Ext.define('EgDefaultReports.view.DefaultReports', {
	extend: 'Ext.form.Panel',
	alias: 'widget.defaultreports',
	cls:'outerpanel',
	frame:true,
	border:true,
	title: defaultReportsTitle,
	margin: '8 8 0 8',
	//frame: true,
	header:{cls:'zonereporthead'},

	requires: [
		'utilities.ScrollCombo',
		'utilities.CustomGrid'
	],

	layout: {
		type: 'vbox',
		align:'stretch'
	},

	items: [
		{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;' + defaultReportsDesc +'</center>',
			width:'100%',
			height: 25,
			padding: 3,
		},
		{
			xtype: 'container',
			cls:'formOuter',
			padding:'10 0 10 0',
			margin: '10 10 0 10',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: catTypeLabel,
					labelAlign: 'left',
					labelSeparator: ' ',
					width: 300,
					margin: '10 0 5 0',
					id: 'categoryType',
					editable: false,
					store: ['Choose category type','Network','System','Application','Site']
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: repTypeLabel,
					labelAlign: 'left',
					labelSeparator: ' ',
					width: 300,
					margin: '10 0 5 20',
					id: 'reportTypeInView',
					editable: false,
					store: ['Choose report type','Measure','Summary']
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: cmpTypeLabel,
					labelAlign: 'left',
					labelSeparator: ' ',
					width: 250,
					margin: '10 0 5 20',
					id: 'selectedCompType',
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : []
					}),
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					editable: false,
					forceSelection: false
				}
			]
		},
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id: 'mainGrid',
			store: new Ext.data.Store({
				fields : ['Test', 'Measures'],
				data : []
			}),
			flex: 1,
			queryMode: 'local',
			autoScroll: false,
			scroll:true,
			//viewConfig: {
			//	deferEmptyText: true
			//},
			margin: 10,
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: '<table align="center"><tr><td align="center" height="250"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">No Data Found.</td></tr></table></td></tr></table>',

			//emptyText: "<table border='0' height='350px' width='100%'><tr><td align=center valign=middle><img src='/final/images/spacer.gif' class='iconInformation'><div class='commonErrorMsgText'>No Data Found</div></td></tr></table>",
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: testText,
						dataIndex: 'Test',
						width: 280
					},
					{
						text: measuresText,
						dataIndex: 'Measures',
						flex: 1,
						sortable: false,
						renderer : function(value) {
							return '<table width="100%" cellspacing="0" cellpadding="0"><tr><td valign="top" style="font-size:8pt;font-family:Tahoma,Calibri,Arial,Helvetica,sans-serif;">'+value+'</td></tr></table>';
						}
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-edit-column-header',
						width: 36,
						//icon: '../../../../resources/images/edit_task.png',
						iconCls: 'iconModify',
						//tooltip: 'Modify',
						sortable: false,
						id: 'updateInView',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 36,
						//icon: '../../../../resources/images/delete.png',
						iconCls: 'iconDelete',
						//tooltip: 'Delete',
						sortable: false,
						id: 'deleteInView',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
						}
					}
				]
			},
			tbar:[
		{
			xtype:'tbfill',
		},{
			xtype:'toolbar',
			ui:'footer',
			items:[
				{
					xtype: 'button',
					cls:'button20',
					text: addNewBtn,
					id: 'addNew'
				},
				{
					xtype: 'button',
					cls:'button20',
					text: addToSummaryBtn,
					id: 'addToSummary',
					disabled: true
				}
			]
		}]
		}
	]

});




