<%
/*******************************************************************************
*		Name			:EgDefaultReportsJSON.jsp
*		Purpose			:JSON page to configure the details required 
						 for default reports
*		Version			:6.0
*		CreationDate	:27/06/2013
*		Author			:Abdul Khader M
*******************************************************************************/
%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgReportInfo" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgThresholdInfo" %>
<%@ page import = "com.eg.EgConfigInfo" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "java.util.*" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.User" %>
<%@ page import = "com.egurkha.UserRegistry" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "com.eg.EgTesterInfo" %>
<%@ page import = "egurkha.ConfigSiteBean" %>
<%@ page import = "net.sf.json.*" %>

<%
	response.setContentType("application/json");
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootJson = new JSONObject();
	JSONObject testExistsJson = new JSONObject();
	JSONObject optionsJson = new JSONObject();
	JSONObject testsJson = new JSONObject();
	JSONObject siteJson = new JSONObject();
	JSONObject summaryJson = new JSONObject();
	JSONObject assocMeasuresJson = new JSONObject();
	JSONObject buttonJson = new JSONObject();
	JSONObject hiddenJson = new JSONObject();
	JSONObject selectedTestJson = new JSONObject();

	JSONArray CompTypeArrayJson = new JSONArray();
	JSONArray reportTypesJson = new JSONArray();
	JSONArray testsArrayJson = new JSONArray();
	JSONArray siteTestsArrayJson = new JSONArray();
	JSONArray descriptorsArrayJson = new JSONArray();
	JSONArray allMeasuresArrayJson = new JSONArray();
	JSONArray assocMeasuresArrayJson = new JSONArray();
	JSONArray disAssocMeasuresArrayJson = new JSONArray();
	JSONArray allRealMeasuresArrayJson = new JSONArray();
	JSONArray assocRealMeasuresArrayJson = new JSONArray();
	JSONArray disAssocRealMeasuresArrayJson = new JSONArray();
	JSONArray assocInfoArrayJson = new JSONArray();
	JSONArray disAssocInfoArrayJson = new JSONArray();
	JSONArray summaryArrayJson = new JSONArray();
	JSONArray applyToSummaryJson = new JSONArray();
	JSONArray enabledTestsArrayJson = new JSONArray();
	JSONArray disabledTestsArrayJson = new JSONArray();

	ConfigSiteBean SiteBean = new ConfigSiteBean();

	if(SiteBean.rcat())
	{
		EgThresholdInfo et = new EgThresholdInfo("manager");
		EgReportInfo rep = new EgReportInfo("manager");
		EgConfigInfo econ= new EgConfigInfo("manager");
		EgDiscInfo ed = new EgDiscInfo("manager");
		EgSpecsInfo espec = new EgSpecsInfo("manager");
		EgTesterInfo testerInfo=new EgTesterInfo("manager");
		String fname = econ.getReportConfigFile();
		IniFile irep = new IniFile(fname);
		IniFile specsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_specs.ini");
		String tests[];
		String dmeasures[];
		String infos[];
		String testName;
		String cattype = "";
		String cattypeT = "";
		String secType ="";
		String graphType = "";
		String serverTests[];
		String colon=":";
		
		ArrayList a_infos = new ArrayList();
		Vector v;
		
		String testinfo = "";
		String testselect="";
		String mselect="";
		String sselect="";
		String serverselect="";
		
		boolean serverlist=false;
		boolean showAllTests = true;
		int tind = 0;
		String serverType="";

		UserRegistry registry1 = UserRegistry.getInstance();
		User user = registry1.getUser(session.getId());
		IniUI iniUI = IniUI.getInstance();
		 
		//user language
		String userLanguage = iniUI.getDefaultLanguage();
		if (user != null)
		{
		 userLanguage = user.getLanguage();
		}
		EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
		MappingNameSorter sorter = new MappingNameSorter(userLanguage);
		EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");

		String previousAssociatedMeasures = null;

		cattype=request.getParameter("catType");
		graphType=request.getParameter("graphType");
		secType =request.getParameter("secType");
		testName = request.getParameter("tname");
		String test_name ="";
		if (testName != null)
		{
			test_name = _mapping.getTestDescription(testName);
		}
		String selIndex = request.getParameter("selIndex");
		serverType = request.getParameter("serverType");
		if(serverType == null || serverType.equals("Select the component"))
		{
			serverType = "";
		}


		if(selIndex != null && !selIndex.equals("null") && !selIndex.equals(""))
		{
			tind = Integer.parseInt(request.getParameter("selIndex"));
		}
		String secTypeI="";
		String cattypeVar = "";

		if(cattype != null)
		{
			if(cattype.indexOf(":")!=-1)
			{
				//&& cattype.startsWith("Application"))
				cattypeVar = cattype.substring(0,cattype.indexOf(":"))+":"+serverType+":"+graphType;//cattype.substring(0,cattype.indexOf(":"));
			}
			else if(cattype.equals("Application"))
			{
				cattypeVar = cattype +":"+serverType+":"+graphType;
			}
			else
			{
				cattypeVar = cattype+":"+graphType;
			}
		}

		//Getting values from and displaying in the category order
		if(secType != null && secType !="")
		secTypeI=secType.toUpperCase()+"_REPORTS";


		Vector avar=new Vector();
		if(cattype != null)
		{
			String var[]=irep.getVariables(secTypeI);
			if(var!=null && var.length!=0)
			{
				for(int i=0;i<var.length;i++)
				{
					//for application category var= Application:<server type>:<graphtype>
					StringTokenizer st = new StringTokenizer(var[i],":");
					if(st.countTokens()>2)
					{
						var[i]=st.nextToken()+":"+st.nextToken()+":"+st.nextToken();
					}
					if(var[i].equals(cattypeVar))//startsWith(cattypeVar))
					{
						avar.addElement(var[i]);
						avar.addElement(irep.getValue(secTypeI,var[i]));
					}
				}
			}//var if
		}//cattype null check
		irep = null;

		if(cattype != null)
		{
			if(cattype.startsWith("Application"))
			{
				serverlist = true;
			}
		}

		session.setAttribute("egPageDesc","EgDefaultReports.jsp");

		String optionvalue = request.getParameter("optvalue");
		if(optionvalue==null)
			optionvalue="upgrade";
		String [] upgradeagents ;
		optionsJson.put("optionvalue",optionvalue);

		// To fetch Category type
		String netselect ="";
		String sysselect ="";
		String appselect ="";
		String siteselect = "";
		if(cattype != null)
		{
			if(cattype.startsWith("Network"))
				netselect = "checked";
			if(cattype.startsWith("System"))
				sysselect = "checked";
			if(cattype.startsWith("Application"))
				appselect = "checked";
			if(cattype.startsWith("Site"))
				siteselect = "checked";
		}

		optionsJson.put("cattype",cattype);
		optionsJson.put("netselect",netselect);
		optionsJson.put("sysselect",sysselect);
		optionsJson.put("appselect",appselect);
		optionsJson.put("siteselect",siteselect);

		// To select the graph type
		if(graphType!=null && graphType!="")
		{
			if(graphType.equals("Measure"))
			{
				mselect="selected";
				sselect="";
			}
			else
			{
				mselect="";
				sselect="selected";
			}
		}

		JSONObject jreportType = new JSONObject();
		jreportType.put("displayField","Measure");
		jreportType.put("valueField","Measure");
		jreportType.put("displayField","Summary");
		jreportType.put("valueField","Summary");
		reportTypesJson.add(jreportType);
		optionsJson.put("mselect",mselect);
		optionsJson.put("sselect",sselect);


		optionsJson.put("serverlist",serverlist);
		optionsJson.put("secType",secType);
		if(serverlist)
		{
			// To select the component
			String appser[] = ed.getServerTypes();
			Vector v_appser = new Vector();
			Vector aggCompTypes = new Vector();
			aggCompTypes = aggregateInfo.getAggregateTypes();
			optionsJson.put("secType",secType);
			optionsJson.put("aggCompTypes",aggCompTypes);
			optionsJson.put("isAggregation",EgInstallInfo.isAggregationSupported());
			for(int i=0;i<appser.length;i++)
			{
				if (!EgInstallInfo.isAggregationSupported() && aggCompTypes.contains(appser[i]))
					continue;

				if(!v_appser.contains(appser[i]))
					v_appser.addElement(appser[i]);
			}
			optionsJson.put("v_appser",v_appser);
			//Collections.sort(v_appser);
			ArrayList serverList = new ArrayList();
			serverList = sorter.getSortedCompTypeList(v_appser);
			optionsJson.put("serverList",serverList);

			for (int j=0;j<serverList.size();j++)
			{
				EgName nameObj = (EgName)serverList.get(j);
				String tmpVal = nameObj.getActualName();	
				String tmpDis = nameObj.getLocalName();	
				if(serverType != null)
				{
					if(serverType.equalsIgnoreCase(tmpVal))
						serverselect = "selected";
					else
						serverselect = "";
				}
				optionsJson.put("tmpVal",tmpVal);
				optionsJson.put("tmpDis",tmpDis);
				optionsJson.put("serverselect",serverselect);
				JSONObject jCompObj = new JSONObject();
				//JSONObject jTestsObjOne = new JSONObject();
				if (j == 0)
				{
					jCompObj.put("valueField","Select the component");
					jCompObj.put("displayField","Select the component");
					CompTypeArrayJson.add(jCompObj);
				}
				jCompObj.put("valueField",tmpVal);
				jCompObj.put("displayField",tmpDis);
				CompTypeArrayJson.add(jCompObj);
			}

				//}//serverlist if
			// Code to select the test
			testsJson.put("serverType",serverType);

			JSONObject jSelectTestsObjOne = new JSONObject();
			jSelectTestsObjOne.put("valueField","Select the test");
			jSelectTestsObjOne.put("displayField","Select the test");
			testsArrayJson.add(jSelectTestsObjOne);
			
			if(!serverType.equals(""))
			{
				//serverTests = espec.getTestsForServer(serverType);
				serverTests = espec.getDefaultTestsForServer(serverType);
				Vector v_serverTests = new Vector();
				String strEnabledTest = specsIni.getValue("TEST_MAPPING",serverType);
				strEnabledTest = "#" + strEnabledTest + "#";
				testsJson.put("strEnabledTest",strEnabledTest);
				testsJson.put("serverTests",serverTests);
				ArrayList aListDisabledTests = new ArrayList();
				if (serverTests != null && serverTests.length > 0)
				{
					for(int st=0;st<serverTests.length;st++)
					{
						if(!serverTests[st].equalsIgnoreCase("WebsiteTest")&&!serverTests[st].equalsIgnoreCase("WebsiteTransactionTest"))
						{
							String strTest = serverTests[st];
							if (strTest.endsWith("_cf"))
							{
								continue;
							}
							String pattern1 = "#" + strTest + ",";
							String pattern2 = "," + strTest + ",";
							String pattern3 = "," + strTest + "#";
							String pattern4 = "#" + strTest + "#";
							if (strEnabledTest.indexOf(pattern1) > -1 || strEnabledTest.indexOf(pattern2) > -1 || 
							strEnabledTest.indexOf(pattern3) > -1 || 
							strEnabledTest.indexOf(pattern4) > -1)
							{
								v_serverTests.addElement(strTest);
								testsJson.put("v_serverTests",v_serverTests);
							}
							else
							{
								aListDisabledTests.add(strTest);
							}
						}
					}
				}
				//remove config tests
				TestBean testBean = new TestBean(true);
				ArrayList configTests = testBean.getAllConfigTests();
				v_serverTests.removeAll(configTests);
				//Collections.sort(v_serverTests);
				List testsList = new ArrayList();
				testsList = sorter.getSortedTestList(v_serverTests);
				testsJson.put("sortedTestsList",testsList);
				aListDisabledTests = sorter.getSortedTestList(aListDisabledTests);
				testsJson.put("sortedDisabledTests",aListDisabledTests);

				//JSONObject jTestsDefault = new JSONObject();
				/*JSONObject jTestsObjOne = new JSONObject();
				jTestsObjOne.put("valueField","Select the test");
				jTestsObjOne.put("displayField","Select the test");
				testsArrayJson.add(jTestsObjOne);*/

				for(int i=0;i<testsList.size();i++)
				{
					EgName nameObj = (EgName)testsList.get(i);
					String tmpVal = nameObj.getActualName();	
					String tmpDis = nameObj.getLocalName();
					//testsJson.put("tmpVal",tmpVal);
					//testsJson.put("tmpDis",tmpDis);
					JSONObject jTestsObjOne = new JSONObject();
					jTestsObjOne.put("valueField",tmpVal);
					jTestsObjOne.put("displayField",tmpDis);
					jTestsObjOne.put("groupField",mappingInfo.getTextDescription("admin.text.Enabled Tests"));
					enabledTestsArrayJson.add(jTestsObjOne);
					testsArrayJson.add(jTestsObjOne);
					if(testName!=null)
					{
						//	String sername =(String)v_serverTests.get(i);
						if(testName.equals(tmpVal))
							testselect = "selected";
						else
							testselect = "";
					}
					testsJson.put("testselect",testselect);
				}//for loop ends here for test

				/*JSONObject jTestsObjTwo = new JSONObject();
				jTestsObjTwo.put("valueField","Select the test");
				jTestsObjTwo.put("displayField","Select the test");
				testsArrayJson.add(jTestsObjTwo);*/

				for (int i=0;i<aListDisabledTests.size();i++)
				{
					EgName nameObj = (EgName)aListDisabledTests.get(i);
					String tmpVal = nameObj.getActualName();
					//testsJson.put("tmpVal_disabledTests",tmpVal);
					String tmpDis = nameObj.getLocalName();
					//testsJson.put("tmpDis_disabledTests",tmpDis);
					JSONObject jTestsObjTwo = new JSONObject();
					jTestsObjTwo.put("valueField",tmpVal);
					jTestsObjTwo.put("displayField",tmpDis);
					jTestsObjTwo.put("groupField",mappingInfo.getTextDescription("admin.text.Disabled Tests"));
					disabledTestsArrayJson.add(jTestsObjTwo);
					testsArrayJson.add(jTestsObjTwo);
					if(testName!=null)
					{
						if(testName.equals(tmpVal))
						{
							testselect = "selected";
						}
						else
						{
							testselect = "";
						}
					}
					testsJson.put("testName_disabledTests",testName);
					testsJson.put("testselect",testselect);
				}
			}//if servertype null		

		}//serverlist if
		else
		{
			//check for service category
			if(cattype != null)
			{
				if(cattype.equals("Site"))
				{
					// To select the test for site category
					String website="",websitetran="";
					if(testName!=null)
					{
						if(testName.equals("WebSiteTest"))
							website = "selected";
						if(testName.equals("WebSiteTransactionTest"))
							websitetran = "selected";
					}
					showAllTests = false;
					if(tind == 1)
						website = "selected";
					if(tind == 2)
						websitetran = "selected";
					siteJson.put("testName",testName);
					siteJson.put("website",website);
					siteJson.put("websitetran",websitetran);
					JSONObject jTestsObjTwo = new JSONObject();
					jTestsObjTwo.put("valueField","Select the test");
					jTestsObjTwo.put("displayField","Select the test");
					JSONObject jTestsObjThree = new JSONObject();
					jTestsObjThree.put("valueField","WebSiteTest");
					jTestsObjThree.put("displayField","Web Site");
					JSONObject jTestsObjFour = new JSONObject();
					jTestsObjFour.put("valueField","WebSiteTransactionTest");
					jTestsObjFour.put("displayField","Web Transactions");
					siteTestsArrayJson.add(jTestsObjTwo);
					siteTestsArrayJson.add(jTestsObjThree);
					siteTestsArrayJson.add(jTestsObjFour);
				}//if service alias site category
			}//cat type null
			if(showAllTests)
			{
				showAllTests = true;
				boolean checked=false;
				//sorting the test in alpha order
				Vector v_alltests = new Vector();
				tests = et.getAllTests();
				tests = espec.getManagedCompTestList(tests);
				siteJson.put("tests",tests);
				for(int tt=0;tt<tests.length;tt++)
					v_alltests.addElement(tests[tt]);
				//remove config tests
				TestBean testBean = new TestBean(true);
				ArrayList configTests = testBean.getAllConfigTests();
				v_alltests.removeAll(configTests);
				ArrayList aListDesktopAgentTestNames = testerInfo.getDesktopAgentTestNames();
				v_alltests.removeAll(aListDesktopAgentTestNames);
				//Collections.sort(v_alltests);
				List testsList2 = new ArrayList();
				testsList2 = sorter.getSortedTestList(v_alltests);
				siteJson.put("sortedtestsList2",testsList2);

				JSONObject jSelectTestsObjOne = new JSONObject();
				jSelectTestsObjOne.put("valueField","Select the test");
				jSelectTestsObjOne.put("displayField","Select the test");
				testsArrayJson.add(jSelectTestsObjOne);

				for(int i=0;i<testsList2.size();i++)
				{
					EgName nameObj = (EgName)testsList2.get(i);
					String tmpVal = nameObj.getActualName();	
					String tmpDis = nameObj.getLocalName();
					//siteJson.put("tmpVal",tmpVal);
					//siteJson.put("tmpDis",tmpDis);
					JSONObject jObjAll = new JSONObject();
					jObjAll.put("valueField",tmpVal);
					jObjAll.put("displayField",tmpDis);
					testsArrayJson.add(jObjAll);
					//	String tn=(String)v_alltests.get(i);
					siteJson.put("testName",testName);
					siteJson.put("isPortRelevantForTest",espec.isPortRelevantForTest(tmpVal));
				}//for loop ends here for test
			}//showAllTests if block
		}//else block of serverlist


		// Code to be added to get the summary for category types
		Hashtable reports = new Hashtable();
		ArrayList aListTests = new ArrayList();
		summaryJson.put("avar",avar);
		if(avar != null && avar.size() != 0)
		{
			for(int j=0;j<avar.size();j=j+2)
			{
				String variable=(String)avar.elementAt(j);
				applyToSummaryJson.add(variable);
				String value=(String)avar.elementAt(j+1);
				applyToSummaryJson.add(value);
				String valueSum=value;
				StringTokenizer dis = new StringTokenizer(value,",");
				value="";
				int valtok = dis.countTokens();
				while(dis.hasMoreTokens())
				{
					//value+=dis.nextToken();
					for(int k=1;k<=valtok;k++)
					{
						// for test
						ArrayList mesList = new ArrayList();
						String temp = (String)dis.nextToken();
						String test = temp.substring(0,temp.indexOf(":"));
						String mes = temp.substring(temp.indexOf(":")+1);
						mes = mappingInfo.getMeasureDescription(test,mes);
						test = mappingInfo.getTestDescription(test);
						if(reports.containsKey(test))
						{
							ArrayList aTemp = (ArrayList)reports.get(test);
							aTemp.add(mes);
							//reports.put(test,aTemp);
						}
						else
						{
							mesList.add(mes);
							reports.put(test,mesList);
							aListTests.add(test);
						}
						// end test
						summaryJson.put("mesList",mesList);
						summaryJson.put("reports",reports);
						summaryJson.put("aListTests",aListTests);

					}// End of for loop
				}

				testinfo = "";
				String type="";
				if(cattype !=null)
				{
					if(serverlist)
					{
						type = mappingInfo.getComponentTypeDescription(serverType)+" "+variable.substring(0,variable.indexOf(":"))+"-"+graphType;
					}
					else
					{
						if(cattype.equals("Site"))
							type = "Service-"+graphType;
						else
							type = cattype +"-"+graphType;
					}
				}
				summaryJson.put("type",type);

				String title ="Following are the selections for "+type+" reports :";
				summaryJson.put("summaryTitle",title);

				//variable = variable.substring(0,variable.lastIndexOf(":"));
				String applyToSummary="";
				String hval="";
				String applink="";
				if(graphType.equalsIgnoreCase("Measure"))
				{
					applyToSummary="Apply To Summary";
					hval="Egdefaultreportsp.jsp?varMeas="+variable+"&applytosum=true"+"&catType="+cattype+"&reportType="+graphType+"secType=Default&servers="+serverType;applink = "<a href='"+hval+"' onMouseOver='appsum.src=imgon8.src' onMouseOut='appsum.src=imgoff8.src'><img src=imgoff8.src border=0 name = appsum ></a>";
				}

				summaryJson.put("applyToSummary",applyToSummary);
				summaryJson.put("title",title);
				if(graphType.equalsIgnoreCase("Measure"))
				{
					/*-----------This code for single and double byte language support------start-------*/
					String addButtonwidth="";

					if(trackerLanguage!=null && (trackerLanguage.equals("en_US") || trackerLanguage.equals("ch_CH") || trackerLanguage.equals("ja_JP") || trackerLanguage.equals("ko_KR")) || trackerLanguage.equals("th_TH") || trackerLanguage.equals("es_ES"))
					{
						addButtonwidth="width:120px;";
					}
					else if(trackerLanguage!=null && (trackerLanguage.equals("fr_FR") || trackerLanguage.equals("de_DE") || trackerLanguage.equals("it_IT") || trackerLanguage.equals("pt_BR")))
					{
						addButtonwidth="width:160px;";
					}
					/*-----------This code for single and double byte language support-----End--------*/
					summaryJson.put("addButtonwidth",addButtonwidth);
					summaryJson.put("hval",hval);
				}

				Collections.sort(aListTests,String.CASE_INSENSITIVE_ORDER);
				summaryJson.put("aListTests",aListTests);
				for (int i=0; i<aListTests.size(); i++)
				{
					JSONObject summaryObj = new JSONObject();
					String testKey = (String)aListTests.get(i);
					ArrayList aListTmp = (ArrayList)reports.get(testKey);
					String strValue = aListTmp.toString();
					strValue = strValue.substring(1,strValue.length()-1);
					String allMeasuresWithComma = "";
					String allMeasures = "";
					StringTokenizer st = new StringTokenizer(strValue,",");
					while (st.hasMoreTokens())
					{
						String aToken = st.nextToken();
						if (aToken != null && aToken.length() > 1)
						{
							allMeasuresWithComma = allMeasuresWithComma + aToken + ",";
						}
					}

					if (allMeasuresWithComma != null && allMeasuresWithComma.trim().length() > 0)
					{
						allMeasures = allMeasuresWithComma.substring(0,allMeasuresWithComma.length()-1);
					}
					if (allMeasures != null && allMeasures.trim().length() > 0)
					{
						summaryJson.put("testKey",testKey);
						summaryObj.put("Test",testKey);
						summaryJson.put("strValue",strValue);
						summaryObj.put("Measures",allMeasures);
						//summaryObj.put("Measures",strValue);
						summaryArrayJson.add(summaryObj);
					}
				}
			}
		}

		avar.removeAllElements();
		boolean testexists=false;
		String cattypeTMI ="";
		if(serverlist)
		{
			if(cattype.indexOf(":")!=-1)
			{
				cattypeTMI = cattype.substring(0,cattype.indexOf(":"))+":"+serverType;
			}
			else
			{
				cattypeTMI = cattype +":"+serverType;//+":"+serverType;
			}
		}
		else
			cattypeTMI = cattype;

		Vector v_test=rep.getTests(cattypeTMI,secTypeI,graphType);
		assocMeasuresJson.put("cattypeTMI",cattypeTMI);
		assocMeasuresJson.put("secTypeI",secTypeI);
		assocMeasuresJson.put("graphType",graphType);
		assocMeasuresJson.put("v_test",v_test);
		assocMeasuresJson.put("testName",testName);
		Vector av_measures = new Vector();
		Vector dv_measures = new Vector();
		//String initname="";
		//Populating associated measures of a selected test
		testExistsJson.put("testexists","false");
		if (v_test != null && !v_test.isEmpty())
		{
			List defaultReortTestList = new ArrayList();
			defaultReortTestList = sorter.getSortedTestList(v_test);
			for(int d=0;d<defaultReortTestList.size();d++)
			{
				EgName nameObj = (EgName)defaultReortTestList.get(d);
				String tmpVal = nameObj.getActualName();	
				String tmpDis = nameObj.getLocalName();

				JSONObject jObjAll = new JSONObject();
				jObjAll.put("valueField",tmpVal);
				jObjAll.put("displayField",tmpDis);
				testsArrayJson.add(jObjAll);
			}
		}

		if(testName!=null && testName !="")
		{
			if(v_test.contains(testName))
			{
				String initname =(String)v_test.elementAt(v_test.indexOf(testName));
				//System.out.println("initname"+initname);
				testexists = true;
				testExistsJson.put("testexists","true");
				//out.println("Test Name : "+initname);
				//populating its asso measures and infos
				av_measures=rep.getMeasures(secTypeI,cattypeTMI,graphType,initname);
				assocMeasuresJson.put("av_measures",av_measures);
				for (int j=0; j < av_measures.size(); j++)
				{
					JSONObject avMeasureObj = new JSONObject();
					String assocMeasString = (String) av_measures.get(j);
					String localName = mappingInfo.getMeasureDescription(testName,assocMeasString);
					if (assocMeasString != null && assocMeasString.trim().length() > 0)
					{
						avMeasureObj.put("displayField",localName);
						avMeasureObj.put("valueField",assocMeasString);
						assocRealMeasuresArrayJson.add(avMeasureObj);
						allRealMeasuresArrayJson.add(avMeasureObj);
					}
				}
			}

			//Populating disassociated measures of a selected test
			dmeasures=et.getMeasurementsForTest(testName);
			if(dmeasures !=null && dmeasures.length > 0)
			{
				for(int j=0;j<dmeasures.length;j++)
				{
					if(!av_measures.contains(dmeasures[j]))
					{
						JSONObject dvMeasureObj = new JSONObject();
						String adMeasure = (String) dmeasures[j];
						String localName = mappingInfo.getMeasureDescription(testName,adMeasure);

						if (adMeasure != null && adMeasure.trim().length() > 0)
						{
							dvMeasureObj.put("displayField",localName);
							dvMeasureObj.put("valueField",adMeasure);
							disAssocRealMeasuresArrayJson.add(adMeasure);
							allRealMeasuresArrayJson.add(dvMeasureObj);
							dv_measures.addElement(dmeasures[j]);
						}
					}
				}
				assocMeasuresJson.put("dv_measures",dv_measures);
			}//dmeasures null check
		}//if testName equals null 
	
		boolean optexist = false;
		//String testNameFin=(String)v_test.elementAt(v_test.indexOf(testName));
		if(av_measures!=null && av_measures.size()!=0)
		{
			for( int i=0;i<av_measures.size();i++)
			{
				/* code for auditlog starts */
				JSONObject assocMeasObj = new JSONObject();
				if(previousAssociatedMeasures==null)
				{
					previousAssociatedMeasures = (String) av_measures.elementAt(i);
					String measureDescription = mappingInfo.getMeasureDescription(testName, (String)av_measures.elementAt(i));
					assocMeasObj.put("displayField",(String) av_measures.elementAt(i));
					assocMeasObj.put("valueField",(String) testName+colon+measureDescription);
					//assocMeasObj.put("valueField",(String) testName+colon+(String)av_measures.elementAt(i));
					assocMeasuresArrayJson.add(assocMeasObj);
					allMeasuresArrayJson.add(assocMeasObj);
				}
				else
				{
					previousAssociatedMeasures += "," + (String) av_measures.elementAt(i);
					assocMeasObj.put("displayField",(String) av_measures.elementAt(i));
					assocMeasObj.put("valueField",(String) av_measures.elementAt(i));
					assocMeasuresArrayJson.add(assocMeasObj);
				}
				/* code for auditlog ends */						
				//System.out.println("av_measures.elementAt(i)"+av_measures.elementAt(i));

				optexist = true;
			}
		}

		if(dv_measures!=null && dv_measures.size()!=0)
		{
			for( int i=0;i<dv_measures.size();i++)
			{
				JSONObject disassocMeasObj = new JSONObject();
				String measureDescription = mappingInfo.getMeasureDescription(testName, (String)dv_measures.elementAt(i));
				//disassocMeasObj.put("displayField",testName+colon+(String)dv_measures.elementAt(i));
				disassocMeasObj.put("displayField",testName+colon+measureDescription);
				disassocMeasObj.put("valueField",dv_measures.elementAt(i));
				disAssocMeasuresArrayJson.add(dv_measures.elementAt(i));
				allMeasuresArrayJson.add(disassocMeasObj);
			}
		}

		// Code added for update and delete button
		buttonJson.put("serverlist",serverlist);
		buttonJson.put("testexists",testexists);
		buttonJson.put("test_name",test_name);
	
		//Getting infos of a selected list fro dbadapter
		EgDbAdapterUI egDb;
		egDb = EgDbAdapterTypeUI.getObject();
		String s_status = "";
		boolean b_status = true;
		try
		{
			s_status = egDb.setConnection();
			if(s_status.equals("CONNECTED"))
			{
				b_status = egDb.getState();
				//getInfosForReports(testname,type or name, comp_type or
				a_infos = egDb.getInfosForReports(testName,"","");
			}
			egDb.releaseConnection(false);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			if(!s_status.equals("CONNECTED"))
			{
				out.println("Could not establish connection");
			}
			else
			{
				if(!b_status)
				{
					out.println("An unknown error occured while fetching");
				}
				egDb.releaseConnection(true);
			}
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		//Vector v_test=rep.getTests(cattype,secTypeI,graphType);
		Vector av_descriptors = new Vector();
		Vector dv_descriptors = new Vector();
		//Populating associated descriptors of a selected test
		if(testName!=null && testName !="")
		{
			if(v_test.contains(testName))
			{
				//cattype = cattype + ":" +serverType;
				String initname =(String)v_test.elementAt(v_test.indexOf(testName));
				av_descriptors=rep.getInfos(secTypeI,cattypeTMI,graphType,initname);
				for (int j=0;j<av_descriptors.size();j++)
				{
					JSONObject avObj = new JSONObject();
					String av_descString = (String) av_descriptors.get(j);
					avObj.put("displayField",av_descString);
					avObj.put("valueField",av_descString);
					assocInfoArrayJson.add(avObj);
				}
			}
			//Populating disassociated descriptors of a selected test
			// ArrayList a_infos have all the related infos for the selected test
			if(a_infos!=null && a_infos.size()>0)
			{
				for(int j=0;j<a_infos.size();j++)
				{
					if(!av_descriptors.contains(a_infos.get(j)))
					{
						JSONObject dvObj = new JSONObject();
						String dv_descString = (String) a_infos.get(j);
						dv_descriptors.addElement(a_infos.get(j));
						dvObj.put("displayField",dv_descString);
						dvObj.put("valueField",dv_descString);
						disAssocInfoArrayJson.add(dvObj);
					}
				}
			}//a_infos null check
		}// checks testName null or blank

		// Code for hidden fields
		hiddenJson.put("secType",secType);
		hiddenJson.put("catType",cattype);
		hiddenJson.put("testName",testName);
		hiddenJson.put("assomOption",optexist);
		hiddenJson.put("previousAssociatedMeasures",previousAssociatedMeasures);

	}
	else
	{
		Vector errors = new Vector();
		errors.addElement(_mapping.getTextDescription("admin.error.Admin Home"));
		errors.addElement("EgAdminOperations.jsp");
		errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
		errors.addElement(_mapping.getTextDescription("admin.error.Your license does not allow you to use this feature")+".");
		errors.addElement(_mapping.getTextDescription("admin.error.Please contact") + " <a href='mailTo:license@eginnovations.com' target='_parent' class='dash_link'><b>license@eginnovations.com</b></a> " + _mapping.getTextDescription("admin.error.for more details")+".");
		session.putValue("vec_Errors", errors);
		//response.sendRedirect("EgErrors.jsp");

	}

	if(request.getQueryString()!=null)
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDefaultReports.jsp?"+request.getQueryString());
	else
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDefaultReports.jsp");

	rootJson.put("optionsJson",optionsJson);
	rootJson.put("testsJson",testsJson);
	rootJson.put("siteJson",siteJson);
	rootJson.put("summaryJson",summaryJson);
	rootJson.put("assocMeasuresJson",assocMeasuresJson);
	rootJson.put("buttonJson",buttonJson);
	rootJson.put("hiddenJson",hiddenJson);
	rootJson.put("reportTypesJson",reportTypesJson);
	rootJson.put("CompTypeArrayJson",CompTypeArrayJson);
	rootJson.put("enabledTestsArrayJson",enabledTestsArrayJson);
	rootJson.put("disabledTestsArrayJson",disabledTestsArrayJson);
	rootJson.put("testsArrayJson",testsArrayJson);
	rootJson.put("siteTestsArrayJson",siteTestsArrayJson);
	rootJson.put("summaryArrayJson",summaryArrayJson);
	rootJson.put("associatedMeasuresJson",assocMeasuresArrayJson);
	rootJson.put("disAssociatedMeasuresJson",disAssocMeasuresArrayJson);
	rootJson.put("allMeasuresArrayJson",allMeasuresArrayJson);
	rootJson.put("applyToSummaryJson",applyToSummaryJson);
	rootJson.put("testExistsJson",testExistsJson);

	rootJson.put("allRealMeasuresArrayJson",allRealMeasuresArrayJson);
	rootJson.put("assocRealMeasuresArrayJson",assocRealMeasuresArrayJson);
	rootJson.put("disAssocRealMeasuresArrayJson",disAssocRealMeasuresArrayJson);
	rootJson.put("assocInfoArrayJson",assocInfoArrayJson);
	rootJson.put("disAssocInfoArrayJson",disAssocInfoArrayJson);

	out.println(rootJson);
%>



