<!DOCTYPE html>

<%@ include file="EgTrackerA.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgInstallInfo"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String fromWizard = request.getParameter("fromWizard");
	if(com.egurkha.util.StringUtils.isNull(fromWizard))
	{
		fromWizard = "";
	}

	IniFile inifile = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	String managerModel = inifile.getValue("MISC_ARGS","eGMgrModel");
	managerModel=(managerModel !=null && managerModel.equalsIgnoreCase("msp"))?"msp":"ent";
	String alertType = "1";
	String deleteComponents = "no";
	if(managerModel.equals("msp"))
	{
		String allowDeleteOrg = inifile.getValue("MISC_ARGS","AllowDeleteOrg");
		if(allowDeleteOrg != null && (allowDeleteOrg.equalsIgnoreCase("true") || allowDeleteOrg.equalsIgnoreCase("yes")))
		{
			alertType = "2";
			deleteComponents="yes";
		}
	}
	else
	{
		String deleteSubOU = inifile.getValue("MISC_ARGS","DeleteSubOU");
		if(deleteSubOU != null && (deleteSubOU.equalsIgnoreCase("true") || deleteSubOU.equalsIgnoreCase("yes")))
		{
			alertType = "2";
			deleteComponents="yes";
		}
	}
%>

<html>
<head>
	<meta charset="utf-8">

	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	<script language="JavaScript1.2">
		var csrfToken = '<%=strCsrfToken%>';
		var pageTitle = '<egui:intnl text="admin.title.Delete Users"/>';
		var pageDescc = '<egui:intnl description="EgDeleteUser.jsp"/>';
		var deleteAll = "<%=deleteComponents%>";
		var processingLabel = '<egui:intnl text="admin.common.Processing" />...';
		var select_users = '<egui:intnl text="admin.user.No user name selected"/>';
		var no_users_found_category = '<egui:intnl text="admin.user.No user(s) found for the selected user account type"/>.';
		var confirmation_common1 = '<egui:intnl text="admin.user.Are you sure you want to delete the selected user account"/>?';
		var confirmation_common2 = '<egui:intnl text="admin.user.Are you sure you want to delete the selected user accounts"/>?';
		var confirmation_common3 = '<egui:intnl text="admin.user.Are you sure you want to delete the selected user account and the infrastructure elements"/>?';
		var confirmation_common4 = '<egui:intnl text="admin.user.Are you sure you want to delete the selected user accounts and their infrastructure elements"/>?';
		var confirmationLabel = '<egui:intnl text="admin.user.CONFIRMATION"/>';
		var no_users_conf = '<egui:intnl text="admin.user.No users have been configured"/>';
		var fieldsettitle1='<egui:intnl text="admin.user.Delete User Accounts"/>';
		var fieldsettitle2='<egui:intnl text="admin.user.Delete Users Accounts And Associated Infrastructure Elements"/>';
		var deletebutton='<egui:intnl text="admin.common.Delete"/>';
		var user_types_label = '<egui:intnl text="admin.common.User account type"/>';
		var allUsersLabel = '<egui:intnl text="admin.common.All user accounts"/>';
		var liveUsersLabel = '<egui:intnl text="admin.common.Active user accounts"/>';
		var expiredUsersLabel = '<egui:intnl text="admin.common.Expired user accounts"/>';
		var selectTxt = '<egui:intnl text="admin.common.Select all"/>';
		var deSelectTxt = '<egui:intnl text="admin.common.Deselect all"/>';
		var manager_model='<%=managerModel%>';
		var alert_type='<%=alertType%>';
		var selectedUsersCount=0;
		var searchLbl = '<egui:intnl text="admin.title.Search user accounts"/>';
		var noUserSearchAlert = '<egui:intnl text="admin.common.No user accounts found for your current search"/>';
		var LoadSearchAlert = '<table border="0" width="100%" height="400px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noCompAlrtDiv">'+noUserSearchAlert+'</div></td></tr></table>';
		var noUserAlert = '<egui:intnl text="admin.common.No user accounts found for the current category"/>';
		var LoadAlert = '<table border="0" width="100%" height="400px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noCompAlrtDiv">'+noUserAlert+'</div></td></tr></table>';

		var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>';
		var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>';
		var errorTitle = '<egui:intnl text="admin.user.Error"/>';
		var deletedMessage = '<egui:intnl text="admin.common.User(s) deleted successfully"/>';
		var currentSelection='';
		var currentusers = null;

	</script>

	<!-- Application folder -->
	<script type="text/javascript" src="DeleteUsers/app/app.js"></script>
	<egui:skin ui="admin"/>

	<script language="javascript">

	// wizard design starts...
	var fromWizard = '<%=fromWizard%>';
	var homeTitle = '<div>'+pageTitle+' <img src="/final/images/spacer.gif" id="homeTitle" class="iconInfoCircle" style="vertical-align:text-top;position:relative;top:2px"/></div>';


	// wizard design ends..	


		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut+'.',
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						console.log(response.responseText);
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage+'.',
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>


</head>

<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</body>
</html>

<%
	if(com.egurkha.util.StringUtils.isNull(fromWizard))
	{
		if(request.getQueryString()!=null)
		{
			session.setAttribute("adminLastAccessedURL","/final/admin/EgDeleteUser.jsp?"+request.getQueryString());
		}
		else
		{
			session.setAttribute("adminLastAccessedURL","/final/admin/EgDeleteUser.jsp");
		}
	}
%>



