Ext.require('Ext.data.SortTypes'); 
Ext.define('EgDispUserSites.controller.Main',{
	extend:'Ext.app.Controller',
	views:[	'Main',
			'UserDetailsGrid',
			'ResultPanel',
			'LoginResultPanel'
	],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'main #userSearch', ref:'searchBoxField'},
		{selector:'userdetailsgrid', ref:'userdetailsgrid'},
		{selector:'loginresultpanel', ref:'loginresultpanel'}
	],
	init:function(){
		appCnt = this;
		this.buildMainData();
		this.control({
			'main':
			{
				'afterrender': this.afterMainRender
			},
			'main combo[id="category"]':
			{
				'select':this.selectOnChange
			},
			'main combo[id="searchCategory"]':
			{
				'select':this.searchCategoryChange
			},
			'userdetailsgrid button[id="blockDomain"]':
			{
				'click':this.showBlockDomainWin
			},
			'main trigger[id="userSearch"]':
			{
				'change':this.getAvaibleUsers
			},
			'main button[id="backButton"]':
			{
				'click':this.goBack
			},
			'main button[id="csv"]':
			{
				'click': this.saveInCSVFormat
			},
			'userdetailsgrid': 
			{
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
		});
	},
	saveInCSVFormat : function()
	{
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+trackerLanguage;
	},
	buildMainData : function()
	{
		var sformattedValue = "";
		var eformattedValue = "";
		var defaultUrl = 'EgDispUserSites/data/EgDispUserSitesJson.jsp?expiry='+selectedCategory+'&date='+new Date().getTime();
		if (selectedCategory != null && selectedCategory == "nonactiveusers")
		{
			urlStr = '/final/servlet/com.eg.AuditServletExtJS?eg_timeline=1 month&jsppage=logons&reqfrom=navlink';

			Ext.Ajax.request({
				url : urlStr,
				method: 'POST',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					var eg_stdate = publicJSON['defaults']["eg_stdate"];
					var starthr = publicJSON['defaults']["starthr"];
					var startmin = publicJSON['defaults']["startmin"];
					var eg_enddate = publicJSON['defaults']["eg_enddate"];
					var endhr = publicJSON['defaults']["endhr"];
					var endmin = publicJSON['defaults']["endmin"];
					var strtdt = new Date(eg_stdate);
					var enddt = new Date(eg_enddate);

					sformattedValue = Ext.Date.format(strtdt, 'm/d/Y')+ ' ' + starthr + ':'+ startmin + ':00';
					eformattedValue = Ext.Date.format(enddt, 'm/d/Y') + ' ' + endhr + ':'+ endmin + ':00';

					defaultUrl = defaultUrl + "&startDate="+encodeURIComponent(sformattedValue)+"&endDate="+encodeURIComponent(eformattedValue);
				}
			});
		}
		Ext.Ajax.request({
			url : defaultUrl,
			method: 'POST',
			async : false,
			success: function(response)
			{
				publicJSON = Ext.decode(response.responseText);
			},
			failure : function(response)
			{
			}
		});
	},
	getAvaibleUsers : function(obj)
	{
		this.fetchUsers(obj.getValue());
	},

	searchCategoryChange : function()
	{
		Ext.getCmp('userdetailsgrid').getStore().clearFilter();
		var searchCategory = Ext.getCmp('searchCategory').getValue();
		Ext.getCmp('userSearch').emptyText = 'Search '+searchCategory;
		Ext.getCmp('userSearch').applyEmptyText();
		Ext.getCmp('userSearch').reset();
	},

	fetchUsers : function(value)
	{
		if (value == "" || value.length == 0)
		{
			Ext.get('MyTrigger_userSearch_0').setStyle('display','none');
			Ext.get('MyTrigger_userSearch_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_userSearch_1').setStyle('display','none');
			Ext.get('MyTrigger_userSearch_0').setStyle('display','block');
		}

		var selectedType = Ext.getCmp('category').getValue();
		var strUrl = '';
		var userdetailsgrid = Ext.getCmp('userdetailsgrid');
		if (value == "" || value.length == 0)
		{
			userdetailsgrid.getStore().clearFilter();
		}
		else
		{
			var searchCategory = Ext.getCmp('searchCategory').getValue();
			searchCategory = searchCategory.replace(' ', '');
			userdetailsgrid.getStore().clearFilter();
			//userdetailsgrid.getStore().filter("UserName",value);
			var userFilter = new Ext.util.Filter({
				filterFn: function(item) {
					if (searchCategory == "CSIDownloaded")
					{
						searchCategory = "AgentDownloaded";
					}
					var itemValue = item.get(searchCategory);
					if (searchCategory == 'RegistrationDate' || searchCategory == 'ExpiryDate')
					{
						if (!Ext.isEmpty(itemValue))
						{
							var date = '';
							if (searchCategory == 'RegistrationDate')
							{
								date = Ext.String.format('{0} {1}', Ext.Date.dateFormat(itemValue, extjsDateFormat+'|'), item.get(searchCategory));
							}
							else
							{
								date = Ext.String.format('{0} {1}', Ext.Date.dateFormat(itemValue, extjsExpiryDateFormat+'|'), item.get(searchCategory));
							}
							itemValue = date.substring(0,date.indexOf('|'));
							if (searchCategory == 'ExpiryDate')
							{
								if (itemValue == 'Dec 12, 9999')
								{
									itemValue = 'No expiry';
								}
							}
						}
						else
						{
							if (searchCategory == 'RegistrationDate')
							{
								itemValue = 'Not Available';
							}
							else
							{
								itemValue = 'No expiry';
							}
						}
					}
					if (searchCategory == 'Email')
					{
						if (item.get('To').toLowerCase().indexOf(value.toLowerCase()) != -1 || item.get('Cc').toLowerCase().indexOf(value.toLowerCase()) != -1 || item.get('Bcc').toLowerCase().indexOf(value.toLowerCase()) != -1)
						{
							return true;
						}
					}
					else if (searchCategory == 'UserElements')
					{
						if (item.get("isElementsAssociated") == true)
						{
							if (item.get("hasallcompaccess") != true)
							{
								var comp = '';
								if (item.get("Zones") != 'no zones')
								{
									comp += item.get('Zones');
								}
								if (item.get("ServiceGroups") != 'no service groups')
								{
									comp += item.get('ServiceGroups');
								}
								if (item.get("Services") != 'no services')
								{
									comp += item.get('Services');
								}
								if (item.get("Segments") != 'no segments')
								{
									comp += item.get('Segments');
								}
								if (item.get("Components") != 'no components')
								{
									comp += item.get('ComponentName');
									comp += item.get('ComponentsType');
								}
								if (item.get("UserVms") != 'no vms')
								{
									comp += item.get('UserVms');
								}
								if (item.get("hasAutoAsscociatedComponents") != false)
								{
									comp += item.get('Auto');
								}
								if (!Ext.isEmpty(comp))
								{
									if ((comp.toLowerCase()).indexOf(value.toLowerCase()) != -1)
									{
										return true;
									}
								}
							}
						}
					}
					else
					{
						if (itemValue.toLowerCase().indexOf(value.toLowerCase()) != -1)
						{
							return true;
						}
					}
				}
			});
			userdetailsgrid.getStore().filter(userFilter);
		}

		if (userdetailsgrid.getStore().getCount() == 0)
		{
			Ext.get('userDeferMessage').update(intnlMessage10+".");
		}
		this.getMain().doLayout();
	},
	
	selectOnChange : function(obj)
	{
		var me = this;
		var selectedValue = obj.getValue();
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		var sformattedValue = "";
		var eformattedValue = "";
		var defaultUrl = 'EgDispUserSites/data/EgDispUserSitesJson.jsp?expiry='+selectedValue+'&date='+new Date().getTime();
		if (selectedValue != null && selectedValue == "nonactiveusers")
		{
			urlStr = '/final/servlet/com.eg.AuditServletExtJS?eg_timeline=1 month&jsppage=logons&reqfrom=navlink';

			Ext.Ajax.request({
				url : urlStr,
				method: 'POST',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					var eg_stdate = publicJSON['defaults']["eg_stdate"];
					var starthr = publicJSON['defaults']["starthr"];
					var startmin = publicJSON['defaults']["startmin"];
					var eg_enddate = publicJSON['defaults']["eg_enddate"];
					var endhr = publicJSON['defaults']["endhr"];
					var endmin = publicJSON['defaults']["endmin"];
					var strtdt = new Date(eg_stdate);
					var enddt = new Date(eg_enddate);

					sformattedValue = Ext.Date.format(strtdt, 'm/d/Y')+ ' ' + starthr + ':'+ startmin + ':00';
					eformattedValue = Ext.Date.format(enddt, 'm/d/Y') + ' ' + endhr + ':'+ endmin + ':00';

					defaultUrl = defaultUrl + "&startDate="+encodeURIComponent(sformattedValue)+"&endDate="+encodeURIComponent(eformattedValue);
				}
			});
		}
		Ext.Ajax.request({
			url : defaultUrl,
			method: 'POST',
			success: function(response)
			{
				publicJSON = Ext.decode(response.responseText);
				me.getUserdetailsgrid().setTitle('<span class="font_bold">'+Ext.getCmp('category').getDisplayValue()+'</span>');
				
				if (!Ext.isEmpty(publicJSON.UserInfo))
				{
					var gridpanel = Ext.widget('userdetailsgrid',{
						store:new Ext.data.Store({
							fields: [{name: 'UserName', sortType:Ext.data.SortTypes.asUCString},
								{name: 'FirstName', sortType:Ext.data.SortTypes.asUCString},
								{name: 'LastName', sortType:Ext.data.SortTypes.asUCString},
								'PhoneNumber',
								{name: 'Company', sortType:Ext.data.SortTypes.asUCString},
								'TimeZone','Role','DateFormat',
								{name: 'RegistrationDate', type: 'date', dateFormat: extjsDateFormat},
								{name: 'ExpiryDate', type: 'date', dateFormat: extjsExpiryDateFormat},
								'Email','To','Cc','Bcc','AgentDownloaded','AgentInstalled',
								'Action','isElementsAssociated','Auto','UserVms','ComponentsType','Components','Segments','Services','ServiceGroups','Zones','hasallcompaccess','hasAutoAsscociatedComponents','ServersForDeletion','BlockedUser','LastLoginTime','ComponentName'],
							data: publicJSON.UserInfo,
							proxy: {
								type: "pagingmemory",
								reader: {
									type: "json"
								}
							},
							remoteFilter : true,
							remoteSort: true,
							autoLoad: true,
							pageSize : 50,
							simpleSortMode: true
						}),
						viewConfig: {
							forceFit: true,
							stripeRows : true
						},
						sortOnLoad: true,
						sortInfo: {
							property: 'RegistrationDate',
							direction: 'DESC'
						}
					});
					var resultPanelObj = Ext.getCmp('loginresultpanel_in_formitem');
					resultPanelObj.show();
					resultPanelObj.removeAll();
					resultPanelObj.removeCls('dataPanel');
					resultPanelObj.add(gridpanel);

					var userSearchObj = Ext.getCmp('userSearch');
					if (!Ext.isEmpty(userSearchObj))
					{
						me.getSearchBoxField().setDisabled(false);
						var searchValue = userSearchObj.getValue();
						if (!Ext.isEmpty(searchValue))
						{
							appCnt.fetchUsers(searchValue);
						}
					}
					//document.getElementById('userSearch-inputEl').value = "";
					//me.getSearchBoxField().setDisabled(false);
					Ext.getCmp("csv").setDisabled(false);

					Ext.getCmp('searchCategory').getStore().loadRawData(publicJSON['searchArr']);
					Ext.getCmp('searchCategory').setValue(Ext.getCmp('searchCategory').getStore().getAt(0));
					Ext.getCmp('userSearch').emptyText = 'Search '+Ext.getCmp('searchCategory').getValue();
					Ext.getCmp('userSearch').applyEmptyText();
					Ext.getCmp('searchCategory').enable();
					Ext.getCmp('userSearch').enable();
				}
				else
				{
					var gridpanel = Ext.widget('userdetailsgrid',{
						store:new Ext.data.Store({
							fields: [{name: 'UserName', sortType:Ext.data.SortTypes.asUCString},
								{name: 'FirstName', sortType:Ext.data.SortTypes.asUCString},
								{name: 'LastName', sortType:Ext.data.SortTypes.asUCString},
								'PhoneNumber',
								{name: 'Company', sortType:Ext.data.SortTypes.asUCString},
								'TimeZone','Role','DateFormat',
								{name: 'RegistrationDate', type: 'date', dateFormat: extjsDateFormat},
								{name: 'ExpiryDate', type: 'date', dateFormat: extjsExpiryDateFormat},
								'Email','To','Cc','Bcc','AgentDownloaded','AgentInstalled',
								'Action','isElementsAssociated','Auto','UserVms','ComponentsType','Components','Segments','Services','ServiceGroups','Zones','hasallcompaccess','hasAutoAsscociatedComponents','ServersForDeletion','BlockedUser','LastLoginTime','ComponentName'],
							data: [],
							proxy: {
								type: "pagingmemory",
								reader: {
									type: "json"
								}
							},
							remoteFilter : true,
							remoteSort: true,
							autoLoad: true,
							pageSize : 50,
							simpleSortMode: true
						}),
						viewConfig: {
							forceFit: true,
							stripeRows : true
						},
						sortOnLoad: true,
						sorters: [{
							property: 'RegistrationDate',
							direction: 'DESC'
						}]
					});
					var resultPanelObj = Ext.getCmp('loginresultpanel_in_formitem');
					resultPanelObj.show();
					resultPanelObj.removeAll();
					resultPanelObj.removeCls('dataPanel');
					resultPanelObj.add(gridpanel);

					me.getUserdetailsgrid().getStore().loadRawData(publicJSON.UserInfo);
					me.getUserdetailsgrid().emptyText = intnlMessage11+".";

					Ext.getCmp("csv").setDisabled(true);

					Ext.getCmp('searchCategory').getStore().loadRawData(publicJSON['searchArr']);
					Ext.getCmp('searchCategory').setValue(Ext.getCmp('searchCategory').getStore().getAt(0));
					Ext.getCmp('userSearch').emptyText = 'Search '+Ext.getCmp('searchCategory').getValue();
					Ext.getCmp('userSearch').applyEmptyText();
					Ext.getCmp('searchCategory').disable();
					Ext.getCmp('userSearch').disable();
				}
				myMask.hide();
				me.getMain().doLayout();


				if (selectedValue != null && (selectedValue == 'logonsimulatorusers' || selectedValue == 'logonsimulatoregusers' || selectedValue == 'nonactiveusers' || selectedValue == 'cloudusers'))
				{
					Ext.getCmp('fname').setVisible(true);
					Ext.getCmp('lname').setVisible(true);
					Ext.getCmp('phoneno').setVisible(true);
					Ext.getCmp('comp').setVisible(true);
					Ext.getCmp('ModifyOver').setVisible(true);
					Ext.getCmp('DeleteOver').setVisible(true);
					Ext.getCmp('blockUsers').setVisible(true);
					//Ext.getCmp('compSearch').setVisible(true);

					Ext.getCmp('dateFormat').setVisible(false);
					Ext.getCmp('userRole').setVisible(false);
					Ext.getCmp('expiry').setVisible(true);
					Ext.getCmp('RegistrationDate').setVisible(true);
					Ext.getCmp('registerUser').setVisible(false);
					Ext.getCmp('mailid').setVisible(false);

					if (selectedValue == 'nonactiveusers')
					{
						Ext.getCmp('LastLoginTime').setVisible(true);
					}
					else
					{
						Ext.getCmp('LastLoginTime').setVisible(false);
					}

					if (selectedValue == 'cloudusers')
					{
						Ext.getCmp('agentdownload').setVisible(true);
						if (cloudModel != null && cloudModel.toLowerCase() == 'phoenix')
						{
							Ext.getCmp('agentinstalled').setVisible(true);
						}
						else
						{
							Ext.getCmp('agentinstalled').setVisible(false);
						}
					}
					else
					{
						Ext.getCmp('agentdownload').setVisible(false);
						Ext.getCmp('agentinstalled').setVisible(false);
					}
				}
				else if (selectedValue != null && (selectedValue == 'logonsimulatorregusers' || selectedValue == 'cloudregusers'))
				{
					Ext.getCmp('fname').setVisible(true);
					Ext.getCmp('lname').setVisible(true);
					Ext.getCmp('phoneno').setVisible(true);
					Ext.getCmp('comp').setVisible(true);
					Ext.getCmp('ModifyOver').setVisible(false);
					Ext.getCmp('DeleteOver').setVisible(true);
					Ext.getCmp('blockUsers').setVisible(false);
					Ext.getCmp('dateFormat').setVisible(false);
					Ext.getCmp('userRole').setVisible(false);
					Ext.getCmp('expiry').setVisible(false);
					Ext.getCmp('LastLoginTime').setVisible(false);
					Ext.getCmp('RegistrationDate').setVisible(false);
					Ext.getCmp('registerUser').setVisible(true);
					Ext.getCmp('mailid').setVisible(false);
					Ext.getCmp('agentdownload').setVisible(false);
					Ext.getCmp('agentinstalled').setVisible(false);
				}
				else
				{
					Ext.getCmp('fname').setVisible(false);
					Ext.getCmp('lname').setVisible(false);
					Ext.getCmp('phoneno').setVisible(false);
					Ext.getCmp('comp').setVisible(false);
					Ext.getCmp('ModifyOver').setVisible(true);
					Ext.getCmp('DeleteOver').setVisible(false);
					Ext.getCmp('blockUsers').setVisible(true);
					Ext.getCmp('LastLoginTime').setVisible(false);

					Ext.getCmp('dateFormat').setVisible(true);
					Ext.getCmp('userRole').setVisible(true);
					Ext.getCmp('expiry').setVisible(true);
					Ext.getCmp('RegistrationDate').setVisible(true);
					Ext.getCmp('registerUser').setVisible(false);
					Ext.getCmp('agentdownload').setVisible(false);
					Ext.getCmp('agentinstalled').setVisible(false);
				}
				me.getUserdetailsgrid().setTitle('<span class="font_bold">'+Ext.getCmp('category').getDisplayValue()+'</span>');
				if (selectedValue != null && (selectedValue == 'logonsimulatorusers' || selectedValue == 'logonsimulatoregusers' || selectedValue == 'nonactiveusers' || selectedValue == 'cloudusers'))
				{
					//me.doSorting("DESC");
					me.getUserdetailsgrid().columns[findColumnIndex(me.getUserdetailsgrid().columns, 'RegistrationDate')].setSortState('DESC');
					if (selectedValue == 'logonsimulatorusers')
					{
						Ext.getCmp('blockDomain').show();
					}
					else
					{
						Ext.getCmp('blockDomain').hide();
					}
				}
				else
				{
					 Ext.getCmp('RegistrationDate').removeCls("x-column-header-sort-DESC");
					 Ext.getCmp('blockDomain').hide();
				}
			},
			failure : function(response)
			{
				myMask.hide();
			}
		});
	},
	showActions: function(view, task, node, rowIndex, e) {
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			//Ext.get(icon).removeCls('x-hidden');
		});
	},
	hideActions: function(view, task, node, rowIndex, e) {
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			//Ext.get(icon).addCls('x-hidden');
		});
	},
	goBack : function()
	{
		window.location.href = backHref;
	},
	afterMainRender : function()
	{
		var me = this;
		if (reqfrom != 'navlink')
		{
			Ext.getCmp('backButton').show();
		}

		if (!Ext.isEmpty(publicJSON.UserInfo))
		{
			Ext.getCmp('userCombo').show();
			Ext.getCmp('category').getStore().loadRawData(publicJSON.optionsArr);
			Ext.getCmp('category').setValue(selectedCategory);
			
			var gridpanel = Ext.widget('userdetailsgrid',{
				store:new Ext.data.Store({
					fields: [{name: 'UserName', sortType:Ext.data.SortTypes.asUCString},
						{name: 'FirstName', sortType:Ext.data.SortTypes.asUCString},
						{name: 'LastName', sortType:Ext.data.SortTypes.asUCString},
						'PhoneNumber',
						{name: 'Company', sortType:Ext.data.SortTypes.asUCString},
						'TimeZone','Role','DateFormat',
						{name: 'RegistrationDate', type: 'date', dateFormat: extjsDateFormat},
						{name: 'ExpiryDate', type: 'date', dateFormat: extjsExpiryDateFormat},
						'Email','To','Cc','Bcc','AgentDownloaded','AgentInstalled',
						'Action','isElementsAssociated','Auto','UserVms','ComponentsType','Components','Segments','Services','ServiceGroups','Zones','hasallcompaccess','hasAutoAsscociatedComponents','ServersForDeletion','BlockedUser','LastLoginTime','ComponentName'],
					data: publicJSON.UserInfo,
					proxy: {
						type: "pagingmemory",
						reader: {
							type: "json"
						}
					},
					remoteFilter : true,
					remoteSort: true,
					autoLoad: true,
					pageSize : 50,
					simpleSortMode: true
				}),
				viewConfig: {
					forceFit: true,
					stripeRows : true
				},
				sortOnLoad: true,
				sorters: [{
					property: 'RegistrationDate',
					direction: 'DESC'
				}]
			});
			var resultPanelObj = Ext.getCmp('loginresultpanel_in_formitem');
			resultPanelObj.show();
			resultPanelObj.removeAll();
			resultPanelObj.removeCls('dataPanel');
			resultPanelObj.add(gridpanel);

			var gridColums = publicJSON['gridColums'];
			var userdetailsgridObj = Ext.getCmp('userdetailsgrid');

			//userdetailsgridObj.getStore().loadRawData(publicJSON.UserInfo);
			var i = 1;
			for (var key in gridColums)
			{
				userdetailsgridObj.columns[i++].setText(gridColums[key]);
			}
			//Ext.getCmp('searchCt').show();
			userdetailsgridObj.setTitle('<span class="font_bold">'+Ext.getCmp('category').getDisplayValue()+'</span>');
		
			var userSearchObj = Ext.getCmp('userSearch');
			if (!Ext.isEmpty(userSearchObj))
			{
				me.getSearchBoxField().setDisabled(false);
				var searchValue = userSearchObj.getValue();
				if (!Ext.isEmpty(searchValue))
				{
					appCnt.fetchUsers(searchValue);
				}
			}

			Ext.getCmp("csv").setDisabled(false);

			Ext.getCmp('searchCategory').getStore().loadRawData(publicJSON['searchArr']);
			Ext.getCmp('searchCategory').setValue(Ext.getCmp('searchCategory').getStore().getAt(0));
			Ext.getCmp('userSearch').emptyText = 'Search '+Ext.getCmp('searchCategory').getValue();
			Ext.getCmp('userSearch').applyEmptyText();
			Ext.getCmp('searchCategory').enable();
			Ext.getCmp('userSearch').enable();
		}
		else
		{
			var gridpanel = Ext.widget('userdetailsgrid',{
				store:new Ext.data.Store({
					fields: [{name: 'UserName', sortType:Ext.data.SortTypes.asUCString},
						{name: 'FirstName', sortType:Ext.data.SortTypes.asUCString},
						{name: 'LastName', sortType:Ext.data.SortTypes.asUCString},
						'PhoneNumber',
						{name: 'Company', sortType:Ext.data.SortTypes.asUCString},
						'TimeZone','Role','DateFormat',
						{name: 'RegistrationDate', type: 'date', dateFormat: extjsDateFormat},
						{name: 'ExpiryDate', type: 'date', dateFormat: extjsExpiryDateFormat},
						'Email','To','Cc','Bcc','AgentDownloaded','AgentInstalled',
						'Action','isElementsAssociated','Auto','UserVms','ComponentsType','Components','Segments','Services','ServiceGroups','Zones','hasallcompaccess','hasAutoAsscociatedComponents','ServersForDeletion','BlockedUser','LastLoginTime','ComponentName'],
					data: [],
					proxy: {
						type: "pagingmemory",
						reader: {
							type: "json"
						}
					},
					remoteFilter : true,
					remoteSort: true,
					autoLoad: true,
					pageSize : 50,
					simpleSortMode: true
				}),
				viewConfig: {
					forceFit: true,
					stripeRows : true
				},
				sortOnLoad: true,
				sorters: [{
					property: 'RegistrationDate',
					direction: 'DESC'
				}]
			});
			var resultPanelObj = Ext.getCmp('loginresultpanel_in_formitem');
			resultPanelObj.show();
			resultPanelObj.removeAll();
			resultPanelObj.removeCls('dataPanel');
			resultPanelObj.add(gridpanel);

			if (selectedCategory == "all")
			{
				Ext.getCmp('loginresultpanel_in_formitem').hide();
				Ext.getCmp('userdetailsgrid').hide();
				Ext.getCmp('userCombo').hide();
				var resultObj = Ext.getCmp('resultpanel');
				resultObj.show();
				resultObj.removeAll();
				var tmpMessage = {
					xtype:'component',
					padding:180,
					style:{'text-align':'center'},
					html:'<div class = "iconInformation" style="margin:0 auto"></div><div class="commonErrorMsgText">'+intnlMessage12+"</div>"
				}
				resultObj.add(tmpMessage);
			}
			else
			{
				Ext.getCmp('category').getStore().loadRawData(publicJSON.optionsArr);
				Ext.getCmp('category').setValue(selectedCategory);

				me.getUserdetailsgrid().setTitle('<span class="font_bold">'+Ext.getCmp('category').getDisplayValue()+'</span>');
				me.getUserdetailsgrid().getStore().loadRawData(publicJSON.UserInfo);
				me.getUserdetailsgrid().emptyText = intnlMessage11;
				Ext.getCmp('userCombo').show();
			}

			Ext.getCmp("csv").setDisabled(true);

			Ext.getCmp('searchCategory').getStore().loadRawData(publicJSON['searchArr']);
			Ext.getCmp('searchCategory').setValue(Ext.getCmp('searchCategory').getStore().getAt(0));
			Ext.getCmp('userSearch').emptyText = 'Search '+Ext.getCmp('searchCategory').getValue();
			Ext.getCmp('userSearch').applyEmptyText();
			Ext.getCmp('searchCategory').disable();
			Ext.getCmp('userSearch').disable();
		}

		if (selectedCategory != null && (selectedCategory == 'logonsimulatorusers' || selectedCategory == 'logonsimulatoregusers' || selectedCategory == 'nonactiveusers' || selectedCategory == 'cloudusers'))
		{
			Ext.getCmp('fname').setVisible(true);
			Ext.getCmp('lname').setVisible(true);
			Ext.getCmp('phoneno').setVisible(true);
			Ext.getCmp('comp').setVisible(true);
			Ext.getCmp('ModifyOver').setVisible(true);
			Ext.getCmp('DeleteOver').setVisible(true);
			Ext.getCmp('blockUsers').setVisible(true);

			Ext.getCmp('dateFormat').setVisible(false);
			Ext.getCmp('userRole').setVisible(false);
			Ext.getCmp('expiry').setVisible(true);
			Ext.getCmp('RegistrationDate').setVisible(true);
			Ext.getCmp('registerUser').setVisible(false);
			Ext.getCmp('mailid').setVisible(false);

			if (selectedCategory == 'nonactiveusers')
			{
				Ext.getCmp('LastLoginTime').setVisible(true);
			}
			else
			{
				Ext.getCmp('LastLoginTime').setVisible(false);
			}

			if (selectedCategory == 'cloudusers')
			{
				Ext.getCmp('agentdownload').setVisible(true);
				if (cloudModel != null && cloudModel.toLowerCase() == 'phoenix')
				{
					Ext.getCmp('agentinstalled').setVisible(true);
				}
				else
				{
					Ext.getCmp('agentinstalled').setVisible(false);
				}
			}
			else
			{
				Ext.getCmp('agentdownload').setVisible(false);
				Ext.getCmp('agentinstalled').setVisible(false);
			}
		}
		else if (selectedCategory != null && (selectedCategory == 'logonsimulatorregusers' || selectedCategory == 'cloudregusers'))
		{
			Ext.getCmp('fname').setVisible(true);
			Ext.getCmp('lname').setVisible(true);
			Ext.getCmp('phoneno').setVisible(true);
			Ext.getCmp('comp').setVisible(true);
			Ext.getCmp('ModifyOver').setVisible(false);
			Ext.getCmp('DeleteOver').setVisible(true);
			Ext.getCmp('blockUsers').setVisible(false);
			Ext.getCmp('dateFormat').setVisible(false);
			Ext.getCmp('userRole').setVisible(false);
			Ext.getCmp('expiry').setVisible(false);
			Ext.getCmp('LastLoginTime').setVisible(false);
			Ext.getCmp('RegistrationDate').setVisible(false);
			Ext.getCmp('registerUser').setVisible(true);
			Ext.getCmp('mailid').setVisible(false);
			Ext.getCmp('agentdownload').setVisible(false);
			Ext.getCmp('agentinstalled').setVisible(false);
		}
		else
		{
			Ext.getCmp('fname').setVisible(false);
			Ext.getCmp('lname').setVisible(false);
			Ext.getCmp('phoneno').setVisible(false);
			Ext.getCmp('comp').setVisible(false);
			Ext.getCmp('ModifyOver').setVisible(true);
			Ext.getCmp('DeleteOver').setVisible(false);
			Ext.getCmp('blockUsers').setVisible(true);
			Ext.getCmp('LastLoginTime').setVisible(false);

			Ext.getCmp('dateFormat').setVisible(true);
			Ext.getCmp('userRole').setVisible(true);
			Ext.getCmp('expiry').setVisible(true);
			Ext.getCmp('RegistrationDate').setVisible(true);
			Ext.getCmp('registerUser').setVisible(false);
			Ext.getCmp('agentdownload').setVisible(false);
			Ext.getCmp('agentinstalled').setVisible(false);
		}
		me.getUserdetailsgrid().setTitle('<span class="font_bold">'+Ext.getCmp('category').getDisplayValue()+'</span>');
		this.getMain().doLayout();
		
		if (selectedCategory != null && (selectedCategory == 'logonsimulatorusers' || selectedCategory == 'logonsimulatoregusers' || selectedCategory == 'nonactiveusers' || selectedCategory == 'cloudusers'))
		{
			if (selectedCategory == 'logonsimulatorusers')
			{
				Ext.getCmp('blockDomain').show();
			}
			else
			{
				Ext.getCmp('blockDomain').hide();
			}
			me.getUserdetailsgrid().columns[findColumnIndex(me.getUserdetailsgrid().columns, 'RegistrationDate')].setSortState('DESC');
		}
		else
		{
			Ext.getCmp('blockDomain').hide();
		}
	},

	doSorting : function(state)
	{
		var ds = Ext.getCmp('RegistrationDate').up('tablepanel').store;
		var field =  Ext.getCmp('RegistrationDate').getSortParam();
		customDateSorting(ds,state,field,userDateFormat);
		Ext.getCmp('userdetailsgrid').getView().refresh();
		var cssClassName = "x-column-header-sort-"+state;
		Ext.getCmp('RegistrationDate').addCls(cssClassName);
	},

	showBlockDomainWin : function()
	{
		popUpWin = Ext.create('Ext.Window', {
			layout: 'fit',
			border: false,
			title: 'Block Domains',
			id: 'egblockdomain',
			width: 500,
			padding:'5 10 10 10',
			autoScroll: true,
			modal: true,

			layout: {
				type: 'vbox',
				pack: 'start',
				align: 'center'
			},
			margin:10,
			dockedItems : [
				{
					dock: 'bottom',
					layout:{
						type:'hbox',
						align:'stretch',
						pack:'center'
					},
					border: false,
					padding : '10 0 0 0',
					items: [
						{
							xtype: 'button',
							id: 'updateBlockedDomain',
							text: 'Update',
							cls : 'quickMenuWhiteButton',
							width: 80,
							layout: {
								type: 'hbox',
								pack: 'center',
								align: 'center'
							},
							listeners : 
							{
								'click' : function()
								{
									appCnt.updateBlockedDomains();
								}
							}
						}
					]
				}
			],
			items: [
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: 'Domains',
					labelAlign: 'top',
					id:'domainVal',
					labelWidth: 60,
					width: 450,
					emptyText : 'Comma-separated list of domains [@example.com,@example1.com]',
					labelSeparator:' ',
					labelStyle:{'font-weight':'bold'},
					margin: 10
				}
			]
		});
		popUpWin.show();
		Ext.getCmp('domainVal').focus(true,true);
	},

	updateBlockedDomains : function()
	{
		var domainVal = Ext.getCmp('domainVal').getValue();
		if (domainVal.indexOf(",") != -1)
		{
			var values = domainVal.split(",");
			for(var v=0;v < values.length;v++)
			{
				var tmpVal = values[v];
				if (tmpVal == null || Ext.isEmpty(tmpVal))
				{
					Ext.Msg.show({
						title: "Block Domains",
						msg: "Please specify domains.",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainVal').focus(true,true);
						}
					});
					return;
				}
				else if (!tmpVal.startsWith('@'))
				{
					Ext.Msg.show({
						title: "Block Domains",
						msg: "Domain name should start with '@' symbol.",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainVal').focus(true);
						}
					});
					return;
				}
				else if (tmpVal.lastIndexOf('@') > 0)
				{
					Ext.Msg.show({
						title: "Block Domains",
						msg: "Please specify valid domain names.",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainVal').focus(true);
						}
					});
					return;
				}
				else if (tmpVal.indexOf('.') == -1)
				{
					Ext.Msg.show({
						title: "Block Domains",
						msg: "Please specify valid domain names.",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainVal').focus(true);
						}
					});
					return;
				}
				else if (tmpVal.endsWith('.'))
				{
					Ext.Msg.show({
						title: "Block Domains",
						msg: "Domain name should not end with a dot.",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainVal').focus(true);
						}
					});
					return;
				}
			}
		}
		else 
		{
			if (domainVal == null || Ext.isEmpty(domainVal))
			{
				Ext.Msg.show({
					title: "Block Domains",
					msg: "Please specify domains.",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainVal').focus(true,true);
					}
				});
				return;
			}
			else if (!domainVal.startsWith('@'))
			{
				Ext.Msg.show({
					title: "Block Domains",
					msg: "Domain name should start with '@' symbol.",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainVal').focus(true);
					}
				});
				return;
			}
			else if (domainVal.lastIndexOf('@') > 0)
			{
				Ext.Msg.show({
					title: "Block Domains",
					msg: "Please specify valid domain names.",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainVal').focus(true);
					}
				});
				return;
			}
			else if (domainVal.indexOf('.') == -1)
			{
				Ext.Msg.show({
					title: "Block Domains",
					msg: "Please specify valid domain names.",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainVal').focus(true);
					}
				});
				return;
			}
			else if (domainVal.endsWith('.'))
			{
				Ext.Msg.show({
					title: "Block Domains",
					msg: "Domain name should not end with a dot.",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainVal').focus(true);
					}
				});
				return;
			}
		}

		Ext.Ajax.request({
			url:'EgDispUserSites/data/EgUserOperationsJson.jsp?blockedDomain='+encodeURIComponent(domainVal)+'&from=blockDomain',
			method:'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var publicJson = Ext.decode(jsonText);
				var blockDomain = publicJson['blockDomain'];
				if (blockDomain == 'success')
				{
					Ext.Msg.show({
						title: "Block Domains",
						msg: "Domains have been blocked successfully.",
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
						fn: function() {
							var win = Ext.getCmp('egblockdomain');
							if (win != null & win != undefined)
							{
								win.close();
							}
						}
					});
				}
			}
		});
	},

	updateUserInfo : function(defaultUrl)
	{
		Ext.Ajax.request({
			url : defaultUrl,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	getUserDetails : function(obj)
	{
		var s_user = obj.getValue();
		var urlStr = 'EgDispUserSites/data/EgDispUserSitesJson.jsp?action=userinfo&user='+encodeURIComponent(s_user);
		this.updateUserInfo(urlStr);
		this.loadUserDetails(s_user);
	},
	loadUserDetails : function(selectedUser)
	{
		var me = this;
		var userDetailsArr = new Array();
		var Servers = publicJSON['Servers'];
		var Segments = publicJSON['Segments'];
		var Zones = publicJSON['Zones'];
		var Services = publicJSON['Services'];
		var serviceGroups = publicJSON['serviceGroups'];
		var userVMs = publicJSON['userVMs'];
		var userVMs = publicJSON['userVMs'];
		var cols = publicJSON['cols'];
		Ext.getCmp('resultpanel').add({xtype:'userdetailscontainer'});
		var tmpPanelObj = Ext.getCmp('userInfoContainer');
		Ext.getCmp("userID").getStore().loadRawData(availableUserIDs);
		Ext.getCmp('userID').setValue(selectedUser);
		tmpPanelObj.removeAll();
		Ext.getCmp('resultpanel').hide();

		var isElementsAssociated = false;
		if (!Ext.isEmpty(Servers))
		{
			isElementsAssociated = true;
			var tmpTab = me.getEgUserTab("1","USER COMPONENTS");
			var gridData = me.getGridPanel(Servers,cols,"Servers");
			tmpPanelObj.add(tmpTab);
			Ext.getCmp('tab1').add(gridData);
		}

		if (!Ext.isEmpty(Segments))
		{
			isElementsAssociated = true;
			var tmpTab = me.getEgUserTab("2","SEGMENTS");
			var gridData = me.getGridPanel(Segments,cols,"Segments");
			tmpPanelObj.add(tmpTab);
			Ext.getCmp('tab2').add(gridData);
		}

		if (!Ext.isEmpty(Zones))
		{
			isElementsAssociated = true;
			var tmpTab = me.getEgUserTab("3","ZONES");
			var gridData = me.getGridPanel(Zones,cols,"Zones");
			tmpPanelObj.add(tmpTab);
			Ext.getCmp('tab3').add(gridData);
		}

		if (!Ext.isEmpty(Services))
		{
			isElementsAssociated = true;
			var tmpTab = me.getEgUserTab("4","SERVICES");
			var gridData = me.getGridPanel(Services,cols,"Services");
			tmpPanelObj.add(tmpTab);
			Ext.getCmp('tab4').add(gridData);
		}

		if (!Ext.isEmpty(serviceGroups))
		{
			isElementsAssociated = true;
			var tmpTab = me.getEgUserTab("5","SERVICE GROUP");
			var gridData = me.getGridPanel(serviceGroups,cols,"serviceGroups");
			tmpPanelObj.add(tmpTab);
			Ext.getCmp('tab5').add(gridData);
		}

		if (!Ext.isEmpty(userVMs))
		{
			isElementsAssociated = true;
			var tmpTab = me.getEgUserTab("6","USER VMs");
			var gridData = me.getGridPanel(userVMs,cols,"userVMs");
			tmpPanelObj.add(tmpTab);
			Ext.getCmp('tab6').add(gridData);
		}

		if (isElementsAssociated == false)
		{
			var tmpMessage = {
				xtype:'container',
				padding:130,
				style:{'text-align':'center'},
				html:'<div class = "iconInformation" style="margin:0 auto"></div><div>No associated elements</div>'
			}
			tmpPanelObj.add(tmpMessage);
		}
		Ext.getCmp('loginresultpanel_in_formitem').hide();
		Ext.getCmp('userdetailsgrid').hide();
		Ext.getCmp('backButton').show();
		Ext.getCmp('resultpanel').show();
	},
	getEgUserTab : function(id,tabTitle)
	{
		var tmpTab = Ext.create('Ext.tab.Panel', {
			width: '90%',
			margin : 8,
			activeTab: 0,
			items: [
				{
					title: tabTitle,
					cls: 'tablayout',
					id: 'tab'+id,
				}
			]
		});
		return tmpTab;
	},
	getGridPanel : function(gridArray,cols,from)
	{
		var fieldstoStore =  new Array();
		var mainColumnsObjArray	=  new Array();
		var itemsArray	=  new Array();
		for (var key in cols)
		{
			var gridColumn = cols[key];
			fieldstoStore.push(gridColumn);
			mainColumnsObjArray.push({
				header: gridColumn,
				sortable:true,
				dataIndex: gridColumn,
				align:'left',
				flex:1,
				renderer: function(value, metaData, record, row, col, store, gridView)
				{
					var tmpValue = value;
					var tmpHtml = value ;
					if (from == "Servers")
					{
						if (tmpValue != "-" && tmpValue.length > 0)
						{
							var tmpArr = tmpValue.split("|#|");
							var type = tmpArr[0];
							var component = tmpArr[1];
							if (type != null && type.indexOf("Agg_") != -1)
							{
								tmpHtml = '<a style="text-decoration:none" href="EgAggregateTree.jsp?qctr=1&reqfrom=home&isAggregateLink=true&server='+encodeURIComponent(type)+'">'+component+'</a>';
							}
							else
							{
								tmpHtml = '<a style="text-decoration:none" href="EgDispServer.jsp?qctr=1&server='+encodeURIComponent(type)+'">'+component+'</a>';
							}
						}
					}
					else if (from == "Segments")
					{
						if (tmpValue != "-" && tmpValue.length > 0)
						{
							tmpHtml = '<a style="text-decoration:none" href="EgAdminTopology.jsp?qctr=0&segment='+encodeURIComponent(tmpValue)+'">'+tmpValue+'</a>'
						}
					}
					else if (from == "Zones")
					{
						if (tmpValue != "-" && tmpValue.length > 0)
						{
							tmpHtml = '<a style="text-decoration:none" href="EgConfigZone.jsp?qctr=0&mode=modify&zone='+encodeURIComponent(tmpValue)+'">'+tmpValue+'</a>'
						}
					}
					else if (from == "Services")
					{
						if (tmpValue != "-" && tmpValue.length > 0)
						{
							tmpHtml = '<a style="text-decoration:none" href="EgConfigSites.jsp?modify=true&site='+encodeURIComponent(tmpValue)+'">'+tmpValue+'</a>'
						}
					}
					else if (from == "serviceGroups")
					{
						if (tmpValue != "-" && tmpValue.length > 0)
						{
							tmpHtml = '<a style="text-decoration:none" href="EgConfigServiceGroup.jsp?modify=true&site='+encodeURIComponent(tmpValue)+'">'+tmpValue+'</a>'
						}
					}
					return tmpHtml;
				}
			});
		}
		var gridpanel = Ext.widget('egusergridpanel',{
			store:new Ext.data.Store({
				fields: fieldstoStore,
				data: gridArray
			}),
			sortableColumns:false,
			cls:'gridSkin',
			columns:mainColumnsObjArray,
			bodyPadding:'0 0 20 0',
			viewConfig: {
				forceFit: true,
				stripeRows : false
			},
			sortable: false,
			hideable: false,
			hideHeaders : true
		});
		return gridpanel;
	},
	
	handleBlockIconClick: function(grid, rowIndex, colIndex)
	{
		var userdetailsgrid = Ext.getCmp('userdetailsgrid').getStore().getAt(rowIndex);
		var userStr = userdetailsgrid.get('UserName');
		Ext.Msg.show(
		{
			title : pageTitle,
			msg : confirmation2+" '"+userStr+"'?",
			icon : 'iconConfirmation',
			buttons : Ext.Msg.YESNO,
			fn : function(buttonText)
			{
				if(buttonText == "yes")
				{
					Ext.Ajax.request({
						url:'EgDispUserSites/data/EgUserOperationsJson.jsp',
						method: 'POST',
						params:{"uname":userStr,"from":"block"},
						standardSubmit: false,
						timeout: 300000,
						success: function(response)
						{
							if(response.status == 200)
							{
								Ext.MessageBox.show({
									title : pageTitle,
									msg : blockedMessage+'.',
									icon : 'iconInformation',
									buttons : Ext.Msg.OK
								});
								selectedCategory = Ext.getCmp('category').getValue();
								appCnt.buildMainData();
								appCnt.afterMainRender();
							}
						},
						failure: function(response)
						{
						}
					});
				}
			}
		});
	},

	handleUnBlockIconClick: function(grid, rowIndex, colIndex)
	{
		var userdetailsgrid = Ext.getCmp('userdetailsgrid').getStore().getAt(rowIndex);
		var userStr = userdetailsgrid.get('UserName');
		Ext.Msg.show(
		{
			title : pageTitle,
			msg : confirmation3+" '"+userStr+"'?",
			icon : 'iconConfirmation',
			buttons : Ext.Msg.YESNO,
			fn : function(buttonText)
			{
				if(buttonText == "yes")
				{
					Ext.Ajax.request({
						url:'EgDispUserSites/data/EgUserOperationsJson.jsp',
						method: 'POST',
						params:{"uname":userStr,"from":"unblock"},
						standardSubmit: false,
						timeout: 300000,
						success: function(response)
						{
							if(response.status == 200)
							{
								Ext.MessageBox.show({
									title : pageTitle,
									msg : unblockedMessage+'.',
									icon : 'iconInformation',
									buttons : Ext.Msg.OK
								});
								selectedCategory = Ext.getCmp('category').getValue();
								appCnt.buildMainData();
								appCnt.afterMainRender();
							}
						},
						failure: function(response)
						{
						}
					});
				}
			}
		});
	},

	handleDeleteIconClick: function(grid, rowIndex, colIndex)
	{
		var category = Ext.getCmp('category').getValue();
		var userdetailsgrid = Ext.getCmp('userdetailsgrid').getStore().getAt(rowIndex);
		var userStr = userdetailsgrid.get('UserName');
		if (!Ext.isEmpty(category) && (category == 'logonsimulatorregusers' || category == 'cloudregusers'))
		{
			Ext.Msg.show(
			{
				title : pageTitle,
				msg : confirmation1+" '"+userStr+"'?",
				icon : 'iconConfirmation',
				buttons : Ext.Msg.YESNO,
				fn : function(buttonText)
				{
					if(buttonText == "yes")
					{
						appCnt.callDeleteNotRegUserCode(userStr);
					}
				}
			});
		}
		else
		{
			var server = userdetailsgrid.get("ServersForDeletion");
			var elements = server.toString();
			queryString = "?delOption=yes&deleteAgents=true";
			Ext.Msg.show(
			{
				title : pageTitle,
				msg : confirmation1+" '"+userStr+"'?",
				icon : 'iconConfirmation',
				buttons : Ext.Msg.YESNO,
				fn : function(buttonText)
				{
					if(buttonText == "yes")
					{
						appCnt.callDeleteUserCode(queryString,userStr,elements);
					}
				}
			});
		}
	},

	callDeleteUserCode : function(queryString,userStr,elements)
	{
		var this_url = '/final/admin/DeleteUsers/data/Egdeleteuserp.jsp';
		if(queryString != null && queryString.length>0)
		{
			this_url='/final/admin/DeleteUsers/data/Egdeleteuserp.jsp'+queryString
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Processing...'});
		myMask.show();
		Ext.Ajax.request({
			url:this_url,
			method: 'POST',
			params:{"uname":userStr,"elements":elements},
			standardSubmit: false,
			timeout: 300000,
			success: function(response)
			{
				myMask.hide();
				if(response.status == 200)
				{
					Ext.MessageBox.show({
						title : pageTitle,
						msg : deletedMessage+'.',
						icon : 'iconInformation',
						buttons : Ext.Msg.OK
					});
					selectedCategory = Ext.getCmp('category').getValue();
					appCnt.buildMainData();
					appCnt.afterMainRender();
				}
			},
			failure: function(response)
			{
				myMask.hide();
			}
		});
	},
	
	callDeleteNotRegUserCode : function (userStr)
	{
		var myRegMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Processing...'});
		myRegMask.show();
		Ext.Ajax.request({
			url:'EgDispUserSites/data/EgUserOperationsJson.jsp',
			method: 'POST',
			params:{"uname":userStr,"from":"delnotreguser"},
			standardSubmit: false,
			timeout: 300000,
			success: function(response)
			{
				myRegMask.hide();
				if(response.status == 200)
				{
					Ext.MessageBox.show({
						title : pageTitle,
						msg : deletedMessage+'.',
						icon : 'iconInformation',
						buttons : Ext.Msg.OK
					});
					selectedCategory = Ext.getCmp('category').getValue();
					appCnt.buildMainData();
					appCnt.afterMainRender();
				}
			},
			failure: function(response)
			{
				myRegMask.hide();
			}
		});
	},

	handleRegisterIconClick : function(grid, rowIndex, colIndex)
	{
		var userdetailsgrid = Ext.getCmp('userdetailsgrid').getStore().getAt(rowIndex);
		var userStr = userdetailsgrid.get('UserName');
		Ext.Msg.show(
		{
			title : pageTitle,
			msg : "Are you sure you want to register the user"+" '"+userStr+"'?",
			icon : 'iconConfirmation',
			buttons : Ext.Msg.YESNO,
			fn : function(buttonText)
			{
				if(buttonText == "yes")
				{
					appCnt.callRegUserCode(userStr);
				}
			}
		});
	},
	
	callRegUserCode : function (userStr)
	{
		var myRegMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Registration in progress...'});
		myRegMask.show();
		Ext.Ajax.request({
			url:'EgDispUserSites/data/EgUserOperationsJson.jsp',
			method: 'POST',
			params:{"uname":userStr,"from":"reguser"},
			standardSubmit: false,
			timeout: 300000,
			success: function(response)
			{
				if(response.status == 200)
				{
					var regjsonText = response.responseText;
					var regUserJSON = Ext.decode(regjsonText);
					if (defaultPortal != null && defaultPortal == 'clstrial')
					{
						Ext.Ajax.request({
							url: '/final/portal/PortalLogin/data/EgLogonp.jsp?comeFrom=register&from=twofalogin&reqFrom=clstrial',
							method: 'POST',
							params: {
								'emailid': regUserJSON['emailid'],
								'fname': regUserJSON['fname'],
								'lname': regUserJSON['lname'],
								'company':regUserJSON['company'],
								'phoneNo':regUserJSON['phoneNo'],
								'password':regUserJSON['password'],
								'timeZone':regUserJSON['timeZone'],
								'simulator':regUserJSON['simulator']
							},
							success: function(response)
							{
								myRegMask.hide();
								if(response.status == 200 && !Ext.isEmpty(response.responseText))
								{
									var jsonText = response.responseText;
									var resultObj = Ext.decode(jsonText);
									if (resultObj['success']=='user')
									{
										Ext.Msg.show({
											title: "Logon Simulator - For Registration",
											msg: resultObj['screenLabels']['userErr'],
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
										return false;
									}
									else if (resultObj['success']=='extagent')
									{
										Ext.Msg.show({
											title: "Logon Simulator - For Registration",
											msg: resultObj['screenLabels']['extAgentErr'],
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
										return false;
									}
									else if (resultObj['success']=='comp')
									{
										Ext.Msg.show({
											title: "Logon Simulator - For Registration",
											msg: resultObj['screenLabels']['compErr'],
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
										return false;
									}
									else if (resultObj['success']=='true')
									{
										Ext.MessageBox.show({
											title : pageTitle,
											msg : "User Registered Successfully"+'.',
											icon : 'iconInformation',
											buttons : Ext.Msg.OK
										});
										selectedCategory = Ext.getCmp('category').getValue();
										appCnt.buildMainData();
										appCnt.afterMainRender();
									}
								}
							},
							failure: function(form,action)
							{
								myRegMask.hide();
							}
						});
					}
					else if (defaultPortal != null && defaultPortal == 'cloud')
					{
						Ext.Ajax.request({
							url: '/final/portal/PortalLogin/data/EgLogonp.jsp?comeFrom=register&from=twofalogin&reqFrom=citrix',
							method: 'POST',
							params: {
								'emailid': regUserJSON['emailid'],
								'fname': regUserJSON['fname'],
								'lname': regUserJSON['lname'],
								'company':regUserJSON['company'],
								'phoneNo':regUserJSON['phoneNo'],
								'password':regUserJSON['password'],
								'timeZone':regUserJSON['timeZone']
							},
							success: function(response)
							{
								myRegMask.hide();
								if(response.status == 200 && !Ext.isEmpty(response.responseText))
								{
									var jsonText = response.responseText;
									var resultObj = Ext.decode(jsonText);
									if (resultObj['success']=='user')
									{
										Ext.Msg.show({
											title: "eG Enterprise Cloud - For Registration",
											msg: resultObj['screenLabels']['userErr'],
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
										return false;
									}
									else if (resultObj['success']=='true')
									{
										Ext.MessageBox.show({
											title : pageTitle,
											msg : "User Registered Successfully"+'.',
											icon : 'iconInformation',
											buttons : Ext.Msg.OK
										});
										selectedCategory = Ext.getCmp('category').getValue();
										appCnt.buildMainData();
										appCnt.afterMainRender();
									}
								}
							},
							failure: function(form,action)
							{
								myRegMask.hide();
							}
						});
					}
				}
			},
			failure: function(response)
			{
				myRegMask.hide();
			}
		});
	}
});

function findColumnIndex(columns,dataIndex)
{
	var index;
	for (index = 0; index < columns.length; ++index) 
	{
		if (columns[index].dataIndex == dataIndex) 
		{ 
			break; 
		}
	}
	return index == columns.length ? -1 : index;
}



