var rowBodyFeature = Ext.create('Ext.grid.feature.RowBody', {
	getAdditionalData : function(data, rowIndex, record, orig) {
		var headerCt = this.view.headerCt, colspan = headerCt.getColumnCount();
		if (record.get("isElementsAssociated") == true)
		{
			if (record.get("hasallcompaccess") == true)
			{
				return {
					//rowBody : "I got some more information for the record on "+rowIndex+" - And I take up the whole widt of the row for this record!",
					rowBody: '<div style="padding-top:1em;padding-bottom:1em;padding-left: 5em;font-style: italic;">'+intnlMessage9+'</div>',
					rowBodyCls : this.rowBodyCls,
					rowBodyColspan : colspan
				};
			}
			else
			{
				var tmpStr = "";
				var htmlStr = "<table border='0' cellpadding='5' cellspacing='0' style='width:100%'>";
				if (record.get("Zones") != 'no zones')
				{
					tmpStr = tmpStr + '<div><p><i>'+intnlMessage2+'</i><br>'+record.get("Zones")+'</p></div>';
				}

				if (record.get("ServiceGroups") != 'no service groups')
				{
					tmpStr = tmpStr + '<div><p><i>'+intnlMessage3+'</i><br>'+record.get("ServiceGroups")+'</p></div>';
				}

				if (record.get("Services") != 'no services')
				{
					tmpStr = tmpStr + '<div><p><i>'+intnlMessage4+'</i><br>'+record.get("Services")+'</p></div>';
				}

				if (record.get("Segments") != 'no segments')
				{
					tmpStr = tmpStr + '<div><p><i>'+intnlMessage5+'</i><br>'+record.get("Segments")+'</p></div>';
				}

				if (record.get("Components") != 'no components')
				{
					tmpStr = tmpStr + '<div><p><i>'+intnlMessage6+'</i><br>'+record.get("Components")+'</p></div>';
				}

				if (record.get("UserVms") != 'no vms')
				{
					tmpStr = tmpStr + '<div><p><i>'+intnlMessage7+'</i><br>'+record.get("UserVms")+'</p></div>';
				}

				if (record.get("hasAutoAsscociatedComponents") != false)
				{
					tmpStr = tmpStr + '<div><p><i>'+intnlMessage8+'</i><br>'+record.get("Auto")+'</p></div>';
				}

				htmlStr = htmlStr + "</table>";
				return {
					//rowBody : "I got some more information for the record on "+rowIndex+" - And I take up the whole widt of the row for this record!",
					rowBody: '<div style="padding-top:0.5em;padding-bottom:0.5em;padding-left: 5em;">'+tmpStr+'</div>',
					rowBodyCls : this.rowBodyCls,
					rowBodyColspan : colspan
				};
			}
		}
		else
		{
			return {
				//rowBody : "I got some more information for the record on "+rowIndex+" - And I take up the whole widt of the row for this record!",
				rowBody: '<div style="padding-top:1em;padding-bottom:1em;padding-left: 5em;font-style: italic;">'+intnlMessage1+'</div>',
				rowBodyCls : this.rowBodyCls,
				rowBodyColspan : colspan
			};
		}
	}
});

Ext.define('EgDispUserSites.view.UserDetailsGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.userdetailsgrid',
	id:'userdetailsgrid',
	requires : ['Ext.ux.RowExpander',
				'Ext.ux.data.PagingMemoryProxy'],

	cls:'gridSkin',
	title : 'All Users',
	rowBodyTrSelector: '.x-grid-rowbody-tr',
	rowBodyHiddenCls: 'x-grid-row-body-hidden',
	rowCollapsedCls: 'x-grid-row-collapsed',
	emptyText: "<div style='margin:10% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText' id=\"userDeferMessage\">"+intnlMessage11+".</div></td></tr></table></div>",
	viewConfig: {
		deferEmptyText: false
	},
	flex : 1,
	initComponent : function() {
		this.dockedItems = [{
			xtype: 'pagingtoolbar',
			id:'pagingtoolbarid',
			store: this.store,
			dock: 'bottom',
			cls:'pagingtoolbar',
			displayInfo: true,
			listeners : {
				'change' : function()
				{
					if (Ext.getCmp('nodeCollapse').hidden == true)
					{
						Ext.getCmp('nodeExpand').show();
						for (var i = 0;i<this.up('grid').getStore().getCount();i++)
						{
							this.up('grid').collapseAllRow(i);
						}
						this.up('grid').view.refreshSize();
					}
					else
					{
						Ext.getCmp('nodeCollapse').show();
						for (var i = 0;i<this.up('grid').getStore().getCount();i++)
						{
							this.up('grid').expandAllRow(i);
						}
						this.up('grid').view.refreshSize();
					}
				}
			}
		}];
		this.callParent();
	},

	tools: [
		{
			xtype:'button',
			id: 'blockDomain',
			cls: 'button20',
			text: 'Block Domains',
			width: 100,
			margin: '2 5 2 0',
			hidden: false
		},
		{
			xtype: 'button',
			id : 'nodeExpand',
 			iconCls: 'iconExpandAll',
			hidden:false,
			style: {
				background: 'none',
				border: '0px'
			},
 			listeners: {
				'click':function(obj){
					this.hide();
					Ext.getCmp('nodeCollapse').show();
					for (var i = 0;i<this.up('grid').getStore().getCount();i++)
					{
						this.up('grid').expandAllRow(i);
					}
					this.up('grid').view.refreshSize();
				}
			}
		},
		{
				xtype:'button',
				id :'nodeCollapse',
				iconCls: 'iconCollapseAll',
				hidden:true,
				style: {
					background: 'none',
					border: '0px'
				},
				listeners:{
				'click':function(obj){
					this.hide();
					Ext.getCmp('nodeExpand').show();
					for (var i = 0;i<this.up('grid').getStore().getCount();i++)
					{
						this.up('grid').collapseAllRow(i);
					}
					this.up('grid').view.refreshSize();
				}
			}
		}
	],

	tbar: [
		{
			xtype:'tbfill',
		},
		{
			xtype:'scrollcombo',
			width: 150,
			editable : false,
			labelAlign : 'top',
			labelSeparator : '',
			id: 'searchCategory',
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField : 'displayField',
			valueField : 'valueField',
			queryMode : 'local'
		},
		{
			xtype: 'trigger',
			trigger1Cls: 'x-form-clear-trigger',
			trigger2Cls: 'x-form-search-trigger',
			cls: 'whitedropdown_search',
			//emptyText: 'Search User Name',
			id : 'userSearch',
			padding: '2 6 2 2',
			onTrigger1Click: function() {
				this.reset();
			},
			onTrigger2Click: function() {
				appCnt.fetchUsers(this.getValue());
			},
			getTriggerMarkup: function() {
				var me = this,
					i = 0,
					hideTrigger = (me.readOnly || me.hideTrigger),
					triggerCls,
					triggerBaseCls = me.triggerBaseCls,
					triggerConfigs = [],
					unselectableCls = Ext.dom.Element.unselectableCls,
					style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
					cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

				// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
				// single triggerCls config. Should rethink this, perhaps something more structured like a list of
				// trigger config objects that hold cls, handler, etc.
				// triggerCls is a synonym for trigger1Cls, so copy it.
				if (!me.trigger1Cls) {
					me.trigger1Cls = me.triggerCls;
				}

				// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
				for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
					if (i == 0)
					{
						triggerConfigs.push({
							tag: 'td',
							role: 'presentation',
							valign: 'top',
							cls: cls,
							id : 'MyTrigger_'+me.id+'_'+i,
							style: style + "display:none;",
							cn: {
								cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
								role: 'presentation'
							}
						});
					}
					else
					{
						triggerConfigs.push({
							tag: 'td',
							role: 'presentation',
							valign: 'top',
							cls: cls,
							id : 'MyTrigger_'+me.id+'_'+i,
							style: style,
							cn: {
								cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
								role: 'presentation'
							}
						});
					}
				}
				triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
				return Ext.DomHelper.markup(triggerConfigs);
			},
			listeners :
			{
				specialkey: function(field, e){
					// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
					// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
					if (e.getKey() == e.ENTER) {
						appCnt.fetchUsers(field.getValue());
					}
				}
			}
		}
	],

	//features: [rowBodyFeature],
	plugins: [{
		ptype: 'rowexpander',
		rowBodyTpl : [
			'{[this.getRowBodyView(values)]}',
			{
				getRowBodyView : function(values)
				{
					if (values.isElementsAssociated == true)
					{
						if (values.hasallcompaccess == true)
						{
							return '<div style="padding-top:1em;padding-bottom:1em;padding-left: 2em;font-style: italic;">'+intnlMessage9+'</div>';
						}
						else
						{
							var tmpStr = "";
							var htmlStr = "<table border='0' cellpadding='0' cellspacing='0' style='width:100%'>";
							if (values.Zones != 'no zones')
							{
								tmpStr = tmpStr + '<div style="word-break:break-all;padding:0px 2px 0px 0px;font-weight: bold;"><p><i>'+intnlMessage2+'</i>&nbsp;:&nbsp;'+values.Zones+'</p></div>';
							}

							if (values.ServiceGroups != 'no service groups')
							{
								tmpStr = tmpStr + '<div style="word-break:break-all;padding:0px 2px 0px 0px;font-weight: bold;"><p><i>'+intnlMessage3+'</i>&nbsp;:&nbsp;'+values.ServiceGroups+'</p></div>';
							}

							if (values.Services != 'no services')
							{
								tmpStr = tmpStr + '<div style="word-break:break-all;padding:0px 2px 0px 0px;font-weight: bold;"><p><i>'+intnlMessage4+'</i>&nbsp;:&nbsp;'+values.Services+'</p></div>';
							}

							if (values.Segments != 'no segments')
							{
								tmpStr = tmpStr + '<div style="word-break:break-all;padding:0px 2px 0px 0px;font-weight: bold;"><p><i>'+intnlMessage5+'</i>&nbsp;:&nbsp;'+values.Segments+'</p></div>';
							}

							if (values.Components != 'no components')
							{
								var type = [];
								var l =0;
								for(var k = 0; k< (values.ComponentsType).length;k++)
								{
									if(type.indexOf(values.ComponentsType[k]) == -1)
									{
										type[l] = values.ComponentsType[k];
										l++;
									}
								}
								for(var i = 0; i< (type).length;i++)
								{
									tmpStr = tmpStr + '<div style="word-break:break-all;padding:0px 2px 0px 0px;font-weight: bold;"><p><i>'+type[i]+'</i>&nbsp;:&nbsp;';
									var n =0;
									for(var j = 0; j< (values.Components).length;j++)
									{
										if((values.Components[j]).indexOf(type[i]) > -1)
										{	
											if(n>0)
											{
												tmpStr = tmpStr+ ",";
											}
											tmpStr = tmpStr+ values.Components[j];
											tmpStr = tmpStr.replace(/ *\([^)]*\) */g, "");
											n++;
										}
									}
									tmpStr = tmpStr +'</p></div>';
								}
							}

							if (values.UserVms != 'no vms')
							{
								tmpStr = tmpStr + '<div style="word-break:break-all;padding:0px 2px 0px 0px;font-weight: bold;"><p><i>'+intnlMessage7+'</i>&nbsp;:&nbsp;'+values.UserVms+'</p></div>';
							}

							if (values.hasAutoAsscociatedComponents != false)
							{
								tmpStr = tmpStr + '<div style="word-break:break-all;padding:0px 2px 0px 0px;font-weight: bold;"><p><i>'+intnlMessage8+'</i>&nbsp;:&nbsp;'+values.Auto+'</p></div>';
							}

							htmlStr = htmlStr + "</table>";
							return '<div style="padding-top:0.5em;padding-bottom:0.5em;padding-left: 2em;">'+tmpStr+'</div>';
						}
					}
					else
					{
						return '<div style="padding-top:1em;padding-bottom:1em;padding-left: 5em;font-style: italic;">'+intnlMessage1+'</div>';
					}
				}
			}
		]
	}],
	//autoScroll : false,

	columns : [
		{
			dataIndex: 'UserName',
			header:'User Name',
			menuDisabled:true,
			flex: 1,
			renderer: function(value, metaData, record, row, col, store, gridView)
			{
				return value;
			},
			tdCls : 'nowrap-text'
		},
		{
			dataIndex: 'FirstName',
			header:'First Name',
			menuDisabled:true,
			id: 'fname',
			width: 100
		},
		{
			dataIndex: 'LastName',
			header:'Last Name',
			menuDisabled:true,
			id: 'lname',
			width: 100
		},
		{
			dataIndex: 'PhoneNumber',
			header:'Phone Number',
			menuDisabled:true,
			id: 'phoneno',
			width: 110
		},
		{
			dataIndex: 'Company',
			header:'Company',
			menuDisabled:true,
			id: 'comp',
			flex :1
		},
		{
			dataIndex: 'Role',
			header:'Role',
			menuDisabled:true,
			id : 'userRole',
			flex :1
		},
		{
			dataIndex: 'RegistrationDate',
			header:'Registration Date',
			id:'RegistrationDate',
			menuDisabled : true,
			sortable : true,
			flex :1,
			renderer: renderLast
		},
		{
			dataIndex: 'ExpiryDate',
			header:'Expiry Date',
			sortable : true,
			menuDisabled : true,
			id : 'expiry',
			flex :1,
			renderer: renderExpiry
		},
		{
			dataIndex: 'TimeZone',
			header:'Time Zone',
			id:'timeZone',
			sortable : true,
			menuDisabled : true,
			flex :1,
			tdCls : 'nowrap-text'
		},
		{
			dataIndex: 'DateFormat',
			header:'Date Format',
			sortable : false,
			menuDisabled : true,
			id : 'dateFormat',
			flex :1
		},
		{
			dataIndex: 'ServersForDeletion',
			header:'ServersForDeletion',
			sortable : false,
			menuDisabled : true,
			hidden : true,
			flex :1
		},
		{
			dataIndex: 'BlockedUser',
			header:'Blocked User',
			id : 'BlockedUser',
			sortable : false,
			menuDisabled : true,
			hidden : true,
			flex :1
		},
		{
			dataIndex: 'LastLoginTime',
			header:'Last Login Time',
			menuDisabled:true,
			sortable : false,
			id: 'LastLoginTime',
			flex:1,
			doSort: function(state) {
				appCnt.doSorting(state);
			}
		},
		{
			dataIndex: 'ComponentName',
			header:'ComponentName',
			menuDisabled:true,
			hidden: true,
			flex :1,
			renderer: function(value, metaData, record, row, col, store, gridView)
			{
				return value;
			}
		},
		{
			dataIndex: 'Email',
			header:'Mail ID/Mobile No',
			sortable : true,
			menuDisabled : true,
			width: 300,
			id: 'mailid',
			columns: [
				{
					dataIndex: 'To',
					header:'To',
					sortable : true,
					menuDisabled : true,
					width: 100,
					tdCls : 'nowrap-text'
				},
				{
					dataIndex: 'Cc',
					header:'Cc',
					sortable : true,
					menuDisabled : true,
					width: 100,
					tdCls : 'nowrap-text'
				},
				{
					dataIndex: 'Bcc',
					header:'Bcc',
					sortable : true,
					menuDisabled : true,
					width: 100,
					tdCls : 'nowrap-text'
				}
			]
		},
		{
			dataIndex: 'AgentDownloaded',
			header:agentdownloadStatus+'?',
			menuDisabled:true,
			id: 'agentdownload'
		},
		{
			dataIndex: 'AgentInstalled',
			header:'Agent Installed'+'?',
			menuDisabled:true,
			id: 'agentinstalled'
		},
		{
			dataIndex: 'Action',
			sortable:false,
			hideable:false,
			hidden : true,
			menuDisabled : true,
			menuDisabled:true
		},
		{
			xtype: 'actioncolumn',
			//cls: 'tasks-icon-column-header tasks-edit-column-header',
			width: 36,
			//icon: '../../../../resources/images/edit_task.png',
			iconCls: 'iconModify',
			id: 'ModifyOver',
			sortable: false,
			hideable: false,
			menuDisabled: true,
			handler : function(grid, rowIndex, colIndex)
			{
				var rec = grid.getStore().getAt(rowIndex);
				var userName = rec.get('Action');
				if (userName != 'admin' && userName != 'supermonitor' && userName != 'egsm' && userName != 'egenterprise')
				{
					changeUserProfile(userName);
				}
			},
			renderer: function(value, metaData, record, row, col, store, gridView)
			{
				if (record.get('UserName') == 'admin' || record.get('UserName') == 'supermonitor' || record.get('UserName') == 'egsm' || record.get('UserName') == 'egenterprise')
				{
					Ext.getCmp('ModifyOver').setDisabled(true);
				}
				else
				{
					Ext.getCmp('ModifyOver').setDisabled(false);
					metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
				}
			}
		},
		{
			xtype: 'actioncolumn',
			width: 36,
			id: 'registerUser',
			sortable: false,
			hideable: false,
			menuDisabled: true,
			renderer: function(value, metaData, record, row, col, store, gridView)
			{
				metaData.tdAttr = "data-qtip='Register' data-qclass='yellowTip'";
				return "<div style='cursor:pointer' onclick=\"javascript:appCnt.handleRegisterIconClick('"+gridView+"','"+row+"','"+col+"')\" class='trans_register_small'></div>";
			}
		},
		{
			xtype: 'actioncolumn',
			width: 36,
			id: 'DeleteOver',
			sortable: false,
			hideable: false,
			menuDisabled: true,
			renderer: function(value, metaData, record, row, col, store, gridView)
			{
				metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
				return "<div style='cursor:pointer' onclick=\"javascript:appCnt.handleDeleteIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconDelete'></div>";
			}
		},
		{
			xtype: 'actioncolumn',
			width: 36,
			id: 'blockUsers',
			sortable: false,
			hideable: false,
			menuDisabled: true,
			renderer: function(value, metaData, record, row, col, store, gridView)
			{
				var tooltip = ""
				var iconCls = ""
				var methodName = ""
				if (record.get('BlockedUser') == 'false')
				{
					tooltip = 'Block';
					iconCls = "iconUnlock";
					methodName = "handleBlockIconClick";
				}
				else
				{
					tooltip = 'Unblock';
					iconCls = "iconLock";
					methodName = "handleUnBlockIconClick";
				}
				metaData.tdAttr = "data-qtip='"+tooltip+"' data-qclass='yellowTip'";
				return "<div style='cursor:pointer' onclick=\"javascript:appCnt."+methodName+"('"+gridView+"','"+row+"','"+col+"')\" class='"+iconCls+"'></div>";
			}
		}
	],
	expandAllRow: function(rowIdx) {
		var view = this.view,
			rowNode = view.getNode(rowIdx),
			row = Ext.get(rowNode),
			nextBd = Ext.get(row).down(this.rowBodyTrSelector),
			record = view.getRecord(rowNode);

		if(row.hasCls(this.rowCollapsedCls)) {
			row.removeCls(this.rowCollapsedCls);
			nextBd.removeCls(this.rowBodyHiddenCls);
			//view.refreshSize();
			//view.fireEvent('expandbody', rowNode, record, nextBd.dom);
		}
	},
	collapseAllRow: function(rowIdx) {
		var view = this.view,
			rowNode = view.getNode(rowIdx),
			row = Ext.get(rowNode),
			nextBd = Ext.get(row).down(this.rowBodyTrSelector),
			record = view.getRecord(rowNode);

		row.addCls(this.rowCollapsedCls);
		nextBd.addCls(this.rowBodyHiddenCls);
		//view.refreshSize();
		//view.fireEvent('collapsebody', rowNode, record, nextBd.dom);
	},

	listeners : {
		columnhide: function(headerCt, column){
			var me = this,
			wordWrapRe = /wordwrap/;
			column.tdCls = "wrap-text " + column.tdCls;
			me.view.refresh();
		},
		columnshow: function(headerCt, column){
			var me = this,
			wordWrapRe = /wordwrap/;
			column.tdCls = "nowrap-text " + column.tdCls;
			me.view.refresh();
		}
	}
});

function changeUserProfile(userName)
{
	window.location.href="EgChangeUserProfile.jsp?username="+encodeURIComponent(userName)+"&qctr=1&reqfrom=disp";
}

function showUserInfo(user)
{
	var usercontainer = Ext.getCmp("userdetailsgrid");
	var defaultUrl = 'EgDispUserSites/data/EgDispUserSitesJson.jsp?action=userinfo&user='+encodeURIComponent(user);
	appCnt.updateUserInfo(defaultUrl);
	appCnt.loadUserDetails(user);
}

function renderLast(value, p, r) 
{
	if (!Ext.isEmpty(value))
	{
		var date = Ext.String.format('{0} {1}', Ext.Date.dateFormat(value, extjsDateFormat+'|'), r.get('RegistrationDate'));
		date = date.substring(0,date.indexOf('|'));
	}
	else
	{
		date = 'Not Available';
	}
	return date;
}

function renderExpiry(value, p, r) 
{
	if (!Ext.isEmpty(value))
	{
		var date = Ext.String.format('{0} {1}', Ext.Date.dateFormat(value, extjsExpiryDateFormat+'|'), r.get('ExpiryDate'));
		date = date.substring(0,date.indexOf('|'));
	}
	else
	{
		date = 'No expiry';
	}
	if (date == 'Dec 12, 9999')
	{
		date = 'No expiry';
	}
	return date;
}



