Ext.define('EgExternalMonitors.controller.Main',{
	extend:'Ext.app.Controller',
	views:['ExternalMonitor','ExternalMonitors'],
	refs:[
		{selector:'externalmonitors', ref:'externalmonitors'},
		{selector:'externalmonitor', ref:'externalmonitor'}
	],

	init: function()
	{
		this.control({
			'externalmonitors':
			{
				'afterrender': this.afterMainRender
			},
			'externalmonitors button[id="addNew"]':
			{
				'click': this.addNew
			},
			'externalmonitors actioncolumn[id="delete"]':
			{
				'click': this.deleteMonitor
			},
			'externalmonitors actioncolumn[id="modify"]':
			{
				'click': this.modifyMonitor
			},
			'externalmonitors grid[id="mainGrid"]':
			{
				//'itemmouseenter': this.onGridEnter,
				//'itemmouseleave': this.onGridLeave
			},

			'externalmonitor combo[id="servertypes"]':
			{
				'select': this.compTypeChange
			},
			'externalmonitor button[id="addBtn"]':
			{
				'click': this.addMonitor
			},
			'externalmonitor button[id="updateBtn"]':
			{
				'click': this.updateMonitor
			},
			'externalmonitor button[id="backbutton"]':
			{
				'click': this.goBackToView
			}
		});
	},

	afterMainRender: function()
	{
		var url = "/final/admin/EgExternalMonitors/data/EgExternalMonitorsJSON.jsp?mode=main";

		Ext.Ajax.request(
				{
					url : url,
					scope:this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						Ext.getCmp('mainGrid').getStore().loadRawData(jsonData.externalViewArray);
					}
				}
			);
	},

	onGridEnter: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
			Ext.each(icons, function(icon){
				Ext.get(icon).removeCls('x-hidden');
		});
	},

	onGridLeave: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		});
	},

	addNew: function()
	{
		Ext.getCmp('mainView').removeAll();
		Ext.getCmp('mainView').add({xtype : 'externalmonitor' });

		var operation = 'Add';

		var url = "/final/admin/EgExternalMonitors/data/EgAddModifyExtrnlMonitorsJSON.jsp?operation="+operation;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					Ext.getCmp('servertypes').getStore().loadRawData(jsonData.compTypeArrayJson);

					Ext.getCmp('servertypes').setValue(jsonData.compTypeArrayJson[0].displayField);
					Ext.getCmp('serverId').setValue('Select component');
					Ext.getCmp('serverId').getStore().removeAll();
				}
			}
		);
	},

	compTypeChange: function()
	{
		var serverType = Ext.getCmp('servertypes').getValue();
		var serverObj = Ext.getCmp('serverId');

		var operation = 'Add';

		var url = "/final/admin/EgExternalMonitors/data/EgAddModifyExtrnlMonitorsJSON.jsp?server="+encodeURIComponent(serverType)+"&operation="+operation+"&enableCompName=true";

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var aStore = new Ext.data.Store({
						fields: ['valueField','displayField'],
						data: []
					});

					for (var i=0; i<jsonData.compNameArrayJson.length; i++)
					{
						var compDisplayField = jsonData.compNameArrayJson[i].displayField;
						var compValueField = jsonData.compNameArrayJson[i].valueField;
						aStore.add({'valueField': compValueField, 'displayField': compDisplayField});
						serverObj.bindStore(aStore);
					}

					if (!Ext.isEmpty(serverObj) && !Ext.isEmpty(jsonData.compNameArrayJson) && jsonData.compNameArrayJson.length > 0)
					{
						serverObj.setValue('Select component');
					}
				}
			}
		);
	},

	addMonitor: function()
	{
		var comp_type = Ext.getCmp('servertypes').getValue();
		var comp_name = Ext.getCmp('serverId').getValue();
		var tool = Ext.getCmp('tool').getValue();
		var url = Ext.getCmp('url').getValue();
		var mainViewID = Ext.getCmp('mainView');

		if(Ext.isEmpty(comp_type) || comp_type=="Select component type")
		{
			Ext.Msg.show({
				title: extMonitorConfigTitle,
				msg: alertForNoComponentType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if(Ext.isEmpty(comp_name) || comp_name=='Select component')
		{
			Ext.Msg.show({
				title: extMonitorConfigTitle,
				msg: alertForNoComponent,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if(Ext.isEmpty(tool))
		{
			Ext.Msg.show({
				title: extMonitorConfigTitle,
				msg: alertForNullValuesTool,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if(Ext.isEmpty(url))
		{
			Ext.Msg.show({
				title: extMonitorConfigTitle,
				msg: alertForNullValuesURL,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if(!checkspecial(tool,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?/."))
		{
			Ext.Msg.show({
				title: extMonitorConfigTitle,
				msg: alertForNoSpecialChar,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}

		var processURL = "/final/admin/EgExternalMonitors/data/EgExtrnlMonitorProcess.jsp?server="+encodeURIComponent(comp_type)+"&compname="+encodeURIComponent(comp_name)+"&tool="+encodeURIComponent(tool)+"&operation=ADDINI&url="+encodeURIComponent(url);
		Ext.Ajax.request(
			{
				url : processURL,
				scope:this,
				method : 'POST',
				success: function(response){
					Ext.Msg.show({
						title: extMonitorConfigTitle,
						msg: alertForAdded,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
					mainViewID.removeAll();
					mainViewID.add({xtype:'externalmonitors'});
					this.afterMainRender();
				}
			}
		);
	},

	deleteMonitor: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		/* code added to get the selected monitor name */
		var viewStoreObj = Ext.getCmp('mainGrid');

		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);

		var tmpVal = record.get('CompType');
		var comp_name = record.get('CompName');

		var toolValue = record.get('Tool');
		var deleteToolUrl = record.get('Url');

		// End of code added 

		var compTypeActualName = '';
		var name = '';

		var isConfirmed = Ext.MessageBox.confirm(extMonitorConfigTitle,deleteConfirm + ' ' + toolValue +' ' + toolForDeletion + '?',function(id) {
			if (id == 'yes')
			{
				var url = "/final/admin/EgExternalMonitors/data/EgExternalMonitorsJSON.jsp";

				Ext.Ajax.request(
					{
						url : url,
						scope:this,
						method : 'POST',
						success: function(response){
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);

							var externalView = jsonData.externalViewArray;

							for (var i=0; i<externalView.length; i++)
							{
								var compTypeLocalName = externalView[i].CompType;
								if (tmpVal == compTypeLocalName)
								{
									compTypeActualName = externalView[i].compTypeActualName;
									name = externalView[i].nameForDeletion;

								}
							}
							if (comp_name.indexOf(':') < 0)
							{
								comp_name = comp_name+':NULL';
							}	
							var processURL = "/final/admin/EgExternalMonitors/data/EgExtrnlMonitorProcess.jsp?server="+encodeURIComponent(compTypeActualName)+"&compname="+encodeURIComponent(comp_name)+"&tool="+encodeURIComponent(toolValue)+"&url="+deleteToolUrl+"&operation=DeleteINI";
							Ext.Ajax.request(
								{
									url : processURL,
									scope:this,
									method : 'POST',
									success: function(response){
										Ext.Msg.show({
											title: extMonitorConfigTitle,
											msg: alertForDeleted,
											width: 300,
											buttons: Ext.Msg.OK,
											icon: 'iconInformation'
										});
										this.afterMainRender();
									}
								}
							);
						}
					}
				);
			}
		},this);
	},

	modifyMonitor: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var compTypeActualName = '';
		var compTypeValueField = '';
		/* code added to get the selected monitor name */
		var viewStoreObj = Ext.getCmp('mainGrid');

		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);

		var tmpVal = record.get('CompType');
		var name = record.get('CompName');

		var toolValue = record.get('Tool');
		var toolUrl = record.get('Url');
		/* End of code added */

		Ext.getCmp('mainView').removeAll();
		Ext.getCmp('mainView').add({xtype : 'externalmonitor' });

		Ext.getCmp('addBtn').hide();
		Ext.getCmp('updateBtn').show();

		Ext.getCmp('servertypes').setDisabled(true);
		Ext.getCmp('serverId').setDisabled(true);
		Ext.getCmp('tool').setDisabled(true);

		var compTypeObj = Ext.getCmp('servertypes');
		var compNameObj = Ext.getCmp('serverId');
		var toolObj = Ext.getCmp('tool');
		var urlObj = Ext.getCmp('url');

		var operation = 'Add';

		var url = "/final/admin/EgExternalMonitors/data/EgAddModifyExtrnlMonitorsJSON.jsp?operation="+operation;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					Ext.getCmp('servertypes').getStore().loadRawData(jsonData.compTypeArrayJson);
				}
			}
		);

		var urlForAjax = "/final/admin/EgExternalMonitors/data/EgExternalMonitorsJSON.jsp?mode=modify";

		Ext.Ajax.request(
			{
				url : urlForAjax,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var externalView = jsonData.externalViewArray;

					for (var i=0; i<externalView.length; i++)
					{
						var compTypeLocalName = externalView[i].CompType;
						if (tmpVal == compTypeLocalName)
						{
							compTypeActualName = externalView[i].compTypeActualName;
							compTypeValueField = externalView[i].nameForDeletion;
						}
					}
					compTypeObj.setValue(compTypeActualName);
					compNameObj.setValue(name);
					toolObj.setValue(toolValue);
					urlObj.setValue(toolUrl);
				}
			}
		);
	},

	updateMonitor: function()
	{
		var comp_type = Ext.getCmp('servertypes').getValue();
		var comp_name = Ext.getCmp('serverId').getValue();
		var tool = Ext.getCmp('tool').getValue();
		var url = Ext.getCmp('url').getValue();

		Ext.getCmp('servertypes').setDisabled(true);
		Ext.getCmp('serverId').setDisabled(true);
		Ext.getCmp('tool').setDisabled(true);

		var mainViewID = Ext.getCmp('mainView');

		var compTypeValueField = '';

		if(Ext.isEmpty(url))
		{
			Ext.Msg.show({
				title: extMonitorConfigTitle,
				msg: alertForNullValuesURL,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			Ext.getCmp('url').focus();
			return false;
		}

		var urlForAjax = "/final/admin/EgExternalMonitors/data/EgExternalMonitorsJSON.jsp";

		Ext.Ajax.request(
			{
				url : urlForAjax,
				scope:this,
				method : 'POST',
				success: function(response){

					if (comp_name.indexOf(':') < 0)
					{
						comp_name = comp_name+':NULL';
					}	
					var processURL = "/final/admin/EgExternalMonitors/data/EgExtrnlMonitorProcess.jsp?server="+encodeURIComponent(comp_type)+"&compname="+encodeURIComponent(comp_name)+"&tool="+encodeURIComponent(tool)+"&operation=ModifyINI&url="+encodeURIComponent(url);

					Ext.Ajax.request(
						{
							url : processURL,
							scope:this,
							method : 'POST',
							success: function(response){
								Ext.Msg.show({
									title: extMonitorConfigTitle,
									msg: alertForUpdated,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
								mainViewID.removeAll();
								mainViewID.add({xtype:'externalmonitors'});
								this.afterMainRender();
							}
						}
					);
				}
			}
		);
	},

	goBackToView: function()
	{
		var mainViewID = Ext.getCmp('mainView');

		mainViewID.removeAll();
		mainViewID.add({ xtype: 'externalmonitors' });

		var url = "/final/admin/EgExternalMonitors/data/EgExternalMonitorsJSON.jsp?mode=main";

		Ext.Ajax.request
		(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					Ext.getCmp('mainGrid').getStore().loadRawData(jsonData.externalViewArray);
				}
			}
		);
	}
});

function checkspecial(fieldValue,s_spl)
{
	var obj_val = fieldValue;
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			alert(alertForSpecial);
			return false;
		}
	}
	return true;
}



