Ext.define('EgExternalMonitors.view.ExternalMonitor', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.externalmonitor',
	cls:'outerpanel',
	title: extMonitorConfigTitle,
	margin:'8 8 0 8',
	//frame: true,

	requires : [
		'utilities.ScrollCombo',
		'utilities.adminMsg'
	],

	dockedItems: [
		{
			xtype: 'adminmsg',
			align:'center',
			addIcon:'iconAdminInfo',
			html: extMonitorConfigDesc,
			spaceforImg:5,
			padding: 5
		}
	],

	items:[
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				align: 'center',
				pack: 'center'
			},
			margin: '10 0 0 0',
			items: [
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: extMonitorCmpType,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 250,
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : []
					}),
					editable: false,
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					margin: '15 0 0 0',
					id: 'servertypes',
					name: 'servertypes',
					forceSelection : false
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: extMonitorCmpName,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 250,
					margin: '15 0 0 0',
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : []
					}),
					editable: false,
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					id: 'serverId',
					name: 'serverName',
					forceSelection : false
				},
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: extMonitorToolName,
					width: 250,
					margin: '15 0 0 0',
					allowBlank: false,
					labelAlign: 'top',
					labelSeparator: ' ',
					id: 'tool',
					name: 'tool'
				},
				{
					xtype: 'textarea',
					cls:'text-area',
					fieldLabel: extMonitorURL,
					width: 250,
					height: 100,
					margin: '15 0 0 0',
					allowBlank: false,
					labelAlign: 'top',
					labelSeparator: ' ',
					id: 'url',
					name: 'url'
				},
				{
					xtype: 'button',
					cls:'button20',
					text: extMonitorAddBtn,
					width: 80,
					margin: '20 0 0 0',
					id: 'addBtn'
				},
				{
					xtype: 'button',
					cls:'button20',
					text: extMonitorUpdateBtn,
					width: 80,
					margin: '20 0 0 0',
					id: 'updateBtn',
					hidden: true
				}
			]
		}
	],

	tools: [
		{
			xtype: 'button',
			cls:'backbutton',
			id: 'backbutton',
			iconCls:'iconBack',
			text: extMonitorBackBtn
		}
	]

});



