Ext.define('EgExternalMonitors.view.ExternalMonitors', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.externalmonitors',
	cls:'outerpanel',
	title: extMonitorsView,
	margin:'8 8 0 8',
	//frame: true,

	requires : [
		'utilities.CustomGrid',
		'utilities.adminMsg'
	],

	layout: {
		type: 'vbox',
		align:'stretch'
	},

	dockedItems: [
		{
			xtype: 'adminmsg',
			align:'center',
			addIcon:'iconAdminInfo',
			html: extMonitorsDesc,
			spaceforImg:5,
			padding: 5
		}
	],

	items: [
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id: 'mainGrid',
			store: new Ext.data.Store({
				fields : ['CompType', 'CompName', 'Tool', 'Url'],
				data : []
			}),
			flex: 1,
			autoScroll: true,
			scroll: true,
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: "<table border='0' height='350px' width='100%'><tr><td align=center><img src='/final/images/spacer.gif' class='iconInformation'><div class='commonErrorMsgText'>" + extMonitorsNothing + ".</div></td></tr></table>",
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: extMonitorsCmpType,
						dataIndex: 'CompType',
						width: 250
					},
					{
						text: extMonitorsCmpName,
						dataIndex: 'CompName',
						width: 250
					},
					{
						text: extMonitorsTool,
						dataIndex: 'Tool',
						width: 150
					},
					{
						text: extMonitorsURL,
						dataIndex: 'Url',
						flex: 1
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-edit-column-header',
						width: 36,
						//icon: '../../../../resources/images/edit_task.png',
						iconCls: 'iconModify',
						//tooltip: 'Modify',
						sortable: false,
						id: 'modify',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 36,
						//icon: '../../../../resources/images/delete.png',
						iconCls: 'iconDelete',
						//tooltip: 'Delete',
						sortable: false,
						id: 'delete',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
						}
					}
				]
			},
			margin: 10,
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					items:[
						{
							xtype: 'button',
							cls:'button20',
							text: extAddNewBtn,
							id: 'addNew'
						}
					]
				}
			]
		}
	]

});



