<%
/*******************************************************************************
*       Name            :       EgExternalMonitorsJSON.jsp
*       Purpose         :       This jsp is used to add external monitor
*       Version         :       6.0
*       CreationDate    :       26/06/2013
*       LastModified    :       26/06/2013
*       Author          :       Abdul Khader
*       Location        :       /final/admin/EgExternalMonitors/data/EgAddModifyExtrnlMonitorsJSON.jsp
*******************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*"%>
<%@ page import = "com.eg.EgDiscInfo"%> 
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "net.sf.json.*"%> 
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();
	JSONObject viewJson = new JSONObject();
	JSONArray externalViewArray = new JSONArray();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	boolean isMSIE7 = ( ua != null && ua.indexOf( "MSIE 7.0" ) != -1 );

	EgDiscInfo egDisc = new EgDiscInfo("manager");	//skm
	IniFile egExternalUrlIni= new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_externalURL.ini");
	String enableCompName = request.getParameter("enableCompName");
	String server = request.getParameter("server");
	String compName = request.getParameter("compname");
	String tool = request.getParameter("tool");
	String url = request.getParameter("url");
	String operation = request.getParameter("operation");
	String isListPage = request.getParameter("isListPage");
	boolean isIniSaved=false;
	ArrayList serverName=null;
	try
	{
		if(enableCompName!=null && enableCompName.equalsIgnoreCase("true"))
		{
			String[] serversArray = egDisc.getAllServersOfType(server);
			serverName = serversArray==null?new ArrayList():new ArrayList(Arrays.asList(serversArray));
		}
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
%>
<%
session.setAttribute("egPageDesc","EgExternalMonitors.jsp");
session.setAttribute("egTitlehref", "/final/admin/EgAddModifyExtrnlMonitors.jsp?operation=Add");
%>
<%
try
{
%>
<%

	Vector compTools = egExternalUrlIni.getVariables("MONITORING TOOLS",true);
	if(compTools!=null && !compTools.isEmpty())
	{
%>
<%
	}
	String userLanguage = _user.getLanguage();
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	List allServers=_user.getAllServerType();
	Vector servers=new Vector();
	Vector dispservers=new Vector();
	servers.addAll(allServers);
	servers.remove("Host_system");
	ArrayList serverList  = new ArrayList();
	ArrayList serverNameList  = new ArrayList();
	if(servers!=null && servers.size()>0)
	{
		Collections.sort(servers,String.CASE_INSENSITIVE_ORDER);
		serverList = sorter.getSortedCompTypeList(servers);
	}
	if(serverList!=null && !serverList.isEmpty())
	{
		int count = serverList.size();
		int countEmpty = 0;
		boolean cellFlag = false;
		for(int i=0; i<serverList.size(); i++)
		{
			EgName nameObj = (EgName)serverList.get(i);
			String tmpVal = nameObj.getActualName();
			String tmpDis = nameObj.getLocalName();
			if(tmpVal!=null && !tmpVal.equals(""))
			{
				Vector addedTool = egExternalUrlIni.getVariables(tmpVal,true);
				if(addedTool!=null && !addedTool.isEmpty())
				{
					rootJson.put("cellFlag",cellFlag);
					rootJson.put("tmpDis",tmpDis);
%>
<%
					rootJson.put("addedTool",addedTool);
					for(int j=0; j<addedTool.size(); j++)
					{
						String compNameTool = (String)addedTool.get(j);
						rootJson.put("compNameTool",compNameTool);
						String name = compNameTool.substring(0,compNameTool.lastIndexOf(":"));
						rootJson.put("name",name);
						viewJson.put("compTypeActualName",tmpVal);
						viewJson.put("nameForDeletion",name);
						viewJson.put("CompType",tmpDis);

						String disName = name;
						if(disName!=null && disName.indexOf(":NULL")>0)
							disName= disName.substring(0,disName.indexOf(":"));

						rootJson.put("disName",disName);

						int compNameLimit=0;
						int toolNameLimit=0;
						int toolUrlLimit=0;
						if(userLanguage.equals("en_US"))
						{
							compNameLimit=23;
							toolNameLimit=14;
							toolUrlLimit=40;
						}
						else
						{
							compNameLimit=18;
							toolNameLimit=6;
							toolUrlLimit=35;
						}

						String compTypeDispName = disName;
						rootJson.put("compTypeDispName",compTypeDispName);
						viewJson.put("CompName",compTypeDispName);
						String toolValue = compNameTool.substring(compNameTool.lastIndexOf(":")+1,compNameTool.length());
						rootJson.put("toolValue",toolValue);
						String toolValueDisp = toolValue;
						rootJson.put("toolValueDisp",toolValueDisp);
						viewJson.put("Tool",toolValue);

						String toolUrl = egExternalUrlIni.getValue(tmpVal,compNameTool);
						rootJson.put("toolUrl",toolUrl);
						String toolUrlDisp = toolUrl;
						rootJson.put("toolUrlDisp",toolUrlDisp);
						viewJson.put("Url",toolUrlDisp);

						externalViewArray.add(viewJson);

						String deleteToolUrl = com.egurkha.util.StringUtils.replace(toolUrl,"&","|amp|");
						deleteToolUrl = com.egurkha.util.StringUtils.replace(toolUrl,"#","|hash|");
						rootJson.put("deleteToolUrl",deleteToolUrl);

						String modifyLink = "EgAddModifyExtrnlMonitors.jsp?server="+tmpVal+"&compname="+name+"&tool="+toolValue+"&operation=Modify&enableCompName=true";
						String deleteLink="EgExtrnlMonitorProcess.jsp?server="+tmpVal+"&compname="+name+"&tool="+toolValue+"&url="+deleteToolUrl+"&operation=DeleteINI";
						rootJson.put("modifyLink",modifyLink);
						rootJson.put("deleteLink",deleteLink);

						if(j!=0)
						{
							if(j+1==addedTool.size())
							{
								rootJson.put("cellFlag",cellFlag);
%>
<%
							}
							else
							{
%>
<%
							}
						}
%>
<%
					}
%>
<%
				cellFlag=!cellFlag;
				}
				else
				{
				countEmpty++;
				}
			}
		}
		if(count==countEmpty)
		{
			rootJson.put("admin_Skin",admin_Skin);
%>
<%
		}
	}
	else
	{
%>
<%

	}
%>
<%
}
catch(Exception e)
{
	e.printStackTrace();
}

	session.setAttribute("adminLastAccessedURL","/final/admin/EgExternalMonitors.jsp?"+request.getQueryString());

	rootJson.put("externalViewArray",externalViewArray);

	out.println(rootJson);
%>




