<!DOCTYPE html>

<%@ include file="EgTrackerA.jsp" %>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<html>
<head>
	<meta charset="utf-8">
	<title>Global Thresholds</title>

	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>

	<!-- Application folder -->
	<script src="GlobalThreshold/app/app.js"></script>
	<egui:skin ui="admin"/>
</head>
<body>
<script language="javascript">
var csrfToken = '<%=strCsrfToken%>';
var pageDesc = '<egui:intnl description="ConfigureGlobalThreshTests.jsp"/>';
//var pageName = '<egui:intnl text="admin.title.Global Thresholds"/>'
var pageName = '<egui:intnl text="admin.title.Enable/Disable Global Thresholds"/>';
var addText = '<egui:intnl text="admin.threshold.Add to Disassociated"/>';
var removeText = '<egui:intnl text="admin.threshold.Remove from Disassociated"/>';
var assoText = '<egui:intnl text="admin.threshold.Associated Tests"/>';
var disAssoText = '<egui:intnl text="admin.threshold.Disassociated Tests"/>';
var btnText = '<egui:intnl text="admin.threshold.Update"/>';

var alert1 = '<egui:intnl text="admin.common.Please choose atleast one test to associate or disassociate"/>'
var alert2 = '<egui:intnl text="admin.common.Global thresholds successfully updated"/>'+'.';
var alert3 = '<egui:intnl text="admin.common.When you set Global Thresholds for a test, any automatic thresholds previously set for this test will be removed"/>'+'?';
var alert4 = '<egui:intnl text="admin.common.and you setting threshold levels for this test will be removed"/>'+'?';
var publicJson = '';

var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>.';
var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>.';
var errorTitle = '<egui:intnl text="admin.user.Error"/>';

Ext.onReady(function(){
	Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
	Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
	Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

	Ext.Ajax.on('requestexception', function (conn, response, options) {
		var errorStr = response.responseText;
		if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
		{
			if (errorStr.indexOf("user-session-invalid") != -1)
			{
				callWindow(1);
			}
			else if (errorStr.indexOf("user-deleted") != -1)
			{
				callWindow(2);
			}
			else if (errorStr.indexOf("user-timedout") != -1)
			{
				callWindow(3);
			}
		}
		else
		{
			if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
			{
				Ext.Msg.show({
					title : errorTitle,
					msg : requestTimeOut,
					buttons : Ext.Msg.OK,
					icon : 'iconError'
				});
			}
			else
			{
				console.log(response.responseText);
				Ext.Msg.show({
					title : errorTitle,
					msg : probsErrorMessage,
					buttons : Ext.Msg.OK,
					icon : 'iconError'
				});
			}
		}
	});
});
</script>
</body>
</html>
<%
if(request.getQueryString()!=null)
{
	session.setAttribute("adminLastAccessedURL","/final/admin/EgGlobalThresholds.jsp?"+request.getQueryString());
}
else
{
	session.setAttribute("adminLastAccessedURL","/final/admin/EgGlobalThresholds.jsp");
}
%>



