
Ext.define('EgInfraComponents.controller.Main',{
	extend: 'Ext.app.Controller',
	views:[	
		'Main',
		'EgInfraDownloader',
		'Print'
	],
	refs:[
		{selector:'main', ref:'main'},
	],
	init:function()
	{
		this.buildMainData();
		this.control({
			'main':
			{
				'afterrender': this.initComponentDetails
			},
			'main combo[id="componentType"]':
			{
				'select':this.componentOnChange
			},
			'main button[id="eGBackURI"]':
			{
				'click':this.eGBackURI
			},
			'main button[id="print"]':
			{
				'click': this.printPage
			},
			'main button[id="save"]':
			{
				'click': this.savePdf
			},
			'main button[id="saveCSV"]':
			{
				'click': this.saveInCSVFormat
			},
		})
	},
	buildMainData : function()
	{
		appURL = appURL + "&date="+new Date().getTime();
		Ext.Ajax.request({
			url : appURL,
			method : 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	printPage : function()
	{
		var printPage = "/final/admin/EgPrintInfraComponents.jsp?print=printpage";
		Ext.widget('print').show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set(
		{
			src :  printPage
		});
	},
	saveInCSVFormat : function()
	{
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+user_language;
	},
	savePdf : function()
	{
		var getSaveObj = Ext.widget('savepdf');
		getSaveObj.savePDF(pdfURLString);
	},
	eGBackURI : function()
	{
		window.location.href = "EgItInfrastructure.jsp?"+strQueryBack;
	},
	initComponentDetails : function()
	{
		var componentGridView = publicJSON['componentGridView'];
		var componentTypeArr = publicJSON['componentTypeArr'];
		var selectedComponentType = publicJSON['selectedComponentType'];

		var componentnamesummaryObj = Ext.getCmp('componentnamesummary');
		componentnamesummaryObj.getStore().loadRawData(componentGridView);
		var componentTypeObj = Ext.getCmp('componentType');
		componentTypeObj.getStore().loadRawData(componentTypeArr);
		componentTypeObj.setValue(selectedComponentType);
		this.setGridColumnTitle();
		this.showHostIpColumn();
	},
	setGridColumnTitle : function()
	{
		var componentnamesummaryObj = Ext.getCmp('componentnamesummary');
		var gridCols = publicJSON['gridCols'];
		var col = 0;
		for (var key in gridCols)
		{
			componentnamesummaryObj.columns[col++].setText(gridCols[key]);
		}
		var selectedComponentType = publicJSON['selectedComponentType'];
		if (selectedComponentType != 'Oracle_server')
		{
			componentnamesummaryObj.columns[6].hide();
		}
		else
		{
			componentnamesummaryObj.columns[6].show();
		}
	},
	showHostIpColumn : function()
	{
		var componentnamesummaryObj = Ext.getCmp('componentnamesummary');
		var hideHostIPField = publicJSON['hideHostIPField'];
		if (hideHostIPField)
		{
			componentnamesummaryObj.columns[1].hide();
		}
		else
		{
			componentnamesummaryObj.columns[1].show();
		}
	},
	componentOnChange : function(obj)
	{
		var me = this;
		var selectedValue = obj.getValue();
		me.updateInfraData("EgInfraComponents/data/EgInfraComponentsJson.jsp?componentType="+encodeURIComponent(selectedValue));
	},
	updateInfraData : function(url)
	{
		var me = this;
		Ext.Ajax.request({
			url : url,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				var componentGridView = publicJSON['componentGridView'];
				var componentnamesummary = Ext.getCmp('componentnamesummary');
				componentnamesummary.getStore().loadRawData(componentGridView);
				//me.setGridColumnTitle();
				var selectedComponentType = publicJSON['selectedComponentType'];
				if (selectedComponentType != 'Oracle_server')
				{
					componentnamesummary.columns[6].hide();
				}
				else
				{
					componentnamesummary.columns[6].show();
				}
				me.showHostIpColumn();
			}
		});
	},
})

function loadURL1(compType,compName)
{
	var tmpURI = "EgInfraCompDetails.jsp?componentType="+encodeURIComponent(compType)+"&componentName="+encodeURIComponent(compName)+"&urlFrom=EgItInfraComponentTypes";
	tmpURI = tmpURI+"&"+strQueryBack;
	window.location.href= tmpURI;
}



