
Ext.define('EgItInfrastructure.view.ComponentGroupedSummaryGrid', {
	extend: 'utilities.CustomGrid',
	alias:'widget.componentgroupedsummarygrid',
	id:'componentgroupedsummarygrid',
	requires: [
		'Ext.grid.feature.Grouping',
		'Ext.grid.*'
	],
	autoScroll : true,
	scroll : true,
	store: new Ext.data.Store({
		fields: ['componentType', 'componentCategory','totalCount'],
		groupField: 'componentCategory',
		data: []
	}),
	cls:'gridSkin',
	collapsible: false,
	title: '<span cls="font_bold">Total managed components</span>',
	resizable: false,
	features: [{
		ftype: 'grouping',
		id : 'componentGrouping',
		//groupHeaderTpl: '{name}',
		groupHeaderTpl: [
			//'<div style="vertical-align:top"><img src="/final/admin/eg_images/{name:this.getImage}.png" class="png">{name:this.formatServerName}</div>',
			'{name:this.formatServerName}',
			{
				formatServerName: function(name) {
					var serArr = name.split("#$#");
					return serArr[0] + " ("+publicJSON[serArr[1]]+")";
				},
				getImage : function(name)
				{
					var serArr = name.split("#$#");
					return serArr[1].toLowerCase();
				}
			}
		],
		hideGroupedHeader: false,
		startCollapsed: false,
	}],
	tools: [{
			xtype: 'button',
			id : 'te',
			name : 'te',
 			iconCls: 'iconExpandAll',
			hidden:true,
			style: {
				background: 'none',
				border: '0px'
			},
 			listeners: {
				'click':function(obj){
					this.hide();
					Ext.getCmp('tc').show();
					var thisGrid = Ext.getCmp('componentgroupedsummarygrid');
					var groupingFeature = thisGrid.view.getFeature('componentGrouping');
					groupingFeature.expandAll();
				}
			}
		},{
				xtype:'button',
				id :'tc',
				name :'tc',
				iconCls: 'iconCollapseAll',
				hidden:false,
				style: {
					background: 'none',
					border: '0px'
				},
				listeners:{
				'click':function(obj){
					this.hide();
					Ext.getCmp('te').show();
					var thisGrid = Ext.getCmp('componentgroupedsummarygrid');
					var groupingFeature = thisGrid.view.getFeature('componentGrouping');
					groupingFeature.collapseAll();
				}
			}
		}],
	columns : [
		{
			header: intnlLabel3,
			sortable: true,
			menuDisabled : true,
			dataIndex: 'componentType',
			flex : 1,
			renderer : function(val)
			{
				var tmpArr = val.split("#$#");
				var tmpTag = '<a id="mouse" href=\'javascript:loadURL("'+tmpArr[0]+'")\' target="main" class="eg_monlink">'+tmpArr[1]+'</a>';
				return tmpTag;
			}
		},
		{
			header: intnlLabel4,
			sortable: true,
			menuDisabled : true,
			dataIndex: 'totalCount',
			flex : 1
		}
	]
});



