Ext.define('EgItInfrastructure.view.ComponentNameSummary', {
	extend: 'utilities.CustomGrid',
	alias:'widget.componentnamesummary',
	id:'componentnamesummary',
	store: new Ext.data.Store({
		fields: ['Nick Name', 'HostName_OR_IP','OS','SystemName','componenetType','port','SID','hiddenField'],
		data: []
	}),
	autoScroll : true,
	scroll : true,
	cls:'gridSkin',
	title: 'Total managed components',
	columns : [
		{
			header: 'Nick Name',
			sortable: true,
			dataIndex: 'Nick Name',
			flex : 1,
			menuDisabled : true,
			renderer : function(val,metaData,record)
			{
				var tmpArr = record.get('hiddenField').split("#$#");
				var tmpTag = '<a id="mouse" href=\'javascript:loadURL1("'+tmpArr[0]+'","'+tmpArr[1]+'")\' target="main" class="eg_monlink">'+val+'</a>';
				return tmpTag;
			}
		},
		{
			header: 'Host IP/Name',
			sortable: true,
			menuDisabled : true,
			dataIndex: 'HostName_OR_IP',
			flex : 1,
			doSort: function(state) {
				var ds = this.up('tablepanel').store;
				var field = this.getSortParam();
				customIPv4Sorting(ds,state,field);
				Ext.getCmp('componentnamesummary').getView().refresh();
				var cssClassName = "x-column-header-sort-"+state;
				this.addCls(cssClassName);
			}
		},
		{
			header: 'Operating System',
			sortable: true,
			menuDisabled : true,
			dataIndex: 'OS',
			flex : 1
		},
		{
			header: 'System Name',
			sortable: true,
			menuDisabled : true,
			dataIndex: 'SystemName',
			flex : 1
		},
		{
			header: 'Component Type',
			sortable: false,
			menuDisabled : true,
			dataIndex: 'componenetType',
			flex : 1,
			renderer : function(val)
			{
				var resultVal;
				if (val != null && val.indexOf("|$|") != -1)
				{
					var tmpArr = val.split("|$|");
					var tmpTable = "<table cellpadding='4' cellspacing='0' border='0'>";
					for (var i = 0;i<tmpArr.length;i++)
					{
						tmpTable = tmpTable + "<tr><td class='x-grid-column-font'>"+tmpArr[i]+"</td></tr>";
					}
					tmpTable = tmpTable + "</table>";
					resultVal = tmpTable;
				}
				else
				{
					resultVal = val;
				}
				return resultVal;
			}
		},
		{
			header: 'Port',
			sortable: false,
			dataIndex: 'port',
			width : 80,
			menuDisabled : true,
			renderer : function(val)
			{
				if (val != null && val.indexOf("|$|") != -1)
				{
					var tmpArr = val.split("|$|");
					var tmpTable = "<table cellpadding='4' cellspacing='0' border='0'>";
					for (var i = 0;i<tmpArr.length;i++)
					{
						tmpTable = tmpTable + "<tr><td class='x-grid-column-font'>"+tmpArr[i]+"</td></tr>";
					}
					tmpTable = tmpTable + "</table>";
					return tmpTable;
				}
				else
				{
					return val;
				}
			}
		},
		{
			header: 'SID',
			menuDisabled : true,
			sortable: false,
			dataIndex: 'SID',
			flex : 1,
			renderer : function(val)
			{
				if (val != null && val.indexOf("|$|") != -1)
				{
					var tmpArr = val.split("|$|");
					var tmpTable = "<table cellpadding='4' cellspacing='0' border='0'>";
					for (var i = 0;i<tmpArr.length;i++)
					{
						tmpTable = tmpTable + "<tr><td class='x-grid-column-font'>"+tmpArr[i]+"</td></tr>";
					}
					tmpTable = tmpTable + "</table>";
					return tmpTable;
				}
				else
				{
					return val;
				}
			}
		}
	]
});



