Ext.define('EgItInfrastructure.view.EgInfraDownloader',{
	alias:'widget.savepdf',
	savePDF : function(s_qryString)
	{
		var progressBar = Ext.MessageBox.progress({
			title: 'Downloading',
			value: 5,
			width: 350,
			increment: 15,
			closable: false,
			progressText: 'Connecting..',
			wait: true,
			waitConfig: {
				interval: 200
			},
			msg: '<b>Downloading Please wait...</b>',
			scope: this,
			handler: function () {
				this.updateText('Done!');
			}
		});					
		var iFrameExists = Ext.query("#pdfIframe");
		if(Ext.isEmpty(iFrameExists))
		{
			Ext.DomHelper.append(document.body, {
				tag: 'iframe',
				frameBorder: 0,
				width: 0,
				height: 0,
				css: 'display:none;visibility:hidden;height:1px;',
				src: s_qryString,
				id: 'pdfIframe'
			});
		}
		else
		{
			Ext.select('#pdfIframe').set( { src :  s_qryString });
		}

		Ext.Ajax.request(
		{
			url : 'EgItInfrastructure/data/EgSaveStatusJson.jsp',
			scope:this,
			success: function(response){
				
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				if(!Ext.isEmpty(jsonData))
				{
					var downloadStatus = jsonData.isDownloaded;
					if(downloadStatus == true || downloadStatus == "true")
					{
						progressBar.hide();
					}
				}
				else
				{
					progressBar.hide();
				}
			}
		});

	}
});