	<%
/*******************************************************************************
*	Name			:	EgMap.jsp
*	Purpose 		:	Shows the Google Map, to mark the zone location.
*	Version 		:	eg 4.0
*	Author			:	N.Gokulanand
*	CreationDate 	:	July-20-2007
*******************************************************************************/
%>
<%@ taglib prefix = "egui" uri ="../WEB-INF/eg-taglib.tld"%>
<%@ include file = "EgTrackerA.jsp" %>
<%@ page errorPage="EgAdminMapError.jsp?s_message=Sorry could not connect map"%>
<%@ page import = "java.util.StringTokenizer"%>
<%@ page import ="com.eg.IniFile" %>
<%@ page import ="com.eg.EgInstallInfo"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<HTML>
<HEAD>
<title> eG Manager</title>
<egui:skin ui = "admin"/>
<%
	String zoneName = request.getParameter("zone");
	String latitude = "null";
	String longitude = "null";
	IniFile iniUiObj = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String myServerName = request.getScheme() + "://" +request.getServerName();
	String myPort = ""+request.getServerPort();
	String myScheme = request.getScheme();
	if (myScheme.equals("http") && !myPort.equals("80"))
		myServerName += ":"+myPort;
	else if (myScheme.equals("https") && !myPort.equals("443"))
		myServerName += ":"+myPort;
	String google_map_key = iniUiObj.getValue("ZONE_MAP",myServerName);
	if(google_map_key == null || google_map_key.equals("") || google_map_key.equalsIgnoreCase("None"))
	{
		myServerName = myServerName+ "/";
		google_map_key = iniUiObj.getValue("ZONE_MAP",myServerName);
		if(google_map_key == null || google_map_key.equals("") || google_map_key.equalsIgnoreCase("None"))
		{
			google_map_key = iniUiObj.getValue("ZONE_MAP","google_map_key");
		}
	}
	if(google_map_key == null || google_map_key.equals("") || google_map_key.equalsIgnoreCase("None"))
	{
%>
	<script>
		window.location.href = "EgAdminMapError.jsp?s_message=Invalid map key (or) not found&s_reason=key";
	</script>
<%
	}
	google_map_key = google_map_key.trim();
	IniFile topoIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	String coordinate = topoIni.getValue("ZONE_LOCATION",zoneName);
	StringTokenizer st = new StringTokenizer(coordinate, "|");
	int tokenCount = 0;
	while(st.hasMoreTokens())
	{
		String thisToken = st.nextToken();
		switch(tokenCount)
		{
			case 0:
				latitude = thisToken;
			break;
			case 1:
				longitude = thisToken;
			break;
		}
		tokenCount++;
	}
	String lastLatitude = latitude;
	String lastLongitude = longitude;
%>
<script language="JavaScript1.2" src="eg_scripts/eg_map.js"></script>
<script src="<%=myScheme%>://maps.google.com/maps?file=api&amp;v=2&amp;key=<%=google_map_key%>" type="text/javascript"></script>
<script language="JavaScript">

var map = null;
 var geocoder = null;

function mapTest(from,action)
{
	var parentForm = window.parent.document.configureZone;
	var thisLat = parentForm.latitude.value;
	var thisLng = parentForm.longitude.value;
	if(from == "img")
	{
		destroyMapWindow('egmap');
	}
	else if(from == "button" && action == "remove")
	{
		window.parent.document.getElementById('latitude').value = "null";
		window.parent.document.getElementById('longitude').value = "null";
		var hostLen = parentForm.managedHosts.options.length;
		//if(hostLen > 0 )
		{
			var mlist = parentForm.managedHosts;
			var marray = new Array();
			var comp_type = window.parent.document.configureZone.ComponentsType.options[window.parent.document.configureZone.ComponentsType.selectedIndex].value;
			var zoneName = window.parent.document.configureZone.zone.value;
			for(var i=0; i<hostLen; i++)
			{
				if(mlist.options[i].value == null)
					continue;
				marray[i] = mlist.options[i].value;
			}
			parentForm.chosenHosts.value = marray;
			parentForm.action = "Egconfigzonep.jsp"
			parentForm.submit();
			destroyMapWindow('egmap');
		}
	}
	else if(from == "button" && ('<%=lastLatitude%>' != thisLat) && ('<%=lastLongitude%>' != thisLng) && action != "remove")
	{
		var hostLen = parentForm.managedHosts.options.length;
		if(hostLen > 0 )
		{
			var mlist = parentForm.managedHosts;
			var marray = new Array();
			var comp_type = window.parent.document.configureZone.ComponentsType.options[window.parent.document.configureZone.ComponentsType.selectedIndex].value;
			var zoneName = window.parent.document.configureZone.zone.value;
			for(var i=0; i<hostLen; i++)
			{
				if(mlist.options[i].value == null)
					continue;
				marray[i] = mlist.options[i].value;
			}
			parentForm.chosenHosts.value = marray;
			parentForm.action = "Egconfigzonep.jsp"
			parentForm.submit();
			destroyMapWindow('egmap');
		}
		else
		{
			alert("<egui:intnl text='admin.zone.Please associate an element and try again'/>");
			destroyMapWindow('egmap');
		}
	}
	else
	{
		destroyMapWindow('egmap');
	}
}
function load() 
{
	try
	{
		if (GBrowserIsCompatible()) 
		{
			var lat;
			var lng;
			var currentLat = '<%=latitude%>';
			var currnetLng = '<%=longitude%>';
			map = new GMap2(document.getElementById("map"));
			map.addControl(new GSmallMapControl());
			
			GEvent.addListener(map, "mousemove", function(point)
			{
				lat = point.lat().toFixed(5);
				lng = point.lng().toFixed(5);
			});
			GEvent.addListener(map, "click", function()
			{
				map.clearOverlays();
				var marker = new GMarker(new GLatLng(lat, lng));
				map.addOverlay(marker);
				window.parent.document.getElementById('latitude').value = lat;
				window.parent.document.getElementById('longitude').value = lng;
			});
			map.setCenter(new GLatLng(31.952162,7.03125), 1);

			if(currentLat != 'null' && currnetLng != 'null')
			{
				var marker1 = new GMarker(new GLatLng(currentLat, currnetLng));
				map.addOverlay(marker1);
			}
			geocoder = new GClientGeocoder();
		}
		else
		{
			window.location.href = "EgAdminMapError.jsp?s_message=Invalid map key (or) not found&s_reason=key";
		}
	}
	catch(error)
	{
		window.location.href = "EgAdminMapError.jsp?s_message=Sorry could not connect map";
	}
}

function showAddress() 
{
	var thisForm = document.adminMap;
	var address = thisForm.address.value;

	if (geocoder)
	{
		geocoder.getLatLng(address,
			function(point)
			{
				if (!point) 
				{
					alert(address + " not found !!!");
				}
				else
				{
					map.setCenter(point, 15);
					var lat = point.lat().toFixed(5);
					var lng = point.lng().toFixed(5);
					map.clearOverlays();
					var marker = new GMarker(new GLatLng(lat, lng));
					window.parent.document.getElementById('latitude').value = lat;
					window.parent.document.getElementById('longitude').value = lng;
					map.addOverlay(marker);
				}
			}
		);
	}
}
</script>
</head>
<body onload="javascript:load();" style="overflow:hidden" scrolling="no" marginwidth="0" marginheight="0" leftmargin="0" topmargin="0">
<form action="#" name="adminMap">
	<table width="100%" height="450" cellpadding="0" cellspacing="0" id="alarmborder" border="0" >
		<tr>
			<td height="18">
				<table width="100%" cellpadding="0" cellspacing="0" border="0" height="18">
					<tr>
						<td width="95%" height="18" align="center" id="eg_headbg" colspan="2" class="head_padding4"><strong><egui:intnl text="admin.zone.GEOGRAPHIC LOCATION"/></strong>
						</td>
					</tr>
					<tr>
						<td width="95%" height="18" align="center" id="eg_headbg" class="head_padding4">
						<strong><egui:intnl text="admin.zone.Address"/></strong>&nbsp;
						<input type="text" style="width:400px" name="address" id="address" value="" />&nbsp;
						<input type="button" value="Go" class="eg_lightbutton" onclick="showAddress(); return false"/></td>
						<td width="23" align="center" valign="middle" id="eg_headbg" style="padding-right:0px;padding-top:0px">
						<a onClick="javascript:mapTest('img','')"><img src="/final/monitor/eg_images/winclose.gif" class="mouse" /></a></td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td align="center" valign="middle" colspan="3" style="padding-top:0px">
				<div id="map" style="padding-top:0px;width: 100%; height: 100%" style="border:0px solid #000000"></div>
			</td>
		</tr>
		<tr height="25">
			<td align="center" valign="middle" colspan="3" height="25" id="eg_headbg">
				<input type="button" value='<egui:intnl text="admin.common.Update"/>' class="eg_lightbutton" onclick="javascript:mapTest('button')">
				<input type="button" value='<egui:intnl text="admin.common.Remove"/>' class="eg_lightbutton" onclick="javascript:mapTest('button','remove')">
			</td>
		</tr>
	</table>
	</form>
</body>
</html>

