
Ext.define('EgMiscReports.controller.Main',{
	extend: 'Ext.app.Controller',
	views:['Main','EmptyPanel','Print'],
	refs:[
		{selector:'main', ref:'main'}
	],
	init:function()
	{
		this.buildMainData();
		this.control({
			'main':
			{
				'afterrender': this.loadMain
			},
			'main button[id="printUserInfo"]':
			{
				'click':this.printUserInfo
			}
		})
	},
	printUserInfo : function()
	{
		var printPage = "/final/admin/EgCommonPrintPage.jsp?flag=0&from=EgMiscReports";
		Ext.widget('print').show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set(
		{
			src :  printPage
		});
	},
	buildMainData : function()
	{
		var defaultUrl = 'EgMiscReports/data/EgMiscReportsJson.jsp?flag=0&reqfrom=navlink&date='+new Date().getTime();
		Ext.Ajax.request({
			url : defaultUrl,
			async: false,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	loadMain: function()
	{
		var userdetails = Ext.getCmp('userdetails');
		var userRawData = publicJSON['ExpiryUsers'];
		if (userRawData != null && !Ext.isEmpty(userRawData))
		{
			var gridColumns = publicJSON['gridColumns'];
			var cols = userdetails.columns.length;
			for (var i = 0;i<cols;i++)
			{
				userdetails.columns[i].setText(gridColumns[i]);
			}
			Ext.getCmp('emptypanel').hide();
			userdetails.show();
			userdetails.getStore().loadRawData(userRawData);
			Ext.getCmp('printUserInfo').setDisabled(false);
		}
		else
		{
			Ext.getCmp('emptypanel').show();
			userdetails.hide();
			Ext.getCmp('printUserInfo').setDisabled(true);
		}
	}
});



