Ext.define('EgMiscReports.view.Main',{
	extend:'Ext.form.Panel',
	alias:'widget.main',
	id:'expiryusers',
	cls:'outerpanel',
	title : pageTitle2,
	margin: '8 8 0 8',

	requires : [
		'EgMiscReports.view.EmptyPanel',
		'utilities.CustomGrid'
	],

	layout: {
		type: 'vbox',
		align:'stretch'
	},

	tools : [
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			items: [{
				xtype: 'button',
				iconCls: 'iconPrinter',
				id: 'printUserInfo',
				//tooltip: '<b>Print</b>',
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Print'
						});
					}
				},
				style: {
					background: 'none',
					border: '0px'
				}
			}]
		}
	],

	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDescription2+'</center>',
			}
		]
	}],

	items:[
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			name: 'userdetails',
			id : 'userdetails',
			autoScroll: true,
			title : pageIntnl4,
			store: new Ext.data.Store({
				fields: ['User ID', 'User validity date','Number of days left'],
				data: []
			}),
			flex: 1,
			columns: [
				{
					dataIndex: 'User ID',
					header: 'User ID',
					flex:1
				},
				{
					dataIndex: 'User validity date',
					header: 'User validity date',
					flex:1,
					doSort: function(state) {
						var ds = this.up('tablepanel').store;
						var field = this.getSortParam();
						customDateSorting(ds,state,field,userDateFormat);
						Ext.getCmp('userdetails').getView().refresh();
						var cssClassName = "x-column-header-sort-"+state;
						this.addCls(cssClassName);
					}
				},
				{
					dataIndex: 'Number of days left',
					header: 'Number of days left',
					flex: 1
				}
			],
			hideHeaders: false,
			margin: 10
		},
		{
			xtype : 'emptypanel',
			id : 'emptypanel',
			border : false,
			hidden : true
		}
	]

});



