//var retrieveDataObj='yes';
var me = this;
Ext.define('EgMonitorSettings.controller.Main',{
	extend:'Ext.app.Controller',
	views:['SettingList','Alarms','Graphs','OtherDisplaySettings','ConfiguredMeasures','NewMeasure','Viewport','UEDConfiguredMeasures','UEDModifyMeasure','UEDNewMeasure','UEDOtherDisplaySettings'],
	refs:[
		{selector:'settinglist', ref:'settinglist'},
		{selector:'main', ref:'main'},
		{selector:'refresh', ref:'refresh'},
		{selector:'alarms', ref:'alarms'},
		{selector:'graphs', ref:'graphs'},
		{selector:'otherdisplaysettings', ref:'otherdisplaysettings'},
		{selector:'newmeasure', ref:'newmeasure'},
		{selector:'configuredmeasures', ref:'configuredmeasures'},
		{selector:'viewport', ref:'viewport'},
	],

	init: function()
	{
		this.control({
			'viewport':
			{
				'afterrender': this.afterMainRender
			},
			'settinglist':
			{
				'itemclick': this.onClickData
			},
			'alarms button[id="alarmUpdateBtn"]':
			{
				'click': this.alarmsUpdate
			},
			'graphs button[id="graphsUpdateBtn"]':
			{
				'click': this.graphsUpdate
			},
			'otherdisplaysettings button[id="otherSetUpdateBtn"]':
			{
				'click': this.otherSetUpdate
			},
			'viewport button[id="tbarEnableId"]':
			{
				'click': this.enableOrDisableMetrics
			},
			'viewport button[id="tbarAddId"]':
			{
				'click': this.addNewMeasure
			},
			'configuredmeasures combo[id="viewTestsId"]':
			{
				'select': this.viewTestsComboChange
			},
			'configuredmeasures actioncolumn[id="deleteMetrics"]':
			{
				'click': this.deleteMetrics
			},
			'configuredmeasures grid[id="mainGrid"]':
			{
				//'itemmouseenter': this.onGridEnter,
				//'itemmouseleave': this.onGridLeave
			},
			'newmeasure combo[id="testnameId"]':
			{
				'select': this.testComboChange
			},
			'newmeasure button[id="measuresAddBtn"]':
			{
				'click': this.measuresAdd
			},
			'uedconfiguredmeasures combo[id="uedUserTypeId"]':
			{
				'select': this.userTypeUEDComboChange
			},
			'uedconfiguredmeasures actioncolumn[id="uedModifyMetrics"]':
			{
				'click': this.modifyUEDMetrics
			},
			'uedconfiguredmeasures actioncolumn[id="uedDeleteMetrics"]':
			{
				'click': this.deleteUEDMetrics
			},
			'uednewmeasure combo[id="userTypeId"]':
			{
				'select': this.loadUEDTests
			},
			'uednewmeasure combo[id="testnameId"]':
			{
				'select': this.loadUEDMeasureForTest
			},
			'uednewmeasure radiogroup[id="tableData"]':
			{
				'change':this.loadUEDTests
			},
			'uednewmeasure combo[id="measureid"]':
			{
				'select': this.loadUEDMeasureDisplay
			},
			'uednewmeasure combo[id="processId"]':
			{
				'select': this.loadUEDProcessDisplay
			},
			'viewport button[id="tbarUEdAddId"]':
			{
				'click': this.addUEDNewMetrics
			},
			'uednewmeasure button[id="uedmeasAddBtn"]':
			{
				'click': this.addUEDMeasures
			},
			'uedmodifymeasure button[id="modifyBtn"]':
			{
				'click': this.modifyUEDMeasures
			},
			'uedotherdisplaysettings button[id="UEDUpdateBtn"]':
			{
				'click': this.updateUEDSettings
			},
			'uedotherdisplaysettings textfield[id=addUedLimit]' : {
				specialkey: function(field, e){
					if (e.getKey() == e.ENTER) {
						this.addUedLimit();
					}
				}
			},
		});
	},

	afterMainRender: function()
	{
		Ext.getCmp('innerPanel').setTitle('ALARMS');

		var process = 'alarms';

		var tbarfillIdObj = Ext.getCmp('tbarfillId');
		var tbarEnableIdObj = Ext.getCmp('tbarEnableId');
		var tbarAddIdObj = Ext.getCmp('tbarAddId');

		var monitorSettingsTree = Ext.getCmp('monitorSetTreePanel');
		var selectedNodeID = 'alarmsId';

		var url = "/final/admin/EgMonitorSettings/data/eguiJSON.jsp?process="+process;

		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				//var mouseOver = jsonData.alarmsDataJson.mouse_over;
				var showAlarmPopup = jsonData.alarmsDataJson.show_alarm_popup;
				var maxPageItems = jsonData.alarmsDataJson.max_page_items;
				var noCurrAlarms = jsonData.alarmsDataJson.no_curr_alarms;

				/*if (mouseOver == 'TRUE')
				{
					Ext.getCmp('yesAlarmsID').setValue(mouseOver);
				}

				if (mouseOver == 'FALSE')
				{
					Ext.getCmp('noAlarmsID').setValue(mouseOver);
				}*/
				var nocurAlarmsObj = Ext.getCmp('nocurAlarms');

				if (showAlarmPopup == 'yes')
				{
					Ext.getCmp('yesAlarmsPopup').setValue(showAlarmPopup);
					nocurAlarmsObj.setVisible(true);
				}

				if (showAlarmPopup == 'no')
				{
					Ext.getCmp('noAlarmsPopup').setValue(showAlarmPopup);
				}

				if (noCurrAlarms == 'yes')
				{
					Ext.getCmp('nocurAlarmsyes').setValue(noCurrAlarms);
				}

				if (noCurrAlarms == 'no')
				{
					Ext.getCmp('nocurAlarmsno').setValue(noCurrAlarms);
				}

				Ext.getCmp('rowMultiplierID').setValue(maxPageItems);

				var record = monitorSettingsTree.getStore().getNodeById(selectedNodeID);
				monitorSettingsTree.getSelectionModel().select(record);

			}
		});
	},

	onClickData: function(me, record, item, index, e, eOpts)
	{
		var mainViewIdObj = Ext.getCmp('mainViewId');
		var innerMainPanelObj = Ext.getCmp('innerPanel');

		var tbarfillIdObj = Ext.getCmp('tbarfillId');
		var tbarEnableIdObj = Ext.getCmp('tbarEnableId');
		var tbarAddIdObj = Ext.getCmp('tbarAddId');

		var monitorSettingsTree = Ext.getCmp('monitorSetTreePanel');
		var selectedNodeID = '';

		if (index == '1')
		{
			//var docComp = Ext.getCmp('panelBarForConfig');
			//alert('docComp------------'+docComp);
			//docComp.hide();

			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'alarms' });

			Ext.getCmp('innerPanel').setTitle(alarmsMainTitle);

			Ext.getCmp('mainViewDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + monitorSettingsAlarmsDesc + '</center>');

			var process = 'alarms';

			var url = "/final/admin/EgMonitorSettings/data/eguiJSON.jsp?process="+process;

			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					//var mouseOver = jsonData.alarmsDataJson.mouse_over;
					var showAlarmPopup = jsonData.alarmsDataJson.show_alarm_popup;
					var maxPageItems = jsonData.alarmsDataJson.max_page_items;
					var noCurrAlarms = jsonData.alarmsDataJson.no_curr_alarms;

					/*if (mouseOver == 'TRUE')
					{
						Ext.getCmp('yesAlarmsID').setValue(mouseOver);
					}

					if (mouseOver == 'FALSE')
					{
						Ext.getCmp('noAlarmsID').setValue(mouseOver);
					}*/

					var nocurAlarmsObj = Ext.getCmp('nocurAlarms');
					if (showAlarmPopup == 'yes')
					{
						Ext.getCmp('yesAlarmsPopup').setValue(showAlarmPopup);
						nocurAlarmsObj.setVisible(true);
					}

					if (showAlarmPopup == 'no')
					{
						Ext.getCmp('noAlarmsPopup').setValue(showAlarmPopup);
					}

					if (noCurrAlarms == 'yes')
					{
						Ext.getCmp('nocurAlarmsyes').setValue(noCurrAlarms);
					}

					if (noCurrAlarms == 'no')
					{
						Ext.getCmp('nocurAlarmsno').setValue(noCurrAlarms);
					}

					Ext.getCmp('rowMultiplierID').setValue(maxPageItems);
				}
			});
		}
		if (index == '2')
		{
			//var docComp = Ext.getCmp('panelBarForConfig');
			//docComp.hide();

			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'graphs'});

			Ext.getCmp('innerPanel').setTitle(graphsMainTitle);

			Ext.getCmp('mainViewDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + monitorSettingsGraphsDesc + '</center>');

			var process = 'graphs';

			var url = "/final/admin/EgMonitorSettings/data/eguiJSON.jsp?process="+process;

			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

//					var monitor3d = jsonData.graphsDataJson.monitor_3d;
//					var reporter3d = jsonData.graphsDataJson.reporter_3d;
					var showNegatives = jsonData.graphsDataJson.show_negatives;
//					var gridOutline = jsonData.graphsDataJson.grid_outline_3d_on;
					var timelineForGraphs = jsonData.graphsDataArrayJson;
					var selTimelineForGraphs = jsonData.dataDisplayJson.dataDisplay;
					var timelineForDD = jsonData.detailedDiagnosisArrayJson;
					var selTimelineForDD = jsonData.ddDisplayJson.ddDisplay;
					var timescaleMonitor = jsonData.timeScaleMonitorJson.timeScaleMonitor;
					var timescaleReporter = jsonData.timeScaleReporterJson.timeScaleReporter;

//					if (monitor3d == 'TRUE')
//					{
//						Ext.getCmp('yes3D_MONITOR').setValue(monitor3d);
//					}
//
//					if (monitor3d == 'FALSE')
//					{
//						Ext.getCmp('no3D_MONITOR').setValue(monitor3d);
//					}

//					if (reporter3d == 'TRUE')
//					{
//						Ext.getCmp('yes3D_REPORTER').setValue(reporter3d);
//					}
//
//					if (reporter3d == 'FALSE')
//					{
//						Ext.getCmp('no3D_REPORTER').setValue(reporter3d);
//					}

					if (showNegatives == 'TRUE')
					{
						Ext.getCmp('yesSHOW_NEGATIVES').setValue(true);
					}

					if (showNegatives == 'FALSE')
					{
						Ext.getCmp('noSHOW_NEGATIVES').setValue(true);
					}

//					if (gridOutline == 'True')
//					{
//						Ext.getCmp('yesGRID_OUTLINE_3D_ON').setValue(gridOutline);
//					}
//
//					if (gridOutline == 'False')
//					{
//						Ext.getCmp('noGRID_OUTLINE_3D_ON').setValue(gridOutline);
//					}

					Ext.getCmp('GRAPHS$DATA_DISPLAY').getStore().loadRawData(timelineForGraphs);
					Ext.getCmp('GRAPHS$DATA_DISPLAY').setValue(timelineForGraphs[0].displayField);

					if (!Ext.isEmpty(selTimelineForGraphs))
					{
						Ext.getCmp('GRAPHS$DATA_DISPLAY').setValue(selTimelineForGraphs);
					}
					else
					{
						Ext.getCmp('GRAPHS$DATA_DISPLAY').setValue(timelineForGraphs[0].displayField);
					}

					Ext.getCmp('GRAPHS$DD_DISPLAY').getStore().loadRawData(timelineForDD);
					Ext.getCmp('GRAPHS$DD_DISPLAY').setValue(timelineForDD[0].displayField);

					if (!Ext.isEmpty(selTimelineForDD))
					{
						Ext.getCmp('GRAPHS$DD_DISPLAY').setValue(selTimelineForDD);
					}
					else
					{
						Ext.getCmp('GRAPHS$DD_DISPLAY').setValue(timelineForDD[0].displayField);
					}

					Ext.getCmp('GRAPHS$TIMESCALE_MONITOR').setValue(timescaleMonitor);
					Ext.getCmp('GRAPHS$TIMESCALE_REPORTER').setValue(timescaleReporter);
				}
			});
		}
		if (index == '3')
		{
			//var docComp = Ext.getCmp('panelBarForConfig');
			//docComp.hide();

			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'otherdisplaysettings'});

			Ext.getCmp('innerPanel').setTitle(otherSetMainTitle);

			Ext.getCmp('mainViewDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + otherDisplaySettingsDesc + '</center>');

			var process = 'othersettings';

			var url = "/final/admin/EgMonitorSettings/data/eguiJSON.jsp?process="+process;

			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var refreshDefault = jsonData.refreshDataJson.defaultt;

					var iMapSettings = jsonData.otherSettingsJson.iMapSettings;
					var eventduration = jsonData.eventDurationArrayJson;
					var selectedEventDuration = jsonData.otherSettingsJson.eventduration;

					var aggregateComp = jsonData.aggregateCompArrayJson;
					var selectedAggregateComp = jsonData.otherSettingsJson.aggregateComp;

					var sortpercount = jsonData.sortPerCountArrayJson;
					var selectedSortPerCount = jsonData.otherSettingsJson.sortpercount;

					var no_of_servers = jsonData.otherSettingsJson.no_of_servers;
					var display_comp_type = jsonData.otherSettingsJson.display_comp_type;

					var component = jsonData.otherSettingsJson.component;
					var Segment = jsonData.otherSettingsJson.Segment;
					var serviceGroup = jsonData.otherSettingsJson.serviceGroup;

					var Service = jsonData.otherSettingsJson.Service;
					var expand = jsonData.otherSettingsJson.expand;
					//var enable = jsonData.otherSettingsJson.enable;

					var show_segment = jsonData.otherSettingsJson.show_segment;
					var show_component = jsonData.otherSettingsJson.show_component;
					var optionalSegmentList = jsonData.otherSettingsJson.optionalSegmentList;

					var optionalServiceList = jsonData.otherSettingsJson.optionalServiceList;

					var optionalZoneList = jsonData.otherSettingsJson.optionalZoneList;

					var dateFormatArray = jsonData.dateFormatForOtherSetArrayJson;

					var selectedDateFormat = jsonData.otherSettingsJson.selectedDateFormat;

					var selectedTimeZoneFormat = jsonData.otherSettingsJson.selectedTimezoneFormat;

					var timeZoneArray = jsonData.timeZoneForOtherSetArrayJson;

					var countryNameArray = jsonData.countryNamForOtherSetArrayJson;
					var selectedCountryName = jsonData.otherSettingsJson.defaultLanguage;

					var defaultLanguageArray = jsonData.defaultLanguageJson;

					var problemActionArray = jsonData.problemActionArrayJson;
					var selectedProblemAction = jsonData.otherSettingsJson.show_problematic_measure;

					var defaultSearchOptionArray = jsonData.defaultSearchOptionForOtherSetArrayJson;
					var selectedDefaultSearchOption=jsonData.otherSettingsJson.selectedDefaultSearchOption;
					//var exhaustedAlert = jsonData.otherSettingsJson.tmpAlert;

					var showSubZoneAsTreeNode = jsonData.otherSettingsJson.showSubZoneAsTreeNode;
					Ext.getCmp('refreshID').setValue(refreshDefault);
					Ext.getCmp('googleMapKey').setValue(iMapSettings);
					Ext.getCmp('componentsCount').setValue(no_of_servers);

					Ext.getCmp('reporterDaywiseDistributionId').getStore().loadRawData(eventduration);

					if (!Ext.isEmpty(selectedEventDuration))
					{
						Ext.getCmp('reporterDaywiseDistributionId').setValue(selectedEventDuration);
					}
					else
					{
						Ext.getCmp('reporterDaywiseDistributionId').setValue(eventduration[0].displayField);
					}

					var userSearchTimeline=jsonData.otherSettingsJson.usersearchtimeline;
					var userSearchTimelineArray=jsonData.userSaerchArrayJson;
					
					Ext.getCmp('userSearchTimelineId').getStore().loadRawData(userSearchTimelineArray);

					if (!Ext.isEmpty(userSearchTimeline))
					{
						Ext.getCmp('userSearchTimelineId').setValue(userSearchTimeline);
					}
					else
					{
						if (userSearchTimelineArray.length > 0)
						{
							Ext.getCmp('userSearchTimelineId').setValue(userSearchTimelineArray[0].displayField);
						}
						else
						{
							Ext.getCmp('userSearchTimelineId').hide();
						}
					}

					Ext.getCmp('aggregateCompView').getStore().loadRawData(aggregateComp);

					if (!Ext.isEmpty(selectedAggregateComp))
					{
						Ext.getCmp('aggregateCompView').setValue(selectedAggregateComp);
					}
					else
					{
						if (aggregateComp.length > 0)
						{
							Ext.getCmp('aggregateCompView').setValue(aggregateComp[0].displayField);
						}
						else
						{
							Ext.getCmp('aggregateCompView').hide();
						}
					}

					Ext.getCmp('sortCompInDash').getStore().loadRawData(sortpercount);

					if (selectedSortPerCount == 'TRUE' || selectedSortPerCount == 'True')
					{
						selectedSortPerCount = 'True';
					}
					if (!Ext.isEmpty(selectedSortPerCount))
					{
						Ext.getCmp('sortCompInDash').setValue(selectedSortPerCount);
					}
					else
					{
						Ext.getCmp('sortCompInDash').setValue(sortpercount[0].displayField);
					}

					Ext.getCmp('dateFormat').getStore().loadRawData(dateFormatArray);
					if (!Ext.isEmpty(selectedSortPerCount))
					{
						Ext.getCmp('dateFormat').setValue(selectedDateFormat);
					}
					else
					{
						Ext.getCmp('dateFormat').setValue(dateFormatArray[0].displayField);
					}

					Ext.getCmp('defaultLanguage').getStore().loadRawData(countryNameArray);
					if (!Ext.isEmpty(selectedCountryName))
					{
						Ext.getCmp('defaultLanguage').setValue(selectedCountryName);
					}
					else
					{
						Ext.getCmp('defaultLanguage').setValue(countryNameArray[0].displayField);
					}

					Ext.getCmp('problemAction').getStore().loadRawData(problemActionArray);
					if (!Ext.isEmpty(selectedProblemAction))
					{
						Ext.getCmp('problemAction').setValue(selectedProblemAction);
					}
					else
					{
						Ext.getCmp('problemAction').setValue(problemActionArray[0].displayField);
					}

					
					Ext.getCmp('defaultSearchOption').getStore().loadRawData(defaultSearchOptionArray);
					if (!Ext.isEmpty(selectedDefaultSearchOption))
					{
						Ext.getCmp('defaultSearchOption').setValue(selectedDefaultSearchOption);
					}
					else
					{
						Ext.getCmp('defaultSearchOption').setValue(defaultSearchOption[0].displayField);
					}

					if (display_comp_type == 'true' || display_comp_type == 'True')
					{
						Ext.getCmp('yesSERVER_DISP_DETAILS$DISPLAY_COMP_TYPE').setValue('True');
					}

					if (display_comp_type == 'false' || display_comp_type == 'False')
					{
						Ext.getCmp('noSERVER_DISP_DETAILS$DISPLAY_COMP_TYPE').setValue('False');
					}

					if (component == 'True')
					{
						Ext.getCmp('yesSHOW_IMAGE$Component').setValue('True');
					}

					if (component == 'False')
					{
						Ext.getCmp('noSHOW_IMAGE$Component').setValue('False');
					}

					if (Segment == 'True')
					{
						Ext.getCmp('yesSHOW_IMAGE$Segment').setValue('True');
					}

					if (Segment == 'False')
					{
						Ext.getCmp('noSHOW_IMAGE$Segment').setValue('False');
					}

					if (serviceGroup == 'True')
					{
						Ext.getCmp('yesSHOW_IMAGE$serviceGroup').setValue('True');
					}

					if (serviceGroup == 'False')
					{
						Ext.getCmp('noSHOW_IMAGE$serviceGroup').setValue('False');
					}

					if (Service == 'True')
					{
						Ext.getCmp('yesSHOW_IMAGE$Service').setValue('True');
					}

					if (Service == 'False')
					{
						Ext.getCmp('yesSHOW_IMAGE$Service').setValue('False');
					}

					if (expand == 'True')
					{
						Ext.getCmp('yesALLOW_INFO_EXPANDING$expand').setValue('True');
					}

					if (expand == 'False')
					{
						Ext.getCmp('noALLOW_INFO_EXPANDING$expand').setValue('False');
					}

					/*if (enable == 'True')
					{
						Ext.getCmp('yesLICENSE_EXPIRY_ALERT$enable').setValue('True');
					}

					if (enable == 'False')
					{
						Ext.getCmp('noLICENSE_EXPIRY_ALERT$enable').setValue('False');
					}

					if (exhaustedAlert == 'True' || exhaustedAlert == 'true')
					{
						Ext.getCmp('yesLICENSE_COUNT_EXHAUSTED_ALERT').setValue('True');
					}

					if (exhaustedAlert == 'False' || exhaustedAlert == 'false')
					{
						Ext.getCmp('noLICENSE_COUNT_EXHAUSTED_ALERT').setValue('False');
					}*/

					if (show_segment == 'True')
					{
						Ext.getCmp('yesALLOW_INFO_EXPANDING$expand').setValue('True');
					}

					if (show_segment == 'False')
					{
						Ext.getCmp('yesSERVICE_LIST$show_segment').setValue('False');
					}

					if (show_component == 'True')
					{
						Ext.getCmp('yesSERVICE_LIST$show_component').setValue('True');
					}

					if (show_component == 'False')
					{
						Ext.getCmp('noSERVICE_LIST$show_component').setValue('False');
					}

					if (optionalSegmentList == 'True' || optionalSegmentList == 'true')
					{
						Ext.getCmp('yesOptionalList_Pages$segmentList').setValue('True');
					}

					if (optionalSegmentList == 'False' || optionalSegmentList == 'false')
					{
						Ext.getCmp('noOptionalList_Pages$segmentList').setValue('False');
					}

					if (optionalServiceList == 'True' || optionalServiceList == 'true')
					{
						Ext.getCmp('yesOptionalList_Pages$serviceList').setValue('True');
					}

					if (optionalServiceList == 'False' || optionalServiceList == 'false')
					{
						Ext.getCmp('noOptionalList_Pages$serviceList').setValue('False');
					}

					if (optionalZoneList == 'True' || optionalZoneList == 'true')
					{
						Ext.getCmp('yesOptionalList_Pages$zonelist').setValue('True');
					}

					if (optionalZoneList == 'False' || optionalZoneList == 'false')
					{
						Ext.getCmp('noOptionalList_Pages$zonelist').setValue('False');
					}

					if (!Ext.isEmpty(selectedTimeZoneFormat))
					{
						Ext.getCmp('timeFormat').setValue(selectedTimeZoneFormat);
					}
					else
					{
						Ext.getCmp('timeFormat').setValue('SHORT');
					}

					if (showSubZoneAsTreeNode == 'True' || showSubZoneAsTreeNode == 'true' || showSubZoneAsTreeNode == 'TRUE')
					{
						Ext.getCmp('yesMISC_ARGS$ShowSubZoneAsTreeNode').setValue('True');
					}

					if (showSubZoneAsTreeNode == 'False' || showSubZoneAsTreeNode == 'false' || showSubZoneAsTreeNode == 'FALSE')
					{
						Ext.getCmp('noMISC_ARGS$ShowSubZoneAsTreeNode').setValue('False');
					}

				}
			});
		}
		if (index == '5')
		{
			var computeTopMetricsOptions = '';

			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'configuredmeasures'});

			//var docComp = Ext.getCmp('panelBarForConfig');
			//docComp.show();

			Ext.getCmp('innerPanel').setTitle('CONFIGURED MEASURES');
			Ext.getCmp('mainViewDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + configMeasuresDesc + '</center>');

			var process = 'AllMeasures';

			var url = "/final/admin/EgMonitorSettings/data/minmaxConfigJSON.jsp?index=main&process="+process;

			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					computeTopMetricsOptions = jsonData.enableorDisableMetricsJson.minmaxEnabled;

					if (computeTopMetricsOptions == 'true' || computeTopMetricsOptions)
					{
						meadis = "NO";
						Ext.getCmp('tbarEnableId').setText('Disable Metrics Computation');
					}

					if (computeTopMetricsOptions == 'false' || !computeTopMetricsOptions)
					{
						meadis = "YES";
						Ext.getCmp('tbarEnableId').setText('Enable Metrics Computation');

						Ext.getCmp('viewTestsId').setDisabled(true);
						Ext.getCmp('tbarAddId').setDisabled(true);
					}

					var viewStoreObj = Ext.getCmp('mainGrid');

					var testNameObj = Ext.getCmp('viewTestsId');

					viewStoreObj.show();
					viewStoreObj.getStore().loadRawData(jsonData.configMeasuresArrayJson);
	
					if (Ext.isEmpty(jsonData.testArrayJson))
					{
						viewStoreObj.getStore().loadRawData('');
						testNameObj.setValue('Not Applicable');
						Ext.get('emptyTextDiv').update(alertForEnableMetricsComp);
					}
					else
					{

						testNameObj.getStore().loadRawData(jsonData.testArrayJson);
						testNameObj.setValue(jsonData.testArrayJson[0].displayField);
						viewStoreObj.getStore().loadRawData(jsonData.configMeasuresArrayJson);
					}
				}
			});
		}
		if (index == '7')
		{
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'uedconfiguredmeasures'});

			Ext.getCmp('innerPanel').setTitle('CONFIGURED MEASURES');
			Ext.getCmp('mainViewDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + uedConfigMeasuresDesc + '</center>');

			var process = 'ShowAllMeasures';
			var userTypeVal = Ext.getCmp('uedUserTypeId').getValue();

			if (userTypeVal == null || userTypeVal == undefined )
				userTypeVal='AllUserTypes';

			var url = "/final/admin/EgMonitorSettings/data/uedConfigJSON.jsp?index=main&process="+process+"&user_type="+userTypeVal;

			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var viewStoreObj = Ext.getCmp('mainGrid');
					var userTypeObj = Ext.getCmp('uedUserTypeId');

					viewStoreObj.show();
					viewStoreObj.getStore().loadRawData(jsonData.configMeasuresArrayJson);
	
					if (Ext.isEmpty(jsonData.testArrayJson))
					{
						viewStoreObj.getStore().loadRawData('');
						userTypeObj.setValue('Not Applicable');
						Ext.get('emptyTextDiv').update(alertForEnableMetricsComp);
					}
					else
					{
						userTypeObj.getStore().loadRawData(jsonData.testArrayJson);
						userTypeObj.setValue(jsonData.testArrayJson[0].valueField);
						viewStoreObj.getStore().loadRawData(jsonData.configMeasuresArrayJson);
					}
				}
			});
		}
		if (index == '8')
		{
			innerMainPanelObj.removeAll();
			innerMainPanelObj.add({ xtype: 'uedotherdisplaysettings'});

			Ext.getCmp('innerPanel').setTitle('OTHER DISPLAY SETTINGS');
			Ext.getCmp('mainViewDesc').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + uedotherDisplaySettingsDesc + '</center>');


			var process = 'uedOtherSettings';

			var url = "/final/admin/EgMonitorSettings/data/uedConfigJSON.jsp?process="+process;

			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var limits = jsonData.limitsJson.limitsArrayJson;
					var defaultLimit = jsonData.limitsJson.limitsDefaultJson;

					var dslimits = jsonData.dsLimitsJson.dslimitsArrayJson;
					var dsdefaultLimit = jsonData.dsLimitsJson.dslimitsDefaultJson;

					Ext.getCmp('limitId').getStore().loadRawData(limits);
					Ext.getCmp('limitId').setValue(defaultLimit);

					Ext.getCmp('dslimitId').getStore().loadRawData(dslimits);
					Ext.getCmp('dslimitId').setValue(dsdefaultLimit);

					var refreshFrequency = jsonData.refreshFrequencyJson.refreshFrequency;
					Ext.getCmp('refreshFreqId').setValue(refreshFrequency);

					/*var retrieveData = jsonData.retrieveDataFromDBJson.retrieveDataFromDB;
					if (retrieveData == 'true')
					{
						Ext.getCmp('yes_retrieveId').setValue('yes');
						retrieveDataObj='yes';
					}

					if (retrieveData == 'false')
					{
						Ext.getCmp('no_retrieveId').setValue('no');
						retrieveDataObj='no';
					}*/
					
					var enableAdGroup = jsonData.enableAdGroupJson;
					var defaultADGroup = jsonData.defaultADGroupJson.defaultADGroup;
					if (!Ext.isEmpty(enableAdGroup))
					{
						Ext.getCmp('adGroupId').getStore().loadRawData(enableAdGroup);
					}
					if (Ext.isEmpty(defaultADGroup))
					{
						Ext.getCmp('adGroupId').setValue('None');
					}
					else
					{
						Ext.getCmp('adGroupId').setValue(defaultADGroup);
					}

					if(!Ext.isEmpty(jsonData.asUsrTypeJson) && jsonData.asUsrTypeJson!=undefined && jsonData.asUsrTypeJson!=null)
					{
						var userTypes = jsonData.asUsrTypeJson.asUsrTypeArr;
						var uSelectedType = jsonData.asUsrTypeJson.adSearchSelectedType;

						Ext.getCmp('searchUserTypeId').getStore().loadRawData(userTypes);
						Ext.getCmp('searchUserTypeId').setValue(uSelectedType);

						var adSearchColumns = jsonData.asUsrTypeMulJson;
						var adSearchSelectedVal = jsonData.adSearchSelectedVal;

						if (!Ext.isEmpty(adSearchColumns))
						{
							Ext.getCmp('searchUserTypeMulId').getStore().loadRawData(adSearchColumns);
						}
						if (Ext.isEmpty(adSearchSelectedVal))
							Ext.getCmp('searchUserTypeMulId').setValue('None');
						else
							Ext.getCmp('searchUserTypeMulId').setValue(adSearchSelectedVal);
					}
				}
			});

		}
	},

	alarmsUpdate: function()
	{
		/*var mouseOverhiddenField = new Ext.form.field.Hidden({
			xtype: 'hidden',
			id: '$_ALARMS$MOUSE_OVERID',
			name: '$_ALARMS$MOUSE_OVER',
		});
		Ext.getCmp('generalPanel').add(mouseOverhiddenField);*/

		var alarmPopuphiddenField = new Ext.form.field.Hidden({
			xtype: 'hidden',
			id: '$_HIDE_ALARM_POPUP$alarm_popup',
			name: '$_HIDE_ALARM_POPUP$alarm_popup',
		});
		Ext.getCmp('generalPanel').add(alarmPopuphiddenField);

		var rowsHiddenField = new Ext.form.field.Hidden({
			xtype: 'hidden',
			id: '$_ALARMS$Row_Multiplier',
			name: '$_ALARMS$Row_Multiplier',
		});
		Ext.getCmp('generalPanel').add(rowsHiddenField);
		
		var closeAlarmhiddenField = new Ext.form.field.Hidden({
			xtype: 'hidden',
			id: '$_HIDE_ALARM_POPUP$no_curr_alarms',
			name: '$_HIDE_ALARM_POPUP$no_curr_alarms',
		});
		Ext.getCmp('generalPanel').add(closeAlarmhiddenField);

		var rowMultiplier = Ext.getCmp('rowMultiplierID').getValue();

		var mouseOverStr = '';
		var alarmsPopupStr = '';
		var nocurAlarmsStr = '';
		var validFlag = 'true';

		/*var yesmouseOverObj = Ext.getCmp('yesAlarmsID');
		var nomouseOverObj = Ext.getCmp('noAlarmsID');*/

		var process = 'alarms';

		var url = "/final/admin/EgMonitorSettings/data/eguiJSON.jsp?process="+process;

		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				//var mouseOver = jsonData.alarmsDataJson.mouse_over;
				var showAlarmPopup = jsonData.alarmsDataJson.show_alarm_popup;
				var noCurrAlarms = jsonData.alarmsDataJson.no_curr_alarms;
				var maxPageItems = jsonData.alarmsDataJson.max_page_items;

				/*if (mouseOver == 'TRUE' || mouseOver == 'True' || mouseOver == 'true')
				{
					mouseOverStr = 'Mouse over in alarm page$True';
				}

				if (mouseOver == 'FALSE' || mouseOver == 'False' || mouseOver == 'false')
				{
					mouseOverStr = 'Mouse over in alarm page$False';
				}
				mouseOverhiddenField.setValue(mouseOverStr);*/

				var yesAlarmsPopupObj = Ext.getCmp('yesAlarmsPopup');
				var noAlarmsPopupObj = Ext.getCmp('noAlarmsPopup');

				if (showAlarmPopup == 'yes' || showAlarmPopup == 'Yes' || showAlarmPopup == 'YES')
				{
					alarmsPopupStr = 'Alarm popup$True';
				}

				if (showAlarmPopup == 'no' || showAlarmPopup == 'No' || showAlarmPopup == 'NO')
				{
					alarmsPopupStr = 'Alarm popup$False';
				}
				alarmPopuphiddenField.setValue(alarmsPopupStr);


				var nocurAlarmsObj = Ext.getCmp('nocurAlarms');
				var nocurAlarmsObj = Ext.getCmp('nocurAlarms');

				if (noCurrAlarms == 'yes' || noCurrAlarms == 'Yes' || noCurrAlarms == 'YES')
				{
					nocurAlarmsStr = 'CurrAlarms$True';
				}

				if (noCurrAlarms == 'no' || noCurrAlarms == 'No' || noCurrAlarms == 'NO')
				{
					nocurAlarmsStr = 'CurrAlarms$False';
				}
				closeAlarmhiddenField.setValue(nocurAlarmsStr);



				var rowmultiplierStr = 'Number of rows to be displayed in alarm page$'+maxPageItems;
				rowsHiddenField.setValue(rowmultiplierStr);

				var rowMultiplierValid = validateTextBoxes('alarms', 'noOfRows', rowMultiplier);

				if (rowMultiplierValid == 'false')
				{
					Ext.Msg.show({
						title: alarmsTitle,
						msg: alertForAlarmRows,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});

					validFlag = 'false';
				}

				var alarmSettingsForm = this.getAlarms().getForm();

				if (validFlag == 'true')
				{
					if (alarmSettingsForm.isValid())
					{
						alarmSettingsForm.submit({
							url: '/final/admin/EgMonitorSettings/data/eguiJSONp.jsp?process=alarms',
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: alarmsTitle,
									msg: updateSuccess,
									width: 400,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								Ext.Msg.show({
									title: alarmsTitle,
									msg: updateNotSuccess,
									width: 400,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
							}
						});
					}
					else
					{
						Ext.Msg.show({
							title: alarmsTitle,
							msg: updateNotSuccess,
							width: 400,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
				}
			}
		});
	},

	graphsUpdate: function()
	{
//		var monitorhiddenField = new Ext.form.field.Hidden({
//			xtype: 'hidden',
//			id: '$_GRAPHS$3D_MONITORID',
//			name: '$_GRAPHS$3D_MONITOR',
//		});
//		Ext.getCmp('generalPanel').add(monitorhiddenField);
//
//		var reporterhiddenField = new Ext.form.field.Hidden({
//			xtype: 'hidden',
//			id: '$_GRAPHS$3D_REPORTERID',
//			name: '$_GRAPHS$3D_REPORTER',
//		});
//		Ext.getCmp('generalPanel').add(reporterhiddenField);
//
		var showNegativesHiddenField = new Ext.form.field.Hidden({
			xtype: 'hidden',
			id: '$_GRAPHS$SHOW_NEGATIVESID',
			name: '$_GRAPHS$SHOW_NEGATIVES',
		});
		Ext.getCmp('generalPanel').add(showNegativesHiddenField);
//
//		var gridOutlineHiddenField = new Ext.form.field.Hidden({
//			xtype: 'hidden',
//			id: '$_GRAPHS$GRID_OUTLINE_3D_ONID',
//			name: '$_GRAPHS$GRID_OUTLINE_3D_ON',
//		});
//		Ext.getCmp('generalPanel').add(gridOutlineHiddenField);

		var dataDisplayHiddenField = new Ext.form.field.Hidden({
			xtype: 'hidden',
			id: '$_GRAPHS$DATA_DISPLAYID',
			name: '$_GRAPHS$DATA_DISPLAY',
		});
		Ext.getCmp('generalPanel').add(dataDisplayHiddenField);

		var ddDisplayHiddenField = new Ext.form.field.Hidden({
			xtype: 'hidden',
			id: '$_GRAPHS$DD_DISPLAYID',
			name: '$_GRAPHS$DD_DISPLAY',
		});
		Ext.getCmp('generalPanel').add(ddDisplayHiddenField);

		var timescaleMonitorHiddenField = new Ext.form.field.Hidden({
			xtype: 'hidden',
			id: '$_GRAPHS$TIMESCALE_MONITORID',
			name: '$_GRAPHS$TIMESCALE_MONITOR',
		});
		Ext.getCmp('generalPanel').add(timescaleMonitorHiddenField);

		var timescaleReporterHiddenField = new Ext.form.field.Hidden({
			xtype: 'hidden',
			id: '$_GRAPHS$TIMESCALE_REPORTERID',
			name: '$_GRAPHS$TIMESCALE_REPORTER',
		});
		Ext.getCmp('generalPanel').add(timescaleReporterHiddenField);

		var timescaleMonitor = Ext.getCmp('GRAPHS$TIMESCALE_MONITOR').getValue();
		var timescaleReporter = Ext.getCmp('GRAPHS$TIMESCALE_REPORTER').getValue();

		var monitorStr = '';
		var reporterStr = '';
		var showNegativesStr = '';
		var gridOutlineStr = '';
		var dataDisplayStr = '';
		var ddDisplayStr = '';
		var timescaleMonitorStr = '';
		var timescaleReporterStr = '';
		var validFlag = 'true';

//		var monitorStr = '';
//		var yes3D_MONITORObj = Ext.getCmp('yes3D_MONITOR');
//		var no3D_MONITORObj = Ext.getCmp('no3D_MONITOR');

		var process = 'graphs';

		var url = "/final/admin/EgMonitorSettings/data/eguiJSON.jsp?process="+process;

		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

//				var monitor3d = jsonData.graphsDataJson.monitor_3d;
//				var reporter3d = jsonData.graphsDataJson.reporter_3d;
				var showNegatives = jsonData.graphsDataJson.show_negatives;
//				var gridOutline = jsonData.graphsDataJson.grid_outline_3d_on;
				var timelineForGraphs = jsonData.graphsDataArrayJson;
				var selTimelineForGraphs = jsonData.dataDisplayJson.dataDisplay;
				var timelineForDD = jsonData.detailedDiagnosisArrayJson;
				var selTimelineForDD = jsonData.ddDisplayJson.ddDisplay;
				var timescaleMonitorPrev = jsonData.timeScaleMonitorJson.timeScaleMonitor;
				var timescaleReporterPrev = jsonData.timeScaleReporterJson.timeScaleReporter;

//				if (monitor3d == 'TRUE')
//				{
//					monitorStr = 'Show monitor graphs in 3D$true';
//				}
//
//				if (monitor3d == 'FALSE')
//				{
//					monitorStr = 'Show monitor graphs in 3D$false';
//				}
//				monitorhiddenField.setValue(monitorStr);

//				var reporterStr = '';
//				var yes3D_REPORTERObj = Ext.getCmp('yes3D_REPORTER');
//				var no3D_REPORTERObj = Ext.getCmp('no3D_REPORTER');

//				if (reporter3d == 'TRUE')
//				{
//					reporterStr = 'Show reporter graphs in 3D$true';
//				}
//
//				if (reporter3d == 'FALSE')
//				{
//					reporterStr = 'Show reporter graphs in 3D$false';
//				}
//				reporterhiddenField.setValue(reporterStr);

				var showNegativesStr = '';
				var yesSHOW_NEGATIVESObj = Ext.getCmp('yesSHOW_NEGATIVES');
				var noSHOW_NEGATIVESObj = Ext.getCmp('noSHOW_NEGATIVES');

				if (showNegatives == 'TRUE')
				{
					showNegativesStr = 'Show negative values in graphs$true';
				}

				if (showNegatives == 'FALSE')
				{
					showNegativesStr = 'Show negative values in graphs$false';
				}
				showNegativesHiddenField.setValue(showNegativesStr);

//				var gridOutlineStr = '';
//				var yesGRID_OUTLINE_3D_ONObj = Ext.getCmp('yesGRID_OUTLINE_3D_ON');
//				var noGRID_OUTLINE_3D_ONObj = Ext.getCmp('noGRID_OUTLINE_3D_ON');

//				if (gridOutline == 'True')
//				{
//					gridOutlineStr = 'Use lines in 3D graph to show depth$true';
//				}
//
//				if (gridOutline == 'False')
//				{
//					gridOutlineStr = 'Use lines in 3D graph to show depth$false';
//				}
//				gridOutlineHiddenField.setValue(gridOutlineStr);

				var dataDisplay = Ext.getCmp('GRAPHS$DATA_DISPLAY').getValue();
				//dataDisplayStr = "Timeline for graphs (hours)$"+selTimelineForGraphs;
				dataDisplayStr = "Timeline for graphs in hours$"+selTimelineForGraphs;
				dataDisplayHiddenField.setValue(dataDisplayStr);

				var ddDisplay = Ext.getCmp('GRAPHS$DD_DISPLAY').getValue();
				//ddDisplayStr = "Timeline for detailed diagnosis (hours)$"+selTimelineForDD;
				ddDisplayStr = "Timeline for detailed diagnosis in hours$"+selTimelineForDD;
				ddDisplayHiddenField.setValue(ddDisplayStr);

				timescaleMonitorStr = "Timescale monitor$"+timescaleMonitorPrev;
				timescaleMonitorHiddenField.setValue(timescaleMonitorStr);

				timescaleReporterStr = "Timescale reporter$"+timescaleReporterPrev;
				timescaleReporterHiddenField.setValue(timescaleReporterStr);

				var timescaleMonitorValid = validateTextBoxes('graphs', 'monitorTimeScale', timescaleMonitor);
				var timescaleReporterValid = validateTextBoxes('graphs', 'reporterTimeScale', timescaleReporter);

				if (timescaleMonitorValid == 'false' || timescaleMonitorValid == false)
				{
					Ext.Msg.show({
						title: graphsTitle,
						msg: alertForMonitorTimescale,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});

					validFlag = 'false';
				}

				if (timescaleReporterValid == 'false' || timescaleReporterValid == false)
				{
					Ext.Msg.show({
						title: graphsTitle,
						msg: alertForReporterTimescale,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});

					validFlag = 'false';
				}

				if (validFlag == 'true')
				{
					var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Processing...'});
					myMask.show();

					var graphSettingsForm = this.getGraphs().getForm();

					if (graphSettingsForm.isValid())
					{
						graphSettingsForm.submit({
						url: '/final/admin/EgMonitorSettings/data/eguiJSONp.jsp?process=graphs',
						method: 'POST',
						success: function(form, action){
							Ext.Msg.show({
								title: graphsTitle,
								msg: updateSuccess,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
							myMask.hide();
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.show({
								title: graphsTitle,
								msg: updateNotSuccess,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							myMask.hide();
						}
						});
					}
					else
					{
						myMask.hide();
						Ext.Msg.show({
							title: graphsTitle,
							msg: updateNotSuccess,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
				}
			}
		});
	},

	otherSetUpdate: function()
	{
		// The below has been included to reset the values on the local storage values for Monitor optional list screens when the settings is changed - Antony

		var noServiceListObj2= Ext.getCmp('noOptionalList_Pages$serviceList').getValue();
		var noZoneListObj2 = Ext.getCmp('noOptionalList_Pages$zonelist').getValue();
		var nosegmentListObj2 = Ext.getCmp('noOptionalList_Pages$segmentList').getValue();

		var validFlag = 'true';
		
		if(noZoneListObj2=='true'|| noZoneListObj2==true)
		{
			localStorage.setItem('optionallistpanel','2');
		}
		else if(noServiceListObj2=='true'|| noServiceListObj2==true)
		{
			localStorage.setItem('serviceoptionallistpanel','2');
		}
		else if(nosegmentListObj2=='true'|| nosegmentListObj2==true)
		{
			localStorage.setItem('segmentoptionallistpanel','2');
		}
		else
		{
			
			localStorage.setItem('optionallistpanel','1');
			localStorage.setItem('serviceoptionallistpanel','1');
			localStorage.setItem('segmentoptionallistpanel','1');
		}

		var refreshValue = Ext.getCmp('refreshID').getValue();

		var refreshHiddenId = Ext.getCmp('$_REFRESH$DefaultID');
		var defaultSearchHiddenId = Ext.getCmp('$_Search_Default_Selection$defaultID');
		var googleMapId = Ext.getCmp('ZONE_MAP$google_map_keyID');
		var eventDurationId = Ext.getCmp('$_REPORTER$EVENTDURATIONID');
		var userSearchTimeline = Ext.getCmp('SEARCH_DISPLAY$Timeline');
		var noOfServersId = Ext.getCmp('$_SERVER_DISP_DETAILS$NO_OF_SERVERSID');
		var aggregateCompId = Ext.getCmp('$_COMPONENT_METRIC_VIEW$AggregateCompID');
		var sortPerCountId = Ext.getCmp('$_SERVER_DISP_DETAILS$SORTPERCOUNTID');

		var hiddenTimezoneFormatId = Ext.getCmp('$_TIMEZONE_FORMAT$selectedTimezoneFormatID');
		var selectedDateFormatId = Ext.getCmp('$_CURRENT_DATE_FORMAT$selectedDateFormatID');
		var defaultLanguageId = Ext.getCmp('$_DEFAULT_LANGUAGE$defaultLanguageID');
		var problemMeasureId = Ext.getCmp('$_LayerModel_OpenMeasures$ProblematicMeasureID');
		var dispCompTypeId = 
		Ext.getCmp('$_SERVER_DISP_DETAILS$DISPLAY_COMP_TYPEID');
		var showImageCmpId = Ext.getCmp('$_SHOW_IMAGE$ComponentID');
		var showImageSegId = Ext.getCmp('$_SHOW_IMAGE$SegmentID');
		var showImageSerGrpId = Ext.getCmp('$_SHOW_IMAGE$serviceGroupID');

		var showImageServiceId = Ext.getCmp('$_SHOW_IMAGE$ServiceID');
		var expandId = Ext.getCmp('$_ALLOW_INFO_EXPANDING$expandID');
		//var licenseExpiryAlertId = Ext.getCmp('$_LICENSE_EXPIRY_ALERT$enableID');
		var showSegmentId = Ext.getCmp('$_SERVICE_LIST$show_segmentID');
		var showCmpId = Ext.getCmp('$_SERVICE_LIST$show_componentID');
		//var licenseExhaustedId = Ext.getCmp('$_MISC_ARGS$LICENSE_COUNT_EXHAUSTED_ALERT_ID');

		var segmentListId = Ext.getCmp('OptionalList_Pages$segmentList_ID');
		var serviceListId = Ext.getCmp('$OptionalList_Pages$serviceList_ID');
		var zoneListId = Ext.getCmp('$OptionalList_Pages$zonelist_ID');

		var hiddenSegmentListId = Ext.getCmp('$_OptionalList_Pages$segmentList_ID');
		var hiddenServiceListId = Ext.getCmp('$_OptionalList_Pages$serviceList_ID');
		var hiddenZoneListId = Ext.getCmp('$_OptionalList_Pages$zonelist_ID');

		var googleMapKey = Ext.getCmp('googleMapKey').getValue();
		var componentsCount = Ext.getCmp('componentsCount').getValue();
		var daywiseDistributions = Ext.getCmp('reporterDaywiseDistributionId').getValue();

		var aggregateCompView = Ext.getCmp('aggregateCompView').getValue();
		var sortCompInDash = Ext.getCmp('sortCompInDash').getValue();
		var dateFormat = Ext.getCmp('dateFormat').getValue();

		var defaultLanguage = Ext.getCmp('defaultLanguage').getValue();
		var problemAction = Ext.getCmp('problemAction').getValue();

		var yesDisCompInServicesObj = Ext.getCmp('yesSERVER_DISP_DETAILS$DISPLAY_COMP_TYPE');
		var noDisCompInServicesObj = Ext.getCmp('noSERVER_DISP_DETAILS$DISPLAY_COMP_TYPE');

		var yesShowImgInCompObj = Ext.getCmp('yesSHOW_IMAGE$Component');
		var noShowImgInCompObj = Ext.getCmp('noSHOW_IMAGE$Component');

		var yesShowImgInSegObj = Ext.getCmp('yesSHOW_IMAGE$Segment');
		var noShowImgInSegObj = Ext.getCmp('noSHOW_IMAGE$Segment');

		var yesShowImgInSerGrpObj = Ext.getCmp('yesSHOW_IMAGE$serviceGroup');
		var noShowImgInSerGrpObj = Ext.getCmp('noSHOW_IMAGE$serviceGroup');

		var yesShowImgInSerObj = Ext.getCmp('yesSHOW_IMAGE$Service');
		var noShowImgInSerObj = Ext.getCmp('noSHOW_IMAGE$Service');

		var yesShowDescForCompObj = Ext.getCmp('yesALLOW_INFO_EXPANDING$expand');
		var noShowDescForCompObj = Ext.getCmp('noALLOW_INFO_EXPANDING$expand');

		/*var yesLicenseExpiryAlertObj = Ext.getCmp('yesLICENSE_EXPIRY_ALERT$enable');
		var noLicenseExpiryAlertObj = Ext.getCmp('noLICENSE_EXPIRY_ALERT$enable');

		var yesExhaustedAlertObj = Ext.getCmp('yesLICENSE_COUNT_EXHAUSTED_ALERT');
		var noExhaustedAlertObj = Ext.getCmp('noLICENSE_COUNT_EXHAUSTED_ALERT');*/

		var yesShowSegInServicesObj = Ext.getCmp('yesSERVICE_LIST$show_segment');
		var noShowSegInServicesObj = Ext.getCmp('noSERVICE_LIST$show_segment');

		var yesShowCompInServicesObj = Ext.getCmp('yesSERVICE_LIST$show_component');
		var noShowCompInServicesObj = Ext.getCmp('noSERVICE_LIST$show_component');

		var yesSegmentListObj = Ext.getCmp('yesOptionalList_Pages$segmentList');
		var noSegmentListObj = Ext.getCmp('noOptionalList_Pages$segmentList');

		var yesServicesListObj = Ext.getCmp('yesOptionalList_Pages$serviceList');
		var noServicesListObj = Ext.getCmp('noOptionalList_Pages$serviceList');

		var yesZoneListObj = Ext.getCmp('yesOptionalList_Pages$zonelist');
		var noZoneListObj = Ext.getCmp('noOptionalList_Pages$zonelist');

		var subZoneId = Ext.getCmp('$MISC_ARGS$ShowSubZoneAsTreeNode_ID');

		var googleMapKeyStr = '';
		var componentsCountStr = '';
		var daywiseDistributionsStr = '';
		var userSearchTimelineStr = '';
		var aggregateCompViewStr = '';
		var sortCompInDashStr = '';
		var dateFormatStr = '';
		var defaultLanguageStr = '';
		var problemActionStr = '';
		var serverDispDetailsStr = '';

		var showCompImageStr = '';
		var showSegImageStr = '';
		var showServiceGroupImageStr = '';
		var showServiceImageStr = '';
		var showDescriptorsStr = '';

		//var showLicenseExpiryAlertStr = '';
		//var exhaustedAlertStr = '';
		var showSegInServicesStr = '';
		var showCompInServicesStr = '';

		var segmentListStr = '';
		var servicesListStr = '';
		var zonesListStr = '';
		var subZoneStr = '';

		var process = 'othersettings';

		var url = "/final/admin/EgMonitorSettings/data/eguiJSON.jsp?process="+process;

		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var refreshDefault = jsonData.refreshDataJson.defaultt;

				var iMapSettings = jsonData.otherSettingsJson.iMapSettings;
				var eventduration = jsonData.eventDurationArrayJson;
				var selectedEventDuration = jsonData.otherSettingsJson.eventduration;

				var aggregateComp = jsonData.aggregateCompArrayJson;
				var selectedAggregateComp = jsonData.otherSettingsJson.aggregateComp;

				var sortpercount = jsonData.sortPerCountArrayJson;
				var selectedSortPerCount = jsonData.otherSettingsJson.sortpercount;

				var no_of_servers = jsonData.otherSettingsJson.no_of_servers;
				var display_comp_type = jsonData.otherSettingsJson.display_comp_type;

				var component = jsonData.otherSettingsJson.component;
				var Segment = jsonData.otherSettingsJson.Segment;
				var serviceGroup = jsonData.otherSettingsJson.serviceGroup;

				var Service = jsonData.otherSettingsJson.Service;
				var expand = jsonData.otherSettingsJson.expand;
				//var enable = jsonData.otherSettingsJson.enable;

				var show_segment = jsonData.otherSettingsJson.show_segment;
				var show_component = jsonData.otherSettingsJson.show_component;
				var optionalSegmentList = jsonData.otherSettingsJson.optionalSegmentList;

				var optionalServiceList = jsonData.otherSettingsJson.optionalServiceList;

				var optionalZoneList = jsonData.otherSettingsJson.optionalZoneList;

				var dateFormatArray = jsonData.dateFormatForOtherSetArrayJson;

				var selectedDateFormat = jsonData.otherSettingsJson.selectedDateFormat;

				var selectedTimeZoneFormat = jsonData.otherSettingsJson.selectedTimezoneFormat;

				var timeZoneArray = jsonData.timeZoneForOtherSetArrayJson;

				var countryNameArray = jsonData.countryNamForOtherSetArrayJson;
				var selectedCountryName = jsonData.otherSettingsJson.defaultLanguage;

				var defaultLanguageArray = jsonData.defaultLanguageJson;

				var problemActionArray = jsonData.problemActionArrayJson;
				var selectedProblemAction = jsonData.otherSettingsJson.show_problematic_measure;

				var defaultSearchOptionArray = jsonData.defaultSearchOptionForOtherSetArrayJson;
				var selectedDefaultSearchOption=jsonData.otherSettingsJson.selectedDefaultSearchOption;

				var showSubZoneAsTreeNode = jsonData.otherSettingsJson.showSubZoneAsTreeNode;
				
				//var hiddenRefreshField = 'Default refresh frequency for monitor webpages (secs)$'+refreshDefault;
				var hiddenRefreshField = 'Default refresh frequency for monitor webpages in secs$'+refreshDefault;
				refreshHiddenId.setValue(hiddenRefreshField);
				defaultSearchHiddenId.setValue(Ext.getCmp('defaultSearchOption').value);
				
				//var exhaustedAlert = jsonData.otherSettingsJson.tmpAlert;

				googleMapKeyStr = 'Google map key$'+iMapSettings;
				googleMapId.setValue(googleMapKeyStr);

				daywiseDistributionsStr = 'Daywise distribution reports in$'+selectedEventDuration;
				eventDurationId.setValue(daywiseDistributionsStr);

				componentsCountStr = 'Components count in segment/service/zone list$'+no_of_servers;
				noOfServersId.setValue(componentsCountStr);

				aggregateCompViewStr = 'View for aggregate components$'+selectedAggregateComp;
				aggregateCompId.setValue(aggregateCompViewStr);

				sortCompInDashStr = 'Sort components in dashboards$'+selectedSortPerCount;
				sortPerCountId.setValue(sortCompInDashStr);

				timeZoneStr = 'Time zone format to be used$' + selectedTimeZoneFormat;
				hiddenTimezoneFormatId.setValue(timeZoneStr);

				dateFormatStr = 'Date format to be used$'+selectedDateFormat;
				selectedDateFormatId.setValue(dateFormatStr);

				defaultLanguageStr = 'Default language$'+defaultLanguage;
				defaultLanguageId.setValue(defaultLanguageStr);

				problemActionStr = 'When a problem component is clicked$'+problemAction;
				problemMeasureId.setValue(problemActionStr);

				if (display_comp_type == 'True' || display_comp_type == 'true')
				{
					serverDispDetailsStr = 'Display component types in segment/service list$True';
				}
				if (display_comp_type == 'False' || display_comp_type == 'false')
				{
					serverDispDetailsStr = 'Display component types in segment/service list$False';
				}
				dispCompTypeId.setValue(serverDispDetailsStr);

				if (component == 'True' || component == 'true')
				{
					showCompImageStr = 'Show icon for component type$True';
				}
				if (component == 'False' || component == 'false')
				{
					showCompImageStr = 'Show icon for component type$False';
				}
				showImageCmpId.setValue(showCompImageStr);

				if (Segment == 'True' || Segment == 'true')
				{
					showSegImageStr = 'Show icon for segment$True';
				}
				if (Segment == 'False' || Segment == 'false')
				{
					showSegImageStr = 'Show icon for segment$False';
				}
				showImageSegId.setValue(showSegImageStr);

				if (serviceGroup == 'True' || serviceGroup == 'true')
				{
					showServiceGroupImageStr = 'Show icon for serviceGroup$True';
				}
				if (serviceGroup == 'False' || serviceGroup == 'false')
				{
					showServiceGroupImageStr = 'Show icon for serviceGroup$False';
				}
				showImageSerGrpId.setValue(showServiceGroupImageStr);

				if (Service == 'True' || Service == 'true')
				{
					showServiceImageStr = 'Show icon for service$True';
				}
				if (Service == 'False' || Service == 'false')
				{
					showServiceImageStr = 'Show icon for service$False';
				}
				showImageServiceId.setValue(showServiceImageStr);

				if (expand == 'True' || expand == 'true')
				{
					showDescriptorsStr = 'Show all descriptors for a component$True';
				}
				if (expand == 'False' || expand == 'false')
				{
					showDescriptorsStr = 'Show all descriptors for a component$False';
				}
				expandId.setValue(showDescriptorsStr);

				/*if (enable == 'True' || enable == 'true')
				{
					showLicenseExpiryAlertStr = 'Show license expiry alert$True';
				}
				if (enable == 'False' || enable == 'false')
				{
					showLicenseExpiryAlertStr = 'Show license expiry alert$False';
				}
				licenseExpiryAlertId.setValue(showLicenseExpiryAlertStr);

				if (exhaustedAlert == 'True' || exhaustedAlert == 'true')
				{
					exhaustedAlertStr = 'Show alert when agent licenses are exhausted$True';
				}
				if (exhaustedAlert == 'False' || exhaustedAlert == 'false')
				{
					exhaustedAlertStr = 'Show alert when agent licenses are exhausted$False';
				}
				licenseExhaustedId.setValue(exhaustedAlertStr);*/

				if (show_segment == 'True' || show_segment == 'true')
				{
					//showSegInServicesStr = 'Show segment(s) in service list$True';
					showSegInServicesStr = 'Show segments in service list$True';
				}
				if (show_segment == 'False' || show_segment == 'false')
				{
					//showSegInServicesStr = 'Show segment(s) in service list$False';
					showSegInServicesStr = 'Show segments in service list$False';
				}
				showSegmentId.setValue(showSegInServicesStr);

				if (show_component == 'True' || show_component == 'true')
				{
					//showCompInServicesStr = 'Show component(s) in service list$True';
					showCompInServicesStr = 'Show components in service list$True';
				}
				if (show_component == 'False' || show_component == 'false')
				{
					//showCompInServicesStr = 'Show component(s) in service list$False';
					showCompInServicesStr = 'Show components in service list$False';
				}
				showCmpId.setValue(showCompInServicesStr);

				if (optionalSegmentList == 'True' || optionalSegmentList == 'true')
				{
					segmentListStr = 'Show optional segment list$True';
				}
				if (optionalSegmentList == 'False' || optionalSegmentList == 'false')
				{
					segmentListStr = 'Show optional segment list$False';
				}
				segmentListId.setValue(segmentListStr);
				hiddenSegmentListId.setValue(segmentListStr);

				if (optionalServiceList == 'True' || optionalServiceList == 'true')
				{
					servicesListStr = 'Show optional service list$True';
				}
				if (optionalServiceList == 'False' || optionalServiceList == 'false')
				{
					servicesListStr = 'Show optional service list$False';
				}
				serviceListId.setValue(servicesListStr);
				hiddenServiceListId.setValue(servicesListStr);

				if (optionalZoneList == 'True' || optionalZoneList == 'true')
				{
					zonesListStr = 'Show optional zone list$True';
				}
				if (optionalZoneList == 'False' || optionalZoneList == 'false')
				{
					zonesListStr = 'Show optional zone list$False';
				}

				if (showSubZoneAsTreeNode == 'True' || showSubZoneAsTreeNode == 'true' || showSubZoneAsTreeNode == 'TRUE')
				{
					subZoneStr = 'MISC_ARGS$ShowSubZoneAsTreeNode$True';
				}

				if (showSubZoneAsTreeNode == 'False' || showSubZoneAsTreeNode == 'false' || showSubZoneAsTreeNode == 'FALSE')
				{
					subZoneStr = 'MISC_ARGS$ShowSubZoneAsTreeNode$False';
				}
				subZoneId.setValue(subZoneStr);
				zoneListId.setValue(zonesListStr);
				hiddenZoneListId.setValue(zonesListStr);

				var defaultRefreshFreqValid = isAValidNumber(refreshValue);
				var defaultRefreshGreater = refreshValue < 30;
				var googleMapKeyValid = validateSingleByte(googleMapKey);
				var componentsCountValid = isAValidNumber(componentsCount);

				if (defaultRefreshFreqValid == 'false' || defaultRefreshFreqValid == false)
				{
					Ext.Msg.show({
						title: otherDisplaySettingsTitle,
						msg: alertForDefaultRefreshFreq,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});

					validFlag = 'false';
				}

				if (defaultRefreshGreater == 'true' || defaultRefreshGreater == true)
				{
					Ext.Msg.show({
						title: otherDisplaySettingsTitle,
						msg: alertForFreqGreater,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});

					validFlag = 'false';
				}

				if (googleMapKeyValid == 'false' || googleMapKeyValid == false)
				{
					Ext.Msg.show({
						title: otherDisplaySettingsTitle,
						msg: alertForMapKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});

					validFlag = 'false';
				}

				if (componentsCountValid == 'false' || componentsCountValid == false)
				{
					Ext.Msg.show({
						title: otherDisplaySettingsTitle,
						msg: alertForComponentsCount,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});

					validFlag = 'false';
				}

				var otherSettingsForm = this.getOtherdisplaysettings().getForm();

				if (validFlag == 'true')
				{
					var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Processing...'});
					myMask.show();

					if (otherSettingsForm.isValid())
					{
						otherSettingsForm.submit({
						url: '/final/admin/EgMonitorSettings/data/eguiJSONp.jsp?process=othersettings',
						method: 'POST',
						success: function(form, action){
							Ext.Msg.show({
								title: otherDisplaySettingsTitle,
								msg: updateSuccess,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
							myMask.hide();
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.show({
								title: otherDisplaySettingsTitle,
								msg: updateNotSuccess,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							myMask.hide();
						}
						});
					}
					else
					{
						myMask.hide();
						Ext.Msg.show({
							title: otherDisplaySettingsTitle,
							msg: updateNotSuccess,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
				}
			}
		});
	},

	enableOrDisableMetrics: function()
	{
		var process = 'enable/disable';
		var computeTopMetricsOptions = '';
		var meadis = '';
		var eitherEnableOrDisableAlert = '';

		var measuredisplay = "fromupdate";

		var viewTestsObj = Ext.getCmp('viewTestsId');
		var tbarAddIdObj = Ext.getCmp('tbarAddId');
		var tbarEnableIdObj = Ext.getCmp('tbarEnableId');

		var url = "/final/admin/EgMonitorSettings/data/minmaxConfigJSON.jsp?index=main&process="+process;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					computeTopMetricsOptions = jsonData.enableorDisableMetricsJson.minmaxEnabled;

					if (computeTopMetricsOptions == 'true' || computeTopMetricsOptions)
					{
						meadis = "NO";
						eitherEnableOrDisableAlert = alertDisableMetrics;
					}

					if (computeTopMetricsOptions == 'false' || !computeTopMetricsOptions)
					{
						meadis = "YES";
						eitherEnableOrDisableAlert = alertEnableMetrics;
					}

					Ext.MessageBox.confirm(configMeasuresTitle,eitherEnableOrDisableAlert, function(id) 
						{
							if (id == 'yes')
							{
								var urlForSubmission = '/final/admin/EgMonitorSettings/data/minmaxConfigJSONp.jsp?serdistype='+meadis+'&process='+process+'&reqFrom=thisPage'+'&measuredisplay='+measuredisplay;

								if (computeTopMetricsOptions == 'true' || computeTopMetricsOptions)
								{
									Ext.getCmp('tbarAddId').setDisabled(true);
								}

								if (computeTopMetricsOptions == 'false' || !computeTopMetricsOptions)
								{
									Ext.getCmp('tbarAddId').setDisabled(false);
								}

								Ext.Ajax.request(
								{
									url : urlForSubmission,
									scope:this,
									method : 'POST',
									success: function(response){
										var jsonText = response.responseText;
										var jsonData = Ext.decode(jsonText);

										if (meadis == "NO")
										{
											Ext.getCmp('tbarEnableId').setText('Enable Metrics Computation');
											Ext.Msg.show({
												title: enableOrDisableMetrics,
												msg: metricsDisabled,
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconInformation'
											});
										}

										if (meadis == "YES")
										{
											Ext.getCmp('tbarEnableId').setText('Disable Metrics Computation');
											Ext.Msg.show({
												title: enableOrDisableMetrics,
												msg: metricsEnabled,
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconInformation'
											});
										}

										var process = 'AllMeasures';

										var url = "/final/admin/EgMonitorSettings/data/minmaxConfigJSON.jsp?index=main&process="+process;

										Ext.Ajax.request(
										{
											url : url,
											scope:this,
											method : 'POST',
											success: function(response){
												var jsonText = response.responseText;
												var jsonData = Ext.decode(jsonText);

												var computeTopMetricsOptionsIn = jsonData.enableorDisableMetricsJson.minmaxEnabled;

												var viewStoreObj = Ext.getCmp('mainGrid');
												var testNameObj = Ext.getCmp('viewTestsId');

												if (computeTopMetricsOptionsIn == 'false' || !computeTopMetricsOptionsIn)
												{
													viewTestsObj.setDisabled(true);
												}
												
												if (computeTopMetricsOptionsIn == 'true' || computeTopMetricsOptionsIn)
												{
													viewTestsObj.setDisabled(false);

													viewStoreObj.getStore().loadRawData(jsonData.configMeasuresArrayJson);
												}

												if (Ext.isEmpty(jsonData.testArrayJson))
												{
													viewStoreObj.getStore().loadRawData('');
													testNameObj.setValue('Not Applicable');

													Ext.get('emptyTextDiv').update(alertForEnableMetricsComp);
												}
												else
												{
													testNameObj.getStore().loadRawData(jsonData.testArrayJson);
													testNameObj.setValue(jsonData.testArrayJson[0].displayField);
												}

											}
										});
									}
								});
							}
						}
					);
				}
			}
		);
	},

	addNewMeasure: function()
	{
		Ext.widget('newmeasure').show();
		Ext.getCmp('newMeasureWindow').show();

		var process = "new";
		var computeTopMetricsOptions = '';

		var url = "/final/admin/EgMonitorSettings/data/minmaxConfigJSON.jsp?index=add&process="+process;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					computeTopMetricsOptions = jsonData.enableorDisableMetricsJson.minmaxEnabled;
					
					if (computeTopMetricsOptions)
					{
						Ext.getCmp('minimumId').setValue('minimum');
					}

					if (!computeTopMetricsOptions)
					{
						Ext.getCmp('maximumId').setValue('maximum');
					}

					Ext.getCmp('testnameId').getStore().loadRawData(jsonData.testArrayJson);
					Ext.getCmp('testnameId').setValue(jsonData.testArrayJson[0].displayField);

					Ext.getCmp('measureid').getStore().removeAll();
					Ext.getCmp('measureid').setValue('Choose measure');
				}
			}
		);
	},

	viewTestsComboChange: function()
	{
		var viewTestsObj = Ext.getCmp('viewTestsId');

		var process = 'AllMeasures';
		var mode = 'add';
		var testName = Ext.getCmp('viewTestsId').getValue();

		var computeTopMetricsOptions = '';

		if (testName == 'All tests')
		{
			process = 'existingmeasure';
		}

		var url = "/final/admin/EgMonitorSettings/data/minmaxConfigJSON.jsp?index=main&process="+process+"&mode="+mode+"&testname="+testName;

		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				computeTopMetricsOptions = jsonData.enableorDisableMetricsJson.minmaxEnabled;

				if (computeTopMetricsOptions == 'false')
				{
					Ext.Msg.show({
						title: configMeasuresTitle,
						msg: alertForEnableMetricsComp,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
				}

				var viewStoreObj = Ext.getCmp('mainGrid');

				if (testName == 'All tests')
				{
					viewStoreObj.getStore().loadRawData(jsonData.configMeasuresArrayJson);
				}
				else
				{
					viewStoreObj.getStore().loadRawData(jsonData.measuresForTestArrayJson);
				}
			}
		});
	},

	onGridEnter: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
			Ext.each(icons, function(icon){
				Ext.get(icon).removeCls('x-hidden');
		});
	},

	onGridLeave: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		});
	},

	deleteMetrics: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var mode = 'delete';
		var mfinal = '';
		var measureType = '';

		var viewStoreObj = Ext.getCmp('mainGrid');

		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);

		var strTest = record.get('Test');

		var measure_type = record.get('Measure');
		var cmeasure = record.get('Measure');

		var display = record.get('Display');

		if (display == 'Minimum')
		{
			mfinal="minimum";
			measureType = "Min";
		}

		if (display == 'Maximum')
		{
			mfinal="maximum";
			measureType = "Max";
		}

		var processToGetStatus = "enable/disable";
		var process = "AllMeasures";
		var testName = strTest;
		var modeToGetMeasures = "add";

		var alertWithMeasureName = alertForDeleteMeasure + ' \'' + cmeasure + '\' ?';

		Ext.MessageBox.confirm(configMeasuresTitle,alertWithMeasureName, function(id) 
			{
				if (id == 'yes')
				{
					var url = "/final/admin/EgMonitorSettings/data/minmaxConfigJSON.jsp?index=main&process="+process;

					Ext.Ajax.request(
						{
							url : url,
							scope:this,
							method : 'POST',
							success: function(response){
								var jsonText = response.responseText;
								var jsonData = Ext.decode(jsonText);

								computeTopMetricsOptions = jsonData.enableorDisableMetricsJson.minmaxEnabled;

								var testsData = jsonData.testArrayJson2;

								var localTestName = '';
								var displayTestName = '';

								for (var i=0; i<testsData.length; i++)
								{
									displayTestName = jsonData.testArrayJson2[i].displayField;

									if (displayTestName == strTest)
									{
										localTestName = jsonData.testArrayJson2[i].valueField;
									}
								}

								var testNameToGetMeasures = Ext.getCmp('viewTestsId').getValue();

								var urlForMeasures = "/final/admin/EgMonitorSettings/data/minmaxConfigJSON.jsp?index=main&process="+process+"&minmaxEnabled="+computeTopMetricsOptions+"&testname="+localTestName+"&mode="+modeToGetMeasures;

								Ext.Ajax.request(
									{
										url : urlForMeasures,
										scope:this,
										method : 'POST',
										success: function(response){
											var jsonText = response.responseText;
											var jsonData = Ext.decode(jsonText);

											var measuresData = jsonData.measuresArrayJson;

											var measureLocalName = '';
											var measureDisplayName = '';

											for (var i=0; i<measuresData.length; i++)
											{
												measureDisplayName = jsonData.measuresArrayJson[i].displayField;

												if (measureDisplayName == measure_type)
												{
													measureLocalName = jsonData.measuresArrayJson[i].valueField;
												}
											}
											
											cmeasure = encodeURIComponent(parent.filterEncode(cmeasure));
											var urlForSubmission = '/final/admin/EgMonitorSettings/data/minmaxConfigJSONp.jsp?index=main&process='+process+'&reqFrom=thisPage&testname='+localTestName+'&measuretype='+measureLocalName+'&radioType='+mfinal+'&mode='+mode+'&displayname='+cmeasure+'&radioType='+mfinal;

											Ext.Ajax.request(
											{
												url : urlForSubmission,
												scope:this,
												method : 'POST',
												success: function(response){
													var jsonText = response.responseText;
													var jsonData = Ext.decode(jsonText);
													Ext.Msg.show({
														title: configMeasuresTitle,
														msg: updateSuccess,
														width: 300,
														buttons: Ext.Msg.OK,
														icon: 'iconInformation'
													});

													var process = 'AllMeasures';

													var testNameToGetMeasures = Ext.getCmp('viewTestsId').getValue();

													if (testNameToGetMeasures == 'All tests')
													{
														process = 'existingmeasure';
													}

													var url = "/final/admin/EgMonitorSettings/data/minmaxConfigJSON.jsp?index=main&process="+process+"&testname="+testNameToGetMeasures+"&mode="+modeToGetMeasures;

													Ext.Ajax.request(
													{
														url : url,
														scope:this,
														method : 'POST',
														success: function(response){
															var jsonText = response.responseText;
															var jsonData = Ext.decode(jsonText);

															var viewStoreObj = Ext.getCmp('mainGrid');

															var testNameObj = Ext.getCmp('viewTestsId');

															if (testNameToGetMeasures == 'All tests')
															{
																viewStoreObj.getStore().loadRawData(jsonData.configMeasuresArrayJson);
															}
															else
															{
																viewStoreObj.getStore().loadRawData(jsonData.measuresForTestArrayJson);
															}
															Ext.getCmp('configuredMeasures').doLayout();
														}
													});
												}
											});
										}
									}
								);
							}
						}
					);
				}
			}
		);
	},

	testComboChange: function()
	{
		var computeTopMetricsOptions = '';
		var measureIdObj = Ext.getCmp('measureid');

		var processToGetStatus = "enable/disable";
		var process = "new";
		var testName = Ext.getCmp('testnameId').getValue();
		var mode = "add";

		if (!Ext.isEmpty(testName) && testName == 'Choose test')
		{
			measureIdObj.getStore().removeAll();
			measureIdObj.setValue('Choose measure');
			return;
		}

		var url = "/final/admin/EgMonitorSettings/data/minmaxConfigJSON.jsp?process="+processToGetStatus;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					computeTopMetricsOptions = jsonData.enableorDisableMetricsJson.minmaxEnabled;

					var urlForMeasures = "/final/admin/EgMonitorSettings/data/minmaxConfigJSON.jsp?index=add&process="+process+"&minmaxEnabled="+computeTopMetricsOptions+"&testname="+testName+"&mode="+mode;

					Ext.Ajax.request(
						{
							url : urlForMeasures,
							scope:this,
							method : 'POST',
							success: function(response){
								var jsonText = response.responseText;
								var jsonData = Ext.decode(jsonText);

								var measuresData = jsonData.measuresArrayJson;

								measureIdObj.getStore().loadRawData(measuresData);

								if (!Ext.isEmpty(measuresData))
								{
									measureIdObj.setValue(jsonData.measuresArrayJson[0].displayField);
								}
								
								if (computeTopMetricsOptions)
								{
									Ext.getCmp('minimumId').setValue('minimum');
								}

								if (!computeTopMetricsOptions)
								{
									Ext.getCmp('maximumId').setValue('maximum');
								}

							}
						}
					);
				}
			}
		);
	},

	measuresAdd: function()
	{
		var mode = 'add';
		var process = 'new';
		var mfinal = '';
		var measureType = '';
		var valFlag = 'true';
		var displayMinimumObj = Ext.getCmp('minimumId');
		var displayMaximumObj = Ext.getCmp('maximumId');

		var strTest = Ext.getCmp('testnameId').getValue();
		var measure_type = Ext.getCmp('measureid').getValue();
		var cmeasure = Ext.getCmp('measureid').getDisplayValue();

		if (displayMinimumObj.getValue())
		{
			mfinal="minimum";
			measureType = "Min";
		}

		if (displayMaximumObj.getValue())
		{
			mfinal="maximum";
			measureType = "Max";
		}

		if (Ext.isEmpty(strTest) || strTest == 'Choose test')
		{
			Ext.Msg.show({
				title: addAMeasureTitle,
				msg: alertForTestType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			valFlag = 'false';
		}

		if (valFlag == 'true' && (Ext.isEmpty(measure_type) || measure_type == 'Choose measure'))
		{
			Ext.Msg.show({
				title: addAMeasureTitle,
				msg: alertForNoMeasure,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			valFlag = 'false';
		}

		var url = "/final/admin/EgMonitorSettings/data/minmaxConfigJSON.jsp?index=add&process="+process;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var allMeasures = jsonData.allMeasuresArrayJson;
					for (var i=0; i<allMeasures.length; i++)
					{
						var aMeasureAndTestAndDis = allMeasures[i];
						var aTestAndMeas = aMeasureAndTestAndDis.substring(aMeasureAndTestAndDis.indexOf(':')+1,aMeasureAndTestAndDis.length);
						var aTest = aTestAndMeas.substring(0,aTestAndMeas.indexOf(':'));
						var aMeas = aTestAndMeas.substring(aTestAndMeas.indexOf(':')+1,aTestAndMeas.length);
						if (aMeas == measure_type && aTest == strTest)
						{
							Ext.Msg.show({
								title: addAMeasureTitle,
								msg: alertForAlreadyExists,
								width: 500,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							valFlag = 'false';
						}
					}

					if (valFlag == 'true')
					{
						cmeasure = encodeURIComponent(parent.filterEncode(cmeasure));
						var urlForSubmission = '/final/admin/EgMonitorSettings/data/minmaxConfigJSONp.jsp?process='+process+'&reqFrom=thisPage&testname='+strTest+'&measuretype='+measure_type+'&radioType='+mfinal+'&mode='+mode+'&displayname='+cmeasure;

						Ext.Ajax.request(
						{
							url : urlForSubmission,
							scope:this,
							method : 'POST',
							success: function(response){
								var jsonText = response.responseText;
								var jsonData = Ext.decode(jsonText);

								Ext.Msg.show({
									title: addAMeasureTitle,
									msg: updateSuccess,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});

								Ext.getCmp('newMeasureWindow').destroy();

								var process = 'AllMeasures';

								var url = "/final/admin/EgMonitorSettings/data/minmaxConfigJSON.jsp?index=main&process="+process;

								Ext.Ajax.request(
								{
									url : url,
									scope:this,
									method : 'POST',
									success: function(response){
										var jsonText = response.responseText;
										var jsonData = Ext.decode(jsonText);

										var viewStoreObj = Ext.getCmp('mainGrid');

										var testNameObj = Ext.getCmp('viewTestsId');

										if (Ext.isEmpty(jsonData.testArrayJson))
										{
											Ext.Msg.show({
												title: addAMeasureTitle,
												msg: alertForEnableMetricsComp,
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconExclamation'
											});

											viewStoreObj.getStore().loadRawData('');
											testNameObj.setValue('Not Applicable');
										}

										testNameObj.getStore().loadRawData(jsonData.testArrayJson);
										testNameObj.setValue(jsonData.testArrayJson[0].displayField);

										viewStoreObj.getStore().loadRawData(jsonData.configMeasuresArrayJson);
										Ext.getCmp('configuredMeasures').doLayout();
									}
								});
							}
						});
					}
				}
			}
		);
	},
	
	userTypeUEDComboChange: function()
	{
		var process = 'ShowAllMeasures';
		var userTypeVal = Ext.getCmp('uedUserTypeId').getValue();
		if (userTypeVal == null || userTypeVal == undefined )
			userTypeVal='AllUserTypes';
		var url = "/final/admin/EgMonitorSettings/data/uedConfigJSON.jsp?index=main&process="+process+"&user_type="+userTypeVal;
		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var viewStoreObj = Ext.getCmp('mainGrid');
				if(viewStoreObj!=null && viewStoreObj!=undefined)
				{
					viewStoreObj.getStore().loadRawData(jsonData.configMeasuresArrayJson);
				}
			}
		});
	},

	modifyUEDMetrics: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var viewStoreObj = Ext.getCmp('mainGrid');
		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);
		
		var TestName = record.get('Test');
		var Process=record.raw.Process_Value;
		var Unit=record.raw.Unit_Value;
		var MeasureName = record.get('Measure');
		var DisplayName = record.get('Display');

		Ext.widget('uedmodifymeasure').show();
		Ext.getCmp('uedmodifyMeasureWindow').show();

		Ext.getCmp('testnameId').setValue(TestName);
		Ext.getCmp('measurenameid').setValue(MeasureName);
		if(Process!=-1 && Process!='' && Process!=undefined)
		{
			Ext.getCmp('processnameid').show();
			Ext.getCmp('processnameid').setValue(Process);
			Ext.getCmp('processId').setValue(Process);
			Ext.getCmp('unitnameid').show();
			Ext.getCmp('unitnameid').setValue(Unit);
			Ext.getCmp('unitId').setValue(Unit);
		}
		Ext.getCmp('displaynameid').setValue(DisplayName);

		var orgTestName = record.get('Test_Value');
		var orgMeasureName = record.get('Measure_Value');
		var orgUserType = record.get('User_Type');
		
		Ext.getCmp('testId').setValue(orgTestName);
		Ext.getCmp('measureId').setValue(orgMeasureName);
		Ext.getCmp('userTypeId').setValue(orgUserType);

	},

	deleteUEDMetrics: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var viewStoreObj = Ext.getCmp('mainGrid');
		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);
		var orgTestName = record.get('Test_Value');
		var orgMeasureName = record.get('Measure_Value');
		var orgDisplayName = record.get('Display_Value');
		var orgUserType = record.get('User_Type');
		var ddProcess=record.raw.Process_Value;
		var Unit=record.raw.Unit_Value;

		var process = "delete";
		var alertWithMeasureName = alertForDeleteMeasure + ' \'' + orgDisplayName + '\' ?';
		var alertForAllUsers = alertForDeleteMeasure + ' \'' + orgDisplayName + '\' for All users?';
		
		Ext.MessageBox.confirm(configMeasuresTitle,alertWithMeasureName, function(id) 
		{
			if (id == 'yes' || id == 'YES')
			{

				orgDisplayName = encodeURIComponent(parent.filterEncode(orgDisplayName));
				var urlForSubmission = '/final/admin/EgMonitorSettings/data/uedConfigJSONp.jsp?index=main&process='+process+'&reqFrom=thisPage&testname='+orgTestName+'&measurename='+orgMeasureName+'&displayname='+orgDisplayName+'&user_type='+orgUserType;

				if(ddProcess!=-1 && ddProcess!='' && ddProcess!=undefined)
					urlForSubmission=urlForSubmission+'&processname='+ddProcess+'&unit='+Unit+"&tableType=dd";

				Ext.MessageBox.confirm(configMeasuresTitle,alertForAllUsers, function(userId)
				{
					if (userId == 'yes' || userId == 'YES')
					{
						urlForSubmission = urlForSubmission + '&allUser=true';
					}
					else
					{
						urlForSubmission = urlForSubmission + '&allUser=false';
					}
					Ext.Ajax.request({
						url : urlForSubmission,
						scope:this,
						method : 'POST',
						success: function(response)
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							Ext.Msg.show({
								title: configMeasuresTitle,
								msg: updateSuccess,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});

							var process = 'ShowAllMeasures';
							var userTypeVal = Ext.getCmp('uedUserTypeId').getValue();
							if (userTypeVal == null || userTypeVal == undefined )
								userTypeVal='AllUserTypes'

							var url = "/final/admin/EgMonitorSettings/data/uedConfigJSON.jsp?index=main&process="+process+"&user_type="+userTypeVal;
							Ext.Ajax.request({
								url : url,
								scope:this,
								method : 'POST',
								success: function(response){
									var jsonText = response.responseText;
									var jsonData = Ext.decode(jsonText);
									var viewStoreObj = Ext.getCmp('mainGrid');
									var userNameObj = Ext.getCmp('uedUserTypeId');
									if(viewStoreObj!=null && viewStoreObj!=undefined)
									{
										viewStoreObj.getStore().loadRawData(jsonData.configMeasuresArrayJson);
									}
									Ext.getCmp('uedConfiguredMeasures').doLayout();
								}
							});
						}
					});
				});
			}
		});
	},

	loadUEDTests :function()
	{
		var userType = Ext.getCmp('userTypeId').getValue();
		var displayNameObj=Ext.getCmp('displaynameid');
		var tableDataObj = Ext.getCmp('tableData');
		var table_Val=tableDataObj.items.items[0].getGroupValue();
		if(!Ext.isEmpty(displayNameObj))
		{
			displayNameObj.setValue("");
		}
		
		var defaultUrl = '/final/monitor/endUserDashboardConfigJson.jsp?';
		var addDelete = "add";
		var url = defaultUrl+"loadTest=true&fromAdmin=true&addOrDelete="+addDelete;
		
		if(userType!=null && userType!='null' && userType!='' && userType!='undefined')
			url = url + "&userType="+userType;
		if(table_Val!=null && table_Val!='null' && table_Val!='' && table_Val!='undefined')
			url = url + "&tableType="+table_Val;
		else
			url = url + "&tableType=test";

		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var testCombo = Ext.getCmp('testnameId');
				var measureCombo = Ext.getCmp('measureid');
				var displayname = Ext.getCmp('displaynameid');
				var tableData = Ext.getCmp('tableData');
				var processId = Ext.getCmp('processId');
				var unitId = Ext.getCmp('unitId');
				var hideTblType =jsonData["HideTableType"];
				if(hideTblType!=null && hideTblType!=undefined && hideTblType=="true")
				{
					tableData.items.items[0].setValue(true);
					tableData.hide();
					processId.hide();
					unitId.hide();
				}
				else
				{
					tableData.show();
				}
				if(!Ext.isEmpty(testCombo) && !Ext.isEmpty(jsonData["TEST"]))
				{
					if(jsonData["TEST"].length>1)
					{
						testCombo.getStore().loadRawData(jsonData["TEST"]);
						measureCombo.show();
						displayname.show();
						testCombo.setValue("-1");
						measureCombo.setValue("-1");
						var temp_table_Val=tableDataObj.items.items[0].getGroupValue();
						if(temp_table_Val=='dd')
						{
							processId.show();
							unitId.show();
						}
						else
						{
							processId.hide();
							unitId.hide();
						}
					}
					else if(jsonData["TEST"].length==1)
					{
						testCombo.getStore().loadRawData({"displayField":"Not Applicable","valueField":"-1"});
						testCombo.setValue("-1");
						measureCombo.hide();
						displayname.hide();
						processId.hide();
						unitId.hide();
					}
				}
				else
				{
					testCombo.getStore().loadRawData('');
					measureCombo.getStore().loadRawData('');
				}
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},

	loadUEDMeasureForTest :function()
	{
		var userType = Ext.getCmp('userTypeId').getValue();
		var tableDataObj = Ext.getCmp('tableData');
		var table_Val=tableDataObj.items.items[0].getGroupValue();
		var displayNameObj=Ext.getCmp('displaynameid');
		var testObj = Ext.getCmp('testnameId').getValue();
		var measureObj = Ext.getCmp('measureid').getValue();
		if(!Ext.isEmpty(displayNameObj))
		{
			var displayName=displayNameObj.getValue();
			if(!Ext.isEmpty(testObj) && testObj=='-1')
			{
				if(!Ext.isEmpty(displayName))
				{
					displayNameObj.setValue("");
				}
			}
		}
	
		var addDelete = "add";
		var test = Ext.getCmp('testnameId').getValue();
		var defaultUrl = '/final/monitor/endUserDashboardConfigJson.jsp?';
		var url = defaultUrl+"loadMeasure=true&fromAdmin=true&addOrDelete="+addDelete+"&test="+test;
		url = url + "&userType="+userType;

		if(table_Val!=null && table_Val!='null' && table_Val!='' && table_Val!='undefined')
			url = url + "&tableType="+table_Val;
		else
			url = url + "&tableType=test";

		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var measureCombo = Ext.getCmp('measureid');
				var processCombo = Ext.getCmp('processId');
				measureCombo.getStore().loadRawData(jsonData["MEASURE"]);
				measureCombo.setValue("-1");
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},

	loadUEDMeasureDisplay :function()
	{
		var tableDataObj = Ext.getCmp('tableData');
		var table_Val=tableDataObj.items.items[0].getGroupValue();
		var measureObj = Ext.getCmp('measureid');
		if(table_Val=='dd')
		{
			var userType = Ext.getCmp('userTypeId').getValue();
			var testObj = Ext.getCmp('testnameId').getValue();
			var meas_Val=measureObj.getValue();
			var addDelete = "add";
			var test = Ext.getCmp('testnameId').getValue();
			var defaultUrl = '/final/monitor/endUserDashboardConfigJson.jsp?';

			var url = defaultUrl+"loadDDColumns=true&test="+test;
			url = url + "&userType="+userType;

			if(meas_Val!=null && meas_Val!='null' && meas_Val!='' && meas_Val!='undefined')
				url = url + "&measure="+meas_Val;

			Ext.Ajax.request({
				url : url,
				method : 'POST',
				scope:this,
				timeout:280000,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var processCombo = Ext.getCmp('processId');
					var unitCombo = Ext.getCmp('unitId');
					processCombo.getStore().loadRawData(jsonData["DD_COLUMNS"]);
					processCombo.setValue("-1");
					unitCombo.setValue("NONE");
				},
				failure : function()
				{
					//alert("failure");
				}
			});
		}
		if(!Ext.isEmpty(measureObj))
		{
			var displayMeaVal=measureObj.getRawValue();
			var meaVal=measureObj.getValue();
			var displayNameObj=Ext.getCmp('displaynameid');
			if(!Ext.isEmpty(displayMeaVal) && meaVal!='-1')
			{
				if(!Ext.isEmpty(displayNameObj))
				{
					displayNameObj.setValue(displayMeaVal);
				}
			}
			else if(!Ext.isEmpty(meaVal) && meaVal=='-1')
			{
				if(!Ext.isEmpty(displayNameObj))
				{
					displayNameObj.setValue("");
				}
			}
		}
	},

	addUEDNewMetrics: function()
	{
		Ext.widget('uednewmeasure').show();
		Ext.getCmp('uednewMeasureWindow').show();
		
		var uedUserTypeIdObj=Ext.getCmp('uedUserTypeId');
		var selectedUserType="";
		if(!Ext.isEmpty(uedUserTypeIdObj))
		{
			selectedUserType = uedUserTypeIdObj.getValue();
		}

		var process = "new";
		var url = "/final/admin/EgMonitorSettings/data/uedConfigJSON.jsp?index=add&process="+process;
		//Ext.getCmp('measureid').setValue();
		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					Ext.getCmp('userTypeId').getStore().loadRawData(jsonData.userTypeArrayJson);

					if(!Ext.isEmpty(selectedUserType) && selectedUserType!=undefined && selectedUserType!=null && selectedUserType!="" && selectedUserType!="AllUserTypes")
					{
						Ext.getCmp('userTypeId').setValue(selectedUserType);
					}
					else
					{
						Ext.getCmp('userTypeId').setValue(jsonData.userTypeArrayJson[0].valueField);
					}
					Ext.getCmp('measureid').getStore().removeAll();
					this.loadUEDTests();
				}
			}
		);
	},

	addUEDMeasures : function()
	{
		var userType = Ext.getCmp('userTypeId').getValue();
		var tableDataObj = Ext.getCmp('tableData');
		var table_Val=tableDataObj.items.items[0].getGroupValue();
		var addDelete = "add";
		var test = Ext.getCmp('testnameId').getValue();
		var measure = Ext.getCmp('measureid').getValue();
		var process_name = Ext.getCmp('processId').getValue();
		var process_unit = Ext.getCmp('unitId').getValue();
		var displayName = Ext.getCmp('displaynameid').getValue();
		var update = true;
		if(userType=="-1"){
			Ext.Msg.alert("Error",userTypeError);
				update = false;
		}
		else if(test=="-1")
		{
			Ext.Msg.alert("Error",testError);
				update = false;
		}
		else if(measure=="-1")
		{
			Ext.Msg.alert("Error",measureError);
				update = false;
		}
		else if(addDelete=="add" && test!="-1" && displayName=='')
		{
			Ext.Msg.alert("Error",displayNameError);
				update = false;
		}
	
		if(update)
		{
			displayName = encodeURIComponent(parent.filterEncode(displayName));
			var url = '/final/monitor/endUserDashboardConfigJson.jsp?isUpdate=true&fromAdmin=true&addOrDelete='+addDelete+'&test='+test+'&measure='+measure+'&displayName='+displayName;
			url = url + "&userType="+userType;
			if(table_Val!=null && table_Val!='null' && table_Val!='' && table_Val!='undefined')
			{
				if(table_Val=='dd')
				{
					url = url + "&processName="+process_name+"&processUnit="+process_unit;
				}
				url = url + "&tableType="+table_Val;
			}
			else
				url = url + "&tableType=test";
			Ext.Ajax.request({
				url : url,
				method : 'POST',
				scope:this,
				timeout:280000,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if(jsonData["UPDATE"]=='SUCCESS')
					{
						Ext.Msg.show({
							title: UEDSettingsTitle,
							msg: updateSuccess,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});

						var process = 'ShowAllMeasures';
						var userTypeVal = Ext.getCmp('uedUserTypeId').getValue();
						if(userTypeVal == null || userTypeVal == undefined )
							userTypeVal='AllUserTypes'
						var url = "/final/admin/EgMonitorSettings/data/uedConfigJSON.jsp?index=main&process="+process+"&user_type="+userTypeVal;
						
						Ext.Ajax.request(
						{
							url : url,
							scope:this,
							method : 'POST',
							success: function(response){
								var jsonText = response.responseText;
								var jsonData = Ext.decode(jsonText);
								var viewStoreObj = Ext.getCmp('mainGrid');
								var userNameObj = Ext.getCmp('uedUserTypeId');
								if(viewStoreObj!=null && viewStoreObj!=undefined)
								{
									viewStoreObj.getStore().loadRawData(jsonData.configMeasuresArrayJson);
								}
								Ext.getCmp('uedConfiguredMeasures').doLayout();
							}
						});
					}
					else if(jsonData["UPDATE"]=='FAILED')
					{
						Ext.Msg.show({
							title: UEDSettingsTitle,
							msg: updateNotSuccess,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
					}
				},
				failure : function()
				{
					//alert("failure");
				}
			});
			Ext.getCmp('uednewMeasureWindow').close();
		}
	},

	modifyUEDMeasures: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var testname=Ext.getCmp('testId').getValue();
		var measurename=Ext.getCmp('measureId').getValue();
		var processname=Ext.getCmp('processnameid').getValue();
		var unitname=Ext.getCmp('unitnameid').getValue();
		var displayname=Ext.getCmp('displaynameid').getValue();
		var userType=Ext.getCmp('userTypeId').getValue();
		var process = 'modify';
		var viewStoreObj = Ext.getCmp('mainGrid');
		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);
		
		if (userType == null || userType == undefined )
			userType='AllUserTypes'
		
		displayname = encodeURIComponent(parent.filterEncode(displayname));

		var url = "/final/admin/EgMonitorSettings/data/uedConfigJSONp.jsp?index=main&process="+process+"&testname="+testname+"&measurename="+measurename+"&displayname="+displayname+"&user_type="+userType;
		if(processname!=null && processname!='' &&  processname!=undefined)
			url=url+"&processname="+processname+"&unit="+unitname+"&tableType=dd";
		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				Ext.Msg.show({
					title: modifyMeasureTitle,
					msg: updateSuccess,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconInformation'
				});

				var process = 'ShowAllMeasures';
				var userTypeVal = Ext.getCmp('uedUserTypeId').getValue();
				if (userTypeVal == null || userTypeVal == undefined )
					userTypeVal='AllUserTypes'

				var url = "/final/admin/EgMonitorSettings/data/uedConfigJSON.jsp?index=main&process="+process+"&user_type="+userTypeVal;
				Ext.Ajax.request(
				{
					url : url,
					scope:this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						var viewStoreObj = Ext.getCmp('mainGrid');
						var userNameObj = Ext.getCmp('uedUserTypeId');
						if(viewStoreObj!=null && viewStoreObj!=undefined)
						{
							viewStoreObj.getStore().loadRawData(jsonData.configMeasuresArrayJson);
						}
						Ext.getCmp('uedConfiguredMeasures').doLayout();
					}
				});
			}
		});
		Ext.getCmp('uedmodifyMeasureWindow').close();
	},

	addUedLimit:function()
	{
		var addUedLimitStr = Ext.getCmp("addUedLimit")!=null?Ext.getCmp("addUedLimit").value:"";
		if(addUedLimitStr!=null && addUedLimitStr!='undefined' && addUedLimitStr!='Add Limit' )
		{
			if(isNaN(addUedLimitStr) || addUedLimitStr==null || addUedLimitStr<=0)
			{
				Ext.Msg.alert("Error","Please enter valid number");
				Ext.getCmp("addUedLimit").reset();
				return;
			}

			var url = "/final/admin/EgMonitorSettings/data/uedConfigJSONp.jsp?index=main&process=addUEDLimit&addUedLimit="+addUedLimitStr;

			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					Ext.Msg.show({
						title: uedotherDisplaySettingsTitle,
						msg: updateSuccess,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});

					Ext.getCmp('addUedLimit').hide();
					Ext.getCmp('iconPlusBut').show();
				},
				failure : function()
				{
					Ext.getCmp('addUedLimit').show();
					Ext.getCmp('iconPlusBut').hide();
				}
			});
			
		}
		else
		{
			if(isNaN(addUedLimitStr) || addUedLimitStr==null || addUedLimitStr<=0)
			{
				Ext.Msg.alert("Error","Please enter valid number");
				Ext.getCmp("addUedLimit").reset();
				return;
			}
		}
	},

	updateUEDSettings:function()
	{
		var limit = Ext.getCmp('limitId').getValue();
		var dslimit = Ext.getCmp('dslimitId').getValue();
		var refreshId = Ext.getCmp('refreshFreqId');
		var refreshFreq = refreshId.getValue();
		var reFrq = parseInt(refreshFreq);
		if(isNaN(reFrq) || reFrq==null || reFrq<=0){
			Ext.Msg.alert("Error",freqError);
			refreshId.reset();
			return;			
		}

		//var retrieveData = Ext.getCmp('dataRadiobtn').getValue().Retrieve;
		var adGroup = Ext.getCmp('adGroupId').getValue();
		var adSearchMulSelVal = Ext.getCmp('searchUserTypeMulId').getValue();
		var adSearUsrType = Ext.getCmp('searchUserTypeId').getValue();
	
		var process = 'update';
		//var url = "/final/admin/EgMonitorSettings/data/uedConfigJSONp.jsp?index=main&process="+process+"&limit="+limit+"&refreshFreq="+refreshFreq+"&retrieveData="+retrieveData+"&adGroup="+adGroup;
		var url = "/final/admin/EgMonitorSettings/data/uedConfigJSONp.jsp?index=main&process="+process+"&limit="+limit+"&refreshFreq="+refreshFreq+"&adGroup="+adGroup+"&adSearUsrType="+encodeURIComponent(adSearUsrType)+"&adSearchMulSelVal="+encodeURIComponent(adSearchMulSelVal)+"&dslimit="+dslimit;

		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				/*if(retrieveDataObj!=null && retrieveData!=null && retrieveDataObj!=retrieveData)
				{
					if(retrieveData=="yes")
					{
						Ext.Msg.show({
						title: uedotherDisplaySettingsTitle,
						msg: radioBtnChange,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
						 fn: function(buttonId) {
							if (buttonId === "ok") 
							{
								Ext.Msg.show({
									title: uedotherDisplaySettingsTitle,
									msg: updateSuccess,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
									});
								}
							}
						});
					}
					retrieveDataObj=retrieveData;
				}
				else
				{*/
					Ext.Msg.show({
						title: uedotherDisplaySettingsTitle,
						msg: updateSuccess,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
				//}
			}
		});
	},
	loadUEDProcessDisplay:function()
	{
		var processObj = Ext.getCmp('processId');
		if(!Ext.isEmpty(processObj))
		{
			var displayProcessVal=processObj.getRawValue();
			var ProcessVal=processObj.getValue();
			var displayNameObj=Ext.getCmp('displaynameid');
			if(!Ext.isEmpty(displayProcessVal) && ProcessVal!='-1')
			{
				if(!Ext.isEmpty(displayNameObj))
				{
					displayNameObj.setValue(displayProcessVal);
				}
			}
			else if(!Ext.isEmpty(ProcessVal) && ProcessVal=='-1')
			{
				if(!Ext.isEmpty(displayNameObj))
				{
					displayNameObj.setValue("");
				}
			}
		}
	}
});
function isAValidNumber(val)
{
	validFigures = '0123456789';
	if(val.length > 1 && val.indexOf('0')==0)
		return "false";
	if(val.length==0)
		return "false";
	for (i=0; i<val.length; i++)
	{
		if (validFigures.indexOf(val.charAt(i),0) == -1) 
		{
			return "false";
		}
	}
	return "true";
}
var noFileToUpload = false;
function validateTextBoxes(str,monitorField,value)
{
	var res = "true";

	if(str == 'alarms' && monitorField == 'noOfRows' && isAValidNumber(value) == "false")
	{
		res = "false";
	}

	if(str == 'graphs' && monitorField == 'monitorTimeScale' && isAValidNumber(value) == "false")
	{
		res = "false";
	}

	if(str == 'graphs' && monitorField == 'reporterTimeScale' && isAValidNumber(value) == "false")
	{
		res = "false";
	}
	return res;
}
function validateSingleByte(input)
{
	for(var i=0;i<input.length;i++)
	{
		var charValue=input.charCodeAt(i);
		if(charValue>255)
			return false;
	}
	return true;
}


