Ext.define('EgMonitorSettings.view.NewMeasure', {
	extend: 'Ext.window.Window',
	alias: 'widget.newmeasure',
	id: 'newMeasureWindow',
	width: 420,
	height: 190,
	title: addAMeasureTitle,
	resizable: false,
	draggable: false,
	modal: true,
	listeners:{
		close : function()
		{
			Ext.Ajax.request({
				url : 'EgMonitorSettings/data/minmaxConfigJSON.jsp?index=main&process=AllMeasures',
				method : 'POST'
			});
		}
	},
	requires:['utilities.ScrollCombo'],
	items: [
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			defaults: {
				labelSeparator: '',
				margin: 5,
				width: 350,
				labelWidth: 100
			},
			margin: 10,
			items: [
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: testNameInAdd,
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : []
					}),
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					id: 'testnameId',
					name: 'testname',
					//editable: false
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: measureInAdd,
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : []
					}),
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					id: 'measureid',
					editable: false
				},
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: displayInAdd,
					columns: 2,
					vertical: false,
					id : 'mtypeContainer',
					items: [
						{ boxLabel: minimumRadioOption, name: 'mtype', inputValue: 'minimum', id: 'minimumId'},
						{ boxLabel: maximumRadioOption, name: 'mtype', inputValue: 'maximum', checked: true, id: 'maximumId'}
					]
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: 10,
			items: [
				{
					xtype: 'button',
					cls:'button20',
					text: addBtnText,
					width: 80,
					id: 'measuresAddBtn'
				}
			]
		}
	]

});



