Ext.define('EgMonitorSettings.view.UEDConfiguredMeasures', {
	extend: 'Ext.form.Panel',
	alias: 'widget.uedconfiguredmeasures',
	id: 'uedConfiguredMeasures',
	border: false,
	autoScroll:false,
	scroll: false,

	requires: [
		'utilities.ScrollCombo',
		'utilities.CustomGrid'
	],

	flex: 1,

	layout: {
		type: 'vbox',
		align:'stretch'
	},

	items: [
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			autoScroll:true,
			scroll: true,
			store: new Ext.data.Store({
				fields : ['Test', 'Measure','Display','Test_Value','Measure_Value','Display_Value','User_Type'],
				data : []
			}),
			flex:1,
			border:false,
			height:400,
			margin: 10,
			id: 'mainGrid',
			viewConfig: {
				deferEmptyText:true
			},
			emptyText: '<center><div style="margin:10% 0 auto 0"><img src=/final/images/spacer.gif class="iconInformation"></div><div id="emptyTextDiv" class="commonErrorMsgText">' + noMeasures + '</div></center>',
			columns: {
				defaults: {
					sortable: true,
					//hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: testText,
						dataIndex: 'Test',
						flex: 1
					},
					{
						text: measureText,
						dataIndex: 'Measure',
						flex: 1
					},
					{
						text: displayText,
						dataIndex: 'Display',
						flex: 1
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 38,
						//icon: '../../../../resources/images/delete.png',
						iconCls: 'iconModify',
						//tooltip: 'Delete',
						sortable: false,
						padding:'3 0 0 0',
						id: 'uedModifyMetrics',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Edit Display' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 38,
						//icon: '../../../../resources/images/delete.png',
						iconCls: 'iconDelete',
						//tooltip: 'Delete',
						sortable: false,
						padding:'3 0 0 0',
						id: 'uedDeleteMetrics',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
						}
					}
				]
			},
			tbar: [
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					width: 150,
					editable: false,
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : []
					}),
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					id: 'uedUserTypeId'
				},
				{
					xtype:'tbfill',
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					items:[
						{
							xtype: 'button',
							cls:'button20',
							id: 'tbarUEdAddId',
							text: addAMeasureTitle
						}
					]
				}
			]
		}
	]
});