Ext.define('EgMonitorSettings.view.UEDOtherDisplaySettings', {
	extend: 'Ext.form.Panel',
	alias: 'widget.uedotherdisplaysettings',
	id: 'uedotherdisplaysettings',
	requires:['Ext.ux.form.MultiSelect'],
	//cls:'outerpanel',
	border: false,

	items:[
		{
			xtype: 'fieldset',
			title: '<b>' + uedTextOtherSetTitle + '</b>',
			id: 'generalPanelNotHidden',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			defaults: {
				labelSeparator: ' ',
				margin: 5,
				width: 550,
				labelWidth: 350
			},
			margin: 20,
			items: [
				{
					xtype:'container',
					layout:'hbox',
					items:[
						{
							xtype: 'scrollcombo',
							cls:'dropdown',
							fieldLabel: limitComboLabel,
							emptyText:limitComboEmptyText,
							id: 'limitId',
							labelWidth:350,
							width:450,
							name: 'limit',
							store: new Ext.data.Store({
								fields : ['valueField','displayField'],
							}),
							queryMode: 'local',
							displayField: 'displayField',
							valueField: 'valueField',
							editable: false
						},
						{
							xtype:'button',
							margin:'0 0 0 5',
							cls:'iconPlus',
							id: 'iconPlusBut',
							style:{'border':'none'},
							listeners:{
								'click':function(btn){
									//alert("test")
									btn.hide();
									Ext.getCmp('addUedLimit').show();
								}
							}
						},
						{
							xtype: 'trigger',
							width:175,
							emptyText:'Add Limit',
							//emptyText:searchEmptyText,
							hidden:true,
							labelAlign:'right',
							labelWidth:40,
							minWidth:80,
							labelSeparator:'',
							maxWidth:88,
							margin:'0 0 0 5',
							enableKeyEvents : true,
							cls :'whitedropdown_search',
							//fieldCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
							//fieldLabel:'<div style="padding-top:4px">'+searchLabel+'</div>',
							value: '',
							onTriggerClick: function()
							{
								var addUedLimitStr = Ext.getCmp("addUedLimit")!=null?Ext.getCmp("addUedLimit").value:"";
								console.log('addUedLimitStr--->',addUedLimitStr);
								if(addUedLimitStr!=null && addUedLimitStr!='undefined' && addUedLimitStr!='Add Limit' )
								{
									if(isNaN(addUedLimitStr) || addUedLimitStr==null || addUedLimitStr<=0)
									{
										Ext.Msg.alert("Error","Please enter valid number");
										Ext.getCmp("addUedLimit").reset();
										return;
									}

									var url = "/final/admin/EgMonitorSettings/data/uedConfigJSONp.jsp?index=main&process=addUEDLimit&addUedLimit="+addUedLimitStr;

									Ext.Ajax.request(
									{
										url : url,
										scope:this,
										method : 'POST',
										success: function(response){
											var jsonText = response.responseText;
											var jsonData = Ext.decode(jsonText);
											Ext.Msg.show({
												title: uedotherDisplaySettingsTitle,
												msg: updateSuccess,
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconInformation'
											});

											Ext.getCmp('addUedLimit').hide();
											Ext.getCmp('iconPlusBut').show();
										},
										failure : function()
										{
											Ext.getCmp('addUedLimit').show();
											Ext.getCmp('iconPlusBut').hide();
										}
									});
									
								}
								else
								{
									if(isNaN(addUedLimitStr) || addUedLimitStr==null || addUedLimitStr<=0)
									{
										Ext.Msg.alert("Error","Please enter valid number");
										Ext.getCmp("addUedLimit").reset();
										return;
									}
								}
							},
							name: 'addUedLimit',
							id: 'addUedLimit',
							maxLength:30,
							enforceMaxLength:true
						}
					]
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: dslimitComboLabel,
					emptyText:dslimitComboEmptyText,
					id: 'dslimitId',
					name: 'dslimit',
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
					}),
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					editable: false,
					hidden:true
				},
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: refreshFreq,
					allowBlank: false,
					name: 'refreshFreq',
					id: 'refreshFreqId',
					maxLength:30,
					enforceMaxLength:true
				},
				/*{
					xtype: 'radiogroup',
					fieldLabel: dataFromDBLabel,
					baseCls:'radiobt',
					labelSeparator:'',
					id:'dataRadiobtn',
					hidden:true,
					items:[
					{
						boxLabel: yesRadioOption,
						name:'Retrieve',
						inputValue: 'yes',
						id:'yes_retrieveId',
						width:70
					},
					{
						boxLabel: noDataFromDBLabel,
						name:'Retrieve',
						inputValue: 'no',
						id:'no_retrieveId',
						width:150
					}]
				},*/
				{
					xtype:'container',		
					defaults:{
						width: 550,
						labelWidth: 350,
						labelSeparator:'',
					},
					items:[
							{
								xtype: 'multiselect',
								height:130,
								width:550,
								scroll: false,
								autoScroll: false,
								labelAlign:'left',
								allowBlank: true,
								fieldLabel: EnableADGroupLabel,
								id: 'adGroupId',
								name: 'adGroup',
								value: '',
								store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : [],							
								}),
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local'
							}
					]
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: addSearchComboLabel,
					emptyText:addSearchComboEmptyText,
					id: 'searchUserTypeId',
					name: 'searchUserTypeId',
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
					}),
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					editable: false,
					//hidden:!addtionalSearchFlag,
					hidden:true,
					listeners: {
						'change': function(field, selectedValue) {
							var process = 'uedOtherSettings';
							var url = "/final/admin/EgMonitorSettings/data/uedConfigJSON.jsp?process="+process+"&adSearUsrType="+encodeURIComponent(selectedValue);
							Ext.Ajax.request(
							{
								url : url,
								scope:this,
								method : 'POST',
								success: function(response){
									var jsonText = response.responseText;
									var jsonData = Ext.decode(jsonText);
									if(!Ext.isEmpty(jsonData.asUsrTypeJson) && jsonData.asUsrTypeJson!=undefined && jsonData.asUsrTypeJson!=null)
									{
										var userTypes = jsonData.asUsrTypeJson.asUsrTypeArr;
										var uSelectedType = jsonData.asUsrTypeJson.adSearchSelectedType;
										
										Ext.getCmp('searchUserTypeId').getStore().loadRawData(userTypes);
										Ext.getCmp('searchUserTypeId').setValue(uSelectedType);

										var adSearchColumns = jsonData.asUsrTypeMulJson;
										var adSearchSelectedVal = jsonData.adSearchSelectedVal;

										if (!Ext.isEmpty(adSearchColumns))
										{
											Ext.getCmp('searchUserTypeMulId').getStore().loadRawData(adSearchColumns);
										}
										if (Ext.isEmpty(adSearchSelectedVal))
											Ext.getCmp('searchUserTypeMulId').setValue('None');
										else
											Ext.getCmp('searchUserTypeMulId').setValue(adSearchSelectedVal);
									}
								}
							});
						}
					}
				},
				{
					xtype:'container',
					//hidden:!addtionalSearchFlag,
					hidden:true,
					defaults:{
						width: 550,
						labelWidth: 350,
						labelSeparator:'',
					},
					items:[
							{
								xtype: 'multiselect',
								height:130,
								width:550,
								scroll: false,
								autoScroll: false,
								labelAlign:'left',
								allowBlank: true,
								fieldLabel: addSearchMultiLabel,
								id: 'searchUserTypeMulId',
								name: 'searchUserTypeMulId',
								value: '',
								hidden:true,
								store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : [],
								}),
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local'
							}
					]
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: 20,
			items: [
				{
					xtype: 'button',
					cls:'button20',
					text: updateBtnText,
					width: 80,
					id:'UEDUpdateBtn',
				}
			]
		}
	]

});



