var originalShow = Ext.window.MessageBox.prototype.show;
Ext.override(Ext.window.MessageBox,{
	minWidth : 300,
	show: function(cfg) 
	{
		if (cfg != undefined && cfg.msg != undefined)
		{
			cfg.msg = Ext.String.trim(cfg.msg);
			var lastChar = cfg.msg.charAt(cfg.msg.length-1);
			if (lastChar  !=  '.'  &&  lastChar  !=  '?')
			{
				cfg.msg = cfg.msg + ".";
			}
		}

		if (cfg != undefined && cfg.msg != undefined && !cfg.hasOwnProperty("width"))
		{
			var tmpWidth = cfg.msg.length * 7;
			Ext.applyIf(cfg,{width : tmpWidth});
		}

		originalShow.apply(this, arguments);
	},

	alert: function(cfg, msg, fn, scope) 
	{
		if (Ext.isString(cfg)) 
		{
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '.'  &&  lastChar  !=  '?')
				{
					msg = msg + ".";
				}
			}

			cfg = {
				title : cfg,
				msg : msg ,
				buttons: this.OK,
				icon : 'iconExclamation',
				fn: fn,
				scope : scope,
				minWidth: this.minWidth
			};
		}
		return this.show(cfg);
	},

	confirm: function(cfg, msg, fn, scope) 
	{
		if (Ext.isString(cfg)) 
		{
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '?')
				{
					msg = msg + "?";
				}
			}

			cfg = 
			{
				title: cfg,
				icon: 'iconConfirmation',
				msg: msg,
				buttons: this.YESNO,
				callback: fn,
				scope: scope
			};
		}
		return this.show(cfg);
	}
});

Ext.define('EgMonitorSettings.view.Viewport', {
	extend: 'Ext.container.Viewport',
	layout: 'fit',
	id: 'mainViewId',
	alias: 'widget.viewport',
	requires: [
		'EgMonitorSettings.view.SettingList',
		'EgMonitorSettings.view.Alarms',
		'EgMonitorSettings.view.Graphs',
		'EgMonitorSettings.view.OtherDisplaySettings',
		'EgMonitorSettings.view.ConfiguredMeasures',
		'EgMonitorSettings.view.NewMeasure',
		'utilities.OuterPanel'
	],

	initComponent: function() {

		if (Ext.get('loadmask'))
		{
			Ext.get('loadmask').remove();
		}

		this.items = [
			{
				//xtype: 'panel',
				//margin:10,
				layout: 'border',
				border:false,
				bodyPadding:0,
				padding:0,
				frame:false,
				items: [
					{
						region: 'west',
						xtype: 'settinglist',
						width:250,
						margin :'8 0 0 8',
						layout:{type:'vbox',align:'stretch'},
						collapsible:true,
						hideCollapseTool:true,
						scroll:false,
						autoScroll:false,
						split: true,
						collapsed:false,
						collapseMode :'mini'
					},
					{
						region: 'center',
						xtype: 'outerPanel',
						id: 'innerPanel',
						cls:'outerpanel',
						id: 'innerPanel',
						margin :'8 8 0 0',
						flex:4,					
						frame:true,	
						hideCollapseTool:true,
						scroll: true,
						autoScroll : true,
						layout:{type:'vbox',align:'stretch'},
						title: '&nbsp;',
						//autoScroll: true,
						dockedItems: [{
							xtype: 'toolbar',
							cls:'adminHeadInfoText',
							dock: 'top',
							height: 25,
							border:true,
							padding: 3,
							layout:{pack:'center'},
							items: [
								{
									xtype: 'component',
									id: 'mainViewDesc',
									cls:'adminHeadInfoText',
									html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp' + monitorSettingsAlarmsDesc + '</center>',
									width:'100%',
									height: 25,
									padding: 3
								}
							]
						}],
						items: [
							{
								xtype: 'alarms',
								autoScroll:true
							}
						]
						
					}
				]
			}
		];

		this.callParent();
	}
});



