Ext.define('EgReplicateUser.controller.Main',{
	extend:'Ext.app.Controller',
	views:['CloneUser','EgDomainGroupTree','viewSelections'],
	refs:[
		{selector:'cloneuser', ref:'cloneuser'},
		{selector:'egdomaingrouptree', ref:'egdomaingrouptree'},
		{selector:'viewselections', ref:'viewselections'},
		{selector:'groupWindow', ref:'groupWindow'}
	],

	init: function()
	{
		thisController = this;
		this.buildMainData();
		var selectedDateFormat;
		var domainArrayJson;
		this.control({
			'cloneuser':
			{
				'afterrender': this.afterMainRender
			},
			'cloneuser combo[id="domainID"]':
			{
				'select': this.domainNameChange
			},
			'cloneuser combo[id="uidS"]':
			{
				'select': this.cloneFromComboChange
			},
			'cloneuser checkbox[id="noExpiryField"]':
			{
				'change': this.noExpiryChange
			},
			'cloneuser button[id="validateID"]':
			{
				'click': this.onValidate
			},
			//'cloneuser radiofield[id="domainAuthentication"]':
			//{
				//'change': this.radioChanged
			//},
			//'cloneuser radiofield[id="egAuthentication"]':
			//{
				//'change': this.radioChanged
			//},
			'cloneuser radiogroup[id="authenticationID"]':
			{
				'change':this.radioChanged
			},
			'cloneuser radiogroup[id="userAuthSAML"]':
			{
				'change':this.radioChanged
			},
			'cloneuser radiofield[id="userId"]':
			{
				'change': this.operationRadioChanged
			},
			'cloneuser radiofield[id="groupId"]':
			{
				'change': this.operationRadioChanged
			},
			'cloneuser button[id="replicateID"]':
			{
				'click': this.cloneUpdate
			},
			'cloneuser checkboxgroup[id="checkboxGroupId"]':
			{
				'change': this.selectCheckBox
			},
			'groupWindow button[id="applyBtn"]':
			{
				'click': this.applyGroupName
			},
			'groupWindow button[id="viewSelect"]':
			{
				'click': this.viewSelections
			},
			'cloneuser textfield[id="passwordID"]':
			{
				'change': this.passStrength
			},
			'cloneuser textfield[id="unameID"]':
			{
				'change':this.onCheck
			}
		});
	},
	
	passStrength: function()
	{
		var pwdLength = publicJSON.pwdLength;
		var pwdComplexityCount = publicJSON.pwdComplexityCount;
		if (pwdLength == "" || pwdLength < 2)
		{
			pwdLength = 8;
		}
		else if(pwdLength != "" && pwdLength < pwdComplexityCount)
		{
			pwdLength = pwdComplexityCount;
		}
		var loginPassword = Ext.getCmp('passwordID').getValue();
		var regExp = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[^\da-zA-Z]).+$/;
		var regExp2 = /^(?=.*\d)(?=.*[a-zA-Z])(?=.*[^\da-zA-Z]).+$/;
		var regExp3 = /^(?=.*\d)(?=.*[a-zA-Z]).+$/;
		if (loginPassword.length >= pwdLength && regExp.test(loginPassword))
		{
			Ext.getCmp('passScore').setText(passStr+': '+Strong);
		}
		else if(loginPassword.length >= pwdLength && loginPassword.match(regExp2))
		{
			Ext.getCmp('passScore').setText(passStr+': '+Good);
		}
		else if(loginPassword.length >= pwdLength && loginPassword.match(regExp3))
		{
			Ext.getCmp('passScore').setText(passStr+': '+Fair);
		}
		else if (loginPassword.length == 0)
		{
			Ext.getCmp('passScore').setText(passLabel1+" "+pwdLength+" "+passLabel2);
		}
		else
		{
			Ext.getCmp('passScore').setText(passStr+': '+Weak);
		}
	},
	pwdComplexityCheck : function(loginPassword)
	{
		var _start = "^";
		var _mid = "";
		var _end = ".+$";
		var result = "";
		var dot = ".";
		var brk = "<br/>";
		var pwdComplexity = publicJSON.pwdComplexity;
		if(pwdComplexity != null && pwdComplexity != undefined)
		{
			if(pwdComplexity.indexOf(",") > -1)
			{
				result = "false#";
				var pwdComplexVal = pwdComplexity.split(",");
				for(var k=0; k<pwdComplexVal.length; k++)
				{
					var temp = pwdComplexVal[k].toLowerCase().trim();
					if(temp == "lc")
					{
						_mid += "(?=.*[a-z])";
						result += brk+(k+1)+dot+" "+alertForPwdComplexity1;
					}
					else if(temp == "uc")
					{
						_mid += "(?=.*[A-Z])";
						result += brk+(k+1)+dot+" "+alertForPwdComplexity2;
					}
					else if(temp == "dg")
					{
						_mid += "(?=.*[0-9])";
						result += brk+(k+1)+dot+" "+alertForPwdComplexity3;
					}
					else if(temp == "sp")
					{
						_mid += "(?=.*[^0-9a-zA-Z])";
						result += brk+(k+1)+dot+" "+alertForPwdComplexity4;
					}
				}
			}
			else
			{
				result = "false#";
				var temp = pwdComplexity.toString().toLowerCase().trim();
				if(temp == "lc")
				{
					_mid += "(?=.*[a-z])";
					result += alertForPwdComplexity1;
				}
				else if(temp == "uc")
				{
					_mid += "(?=.*[A-Z])";
					result +=  alertForPwdComplexity2;
				}
				else if(temp == "dg")
				{
					_mid += "(?=.*[0-9])";
					result +=  alertForPwdComplexity3;
				}
				else if(temp == "sp")
				{
					_mid += "(?=.*[^0-9a-zA-Z])";
					result +=  alertForPwdComplexity4;
				}
			}
			var regExp = new RegExp(_start + _mid + _end);
			if(regExp.test(loginPassword))
			{
				result = "true";
			}
		}
		return result;
	},
	onCheck: function()
	{
		var Username = Ext.getCmp('unameID').getValue();
		var hiddenFields = publicJSON.usersExistJson;
		var usname = hiddenFields.usersexist;
		if(Username !=null && Username!="")
		{
			var userCheckEg = Ext.getCmp('egAuthentication').getValue();
			if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
			{
				if (Ext.getCmp('idpAuthSAML').getValue() == true)
				{
					userCheckEg = true;
				}
				else if (Ext.getCmp('eGAuthSAML').getValue() == true)
				{
					userCheckEg = true;
				}
			}


			if(usname!=null && usname!="" && userCheckEg == true)
			{
				var myarr = usname.split("|hash|");
				if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
				{
					if (Ext.getCmp('idpAuthSAML').getValue() == true)
					{
						var idpName = Ext.getCmp('idpName').getValue();
						Username = 'samlsso/'+idpName+'/'+Username;
					}
					else if (Ext.getCmp('domainAuthSAML').getValue() == true)
					{
						var domainname = Ext.getCmp('domainID').getValue();
						Username = domainname+'/'+Username;
					}
				}
				else if (Ext.getCmp('domainAuthentication').getValue() == true)
				{
					var domainname = Ext.getCmp('domainID').getValue();
					Username = domainname+'/'+Username;
				}
				if( Ext.Array.contains(myarr,Username) || Ext.Array.contains(myarr,Username.toLowerCase()) ||
					Ext.Array.contains(myarr,Username.toUpperCase()) )
				{
					Ext.getCmp('userImage').update('<center><img src="/final/images/spacer.gif" class="iconWrong" style="cursor:pointer;" border="0" width="15" height="10" data-qtip="User ID already exists" data-qclass="yellowtip"></center>')
				}
				else
				{
					Ext.getCmp('userImage').update('<center><img src="/final/images/spacer.gif" class="iconRight" style="cursor:pointer;" border="0" width="15" height="10" data-qtip="User ID available" data-qclass="yellowtip"></center>')
				}
				Ext.getCmp('userImage').show();
			}
		}
		else
		{
			Ext.getCmp('userImage').hide();
		}
	},
	buildMainData : function()
	{
		Ext.Ajax.request({
			url : appURL,
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},

	domainNameChange: function(obj)
	{
		var userId = Ext.getCmp('uidS').getValue();
		var domainForGroup = Ext.getCmp('domainID').getValue();

		var userRadioObj = Ext.getCmp('userId');
		var groupRadioObj = Ext.getCmp('groupId');

		if (userRadioObj.getValue())
		{
			operationTypeValue = 'User';
		}

		if (groupRadioObj.getValue())
		{
			operationTypeValue = 'Group';
		}

		var me = this;
		var selectedDomain = obj.getValue();
		if (selectedDomain != 'none' && selectedDomain != 'Choose a domain')
		{
			me.isPwdConfiguredWithSelectedDomain(selectedDomain);
			if (operationTypeValue == 'Group')
			{
				var authenticationType = Ext.getCmp('domainAuthentication').getGroupValue();
				if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
				{
					authenticationType = Ext.getCmp('domainAuthSAML').getGroupValue();
				}
				var urlString = "/final/admin/EgReplicateUser/data/EgReplicateUserJSON.jsp?uname="+userId+"&domain="+domainForGroup+"&operation="+operationTypeValue+"&authentication="+authenticationType+"&ldapPass="+encodeURIComponent(adDomainpwd);

				me.updateUserPage(urlString);
				Ext.getCmp('displayGroup').setValue('  ----Click on the icon to select a group----  ');
			}
			else
			{
				Ext.getCmp('operationID').setValue({
					operation : 'User'
				});

				Ext.suspendLayouts();
				Ext.getCmp('domainID').show();
				Ext.getCmp('operationID').show();
				Ext.getCmp('displayGroup').show();
				Ext.getCmp('validateID').show();

				Ext.getCmp('expiry_dateID').hide();
				Ext.getCmp('mailidormobileID').hide();
				Ext.getCmp('timeZoneID').hide();
				Ext.getCmp('languageNameID').hide();
				
				Ext.getCmp('userCont').show();
				Ext.getCmp('unameID').show();
				Ext.getCmp('unameID').setReadOnly(false);
				Ext.getCmp('passwordID').hide();
				Ext.getCmp('Retype_passwordID').hide();
				Ext.getCmp('grpnameContainer').hide();
				Ext.getCmp('replicateID').hide();

				Ext.getCmp('validateID').show();
				Ext.resumeLayouts(true);

				Ext.getCmp('unameID').reset();
			}
		}
		else
		{
			Ext.Msg.show({
				title: cloneUserTitle,
				msg: alertForNoDomain,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			Ext.getCmp('operationID').setValue({
				operation : 'User'
			});

			Ext.suspendLayouts();
			Ext.getCmp('domainID').show();
			Ext.getCmp('operationID').show();
			Ext.getCmp('displayGroup').show();
			Ext.getCmp('validateID').show();

			Ext.getCmp('expiry_dateID').hide();
			Ext.getCmp('mailidormobileID').hide();
			Ext.getCmp('timeZoneID').hide();
			Ext.getCmp('languageNameID').hide();

			Ext.getCmp('userCont').show();
			Ext.getCmp('unameID').show();
			Ext.getCmp('unameID').setReadOnly(false);
			Ext.getCmp('passwordID').hide();
			Ext.getCmp('Retype_passwordID').hide();
			Ext.getCmp('grpnameContainer').hide();
			Ext.getCmp('replicateID').hide();

			Ext.getCmp('validateID').show();
			Ext.resumeLayouts(true);

			Ext.getCmp('unameID').reset();
			return false;
		}
	},

	updateUserPage : function(urlStr)
	{
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},

	isPwdConfiguredWithSelectedDomain : function(selectedDomain)
	{
		var me = this;
		var params = "domainName="+selectedDomain+"&validatePwd=yes";
		var urlStr = "/final/servlet/com.egurkha.ADDomainAuth?"+params;
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var resObj = Ext.decode(response.responseText);
				if (resObj.isPasswordConfigured == false)
				{
					me.showAuthenticationWindow(resObj.domainName,resObj.domUser);
				}
			}
		});
	},

	showAuthenticationWindow : function(domainName,domUser)
	{
		Ext.widget("window",{
			title : domainNameCredentialLabel,
			id:'authWindow',
			width: 600,
			height: 170,
			modal : true,
			border : false,
			autoScroll:false,
			closeAction: 'destory',
			doClose: function() {
				Ext.getCmp("domainID").setValue('Choose a domain');
				this.destroy();
			},
			buttonAlign : 'center',
			items:[
				{
					xtype : 'container',
					layout : {
						type : 'vbox',
						align : 'center',
						pack : 'center',
						padding : '6'
					},
					defaults: {
						labelAlign : 'top',
						labelSeparator : '',
						margin : '5'
					},
					items : [
						{
							xtype : 'displayfield',
							fieldLabel : '<b>Domain User</b>',
							width : 320,
							value : domainName + "\\" + domUser
						},
						{
							xtype:'textfield',
							id: 'userInput',
							cls: 'textbox',
							fieldLabel : '<b>Domain User\'s Password</b>',
							width : 320,
							inputType : 'password',
						}
					]
				}
			],
			buttons : [
				{
					text : 'Submit',
					cls : 'quickMenuWhiteButton',
					handler : function()
					{
						var userInput = Ext.getCmp('userInput').getValue();
						if (userInput == null || userInput == "" || userInput.length == 0)
						{
							Ext.Msg.show({
								title: cloneUserTitle,
								msg: alertForNoPassword,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn : function(btn){
									Ext.getCmp('userInput').focus(true);
								}
							});
							return false;
						}
						adDomainpwd = userInput;
						Ext.getCmp('authWindow').destroy();
					}
				}
			]
		}).show();
	},

	afterMainRender: function()
	{
		var authenticationType = '';
		var usersToBeCloned = Ext.getCmp('uidS');
		var timeZoneToBeCloned = Ext.getCmp('timeZoneID');
		var countryCodeToBeCloned = Ext.getCmp('languageNameID');
		var isValidCloningUser = true;

		var isSAMLLoginEnabled = publicJSON.isSAMLLoginEnabled
		
		if (!Ext.isEmpty(isSAMLLoginEnabled) && isSAMLLoginEnabled)
		{
			Ext.getCmp('userAuthSAML').show();
			Ext.getCmp('userAuthSAML').setDisabled(false);

			Ext.getCmp('authenticationID').hide();
			Ext.getCmp('authenticationID').setDisabled(true);
		}
		else
		{
			Ext.getCmp('authenticationID').show();
			Ext.getCmp('authenticationID').setDisabled(false);

			Ext.getCmp('userAuthSAML').hide();
			Ext.getCmp('userAuthSAML').setDisabled(true);
		}

		if (!isEnterpriseModel)
		{
			Ext.getCmp('authenticationID').hide();
			Ext.getCmp('userAuthSAML').hide();
		}

		if (!Ext.isEmpty(isSAMLLoginEnabled) && isSAMLLoginEnabled)
		{
			authenticationType = Ext.getCmp('userAuthSAML').getValue().authenticationSAML;
		}
		else
		{
			var domainRadio = Ext.getCmp('domainAuthentication');
			var egRadio = Ext.getCmp('egAuthentication');

			var domainUsersObj = Ext.getCmp('domainID');

			if (domainRadio.getValue())
			{
				authenticationType = 'Domain';
			}

			if (egRadio.getValue())
			{
				authenticationType = 'Eg';
			}
		}

		var selectAllObj = Ext.getCmp('selectAllId');
		var checkboxGroupObj = Ext.getCmp('checkboxGroupId');

		if (selectAllObj.getValue())
		{
			checkboxGroupObj.setValue({rb1:
				['User_Preferences','Infrastructure_Elements','Exclude_Mail_Alerts','Live_Graph','Quick_Insights','Favorite_Measures','Custom_Dashboards','Favorites','Schedules','Configuration_Data','Quick_Menus','User_Experience_Dashboard','Business_Dashboards',/*'Fix_FeedbackAndHistory',*/'User_Reports','Maintenance_Policies','Booklets','Background_Reports','Citrix_Dashboards']
			});
		}
		else
		{
			checkboxGroupObj.setValue(false);
			checkboxGroupObj.setValue({rb1:
				['User_Preferences']});
		}

		var url = "/final/admin/EgReplicateUser/data/EgReplicateUserJSON.jsp?authentication="+authenticationType;

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				domainArrayJson = jsonData.domainArrayJson;

				var userCreated = jsonData.isUsersCreated;
				if (!Ext.isEmpty(userCreated) && userCreated)
				{
					usersToBeCloned.getStore().loadRawData(jsonData.usersArrayJson);
					usersToBeCloned.setValue(jsonData.usersArrayJson[0].valueField);

					var defaultTimeZoneJson = jsonData.timeZoneArrayJson[0].valueField;
					var defaultTimeZone = jsonData.defaultTimeZoneJson.defaultTimeZone;

					timeZoneToBeCloned.getStore().loadRawData(jsonData.timeZoneArrayJson);

					if (Ext.isEmpty(defaultTimeZone))
					{
						timeZoneToBeCloned.setValue(jsonData.timeZoneArrayJson[0].valueField);
					}
					else
					{
						timeZoneToBeCloned.setValue('default');
					}

					countryCodeToBeCloned.getStore().loadRawData(jsonData.countryArrayJson);
					countryCodeToBeCloned.setValue(jsonData.userLanguageJson.userLanguage);
				}
				else
				{
					Ext.getCmp('cloneUserCont').hide();
					Ext.getCmp('emptyCont').show();
				}
			}
		});

		var url = "/final/admin/EgReplicateUser/data/EgReplicateUserJSON.jsp?authentication=Domain";

		//Ext.Ajax.request(
			//{
				//url : url,
				//scope:this,
				//method : 'POST',
				//success: function(response){
					//var jsonText = response.responseText;
					//var jsonData = Ext.decode(jsonText);
					//domainArrayJson = jsonData.domainArrayJson;

					//if (authenticationType == 'Domain')
					//{
						//Ext.getCmp('validateID').show();
					//}
				//}
			//}
		//);

		if (authenticationType == 'Domain')
		{
			Ext.getCmp('validateID').show();
		}

		var pwdLength = publicJSON.pwdLength;
		var pwdComplexityCount = publicJSON.pwdComplexityCount;
		if (pwdLength == "" || pwdLength < 2)
		{
			pwdLength = 8;
		}
		else if(pwdLength != "" && pwdLength < pwdComplexityCount)
		{
			pwdLength = pwdComplexityCount;
		}
		Ext.getCmp('passScore').setText(passLabel1+" "+pwdLength+" "+passLabel2);

		if (!isEnterpriseModel)
		{
			Ext.getCmp('userAuthSAML').setDisabled(true);
			Ext.getCmp('eGAuthSAML').setValue(true);
		}
	},

	cloneFromComboChange: function()
	{
		var authenticationType = '';
		var usersToBeCloned = Ext.getCmp('uidS');
		var timeZoneToBeCloned = Ext.getCmp('timeZoneID');
		var countryCodeToBeCloned = Ext.getCmp('languageNameID');
		var isValidCloningUser = true;
		if (publicJSON.isSAMLLoginEnabled)
		{
			Ext.getCmp('userAuthSAML').reset();
		}
		else
		{
			Ext.getCmp('authenticationID').reset();
		}

		authenticationType = 'Eg';

		var url = "/final/admin/EgReplicateUser/data/EgReplicateUserJSON.jsp?authentication="+authenticationType;

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				//Ext.suspendLayouts();
				//Ext.getCmp('domainID').hide();
				//Ext.getCmp('operationID').hide();
				//Ext.getCmp('displayGroup').hide();
				//Ext.getCmp('validateID').hide();
				//Ext.getCmp('groupPopup').hide();
				//Ext.getCmp('grpnameContainer').hide();
				//Ext.getCmp('groupName').hide();
				//Ext.getCmp('unameID').show();
				//Ext.getCmp('passCont').show();
				//Ext.getCmp('passwordID').show();
				//Ext.getCmp('Retype_passwordID').show();
				//Ext.getCmp('expiry_dateID').show();
				//Ext.getCmp('mailidormobileID').show();
				//Ext.getCmp('timeZoneID').show();
				//Ext.getCmp('languageNameID').show();
				//Ext.getCmp('replicateID').show();
				//Ext.resumeLayouts(true);

				Ext.getCmp('unameID').reset();
				Ext.getCmp('passwordID').reset();
				Ext.getCmp('Retype_passwordID').reset();
				Ext.getCmp('tilldate').reset();
				Ext.getCmp('mailidormobileID').reset();
				Ext.getCmp('noExpiryField').reset();

				var defaultTimeZoneJson = jsonData.timeZoneArrayJson[0].displayField;
				var defaultTimeZone = jsonData.defaultTimeZoneJson.defaultTimeZone;

				timeZoneToBeCloned.getStore().loadRawData(jsonData.timeZoneArrayJson);

				if (Ext.isEmpty(defaultTimeZone))
				{
					timeZoneToBeCloned.setValue(jsonData.timeZoneArrayJson[0].valueField);
				}
				else
				{
					timeZoneToBeCloned.setValue('default');
				}

				countryCodeToBeCloned.getStore().loadRawData(jsonData.countryArrayJson);
				countryCodeToBeCloned.setValue(jsonData.userLanguageJson.userLanguage);

				var usersToBeCloned = Ext.getCmp('uidS').getValue();

				var url = "/final/admin/EgReplicateUser/data/EgReplicateUserJSON.jsp?authentication="+authenticationType+"&username="+usersToBeCloned;

				//Ext.Ajax.request(
				//{
					//url : url,
					//scope:this,
					//method : 'POST',
					//success: function(response){
						//var jsonText = response.responseText;
						//var jsonData = Ext.decode(jsonText);

						selectedDateFormat = jsonData.selectedDateFormatJson.selectedDateFormat;
					//}
				//});

				Ext.Ajax.request(
					{
					url : url,
					scope:this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						var org = jsonData.orgName;
						superOrg = jsonData.superOrgName;
						var uvalidtill = jsonData.uvalidtill;

						if (uvalidtill != null && uvalidtill != "12/12/9999")
						{
							Ext.getCmp('tilldate').setMaxValue(uvalidtill);
							Ext.getCmp('noExpiryField').setDisabled(true);
						}
						else
						{
							Ext.getCmp('tilldate').setMaxValue("12/12/9999");
							Ext.getCmp('noExpiryField').setDisabled(false);
						}
						Ext.getCmp('tilldate').setValue("");
						Ext.getCmp('noExpiryField').setValue("");

						//if (!Ext.isEmpty(org) && org.toLowerCase() == 'egenterprise')
						//{
							//Ext.getCmp('tilldate').setDisabled(false);
							//Ext.getCmp('noExpiryField').setDisabled(false);
						//}
						//else
						//{
							//if (uvalidtill != null && uvalidtill != "12/12/9999")
							//{
								//Ext.getCmp('tilldate').setValue(uvalidtill);
								//Ext.getCmp('noExpiryField').setValue(false);
							//}
							//else
							//{
								//Ext.getCmp('tilldate').setValue("");
								//Ext.getCmp('noExpiryField').setValue(true);
							//}
							//Ext.getCmp('tilldate').setDisabled(true);
							//Ext.getCmp('noExpiryField').setDisabled(true);
						//}
					}
				});

				if (!isEnterpriseModel)
				{
					Ext.getCmp('userAuthSAML').setDisabled(true);
					Ext.getCmp('userAuthSAML').hide();
					Ext.getCmp('authenticationID').setDisabled(true);
					Ext.getCmp('authenticationID').hide();
					Ext.getCmp('eGAuthSAML').setValue(true);
					Ext.getCmp('egAuthentication').setValue(true);
				}
				else
				{
					//Ext.getCmp('tilldate').setDisabled(false);
					//Ext.getCmp('noExpiryField').setDisabled(false);

					Ext.getCmp('userAuthSAML').setDisabled(false);
					Ext.getCmp('authenticationID').setDisabled(false);
					Ext.getCmp('eGAuthSAML').setValue(true);
					Ext.getCmp('egAuthentication').setValue(true);
				}
			}
		});
	},

	afterCloneSuccess: function()
	{
		var authenticationType = '';
		var usersToBeCloned = Ext.getCmp('uidS');
		var timeZoneToBeCloned = Ext.getCmp('timeZoneID');
		var countryCodeToBeCloned = Ext.getCmp('languageNameID');
		var authenticationId = Ext.getCmp('authenticationID');
		var isValidCloningUser = true;

		//var usersToBeClonedValue = Ext.getCmp('uidS').getValue();
		//var authenticationValue = Ext.getCmp('authenticationID').getValue();

		//var domainRadio = Ext.getCmp('domainAuthentication');
		//var egRadio = Ext.getCmp('egAuthentication');

		var domainUsersObj = Ext.getCmp('domainID');

		if (publicJSON.isSAMLLoginEnabled)
		{
			Ext.getCmp('userAuthSAML').reset();
		}
		else
		{
			authenticationId.reset();
		}

		authenticationType = 'Eg';

		var selectAllObj = Ext.getCmp('selectAllId');
		var checkboxGroupObj = Ext.getCmp('checkboxGroupId');

		selectAllObj.setValue('allCategory');
		checkboxGroupObj.setValue({rb1:
			['User_Preferences','Infrastructure_Elements','Exclude_Mail_Alerts','Live_Graph','Quick_Insights','Favorite_Measures','Custom_Dashboards','Favorites','Schedules','Configuration_Data','Quick_Menus','User_Experience_Dashboard','Business_Dashboards',/*'Fix_FeedbackAndHistory',*/'User_Reports','Maintenance_Policies','Booklets','Background_Reports','Citrix_Dashboards']
		});

		var url = "/final/admin/EgReplicateUser/data/EgReplicateUserJSON.jsp?authentication="+authenticationType;

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				usersToBeCloned.getStore().loadRawData(jsonData.usersArrayJson);
				usersToBeCloned.setValue(jsonData.usersArrayJson[0].valueField);

				Ext.getCmp('unameID').reset();
				Ext.getCmp('passwordID').reset();
				Ext.getCmp('Retype_passwordID').reset();
				Ext.getCmp('tilldate').reset();
				Ext.getCmp('mailidormobileID').reset();
				Ext.getCmp('noExpiryField').reset();
				Ext.getCmp('grpnameContainer').hide();

				var defaultTimeZoneJson = jsonData.timeZoneArrayJson[0].displayField;
				var defaultTimeZone = jsonData.defaultTimeZoneJson.defaultTimeZone;

				timeZoneToBeCloned.getStore().loadRawData(jsonData.timeZoneArrayJson);

				if (Ext.isEmpty(defaultTimeZone))
				{
					timeZoneToBeCloned.setValue(jsonData.timeZoneArrayJson[0].valueField);
				}
				else
				{
					timeZoneToBeCloned.setValue('default');
				}
				
				countryCodeToBeCloned.getStore().loadRawData(jsonData.countryArrayJson);
				countryCodeToBeCloned.setValue(jsonData.userLanguageJson.userLanguage);
			}
		});
	},

	cloneUpdate: function()
	{
		var authType = '';
		var operationTypeValue = '';
		var item = '';
		var displayItem = '';
		var me = this;

		var unameObj = Ext.getCmp('unameID');

		var userRadioObj = Ext.getCmp('userId');
		var groupRadioObj = Ext.getCmp('groupId');

		var operationType = '';
		var passwordObj = Ext.getCmp('passwordID');
		var retypePasswordValue = Ext.getCmp('Retype_passwordID').getValue();

		if (publicJSON.isSAMLLoginEnabled)
		{
			authType = Ext.getCmp('userAuthSAML').getValue().authenticationSAML;
		}
		else
		{
			var domainRadioObj = Ext.getCmp('domainAuthentication');
			var egRadioObj = Ext.getCmp('egAuthentication');

			if (domainRadioObj.getValue())
			{
				authType = 'Domain';
			}

			if (egRadioObj.getValue())
			{
				authType = 'Eg';
			}
		}

		if (userRadioObj.getValue())
		{
			operationTypeValue = 'User';
		}

		if (groupRadioObj.getValue())
		{
			operationTypeValue = 'Group';
		}

		var isValid = true;
		var isaCategory = false;

		var isValidated = '';
		var eedateforpro = '';
		var dateforpro = '';

		var checkboxGroupObj = Ext.getCmp('checkboxGroupId');
		var checkCategories = Ext.getCmp('checkboxGroupId').getChecked();

		var allCheckedCategory = '';

		for (var i=0; i<checkCategories.length; i++)
		{
			var aCategory = checkCategories[i];
			var inputValueForCategory = aCategory.inputValue;
			allCheckedCategory += inputValueForCategory + ',';
		}

		var url = "/final/admin/EgReplicateUser/data/EgReplicateUserJSON.jsp?authentication="+authType;

		var currentdate = '';
		var currenthr = '';
		var currentmin = '';
		var tillhr = '';
		var tillmin = '';
		var userExists = '';
		var isDoubleByte = '';
		var currentDateFormatVar = '';
		var pwdLen = '';
		var pwdComplexityCount = '';

		// for 2fa - starts here
		var isAdminEnabled2FA = '';
		var is2FACFlagEnabled = '';
		// for 2fa - ends here

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				async: false,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					currentdate = jsonData.currentDateJson.str_currentdate;
					currenthr = jsonData.currentHourJson.str_currenthr;
					currentmin = jsonData.currentMinJson.str_currentmin;
					tillhr = '00';
					tillmin = '00';
					userExists = jsonData.usersExistJson.usersexist;
					isDoubleByte = jsonData.isDoubleJson.isDouble;
					currentDateFormatVar = jsonData.currentDateFormatJson.currentDateFormat;

					pwdLen = jsonData.pwdLength;
					isAdminEnabled2FA = jsonData.isAdminEnabled2FA;
					is2FACFlagEnabled = jsonData.is2FACFlagEnabled;
					pwdComplexityCount = jsonData.pwdComplexityCount;
				}
			}
		);

		if (pwdLen == "" || pwdLen < 2)
		{
			pwdLen = 8;
		}
		else if(pwdLen != "" && pwdLen < pwdComplexityCount)
		{
			pwdLen = pwdComplexityCount;
		}

		var user_Id=true;
		var user_pwd=true;

		var never = Ext.getCmp('noExpiryField');
		var expiry_dateObj = Ext.getCmp('expiryField');

		var eedateforpro;
		var checkToStr;
		var tomail;
		if (isValidated == 'true' || authType == 'Eg' || operationTypeValue == 'Group' || authType == 'Domain')
		{
			tomail= Ext.getCmp('mailidormobileID');
			checkToStr = Ext.getCmp('mailidormobileID').getValue();
		}
		var regExp1 = /^(\+\d\d)?[0-9]+$/g;

		if (authType == 'Eg')
		{
			var unameValue = Ext.getCmp('unameID').getValue();
			var uname = Ext.getCmp('unameID').getValue();
			var passValue = Ext.getCmp('passwordID').getValue();
			var retypepassValue = Ext.getCmp('Retype_passwordID').getValue();
			var usname = userExists;
			var unameck = Ext.getCmp('unameID').getValue();
			var isLocal = "true";
		}

		if (operationTypeValue == 'User')
		{
			var uname = Ext.getCmp('unameID').getValue();
			var unameValue = Ext.getCmp('unameID').getValue();
			var usname = userExists;
			var unameck = Ext.getCmp('unameID').getValue();
		}

		if ((authType == 'Eg' || operationType == 'User' ) && (isValidated == 'true'))
		{
			var expiry_date = Ext.getCmp('tilldate');
			var expiryValue = Ext.getCmp('tilldate').getValue();
			var never = Ext.getCmp('noExpiryField');
		}
		else if (operationType == 'Group' && grpname != 'none')
		{
			var expiry_date = Ext.getCmp('tilldate');
			var expiryValue = Ext.getCmp('tilldate').getValue();
			var never = Ext.getCmp('noExpiryField');
		}

		if (authType == 'Eg')
		{
			var expiry_date = Ext.getCmp('tilldate');
			var expiryValue = Ext.getCmp('tilldate').getValue();
			var never = Ext.getCmp('noExpiryField');
		}

		if (authType == 'Domain')
		{
			var domainname = Ext.getCmp('domainID').getValue();
		}

		if (domainname =='none' || domainname == 'Choose a domain')
		{
			Ext.Msg.show({
				title: cloneUserTitle,
				msg: alertForNoDomain,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}

		if (unameck!=null&&unameck!="")
		{
			if (usname!=null&&usname!="")
			{
				var myarr = usname.split("|hash|");
				if (authType == 'SAML')
				{
					var idpName = Ext.getCmp('idpName').getValue();
					unameck = 'samlsso/'+idpName+"/"+unameck;
				}
				else if (authType == 'Domain')
				{
					var selectedDomain = Ext.getCmp('domainID').getValue();
					unameck= selectedDomain +"/"+unameck;
				}
				for (i=0;i<myarr.length;i++)
				{
					if (myarr[i].toLowerCase()==unameck.toLowerCase())
					{
						Ext.Msg.show({
							title: cloneUserTitle,
							msg: alertForAlreadyUser,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
					});
					return;
					}
				}
			}
		}

		var unameValue = Ext.getCmp('unameID').getValue();
		var unameObj = Ext.getCmp('unameID');
		var passwordValue = Ext.getCmp('passwordID').getValue();
		var passValue = Ext.getCmp('passwordID').getValue();
		var passObj = Ext.getCmp('passwordID');

		if (authType == 'SAML' )
		{
			var selectedIdp = Ext.getCmp('idpName').getValue();
			if (selectedIdp == 'none')
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: userIdpValidationMsg+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('idpName').focus(true);
					}
				});
				return;
			}
			
			if(!checkblank(unameValue))
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForUserId+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('unameID').focus(true);
					}
				});
				return;
			}
		}

		if (operationTypeValue == 'User' || authType == 'Eg')
		{
			if (isDoubleByte=='false')
			{
				user_Id = this.validateSingleByte();
				if (passwordValue!=null)
					user_pwd= this.validateSingleByte(passwordValue);
			}
			if (!user_Id)
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForSingleByte,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				isValid = false;
				return;
			}

			var isUserSelected = this.isUserIdSelected();
			if (!isUserSelected)
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForSelectionUser,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				isValid = false;
				return;
			}
			else if (unameValue == '')
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForUserId,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				isValid = false;
				return;
			}

			/* fix to find out whether user name starts or ends with space starts*/
			checkSpace = unameValue;
			if (checkSpace.indexOf(' ')==0) 
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForStartSpaceInId,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}

			if (checkSpace.lastIndexOf(' ')==checkSpace.length-1)//jamesthomas
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForEndSpaceInId,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}

			if (checkSpace.indexOf('  ')!=-1 || checkSpace.indexOf('--')!=-1 ||checkSpace.indexOf('__')!=-1 ||checkSpace.indexOf('..')!=-1)
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForSomeCharInId,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
			if (!checkSpecial(unameObj,"=\"/\\"))
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: _checkspecial,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						unameObj.focus();
					}
				});
				isValid = false;
				return;
			}
			else if(trim(unameValue) == "")
			{
				isValid = false;
				return;
			}
			else if (unameValue.indexOf("..") > -1)
			{
				isValid = false;
				return;
			}
			else if (unameValue.toUpperCase() == "ADMIN" || unameValue.toUpperCase() == "SUPERMONITOR" || unameValue.toUpperCase() == "MONITOR" )
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForOtherManager + thisForm.uname.value + "'.",
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				isValid = false;
				return;
			}

			if (unameValue.toUpperCase() == "NULL")
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForNullId + thisForm.uname.value + "'.",
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			if (!Ext.isEmpty(enforceEmailIDInMSP) && enforceEmailIDInMSP.toLowerCase() == 'true')
			{
				if(superOrg != null && superOrg.toLowerCase() != 'egenterprise')
				{
					var regExp = /[\#]?([a-zA-Z0-9]+[\#\ \_\.\-\&]?)*[a-zA-Z0-9]\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]/g;
					var toMailResult= unameValue.match(regExp);
					if (toMailResult != unameValue.toString())
					{
						Ext.Msg.show({
							title: cloneUserTitle,
							msg: userIDEmailValidationMsg+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn){
								unameObj.focus(true);
							}
						});
						return false;
					}
				}
			}
		}

		if (authType=='Eg')
		{
			var pwdComplexity = me.pwdComplexityCheck(passValue);
			if (passValue == '')
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForNoPassword,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				isValid = false;
				return;
			}
			else if (isLocal == 'true' && passValue.length < pwdLen)
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: passLabel1+" "+pwdLen+" "+passLabel2,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				isValid = false;
				return;
			}
			else if (isLocal == 'true' && !checkloginpass(passwordObj))
			{
				isValid = false;
				return;
			}
			else if(isLocal == 'true' && pwdComplexity.indexOf("false") > -1)
			{
				var resMsg = pwdComplexity.substring(pwdComplexity.indexOf("false#")+6);
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForPwdComplexity5+". "+passLabel1+" "+resMsg+ ".",
					width : 400,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						passObj.focus(true);
					}
				});
				return false;
			}
			else if (isLocal == 'true' && !user_pwd)
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForPasswordDBL,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				isValid = false;
				return;
			}
			else if (isLocal == 'true' && retypePasswordValue == "")
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForPasswordRetype,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				isValid = false;
				return;
			}
			else if (passValue != retypePasswordValue)
			{
				Ext.Msg.show({
					title: cloneUserTitle,
					msg: alertForPasswordMismatch,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				isValid = false;
			}
		}
		else if (authType == 'Domain')
		{
			if (operationTypeValue != null && operationTypeValue == 'Group')
			{
				var grpname = Ext.getCmp('displayGroup').getValue();
				if (grpname == '' || grpname == "  ----Click on the icon to select a group----  ")
				{
					Ext.Msg.show({
						title: cloneUserTitle,
						msg: alertForNoGroup,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
				//else
				//{
					//Ext.getCmp('groupName').setValue(grpname);
				//}
			}
		}

		if (isValidated == 'true' || authType == 'Eg' || operationTypeValue == 'Group' || authType == 'Domain')
		{
			var expiry_date = Ext.getCmp('tilldate');
			if (never.checked == false)
			{
				var comFormat = currentDateFormatVar;
				var ssdate = "";
				if (currentdate != null && currentdate != 'undefined')
				{
					ssdate = currentdate;
				}

				var expiryValue = Ext.getCmp('tilldate').getValue();
				var formattedDate = Ext.Date.format(expiryValue,'m/d/Y');

				if (!Ext.isEmpty(expiryValue) && expiryValue != '')
				{
					Ext.getCmp('noExpiryField').setValue(false);
				}
				eedateforpro = formattedDate;
				var checkBlank = this.checkblank(formattedDate);
				var checkTime = this.checkTime(ssdate,eedateforpro,currenthr,tillhr,currentmin,tillmin);

				if (checkBlank == false)
				{
					Ext.Msg.show({
						title: cloneUserTitle,
						msg: alertForValidatyDate,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					isValid = false;
					return;
				}
				else if (checkTime == false)
				{
					Ext.Msg.show({
						title: cloneUserTitle,
						msg: alertForValidatyCheck,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					isValid = false;
					return;
				}
			}
		}

		if (isValidated == 'true' || authType == 'Eg' || operationTypeValue == 'Group' || authType == 'Domain')
		{
			if (checkToStr != "")
			{
				var checkToStrArr = checkToStr.split(",");
				if(checkToStrArr != null && checkToStrArr.length > 0)
				{
					for(var i=0; i<checkToStrArr.length; i++)
					{
						var tempVal = checkToStrArr[i].toString();
						if(tempVal.indexOf("@") == -1 || tempVal.indexOf(".") == -1)
						{
							var tempResult = tempVal.match(regExp1);
							if(tempResult == null || tempResult != tempVal)
							{
								Ext.Msg.show({
									title: cloneUserTitle,
									msg: alertForEmailOrMobile,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
								tomail.focus();
								isValid = false;
								return;
							}
						}
						else
						{
							if(!validateSingleByte(tempVal))
							{
								Ext.Msg.show({
									title: cloneUserTitle,
									msg: alertForDBLInToMail,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
								tomail.focus();
								isValid = false;
								return;
							}
							else if(!validateEmail(tempVal))
							{
								Ext.Msg.show({
									title: cloneUserTitle,
									msg: alertForEmailOrMobile,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
								tomail.focus();
								isValid = false;
								return;
							}					
						}
					}
				}
			}
		}

		if (isValidated == "false" && authType == 'Domain' && operationTypeValue == 'User')
		{
			isValid = false;
			Ext.Msg.show({
				title: cloneUserTitle,
				msg: alertForIsValidated,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		isaCategory = this.isSelectedAny();
		if (isaCategory == false)
		{
			Ext.Msg.show({
				title: cloneUserTitle,
				msg: alertForNoCategory,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		if (isValid && isaCategory)
		{
			var expiryValue = Ext.getCmp('tilldate').getValue();
			var never = Ext.getCmp('noExpiryField').getValue();
			if (never)
			{
				never = 'Never';
			}
			var authentication = authType;
			var formattedDate = Ext.Date.format(expiryValue,'m/d/Y');

			var parameters = "dateforpro="+formattedDate+"&authentication="+authentication+"&operation="+operationTypeValue+"&categoryCheck="+allCheckedCategory+"&userDateFormat="+selectedDateFormat+'&never='+never;

			if (!Ext.isEmpty(isAdminEnabled2FA) && (isAdminEnabled2FA.toLowerCase() == "true" || isAdminEnabled2FA.toLowerCase() == "yes") &&
				!Ext.isEmpty(is2FACFlagEnabled) && (is2FACFlagEnabled.toLowerCase() == "true" || is2FACFlagEnabled.toLowerCase() == "yes"))
			{
				var mailIDVal = Ext.getCmp('mailidormobileID').getValue();

				if (Ext.isEmpty(mailIDVal) || Ext.String.trim(mailIDVal).length == 0)
				{
					Ext.Msg.show({
						title: cloneUserTitle,
						msg: maidIDAlertMsg,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return;
				}
				parameters += '&mailIDVal='+mailIDVal;
			}

			var cloneForm = this.getCloneuser().getForm();

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Processing...'});
			myMask.show();

			if (cloneForm.isValid())
			{

				var unameValue = Ext.getCmp('unameID').getValue();
				unameValue = parent.filterEncode(unameValue);
				Ext.getCmp('unameID').setValue(unameValue);
				var passwordValue = Ext.getCmp('passwordID').getValue();
				passwordValue = parent.filterEncode(passwordValue);
				Ext.getCmp('passwordID').setValue(passwordValue);
				Ext.getCmp('Retype_passwordID').setValue(passwordValue);

				cloneForm.submit({
					url: '/final/admin/EgReplicateUser/data/EgReplicateUserJSONp.jsp?',
					params: parameters,
					method: 'POST',
					success: function(form, action){
						var jsonText = action.response.responseText;
						var jsonData = Ext.decode(jsonText);
						var error = jsonData.error;
						if(error != null && !error)
						{
							Ext.Msg.show({
								title: cloneUserTitle,
								msg: cloneUserMessage,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
							me.afterCloneSuccess();
							myMask.hide();
						}
						else
						{
							var twoFAMailSend = jsonData.TwoFAMailSend;
							if (!Ext.isEmpty(twoFAMailSend) && twoFAMailSend.toLowerCase() == "failed")
							{
								var mailSendErrMsg = jsonData.MailSendErrMsg;
								Ext.Msg.show({
									title: pageTitle,
									msg: mailSendErrMsg + ".",
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}

							var errorMsg = jsonData.errorMsg;
							Ext.Msg.show({
								title: cloneUserTitle,
								msg: errorMsg.message1 +' . '+errorMsg.message2,
								buttons: Ext.Msg.OK,
								icon: 'iconError'
							});
							myMask.hide();
						}
					}
				});
			}
		}
	},

	radioChanged: function(obj, newValue, oldValue, eOpts)
	{
		var authenticationType = '';
		var userToClone = Ext.getCmp('uidS').getValue();
		Ext.getCmp('userId').setValue('User');

		if (userToClone == 'Choose a user')
		{
			Ext.suspendLayouts();
			Ext.getCmp('domainID').hide();
			Ext.getCmp('operationID').hide();
			Ext.getCmp('displayGroup').hide();
			Ext.getCmp('validateID').hide();
			Ext.getCmp('groupPopup').hide();
			Ext.getCmp('grpnameContainer').hide();
			Ext.getCmp('groupName').hide();
			Ext.getCmp('unameID').show();
			Ext.getCmp('unameID').setReadOnly(false);
			Ext.getCmp('passCont').show();
			Ext.getCmp('passwordID').show();
			Ext.getCmp('Retype_passwordID').show();
			Ext.getCmp('expiry_dateID').show();
			Ext.getCmp('mailidormobileID').show();
			Ext.getCmp('timeZoneID').show();
			Ext.getCmp('languageNameID').show();
			Ext.getCmp('replicateID').show();
			Ext.getCmp('idpName').hide();
			Ext.resumeLayouts(true);

			Ext.getCmp('unameID').reset();


			Ext.Msg.show({
				title: cloneUserTitle,
				msg: chooseToCloneCombo,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			if (publicJSON.isSAMLLoginEnabled)
			{
				Ext.getCmp('userAuthSAML').reset();
			}
			else
			{
				Ext.getCmp('authenticationID').reset();
			}
			return;
		}

		
		if (obj.id == 'userAuthSAML')
		{
			authenticationType = newValue.authenticationSAML
		}
		else
		{
			authenticationType = newValue.authentication
		}
		if (authenticationType == 'Domain')
		{
			Ext.suspendLayouts();
			Ext.getCmp('domainID').show();
			Ext.getCmp('operationID').show();
			Ext.getCmp('displayGroup').show();
			Ext.getCmp('validateID').show();
			Ext.getCmp('unameID').show();
			Ext.getCmp('passwordID').hide();
			Ext.getCmp('passCont').hide();
			Ext.getCmp('Retype_passwordID').hide();
			Ext.getCmp('expiry_dateID').hide();
			Ext.getCmp('mailidormobileID').hide();
			Ext.getCmp('timeZoneID').hide();
			Ext.getCmp('languageNameID').hide();
			Ext.getCmp('replicateID').hide();
			Ext.getCmp('validateID').show();
			Ext.resumeLayouts(true);
			Ext.getCmp('idpName').hide();

			Ext.getCmp('unameID').reset();
		}
		else if (authenticationType == "SAML")
		{
			Ext.suspendLayouts();
			Ext.getCmp('idpName').show();
			Ext.getCmp('idpName').setDisabled(false);
			Ext.getCmp('validateID').hide();
			Ext.getCmp('unameID').setReadOnly(false);
			
			Ext.getCmp('domainID').hide();
			Ext.getCmp('operationID').hide();
			Ext.getCmp('passwordID').hide();
			Ext.getCmp('passCont').hide();
			Ext.getCmp('Retype_passwordID').hide();
			var idps = Ext.getCmp('idpName');
			idps.getStore().loadRawData(publicJSON['ssoList']);
			idps.setValue(idps.getStore().getAt(0).get("valueField"));
			Ext.getCmp('expiry_dateID').show();
			Ext.getCmp('mailidormobileID').show();
			Ext.getCmp('timeZoneID').show();
			Ext.getCmp('languageNameID').show();
			Ext.getCmp('replicateID').show();
			Ext.resumeLayouts(true);

		}
		else if (authenticationType == 'Eg')
		{
			Ext.suspendLayouts();
			Ext.getCmp('domainID').hide();
			Ext.getCmp('operationID').hide();
			Ext.getCmp('displayGroup').hide();
			Ext.getCmp('validateID').hide();
			Ext.getCmp('groupPopup').hide();
			Ext.getCmp('grpnameContainer').hide();
			Ext.getCmp('groupName').hide();
			Ext.getCmp('unameID').show();
			Ext.getCmp('unameID').setReadOnly(false);
			Ext.getCmp('passCont').show();
			Ext.getCmp('passwordID').show();
			Ext.getCmp('Retype_passwordID').show();
			Ext.getCmp('expiry_dateID').show();
			Ext.getCmp('mailidormobileID').show();
			Ext.getCmp('timeZoneID').show();
			Ext.getCmp('languageNameID').show();
			Ext.getCmp('replicateID').show();
			Ext.getCmp('idpName').hide();
			Ext.resumeLayouts(true);

			Ext.getCmp('unameID').reset();
		}

		var domainUsersObj = Ext.getCmp('domainID');
		domainUsersObj.getStore().loadRawData(domainArrayJson);
		domainUsersObj.setValue(domainArrayJson[0].valueField);
	},

	noExpiryChange: function()
	{
		if (Ext.getCmp('noExpiryField').getValue())
		{
			Ext.getCmp('tilldate').setValue('');
			Ext.getCmp('tilldate').disable();
		}
		else
		{
			Ext.getCmp('tilldate').enable();
		}
	},

	operationRadioChanged: function()
	{
		var authenticationType = '';

		if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
		{
			authenticationType = Ext.getCmp('userAuthSAML').getValue().authenticationSAML;
		}
		else
		{
			var domainRadio = Ext.getCmp('domainAuthentication');
			var egRadio = Ext.getCmp('egAuthentication');

			if (domainRadio.getValue())
			{
				authenticationType = 'Domain';
			}

			if (egRadio.getValue())
			{
				authenticationType = 'Eg';
			}
		}

		var userRadio = Ext.getCmp('userId');
		var groupRadio = Ext.getCmp('groupId');

		var userId = Ext.getCmp('uidS').getValue();
		var domainForGroup = Ext.getCmp('domainID').getValue();

		if (domainForGroup == 'Choose a domain')
		{
			Ext.Msg.show({
				title: cloneUserTitle,
				msg: alertForNoDomain,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			Ext.getCmp('operationID').reset();
			return;
		}

		if (groupRadio.getValue())
		{
			Ext.suspendLayouts();
			Ext.getCmp('grpnameContainer').show();
			Ext.getCmp('validateID').hide();
			Ext.getCmp('expiry_dateID').show();
			Ext.getCmp('mailidormobileID').show();
			Ext.getCmp('timeZoneID').show();
			Ext.getCmp('languageNameID').show();
			Ext.getCmp('replicateID').show();
			Ext.getCmp('groupPopup').show();

			Ext.getCmp('unameID').hide();
			Ext.getCmp('userCont').hide();
			Ext.resumeLayouts(true);
		}

		if (userRadio.getValue())
		{
			Ext.suspendLayouts();
			Ext.getCmp('domainID').show();
			Ext.getCmp('operationID').show();
			Ext.getCmp('displayGroup').show();
			Ext.getCmp('validateID').show();

			Ext.getCmp('expiry_dateID').hide();
			Ext.getCmp('mailidormobileID').hide();
			Ext.getCmp('timeZoneID').hide();
			Ext.getCmp('languageNameID').hide();
			
			Ext.getCmp('userCont').show();
			Ext.getCmp('unameID').show();
			Ext.getCmp('unameID').setReadOnly(false);
			Ext.getCmp('passwordID').hide();
			Ext.getCmp('Retype_passwordID').hide();
			Ext.getCmp('grpnameContainer').hide();
			Ext.getCmp('replicateID').hide();

			Ext.getCmp('validateID').show();
			Ext.resumeLayouts(true);
			Ext.getCmp('unameID').reset();
		}

		var userRadioObj = Ext.getCmp('userId');
		var groupRadioObj = Ext.getCmp('groupId');

		if (userRadioObj.getValue())
		{
			operationTypeValue = 'User';
		}

		if (groupRadioObj.getValue())
		{
			operationTypeValue = 'Group';
		}

		Ext.getCmp('displayGroup').setValue('  ----Click on the icon to select a group----  ');
		Ext.getCmp('tilldate').reset();

		//var authenticationType = '';

		//var domainRadio = Ext.getCmp('domainAuthentication');
		//var egRadio = Ext.getCmp('egAuthentication');

		//if (domainRadio.getValue())
		//{
			//authenticationType = 'Domain';
		//}

		//if (egRadio.getValue())
		//{
			//authenticationType = 'Eg';
		//}

		var userId = Ext.getCmp('uidS').getValue();
		var domainForGroup = Ext.getCmp('domainID').getValue();

		var userRadioObj = Ext.getCmp('userId');
		var groupRadioObj = Ext.getCmp('groupId');

		if (userRadioObj.getValue())
		{
			operationTypeValue = 'User';
		}

		if (groupRadioObj.getValue())
		{
			operationTypeValue = 'Group';
		}

		var domainURL = "/final/admin/EgReplicateUser/data/EgReplicateUserJSON.jsp?uname="+userId+"&domain="+domainForGroup+"&operation="+operationTypeValue+"&authentication="+authenticationType+"&ldapPass="+encodeURIComponent(adDomainpwd);

		Ext.Ajax.request({
			url : domainURL,
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});

	},

	onValidate: function()
	{
		var sub = true;
		var authenticationType='';

		var cloningUser = Ext.getCmp('uidS').getValue();
		var isRefresh = 'subseq';
		var isValidated = true;

		if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
		{
			authenticationType = Ext.getCmp('userAuthSAML').getValue().authenticationSAML;
		}
		else
		{
			var domainRadio = Ext.getCmp('domainAuthentication');
			var egRadio = Ext.getCmp('egAuthentication');

			if (domainRadio.getValue())
			{
				authenticationType = 'Domain';
			}

			if (egRadio.getValue())
			{
				authenticationType = 'Eg';
			}
		}

		var url = "/final/admin/EgReplicateUser/data/EgReplicateUserJSON.jsp?authentication="+authenticationType;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var userExists = jsonData.usersExistJson.usersexist;

					var domainname = Ext.getCmp('domainID').getValue();
					var unameObj = Ext.getCmp('unameID');
					var uname = unameObj.getValue();
					var usname = userExists;
					var eedateforpro;
					var unameck = Ext.getCmp('unameID').getValue();
					if(unameck!=null&&unameck!="")
					{
						if(usname!=null&&usname!="")
						{
							var myarr = usname.split("|hash|");
							if (authenticationType == 'Domain')
								unameck = domainname +"/"+unameck
							for (i=0;i<myarr.length;i++)
							{
								if(myarr[i].toLowerCase()==unameck.toLowerCase())
								{
									Ext.Msg.show({
										title: cloneUserTitle,
										msg: alertForAlreadyUser,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
									sub = false;
									return;
								}
							}
						}
					}
					if (domainname =='Choose a domain')
					{
						Ext.Msg.show({
							title: cloneUserTitle,
							msg: alertForNoDomain,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						sub = false;
						return;
					}
					if (!checkblank(uname))
					{
						Ext.Msg.show({
							title: cloneUserTitle,
							msg: alertForUserId,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						sub = false;
						return;
					}
					else if (!checkSpecial(unameObj,"=\"/\\"))
					{
						Ext.Msg.show({
							title: cloneUserTitle,
							msg: _checkspecial,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function()
							{
								unameObj.focus();
							}
						});
						sub = false;
						return;
					}
					else if (trim(uname) == "")
					{
						sub = false;
						return;
					}
					else if (uname.indexOf("..") > -1)
					{
						Ext.Msg.show({
							title: cloneUserTitle,
							msg: alertForDoubleDots,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						sub = false;
						return;
					}

					var urlForValidation = "/final/admin/EgReplicateUser/data/EgReplicateUserJSON.jsp?authentication="+authenticationType+"&uname="+encodeURIComponent(uname)+"&domain="+encodeURI(domainname)+"&cloningUser="+encodeURIComponent(cloningUser)+"&isRefresh="+isRefresh+"&cloningUser="+encodeURIComponent(cloningUser)+"&isValidated="+isValidated+"&ldapPass="+encodeURIComponent(adDomainpwd);

					Ext.Ajax.request(
					{
						url : urlForValidation,
						scope:this,
						method : 'POST',
						success: function(response){
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);

							var isValidUser = jsonData.validatedUserJson.isValidUserForJSON;

							if (isValidUser == 'true')
							{
								Ext.getCmp('unameID').setReadOnly(true);
								Ext.getCmp('expiry_dateID').show();
								Ext.getCmp('mailidormobileID').show();
								Ext.getCmp('timeZoneID').show();
								Ext.getCmp('languageNameID').show();
								Ext.getCmp('replicateID').show();
								Ext.getCmp('validateID').hide();
							}
							else
							{
								Ext.Msg.show({
									title: cloneUserTitle,
									msg: alertForNoValidUser,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
								Ext.getCmp('expiry_dateID').hide();
								Ext.getCmp('mailidormobileID').hide();
								Ext.getCmp('timeZoneID').hide();
								Ext.getCmp('languageNameID').hide();
								Ext.getCmp('replicateID').hide();
								Ext.getCmp('validateID').show();
							}
						}
					});
				}
			}
		);
	},

	validateSingleByte: function(input)
	{
		for(var i=0;i<input.length;i++)
		{
			var charValue=input.charCodeAt(i);
			if(charValue>255)
				return false;
		}
		return true;
	},

	isUserIdSelected: function()
	{
		var selectVal = Ext.getCmp('uidS').getValue();
		if (selectVal != 'Choose a user')
		{
			return true;
		}
		return false;
	},

	isSelectedAny: function()
	{
		var checkedComp = Ext.getCmp('checkboxGroupId').getChecked();

		for (var j=0;j<checkedComp.length;j++)
		{
			var checkedItem = checkedComp[j];
			if(checkedItem.getValue())
				return true;
		}
		return false;
	},

	checkblank: function(fieldValue)
	{
		var int_Flag = 0;

		if(typeof(field)=='object')
		{
			str_Value = fieldValue;
		}
		else
		{
			str_Value = fieldValue;
		}
		if(str_Value.length==0)
		{
			int_Flag=0;
		}
		for(i=1;i<=str_Value.length ;i++)
		{
			if(str_Value.charAt(i-1) == " ")
			{
				int_Flag=0;
			}
			else
			{
				int_Flag = 1;
				break;
			}
		}
		if(int_Flag != 1)
		{
			return false;
		}
		return true;
	},

	checkTime: function(timstart,timend,startHr,endHr,startMin,endMin)
	{
		var slen = startHr.length;
		if(slen == 1 )
		{
			startHr = "0" + startHr;
		}

		var elen = endHr.length;
		if(elen == 1)
		{
			endHr = "0" + endHr;
		}

		var sminlen = startMin.length;
		if(sminlen == 1)
		{
			startMin = "0" + startMin;
		}

		var eminlen = endMin.length;
		if(eminlen == 1)
		{
			endMin  = "0" + endMin;
		}

		var startmon = timstart.substring(0,timstart.indexOf("/"));
		var interstartmon = timstart.substring(timstart.indexOf("/")+1);
		var startday = interstartmon.substring(0,interstartmon.indexOf("/"));
		var startyear = interstartmon.substring(interstartmon.indexOf("/")+1);
		var startdate = startyear + startmon + startday + startHr + startMin;
		var endmon = timend.substring(0,timend.indexOf("/"));
		var interendmon = timend.substring(timend.indexOf("/")+1);
		var endday = interendmon.substring(0,interendmon.indexOf("/"));
		var endyear = interendmon.substring(interendmon.indexOf("/")+1);
		var enddate = endyear + endmon + endday + endHr + endMin;

		if(startdate > enddate || startdate == enddate)
		{
			return false;
		}
		else
		{
			return true;
		}
		return true;
	},

	applyGroupName: function()
	{
		var item = "";
		var displayItem = "";
		c = 0;
		if (groupArray != null && groupArray.length > 0)
		{
			for (i=0;i<groupArray.length;i++)
			{
				if (groupArray[i] != null && groupArray[i] != "undefined")
				{
					if (c == 0)
					{
						item = item + groupArray[i];
						displayItem = displayItem + groupArray[i];
					}
					else
					{
						item = item +"|#|"+groupArray[i];
						displayItem = displayItem +","+groupArray[i];
					}
					c++;
				}
			}

			Ext.getCmp('displayGroup').setValue(displayItem);
			Ext.getCmp('groupName').setValue(item);
			groupArray = new Array();
			Ext.getCmp('groupWindow').destroy();
			Ext.Ajax.request({
				url:'EgReplicateUser/data/EgReplicateUserJSON.jsp',
				method:'POST'
			});
		}
		else
		{
			Ext.Msg.show({
				title: cloneUserTitle,
				msg: alertForNoGroup,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}
	},

	viewSelections: function()
	{
		Ext.widget("window",{
		extend:'Ext.container.Container',
		alias:'widget.viewSelections',
		title : 'Group Selections',
		id:'viewWindow',
		width: 300,
		height: 300,
		padding : '5px',
		modal : true,
		border : false,
		floatable:true,
		floating :true,
		autoScroll:false,
		closeAction: 'destory',
		doClose: function() {
			this.destroy();
		},
		layout:{
			type:'fit'
		},
		items:[{
			xtype : 'viewselections'
		}]
		}).show();

		var isGroupAvailable = "0";
		var labelToViewObj = Ext.getCmp('labelID');

		var htmlInput = "<table align='center' width='100%' class='tableborder_ad' cellpadding='4' cellspacing='0'>";

		for (i=0;i<groupArray.length;i++)
		{
			if (groupArray[i] != null && groupArray[i] != "undefined")
			{
				isGroupAvailable = "1";
				htmlInput = htmlInput + "<tr><td class='tdborder_ad' valign='top' style='font:5;width:100%;padding:2px;'>"+groupArray[i].replace(/</g,"&lt;").replace(/>/g,"&gt;")+"</td></tr>";
			}
		}

		if (isGroupAvailable == "0")
		{
			return false;
		}
		htmlInput = htmlInput +"</table>";
		labelToViewObj.setText(htmlInput,false);
	},

	selectAllOrDeselect: function()
	{
		var selectAllObj = Ext.getCmp('selectAllId');
		var checkboxGroupObj = Ext.getCmp('checkboxGroupId');

		if (selectAllObj.getValue())
		{
			checkboxGroupObj.setValue({rb1:
				['User_Preferences','Infrastructure_Elements','Exclude_Mail_Alerts','Live_Graph','Quick_Insights','Favorite_Measures','Custom_Dashboards','Favorites','Schedules','Configuration_Data','Quick_Menus','User_Experience_Dashboard','Business_Dashboards',/*'Fix_FeedbackAndHistory',*/'User_Reports','Maintenance_Policies','Booklets','Background_Reports','Citrix_Dashboards']
			});
		}
		else
		{
			checkboxGroupObj.setValue(false);
			checkboxGroupObj.setValue({rb1:
				['User_Preferences']});
		}
	},
	
	selectCheckBox: function()
	{
		var checkboxGroupObj = Ext.getCmp('checkboxGroupId');
		var checkboxChecked = checkboxGroupObj.getChecked();

		if (checkboxChecked.length < 11)
		{
			Ext.getCmp('selectAllId').setValue(false);
		}

		if (checkboxChecked.length == 11)
		{
			Ext.getCmp('selectAllId').setValue('allCategory');
		}
	},

});

function addData(items,displayItems)
{
	Ext.getCmp('displayGroup').setValue(displayItems);
	Ext.getCmp('groupName').setValue(items);
	Ext.getCmp('groupWindow').destroy();
}

function addGroupToArrayInCtrll(obj)
{
	var groupArray = new Array();
	var i = 0;
	if (obj.checked == true)
	{
		groupArray[i++] = obj.value;
	}
	else
	{
		var index = groupArray.indexOf(obj.value);
		groupArray.splice(index,1);
	}
}

function loadTree()
{
	selectedDomainDisplayName = Ext.getCmp('domainID').getValue();
	Ext.widget("window",{
		extend:'Ext.container.Container',
		alias:'widget.groupWindow',
		title : 'Domain Groups',
		id:'groupWindow',
		padding : '5px 10px 10px 10px',
		modal : true,
		border : false,
		floatable:true,
		floating :true,
		autoScroll:false,
		resizable: false,
		closeAction: 'destory',
		doClose: function() {
			groupArray = new Array();
			Ext.Ajax.request({
				url:'EgReplicateUser/data/EgReplicateUserJSON.jsp',
				method:'POST'
			});
			this.destroy();
		},
		layout:{
			type:'auto',
		},
		items:[{
			width: 900,
			height: 450,
			xtype : 'egdomaingrouptree'
		},
		{
			xtype: 'button',
			text: 'View Selection',
			id: 'viewSelect',
			width: 100,
			cls:'button20',
			margin: '2 0 10 360',
			handler: thisController.viewSelections,
		},
		{
			xtype: 'button',
			text: 'Apply',
			id: 'applyBtn',
			width: 80,
			cls:'button20',
			margin: '2 0 10 20',
			handler: thisController.applyGroupName,
		}]
	}).show();
}

function setSelectedGroupName(grpName)
{
	if (grpName != null && grpName.length > 0)
	{
		Ext.getCmp('displayGroup').setValue(grpName);
	}
	Ext.getCmp('groupWindow').destroy();
}

function setWindowTitle(title)
{
	Ext.getCmp('rightPane').setTitle(title);
}

function checkSpecial(field,s_spl)
{
	obj_val = field.value;
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			//alert(_checkspecial);
			return false;
		}
	}
	return true;
}


