Ext.define('EgReportCustomSetting.controller.Main',{
	extend:'Ext.app.Controller',
	views:['CapacityPlanning','Associates'],
	refs:[
		{selector:'capacityplanning', ref:'capacityplanning'},
		{selector:'configTests', ref:'configTests'},
		{selector:'configSystemReports', ref:'configSystemReports'},
		{selector:'associates', ref:'associates'},
		{selector:'addModifyPolicy', ref:'addModifyPolicy'}
	],
	init:function(){
		thisController = this;
		var allMeasuresArray;
		var allPolicyArray;
		var allReportViewArray;
		this.control({
			'capacityplanning':
			{
				'afterrender': this.afterMainRender
			},
			'capacityplanning tabpanel[id="capPlanTabs"]':
			{
				'tabchange': this.tabChange
			},
			'capacityplanning tabpanel[id="configTestTab"]':
			{
				'activate': this.configTestTab
			},
			'addModifyPolicy button[id="UpdateBtn"]':
			{
				'click': this.update
			},
			'capacityplanning button[id="modifyBtn"]':
			{
				'click': this.modifyUpdate
			},
			'capacityplanning button[id="addNew"]':
			{
				'click': this.addNewPolicy
			},
			'addModifyPolicy combo[id="percentilePoliciesForModify"]':
			{
				'select': this.modifyPolicyComboChange
			},
			'capacityplanning checkbox[id="allCheckboxId"]':
			{
				'change': this.checkBoxOnChange
			},
			'capacityplanning actioncolumn[id="modifyInView"]':
			{
				'click': this.modifyPolicyInView
			},
			'capacityplanning actioncolumn[id="showAssociates"]':
			{
				'click': this.goToAssociates
			},
			'capacityplanning combo[id="componentType"]':
			{
				'select': this.compTypeChange
			},
			'capacityplanning combo[id="testName"]':
			{
				'select': this.testNameChange
			},
			'capacityplanning combo[id="cpctEnabledTest"]':
			{
				'select': this.cpctEnabledTestChange
			},
			'capacityplanning combo[id="capacityTestStatus"]':
			{
				'select': this.capacityTestStatusChange
			},
			'capacityplanning radio[id="enableRadio"]':
			{
				'change': this.disableRadioChange
			},
			'capacityplanning radio[id="disableRadio"]':
			{
				'change': this.enableRadioChange
			},
			'capacityplanning button[id="configUpdateBtn"]':
			{
				'click': this.configUpdate
			},
			'capacityplanning button[id="addBackButton"]':
			{
				'click': this.goToMainView
			},

			'associates combo[id="policyInViewAssociate"]':
			{
				'select': this.policyInViewAssociateChange
			},
			'associates button[id="backbutton"]':
			{
				'click': this.goToView
			},

			'configSystemReports button[id="configSysReportBtn"]':
			{
				'click': this.configSysReportUpdate
			},
		});
	},

	afterMainRender: function()
	{
		Ext.getCmp('addBackButton').hide();

		var aTab = Ext.getCmp('capPlanTabs').getActiveTab();
		var me = this;
		var isAssociate = '';

		var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp";

		var allPercentileDetails = new Array();
		var mainGridObj = Ext.getCmp('mainGrid');
		mainGridObj.show();

		Ext.Ajax.request(
		{
			url : url,
			scope: this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var len = jsonData.policyDetailsArrayJson.length;
				var lenForAssoc = jsonData.associatesArrayJson.length;

				var aStore = new Ext.data.Store({
					fields: ['PercentilePolicy','MinValue','MaxValue','Associates','modifyValue','deleteValue'],
					data: [],
				});

				var k = 0;
				for (var i=0; i<len; i++)
				{
					var isAssociate = 'No';

					var percentile = jsonData.policyDetailsArrayJson[i].aListPercentiles;
					var minValue = jsonData.policyDetailsArrayJson[i].aListMinValues;
					var maxValue = jsonData.policyDetailsArrayJson[i].aListMaxValues;

					allPercentileDetails[k] = percentile;
					allPercentileDetails[k+1] = minValue;
					allPercentileDetails[k+2] = maxValue;
					allPercentileDetails[k+3] = isAssociate;

					for (var j=0; j<lenForAssoc; j++)
					{
						var associates = jsonData.associatesArrayJson[j].strValue;

						if (percentile == associates)
						{
							isAssociate = 'Yes';
							allPercentileDetails[k+3] = isAssociate;
						}
					}
					k = k+4;
				}

				for (var i=0; i<allPercentileDetails.length; i=i+4)
				{
					var percentile = allPercentileDetails[i];
					var minValue = allPercentileDetails[i+1];
					var maxValue = allPercentileDetails[i+2];
					var associates = allPercentileDetails[i+3];
					var linkUrl = '';

					if (associates == 'Yes')
					{
						var onclickFunction = "\"javascript:showAssociates('"+percentile+"');\"";

						linkUrl = percentile;
						isAssociate = 'hasAssociate';
					}
					else
					{
						linkUrl = '-';
						isAssociate = 'noAssociate';
					}

					aStore.add({'PercentilePolicy': percentile, 'MinValue': minValue, 'MaxValue' : maxValue, 'Associates' : linkUrl, 'modifyValue': '-', 'deleteValue' : isAssociate});
				}
				mainGridObj.bindStore(aStore);
			}
		});

		var urlForConfigTests = "/final/admin/EgReportCustomSetting/data/EgReportSettingJSON.jsp";

		Ext.Ajax.request(
		{
			url : urlForConfigTests,
			scope: this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				Ext.getCmp("componentType").getStore().loadRawData(jsonData.compTypeArrayJson);
			}
		});

		Ext.getCmp('cpctEnabledTest').setValue('All');
		Ext.getCmp('testName').setValue('Choose a test');
		Ext.getCmp('capacityTestStatus').setValue('Not Applicable');

		Ext.getCmp('componentType').setValue('Choose a component type');
		Ext.getCmp('cpctEnabledTest').setValue('All');
		Ext.getCmp('mainConfigGrid').hide();
		Ext.getCmp('configUpdateBtn').hide();

		var url = "/final/admin/EgReportCustomSetting/data/EgReportSysSettingJSON.jsp";
		var configSys = Ext.getCmp('configSysTitle');

		Ext.Ajax.request(
			{
				url : url,
				scope: this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					for (var i=1; i<=5; i++)
					{
						var title = jsonData.titleArrayJson[i-1];

						var hiddenTitleField = new Ext.form.field.Hidden({
							xtype: 'hiddenfield',
							id: 'Measure'+i+'_Title',
							name: 'Measure'+i+'_Title',
							value: title,
						});
						configSys.add(hiddenTitleField);

						Ext.getCmp('check'+i).setValue(jsonData.tmpCheckArrayJson[i-1]);

						Ext.getCmp('Measure'+i+'_Major').setValue(jsonData.tmpLesserArrayJson[i-1]);

						Ext.getCmp('Measure'+i+'_Critical').setValue(jsonData.tmpGreaterArrayJson[i-1]);

					}
				}
			}
		);
	},

	addNewPolicy: function()
	{
		Ext.widget('addModifyPolicy').show();
		Ext.getCmp('newPolicyWindow').show();
		Ext.getCmp('addModifyPercentile').show();

		Ext.getCmp('percentilePoliciesForModify').hide();
		Ext.Ajax.request({
				url: 'EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp?index=add',
				method: 'POST'
		});
	},

	update: function(btn)
	{
		var policyMinimumValue = Ext.getCmp('addModifyMinimumValue').getValue();
		var policyMaximumValue = Ext.getCmp('addModifyMaximumValue').getValue();
		var buttonText = Ext.getCmp('UpdateBtn').getText();

		var allPercentileDetails = new Array();
		var me = this;
		var isAssociate = '';
		var previousPercentile = '';
		var previousPercentileArray = '';

		var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp";

		var allPercentileDetails = new Array();
		var mainGridObj = Ext.getCmp('mainGrid');
		mainGridObj.show();

		Ext.Ajax.request(
		{
			url : url,
			scope: this,
			method : 'POST',
			async : false,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				previousPercentileArray = jsonData.policyDetailsArrayJson;
			}
		});

		if (buttonText == addText)
		{
			var isMinANumber = checkNumber(policyMinimumValue);
			var isMaxANumber = checkNumber(policyMaximumValue);

			var perNameValue = Ext.getCmp('addPolicyName').getValue();

			for (var i=0; i<previousPercentileArray.length; i++)
			{
				previousPercentile = previousPercentileArray[i].aListPercentiles;
				previousPercentile = previousPercentile.toLowerCase();

				var perNameValueLower = perNameValue.toLowerCase();

				var alertForPolicyAlreadyExists = alertForPolicyAlreadyExistsOne + ' ' + '\'' + perNameValue + '\'' + ' ' + alertForPolicyAlreadyExistsTwo + alertForPolicyAlreadyExistsThree;

				if (perNameValueLower == previousPercentile)
				{
					Ext.Msg.show({
						title: policyConfigure,
						msg: alertForPolicyAlreadyExists,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return;
				}
			}

			if (perNameValue == "" || perNameValue == "null")
			{
				Ext.Msg.show({
					title: policyConfigure,
					msg: alertForPolicyName,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}
			else if (perNameValue.indexOf(" ") > -1)
			{
				Ext.Msg.show({
					title: policyConfigure,
					msg: alertForSpaceInPolicyName,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}
			else if (!checkspecialnomess(perNameValue,"`~!@#$%^&*()+=[]{}|\\:;\"\'<>,?\/"))
			{
				Ext.Msg.show({
					title: policyConfigure,
					msg: alertForSpecialCharacterInName,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			if (isMinANumber == 'false' || isMinANumber == false)
			{
				Ext.Msg.show({
					title: policyConfigure,
					msg: alertForNotNumberInMin,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			if (isMaxANumber == 'false' || isMaxANumber == false)
			{
				Ext.Msg.show({
					title: policyConfigure,
					msg: alertForNotNumberInMax,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			if (Ext.isEmpty(policyMinimumValue) || Number(policyMinimumValue) == 0)
			{
				Ext.Msg.show({
					title: policyConfigure,
					msg: alertForMinimumValue,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			if (Ext.isEmpty(policyMaximumValue) || Number(policyMaximumValue) == 0)
			{
				Ext.Msg.show({
					title: policyConfigure,
					msg: alertForMaximumValue,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			if (Ext.isEmpty(policyMinimumValue) || Number(policyMinimumValue) > 100)
			{
				Ext.Msg.show({
					title: policyConfigure,
					msg: alertForNotNumberInMin,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			if (Ext.isEmpty(policyMaximumValue) || Number(policyMaximumValue) > 100)
			{
				Ext.Msg.show({
					title: policyConfigure,
					msg: alertForNotNumberInMax,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			if (Number(policyMaximumValue) < Number(policyMinimumValue))
			{
				Ext.Msg.show({
					title: policyConfigure,
					msg: alertForGreater,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
			else
			{
				var percentilePoliciesOperation = 'add';
				var percentilePolicyName = Ext.getCmp('addPolicyName').getValue();

				var updateURL = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsp.jsp?perDef="+percentilePoliciesOperation+"&perName="+encodeURIComponent(percentilePolicyName)+"&minPer="+policyMinimumValue+"&maxPer="+policyMaximumValue+"&$_minPer="+policyMinimumValue+"&$_maxPer="+policyMaximumValue;

				Ext.Ajax.request(
					{
						url : updateURL,
						scope: this,
						method : 'POST',
						success: function(response){

							Ext.Msg.show({
								title: policyConfigure,
								msg: policySuccess,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
							Ext.getCmp('newPolicyWindow').destroy();

							var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp?index=main";

							Ext.Ajax.request(
							{
								url : url,
								scope: this,
								method : 'POST',
								success: function(response){
									var jsonText = response.responseText;
									var jsonData = Ext.decode(jsonText);
									var len = jsonData.policyDetailsArrayJson.length;
									var lenForAssoc = jsonData.associatesArrayJson.length;

									var aStore = new Ext.data.Store({
										fields: ['PercentilePolicy','MinValue','MaxValue','Associates','modifyValue','deleteValue'],
										data: [],
									});

									var k = 0;
									for (var i=0; i<len; i++)
									{
										var isAssociate = 'No';

										var percentile = jsonData.policyDetailsArrayJson[i].aListPercentiles;
										var minValue = jsonData.policyDetailsArrayJson[i].aListMinValues;
										var maxValue = jsonData.policyDetailsArrayJson[i].aListMaxValues;

										allPercentileDetails[k] = percentile;
										allPercentileDetails[k+1] = minValue;
										allPercentileDetails[k+2] = maxValue;
										allPercentileDetails[k+3] = isAssociate;

										for (var j=0; j<lenForAssoc; j++)
										{
											var associates = jsonData.associatesArrayJson[j].strValue;

											if (percentile == associates)
											{
												isAssociate = 'Yes';
												allPercentileDetails[k+3] = isAssociate;
											}
										}
										k = k+4;
									}

									for (var i=0; i<allPercentileDetails.length; i=i+4)
									{
										var percentile = allPercentileDetails[i];
										var minValue = allPercentileDetails[i+1];
										var maxValue = allPercentileDetails[i+2];
										var associates = allPercentileDetails[i+3];
										var linkUrl = '';

										if (associates == 'Yes')
										{
											var onclickFunction = "\"javascript:showAssociates('"+percentile+"');\"";

											linkUrl = percentile;
											isAssociate = 'hasAssociate';
										}
										else
										{
											linkUrl = '-';
											isAssociate = 'noAssociate';
										}

										aStore.add({'PercentilePolicy': percentile, 'MinValue': minValue, 'MaxValue' : maxValue, 'Associates' : linkUrl, 'modifyValue' : '-', 'deleteValue' : isAssociate});
									}
									Ext.getCmp('mainGrid').bindStore(aStore);
								}
							});
						}
					}
				);
			}
		}
		else
		{
			me.modifyUpdate();
		}
	},

	modifyUpdate: function()
	{
		var allPercentileDetails = new Array();
		var isAssociate = '';
		var percentilePoliciesOperation = 'modify';
		var perChoosen = Ext.getCmp('percentilePoliciesForModify').getValue();
		var minPer = Ext.getCmp('addModifyMinimumValue').getValue();
		var maxPer = Ext.getCmp('addModifyMaximumValue').getValue();

		var prevMinPer = '';
		var prevMaxPer = '';

		var policyMinimumValue = Ext.getCmp('addModifyMinimumValue').getValue();
		var policyMaximumValue = Ext.getCmp('addModifyMaximumValue').getValue();

		var isMinANumber = checkNumber(policyMinimumValue);
		var isMaxANumber = checkNumber(policyMaximumValue);

		if (isMinANumber == 'false' || isMinANumber == false)
		{
			Ext.Msg.show({
				title: policyConfigure,
				msg: alertForNotNumberInMin,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		if (isMaxANumber == 'false' || isMaxANumber == false)
		{
			Ext.Msg.show({
				title: policyConfigure,
				msg: alertForNotNumberInMax,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		if (Ext.isEmpty(policyMinimumValue) || Number(policyMinimumValue) == 0)
		{
			Ext.Msg.show({
				title: policyConfigure,
				msg: alertForMinimumValue,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		if (Ext.isEmpty(policyMaximumValue) || Number(policyMaximumValue) == 0)
		{
			Ext.Msg.show({
				title: policyConfigure,
				msg: alertForMaximumValue,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		if (Ext.isEmpty(policyMinimumValue) || Number(policyMinimumValue) > 100)
		{
			Ext.Msg.show({
				title: policyConfigure,
				msg: alertForNotNumberInMin,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		if (Ext.isEmpty(policyMaximumValue) || Number(policyMaximumValue) > 100)
		{
			Ext.Msg.show({
				title: policyConfigure,
				msg: alertForNotNumberInMax,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		if (Number(policyMaximumValue) < Number(policyMinimumValue))
		{
			Ext.Msg.show({
				title: policyConfigure,
				msg: alertForGreater,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp";

		var allPercentileDetails = new Array();

		Ext.Ajax.request(
		{
			url : url,
			scope: this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var len = jsonData.policyDetailsArrayJson.length;

				var percentile = '';
				for (var i=0; i<len; i++)
				{
					var percentile = jsonData.policyDetailsArrayJson[i].aListPercentiles;
					var minValue = jsonData.policyDetailsArrayJson[i].aListMinValues;
					var maxValue = jsonData.policyDetailsArrayJson[i].aListMaxValues;

					if (perChoosen == percentile)
					{
						prevMinPer = jsonData.policyDetailsArrayJson[i].aListMinValues;
						prevMaxPer = jsonData.policyDetailsArrayJson[i].aListMaxValues;
					}
				}

				var updateURL = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsp.jsp?perDef="+percentilePoliciesOperation+"&perChoosen="+encodeURIComponent(perChoosen)+"&minPer="+minPer+"&maxPer="+maxPer+"&$_minPer="+prevMinPer+"&$_maxPer="+prevMaxPer;

				Ext.Ajax.request(
					{
						url : updateURL,
						scope: this,
						method : 'POST',
						success: function(response){

							Ext.Msg.show({
								title: policyConfigure,
								msg: modifySuccess,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});

							Ext.getCmp('mainGrid').show();
							Ext.getCmp('newPolicyWindow').destroy();

							var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp?index=main";

							Ext.Ajax.request(
							{
								url : url,
								scope: this,
								method : 'POST',
								success: function(response){
									var jsonText = response.responseText;
									var jsonData = Ext.decode(jsonText);
									var len = jsonData.policyDetailsArrayJson.length;
									var lenForAssoc = jsonData.associatesArrayJson.length;

									var aStore = new Ext.data.Store({
										fields: ['PercentilePolicy','MinValue','MaxValue','Associates','modifyValue','deleteValue'],
										data: [],
									});

									var k = 0;
									for (var i=0; i<len; i++)
									{
										var isAssociate = 'No';

										var percentile = jsonData.policyDetailsArrayJson[i].aListPercentiles;
										var minValue = jsonData.policyDetailsArrayJson[i].aListMinValues;
										var maxValue = jsonData.policyDetailsArrayJson[i].aListMaxValues;

										allPercentileDetails[k] = percentile;
										allPercentileDetails[k+1] = minValue;
										allPercentileDetails[k+2] = maxValue;
										allPercentileDetails[k+3] = isAssociate;

										for (var j=0; j<lenForAssoc; j++)
										{
											var associates = jsonData.associatesArrayJson[j].strValue;

											if (percentile == associates)
											{
												isAssociate = 'Yes';
												allPercentileDetails[k+3] = isAssociate;
											}
										}
										k = k+4;
									}

									for (var i=0; i<allPercentileDetails.length; i=i+4)
									{
										var percentile = allPercentileDetails[i];
										var minValue = allPercentileDetails[i+1];
										var maxValue = allPercentileDetails[i+2];
										var associates = allPercentileDetails[i+3];
										var linkUrl = '';

										if (associates == 'Yes')
										{
											var onclickFunction = "\"javascript:showAssociates('"+percentile+"');\"";

											linkUrl = percentile;
											isAssociate = 'hasAssociate';
										}
										else
										{
											linkUrl = '-';
											isAssociate = 'noAssociate';
										}

										aStore.add({'PercentilePolicy': percentile, 'MinValue': minValue, 'MaxValue' : maxValue, 'Associates' : linkUrl, 'modifyValue' : '-', 'deleteValue' : isAssociate});
									}
									Ext.getCmp('mainGrid').bindStore(aStore);
								}
							});
						}
					}
				);
			}
		});
	},

	deletePolicyInView: function(gridView,row,col)
	{
		var viewStoreObj = Ext.getCmp('mainGrid');
		var isAssociate = '';

		var store = viewStoreObj.getStore();
		var record = store.getAt(row);

		var percentilePolicy = record.get('PercentilePolicy');
		var minValue = record.get('MinValue');
		var maxValue = record.get('MaxValue');
		var associates = record.get('Associates');
		var allPercentileDetails = new Array();

		Ext.MessageBox.confirm(capPlanTitle,alertForDeleteConfirmation+' ' +percentilePolicy+' '+'?', function(id) 
			{
				if (id == 'yes')
				{
					if (associates == '-')
					{
						var percentilePoliciesOperation = 'delete';

						var updateURL = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsp.jsp?perDef="+percentilePoliciesOperation+"&selectedPercentile="+encodeURIComponent(percentilePolicy);

						Ext.Ajax.request(
							{
								url : updateURL,
								scope: this,
								method : 'POST',
								success: function(response){

									Ext.Msg.show({
										title: policyConfigure,
										msg: deleteSuccess,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});

									var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp?index=main";

									Ext.Ajax.request(
									{
										url : url,
										scope: this,
										method : 'POST',
										success: function(response){
											var jsonText = response.responseText;
											var jsonData = Ext.decode(jsonText);
											var len = jsonData.policyDetailsArrayJson.length;
											var lenForAssoc = jsonData.associatesArrayJson.length;

											var aStore = new Ext.data.Store({
												fields: ['PercentilePolicy','MinValue','MaxValue','Associates','modifyValue','deleteValue'],
												data: [],
											});

											var k = 0;
											for (var i=0; i<len; i++)
											{
												var isAssociate = 'No';

												var percentile = jsonData.policyDetailsArrayJson[i].aListPercentiles;
												var minValue = jsonData.policyDetailsArrayJson[i].aListMinValues;
												var maxValue = jsonData.policyDetailsArrayJson[i].aListMaxValues;

												allPercentileDetails[k] = percentile;
												allPercentileDetails[k+1] = minValue;
												allPercentileDetails[k+2] = maxValue;
												allPercentileDetails[k+3] = isAssociate;

												for (var j=0; j<lenForAssoc; j++)
												{
													var associates = jsonData.associatesArrayJson[j].strValue;

													if (percentile == associates)
													{
														isAssociate = 'Yes';
														allPercentileDetails[k+3] = isAssociate;
													}
												}
												k = k+4;
											}

											for (var i=0; i<allPercentileDetails.length; i=i+4)
											{
												var percentile = allPercentileDetails[i];
												var minValue = allPercentileDetails[i+1];
												var maxValue = allPercentileDetails[i+2];
												var associates = allPercentileDetails[i+3];
												var linkUrl = '';

												if (associates == 'Yes')
												{
													var onclickFunction = "\"javascript:showAssociates('"+percentile+"');\"";

													linkUrl = percentile;
													isAssociate = 'hasAssociate';
												}
												else
												{
													linkUrl = '-';
													isAssociate = 'noAssociate';
												}

												aStore.add({'PercentilePolicy': percentile, 'MinValue': minValue, 'MaxValue' : maxValue, 'Associates' : linkUrl, 'modifyValue' : '-', 'deleteValue' : isAssociate});
											}
											Ext.getCmp('mainGrid').bindStore(aStore);
										}
									});
								}
							}
						);
					}
					else
					{
						Ext.Msg.show({
							title: policyConfigure,
							msg: policyAssociates,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
					}
				}
			}
		);
	},

	modifyPolicyInView: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var viewStoreObj = Ext.getCmp('mainGrid');

		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);

		var percentilePolicy = record.get('PercentilePolicy');
		var minValue = record.get('MinValue');
		var maxValue = record.get('MaxValue');
		var associates = record.get('Associates');

		Ext.widget('addModifyPolicy').show();
		Ext.getCmp('newPolicyWindow').show();
		Ext.getCmp('addModifyPercentile').show();

		Ext.getCmp('addPolicyName').hide();
		Ext.getCmp('UpdateBtn').setText('Update');
		Ext.getCmp('newPolicyWindow').setTitle(modifyPolicy);

		Ext.getCmp('percentilePoliciesForModify').show();

		var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp?index=add";

		Ext.Ajax.request(
		{
			url : url,
			scope: this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var len = jsonData.policyDetailsArrayJson.length;

				var aStore = new Ext.data.Store({
					fields: ['displayField','valueField'],
				});

				var k = 0;
				for (var i=0; i<len; i++)
				{
					var isAssociate = 'No';

					var percentile = jsonData.policyDetailsArrayJson[i].aListPercentiles;

					aStore.add({'displayField': percentile, 'valueField': percentile});

					Ext.getCmp('percentilePoliciesForModify').bindStore(aStore);
					Ext.getCmp('percentilePoliciesForModify').setValue(percentilePolicy);

				}
			}
		});

		Ext.getCmp('addModifyMinimumValue').setValue(minValue);
		Ext.getCmp('addModifyMaximumValue').setValue(maxValue);
	},

	modifyPolicyComboChange: function()
	{
		var policyName = Ext.getCmp('percentilePoliciesForModify').getDisplayValue();

		var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp?index=add";

		Ext.Ajax.request(
		{
			url : url,
			scope: this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var len = jsonData.policyDetailsArrayJson.length;
				var lenForAssoc = jsonData.associatesArrayJson.length;

				var aStore = new Ext.data.Store({
					fields: ['PercentilePolicy','MinValue','MaxValue','Associates'],
				});

				var k = 0;
				for (var i=0; i<len; i++)
				{
					var isAssociate = 'No';

					var percentile = jsonData.policyDetailsArrayJson[i].aListPercentiles;
					var minValue = jsonData.policyDetailsArrayJson[i].aListMinValues;
					var maxValue = jsonData.policyDetailsArrayJson[i].aListMaxValues;

					if (policyName == percentile)
					{
						Ext.getCmp('addModifyMinimumValue').setValue(minValue);
						Ext.getCmp('addModifyMaximumValue').setValue(maxValue);
					}
				}
			}
		});
	},

	compTypeChange: function()
	{
		var configUpdateBtnObj = Ext.getCmp('configUpdateBtn');

		Ext.suspendLayouts();
		Ext.getCmp('mainConfigGrid').hide();
		configUpdateBtnObj.hide();
		Ext.resumeLayouts(true);

		var componentType = Ext.getCmp('componentType').getValue();
		var cpctEnabledTest = Ext.getCmp('cpctEnabledTest').getValue();

		if (cpctEnabledTest == 'Capacity enabled')
		{
			cpctEnabledTest = 'true';
		}
		var testsObj = Ext.getCmp('testName');

		if (componentType == 'Choose a component type')
		{
			testsObj.setValue('Not Applicable');
			Ext.getCmp('capacityTestStatus').setValue('Not Applicable');
		}
		Ext.getCmp('capacityTestStatus').setValue('Not Applicable');

		var url = "/final/admin/EgReportCustomSetting/data/EgReportSettingJSON.jsp?componentType="+encodeURIComponent(componentType)+"&cpctEnabledTest="+cpctEnabledTest;

		Ext.Ajax.request(
			{
				url : url,
				scope: this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					testsObj.getStore().loadRawData(jsonData.testsArrayJson);
					var testsArray = jsonData.testsArrayJson;
					if (testsArray.length > 0)
					{
						testsObj.setValue(jsonData.testsArrayJson[0].displayField);
					}
				}
			}
		);
	},

	cpctEnabledTestChange: function()
	{
		var componentType = Ext.getCmp('componentType').getValue();
		var cpctEnabledTest = Ext.getCmp('cpctEnabledTest').getValue();
		var testName = Ext.getCmp('testName').getValue();
		var configUpdateBtnObj = Ext.getCmp('configUpdateBtn');
		var mainConfigGrid = Ext.getCmp('mainConfigGrid');
		mainConfigGrid.view.refresh();
		configUpdateBtnObj.hide();

		if (cpctEnabledTest == 'Capacity enabled')
		{
			cpctEnabledTest = 'true';
		}
		var testsObj = Ext.getCmp('testName');

		var url = "/final/admin/EgReportCustomSetting/data/EgReportSettingJSON.jsp?componentType="+encodeURIComponent(componentType)+"&cpctEnabledTest="+cpctEnabledTest;

		Ext.Ajax.request(
			{
				url : url,
				scope: this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					if (!Ext.isEmpty(testsObj) && !Ext.isEmpty(jsonData.testsArrayJson) && jsonData.testsArrayJson.length > 0)
					{
						testsObj.getStore().loadRawData(jsonData.testsArrayJson);
						testsObj.setValue(jsonData.testsArrayJson[0].displayField);
					}
					else
					{
						testsObj.getStore().removeAll();
						testsObj.setValue('Not Applicable');
					}

					Ext.suspendLayouts();
					Ext.getCmp('mainConfigGrid').hide();
					configUpdateBtnObj.hide();
					Ext.resumeLayouts(true);
				}
			}
		);
	},

	capacityTestStatusChange: function()
	{
		var capacityTestStatus = Ext.getCmp('capacityTestStatus').getValue();

		var componentType = Ext.getCmp('componentType').getValue();
		var testName = Ext.getCmp('testName').getValue();
		var cpctEnabledTest = Ext.getCmp('cpctEnabledTest').getValue();
		var mainConfigGrid = Ext.getCmp('mainConfigGrid');

		var url = "/final/admin/EgReportCustomSetting/data/EgReportSettingJSON.jsp?componentType="+encodeURIComponent(componentType)+"&testName="+testName+"&cpctEnabledTest="+cpctEnabledTest;

		Ext.Ajax.request(
			{
				url : url,
				scope: this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					for (var i=0; i<jsonData.measureNameArrayJson.length; i++)
					{
						var measure = jsonData.measureNameArrayJson[i].displayField;
						var measureActualName = jsonData.measureNameArrayJson[i].valueField;

						var editField = new Ext.form.field.ComboBox({
									cls: 'dropdown',
									editable: false,
									width : 150,
									displayField : 'displayField',
									valueField : 'valueField',
									queryMode : 'local',
									id: 'policyGridCombo',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [ ]
									}),
								});

						var reportViewField = new Ext.form.field.ComboBox({
							cls: 'dropdown',
							editable: false,
							width : 150,
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							id: 'reportViewGridCombo',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : [{'displayField':'Maximum','valueField':'Maximum'},{'displayField':'Minimum','valueField':'Minimum'}],
							}),
						});

						if (capacityTestStatus == 'yes')
						{
							Ext.getCmp('policyColumn').setEditor(editField);
							Ext.getCmp('viewColumn').setEditor(reportViewField);
							Ext.getCmp('policyGridCombo').getStore().loadRawData(jsonData.percentilePolicyArrayJson);

							for (var i=0; i<jsonData.measureNameArrayJson.length; i++)
							{
								var me = this;
								var measure = jsonData.measureNameArrayJson[i].displayField;
								var measureActualName = jsonData.measureNameArrayJson[i].valueField;

								var aPolicyComboObj = Ext.getCmp('policyGridCombo');
								aPolicyComboObj.on('select', this.selectClick, me, {
									//single: true,
									//delay: 100
								});

								var aReportViewObj = Ext.getCmp('reportViewGridCombo');
								aReportViewObj.on('select', this.viewClick, me, {
									//single: true,
									//delay: 100
								});
							}
						}

						if (capacityTestStatus == 'no')
						{
							var record = '';
							Ext.getCmp('policyColumn').setEditor(record);
							Ext.getCmp('viewColumn').setEditor(record);
						}
					}
				}
			}
		);
	},

	testNameChange: function()
	{
		var componentType = Ext.getCmp('componentType').getValue();
		var testName = Ext.getCmp('testName').getValue();
		var cpctEnabledTest = Ext.getCmp('cpctEnabledTest').getValue();
		var measuresArray = new Array();
		var policyArray = new Array();
		var reportViewArray = new Array();
		var hiddenPolicyArray = new Array();
		var hiddenMeasureArray = new Array();
		var mainConfigGrid = Ext.getCmp('mainConfigGrid');
		mainConfigGrid.show();
		var gridComboId = Ext.getCmp('policyGridCombo');
		var configUpdateBtnObj = Ext.getCmp('configUpdateBtn');
		var isEnabled = '';

		var url = "/final/admin/EgReportCustomSetting/data/EgReportSettingJSON.jsp?componentType="+encodeURIComponent(componentType)+"&testName="+testName+"&cpctEnabledTest="+cpctEnabledTest;

		Ext.Ajax.request(
			{
				url : url,
				scope: this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					allMeasuresArray = jsonData.measureNameArrayJson;
					allPolicyArray = jsonData.percentilePolicyArrayJson;
					allReportViewArray = jsonData.selectedReportViewArray;

					if (Ext.isEmpty(allMeasuresArray) || allMeasuresArray.length == 0)
					{
						configUpdateBtnObj.setDisabled(true);
					}
					else
					{
						configUpdateBtnObj.setDisabled(false);
					}

					var editField = new Ext.form.field.ComboBox({
									cls: 'dropdown',
									editable: false,
									width : 150,
									displayField : 'displayField',
									valueField : 'valueField',
									queryMode : 'local',
									id: 'policyGridCombo',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [ ]
									}),
								});

					var reportViewField = new Ext.form.field.ComboBox({
							cls: 'dropdown',
							editable: false,
							width : 150,
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							id: 'reportViewGridCombo',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : [{'displayField':'Maximum','valueField':'Maximum'},{'displayField':'Minimum','valueField':'Minimum'}],
							}),
						});

					if (jsonData.capacityEnabledJson.strEnabled == 'checked')
					{
						Ext.getCmp('capacityTestStatus').setValue('yes');
						isEnabled = 'enabled';
						Ext.getCmp('policyColumn').setEditor(editField);
						Ext.getCmp('policyGridCombo').getStore().loadRawData(jsonData.percentilePolicyArrayJson);
						Ext.getCmp('viewColumn').setEditor(reportViewField);
						mainConfigGrid.getStore().loadRawData(jsonData.dataForGridArray);
					}

					if (jsonData.capacityEnabledJson.strDisabled == 'checked')
					{
						var record = '';
						Ext.getCmp('capacityTestStatus').setValue('no');
						isEnabled = 'disabled';
						Ext.getCmp('policyGridCombo').getStore().loadRawData(jsonData.percentilePolicyArrayJson);
						mainConfigGrid.getStore().loadRawData(jsonData.dataForGridArray);
						Ext.getCmp('policyColumn').setEditor(record);
						Ext.getCmp('viewColumn').setEditor(record);
					}

					Ext.getCmp('configUpdateBtn').show();

					for (var i=0; i<jsonData.measureNameArrayJson.length; i++)
					{
						var me = this;
						var measure = jsonData.measureNameArrayJson[i].displayField;
						var measureActualName = jsonData.measureNameArrayJson[i].valueField;

						var aPolicyComboObj = Ext.getCmp('policyGridCombo');
						aPolicyComboObj.on('select', this.selectClick, me, {
							//single: true,
							//delay: 100
						});

						var aReportViewObj = Ext.getCmp('reportViewGridCombo');
						aReportViewObj.on('select', this.viewClick, me, {
							//single: true,
							//delay: 100
						});
					}
				}
			}
		);
	},

	viewClick: function(a,b,c,d)
	{
		var viewClicked = a.id;
		var componentType = Ext.getCmp('componentType').getValue();
		var testName = Ext.getCmp('testName').getValue();
		var cpctEnabledTest = Ext.getCmp('cpctEnabledTest').getValue();
		var viewToApply = Ext.getCmp(viewClicked).getValue();

		var viewIdObj = Ext.getCmp('reportViewGridCombo');
		viewIdObj.setValue(viewToApply);

		var aStore = new Ext.data.Store({
			fields: ['displayField','valueField'],
		});

		var url = "/final/admin/EgReportCustomSetting/data/EgReportSettingJSON.jsp?componentType="+encodeURIComponent(componentType)+"&testName="+testName+"&cpctEnabledTest="+cpctEnabledTest;

		Ext.Ajax.request(
			{
				url : url,
				scope: this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var answer = '';

					var numberOfMeasures = jsonData.measureNameArrayJson.length;
					if (numberOfMeasures > 1)
					{
						Ext.MessageBox.confirm(configureTestTitle,alertForAllViewApply + ' ' + testName + '?', function(id) {
							if (id == 'yes')
							{
								var mainConfigGrid = Ext.getCmp('mainConfigGrid');
								var models = mainConfigGrid.getStore().getRange();
								for (var i=0; i<models.length; i++)
								{
									models[i].set('reportView',viewToApply);
								}
								mainConfigGrid.view.refresh();
							}
						},this);
					}
				}
			}
		);
	},

	// Code added to apply a policy name that is once selected to all other measures
	selectClick: function(a,b,c,d)
	{
		var policyClicked = a.id;
		var componentType = Ext.getCmp('componentType').getValue();
		var testName = Ext.getCmp('testName').getValue();
		var cpctEnabledTest = Ext.getCmp('cpctEnabledTest').getValue();
		var policyToApply = Ext.getCmp(policyClicked).getValue();

		var policyIdObj = Ext.getCmp('policyGridCombo');
		policyIdObj.setValue(policyToApply);

		var aStore = new Ext.data.Store({
			fields: ['displayField','valueField'],
		});

		var url = "/final/admin/EgReportCustomSetting/data/EgReportSettingJSON.jsp?componentType="+encodeURIComponent(componentType)+"&testName="+testName+"&cpctEnabledTest="+cpctEnabledTest;

		Ext.Ajax.request(
			{
				url : url,
				scope: this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var answer = '';

					var numberOfMeasures = jsonData.measureNameArrayJson.length;
					if (numberOfMeasures > 1)
					{
						Ext.MessageBox.confirm(configureTestTitle,alertForAllPolicyApply + ' ' + testName + '?', function(id) {
							if (id == 'yes')
							{
								var mainConfigGrid = Ext.getCmp('mainConfigGrid');
								var models = mainConfigGrid.getStore().getRange();
								for (var i=0; i<models.length; i++)
								{
									models[i].set('Policy',policyToApply);
								}
								mainConfigGrid.view.refresh();
							}
						},this);
					}
				}
			}
		);
	},

	configUpdate: function(obj)
	{
		var hiddenContainerObj = Ext.getCmp('hiddenContainer');
		var componentType = Ext.getCmp('componentType').getValue();
		var testName = Ext.getCmp('testName').getValue();
		var cpctEnabledTest = Ext.getCmp('cpctEnabledTest').getValue();
		var capacityTestStatus = '';

		var policy = Ext.getCmp('policyGridCombo').getValue();
		var measuresArray = new Array();
		var policyArray = new Array();
		var reportViewArray = new Array();
		var hiddenPolicyArray = new Array();
		var hiddenMeasureArray = new Array();

		var lenForStores = allMeasuresArray.length;
		var mainConfigGridId = Ext.getCmp('mainConfigGrid');
		var store = mainConfigGridId.getStore();
		var reportView = Ext.getCmp('reportViewGridCombo').getValue();

		var url = "/final/admin/EgReportCustomSetting/data/EgReportSettingJSON.jsp?componentType="+encodeURIComponent(componentType)+"&testName="+testName+"&cpctEnabledTest="+cpctEnabledTest;

		Ext.Ajax.request(
			{
				url : url,
				scope: this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var existingSelectedPolicy = jsonData.dataForGridArray[0].Policy;
					var existingSelectedView = jsonData.dataForGridArray[0].reportView;

					for (var i=0; i<lenForStores; i++)
					{
						var record = store.getAt(i);
						var aMeasure = record.get('Measures');
						var aPolicy = record.get('Policy');
						if (lenForStores == '1')
						{
							aPolicy = policy;
						}
						var aReportView = record.get('reportView');

						if (aReportView == 'Minimum')
						{
							aReportView = 'MP';
						}
						else if (aReportView == 'Maximum')
						{
							aReportView = 'XP';
						}

						var measure = allMeasuresArray[i].displayField;
						var measureActualName = allMeasuresArray[i].valueField;

						var hiddenMeasureField = {
							xtype: 'hiddenfield',
							id: 'measures'+i,
							name: 'measures',
							value: measure,
						};

						var hiddenPolicyField = {
							xtype: 'hiddenfield',
							id: measureActualName+'_percentileType',
							name: measureActualName+'_percentileType',
							value: aPolicy,
						};

						var hiddenReportViewField = {
							xtype: 'hiddenfield',
							id: measureActualName+'_reportView',
							name: measureActualName+'_reportView',
							value: aReportView,
						};

						if (lenForStores == '1')
						{
							hiddenPolicyFieldForAudit = {
								xtype: 'hiddenfield',
								id: "$_"+measureActualName+"_percentileType",
								name: "$_"+measureActualName+"_percentileType",
								value: record.get('Policy'),
							};
						}

						var hiddenPolicyFieldForAudit = {
							xtype: 'hiddenfield',
							id: "$_"+measureActualName+"_percentileType",
							name: "$_"+measureActualName+"_percentileType",
							value: jsonData.dataForGridArray[i].Policy,
						};

						var hiddenReportViewFieldForAudit = {
							xtype: 'hiddenfield',
							id: "$_"+measureActualName+"_reportView",
							name: "$_"+measureActualName+"_reportView",
							value: jsonData.dataForGridArray[i].reportView,
						};

						hiddenPolicyArray.push(hiddenPolicyFieldForAudit);
						hiddenMeasureArray.push(hiddenReportViewFieldForAudit);

						measuresArray.push(hiddenMeasureField);
						policyArray.push(hiddenPolicyField);
						reportViewArray.push(hiddenReportViewField);
					}

					hiddenContainerObj.add(measuresArray);
					hiddenContainerObj.add(policyArray);
					hiddenContainerObj.add(reportViewArray);
					hiddenContainerObj.add(hiddenPolicyArray);
					hiddenContainerObj.add(hiddenMeasureArray);

					var configForm = this.getConfigTests().getForm();
					if (configForm.isValid())
					{
						configForm.submit({
							url: '/final/admin/EgReportCustomSetting/data/EgReportSettingJSONp.jsp',
							method: 'POST',
							success: function(form, action){
								Ext.Msg.show({
									title: configureTestTitle,
									msg: configTestsSuccess,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								Ext.Msg.show({
									title: configureTestTitle,
									msg: configTestsFailure,
									width: 300,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
							}
						});
					}
				}
			}
		);
	},

	configSysReportUpdate: function(btn)
	{
		for (var i=1; i<=5; i++)
		{
			var checkValue = Ext.getCmp('check'+i).getValue();

			var majorValue = Ext.getCmp('Measure'+i+'_Major').getValue();

			var criticValue = Ext.getCmp('Measure'+i+'_Critical').getValue();

			if (Ext.isEmpty(majorValue))
			{
				Ext.Msg.show({
					title: configSys,
					msg: alertForEmpty,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}

			if (Ext.isEmpty(criticValue))
			{
				Ext.Msg.show({
					title: configSys,
					msg: alertForSpace,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}

			var isSpaceInMajor = checkspace(majorValue);
			var isSpaceInCritical = checkspace(criticValue);

			if (isSpaceInMajor == 'false' || isSpaceInMajor == false)
			{
				Ext.Msg.show({
					title: configSys,
					msg: alertForSpace,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}

			if (isSpaceInCritical == 'false' || isSpaceInCritical == false)
			{
				Ext.Msg.show({
					title: configSys,
					msg: alertForSpace,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}

			if (checkValue == '<')
			{
				if ( majorValue < criticValue)
				{
					Ext.Msg.show({
						title: configSys,
						msg: alertForMinConditionCheck,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}else if (checkValue == '>')
			{
				if (majorValue > criticValue)
				{
					Ext.Msg.show({
						title: configSys,
						msg: alertForMaxConditionCheck,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}
		}

		var configSystemReports = this.getConfigSystemReports().getForm();
		if (configSystemReports.isValid())
		{
			configSystemReports.submit({
				url: '/final/admin/EgReportCustomSetting/data/EgReportSysSettingJSONp.jsp',
				method: 'POST',
				success: function(form, action){
					Ext.Msg.show({
						title: configSys,
						msg: sysConfigSuccess,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					Ext.Msg.show({
						title: configSys,
						msg: sysConfigFailure,
						width: 300,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
				}
			});
		}
	},

	policyInViewAssociateChange: function()
	{
		var policyNameFromCombo = Ext.getCmp('policyInViewAssociate').getDisplayValue();
		var operation = 'view';

		var urlForView = "/final/admin/EgReportCustomSetting/data/EgShowPercentileAssociatesJSON.jsp?strPercentile="+encodeURIComponent(policyNameFromCombo)+"&perDef="+operation;

		var bStore = new Ext.data.Store({
					fields: ['Test','Measures'],
				});

		Ext.Ajax.request(
		{
			url : urlForView,
			scope: this,
			method : 'POST',
			success: function(response){
				var jsonTextForView = response.responseText;
				var jsonDataForView = Ext.decode(jsonTextForView);
				var policyName = jsonDataForView.percentilePolicy;
				var testLength = jsonDataForView.testArrayJson.length;

				if (testLength == 0)
				{
					Ext.getCmp('mainGridInAssociates').bindStore(bStore);
				}
				else
				{
					for (var i=0; i<testLength; i++)
					{
						var testName = jsonDataForView.testArrayJson[i];
						var mappedTestName = jsonDataForView.mappedTestArrayJson[i];

						var urlForMeasure = "/final/admin/EgReportCustomSetting/data/EgShowPercentileAssociatesJSON.jsp?strPercentile="+encodeURIComponent(policyNameFromCombo)+"&testName="+testName;

						Ext.Ajax.request(
						{
							url : urlForMeasure,
							scope: this,
							method : 'POST',
							success: function(response){
								var jsonTextForMeasure = response.responseText;
								var jsonDataForMeasure = Ext.decode(jsonTextForMeasure);
								var measuresForTestLength = jsonDataForMeasure.localMeasuresForTestArrayJson.length;
								var measuresAndTestArray = jsonDataForMeasure.measuresAndTestArrayJson;
								var measuresForTestArray = jsonDataForMeasure.measuresForTestArrayJson;

								if (measuresAndTestArray.length == 0)
								{
									Ext.getCmp('mainGridInAssociates').bindStore(bStore);
								}
								else
								{
									for (var j=0; j<measuresAndTestArray.length; j++)
									{
										var testslocalName = measuresAndTestArray[j].Test;
										var measureslocalName = measuresAndTestArray[j].Measures;

										var s_obj1 = '';

										for (var j=0; j<measuresForTestArray.length; j++)
										{
											var testsInAllArray = measuresForTestArray[j].Test;
											var measureslocalName = measuresForTestArray[j].Measures;

											if (testslocalName == testsInAllArray)
											{
												s_obj = new String(measureslocalName);
												s_obj1 = s_obj1 + s_obj.valueOf() + ',';
											}
										}

										bStore.add({ 'Test': testslocalName, 'Measures': s_obj1 });
										Ext.getCmp('mainGridInAssociates').bindStore(bStore);
									}
								}
							}
						}
						);
					}
				}
			}
		}
		);
	},

	deleteCheckBox: function()
	{
		var selectedRecords = Ext.getCmp('mainGrid').getSelectionModel().getSelection();
		var len = selectedRecords.length;
		var j = 0;
		var answer = '';
		var allPercentileDetails = new Array();
		var isAssociate = '';

		if (len == 0)
		{
			Ext.Msg.show({
				title: policyConfigure,
				msg: policyNotSelected,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}
		else
		{
			Ext.MessageBox.confirm(policyConfigure,deleteConfirm, function(id) {
							if (id == 'yes')
							{
								for (var i=0; i<len; i++)
								{
									var percentilePolicy = selectedRecords[i].get('PercentilePolicy');
									var minValue = selectedRecords[i].get('MinValue');
									var maxValue = selectedRecords[i].get('MaxValue');
									var associates = selectedRecords[i].get('Associates');

									var percentilePoliciesOperation = 'delete';

									if (associates != '-')
									{
										Ext.getCmp('mainGrid').getSelectionModel().deselect(selectedRecords[i]);
										Ext.Msg.show({
											title: policyConfigure,
											msg: 'Percentile policy '+ ' ' + percentilePolicy + ' '+ 'has associates',
											width: 400,
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
									}
									else if (percentilePolicy == 'Default')
									{
										Ext.getCmp('mainGrid').getSelectionModel().deselect(i);
										Ext.Msg.show({
											title: policyConfigure,
											msg: defaultPolicy,
											width: 300,
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
									}
									else
									{
										var updateURL = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsp.jsp?perDef="+percentilePoliciesOperation+"&selectedPercentile="+encodeURIComponent(percentilePolicy);

										Ext.Ajax.request(
										{
											url : updateURL,
											scope: this,
											method : 'POST',
											success: function(response){

												Ext.getCmp('mainGrid').show();

												if (j == 0)
												{
													Ext.Msg.show({
														title: policyConfigure,
														msg: deleteSuccess,
														width: 300,
														buttons: Ext.Msg.OK,
														icon: 'iconInformation'
													});
												}

												var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp?index=main";

												Ext.Ajax.request(
												{
													url : url,
													scope: this,
													method : 'POST',
													success: function(response){
														var jsonText = response.responseText;
														var jsonData = Ext.decode(jsonText);
														var len = jsonData.policyDetailsArrayJson.length;
														var lenForAssoc = jsonData.associatesArrayJson.length;

														var aStore = new Ext.data.Store({
															fields: ['PercentilePolicy','MinValue','MaxValue','Associates','modifyValue','deleteValue'],
															data: [],
														});

														var k = 0;
														for (var i=0; i<len; i++)
														{
															var isAssociate = 'No';

															var percentile = jsonData.policyDetailsArrayJson[i].aListPercentiles;
															var minValue = jsonData.policyDetailsArrayJson[i].aListMinValues;
															var maxValue = jsonData.policyDetailsArrayJson[i].aListMaxValues;

															allPercentileDetails[k] = percentile;
															allPercentileDetails[k+1] = minValue;
															allPercentileDetails[k+2] = maxValue;
															allPercentileDetails[k+3] = isAssociate;

															for (var j=0; j<lenForAssoc; j++)
															{
																var associates = jsonData.associatesArrayJson[j].strValue;

																if (percentile == associates)
																{
																	isAssociate = 'Yes';
																	allPercentileDetails[k+3] = isAssociate;
																}
															}
															k = k+4;
														}

														for (var i=0; i<allPercentileDetails.length; i=i+4)
														{
															var percentile = allPercentileDetails[i];
															var minValue = allPercentileDetails[i+1];
															var maxValue = allPercentileDetails[i+2];
															var associates = allPercentileDetails[i+3];
															var linkUrl = '';

															if (associates == 'Yes')
															{
																var onclickFunction = "\"javascript:showAssociates('"+percentile+"');\"";
																linkUrl = percentile;
																isAssociate = 'hasAssociate';
															}
															else
															{
																linkUrl = '-';
																isAssociate = 'noAssociate';
															}

															aStore.add({'PercentilePolicy': percentile, 'MinValue': minValue, 'MaxValue' : maxValue, 'Associates' : linkUrl, 'modifyValue' : '-', 'deleteValue' : isAssociate});
														}
														Ext.getCmp('mainGrid').bindStore(aStore);
													}
												});
												j++;
											}
										}
										);
									}
								}
							}
							else
							{
								for (var i=0; i<len; i++)
								{
									Ext.getCmp('mainGrid').getSelectionModel().deselect(selectedRecords[i]);
								}
							}
						},this);
			}
	},

	goToMainView: function()
	{
		Ext.getCmp('modifyPercentile').hide();
		Ext.getCmp('mainGrid').show();
		Ext.getCmp('addBackButton').hide();

		var mainGridObj = Ext.getCmp('mainGrid');
		var allPercentileDetails = new Array();
		var isAssociate = '';

		var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp";
		Ext.Ajax.request(
		{
			url : url,
			scope: this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var len = jsonData.policyDetailsArrayJson.length;
				var lenForAssoc = jsonData.associatesArrayJson.length;

				var aStore = new Ext.data.Store({
					fields: ['PercentilePolicy','MinValue','MaxValue','Associates','modifyValue','deleteValue'],
					data: [],
				});

				var k = 0;
				for (var i=0; i<len; i++)
				{
					var isAssociate = 'No';

					var percentile = jsonData.policyDetailsArrayJson[i].aListPercentiles;
					var minValue = jsonData.policyDetailsArrayJson[i].aListMinValues;
					var maxValue = jsonData.policyDetailsArrayJson[i].aListMaxValues;

					allPercentileDetails[k] = percentile;
					allPercentileDetails[k+1] = minValue;
					allPercentileDetails[k+2] = maxValue;
					allPercentileDetails[k+3] = isAssociate;

					for (var j=0; j<lenForAssoc; j++)
					{
						var associates = jsonData.associatesArrayJson[j].strValue;

						if (percentile == associates)
						{
							isAssociate = 'Yes';
							allPercentileDetails[k+3] = isAssociate;
						}
					}
					k = k+4;
				}

				for (var i=0; i<allPercentileDetails.length; i=i+4)
				{
					var percentile = allPercentileDetails[i];
					var minValue = allPercentileDetails[i+1];
					var maxValue = allPercentileDetails[i+2];
					var associates = allPercentileDetails[i+3];
					var linkUrl = '';

					if (associates == 'Yes')
					{
						var onclickFunction = "\"javascript:showAssociates('"+percentile+"');\"";

						linkUrl = percentile;
						isAssociate = 'hasAssociate';
					}
					else
					{
						linkUrl = '-';
						isAssociate = 'noAssociate';
					}

					aStore.add({'PercentilePolicy': percentile, 'MinValue': minValue, 'MaxValue' : maxValue, 'Associates' : linkUrl, 'modifyValue' : '-', 'deleteValue' : isAssociate});
				}
				mainGridObj.bindStore(aStore);
				Ext.getCmp('addNew').show();
			}
		});
	},

	// added for refresh so that session will be set on click
	tabChange: function()
	{
		var aTab = Ext.getCmp('capPlanTabs').getActiveTab();
		var activeTabTitle = aTab.title;
		var isAssociate = '';
		var selectTab = '';
		var allPercentileDetails = new Array();
		var mainGridObj = Ext.getCmp('mainGrid');

		if (activeTabTitle == 'Configure Percentile Policy')
		{
			selectTab = 'ConfigurePercentilePolicy';
			Ext.getCmp('descId').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;' + capPlanDesc + '</center>');

			var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp";

			Ext.Ajax.request(
			{
				url : url,
				scope: this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var len = jsonData.policyDetailsArrayJson.length;
					var lenForAssoc = jsonData.associatesArrayJson.length;

					var aStore = new Ext.data.Store({
						fields: ['PercentilePolicy','MinValue','MaxValue','Associates','modifyValue','deleteValue'],
						data: [],
					});

					var k = 0;
					for (var i=0; i<len; i++)
					{
						var isAssociate = 'No';

						var percentile = jsonData.policyDetailsArrayJson[i].aListPercentiles;
						var minValue = jsonData.policyDetailsArrayJson[i].aListMinValues;
						var maxValue = jsonData.policyDetailsArrayJson[i].aListMaxValues;

						allPercentileDetails[k] = percentile;
						allPercentileDetails[k+1] = minValue;
						allPercentileDetails[k+2] = maxValue;
						allPercentileDetails[k+3] = isAssociate;

						for (var j=0; j<lenForAssoc; j++)
						{
							var associates = jsonData.associatesArrayJson[j].strValue;
							if (percentile == associates)
							{
								isAssociate = 'Yes';
								allPercentileDetails[k+3] = isAssociate;
							}
						}
						k = k+4;
					}

					for (var i=0; i<allPercentileDetails.length; i=i+4)
					{
						var percentile = allPercentileDetails[i];

						var minValue = allPercentileDetails[i+1];
						var maxValue = allPercentileDetails[i+2];
						var associates = allPercentileDetails[i+3];
						var linkUrl = '';

						if (associates == 'Yes')
						{
							var onclickFunction = "\"javascript:showAssociates('"+percentile+"');\"";
							linkUrl = percentile;
							isAssociate = 'hasAssociate';
						}
						else
						{
							linkUrl = '-';
							isAssociate = 'noAssociate';
						}

						aStore.add({'PercentilePolicy': percentile, 'MinValue': minValue, 'MaxValue' : maxValue, 'Associates' : linkUrl, 'modifyValue' : '-', 'deleteValue' : isAssociate});
					}
					mainGridObj.bindStore(aStore);
				}
			});
		}

		if (activeTabTitle == 'Configure Tests')
		{
			selectTab = 'ConfigureTests';
			Ext.getCmp('descId').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;' + configTestDesc + '</center>');
		}

		if (activeTabTitle == 'Configure Tests' && showOnlyFromSession == 'configTests')
		{
			selectTab = 'ConfigureTests';
			var urlForConfigTests = "/final/admin/EgReportCustomSetting/data/EgReportSettingJSON.jsp";

			Ext.Ajax.request(
			{
				url : urlForConfigTests,
				scope: this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					Ext.getCmp("componentType").getStore().loadRawData(jsonData.compTypeArrayJson);

					var testName = Ext.getCmp('testName').getValue();

					if (testName != 'Choose a test')
					{
						Ext.getCmp('configUpdateBtn').show();
					}
					else
					{
						Ext.getCmp('configUpdateBtn').hide();
					}
				}
			});
		}

		if (activeTabTitle == 'Configure System Reports')
		{
			selectTab = 'ConfigureSystemReports';
			Ext.getCmp('descId').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;' + configSysDesc + '</center>');

			var url = "/final/admin/EgReportCustomSetting/data/EgReportSysSettingJSON.jsp";
			Ext.Ajax.request(
				{
					url : url,
					scope: this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						for (var i=1; i<=5; i++)
						{
							var title = jsonData.titleArrayJson[i-1];

							var hiddenTitleField = new Ext.form.field.Hidden({
								xtype: 'hiddenfield',
								id: 'Measure'+i+'_Title',
								name: 'Measure'+i+'_Title',
								value: title,
							});
							Ext.getCmp('configSysTitle').add(hiddenTitleField);

							Ext.getCmp('check'+i).setValue(jsonData.tmpCheckArrayJson[i-1]);

							Ext.getCmp('Measure'+i+'_Major').setValue(jsonData.tmpLesserArrayJson[i-1]);

							Ext.getCmp('Measure'+i+'_Critical').setValue(jsonData.tmpGreaterArrayJson[i-1]);

						}
					}
				}
			);
		}
		Ext.Ajax.request({
			url: 'EgReportCustomSetting/data/reportcustomsettingshelpJson.jsp?selectTab='+selectTab,
			method: 'POST',
			async: false
		});
	},

	goToView: function()
	{
		var mainViewPort = Ext.getCmp('mainViewport');
		var isAssociate = '';
		mainViewPort.removeAll();

		mainViewPort.add({ xtype: 'capacityplanning'});

		var aTab = Ext.getCmp('capPlanTabs').getActiveTab();
		var me = this;

		var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp";

		var allPercentileDetails = new Array();

		Ext.Ajax.request(
		{
			url : url,
			scope: this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var len = jsonData.policyDetailsArrayJson.length;
				var lenForAssoc = jsonData.associatesArrayJson.length;

				var aStore = new Ext.data.Store({
					fields: ['PercentilePolicy','MinValue','MaxValue','Associates','modifyValue','deleteValue'],
					data: [],
				});

				var k = 0;
				for (var i=0; i<len; i++)
				{
					var isAssociate = 'No';

					var percentile = jsonData.policyDetailsArrayJson[i].aListPercentiles;
					var minValue = jsonData.policyDetailsArrayJson[i].aListMinValues;
					var maxValue = jsonData.policyDetailsArrayJson[i].aListMaxValues;

					allPercentileDetails[k] = percentile;
					allPercentileDetails[k+1] = minValue;
					allPercentileDetails[k+2] = maxValue;
					allPercentileDetails[k+3] = isAssociate;

					for (var j=0; j<lenForAssoc; j++)
					{
						var associates = jsonData.associatesArrayJson[j].strValue;

						if (percentile == associates)
						{
							isAssociate = 'Yes';
							allPercentileDetails[k+3] = isAssociate;
						}
					}
					k = k+4;
				}

				for (var i=0; i<allPercentileDetails.length; i=i+4)
				{
					var percentile = allPercentileDetails[i];
					var minValue = allPercentileDetails[i+1];
					var maxValue = allPercentileDetails[i+2];
					var associates = allPercentileDetails[i+3];
					var linkUrl = '';

					if (associates == 'Yes')
					{
						var onclickFunction = "\"javascript:showAssociates('"+percentile+"');\"";

						linkUrl = percentile;
						isAssociate = 'hasAssociate';
					}
					else
					{
						linkUrl = '-';
						isAssociate = 'noAssociate';
					}

					aStore.add({'PercentilePolicy': percentile, 'MinValue': minValue, 'MaxValue' : maxValue, 'Associates' : linkUrl, 'modifyValue' : '-', 'deleteValue' : isAssociate});
				}
				Ext.getCmp('mainGrid').bindStore(aStore);
			}
		});
	},

	goToAssociates: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var viewStoreObj = Ext.getCmp('mainGrid');

		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);

		var onlyPolicy = record.get('PercentilePolicy');
		var operation = 'view';

		var mainViewPort = Ext.getCmp('mainViewport');
		mainViewPort.removeAll();

		mainViewPort.add({ xtype: 'associates'});

		var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp";

		Ext.Ajax.request(
			{
				url : url,
				scope: this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var len = jsonData.policyDetailsArrayJson.length;
					var lenForAssoc = jsonData.associatesArrayJson.length;

					var aStore = new Ext.data.Store({
						fields: ['displayField','valueField'],
					});

					var k = 0;
					for (var i=0; i<len; i++)
					{
						var isAssociate = 'No';

						var percentile = jsonData.policyDetailsArrayJson[i].aListPercentiles;

						aStore.add({'displayField': percentile, 'valueField': percentile });

						Ext.getCmp('policyInViewAssociate').bindStore(aStore);
					}

					Ext.getCmp('policyInViewAssociate').setValue(onlyPolicy);
				}
			}
		);

		var urlForView = "/final/admin/EgReportCustomSetting/data/EgShowPercentileAssociatesJSON.jsp?strPercentile="+encodeURIComponent(onlyPolicy)+"&perDef="+operation;

		var bStore = new Ext.data.Store({
			fields: ['Test','Measures'],
		});

		Ext.Ajax.request(
			{
				url : urlForView,
				scope: this,
				method : 'POST',
				success: function(response){
					var jsonTextForView = response.responseText;
					var jsonDataForView = Ext.decode(jsonTextForView);
					var policyName = jsonDataForView.percentilePolicy;

					var testLength = jsonDataForView.testArrayJson.length;

					for (var i=0; i<testLength; i++)
					{
						var testName = jsonDataForView.testArrayJson[i];

						var mappedTestName = jsonDataForView.mappedTestArrayJson[i];

						var urlForMeasure = "/final/admin/EgReportCustomSetting/data/EgShowPercentileAssociatesJSON.jsp?strPercentile="+encodeURIComponent(onlyPolicy)+"&testName="+testName;

						Ext.Ajax.request(
						{
							url : urlForMeasure,
							scope: this,
							method : 'POST',
							success: function(response){
								var jsonTextForMeasure = response.responseText;
								var jsonDataForMeasure = Ext.decode(jsonTextForMeasure);
								var measuresForTestLength = jsonDataForMeasure.localMeasuresForTestArrayJson.length;
								var measuresAndTestArray = jsonDataForMeasure.measuresAndTestArrayJson;

								var measuresForTestArray = jsonDataForMeasure.measuresForTestArrayJson;

								for (var j=0; j<measuresAndTestArray.length; j++)
								{
									var testslocalName = measuresAndTestArray[j].Test;
									var measureslocalName = measuresAndTestArray[j].Measures;

									var s_obj1 = '';

									for (var j=0; j<measuresForTestArray.length; j++)
									{
										var testsInAllArray = measuresForTestArray[j].Test;
										var measureslocalName = measuresForTestArray[j].Measures;

										if (testslocalName == testsInAllArray)
										{
											s_obj = new String(measureslocalName);
											s_obj1 = s_obj1 + s_obj.valueOf() + ',';
										}
									}

									bStore.add({ 'Test': testslocalName, 'Measures': s_obj1 });
									Ext.getCmp('mainGridInAssociates').bindStore(bStore);
								}
							}
						}
						);
					}
				}
			}
		);
	},
});

/* function to view the data in show associates page */
function showAssociates(onlyPolicy)
{
	var operation = 'view';

	var mainViewPort = Ext.getCmp('mainViewport');
	mainViewPort.removeAll();

	mainViewPort.add({ xtype: 'associates'});

	var url = "/final/admin/EgReportCustomSetting/data/EgPercentileOperationsJSON.jsp";

	Ext.Ajax.request(
		{
			url : url,
			scope: this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var len = jsonData.policyDetailsArrayJson.length;
				var lenForAssoc = jsonData.associatesArrayJson.length;

				var aStore = new Ext.data.Store({
					fields: ['displayField','valueField'],
				});

				var k = 0;
				for (var i=0; i<len; i++)
				{
					var isAssociate = 'No';

					var percentile = jsonData.policyDetailsArrayJson[i].aListPercentiles;

					aStore.add({'displayField': percentile, 'valueField': percentile });

					Ext.getCmp('policyInViewAssociate').bindStore(aStore);
				}

				Ext.getCmp('policyInViewAssociate').setValue(onlyPolicy);
			}
		}
	);

	var urlForView = "/final/admin/EgReportCustomSetting/data/EgShowPercentileAssociatesJSON.jsp?strPercentile="+encodeURIComponent(onlyPolicy)+"&perDef="+operation;

	var bStore = new Ext.data.Store({
					fields: ['Test','Measures'],
				});

	Ext.Ajax.request(
		{
			url : urlForView,
			scope: this,
			method : 'POST',
			success: function(response){
				var jsonTextForView = response.responseText;
				var jsonDataForView = Ext.decode(jsonTextForView);
				var policyName = jsonDataForView.percentilePolicy;

				var testLength = jsonDataForView.testArrayJson.length;

				for (var i=0; i<testLength; i++)
				{
					var testName = jsonDataForView.testArrayJson[i];

					var mappedTestName = jsonDataForView.mappedTestArrayJson[i];

					var urlForMeasure = "/final/admin/EgReportCustomSetting/data/EgShowPercentileAssociatesJSON.jsp?strPercentile="+encodeURIComponent(onlyPolicy)+"&testName="+testName;

					Ext.Ajax.request(
					{
						url : urlForMeasure,
						scope: this,
						method : 'POST',
						success: function(response){
							var jsonTextForMeasure = response.responseText;
							var jsonDataForMeasure = Ext.decode(jsonTextForMeasure);
							var measuresForTestLength = jsonDataForMeasure.localMeasuresForTestArrayJson.length;
							var measuresAndTestArray = jsonDataForMeasure.measuresAndTestArrayJson;

							var measuresForTestArray = jsonDataForMeasure.measuresForTestArrayJson;

							for (var j=0; j<measuresAndTestArray.length; j++)
							{
								var testslocalName = measuresAndTestArray[j].Test;
								var measureslocalName = measuresAndTestArray[j].Measures;

								var s_obj1 = '';

								for (var j=0; j<measuresForTestArray.length; j++)
								{
									var testsInAllArray = measuresForTestArray[j].Test;
									var measureslocalName = measuresForTestArray[j].Measures;

									if (testslocalName == testsInAllArray)
									{
										s_obj = new String(measureslocalName);
										s_obj1 = s_obj1 + s_obj.valueOf() + ',';
									}
								}

								bStore.add({ 'Test': testslocalName, 'Measures': s_obj1 });
								Ext.getCmp('mainGridInAssociates').bindStore(bStore);
							}
						}
					}
					);
				}
			}
		}
	);
}

function checkNumber(value)
{
	var numbers = "0123456789";
	var hasNonNumericalCharacter = "false";

	for (var i=0;i<value.length;i++)
	{
		var strChar = value.charAt(i);

		if (numbers.indexOf(strChar) == -1)
		{
			hasNonNumericalCharacter = "true";
			break;
		}
	}

	if (hasNonNumericalCharacter == "true")
	{
		return false;
	}
	else
	{
		return true;
	}
}

function checkblank(str_Value)
{
	//str_Value=field.value;
	var int_Flag = 1;
	if(str_Value.length==0)
	{
		int_Flag=0;
	}
	for(i=1;i<=str_Value.length ;i++)
	{
		if(str_Value.charAt(i-1) == " ")
		{
			int_Flag=0;
		}
		else
		{
			int_Flag = 1;
			break;
		}
	}
	if(int_Flag != 1)
	{
		return false;
	}
	return true;
}

//validation for space
function checkspace(field)
{
	s_val = field;
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			//alert(_checkblank);
			return false;
		}
	}
	return true;
}

function checkspecialnomess(fieldValue,s_spl)
{
	obj_val = fieldValue;
	
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			return false;
		}
	}
	return true;
}



