Ext.define('EgReportCustomSetting.view.AddModifyPolicy', {
	extend: 'Ext.window.Window',
	alias: 'widget.addModifyPolicy',
	id: 'newPolicyWindow',
	width: 420,
	height: 260,
	padding:'5 10 10 10',
	title: newPolicy,
	resizable: false,
	draggable: false,
	modal: true,
	listeners : {
		close : function()
		{
			Ext.Ajax.request({
				url:'EgReportCustomSetting/data/EgReportSysSettingJSON.jsp',
				method:'POST'
			});
		}
	},
	requires: ['utilities.ScrollCombo'],
	items: [
		{
			xtype: 'container',
			id: 'addModifyPercentile',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			defaults: {
				labelSeparator: '',
				labelAlign: 'top',
				margin: 5
			},
			margin: 10,
			items: [
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: policyText,
					width: 250,
					allowBlank: false,
					id: 'addPolicyName'
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: policyText,
					width: 250,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					editable: false,
					queryMode: 'local',
					labelAlign: 'top',
					labelSeparator: ' ',
					id: 'percentilePoliciesForModify'
				},
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: minimumText,
					width: 250,
					allowBlank: false,
					id: 'addModifyMinimumValue'
				},
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: maximumText,
					width: 250,
					allowBlank: false,
					id: 'addModifyMaximumValue'
				},
				{
					xtype: 'button',
					cls:'button20',
					text: addText,
					width: 80,
					margin: '10 0 10 0',
					id:'UpdateBtn'
				}
			]
		}
	]

});



