Ext.define('EgReportCustomSetting.view.Associates', {
	extend: 'Ext.form.Panel',
	alias: 'widget.associates',
	cls: 'outerpanel',
	title: associatesTitle,
	margin: '8 8 0 8',	
	header:{cls:'zonereporthead'},
	requires: ['utilities.ScrollCombo','utilities.CustomGrid'],
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	items: [
		{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;' + associatesDesc + '</center>',
			width:'100%',
			height: 25,
			padding: 3
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: associatesPolicyCombo,
					labelSeparator: ' ',
					width: 320,
					labelWidth: 120,
					margin: '10 0 5 0',
					editable: false,
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : []
					}),
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					name: 'policyInViewAssociate',
					id: 'policyInViewAssociate',
				}
			]
		},
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id: 'mainGridInAssociates',
			store: new Ext.data.Store({
				fields : ['Test', 'Measures'],
				data : []
			}),
			flex: 1,
			autoScroll: true,
			scroll: true,
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: "<table border='0' height='350px' width='100%'><tr><td align=center valign=middle><img src='/final/images/spacer.gif' class='iconInformation'><div class='commonErrorMsgText'>No data found for your selection.</div></td></tr></table>",
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: testText,
						dataIndex: 'Test',
						width: 280
					},
					{
						text: measuresText,
						dataIndex: 'Measures',
						flex: 1,
						renderer : function(value) {
							var measures = value.split(",");
							var measuresLen = measures.length;
							var rowText = '';
							for (var d = 0; d < measuresLen; d = d + 3)
							{
								var colText = '';
								for (var e = d; e < d + 3; e++)
								{
									if (e < measuresLen)
									{
										colText = colText + '<td valign="top" height="20" width="33%" style="font-size:8pt;font-family:Tahoma,Calibri,Arial,Helvetica,sans-serif;">'+measures[e]+'</td>';
									}
									else
									{
										colText = colText + '<td valign="top" height="20" width="33%">&nbsp;</td>';
									}
								}
								rowText = rowText + '<tr>' + colText + '</tr>';
							}
							return '<table border="0" width="100%" cellspacing="0" cellpadding="0">'+rowText+'</table>';
						}
					}
				]
			},
			margin: '10 10 10 10'
		}
	],

	tools : [
		{
			xtype : 'button',
			cls: 'backbutton',
			id : 'backbutton',
			iconCls:'iconBack',
			text: backText
		}
	]

});



