Ext.define('EgReportCustomSetting.view.CapacityPlanning', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.capacityplanning',
	cls: 'outerpanel',
	frame:true,
	border:true,
	title: capPlanTitle,
	margin: '8 8 0 8',
	header:{cls:'zonereporthead'},

	requires: [
		'utilities.ScrollCombo',
		'utilities.CustomGrid',
		'utilities.ScrollTabPanel'
	],

	layout: {
		type: 'vbox',
		align:'stretch'
	},

	items: [
		{
			xtype: 'component',
			id: 'descId',
			cls: 'adminHeadInfoText',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;' + capPlanDesc + '</center>',
			width: '100%',
			height: 25,
			padding: 3
		},
		{
			xtype: 'scrolltabPanel',
			style:{'border':'0px !important'},
			cls: 'tablayout',
			id: 'capPlanTabs',
			plain: true,
			tabPosition: 'top',
			autoScroll: false,
			scroll: false,
			flex: 1,
			margin: 10,
			items: [
				{
					title: policyConfigure,
					layout: {
						type: 'vbox',
						align:'stretch'
					},
					cls:'tabLayoutInnerBorder',
					style:{'border-top':'0px'},
					items:[
						{
							xtype: 'customgrid',
							cls:'gridSkin',
							id: 'mainGrid',
							store: new Ext.data.Store({
								fields : ['PercentilePolicy', 'MinValue', 'MaxValue', 'Associates'],
								data : []
							}),
							autoScroll: true,
							flex: 1,
							margin: 10,
							viewConfig: {
								deferEmptyText: true
							},
							emptyText: "<table border='0' height='350px' width='100%'><tr><td align=center vlaign=top><img src='/final/admin/eg_images/exclamation-icon.gif'><div>No Policies Configured</div></td></tr></table>",
							selModel: {
								selType: 'checkboxmodel',
								mode: 'MULTI',
								checkOnly: true,
							},
							columns: {
								defaults: {
									sortable: true,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false
								},
								items: [
									{
										text: policyText,
										dataIndex: 'PercentilePolicy',
										flex:1,
										id: 'policyText',
									},
									{
										text: minimumText,
										dataIndex: 'MinValue',
										flex:1,
										id: 'policyText1',
									},
									{
										text: maximumText,
										dataIndex: 'MaxValue',
										flex:1,
										id: 'policyText2',
									},
									{
										xtype: 'actioncolumn',
										dataIndex: 'Associates',
										id: 'showAssociates',
										width: 36,
										iconCls: 'iconShowAssociates',
										sortable: false,
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											metaData.tdAttr = "data-qtip='"+showAssociatesLabel+"' data-qclass='yellowTip'";
											if (value != '-')
											{
												this.disabled = false;
											}
											else
											{
												this.disabled = true;
											}
										},
									},
									{
										xtype: 'actioncolumn',
										width: 36,
										iconCls:'iconModify',
										sortable: false,
										id: 'modifyInView',
										dataIndex: 'modifyValue',
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
										}
									},
									{
										header : '<div class="iconDeleteAll" data-qtip="Delete All" data-qclass="yellowTip"></div>',
										xtype: 'actioncolumn',
										width: 36,
										sortable: false,
										id: 'deleteInView',
										dataIndex: 'deleteValue',
										listeners: {
											headerclick: function(g, index, ev) {
												thisController.deleteCheckBox();
											},
										},
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
											if (value == 'hasAssociate')
											{
												return '<div class="iconDeleteDisabled"></div>';
											}
											if (value == 'noAssociate')
											{
												return "<div style='cursor:pointer' onclick=\"javascript:thisController.deletePolicyInView('"+gridView+"','"+row+"','"+col+"')\" class='iconDelete'></div>";
											}
										},
									}
								]
							},
							tbar: [
								{
									xtype:'tbfill',
								},
								{
									xtype: 'toolbar',
									ui: 'footer',
									items:[
										{
											xtype: 'button',
											cls:'button20',
											text: addPolicy,
											id: 'addNew'
										}
									]
								}
							]
						}
					]
				},
				{
					xtype: 'configTests',
					id: 'configTestTab',
					cls:'tabLayoutInnerBorder',
					style:{'border-top':'0px'},
					layout: {
						type: 'vbox',
						align:'stretch'
					}
				},
				{
					xtype: 'configSystemReports',
					cls:'tabLayoutInnerBorder',
					style:{'border-top':'0px'},
				}
			]
		}
	],
	
	tools: [
		{
			xtype : 'button',
			cls:'backbutton',
			id : 'addBackButton',
			iconCls:'iconBack',
			text : backBtnText,
			hidden : true
		}
	]

});



