Ext.define('sla.controller.Main',{
	extend:'Ext.app.Controller',
	views:['SlaList','SlaViewDetails','SlaAddSecond','SlaTimeFilter','SlaModify','SlaExcludeIncludeDescriptors'],
	requires : ['sla.view.SlaAdd','sla.view.SlaAddSecond','sla.view.SlaTimeFilter','sla.view.SlaModify','sla.view.SlaExcludeIncludeDescriptors'],
	refs:[
		{selector:'slaList', ref:'slaList'},
		{selector:'slaAdd', ref:'slaAdd'},
		{selector:'slaAddSecond', ref:'slaAddSecond'},
		{selector:'slaViewDetails', ref:'slaViewDetails'},
		{selector:'slaTimeFilter', ref:'slaTimeFilter'},
		{selector:'slaModify', ref:'slaModify'},
		{selector:'sla.view.SlaExcludeIncludeDescriptors', ref:'sla.view.SlaExcludeIncludeDescriptors'}
	],
	init:function(){
		appCnt = this;
		this.control({
			'slaList':
			{
				'afterrender': this.afterMainRender
			},
			'slaList button[id="addSLA"]':
			{
				'click': this.AddSLA
			},
			'slaAdd combo[id="filtercompo"]':
			{
				'select': this.compTypeSelectCombo
			},
			'slaAdd combo[id="testcompo"]':
			{
				'select': this.testTypeSelectCombo
			},
			'slaAdd button[id="add"]':
			{
				'click': this.loadingrid
			},
			'slaAdd button[id="next"]':
			{
				'click': this.loadSlaSecondAdd
			},
			'slaAddSecond radiogroup[id="operatingh"]':
			{
				'change':this.radioOnChange
			},
			'slaAddSecond radiogroup[id="radioexp"]':
			{
				'change':this.radioOnChangeforexpire
			},
			'slaAddSecond combo[id="applyto"]':
			{
				'select': this.applyToSelectCombo
			},
			'slaAddSecond button[id="assignmore"]':
			{
				'click': this.loadAssignMore
			},
			'slaAddSecond button[id="conf"]':
			{
				'click': this.loadTimeFilter
			},
			'slaAddSecond combo[id="Compon"]':
			{
				'select': this.loadItemSelector
			},
			'slaAddSecond combo[id="complscroll"]':
			{
				'select': this.anyConditionLoad
			},
			'slaTimeFilter button[id="app"]':
			{
				'click': this.loadSlaTable
			},
			'slaAddSecond button[id="finish"]':
			{
				'click': this.finishAdd
			},
			'slaModify button[id="goo"]':
			{
				'click': this.goButtonClick
			},
			'slaAdd button[id="updatemodify"]':
			{
				'click': this.updateRule
			},
			'slaAddSecond button[id="secUpdate"]':
			{
				'click': this.updateAttributes
			},
			'slaAddSecond checkbox[id="checkAssociation"]':
			{
				'change':this.checkboxClick
			},
			'slaAddSecond button[id="finishmodify"]':
			{
				'click': this.finishAssociation
			},
			/*'slaAddSecond button[id="refine"]':
			{
				'click': this.loadRefine
			},*/
			'slaAddSecond button[id="refine"]':
			{
				'click': this.loadRefinePopup
			},
			'slaExcludeIncludeDescriptors combo[id="slatestcombo"]':
			{
				'select': this.testChangeCombo
			},
			'slaExcludeIncludeDescriptors combo[id="slascombo"]':
			{
				'select': this.slaNameChangeCombo
			},
			'slaExcludeIncludeDescriptors button[id="updaterefine"]':
			{
				'click': this.updateRefine
			},
			'slaList trigger[name="gridSearch"]':
			{
			'change': this.textFieldSearch
			}
		});
	},	
	textFieldSearch: function(){
		
		var gridsearch = Ext.getCmp('gridSearch').getValue();
		
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		//appCtn.egTitleSearch(field.getValue());
		var itemSelectorObj = Ext.getCmp('gridDisplay');
		if (Ext.String.trim(gridsearch).length > 0 && (Ext.String.trim(gridsearch) != '' || Ext.String.trim(gridsearch) != null)) {
			var regex = RegExp(gridsearch, 'i');
			var elementsItems = itemSelectorObj.getStore();
			elementsItems.clearFilter(true);								
			elementsItems.filter(new Ext.util.Filter({
			caseSensitive: true,
			filterFn: function (object) {
				var items=0;
				var match = false;
				Ext.Object.each(object.data, function (property, value) {										
					if(items==0)
					{
						match = match || regex.test(String(value));
					}
					items++;
				});
				return match;
				}
				}));
				} else {
				itemSelectorObj.getStore().clearFilter();
				}
				gridsearch.focus();
	},
	afterMainRender : function()
	{
		Ext.Ajax.request({
			url: '/final/admin/EgSLAConfiguration/data/egSLAListJSON.jsp',
			method: 'GET',			
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var publicJSON = Ext.decode( jsonText );
					var result = publicJSON['SlaNameGrid'];
					if (result != null && result.length > 0)
					{
						Ext.getCmp('gridSearch').enable();
					}
					else
					{
						Ext.getCmp('gridSearch').disable();
					}
					modifyBackBt = false;
					Ext.getCmp('gridDisplay').show();
					Ext.getCmp('gridDisplay').getStore().suspendEvents(true);
					Ext.getCmp('gridDisplay').getStore().loadRawData(publicJSON['SlaNameGrid']);
					Ext.getCmp('gridDisplay').getStore().resumeEvents();
					Ext.getCmp('addSLA').setText(publicJSON['screenLabels']['admin.common.Add SLA']);
				}
			}
			
		});
	},
	handleDeleteSelected: function(grid, rowIndex, colIndex){
		var slaNamesDel='';
		var meGrid = Ext.getCmp('gridDisplay');
		
		var meGridStore = meGrid.getStore();
		var noOfrecords = meGridStore.getCount();
		 var selectionModelObj = meGrid.getSelectionModel();
			if (noOfrecords > 0) {
				 var selected = selectionModelObj.getSelection();
				 

				 if (selected.length == 0) {
									 Ext.Msg.show({
										title: alert15,
										msg: alert1+'.',
										buttons: Ext.MessageBox.OK,
										icon: Ext.MessageBox.WARNING
										});
										return;
										}

							else
				{
					for (var i = 0; i < selected.length; i++) 
					{
					var recOrg1 = selected[i];
					slaNamesDel+=recOrg1.get('SlaNameList')+',';
											
					var selectedItems = slaNamesDel;
					var selItemsLen = selectedItems.length;
					var sellectedNameDel = selectedItems.substring(0, selItemsLen-1);
											
					}
					var message = alert2+" "+ sellectedNameDel+" ?";
					
					Ext.Msg.confirm('SLA', message, function(buttonText) {
						if (buttonText == "yes")
							{
								Ext.Ajax.request({
								url: '/final/admin/EgSLAConfiguration/data/egSaveSLAConfigJSON.jsp?sla_names='+slaNamesDel+'&param=deleteSelectedSla',
								method: 'GET',
								async:false,
								success: function( response )
								{
									if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
										{
											var jsonText = response.responseText;
											var jsonObj = Ext.decode( jsonText );
											var isSelDel = jsonObj['isSelectedDeleted'];
											var DelSlaNames = jsonObj['DeletedSla'];
											if(isSelDel)
												{
												Ext.Msg.show({
												title : alert15,
												msg : DelSlaNames+'.',
												icon: 'iconExclamation',
												buttons : Ext.Msg.OK,
												fn: function (buttonId){
												if (buttonId == "ok") {
													appcnt.getController("Main").afterMainRender();
												}
												}
											});
										}

										}
									}
								});
								}
							});
				}
		}
		else{
			Ext.Msg.show({
								title: alert15,
								msg: noSLA+'.',
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
								});
								return;
		}
	},
	AddSLA: function()
	{
		Ext.getCmp('viewport').removeAll();
		Ext.getCmp('viewport').add({xtype: 'slaAdd'});

		addedMeasures ='';
		Ext.getCmp('multifield').getStore().loadData('');
		var gval = Ext.getCmp('metricsgrid');
		gval.getStore().clearData(); 


		Ext.Ajax.request({
			url: '/final/admin/EgSLAConfiguration/data/egAddSLAJSON.jsp?flag=notmodify',
			method: 'GET',			
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;		
					
					var publicJSON = Ext.decode( jsonText );

					Ext.getCmp('SlaName').setFieldLabel(publicJSON['screenLabels']['admin.metric.SLA Name']);
					Ext.getCmp('next').setText(publicJSON['screenLabels']['admin.common.Next']);
					Ext.getCmp('text').update(publicJSON['screenLabels']['sla.configure.All conditions associated with the SLA given below,   All of these conditions to be true for the SLA to be  in compliance ']);
					Ext.getCmp('add').setText(publicJSON['screenLabels']['admin.common.ADD']);
					Ext.getCmp('back').setText(publicJSON['screenLabels']['admin.common.Back']);
					
					Ext.getCmp('filtercompo').getStore().loadRawData(publicJSON['category']);
					Ext.getCmp('filtercompo').setValue('All');
					Ext.getCmp('testcompo').getStore().loadRawData(publicJSON['testDscroll']);
					//Ext.getCmp('testcompo').setValue('Please select a test');
					Ext.getCmp('testcompo').setValue('-1');
					
					//Ext.getCmp('multifield').setValue('Not applicable');
					exSlaList = publicJSON['existingSLAS'];
				}
			}
		});
	},
	compTypeSelectCombo: function(obj)
	{
		var selectedCompType = obj.getValue();
		
		Ext.Ajax.request({
			url: '/final/admin/EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=loadTestSelectBox&selectedComponentType='+selectedCompType,
			method: 'GET',			
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var publicJSON = Ext.decode( jsonText );

					Ext.getCmp('testcompo').getStore().loadRawData(publicJSON['testscroll']);
					Ext.getCmp('testcompo').setValue('-1');
					Ext.getCmp('multifield').getStore().loadData('');
				}
			}
		});
	},
	testTypeSelectCombo:function(obj)
	{
		var testName = obj.getValue();
		var selectedCompType = Ext.getCmp('filtercompo').getValue();

		Ext.Ajax.request({
			url: '/final/admin/EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=loadSelectBoxMetrics&selectedComponentType='+selectedCompType+'&TestName='+testName,
			method: 'GET',			
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var publicJSON = Ext.decode( jsonText );

					var textcont = publicJSON['testArray'];
					Ext.getCmp('multifield').getStore().loadRawData(textcont);
				}
			}
		});

	},
	loadingrid: function()
	{
		var selectedtestname = Ext.getCmp('testcompo').getValue();
		
		var selectedDispTestName = Ext.getCmp('testcompo').getRawValue();

		var selectedmetricname = Ext.getCmp('multifield').getValue();
		var gridData = Ext.getCmp('multifield').store.data.items;


		if(selectedmetricname == undefined)
		{
					Ext.Msg.show({
						title: alert15,
						msg: choosemetric+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
						return;
		}

		if(selectedmetricname != undefined)
		{

		if(selectedmetricname.length ==0)
		{
			Ext.Msg.show({
						title: alert15,
						msg: choosemetric+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
						return;
		}

		}
		for (var i = 0; i < gridData.length; i++) 
		{
			var rowData = gridData[i].data;
			var metricname = rowData.displayField;
			var valueField = rowData.valueField;
			
			for(var j = 0; j < selectedmetricname.length; j++)
			{
				if(selectedmetricname[j]!=null && selectedmetricname[j]!=undefined && selectedmetricname[j] == valueField)
				{
					if(addedMeasures.indexOf(valueField)>=0 )
					{
						Ext.Msg.show({
						title: alert15,
						msg: alert22+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
						return;
					}
					else{
						var rulename = metricname.substring(0,metricname.indexOf("("));
						Ext.getCmp('metricsgrid').getStore().add({
						RuleName: rulename,
						Test: selectedDispTestName,
						Metric: metricname,
						Expectedcondition: "LT",
						Expectedvalue: "",
						Weight:"1",
						hiddenVal : rulename+"~$~"+valueField+"~$~LT"+"~$~none"+"~$~1"
						});
						
						addedMeasures += valueField+",";
						
					}
				}
			}
		}
	},

	loadSlaSecondAdd: function()
	{
		isass = false;
		isbackEx =false;
		qryStr='';
		isModify=false;
		modifyBackBt = false;
		result ='';
		temprulename ='';
		addslavalues.splice(0, addslavalues.length);
		var userGridObj = Ext.getCmp('metricsgrid');
		var sla = Ext.getCmp('SlaName').getValue();
		slaname = sla;
		if ((sla=="" ||sla==" " ||sla=="null"))
		{
			Ext.Msg.show({
						title: alert15,
						msg: alert3+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
			Ext.getCmp('SlaName').focus();
			return;
		}
		/*else if((checkspace(sla)==false))
		{
			Ext.Msg.show({
						title: alert15,
						msg: alert4+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
		Ext.getCmp('SlaName').focus();
		return;
		}*/
		else if((SpecialCharacterValidation(sla)==false))
		{
			Ext.Msg.show({
						title: alert15,
						msg: alert5+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
		
		return;
		}
		
		var gridvalobj = Ext.getCmp('metricsgrid');
		
		var gridData = gridvalobj.store.data.items;
		var gridLength = gridvalobj.store.data.length;
		if(gridLength ==0)
		{
			Ext.Msg.show({
						title: alert15,
						msg: alert6+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
		
		return;
		}
		
		var gridval = Ext.getCmp('metricsgrid').store.data.items;
		
		for(var i=0;i<gridval.length;i++)
		{
			var gridvall = gridval[i].data.hiddenVal;
			addslavalues.push(gridvall);
			
		}

		
		
		for (var i = 0; i < addslavalues.length; i++) 
		{
			var hiddval = addslavalues[i].split('~$~');
				var rule = hiddval[0];
				var testMeas = hiddval[1];
				var cond = hiddval[2];
				var exepctedVal = hiddval[3];
				var weightval = hiddval[4];
				
			
		if(rule=='')
		{
			addslavalues.splice(0, addslavalues.length);
			result ='';
			Ext.Msg.show({
					title: alert15,
					msg: alert7+'.',
					buttons: Ext.Msg.OK,
					width: 400,
					icon: 'iconExclamation'
					});
			return;
			}

		else if(exepctedVal==""||exepctedVal==" " ||exepctedVal=="none")
		{
			addslavalues.splice(0, addslavalues.length);
			result ='';
			Ext.Msg.show({
					title: alert15,
					msg: alert8+'.',
					buttons: Ext.Msg.OK,
					width: 400,
					icon: 'iconExclamation'
					});
			return;
			}

			else if((checkspace(exepctedVal)==false))
			{
				addslavalues.splice(0, addslavalues.length);
				result ='';
				Ext.Msg.show({
						title: alert15,
						msg: alert9+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}

			else if((SpecialCharacterValidation(exepctedVal)==false))
			{
				addslavalues.splice(0, addslavalues.length);
				result ='';
				Ext.Msg.show({
						title: alert15,
						msg: alert10+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}

			else if(isNumber(exepctedVal)==false)
			{
				addslavalues.splice(0, addslavalues.length);
				result ='';
				return;
			}



		if(testMeas!=null && cond!=null && exepctedVal!= 'none' && rule!=null && weightval!=null)
		{
			
			if(rule=="")
			{
				addslavalues.splice(0, addslavalues.length);
				result ='';
				Ext.Msg.show({
						title: alert15,
						msg: alert7+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}

			else if(exepctedVal==""||exepctedVal==" " ||exepctedVal==null)
			{
				addslavalues.splice(0, addslavalues.length);
				result ='';
				Ext.Msg.show({
						title: alert15,
						msg: alert8+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}

			else if((checkspace(exepctedVal)==false))
			{
				addslavalues.splice(0, addslavalues.length);
				result ='';
				Ext.Msg.show({
						title: alert15,
						msg: alert9+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}
			else if((SpecialCharacterValidation(exepctedVal)==false))
			{
				addslavalues.splice(0, addslavalues.length);
				result ='';
				Ext.Msg.show({
						title: alert15,
						msg: alert10+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}
			else if(isNumber(exepctedVal)==false)
			{
				addslavalues.splice(0, addslavalues.length);
				result ='';
				Ext.getCmp('exv').focus();
				return;
			}

			else if((SpecialCharacterValidation(weightval)==false))
			{
				addslavalues.splice(0, addslavalues.length);
				result ='';
				Ext.Msg.show({
						title: alert15,
						msg: alert10+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}
			else if(isNumber(weightval)==false)
			{
				result ='';
				addslavalues.splice(0, addslavalues.length);
				return;
			}
			else if(weightval==0)
			{
				result ='';
				addslavalues.splice(0, addslavalues.length);
				Ext.Msg.show({
						title: alert15,
						msg: alert11+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}
			else if(weightval==""||weightval==" " ||weightval==null)
			{
				result ='';
				addslavalues.splice(0, addslavalues.length);
				Ext.Msg.show({
						title: alert15,
						msg: alert27+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}
				
				var existtempru=temprulename.split(",");
				var existte = existtempru.length;
				


			if(temprulename!=null && !Ext.isEmpty(temprulename)) 
			{
				
				var existtemprule=temprulename.split(",");
				
				for(var a=0;a<existtemprule.length;a++)
				{
					var per = false;
					var existrule=existtemprule[a];
					
					if(existrule.trim()==rule.trim())
					{
						addslavalues.splice(0, addslavalues.length);
						result ='';
						Ext.Msg.show({
						title: alert15,
						msg: exrulename+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
						return;
					}
				}
			}
			temprulename+=rule+',';
			
			var tempvar = rule+"|"+testMeas+"|"+cond+":"+exepctedVal+"|W:"+weightval;
			result+=tempvar+",";
			
		}
	}


	if(exSlaList!=null && exSlaList!=undefined & !Ext.isEmpty(exSlaList))
		{
			var exsistSLA = exSlaList.split(",");
			for(var i=0;i<exsistSLA.length;i++)
			{
				var ex_sla = exsistSLA[i];
				if(ex_sla.trim()==sla)
				{
					addslavalues.splice(0, addslavalues.length);
					Ext.Msg.show({
						title: alert15,
						msg: SLAAlready+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
					return;
				}
			}
		}

		Ext.getCmp('viewport').removeAll();
		Ext.getCmp('viewport').add({xtype: 'slaAddSecond'});
		
		
		Ext.Ajax.request({
			url: '/final/admin/EgSLAConfiguration/data/egConfigSLAJSON.jsp?isNewSLA=true&flag=create',
			method: 'GET',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					console.log('jsonText222-->>',jsonText);
					var publicJSON = Ext.decode( jsonText );

					Ext.getCmp('compliance').setFieldLabel(publicJSON['screenLabels']['What compliance do you expect?']);
					Ext.getCmp('operatingh').setFieldLabel(publicJSON['screenLabels']['What are operating hours']);
					//Ext.getCmp('bAlable').setInputValue(publicJSON['screenLabels']['Always']);
					//Ext.getCmp('bSlable').setInputValue(publicJSON['screenLabels']['Specific']);
					Ext.getCmp('contractperiod').setFieldLabel(publicJSON['screenLabels']['What is the SLA contract period']);
					Ext.getCmp('from').setFieldLabel(publicJSON['screenLabels']['From']);
					Ext.getCmp('sthrs').setFieldLabel(publicJSON['screenLabels']['Hrs']);
					Ext.getCmp('stmins').setFieldLabel(publicJSON['screenLabels']['Mins']);
					Ext.getCmp('dslaexp').setFieldLabel(publicJSON['screenLabels']['Does this SLA expires']);
					//Ext.getCmp('operatingh').setFieldLabel(publicJSON['screenLabels']['Yes']);
					//Ext.getCmp('operatingh').setFieldLabel(publicJSON['screenLabels']['No']);
					Ext.getCmp('to').setFieldLabel(publicJSON['screenLabels']['To']);
					Ext.getCmp('endhrs').setFieldLabel(publicJSON['screenLabels']['Hrs']);
					Ext.getCmp('endmins').setFieldLabel(publicJSON['screenLabels']['Mins']);
					Ext.getCmp('complscroll').setFieldLabel(publicJSON['screenLabels']['SLA compliance period']);
					Ext.getCmp('ignoremaint').setFieldLabel(publicJSON['screenLabels']['Should ignore maintenance period']);
					Ext.getCmp('assignmore').setText(publicJSON['screenLabels']['Assign More']);
					Ext.getCmp('finish').setText(publicJSON['screenLabels']['Finish']);
					Ext.getCmp('refine').setText(publicJSON['screenLabels']['Refine']);
					//Ext.getCmp('specific').setValue(publicJSON['screenLabels']['Configured Specific Periods']);
					Ext.getCmp('Slas').hide();

					Ext.getCmp('sthrs').show();
					Ext.getCmp('sthrs').getStore().suspendEvents(true);
					Ext.getCmp('sthrs').getStore().loadRawData(publicJSON['hours']);
					Ext.getCmp('sthrs').getStore().resumeEvents();
					Ext.getCmp('sthrs').setValue('00');
					
					
					Ext.getCmp('endhrs').show();
					Ext.getCmp('endhrs').getStore().suspendEvents(true);
					Ext.getCmp('endhrs').getStore().loadRawData(publicJSON['hours']);
					Ext.getCmp('endhrs').getStore().resumeEvents();
					Ext.getCmp('endhrs').setValue('00');

					Ext.getCmp('anySthrs').show();
					Ext.getCmp('anySthrs').getStore().suspendEvents(true);
					Ext.getCmp('anySthrs').getStore().loadRawData(publicJSON['hours']);
					Ext.getCmp('anySthrs').getStore().resumeEvents();
					Ext.getCmp('anySthrs').setValue('00');


					Ext.getCmp('anyStmin').show();
					Ext.getCmp('anyStmin').getStore().suspendEvents(true);
					Ext.getCmp('anyStmin').getStore().loadRawData(publicJSON['minutes']);
					Ext.getCmp('anyStmin').getStore().resumeEvents();
					Ext.getCmp('anyStmin').setValue('00');

					Ext.getCmp('anyEndhrs').show();
					Ext.getCmp('anyEndhrs').getStore().suspendEvents(true);
					Ext.getCmp('anyEndhrs').getStore().loadRawData(publicJSON['hours']);
					Ext.getCmp('anyEndhrs').getStore().resumeEvents();
					Ext.getCmp('anyEndhrs').setValue('00');




					Ext.getCmp('anyEndmin').show();
					Ext.getCmp('anyEndmin').getStore().suspendEvents(true);
					Ext.getCmp('anyEndmin').getStore().loadRawData(publicJSON['minutes']);
					Ext.getCmp('anyEndmin').getStore().resumeEvents();
					Ext.getCmp('anyEndmin').setValue('00');



					Ext.getCmp('stmins').show();
					Ext.getCmp('stmins').getStore().suspendEvents(true);
					Ext.getCmp('stmins').getStore().loadRawData(publicJSON['minutes']);
					Ext.getCmp('stmins').getStore().resumeEvents();
					Ext.getCmp('stmins').setValue('00');


					Ext.getCmp('endmins').show();
					Ext.getCmp('endmins').getStore().suspendEvents(true);
					Ext.getCmp('endmins').getStore().loadRawData(publicJSON['minutes']);
					Ext.getCmp('endmins').getStore().resumeEvents();
					Ext.getCmp('endmins').setValue('00');

					Ext.getCmp('complscroll').show();
					Ext.getCmp('complscroll').getStore().suspendEvents(true);
					Ext.getCmp('complscroll').getStore().loadRawData(publicJSON['complperiod']);
					Ext.getCmp('complscroll').getStore().resumeEvents();
					Ext.getCmp('complscroll').setValue(Today);

					Ext.getCmp('applyto').show();
					Ext.getCmp('applyto').getStore().suspendEvents(true);
					Ext.getCmp('applyto').getStore().loadRawData(publicJSON['applyscroll']);
					Ext.getCmp('applyto').getStore().resumeEvents();
					Ext.getCmp('applyto').setValue(Zone);

					Ext.getCmp('from').setValue(publicJSON['currentdate']);
					Ext.getCmp('to').setValue(publicJSON['currentEndDate']);
					
					Ext.getCmp('sthrs').setValue(publicJSON['currenthr']);
					Ext.getCmp('stmins').setValue(publicJSON['currentmins']);
					Ext.getCmp('endhrs').setValue(publicJSON['currenthr']);
					Ext.getCmp('endmins').setValue(publicJSON['currentmins']);
					
					Ext.getCmp('anyfrom').setValue(publicJSON['currentdate']);
					Ext.getCmp('anyto').setValue(publicJSON['currentEndDate']);
					Ext.getCmp('anySthrs').setValue(publicJSON['currenthr']);
					Ext.getCmp('anyStmin').setValue(publicJSON['currentmins']);
					Ext.getCmp('anyEndhrs').setValue(publicJSON['currenthr']);
					Ext.getCmp('anyEndmin').setValue(publicJSON['currentmins']);

				}
			}
			});
			var url=Ext.urlEncode('EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=selectboxes&sla_name='+slaname+'&infraType=Zone&rulesValue='+encodeURIComponent(result)+'&flag=create');
				Ext.Ajax.request({
				//url: url,
				url: 'EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=selectboxes&sla_name='+slaname+'&infraType=Zone&rulesValue='+encodeURIComponent(result)+'&flag=create',
				method: 'POST',			
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var publicJSON = Ext.decode( jsonText );

						Ext.getCmp('itemsel').getStore().loadRawData(publicJSON['itemselector']);
					}
				}
				});
	},

	radioOnChange: function(obj, newValue, oldValue, eOpts)
	{
		var radiosell = newValue.operating;
		if(radiosell == 'specific')
		{
			Ext.getCmp('spcontainer').show();
			if(showConfigData){
				Ext.getCmp('tablecont').show();
			}
			else{
				Ext.getCmp('tablecont').hide();
			}
		}
		else
		{
			Ext.getCmp('spcontainer').hide();
			Ext.getCmp('tablecont').hide();
		}
	
	},
	
	radioOnChangeforexpire: function(obj, newValue, oldValue, eOpts)
	{
		var sell = newValue.exp;
		if(sell == 'no')
		{
		Ext.getCmp('tocontainer').hide();
		}
		else
		{
		Ext.getCmp('tocontainer').show();
			
			if(isModify)
			{
				Ext.getCmp('to').setValue(modEndD);
				Ext.getCmp('endhrs').setValue(modEndH);
				Ext.getCmp('endmins').setValue(modEndM);
			}
		}
	},

	applyToSelectCombo :function(obj)
	{
		var selectedCompType = obj.getValue();
		Ext.getCmp('itemsel').getStore().removeAll();
		Ext.getCmp('itemsel').setValue('');
		var url ="";
		if(isModify)
		{
			if(selectedCompType == 'ComponentType')
			{
				showAssociatedElementsVal =false;
				url = '/final/admin/EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=InfraElements&infraType=ComponentType&showassociate='+showAssociatedElementsVal+'&sla_name='+sellslaName+'&flag=false&showassociate=true';
				console.log('moddd url',url);
				
				Ext.getCmp('Compon').show();
				Ext.getCmp('checkAssociation').show();

			}
			else
			{
				Ext.getCmp('Compon').hide();
				Ext.getCmp('checkAssociation').hide();

				
				url='/final/admin/EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=selectboxes&sla_name='+sellslaName+'&infraType='+selectedCompType+'&flag=false';
				
			}
		}
		else
		{
			if(selectedCompType == 'ComponentType')
			{
				url = '/final/admin/EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=InfraElements&sla_name='+slaname+'&infraType='+selectedCompType;
				Ext.getCmp('Compon').show();
				console.log('addd url',url);

			}
			else
			{
				url='/final/admin/EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=selectboxes&sla_name='+slaname+'&infraType='+selectedCompType+'&rulesValue='+encodeURIComponent(result)+'&flag=true';
				Ext.getCmp('Compon').hide();
			}
		}
		Ext.Ajax.request({
			url: url,
			method: 'GET',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					
					var publicJSON = Ext.decode( jsonText );
					if(selectedCompType == 'ComponentType')
					{
						Ext.getCmp('Compon').getStore().loadRawData(publicJSON['compArr']);
						Ext.getCmp('Compon').setValue('-1');
					}
					else
					{
						//var itemselectorval = publicJSON['itemselector'];
						Ext.getCmp('itemsel').getStore().loadRawData(publicJSON['itemselector']);
						
						//Ext.getCmp('itemsel').getStore().loadRawData(publicJSON['assignItemSel']);
						Ext.getCmp('itemsel').setValue(publicJSON['assignItemSel']);
						
					}
				}
			}
		});
	},

	anyConditionLoad:function(obj)
	{
		var selecComp = obj.getValue();

		if (selecComp=='Any')
		{
			Ext.getCmp('timeperiod').show();
		}
		else
		{
			Ext.getCmp('timeperiod').hide();
		}
	},

	loadItemSelector :function(obj)
	{
		var url ="";
		var selectedComp = obj.getValue();
		Ext.getCmp('itemsel').getStore().removeAll();
		Ext.getCmp('itemsel').setValue('');
		
		if(isModify)
		{
			url = '/final/admin/EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=selectboxes&infraType=ComponentType&infraElement='+selectedComp+'&sla_name='+sellslaName+'&flag=false';
		}
		else
		{
				url=
				'/final/admin/EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=selectboxes&sla_name='+slaname+'&infraType=ComponentType&infraElement='+selectedComp+'&rulesValue='+encodeURIComponent(result)+'&flag=true';
		}

		Ext.Ajax.request({
				url: url,
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var publicJSON = Ext.decode( jsonText );
						
						
							//Ext.getCmp('itemsel').getStore().loadRawData(publicJSON['assignItemSel']);
						
						Ext.getCmp('itemsel').getStore().loadRawData(publicJSON['itemselector']);
						Ext.getCmp('itemsel').setValue(publicJSON['assignItemSel']);
					}
				}
			});
	},


	loadTimeFilter: function()
	{
		Ext.Ajax.request({
			url: '/final/admin/EgSLAConfiguration/data/egSLATimeFilterJSON.jsp',
			method: 'GET',			
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var publicJSON = Ext.decode( jsonText );
					timeFilterConfig = Ext.create("Ext.window.Window", {
					id:'timewindow',
					timeFilterConfig:'',
					height:300,
					width:460,
					bodyBorder:true,
					title:TimeFilter,
					closable:true,
					draggable:true,
					modal:true,
					resizable:true,
					scroll:true,
					autoScroll:true,
					closeAction:'destroy',
					layout:'vbox',
					layout: 'fit',
					//maximizable: true,
					items:[{
						xtype: 'slaTimeFilter',
						scroll:true,
						autoScroll:true,
						jsonData:publicJSON
					}],
					listeners: {
						show: function (f) {
							if (this.modal) {
								var g = Ext.dom.Query.select(".x-mask");
								var e = Ext.fly(g[0]);
								e.addCls("windowModal");
							}
						},
						hide: function (f) {
							if (this.modal) {
								var g = Ext.dom.Query.select(".x-mask");
								var e = Ext.fly(g[0]);
								e.removeCls("windowModal");
							}
						},
						afterrender: function () {
							Ext.EventManager.onWindowResize(function () {
								var e = this;
								e.center();
							}, this);
						}
					},
				});
				timeFilterConfig.show();
				}
			}
		});
	},


	loadRefinePopup: function()
	{
		var url ='';
		
		if(isModify)
		{
			slaNAME = sellslaName;
		}
		else
		{
			slaNAME = slaname;
		}
		url = '/final/admin/EgSLAConfiguration/data/egRefineSLADescriptorJSON.jsp?sla_name='+slaNAME;

		
		Ext.Ajax.request({
			url: url,
			method: 'GET',			
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var publicJSON = Ext.decode( jsonText );
					ExcludeIncludeDescript = Ext.create("Ext.window.Window", {
					id:'refinepop',
					ExcludeIncludeDescript:'',
					height:600,
					width:770,
					bodyBorder:true,
					title:EXCLUDEINCLUDE,
					closable:true,
					draggable:true,
					modal:true,
					resizable:true,
					scroll:true,
					autoScroll:true,
					closeAction:'destroy',
					layout:'vbox',
					layout: 'fit',
					//maximizable: true,
					items:[{
						xtype: 'slaExcludeIncludeDescriptors',
						scroll:true,
						autoScroll:true,
						jsonData:publicJSON
					}],
					listeners: {
						show: function (f) {
							if (this.modal) {
								var g = Ext.dom.Query.select(".x-mask");
								var e = Ext.fly(g[0]);
								e.addCls("windowModal");
							}
						},
						hide: function (f) {
							if (this.modal) {
								var g = Ext.dom.Query.select(".x-mask");
								var e = Ext.fly(g[0]);
								e.removeCls("windowModal");
							}
						},
						afterrender: function () {
							Ext.EventManager.onWindowResize(function () {
								var e = this;
								e.center();
							}, this);
						}
					},
				});
				ExcludeIncludeDescript.show();
				}
			}
		});























	},





























	
	loadSlaTable: function()
	{
		isloadSlaTable = true;
		var Cweekdays = new Array();

		Tshours=Ext.getCmp('hscroll').getValue();
		Tsmins=Ext.getCmp('mscroll').getValue();
		
		Tehours=Ext.getCmp('hoscroll').getValue();
		Temins=Ext.getCmp('miscroll').getValue();

		var sth = Tshours+':'+Tsmins;
		var edh = Tehours+':'+Temins;
		if(sth > edh)
		{
			Ext.Msg.show({
								title: alert15,
								msg: alert19+'.',
								buttons: Ext.Msg.OK,
								width: 400,
								icon: 'iconExclamation'
								});
						return;
		}

		var checkCategories = Ext.getCmp('checkboxdays').getChecked();
		for (var i=0; i<checkCategories.length; i++)
		{
			var aCategory = checkCategories[i];
			var inputValueForCategory = aCategory.inputValue;
			//Cweekdays += inputValueForCategory + ',';
			Cweekdays.push(inputValueForCategory);
		}
		
		/*var Cweekends = new Array();;
		var checkCategories = Ext.getCmp('checkboxexclud').getChecked();
		
		for (var i=0; i<checkCategories.length; i++)
		{
			var aCategory = checkCategories[i];
			var inputValueForCategory = aCategory.inputValue;
			
			//allCheckedweekends += inputValueForCategory + ',';
			Cweekends.push(inputValueForCategory);
			
		}
		
		var selected_week_days="";
		var repeat_selection_flag=false;
		var weekdays=new Array();
		var excluded_week_ends=new Array();

		for(j=0;j<Cweekends.length;j++)
		{
			
				excluded_week_ends[j]=Cweekends[j];
			
		}
		for(i=0;i<Cweekdays.length;i++)
		{
			if(Cweekdays[i]==undefined)
				continue;
			else
			{
				var tmp_weekday=Cweekdays[i];
				for(j=0;j<excluded_week_ends.length;j++)
				{
					if(excluded_week_ends[j]==undefined)
						continue;
					else
					{
						var tmp_excluded_week_ends=excluded_week_ends[j];
						if(tmp_weekday==tmp_excluded_week_ends)
						{
							selected_week_days+=tmp_weekday+",";
							repeat_selection_flag=true;
						}
					}
				}
			}
		}

		if(repeat_selection_flag)
		{
			var selectedWeek = selected_week_days
			var sWeek = selected_week_days.length;
			var week = selectedWeek.substring(0, sWeek-1);

			Ext.Msg.show({
								title: alert15,
								msg: "'"+week+"'"+alreadysel+'.',
								buttons: Ext.Msg.OK,
								width: 400,
								icon: 'iconExclamation'
								});
						return;
		}*/

		var starthour = Ext.getCmp('hscroll').getValue();
		var starmin = Ext.getCmp('mscroll').getValue();
		var endhour = Ext.getCmp('hoscroll').getValue();
		var endmin = Ext.getCmp('miscroll').getValue();
		
		var daysforWeekdays="";
		var daysForExcludeWeekEnd="";
		var dispPeakHours='-';
		var dispWeekDays='-';
		var excludeDispWeekEnds='-';
		qryStr ='';

		if(starthour!=null && starthour!='undefined')
		{
			
		qryStr+='&start_hours='+starthour;
		
		dispPeakHours=starthour+':';
		}	
		if(starmin!=null && starmin!='undefined')
		{
		qryStr+='&start_minutes='+starmin;
		dispPeakHours+=starmin;
		}
		if(endhour!=null && endhour!='undefined')
		{
		qryStr+='&end_hours='+endhour;
		dispPeakHours+=' - '+endhour+':';
		}
		if(endmin!=null && endmin!='undefined')
		{
		qryStr+='&end_minutes='+endmin;
		dispPeakHours+=endmin;

		if(dispPeakHours!=null && dispPeakHours=='' || (dispPeakHours=='00:00 - 00:00'))
			dispPeakHours='-';
		}

		var allCheckedweekdays = Cweekdays.toString();
		
		if(allCheckedweekdays!=null && allCheckedweekdays!='undefined' && allCheckedweekdays!="")
		{
		
		var num=0;
		var index=0;
		var allCheckedweekdays = allCheckedweekdays.split(',');
			
		for(i=0;i<allCheckedweekdays.length;i++)
		{
			daysforWeekdays=daysforWeekdays+","+allCheckedweekdays[i];
		}

		if(daysforWeekdays!=null && daysforWeekdays.length>2)
		daysforWeekdays=daysforWeekdays.substr(daysforWeekdays.indexOf(",")+1,daysforWeekdays.length);
		qryStr+='&WeekDays='+daysforWeekdays;
		dispWeekDays=daysforWeekdays;
		
		if(dispWeekDays!=null && dispWeekDays=="")
			dispWeekDays='-';
		}
	
		/*var allCheckedweekends = Cweekends.toString();

		if(allCheckedweekends!=null && allCheckedweekends!='undefined' && allCheckedweekends!="")
		{
		var num=0;
		var index=0;
		var allCheckedweekends = allCheckedweekends.split(',');

		for(i=0;i<allCheckedweekends.length;i++)
		{
			daysForExcludeWeekEnd=daysForExcludeWeekEnd+","+allCheckedweekends[i];
		}
		if(daysForExcludeWeekEnd!=null && daysForExcludeWeekEnd.length>2)
		daysForExcludeWeekEnd=daysForExcludeWeekEnd.substr(daysForExcludeWeekEnd.indexOf(',')+1,daysForExcludeWeekEnd.length);
		qryStr+='&ExcludeWeekEnds='+daysForExcludeWeekEnd;
		excludeDispWeekEnds=daysForExcludeWeekEnd;
		
		if(excludeDispWeekEnds!=null && excludeDispWeekEnds=='')
			excludeDispWeekEnds='-';
		}*/

		if((dispPeakHours!=null && dispPeakHours=='-') && (dispWeekDays!=null && dispWeekDays=='-') && (excludeDispWeekEnds!=null && excludeDispWeekEnds=='-'))
		{
				Ext.Msg.show({
								title: alert15,
								msg: confSpecicPer+'.',
								buttons: Ext.Msg.OK,
								width: 400,
								icon: 'iconExclamation'
								});
						return;
		}
		
		/*timeFilterTableData="<table border='0' cellspacing='0' cellpadding='4' width='90%' class='tableborder_ad'><col width='18%'><col width='2%'><col width='80%'><tr><td colspan='3' align='center' class='tdborder_ad2 eg_75bold'><egui:intnl text='admin.sla.Configured Specific Periods'/></td></tr>";
		if ( dispPeakHours != null && dispPeakHours != "-")
		{
		timeFilterTableData+="<tr><td class='tdborder_ad' nowrap>"+peakhours+"</td><td class='tdborder_ad'> : </td><td class='tdborder_ad'>"+dispPeakHours+"</td></tr>";
		}
		if ( dispWeekDays != null && dispWeekDays != "-" )
		{
		timeFilterTableData+="<tr><td class='tdborder_ad' nowrap>"+peakweekdays+"</td><td class='tdborder_ad'> : </td><td class='tdborder_ad'>"+dispWeekDays+"</td></tr>";
		}
		if ( excludeDispWeekEnds != null && excludeDispWeekEnds != "-" )
		{
		timeFilterTableData+="<tr><td class='tdborder_ad' nowrap>"+Exweekends+"</td><td class='tdborder_ad'> : </td><td class='tdborder_ad'>"+excludeDispWeekEnds+"</td></tr>";
		}
		timeFilterTableData+="</table>";*/
		
		if ( dispPeakHours != null && dispPeakHours != "-")
		{
			timeFilterTableData="Operating hrs - ";
		}
		if(dispWeekDays != null && dispWeekDays != "-")
		{
			timeFilterTableData+=dispWeekDays;
		}
		else{
			timeFilterTableData+="All Days";
		}
		if ( dispPeakHours != null && dispPeakHours != "-")
		{
			timeFilterTableData+="("+dispPeakHours+' Hrs)</div>';
		}
		alert("hhhhhhhhh"+timeFilterTableData);
		Ext.getCmp('loadtable').update(timeFilterTableData);
		Ext.getCmp('tablecont').show();
		Ext.getCmp('timewindow').destroy();
	},

	loadRefine: function()
	{
		/*Ext.getCmp('viewport').removeAll();
		Ext.getCmp('viewport').add({xtype: 'slaExcludeIncludeDescriptors'});
		Ext.getCmp('componentDetails').hide();
		Ext.getCmp('updaterefine').hide();
		var url ='';
		
		if(isModify)
		{
			slaNAME = sellslaName;
		}
		else
		{
			slaNAME = slaname;
		}
		url = '/final/admin/EgSLAConfiguration/data/egRefineSLADescriptorJSON.jsp?sla_name='+slaNAME;

		Ext.Ajax.request({
				url: url,
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						
						var publicJSON = Ext.decode( jsonText );
						Ext.getCmp('slascombo').getStore().suspendEvents(true);
						Ext.getCmp('slascombo').getStore().loadRawData(publicJSON['slanamelist']);
						Ext.getCmp('slascombo').getStore().resumeEvents();
						Ext.getCmp('slascombo').setValue(publicJSON['selslaname']);
					}
				}
			});

			Ext.Ajax.request({
				url: '/final/admin/EgSLAConfiguration/data/egRefineSLADescriptorpJSON.jsp?param=testListDiv&sla_name='+slaNAME,
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						console.log('jsonTextjsonText',jsonText);
						var publicJSON = Ext.decode( jsonText );
						Ext.getCmp('slatestcombo').getStore().suspendEvents(true);
						Ext.getCmp('slatestcombo').getStore().loadRawData(publicJSON['slatest']);
						Ext.getCmp('slatestcombo').getStore().resumeEvents();
						Ext.getCmp('slatestcombo').setValue('-1');
					}
				}
			});*/
	},
	
	slaNameChangeCombo: function(obj)
	{
		var selectedTest = obj.getValue();
		if(selectedTest == (-1))
		{
			
			Ext.getCmp('componentDetails').hide();
			Ext.getCmp('updaterefine').hide();
			Ext.getCmp('noDes').show();
			return;
		}

		var selectedSLA = obj.getValue();
		slaNAME = selectedSLA
		Ext.getCmp('updaterefine').hide();
		Ext.getCmp('componentDetails').hide();
		Ext.getCmp('noDes').show();
		Ext.Ajax.request({
				url: '/final/admin/EgSLAConfiguration/data/egRefineSLADescriptorpJSON.jsp?param=testListDiv&sla_name='+selectedSLA,
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						
						var publicJSON = Ext.decode( jsonText );
						console.log('publicJSONyyyyyyyy',publicJSON);
						Ext.getCmp('slatestcombo').getStore().suspendEvents(true);
						Ext.getCmp('slatestcombo').getStore().loadRawData(publicJSON['slatest']);
						Ext.getCmp('slatestcombo').getStore().resumeEvents();
						Ext.getCmp('slatestcombo').setValue('-1');
					}
				}
			});
	},
	testChangeCombo: function(obj)
	{
		var selectedTest = obj.getValue();
		if(selectedTest == (-1))
		{
			
			Ext.getCmp('componentDetails').hide();
			Ext.getCmp('updaterefine').hide();
			Ext.getCmp('noDes').show();
			return;
		}
		
		
		Ext.getCmp('componentDetails').hide();
		Ext.getCmp('updaterefine').hide();
		Ext.getCmp('noDes').show();
		
		
		Ext.Ajax.request({
				url: '/final/admin/EgSLAConfiguration/data/egRefineSLADescriptorpJSON.jsp?param=infoListDiv&sla_name='+slaNAME+'&testName='+selectedTest,
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						
						var publicJSON = Ext.decode( jsonText );
						console.log('publicJSONpublicJSONxxx',publicJSON);
						Ext.getCmp('noDes').hide();
						Ext.getCmp('componentDetails').show();
						Ext.getCmp('updaterefine').show();
						Ext.getCmp('componentDetails').getStore().loadRawData(publicJSON['excludedItem']);
						Ext.getCmp('componentDetails').getStore().resumeEvents();
						Ext.getCmp('componentDetails').setValue(publicJSON['includedItem']);
						console.log('publiexitem',publicJSON['excludedItem']);
						console.log('publiIIIIitem',publicJSON['includedItem']);
					}
				}
			});
			
	},	

	updateRefine: function()
	{
		var selTest = Ext.getCmp('slatestcombo').getValue();
		var excludedInfosValue="";
		var availableInfosValue="";
		var includedDesc = Ext.getCmp('componentDetails').getValue();
		var Arr = new Array();
			for (var i = 0; i < Ext.getCmp('componentDetails').getStore().getCount(); i++) 
				{
					var isData = false;
					var allValue = Ext.getCmp('componentDetails').getStore().getAt(i).get('valueField');
					for (var j = 0; j < includedDesc.length; j++) {
					if (allValue == includedDesc[j]) {
					isData = true;
					break;
					}
					}
					if (!isData) {
					Arr[Arr.length] = allValue;
					}
				}
			var excludeDesc = Arr;
			var url='/final/admin/EgSLAConfiguration/data/egSaveSLAConfigJSON.jsp?param=saveExcludedDescriptors&sla_name='+slaNAME+'&test='+selTest;

		if(excludeDesc!=null && excludeDesc!="undefined")
		{
			if((includedDesc!=null && includedDesc.length==0) && (excludeDesc!=null && excludeDesc.length==0))
			{
				
				Ext.Msg.show({
								title: alert15,
								msg: NoDescriptors+'.',
								buttons: Ext.Msg.OK,
								width: 400,
								icon: 'iconExclamation'
								});
				return;
			}
			for(var i=0;i<excludeDesc.length>0;i++)
			{
				excludedInfosValue=excludedInfosValue+"|"+excludeDesc[i];
			}
			for(var i=0;i<includedDesc.length>0;i++)
			{
				availableInfosValue=availableInfosValue+","+includedDesc[i];
			}
			
			
			if(excludedInfosValue!=null && excludedInfosValue.length>1)
			{
				
				excludedInfosValue=excludedInfosValue.substr(1,excludedInfosValue.length);
				excludedInfosValue=selTest+":"+excludedInfosValue;
				url+='&excludedInfos='+excludedInfosValue;
			}
			if(availableInfosValue!=null && availableInfosValue.length>1)
			{
				
				availableInfosValue=availableInfosValue.substr(1,availableInfosValue.length);
				availableInfosValue=selTest+":"+availableInfosValue;
				url+='&includeInfos='+availableInfosValue;
			}
		}
		
		Ext.Ajax.request({
				url: url,
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var publicJSON = Ext.decode( jsonText );
						var isRefine = publicJSON['isrefined'];
							if(isRefine == true)
							{
								Ext.Msg.show({
										title : alert15,
										msg : alert12+"'"+slaNAME+"'"+alert13+'.',
										icon: 'iconExclamation',
										buttons : Ext.Msg.OK,
										fn: function (buttonId){
										if (buttonId == "ok") {
											//Ext.getCmp('viewport').removeAll();
											//Ext.getCmp('viewport').add({xtype: 'slaList'});
											
										}
										}
									});
								
					}
					else
						{
									Ext.Msg.show({
										title : alert15,
										msg : alert24+" "+slaNAME+" "+alert13+'.',
										icon: 'iconExclamation',
										buttons : Ext.Msg.OK
									});
							}
					}
				}
			});
	},

	loadAssignMore: function()
	{
		var selectedInfraType =Ext.getCmp('applyto').getValue();
		var selectedInfraElement =Ext.getCmp('Compon').getValue();
		var associatedElements=new Array();
		var disAssociatedElements=new Array();
		associatedElements = Ext.getCmp('itemsel').getValue();
		var noOfAssociatedS = associatedElements.length;
		var url ='';
		var SLANAME ='';
		var Arr = new Array();
		
		for (var i = 0; i < Ext.getCmp('itemsel').getStore().getCount(); i++) 
			{
				var isData = false;
				var allValue = Ext.getCmp('itemsel').getStore().getAt(i).get('valueField');
				for (var j = 0; j < associatedElements.length; j++) {
				if (allValue == associatedElements[j]) {
				isData = true;
				break;
				}
				}
				if (!isData) {
				Arr[Arr.length] = allValue;
				}
			}
			
		disAssociatedElements = Arr;

		
		if(isModify)
		{
			if((selectedInfraType!=null && selectedInfraType=="ComponentType") && (selectedInfraElement!=null && selectedInfraElement=="" || selectedInfraElement=="-1"))
			{
				Ext.Msg.show({
							title: alert15,
							msg: sellcompT+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
					return;
			}
			
			url ='/final/admin/EgSLAConfiguration/data/egSaveSLAConfigJSON.jsp?param=saveSLAAssignModification&sla_name='+sellslaName+'&associatedElements='+associatedElements+'&disAssociatedElements='+disAssociatedElements+'&infraType='+selectedInfraType+'&infraElement='+selectedInfraElement;
			SLANAME = sellslaName;
		}
		else
		{
			var expectedCompliance=Ext.getCmp('compliance').getValue();
			var nearingCompliance=5;
			var selectedCompTimePeriod='';
			var infraType=Ext.getCmp('applyto').getValue();
			var components=Ext.getCmp('Compon').getValue();
			var selectedOperatingPeriod = Ext.getCmp('operatingh').getValue().operating;
			
			var rulesValue = result.substring(0, result.lastIndexOf(","));
			
			var daysPeriods='';
			var weeksPeriods='';
			var monthsPeriods='';
			var mainperiod=Ext.getCmp('ignoremaint').getValue().maint;
			var issla=Ext.getCmp('radioexp').getValue().exp;
			
			if(issla=='yes')
			{
				var isSLAContinous=false;
			}
			else
			{
				var isSLAContinous=true;
			}
			var sdate='';
			var hours='';
			var mins='';
			var edate='';
			var ehours='';
			var emins='';
			var associatedElementsObj='';
			var disassociatedElementsObj='';
			var associatedElements=new Array();
			var disAssociatedElements=new Array();
			var selectedInfraType=infraType;
			var SLAAssociated='true';
			var selectedTimePeriod="";
			var tempvar="";
			var user="";
			
			var endDate="";
			var hrs=Ext.getCmp('sthrs').getValue();
			var min=Ext.getCmp('stmins').getValue();
			var ignoreMainPeriod="";
			var displayPeriodStartHrVal='';
			var displayPeriodStartMinVal='';
			var anyPeriodStartDateVal='';
			var anyPeriodEndDateVal='';
			var displayPeriodEndHrVal='';
			var displayPeriodEndMinVal='';
			var changeCompliancePeriod="false";
			var selectedInfraElement =components;
			var displayPeriodVal = Ext.getCmp('complscroll').getValue();
			var slannnn = slaname;
			SLANAME = slaname;

			var fromValue = Ext.getCmp('from').getValue();
			
			fromValue = formatDate(fromValue, 'MM/dd/yyyy');
			
			var startDate=fromValue;
			
			if(issla=='yes')
			{
			var toValue = Ext.getCmp('to').getValue();
			
			toValue = formatDate(toValue, 'MM/dd/yyyy');
			
			endDate=toValue;

			ehours=Ext.getCmp('endhrs').getValue();
			emins=Ext.getCmp('endmins').getValue();
			}

			var anyfromValue = Ext.getCmp('anyfrom').getValue();
			
			anyfromValue = formatDate(anyfromValue, 'MM/dd/yyyy');
		
			var anyPeriodStartDateVal=anyfromValue;

			var displayPeriodStartHrVal= Ext.getCmp('anySthrs').getValue();

			var displayPeriodStartMinVal= Ext.getCmp('anyStmin').getValue();
			
			var anytoValue = Ext.getCmp('anyto').getValue();
			
			anytoValue = formatDate(anytoValue, 'MM/dd/yyyy');
			
			var anyPeriodEndDateVal=anytoValue;

			console.log('anyPeriodEndDateVal',anyPeriodEndDateVal);
			console.log('anyPeriodStartDateVal',anyPeriodStartDateVal);
			
			var displayPeriodEndHrVal= Ext.getCmp('anyEndhrs').getValue();
			
			var displayPeriodEndMinVal= Ext.getCmp('anyEndmin').getValue();

			associatedElements = Ext.getCmp('itemsel').getValue();
			var noOfAssociatedServers = associatedElements.length;
			var Arr = new Array();
			for (var i = 0; i < Ext.getCmp('itemsel').getStore().getCount(); i++) 
				{
					var isData = false;
					var allValue = Ext.getCmp('itemsel').getStore().getAt(i).get('valueField');
					for (var j = 0; j < associatedElements.length; j++) {
					if (allValue == associatedElements[j]) {
					isData = true;
					break;
					}
					}
					if (!isData) {
					Arr[Arr.length] = allValue;
					}
				}
				
			disAssociatedElements = Arr;

			if(expectedCompliance=="" ||expectedCompliance=="" ||expectedCompliance=="null")
			{
				Ext.Msg.show({
							title: alert15,
							msg: expCempt+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
				compliance.focus();
				return;
			}
			else if(expectedCompliance==0)
			{
				Ext.Msg.show({
							title: alert15,
							msg: cannotbeZ+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
				compliance.focus();
				return;
			}
			else if(expectedCompliance<0)
			{
				Ext.Msg.show({
							title: alert15,
							msg: lessthanZ+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
				compliance.focus();
				return;
			}
			else if(expectedCompliance>100)
			{
				Ext.Msg.show({
							title: alert15,
							msg: lessthanHund+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
				compliance.focus();
				return;
				
			}	
			else if(isNumber(expectedCompliance)==false)
			{
				compliance.focus();
				return;
			}
		url = '/final/admin/EgSLAConfiguration/data/egSaveSLAConfigJSON.jsp?param=submit&sla_name='+slaname+'&rulesValues='+encodeURIComponent(rulesValue)+'&expectedComplaince='+expectedCompliance+'&complaince_duration='+selectedTimePeriod+'&displayPeriod='+displayPeriodVal+'&anyPeriodStartDate='+anyPeriodStartDateVal+'&anyPeriodStartHour='+displayPeriodStartHrVal+'&anyPeriodStartMin='+displayPeriodStartMinVal+'&anyPeriodEndDate='+anyPeriodEndDateVal+'&anyPeriodEndHour='+displayPeriodEndHrVal+'&anyPeriodEndMin='+displayPeriodEndMinVal+'&startDate='+startDate+'&hrs='+hrs+'&min='+min+'&enddate='+endDate+'&endhours='+ehours+'&endmins='+emins+'&ignoreMainPeriod='+mainperiod+'&issla='+issla+'&associatedElements='+associatedElements+'&disAssociatedElements='+disAssociatedElements+'&infraType='+selectedInfraType+'&infraElement='+selectedInfraElement+'&selectedOperatingPeriod='+selectedOperatingPeriod+'&nearingCompliance='+nearingCompliance;
		
			if(selectedOperatingPeriod=="specific")
			{

				
				if(qryStr!=null && qryStr=="")
				{
					Ext.Msg.show({
							title: alert15,
							msg: confPeriod+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
					return;
				}
				else
				{
					url+=qryStr;
					
				}
			}
		
			
			var sDate=startDate+" "+hrs+":"+min;
			var eDate=endDate+" "+ehours+":"+emins;
			if(issla =='yes')
			{
				if(new Date(sDate).getTime()>=new Date(eDate).getTime())
				{
					Ext.Msg.show({
								title: alert15,
								msg: startDlessE+'.',
								buttons: Ext.Msg.OK,
								width: 400,
								icon: 'iconExclamation'
								});
						return;
				}
			}

			var tempDisplayPeriodStartDateVal = getDateFromFormat(anyPeriodStartDateVal,'MM/dd/yyyy');
			var convertDateOfStartVal = new Date(tempDisplayPeriodStartDateVal);
			convertDateOfStartVal.setHours( displayPeriodStartHrVal );
			convertDateOfStartVal.setMinutes( displayPeriodStartMinVal );
			convertDateOfStartVal.setSeconds( 0 );

			var tempDisplayPeriodEndDateVal = getDateFromFormat(anyPeriodEndDateVal,'MM/dd/yyyy');
			var convertDateOfEndVal = new Date(tempDisplayPeriodEndDateVal);
			convertDateOfEndVal.setHours( displayPeriodEndHrVal );
			convertDateOfEndVal.setMinutes( displayPeriodEndMinVal );
			convertDateOfEndVal.setSeconds( 0 );
			
			if(displayPeriodVal =='Any')
			{

			if ( convertDateOfStartVal.getTime() >  convertDateOfEndVal.getTime() )
			{
				Ext.Msg.show({
							title: alert15,
							msg: stLessTIM+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
					return;
			}

			if ( convertDateOfStartVal.getTime() < new Date(sDate).getTime() )
			{
				Ext.Msg.show({
							title: alert15,
							msg: stDSlaStD+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
					return;
			}
			
			if ( !isSLAContinous && convertDateOfEndVal.getTime() > new Date(eDate).getTime())
			{
				Ext.Msg.show({
							title: alert15,
							msg: endDlessSlaEndD+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
					return;
			}
			}

			if((selectedInfraType!=null && selectedInfraType=="ComponentType") && (selectedInfraElement!=null && selectedInfraElement=="" || selectedInfraElement=="-1"))
			{
				Ext.Msg.show({
							title: alert15,
							msg: sellcompT+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
					return;
			}
			
			if ( noOfAssociatedServers == 0 )
			{
				Ext.Msg.show({
							title: alert15,
							msg: assocElemNull+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
					return;
			}

		}

	
		
	Ext.Ajax.request({
				url: url,
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
							if(!isModify)
							{
								Ext.getCmp('refine').setDisabled(false);
							}
						Ext.Msg.show({
							title: 'SLA',
							msg: 'Component has been defined succeessfully',
							buttons: Ext.MessageBox.OK,
							maskCls :'windowModal',
							icon: 'iconExclamation'
						});
					}
				}
			});
		
		Ext.Ajax.request({
				url: '/final/admin/EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=associateelement&sla_name='+SLANAME,
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						Ext.getCmp('Associate').show();
						var jsonText = response.responseText;
						isass =true;
						var publicJSON = Ext.decode( jsonText );
						Ext.getCmp('assignmoregrid').getStore().suspendEvents(true);
						Ext.getCmp('assignmoregrid').getStore().loadData(publicJSON['associated']);
						Ext.getCmp('assignmoregrid').getStore().resumeEvents();
					}
				}
				});
	},

	finishAdd:function()
	{
	var expectedCompliance=Ext.getCmp('compliance').getValue();
	var nearingCompliance=5;
	var selectedCompTimePeriod='';
	var infraType=Ext.getCmp('applyto').getValue();
	var components=Ext.getCmp('Compon').getValue();
	var selectedOperatingPeriod = Ext.getCmp('operatingh').getValue().operating;
	
	var rulesValue = result.substring(0, result.lastIndexOf(","));
	
	var daysPeriods='';
	var weeksPeriods='';
	var monthsPeriods='';
	var mainperiod=Ext.getCmp('ignoremaint').getValue().maint;
	var issla=Ext.getCmp('radioexp').getValue().exp;
	
	if(issla=='yes')
		{
			var isSLAContinous=false;
		}
		else
		{
			var isSLAContinous=true;
		}
	var sdate='';
	var hours='';
	var mins='';
	var edate='';
	var ehours='';
	var emins='';
	var associatedElementsObj='';
	var disassociatedElementsObj='';
	var associatedElements=new Array();
	var disAssociatedElements=new Array();
	var selectedInfraType=infraType;
	var SLAAssociated='true';
	var selectedTimePeriod="";
	var tempvar="";
	var user="";
	
	var endDate="";
	var hrs=Ext.getCmp('sthrs').getValue();
	var min=Ext.getCmp('stmins').getValue();
	var ignoreMainPeriod="";
	var anyPeriodStartDateVal='';
	var displayPeriodStartHrVal='';
	var displayPeriodStartMinVal='';
	var anyPeriodEndDateVal='';
	var displayPeriodEndHrVal='';
	var displayPeriodEndMinVal='';
	

	var anyfromValue = Ext.getCmp('anyfrom').getValue();
	
	anyfromValue = formatDate(anyfromValue, 'MM/dd/yyyy');

	var anyPeriodStartDateVal=anyfromValue;

	var displayPeriodStartHrVal= Ext.getCmp('anySthrs').getValue();

	var displayPeriodStartMinVal= Ext.getCmp('anyStmin').getValue();
	
	var anytoValue = Ext.getCmp('anyto').getValue();
	
	anytoValue = formatDate(anytoValue, 'MM/dd/yyyy');
	
	var anyPeriodEndDateVal=anytoValue;
	
	var displayPeriodEndHrVal= Ext.getCmp('anyEndhrs').getValue();

	var displayPeriodEndMinVal= Ext.getCmp('anyEndmin').getValue();
	
	var changeCompliancePeriod="false";
	var selectedInfraElement =components;
	var displayPeriodVal = Ext.getCmp('complscroll').getValue();
	var slannnn = slaname;
	

	var fromValue = Ext.getCmp('from').getValue();
	
	fromValue = formatDate(fromValue, 'MM/dd/yyyy');
	
	var startDate=fromValue;

	if(issla=='yes')
	{
	var toValue = Ext.getCmp('to').getValue();
	
	toValue = formatDate(toValue, 'MM/dd/yyyy');
	
	endDate=toValue;

	ehours=Ext.getCmp('endhrs').getValue();
	emins=Ext.getCmp('endmins').getValue();
	}
	
	
	associatedElements = Ext.getCmp('itemsel').getValue();
	var noOfAssociatedServers = associatedElements.length;
	var Arr = new Array();
	for (var i = 0; i < Ext.getCmp('itemsel').getStore().getCount(); i++) 
		{
			var isData = false;
			var allValue = Ext.getCmp('itemsel').getStore().getAt(i).get('valueField');
			for (var j = 0; j < associatedElements.length; j++) {
			if (allValue == associatedElements[j]) {
			isData = true;
			break;
			}
			}
			if (!isData) {
			Arr[Arr.length] = allValue;
			}
		}
		
	disAssociatedElements = Arr;

	if(expectedCompliance=="" ||expectedCompliance=="" ||expectedCompliance=="null")
		{
			Ext.Msg.show({
						title: alert15,
						msg: expCempt+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
			compliance.focus();
			return;
		}
		else if(expectedCompliance==0)
		{
			Ext.Msg.show({
						title: alert15,
						msg: cannotbeZ+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
			compliance.focus();
			return;
		}
		else if(expectedCompliance<0)
		{
			Ext.Msg.show({
						title: alert15,
						msg: lessthanZ+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
			compliance.focus();
			return;
		}
		else if(expectedCompliance>100)
		{
			Ext.Msg.show({
						title: alert15,
						msg: lessthanHund+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
			compliance.focus();
			return;
			
		}	
		else if(isNumber(expectedCompliance)==false)
		{
			compliance.focus();
			return;
		}

	var URL='/final/admin/EgSLAConfiguration/data/egSaveSLAConfigJSON.jsp?param=submit&sla_name='+slaname+'&rulesValues='+encodeURIComponent(rulesValue)+'&expectedComplaince='+expectedCompliance+'&complaince_duration='+selectedTimePeriod+'&displayPeriod='+displayPeriodVal+'&anyPeriodStartDate='+anyPeriodStartDateVal+'&anyPeriodStartHour='+displayPeriodStartHrVal+'&anyPeriodStartMin='+displayPeriodStartMinVal+'&anyPeriodEndDate='+anyPeriodEndDateVal+'&anyPeriodEndHour='+displayPeriodEndHrVal+'&anyPeriodEndMin='+displayPeriodEndMinVal+'&startDate='+startDate+'&hrs='+hrs+'&min='+min+'&enddate='+endDate+'&endhours='+ehours+'&endmins='+emins+'&ignoreMainPeriod='+mainperiod+'&issla='+issla+'&associatedElements='+associatedElements+'&disAssociatedElements='+disAssociatedElements+'&infraType='+selectedInfraType+'&infraElement='+selectedInfraElement+'&selectedOperatingPeriod='+selectedOperatingPeriod+'&nearingCompliance='+nearingCompliance;

	
	if(selectedOperatingPeriod=="specific")
		{
		
		if(qryStr!=null && qryStr=="")
			{
				Ext.Msg.show({
						title: alert15,
						msg: confPeriod+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}
			else
			{
				URL+=qryStr;
				
			}
		}

		var sDate=startDate+" "+hrs+":"+min;
		var eDate=endDate+" "+ehours+":"+emins;

		if(issla =='yes')
		{
			
			if(new Date(sDate).getTime()>=new Date(eDate).getTime())
			{
				Ext.Msg.show({
							title: alert15,
							msg: startDlessE+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
					return;
			}
		}

		var tempDisplayPeriodStartDateVal = getDateFromFormat(anyPeriodStartDateVal,'MM/dd/yyyy');
		var convertDateOfStartVal = new Date(tempDisplayPeriodStartDateVal);
		convertDateOfStartVal.setHours( displayPeriodStartHrVal );
		convertDateOfStartVal.setMinutes( displayPeriodStartMinVal );
		convertDateOfStartVal.setSeconds( 0 );

		var tempDisplayPeriodEndDateVal = getDateFromFormat(anyPeriodEndDateVal,'MM/dd/yyyy');
		var convertDateOfEndVal = new Date(tempDisplayPeriodEndDateVal);
		convertDateOfEndVal.setHours( displayPeriodEndHrVal );
		convertDateOfEndVal.setMinutes( displayPeriodEndMinVal );
		convertDateOfEndVal.setSeconds( 0 );
		
		if(displayPeriodVal =='Any')
		{

		if ( convertDateOfStartVal.getTime() > convertDateOfEndVal.getTime() )
		{
			Ext.Msg.show({
						title: alert15,
						msg: stLessTIM+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
		}

		if ( convertDateOfStartVal.getTime() < new Date(sDate).getTime() )
		{
			Ext.Msg.show({
						title:alert15,
						msg: stDSlaStD+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
		}
		
		if ( !isSLAContinous && convertDateOfEndVal.getTime() > new Date(eDate).getTime())
		{
			Ext.Msg.show({
						title: alert15,
						msg: endDlessSlaEndD+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
		}
		
		}

		console.log('selectedInfraElement',selectedInfraElement);

		if((selectedInfraType!=null && selectedInfraType=="ComponentType") && (selectedInfraElement!=null && selectedInfraElement=="" || selectedInfraElement=="-1"))
		{
			Ext.Msg.show({
						title: alert15,
						msg: sellcompT+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
		}
		
		console.log('isbackEx',isbackEx);
		console.log('isass',isass);

		if(isass == false)
		{
			if ( noOfAssociatedServers == 0 )
			{
				Ext.Msg.show({
						title: alert15,
						msg: assocElemNull+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
					return;
			}
		}

		console.log('URL>>>>>>>>>>>>',URL);

	Ext.Ajax.request({
			url: URL,
			method: 'GET',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var publicJSON = Ext.decode( jsonText );
					var isFinished = publicJSON['result'];	
					if(isFinished == true)
						
					{
						
					Ext.Msg.show({
										title : alert15,
										msg : alert15+" "+"'"+slaname+"'"+" "+alert14+'.',
										icon: 'iconExclamation',
										buttons : Ext.Msg.OK,
										fn: function (buttonId){
										if (buttonId == "ok") {
											Ext.getCmp('viewport').removeAll();
											Ext.getCmp('viewport').add({xtype: 'slaList'});
										}
										}
									});
					}
					else
						{
									Ext.Msg.show({
										title : alert15,
										msg : alert23+" "+slaname+'.' ,
										icon: 'iconExclamation',
										buttons : Ext.Msg.OK
									});
						}
				}
			}
		});
	},
	
	handleDeleteIconClick: function(slanames)
	{
		Ext.Msg.show({
				title: alert15,
				msg: alert16+" "+"'"+slanames+"'"+" "+alert26,
				buttons: Ext.Msg.YESNO,
				icon: Ext.Msg.QUESTION,
				fn: function (buttonId) {
				if (buttonId == "yes") {
		Ext.Ajax.request({
				url: '/final/admin/EgSLAConfiguration/data/egSaveSLAConfigJSON.jsp?sla_name='+slanames+'&param=deletesla',
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var publicJSON = Ext.decode( jsonText );
						
						var deletedsla = publicJSON['sladeleted'];
						var isdelete = publicJSON['isdeleted'];
						if(isdelete == true)
					{
					Ext.Msg.show({
										title : alert15,
										msg : deletedsla+'.',
										icon: 'iconExclamation',
										buttons : Ext.Msg.OK,
										fn: function (buttonId){
										if (buttonId == "ok") {
											appcnt.getController("Main").afterMainRender();
										}
										}
									});
								
					}
					else
						{
									Ext.Msg.show({
										title : alert15,
										msg : alert25+'.',
										icon: 'iconExclamation',
										buttons : Ext.Msg.OK
									});
						}
				}
			}
		});
		}
		}
		});
	},

	handleModifyIconClick:function(modifyURL)
	{
		Ext.Ajax.request({
				url: modifyURL,
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						Ext.getCmp('viewport').removeAll();
						Ext.getCmp('viewport').add({xtype: 'slaModify'});
						var jsonText = response.responseText;
						var publicJSON = Ext.decode( jsonText );
						
						Ext.getCmp('sellopt').setFieldLabel('Change Criteria');
						Ext.getCmp('sellsla').setFieldLabel(publicJSON['screenLabels']['admin.sla.Select SLA']);
						Ext.getCmp('sellsla').getStore().suspendEvents(true);
						Ext.getCmp('sellsla').getStore().loadRawData(publicJSON['slanames']);
						Ext.getCmp('sellsla').getStore().resumeEvents();
						Ext.getCmp('sellsla').setValue(publicJSON['sellslanames']);
						Ext.getCmp('sellopt').setValue('-1');
						isModify =true;
					}
				}
			});
	},

	handleViewIconClick:function(viewURL)
	{
		Ext.Ajax.request({
			url: viewURL,
			method: 'GET',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var publicJSON = Ext.decode( jsonText );
					var ruledetails = publicJSON['conSLARule'];

					viewDetails = Ext.create("Ext.window.Window", {
					id:'slaViewDetails',
					viewDetails:'',
					height:500,
					width:800,
					bodyBorder:true,
					title:SLADetails,
					closable:true,
					draggable:true,
					modal:true,
					resizable:true,
					scroll:true,
					autoScroll:true,
					closeAction:'destroy',
					layout:'vbox',
					layout: 'fit',
					//maximizable: true,
					items:[{
						xtype: 'slaViewDetails',
						scroll:true,
						autoScroll:true,
						jsonData:publicJSON
					}],
					listeners: {
						show: function (f) {
							if (this.modal) {
								var g = Ext.dom.Query.select(".x-mask");
								var e = Ext.fly(g[0]);
								e.addCls("windowModal");
							}
						},
						hide: function (f) {
							if (this.modal) {
								var g = Ext.dom.Query.select(".x-mask");
								var e = Ext.fly(g[0]);
								e.removeCls("windowModal");
							}
						},
						afterrender: function () {
							Ext.EventManager.onWindowResize(function () {
								var e = this;
								e.center();
							}, this);
						}
					},
				});
				viewDetails.show();
				}
			}
		});
	},
	
	goButtonClick:function()
	{
		sellslaName = Ext.getCmp('sellsla').getValue();
		var selloption = Ext.getCmp('sellopt').getValue();
		if(selloption == '-1')
		{
			Ext.Msg.show({
						title : alert15,
						msg : pleaseOptN +'.',
						icon: 'iconExclamation',
						buttons : Ext.Msg.OK
						});
		}
	
		modifyBackBt =true;
		this.loadModifyCombo(selloption);
		showConfigData=false;
	},
	
	loadModifyCombo: function(selloption)
	{
		if(selloption=='SLA Rules')
		{
			Ext.getCmp('viewport').removeAll();
			Ext.getCmp('viewport').add({xtype: 'slaAdd'});
			Ext.getCmp('multifield').getStore().loadData('');
			Ext.getCmp('adminAddMsg').update(descriptor4);

			Ext.Ajax.request({
				url: '/final/admin/EgSLAConfiguration/data/egAddSLAJSON.jsp?flag=Modify SLA Rules&sla_name='+sellslaName,
				method: 'GET',			
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;	
						var publicJSON = Ext.decode( jsonText );

						Ext.getCmp('next').hide();
						Ext.getCmp('updatemodify').show();
						Ext.getCmp('updatemodify').setText(publicJSON['screenLabels']['admin.common.Update']);
						Ext.getCmp('text').update(publicJSON['screenLabels']['sla.configure.All conditions associated with the SLA given below,   All of these conditions to be true for the SLA to be  in compliance ']);
						Ext.getCmp('add').setText(publicJSON['screenLabels']['admin.common.ADD']);
						Ext.getCmp('SlaName').hide();
						Ext.getCmp('SlaNamelabel').show();

						Ext.getCmp('SlaNamelabel').setValue(sellslaName);
						
						Ext.getCmp('filtercompo').getStore().loadRawData(publicJSON['category']);
						Ext.getCmp('filtercompo').setValue("All");
						
						Ext.getCmp('testcompo').getStore().loadRawData(publicJSON['testDscroll']);
						Ext.getCmp('testcompo').setValue('-1');

						Ext.getCmp('metricsgrid').getStore().loadData(publicJSON['gridvall']);
						
						addedMeasures='';
						loadinGrMet.splice(0, loadinGrMet.length);
							
						var gridval = Ext.getCmp('metricsgrid').store.data.items;
						
							for(var i=0;i<gridval.length;i++)
							{
								var gridvall = gridval[i].data.hiddenVal;
								loadinGrMet.push(gridvall);
							}
								
							for (var i = 0; i < loadinGrMet.length; i++) 
							{
								var hiddval = loadinGrMet[i].split('~$~');
								var rule = hiddval[0];
								var testMeas = hiddval[1];
								addedMeasures +=testMeas+",";
							}
					}
				}
			});
		}
		else if(selloption=='SLA Attributes')
		{
			Ext.getCmp('viewport').removeAll();
			Ext.getCmp('viewport').add({xtype: 'slaAddSecond'});
			
			Ext.getCmp('applyto').hide();
			Ext.getCmp('Compon').hide();
			Ext.getCmp('itemselcon').hide();
			Ext.getCmp('Associate').hide();
			Ext.getCmp('buttons').hide();
			Ext.getCmp('secUpdate').show();
			
			Ext.getCmp('adminSecMsg').update(descriptor4);
			Ext.getCmp('Slas').hide();
			Ext.getCmp('SlaSecNamelabel').show();
			
			Ext.getCmp('SlaSecNamelabel').setValue(sellslaName);
			Ext.getCmp('secback').show();
			

			Ext.Ajax.request({
				url: '/final/admin/EgSLAConfiguration/data/egConfigSLAJSON.jsp?flag=Modify SLA Attributes&sla_name='+sellslaName,
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var publicJSON = Ext.decode( jsonText );
						
						Ext.getCmp('compliance').setFieldLabel(publicJSON['screenLabels']['What compliance do you expect?']);
						Ext.getCmp('operatingh').setFieldLabel(publicJSON['screenLabels']['What are operating hours']);
						Ext.getCmp('contractperiod').setFieldLabel(publicJSON['screenLabels']['What is the SLA contract period']);
						Ext.getCmp('from').setFieldLabel(publicJSON['screenLabels']['From']);
						Ext.getCmp('sthrs').setFieldLabel(publicJSON['screenLabels']['Hrs']);
						Ext.getCmp('stmins').setFieldLabel(publicJSON['screenLabels']['Mins']);
						Ext.getCmp('dslaexp').setFieldLabel(publicJSON['screenLabels']['Does this SLA expires']);
						Ext.getCmp('to').setFieldLabel(publicJSON['screenLabels']['To']);
						Ext.getCmp('complscroll').setFieldLabel(publicJSON['screenLabels']['SLA compliance period']);
						Ext.getCmp('ignoremaint').setFieldLabel(publicJSON['screenLabels']['Should ignore maintenance period']);
						Ext.getCmp('assignmore').setText(publicJSON['screenLabels']['Assign More']);
						Ext.getCmp('finish').setText(publicJSON['screenLabels']['Finish']);
						Ext.getCmp('refine').setText(publicJSON['screenLabels']['Refine']);
						//Ext.getCmp('specific').setValue(publicJSON['screenLabels']['Configured Specific Periods']);
						

						var modifiedvalue = publicJSON['modifyval'];
						Ext.getCmp('sthrs').show();
						Ext.getCmp('sthrs').getStore().suspendEvents(true);
						Ext.getCmp('sthrs').getStore().loadRawData(publicJSON['hours']);
						Ext.getCmp('sthrs').getStore().resumeEvents();
						Ext.getCmp('sthrs').setValue(modifiedvalue['sthour']);
						

						modEndD = publicJSON['currentEndDate'];
						modEndH = publicJSON['currenthr'];
						modEndM = publicJSON['currentmins'];
						
						
						Ext.getCmp('endhrs').show();
						Ext.getCmp('endhrs').getStore().suspendEvents(true);
						Ext.getCmp('endhrs').getStore().loadRawData(publicJSON['hours']);
						Ext.getCmp('endhrs').getStore().resumeEvents();
						Ext.getCmp('endhrs').setValue(modifiedvalue['endhour']);

						Ext.getCmp('anySthrs').show();
						Ext.getCmp('anySthrs').getStore().suspendEvents(true);
						Ext.getCmp('anySthrs').getStore().loadRawData(publicJSON['hours']);
						Ext.getCmp('anySthrs').getStore().resumeEvents();
						Ext.getCmp('anySthrs').setValue('00');

						Ext.getCmp('anyStmin').show();
						Ext.getCmp('anyStmin').getStore().suspendEvents(true);
						Ext.getCmp('anyStmin').getStore().loadRawData(publicJSON['minutes']);
						Ext.getCmp('anyStmin').getStore().resumeEvents();
						Ext.getCmp('anyStmin').setValue('00');

						Ext.getCmp('anyEndhrs').show();
						Ext.getCmp('anyEndhrs').getStore().suspendEvents(true);
						Ext.getCmp('anyEndhrs').getStore().loadRawData(publicJSON['hours']);
						Ext.getCmp('anyEndhrs').getStore().resumeEvents();
						Ext.getCmp('anyEndhrs').setValue('00');


						Ext.getCmp('anyEndmin').show();
						Ext.getCmp('anyEndmin').getStore().suspendEvents(true);
						Ext.getCmp('anyEndmin').getStore().loadRawData(publicJSON['minutes']);
						Ext.getCmp('anyEndmin').getStore().resumeEvents();
						Ext.getCmp('anyEndmin').setValue('00');

						Ext.getCmp('stmins').show();
						Ext.getCmp('stmins').getStore().suspendEvents(true);
						Ext.getCmp('stmins').getStore().loadRawData(publicJSON['minutes']);
						Ext.getCmp('stmins').getStore().resumeEvents();
						Ext.getCmp('stmins').setValue(modifiedvalue['stmin']);


						Ext.getCmp('endmins').show();
						Ext.getCmp('endmins').getStore().suspendEvents(true);
						Ext.getCmp('endmins').getStore().loadRawData(publicJSON['minutes']);
						Ext.getCmp('endmins').getStore().resumeEvents();
						Ext.getCmp('endmins').setValue(modifiedvalue['endmin']);

						Ext.getCmp('complscroll').show();
						Ext.getCmp('complscroll').getStore().suspendEvents(true);
						Ext.getCmp('complscroll').getStore().loadRawData(publicJSON['complperiod']);
						Ext.getCmp('complscroll').getStore().resumeEvents();
						Ext.getCmp('complscroll').setValue(Today);

						Ext.getCmp('from').setValue(publicJSON['currentdate']);
						Ext.getCmp('to').setValue(publicJSON['currentdate']);

						Ext.getCmp('anyfrom').setValue(publicJSON['currentdate']);
						Ext.getCmp('anyto').setValue(publicJSON['currentEndDate']);
						Ext.getCmp('anySthrs').setValue(publicJSON['currenthr']);
						Ext.getCmp('anyStmin').setValue(publicJSON['currentmins']);
						Ext.getCmp('anyEndhrs').setValue(publicJSON['currenthr']);
						Ext.getCmp('anyEndmin').setValue(publicJSON['currentmins']);

						Ext.getCmp('compliance').setValue(modifiedvalue['ExpectedComplaince']);
						
						var disp = modifiedvalue['DisplayPeriod'];
						var displayPeriod = disp.substring(0,disp.indexOf("#"));
							
							if(displayPeriod=='Any')
							{
								Ext.getCmp('complscroll').setValue(displayPeriod);
								Ext.getCmp('timeperiod').show();
								Ext.getCmp('anyfrom').setValue(publicJSON['AnyStDate']);
								Ext.getCmp('anyto').setValue(publicJSON['AnyEndDate']);
								Ext.getCmp('anySthrs').setValue(publicJSON['AnyStHour']);
								Ext.getCmp('anyStmin').setValue(publicJSON['AnyStMin']);
								Ext.getCmp('anyEndhrs').setValue(publicJSON['AnyEndHour']);
								Ext.getCmp('anyEndmin').setValue(publicJSON['AnyEndMin']);
							}
							else
							{
								Ext.getCmp('complscroll').setValue(modifiedvalue['DisplayPeriod']);
							}

						Ext.getCmp('from').setValue(modifiedvalue['StartDate']);
						Ext.getCmp('to').setValue(modifiedvalue['EndDate']);
						
						var dispPeakHours='-';
						var dispWeekDays='-';
						var excludeDispWeekEnds='-';

						dispPeakHours = modifiedvalue['PeakHours'];
						dispWeekDays = modifiedvalue['WeekDays'];
						excludeDispWeekEnds = modifiedvalue['ExcludeWeekEnds'];

						if(dispPeakHours!='None' ||dispWeekDays!= 'None'||excludeDispWeekEnds!='None')
						{
							var value = {operating : 'specific'};
							Ext.getCmp('operatingh').setValue(value);
							showConfigData=true;
							Ext.getCmp('tablecont').show();
						}
						else
						{
							var value = {operating : 'always'};
							Ext.getCmp('operatingh').setValue(value);
							Ext.getCmp('tablecont').hide();
							qryStr='';
							
						}
						
						var stHrMs = dispPeakHours.substring(0,dispPeakHours.indexOf('-'));
						
						var starthour = stHrMs.substring(0,stHrMs.indexOf(':'));
					
						var starmin = stHrMs.substring(stHrMs.indexOf(':')+1,stHrMs.length);
						
						
						var endHrMs = dispPeakHours.substring(dispPeakHours.indexOf('-')+1,dispPeakHours.length);
						
						var endhour = endHrMs.substring(0,endHrMs.indexOf(':'));
						
						
						var endmin = endHrMs.substring(endHrMs.indexOf(':')+1,endHrMs.length);
						
						if(dispPeakHours!='None' ||dispWeekDays!= 'None'||excludeDispWeekEnds!='None')
						{
						qryStr='&start_hours='+starthour+'&start_minutes='+starmin+'&end_hours='+endhour+'&end_minutes='+endmin+'&WeekDays='+dispWeekDays+'&ExcludeWeekEnds='+excludeDispWeekEnds;
						}
					
						var selectedOperatingPeriod = Ext.getCmp('operatingh').getValue().operating;
						
						if(selectedOperatingPeriod=="specific")
						{
							if(dispPeakHours!='None' ||dispWeekDays!= 'None'||excludeDispWeekEnds!='None')
							{
							if( qryStr.indexOf('start_hours') > -1 )
							{
								qryStr=qryStr.replace(/(start_hours=)[^\&]+/, '$1' + starthour);
							}
							else
							{
								qryStr+='&start_hours='+starthour;
							}
							if( qryStr.indexOf('start_minutes') > -1 )
							{

								qryStr=qryStr.replace(/(start_minutes=)[^\&]+/, '$1' + starmin);
							}
							else
							{								
								qryStr+='&start_minutes='+starmin;
							}
							if( qryStr.indexOf('end_hours') > -1 )
							{

								qryStr=qryStr.replace(/(end_hours=)[^\&]+/, '$1' + endhour);
							}
							else
							{								
								qryStr+='&end_hours='+endhour;
							}
							if( qryStr.indexOf('end_minutes') > -1 )
							{

								qryStr=qryStr.replace(/(end_minutes=)[^\&]+/, '$1' + endmin);
							}
							else
							{								
								qryStr+='&end_minutes='+endmin;
							}

							if( qryStr.indexOf('WeekDays') > -1 )
							{

								qryStr=qryStr.replace(/(WeekDays=)[^\&]+/, '$1' + dispWeekDays);
							}
							else
							{								
								qryStr+='&WeekDays='+dispWeekDays;
							}
							if( qryStr.indexOf('ExcludeWeekEnds') > -1 )
							{

								qryStr=qryStr.replace(/(ExcludeWeekEnds=)[^\&]+/, '$1' + excludeDispWeekEnds);
							}
							else
							{								
								qryStr+='&ExcludeWeekEnds='+excludeDispWeekEnds;
							}
							}
						}
						}

						if(dispPeakHours!='None' ||dispWeekDays!= 'None'||excludeDispWeekEnds!='None')
						{
							/*timeFilterTableData="<table border='0' cellspacing='0' cellpadding='4' width='90%' class='tableborder_ad'><col width='18%'><col width='2%'><col width='80%'><tr><td colspan='3' align='center' class='tdborder_ad2 eg_75bold'><egui:intnl text='admin.sla.Configured Specific Periods'/></td></tr>";
							if ( dispPeakHours != null && dispPeakHours != "-")
							{
							timeFilterTableData+="<tr><td class='tdborder_ad' nowrap>"+peakhours+"</td><td class='tdborder_ad'> : </td><td class='tdborder_ad'>"+dispPeakHours+"</td></tr>";
							}
							if ( dispWeekDays != null && dispWeekDays != "-" )
							{
							timeFilterTableData+="<tr><td class='tdborder_ad' nowrap>"+peakweekdays+"</td><td class='tdborder_ad'> : </td><td class='tdborder_ad'>"+dispWeekDays+"</td></tr>";
							}
							if ( excludeDispWeekEnds != null && excludeDispWeekEnds != "-" )
							{
							timeFilterTableData+="<tr><td class='tdborder_ad' nowrap>"+Exweekends+"</td><td class='tdborder_ad'> : </td><td class='tdborder_ad'>"+excludeDispWeekEnds+"</td></tr>";
							}
							timeFilterTableData+="</table>";*/
							if ( dispPeakHours != null && dispPeakHours != "-")
							{
								timeFilterTableData="Operating hrs - ";
							}
							
							if(dispWeekDays != null && dispWeekDays != "-" && dispWeekDays != "None")
							{
								timeFilterTableData+=dispWeekDays;
							}
							else{
								timeFilterTableData+="All Days";
							}
							if ( dispPeakHours != null && dispPeakHours != "-")
							{
								timeFilterTableData+="("+dispPeakHours+' Hrs)</div>';
							}

							Ext.getCmp('loadtable').update(timeFilterTableData);
						}
						
						var isSlaContinuous = modifiedvalue['isSlaContinuous'];
						if(isSlaContinuous.toLowerCase()=='yes')
						{
							var val = {exp : 'no'};
							Ext.getCmp('radioexp').setValue(val);
							Ext.getCmp('tocontainer').hide();
						}
						else if(isSlaContinuous.toLowerCase()=='no')
						{
							var val = {exp : 'yes'};
							Ext.getCmp('radioexp').setValue(val);
						}

						var ignoreMainPer = modifiedvalue['IgnoreMaintenancePeriod'];
						
					
						if(ignoreMainPer.toLowerCase()=='yes')
						{
							var val = {maint : 'yes'};
							Ext.getCmp('ignoremaint').setValue(val);
						}
						else if(ignoreMainPer.toLowerCase()=='no')
						{
							var val = {maint : 'no'};
							Ext.getCmp('ignoremaint').setValue(val);
						}
				}
			});
			}
		else if(selloption=='SLA Association')
		{
			Ext.getCmp('viewport').removeAll();
			Ext.getCmp('viewport').add({xtype: 'slaAddSecond'});
			Ext.getCmp('finish').hide();
			Ext.getCmp('finishmodify').show();
			Ext.getCmp('refine').setDisabled(false);
			Ext.getCmp('Slas').hide();
			Ext.getCmp('SlaSecNamelabel').show();
			Ext.getCmp('SlaSecNamelabel').setValue(sellslaName);
			Ext.getCmp('compliance').hide();
			Ext.getCmp('operatingh').hide();
			Ext.getCmp('contractperiod').hide();
			Ext.getCmp('dslaexp').hide();
			Ext.getCmp('tocontainer').hide();
			Ext.getCmp('complscroll').hide();
			Ext.getCmp('ignoremaint').hide();
			Ext.getCmp('secUpdate').hide();
			Ext.getCmp('Associate').show();
			Ext.getCmp('adminSecMsg').update(descriptor4);
			Ext.getCmp('secback').show();

			Ext.Ajax.request({
			url: '/final/admin/EgSLAConfiguration/data/egConfigSLAJSON.jsp?sla_name='+sellslaName+'isNewSLA=true&flag=create',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var publicJSON = Ext.decode( jsonText );
					
					Ext.getCmp('assignmore').setText(publicJSON['screenLabels']['Assign More']);
					Ext.getCmp('finish').setText(publicJSON['screenLabels']['Finish']);
					Ext.getCmp('refine').setText(publicJSON['screenLabels']['Refine']);

					Ext.getCmp('applyto').getStore().suspendEvents(true);
					Ext.getCmp('applyto').getStore().loadRawData(publicJSON['applyscroll']);
					Ext.getCmp('applyto').getStore().resumeEvents();
					Ext.getCmp('applyto').setValue(Zone);
				}
			}
			});
			
			Ext.Ajax.request({
				url: '/final/admin/EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=selectboxes&sla_name='+sellslaName+'&infraType=Zone&flag=false',
				method: 'GET',			
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						
						var publicJSON = Ext.decode( jsonText );
						
						
						Ext.getCmp('itemsel').getStore().loadRawData(publicJSON['itemselector']);
						Ext.getCmp('itemsel').setValue(publicJSON['assignItemSel']);
					}
				}
				});
			
				Ext.Ajax.request({
				url: '/final/admin/EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=associateelement&sla_name='+sellslaName,
				method: 'GET',			
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						//alert(jsonText);
						var publicJSON = Ext.decode( jsonText );
						Ext.getCmp('assignmoregrid').getStore().suspendEvents(true);
						Ext.getCmp('assignmoregrid').getStore().loadData(publicJSON['associated']);
						Ext.getCmp('assignmoregrid').getStore().resumeEvents();
					}
				}
				});
		}
	},
	
	checkboxClick : function(obj,newValue,oldValue,eOpts)
	{
		var url ='';
		var showAssociated = obj.getValue();
		if (showAssociated == true)
		{
			showAssociatedElementsVal = true;
			url = '/final/admin/EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=InfraElements&infraType=ComponentType&showassociate='+showAssociatedElementsVal+'&sla_name='+sellslaName+'&flag=false&showassociate=true';
		}
		else
		{
			showAssociatedElementsVal = false;
			url = '/final/admin/EgSLAConfiguration/data/egConfigSLApJSON.jsp?param=InfraElements&infraType=ComponentType&showassociate='+showAssociatedElementsVal+'&sla_name='+sellslaName+'&flag=false&showassociate=true';
		}
		Ext.Ajax.request({
			url: url,
			method: 'GET',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					
					var publicJSON = Ext.decode( jsonText );
					Ext.getCmp('Compon').getStore().loadRawData(publicJSON['compArr']);
					Ext.getCmp('Compon').setValue('-1');
					
				}
			}
		});
	},

	updateRule: function()
	{
		result ='';
		temprulename ='';
		addslaupdate.splice(0, addslaupdate.length);
		var SLAname = sellslaName;
		var gridval = Ext.getCmp('metricsgrid').store.data.items;
		
		for(var i=0;i<gridval.length;i++)
		{
			var gridvall = gridval[i].data.hiddenVal;
			addslaupdate.push(gridvall);
		}
		
		if(addslaupdate.length==0)
		{
			
			addslaupdate.splice(0, addslaupdate.length);
			result ='';
			Ext.Msg.show({
					title:alert15,
					msg: alert6+'.',
					buttons: Ext.Msg.OK,
					width: 400,
					icon: 'iconExclamation'
					});
			return;
		}
		
		

		for (var i = 0; i < addslaupdate.length; i++) 
		{
			var hiddval = addslaupdate[i].split('~$~');
			var rule = hiddval[0];
			var testMeas = hiddval[1];
			var cond = hiddval[2];
			var exepctedVal = hiddval[3];
			var weightval = hiddval[4];
				
			if(rule=='')
			{
			addslaupdate.splice(0, addslaupdate.length);
			result ='';
			Ext.Msg.show({
					title: alert15,
					msg: alert7+'.',
					buttons: Ext.Msg.OK,
					width: 400,
					icon: 'iconExclamation'
					});
			return;
			}

			else if(exepctedVal==""||exepctedVal==" " ||exepctedVal=="none")
			{
			addslaupdate.splice(0, addslaupdate.length);
			result ='';
			Ext.Msg.show({
					title: alert15,
					msg: alert8+'.',
					buttons: Ext.Msg.OK,
					width: 400,
					icon: 'iconExclamation'
					});
			return;
			}

			else if((checkspace(exepctedVal)==false))
			{
				addslaupdate.splice(0, addslaupdate.length);
				result ='';
				Ext.Msg.show({
						title: alert15,
						msg: alert9+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}

			else if((SpecialCharacterValidation(exepctedVal)==false))
			{
				addslaupdate.splice(0, addslaupdate.length);
				result ='';
				Ext.Msg.show({
						title: alert15,
						msg: alert10+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}

			else if(isNumber(exepctedVal)==false)
			{
				addslaupdate.splice(0, addslaupdate.length);
				result ='';
				return;
			}

		if(testMeas!=null && cond!=null && exepctedVal!= 'none' && rule!=null && weightval!=null)
		{
			if(rule=="")
			{
				addslaupdate.splice(0, addslaupdate.length);
				result ='';
				Ext.Msg.show({
						title: alert15,
						msg: alert7+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}

			else if(exepctedVal==""||exepctedVal==" " ||exepctedVal==null)
			{
				addslaupdate.splice(0, addslaupdate.length);
				result ='';
				Ext.Msg.show({
						title:alert15,
						msg: alert8+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}

			else if((checkspace(exepctedVal)==false))
			{
				addslaupdate.splice(0, addslaupdate.length);
				result ='';
				Ext.Msg.show({
						title: alert15,
						msg: alert9+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}
			else if((SpecialCharacterValidation(exepctedVal)==false))
			{
				addslaupdate.splice(0, addslaupdate.length);
				result ='';
				Ext.Msg.show({
						title: alert15,
						msg: alert10+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}
			else if(isNumber(exepctedVal)==false)
			{
				addslaupdate.splice(0, addslaupdate.length);
				result ='';
				Ext.getCmp('exv').focus();
				return;
			}
			


			else if((SpecialCharacterValidation(weightval)==false))
			{
				addslaupdate.splice(0, addslaupdate.length);
				result ='';
				Ext.Msg.show({
						title: alert15,
						msg: alert10+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}
			else if(isNumber(weightval)==false)
			{
				addslaupdate.splice(0, addslaupdate.length);
				result ='';
				return;
			}
			else if(weightval==0)
			{
				result ='';
				addslaupdate.splice(0, addslaupdate.length);
				Ext.Msg.show({
						title: alert15,
						msg: alert11+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}

			else if(weightval==""||weightval==" " ||weightval==null)
			{
				result ='';
				addslaupdate.splice(0, addslaupdate.length);
				Ext.Msg.show({
						title: alert15,
						msg: alert27+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
			}

			if(temprulename!=null && !Ext.isEmpty(temprulename))
			{
				var existtemprule=temprulename.split(",");
				
				for(var a=0;a<existtemprule.length;a++)
				{
					var per = false;
					var existrule=existtemprule[a];
					
				
					if(existrule.trim()==rule.trim())
					{
						addslaupdate.splice(0, addslaupdate.length);
						result ='';
						Ext.Msg.show({
						title: alert15,
						msg: exrulename+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
						return;
					}
				}
			}
			temprulename+=rule+',';
			var tempvar = rule+"|"+testMeas+"|"+cond+":"+exepctedVal+"|W:"+weightval;
			result+=tempvar+",";
		}
		}

		result = result.substring(0, result.lastIndexOf(","));

		

		Ext.Ajax.request({
				url: '/final/admin/EgSLAConfiguration/data/egSaveSLAConfigJSON.jsp?param=saveSLARulesModification&sla_name='+SLAname+'&rulesValues='+encodeURIComponent(result),
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var publicJSON = Ext.decode( jsonText );
						var isUpdated = publicJSON['updaterule'];	
							
					if(isUpdated == true)
					{
							Ext.Msg.show({
										title : alert15,
										msg : alert15+" "+"'"+SLAname+"'"+" "+alert17+'.',
										icon: 'iconExclamation',
										buttons : Ext.Msg.OK,
										fn: function (buttonId){
										if (buttonId == "ok") {
											Ext.getCmp('viewport').removeAll();
											Ext.getCmp('viewport').add({xtype: 'slaList'});
										}
										}
									});
					}
					else
					{
							Ext.Msg.show({
										title : alert15,
										msg : alert15+" "+SLAname+" "+alert18+'.' ,
										icon: 'iconExclamation',
										buttons : Ext.Msg.OK
									});
					}
					}
				}
			});
			
	},

	updateAttributes: function()
	{
		var selectedTimePeriod="";
		var anyPeriodStartDateVal='';
		var displayPeriodStartHrVal='';
		var displayPeriodStartMinVal='';
		var anyPeriodEndDateVal='';
		var displayPeriodEndHrVal='';
		var displayPeriodEndMinVal='';
		var ignoreMainPeriod="";
		var nearingCompliance=5;

		var SLAname = sellslaName;
		var expectedCompliance=Ext.getCmp('compliance').getValue();
		var selectedOperatingPeriod = Ext.getCmp('operatingh').getValue().operating;
		var issla=Ext.getCmp('radioexp').getValue().exp;
		var fromValue = Ext.getCmp('from').getValue();
		
		fromValue = formatDate(fromValue, 'MM/dd/yyyy');
		var startDate=fromValue;
		
		var hrs=Ext.getCmp('sthrs').getValue();
		var min=Ext.getCmp('stmins').getValue();

		if(issla =='yes')
		{
		var toValue = Ext.getCmp('to').getValue();
		
		toValue = formatDate(toValue, 'MM/dd/yyyy');
		
		var endDate=toValue;
		}
		else
		{
			endDate='';
		}

		var ehours=Ext.getCmp('endhrs').getValue();
		var emins=Ext.getCmp('endmins').getValue();
		var anyfromValue = Ext.getCmp('anyfrom').getValue();
		
		anyfromValue = formatDate(anyfromValue, 'MM/dd/yyyy');
		
		var anyPeriodStartDateVal=anyfromValue;

		var displayPeriodStartHrVal= Ext.getCmp('anySthrs').getValue();

		var displayPeriodStartMinVal= Ext.getCmp('anyStmin').getValue();
		
		var anytoValue = Ext.getCmp('anyto').getValue();
		
		anytoValue = formatDate(anytoValue, 'MM/dd/yyyy');
		
		var anyPeriodEndDateVal=anytoValue;
		
		var displayPeriodEndHrVal= Ext.getCmp('anyEndhrs').getValue();

		var displayPeriodEndMinVal= Ext.getCmp('anyEndmin').getValue();
		

		var issla=Ext.getCmp('radioexp').getValue().exp;
		
		if(issla=='yes')
		{
			var isSLAContinous=false;
		}
		else
		{
			var isSLAContinous=true;
		}
		var displayPeriodVal = Ext.getCmp('complscroll').getValue();
		var mainperiod=Ext.getCmp('ignoremaint').getValue().maint;
		
		if(expectedCompliance=="" ||expectedCompliance=="" ||expectedCompliance=="null")
		{
			Ext.Msg.show({
						title: alert15,
						msg: expCempt+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
			compliance.focus();
			return;
		}
		else if(expectedCompliance==0)
		{
			Ext.Msg.show({
						title:alert15,
						msg: cannotbeZ+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
			compliance.focus();
			return;
		}
		else if(expectedCompliance<0)
		{
			Ext.Msg.show({
						title: alert15,
						msg: lessthanZ+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
			compliance.focus();
			return;
		}
		else if(expectedCompliance>100)
		{
			Ext.Msg.show({
						title: alert15,
						msg: lessthanHund+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
			compliance.focus();
			return;
			
		}
		else if(isNumber(expectedCompliance)==false)
		{
			compliance.focus();
			return;
		}

		upURL = '/final/admin/EgSLAConfiguration/data/egSaveSLAConfigJSON.jsp?param=saveSLAAttributesModification&sla_name='+SLAname+'&expectedComplaince='+expectedCompliance+'&complaince_duration='+selectedTimePeriod+'&displayPeriod='+displayPeriodVal+'&anyPeriodStartDate='+anyPeriodStartDateVal+'&anyPeriodStartHour='+displayPeriodStartHrVal+'&anyPeriodStartMin='+displayPeriodStartMinVal+'&anyPeriodEndDate='+anyPeriodEndDateVal+'&anyPeriodEndHour='+displayPeriodEndHrVal+'&anyPeriodEndMin='+displayPeriodEndMinVal+'&startDate='+startDate+'&hrs='+hrs+'&min='+min+'&enddate='+endDate+'&endhours='+ehours+'&endmins='+emins+'&issla='+issla+'&ignoreMainPeriod='+mainperiod+'&selectedOperatingPeriod='+selectedOperatingPeriod+'&nearingCompliance='+nearingCompliance;
		
		
		if(selectedOperatingPeriod=="specific")
			{
			
			if(isloadSlaTable)
				{
					isloadSlaTable=false;
				
					if(qryStr==null || Ext.isEmpty(qryStr) || qryStr==undefined)
					{
						Ext.Msg.show({
								title: alert15,
								msg: confPeriod+'.',
								buttons: Ext.Msg.OK,
								width: 400,
								icon: 'iconExclamation'
								});
						return;
					}
					else
					{
						upURL+=qryStr;
						upURL+='&modifySpecificPeriods=true';
						
					}
				}
				else
				{
					if(qryStr==null || Ext.isEmpty(qryStr) || qryStr==undefined)
					{
						Ext.Msg.show({
								title: alert15,
								msg: confPeriod+'.',
								buttons: Ext.Msg.OK,
								width: 400,
								icon: 'iconExclamation'
								});
						return;
					}
					else
					{
						upURL+=qryStr;
						upURL+='&modifySpecificPeriods=true';
						
					}
				}
			}

		var sDate=startDate+" "+hrs+":"+min;
		var eDate=endDate+" "+ehours+":"+emins;
		
		if(issla =='yes')
		{

		if(new Date(sDate).getTime()>=new Date(eDate).getTime())
		{
			Ext.Msg.show({
						title: alert15,
						msg: startDlessE+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
		}
		}

		if(displayPeriodVal =='Any')
		{
		var tempDisplayPeriodStartDateVal = getDateFromFormat(anyPeriodStartDateVal,'MM/dd/yyyy');
		var convertDateOfStartVal = new Date(tempDisplayPeriodStartDateVal);
		convertDateOfStartVal.setHours( displayPeriodStartHrVal );
		convertDateOfStartVal.setMinutes( displayPeriodStartMinVal );
		convertDateOfStartVal.setSeconds( 0 );

		var tempDisplayPeriodEndDateVal = getDateFromFormat(anyPeriodEndDateVal,'MM/dd/yyyy');
		var convertDateOfEndVal = new Date(tempDisplayPeriodEndDateVal);
		convertDateOfEndVal.setHours( displayPeriodEndHrVal );
		convertDateOfEndVal.setMinutes( displayPeriodEndMinVal );
		convertDateOfEndVal.setSeconds( 0 );
		
		if ( convertDateOfStartVal.getTime() >  convertDateOfEndVal.getTime() )
		{
			Ext.Msg.show({
						title: alert15,
						msg: stLessTIM+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
		}

		if ( convertDateOfStartVal.getTime() < new Date(sDate).getTime() )
		{
			Ext.Msg.show({
						title: alert15,
						msg: stDSlaStD+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
		}
		
		if ( !isSLAContinous && convertDateOfEndVal.getTime() > new Date(eDate).getTime())
		{
			Ext.Msg.show({
						title: alert15,
						msg: endDlessSlaEndD+'.',
						buttons: Ext.Msg.OK,
						width: 400,
						icon: 'iconExclamation'
						});
				return;
		}
		}

		Ext.Ajax.request({
				url: upURL,
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						
						var publicJSON = Ext.decode( jsonText );
								var isUpdated = publicJSON['updateattribute'];	
					if(isUpdated == true)
					{
					Ext.Msg.show({
										title : alert15,
										msg : alert15+" "+"'"+SLAname+"'"+" "+alert17+'.',
										icon: 'iconExclamation',
										buttons : Ext.Msg.OK,
										fn: function (buttonId){
										if (buttonId == "ok") {
											Ext.getCmp('viewport').removeAll();
											Ext.getCmp('viewport').add({xtype: 'slaList'});
										}
										}
									});
					}
					else
						{
									Ext.Msg.show({
										title : alert15,
										msg : alert15+" "+SLAname+" "+alert18 +'.',
										icon: 'iconExclamation',
										buttons : Ext.Msg.OK
									});
								}
					}
				}
			});
	},

	finishAssociation: function()
	{
		var selectedInfraType =Ext.getCmp('applyto').getValue();
		var selectedInfraElement =Ext.getCmp('Compon').getValue();
		var associatedElements=new Array();
		var disAssociatedElements=new Array();
		associatedElements = Ext.getCmp('itemsel').getValue();
		var noOfAssociatedServers = associatedElements.length;
		var url ='';
		var SLANAME ='';

		var Arr = new Array();
		for (var i = 0; i < Ext.getCmp('itemsel').getStore().getCount(); i++) 
			{
				var isData = false;
				var allValue = Ext.getCmp('itemsel').getStore().getAt(i).get('valueField');
				for (var j = 0; j < associatedElements.length; j++) {
				if (allValue == associatedElements[j]) {
				isData = true;
				break;
				}
				}
				if (!isData) {
				Arr[Arr.length] = allValue;
				}
			}
			
		disAssociatedElements = Arr;

		if(isModify)
		{
			url ='/final/admin/EgSLAConfiguration/data/egSaveSLAConfigJSON.jsp?param=saveSLAAssignModification&sla_name='+sellslaName+'&associatedElements='+associatedElements+'&disAssociatedElements='+disAssociatedElements+'&infraType='+selectedInfraType+'&infraElement='+selectedInfraElement+'&finish=true';
			SLANAME = sellslaName;
		}

			if((selectedInfraType!=null && selectedInfraType=="ComponentType") && (selectedInfraElement!=null && selectedInfraElement=="" || selectedInfraElement=="-1"))
			{
				Ext.Msg.show({
							title: alert15,
							msg: sellcompT+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
					return;
			}
			
		if(!isModify)
		{
			if ( noOfAssociatedServers == 0 )
			{
				Ext.Msg.show({
							title: alert15,
							msg: assocElemNull+'.',
							buttons: Ext.Msg.OK,
							width: 400,
							icon: 'iconExclamation'
							});
					return;
			}
		}
		
		Ext.Ajax.request({
				url: url,
				method: 'GET',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var publicJSON = Ext.decode( jsonText );
						var isfinishedasso = publicJSON['associationfinish'];
					if(isfinishedasso == true)
					{
					Ext.Msg.show({
									title :alert15,
									msg : alert15+" "+"'"+sellslaName+"'"+" "+alert17+'.',
									icon: 'iconExclamation',
									buttons : Ext.Msg.OK,
									fn: function (buttonId){
									if (buttonId == "ok") {
									Ext.getCmp('viewport').removeAll();
									Ext.getCmp('viewport').add({xtype: 'slaList'});
									}
									}
								});
					}
					else
						{
								Ext.Msg.show({
									title : alert15,
									msg : alert15+" "+sellslaName+" "+alert18+'.' ,
									icon: 'iconExclamation',
									buttons : Ext.Msg.OK
								});
						}
					}
				}
				});
	}

});