var mySelectionModel = Ext.create('Ext.selection.CheckboxModel', {
	selType: 'checkboxmodel',
	mode: 'MULTI',
	checkOnly: true,
	renderer : function(val, meta, record, rowIndex, colIndex, store,view){
		if( record.get('isDisabled')=='true')
		{
			//meta.tdCls = Ext.baseCSSPrefix;
			meta.tdCls = "noEllipsis";
			return '<img src="/final/images/spacer.gif" class="iconLock"  style="margin-left:-5px;width:16px;height:16px;"/>';
		}
		else
		{
			//meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
			meta.tdCls = "noEllipsis";
			return '<img src="/final/images/spacer.gif"  class="' + Ext.baseCSSPrefix + 'grid-row-checker"/>';
		}
	},
	selectAll: function(){
		var rowIndex=0;
		while(typeof(Ext.getCmp('gridDisplay').getStore().getAt(rowIndex))!='undefined') {
			var record = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);
			if (record.get('isDisabled')=='true'){
				Ext.getCmp('gridDisplay').getSelectionModel().deselect(rowIndex, true);
			}
			else {
				Ext.getCmp('gridDisplay').getSelectionModel().select(rowIndex, true);
			}
			rowIndex++;
		}
		var view = Ext.getCmp('gridDisplay').getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
			checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	},
	deselectAll: function(){
		var rowIndex=0;
		while(typeof(Ext.getCmp('gridDisplay').getStore().getAt(rowIndex))!='undefined') {
			var record = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);
			Ext.getCmp('gridDisplay').getSelectionModel().deselect(rowIndex, true);
			rowIndex++;
		}
		var view   = Ext.getCmp('gridDisplay').getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd  = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
			checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	}
});

Ext.define('sla.view.SlaList', {
	extend: 'Ext.form.Panel',
	alias: 'widget.slaList',
	id: 'slalistpage',
	cls:'outerpanel',
	requires:[
		'Ext.ux.OptGroupItemSelectorRv',
		'utilities.ScrollCombo',
		'utilities.innerScrollContainer',
		'Ext.ux.CheckColumn',
		'Ext.ux.RowExpander',
		'Ext.grid.*',
		'utilities.ScrollCombo',
		'utilities.innerScrollContainer',
		'utilities.CustomGrid'
	],
	title:slaListTitle,
	margin:'8 8 0 8',
	header:{cls:'textUpper'},
	scroll : true,
	autoScroll : true,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	fieldDefaults: {
		labelAlign: 'top',
		labelSeparator: ' '
	},
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [
		{
			xtype: 'component',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp &nbsp'+descriptor1+'</center>'
		}]
	}],
	layout : {
		type: 'vbox',
		align : 'stretch'
	},

	items: [
		{
			xtype: 'gridpanel',
			cls:'gridSkin',
			id: 'gridDisplay',
			store:new Ext.data.Store({
				fields: ['SlaNameList','view','modify','delete'],
				data: []
			}),			
			margin: 10,
			autoScroll:true,
			flex : 1,
			selModel:mySelectionModel,			
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: '<table border="0" height="350px" width="100%"><tr><td align=center vlaign=top><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+nosla+'.</div></td></tr></table>',
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: slaListTitle,
						dataIndex:'SlaNameList',
						id: 'SlaName',
						flex:1,						
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							
							return value;
						}
					},
					{
						xtype: 'actioncolumn',
						dataIndex:'view',
						width: 36,
						id: 'view',
						//iconCls: 'measureCommon',
						sortable: false,
							/*listeners: {
							headerclick: function(g, index, ev) {
								appCnt.handleViewIconClick(g, index, ev);
							}
						},*/
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='"+viewlable+"' data-qclass='yellowTip'";
							var isGroupLocked = record.get('isDisabled');
							//metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
							if (isGroupLocked == "false")
							{
								return "<div onclick=\"javascript:handleViewIconClick('"+value+"')\" class='measureCommonDisabled'></div>";

							}
							else
							{
								return "<div onclick=\"javascript:handleViewIconClick('"+value+"')\" style='cursor:pointer' class='measureCommon'></div>"; //onclick=\"javascript:appCnt.handleDeleteIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconDelete'></div>";
							}
						}
					},
					{
						xtype: 'actioncolumn',
						dataIndex:'modify',
						width: 36,
						id: 'EditOver',
						//iconCls: 'iconModify',
						sortable: false,
						/*listeners: {
							headerclick: function(g, index, ev) {
								appCnt.handleModifyIconClick(g, index, ev);
							}
						},*/
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='"+modifylable+"' data-qclass='yellowTip'";
							var isGroupLocked = record.get('isDisabled');
							//metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
							if (isGroupLocked == "false")
							{
								return "<div onclick=\"javascript:handleModifyIconClick('"+value+"')\" class='iconModifyDisabled'></div>";
							}
							else
							{
								return "<div onclick=\"javascript:handleModifyIconClick('"+value+"')\" style='cursor:pointer' class='iconModify'></div>"; //onclick=\"javascript:appCnt.handleDeleteIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconDelete'></div>";
							}
						}

					},					
					{
						header : '<div class="iconDeleteAll" data-qtip="'+deletesellable+'" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',		
						dataIndex:'delete',
						width: 36,
						id: 'DeleteOver',
						//tooltip: deletelable,
						sortable: false,
						listeners: {
							headerclick: function(g, index, ev) {
								appCnt.handleDeleteSelected(g, index, ev);
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							var isGroupLocked = record.get('isDisabled');
							metaData.tdAttr = "data-qtip='"+deletelable+"' data-qclass='yellowTip'";
							if (isGroupLocked == "false")
							{
								return "<div onclick=\"javascript:handleDeleteIconClick('"+value+"')\" class='iconDeleteDisabled'></div>";
							}
							else
							{
								return "<div onclick=\"javascript:handleDeleteIconClick('"+value+"')\" style='cursor:pointer' class='iconDelete'></div>"; 
								//onclick=\"javascript:appCnt.handleDeleteIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconDelete'></div>";
							}
						}
					}
				]
			},
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'trigger',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					name: 'gridSearch',
					//margin: '23 10 10 10',
					id: 'gridSearch',
					cls: 'whitedropdown_search',
					emptyText: 'Search',
					labelAlign: 'top',
					//width: 200,
					hidden: false,
						getTriggerMarkup: function() {
						var me = this,
							i = 0,
							hideTrigger = (me.readOnly || me.hideTrigger),
							triggerCls,
							triggerBaseCls = me.triggerBaseCls,
							triggerConfigs = [],
							unselectableCls = Ext.dom.Element.unselectableCls,
							style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
							cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}

						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click: function () {
					this.reset();
					},
					onTrigger2Click : function() {
						appCnt.textFieldSearch();
					},
					/*onTriggerClick: function () {
					//appCtn.egTitleSearch(this.getValue());
						
						}
					listeners: {
								
					specialkey: function (field, e) {
					// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN, // e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
						if (e.getKey() == e.ENTER) {
							
							//appCtn.egTitleSearch(field.getValue());
							var itemSelectorObj = Ext.getCmp('gridDisplay');
							if (Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null)) {
								var regex = RegExp(field.value, 'i');
								var elementsItems = itemSelectorObj.getStore();
								elementsItems.clearFilter(true);								
								elementsItems.filter(new Ext.util.Filter({
								caseSensitive: true,
								filterFn: function (object) {
									var items=0;
									var match = false;
									Ext.Object.each(object.data, function (property, value) {										
										if(items==0)
										{
											match = match || regex.test(String(value));
										}
										items++;
									});
									return match;
									}
									}));
									} else {
									itemSelectorObj.getStore().clearFilter();
									}
									field.focus();
							}
						}
					}*/
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					items:[
						{
							xtype: 'button',
							cls:'button20',
							text: 'Add SLA',
							id: 'addSLA',
						}
					]
				}
			]
		}]
});
