Ext.define('sla.view.SlaTimeFilter',{
	extend:'Ext.panel.Panel',
	alias:'widget.slaTimeFilter',
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	jsonData:'',
	items:[{
		xtype:'panel',
		cls:'datapanel',
		margin:10,
		title:PeakHours,
		layout:'vbox',
		defaults:{
			margin:5,
		},
		items:[{
			xtype:'container',
			layout:'hbox',
			items:[
			{
				xtype:'displayfield',
				fieldLabel:StartTime,
				labelSeparator:'',
			},{
					xtype: 'scrollcombo',
					id : 'hscroll',
					labelSeparator:'',
					width:80,
					margin:'0 5 0 0',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data: []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false
			},{
				xtype:'displayfield',
				value:Hrs,
				margin:'0 50 0 0',
			},{
					xtype: 'scrollcombo',
					labelSeparator:'',
					id : 'mscroll',
					width:80,
					margin:'0 5 0 0',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data: []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false
			},{
				xtype:'displayfield',
				value:Mins
			}]
		},{
			xtype:'container',
			layout:'hbox',
			items:[
			{
				xtype:'displayfield',
				fieldLabel:EndTime,
				labelSeparator:'',
			},{
					xtype: 'scrollcombo',
					id : 'hoscroll',
					labelSeparator:'',
					width:80,
					margin:'0 5 0 0',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data: []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false
			},{
				xtype:'displayfield',
				value:Hrs,
				margin:'0 50 0 0',
			},{
					xtype: 'scrollcombo',
					id : 'miscroll',
					labelSeparator:'',
					width:80,
					margin:'0 5 0 0',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data: []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false
			},{
				xtype:'displayfield',
				value:Mins
			}]
		}]
	},{
		xtype:'panel',
		cls:'datapanel',
		margin:10,
		title:DaysofWeek,
		layout: {
			type: 'vbox',
			align: 'stretch'
		},
		defaults:{
			margin:5,
		},
		items:[{
			xtype: 'checkboxgroup',
			id:'checkboxdays',
			columns: 4,
			defaults:{
				width:'120',
			},
			vertical: false,
			items: [
				{
					boxLabel: Monday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Monday',
					id:'Monday'
				}, {
					boxLabel: Tuesday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Tuesday',
					id:'Tuesday'
				},{
					boxLabel: Wednesday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Wednesday',
					id:'Wednesday'
				},{
					boxLabel: Thursday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Thursday',
					id:'Thursday'
				},{
					boxLabel: Friday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Friday',
					id:'Friday'
				},{
					boxLabel: Saturday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Saturday',
					id:'Saturday'
				},{
					boxLabel: Sunday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Sunday',
					id:'Sunday'
				}]
			}]
	}
	/*{
		xtype:'panel',
		cls:'datapanel',
		margin:10,
		title:ExcludeWeekEnds,
		layout: {
			type: 'vbox',
			align: 'stretch'
		},
		defaults:{
			margin:5,
		},
		items:[{
			xtype: 'checkboxgroup',
				id:'checkboxexclud',
			columns: 4,
			defaults:{
				width:'120',
			},
			vertical: false,
			items: [
				{
					boxLabel: Monday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Monday',
					id:'Monday1'
				}, {
					boxLabel: Tuesday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Tuesday',
					id:'Tuesday2'
				},{
					boxLabel: Wednesday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Wednesday',
					id:'Wednesday3'
				},{
					boxLabel: Thursday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Thursday',
					id:'Thursday4'
				},{
					boxLabel: Friday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Friday',
					id:'Friday5'
				},{
					boxLabel: Saturday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Saturday',
					id:'Saturday6'
				},{
					boxLabel: Sunday,
					name: 'rb',
					cls:'checkbt',
					inputValue: 'Sunday',
					id:'Sunday7'
				}]
			}]
	}*/,{
			xtype: 'container',
			margin:0,
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'center'
			},
			items:[{
				xtype: 'button',
				id: 'app',
				text: Apply,
				cls:'button20',
			}]
		}],
		listeners :
		{
				afterrender:function()
				{
					var json=this.jsonData;
					Ext.getCmp('hscroll').getStore().loadRawData(json['hourval']);
					Ext.getCmp('hscroll').setValue('00');
					Ext.getCmp('mscroll').getStore().loadRawData(json['minval']);
					Ext.getCmp('mscroll').setValue('00');

					Ext.getCmp('hoscroll').getStore().loadRawData(json['hourval']);
					Ext.getCmp('hoscroll').setValue('23');
					Ext.getCmp('miscroll').getStore().loadRawData(json['minval']);
					Ext.getCmp('miscroll').setValue('59');

				
				if(isModify)
				{
					Ext.Ajax.request({
						url: '/final/admin/EgSLAConfiguration/data/egConfigSLAJSON.jsp?flag=Modify SLA Attributes&sla_name='+sellslaName,
						method: 'GET',
						async: false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								var publicJSON = Ext.decode( jsonText );
								var dispPeakHours='-';
								var dispWeekDays='-';
								var excludeDispWeekEnds='-';

								var modifiedresp = publicJSON['modifyval'];
								

								dispPeakHours = modifiedresp['PeakHours'];
								dispWeekDays = modifiedresp['WeekDays'];
								excludeDispWeekEnds = modifiedresp['ExcludeWeekEnds'];
								
								
								
								if(dispPeakHours!='None' ||dispWeekDays!= 'None'||excludeDispWeekEnds!='None')
							{		
									if(dispPeakHours!='None')
								{
								var stHrMs = dispPeakHours.substring(0,dispPeakHours.indexOf('-'));
								
								var sthours = stHrMs.substring(0,stHrMs.indexOf(':'));
								
								Ext.getCmp('hscroll').setValue(sthours);
								var stmins = stHrMs.substring(stHrMs.indexOf(':')+1,stHrMs.length);
								
								Ext.getCmp('mscroll').setValue(stmins);

				

								var endHrMs = dispPeakHours.substring(dispPeakHours.indexOf('-')+1,dispPeakHours.length);
								
								var endhours = endHrMs.substring(0,endHrMs.indexOf(':'));
								
								Ext.getCmp('hoscroll').setValue(endhours);
								var endmins = endHrMs.substring(endHrMs.indexOf(':')+1,endHrMs.length);
								
								Ext.getCmp('miscroll').setValue(endmins);

								}


								var dispWdate = dispWeekDays.split(',');

								for(var i = 0; i < dispWdate.length;i++)
								{
									var days =dispWdate[i];
									
									if(days=='Monday')
									{
										Ext.getCmp('Monday').setValue(true);
									}
									else if(days=='Tuesday')
									{
										Ext.getCmp('Tuesday').setValue(true);
									}
									else if(days=='Wednesday')
									{
										Ext.getCmp('Wednesday').setValue(true);
									}
									else if(days=='Thursday')
									{
										Ext.getCmp('Thursday').setValue(true);
									}
									else if(days=='Friday')
									{
										Ext.getCmp('Friday').setValue(true);
									}
									else if(days=='Saturday')
									{
										Ext.getCmp('Saturday').setValue(true);
									}
									else if(days=='Sunday')
									{
										Ext.getCmp('Sunday').setValue(true);
									}
								}

								
								var Excludeddate = excludeDispWeekEnds.split(',');

								for(var i = 0; i < Excludeddate.length;i++)
								{
									var days =Excludeddate[i];
									
									if(days=='Monday')
									{
										Ext.getCmp('Monday1').setValue(true);
									}
									else if(days=='Tuesday')
									{
										Ext.getCmp('Tuesday2').setValue(true);
									}
									else if(days=='Wednesday')
									{
										Ext.getCmp('Wednesday3').setValue(true);
									}
									else if(days=='Thursday')
									{
										Ext.getCmp('Thursday4').setValue(true);
									}
									else if(days=='Friday')
									{
										Ext.getCmp('Friday5').setValue(true);
									}
									else if(days=='Saturday')
									{
										Ext.getCmp('Saturday6').setValue(true);
									}
									else if(days=='Sunday')
									{
										Ext.getCmp('Sunday7').setValue(true);
									}
								}
							}
							}
							
						}
							})
						
						}







				}
		}
});



