var publicRmtAgt = '';var elemList;
Ext.define('EgServerDiscovery.controller.Main',{
	extend:'Ext.app.Controller',
	views:[	'Main',
			'DiscoveryTree',
			'Mywindow',
			'EgVirualPlatforms',
			'EgDiscoveryVirtualForm',
			'EgDiscoveryCloudForm',
			'EgDiscoveryNetscalerForm',
			'EgDiscoveryCloudDirectoryForm',
			'EgDiscoveryStoragePlatformForm',
			'EgDiscoveryRabbitMQForm',
			'EgDiscoveryResultPanel',
			'ResultPanel',
			'DiscoveryDetailsGrid',
			'EgCloudPlatforms',
			'EgNetscalerPlatforms',
			'EgCloudDirectoryforms',
			'EgStoragePlatforms',
			'EgRabbitMQ',
			'EgAgentDiscoveryPanel',
			'DiscoverySettings',
			'EgDiscServersContainer',
			'ManageDiscoveredComponents',
			'EgManagerDiscoverySettings',
			'ConfigureComponentTypes',
			'EgCommonDiscoverySettings',
			'ManageServers',
			'AutoManageComponentTypes',
			'RemoteAgentsGrid',
			'EgConfigEnvFormContainer',
			'EgAutodeleteSettings',
			'EgDiscoveryReport',
			'DetailsGrid',
			'EgInfraDownloader',
			'ReportPanel',
			'Print'
	],
	refs:[
		//{ref:'treePanel',selector:'discoverytree treepanel'},
		{selector:'main', ref:'main'},
		{selector:'discoverytree', ref:'discoverytree'},
		{selector:'mywindow', ref:'mywindow'},
		{selector:'managersettingspanel', ref:'managersettingspanel'},
		{selector:'commonsettingspanel', ref:'commonsettingspanel'},
		{selector:'discoverypane', ref:'discoverypane'},
		{selector:'egdiscoveryvirtualform', ref:'egdiscoveryvirtualform'},
		{selector:'egdiscoverycloudform', ref:'egdiscoverycloudform'},
		{selector:'egdiscoverynetscalerform', ref:'egdiscoverynetscalerform'},
		{selector:'egdiscoveryclouddirectoryform', ref:'egdiscoveryclouddirectoryform'},
		{selector:'egdiscoverystorageplatformform', ref:'egdiscoverystorageplatformform'},
		{selector:'egdiscoveryrabbirmqform', ref:'egdiscoveryrabbirmqform'},
		{selector:'resultpanel', ref:'resultpanel'},
		{selector:'virtualplatform', ref:'virtualplatform'},
		{selector:'discoverydetailsgrid', ref:'discoverydetailsgrid'},
		{selector:'detailsgrid', ref:'detailsgrid'},
		{selector:'egcloudplatforms', ref:'egcloudplatforms'},
		{selector:'egnetscalerforms', ref:'egnetscalerforms'},
		{selector:'egclouddirectoryform', ref:'egclouddirectoryform'},
		{selector:'egstorageplatform', ref:'egstorageplatform'},
		{selector:'egrabbitmq', ref:'egrabbitmq'},
		{selector:'agentdiscovery', ref:'agentdiscovery'},
		{selector:'discoverysettings', ref:'discoverysettings'},
		{selector:'egdiscserverscontainer', ref:'egdiscserverscontainer'},
		{selector:'managediscoveredcomponents', ref:'managediscoveredcomponents'},
		{selector:'egnewserverlist', ref:'egnewserverlist'},
		{selector:'configurecomponenttypes', ref:'configurecomponenttypes'},
		{selector:'automanagecomponenttypes', ref:'automanagecomponenttypes'},
		{selector:'egconfigenvformcontainer', ref:'egconfigenvformcontainer'},
		{selector:'discoveryreport', ref:'discoveryreport'},
		{selector:'egconfigenvformcontainer itemselectorfield[id="componentDetails"]', ref:'componentDetailsSelector'},
		{selector:'autodeletesettingspanel', ref:'autodeletesettingspanel'},
		{selector:'reportpanel', ref:'reportpanel'}
	],
	init:function(){
		appCnt = this;
		this.buildMainData();
		this.control({
			'main':
			{
				'boxready': this.afterMainRender
			},
			'discoverypane':
			{
				'boxready': this.loadGeneralSettings
			},
			'discoverypane button[id="Submit"]':
			{
				'click': this.updateServerDetails
			},
			'discoverypane radiogroup[id="ADDiscoveryGroup"]':
			{
				'change': this.discoverUsingActiveDirectory
			},
//			'discoverypane radiogroup[id="isCredentialsConfigured"]':
//			{
//				'change': this.isCredentialsConfigured
//			},
			'discoverypane combo[id="ADdomain"]':
			{
				'select': this.populateADSite
			},
			'discoverypane combo[id="period"]':
			{
				'select':this.reDiscPeriodChange
			},
			'discoverypane combo[id="ADSite"]':
			{
				'select': this.populateADSubnet
			},
			'discoverypane multiselect[id="ADSubnet"]':
			{
				'change': this.populateIPRange
			},
			'discoverypane combo[id="snmpversion"]':
			{
				'select': this.changeSNMPVersion
			},
			'discoverypane radiogroup[id="encryptradioAdd"]':
			{
				'change': this.changeEncType
			},
			'commonsettingspanel radiogroup[id="autoManage"]':
			{
				'change': this.autoManageComponent
			},
			'discoverytree':
			{
				'afterrender': this.loadTreeData,
				'itemmouseenter':this.showToolTip,
				'itemclick':this.loadServerDiscoveryPage
			},
			'discoverytree label[id="Expand"]':
			{
				//'click':this.onExpandAllClick
			},
			'discoverytree button[id="Collapse"]':
			{
				'click':this.onCollapseAllClick
			},
			'commonsettingspanel button[id="expandSelector"]':
			{
				'click':this.showComponentSelector
			},
			'commonsettingspanel button[id="portSelector"]':
			{
				'click':this.showPortSelector
			},
			'commonsettingspanel checkboxfield[id="activePorts"]':
			{
				'change':this.showActivePortsForComponents
			},
			'virtualplatform combo[id="virtualCategory"]':
			{
				'select':this.categoryOnChange
			},
			'virtualplatform combo[id="action"]':
			{
				'select':this.actionOnChange
			},
			'virtualplatform combo[id="ssl"]':
			{
				'select':this.sslOnChange
			},
			'egdiscoveryvirtualform combo[id="ipModify"]':
			{
				'select':this.loadComboDetails
			},
			'egdiscoveryvirtualform button[id="submit"]':
			{
				'click':this.submitServerDetails
			},
			'egdiscoveryvirtualform button[id="clearVForm"]':
			{
				'click':this.clearForm
			},
			'egcloudplatforms combo[id="cloudaction"]':
			{
				'select':this.loadOnCloudAction
			},
			'egnetscalerforms combo[id="netscaleraction"]':
			{
				'select':this.loadOnNetscalerAction
			},
			'egclouddirectoryform combo[id="clouddirectoryaction"]':
			{
				'select':this.loadOnCloudDirectoryAction
			},
			'egstorageplatform combo[id="storagePlatformAction"]':
			{
				'select':this.loadOnStoragePlatformAction
			},
			'egrabbitmq combo[id="rabbitMQAction"]':
			{
				'select':this.loadOnRabbitMQAction
			},
			'egdiscoverycloudform button[id="submit"]':
			{
				'click':this.submitCloudDetails
			},
			'egdiscoverynetscalerform button[id="submitNS"]':
			{
				'click':this.submitNetscaler
			},
			'egdiscoverynetscalerform button[id="clearNS"]':
			{
				'click':this.clearNSForm
			},
			'egdiscoveryclouddirectoryform button[id="submitCD"]':
			{
				'click':this.submitCloudDirectory
			},
			'egdiscoveryclouddirectoryform button[id="clearCD"]':
			{
				'click':this.clearCloudDirectory
			},
			'egdiscoverystorageplatformform button[id="submitStoragePlatform"]':
			{
				'click':this.submitStoragePlatform
			},
			'egdiscoverystorageplatformform button[id="clearStorgePlatformForm"]':
			{
				'click':this.clearStoragePlatform
			},
			'egdiscoveryrabbirmqform button[id="submitRabbitMQ"]':
			{
				'click':this.submitRabbitMQ
			},
			'egdiscoveryrabbirmqform button[id="clearRabbitMQForm"]':
			{
				'click':this.clearRabbitMQ
			},
			'egdiscoveryvirtualform button[id="validateVC"]':
			{
				'click':this.validateVCenterDetails
			},
			'egdiscoverycloudform button[id="cloudClear"]':
			{
				'click':this.clearFormCloud
			},
			'egdiscoverycloudform combo[id="accountModify"]':
			{
				'select':this.loadCloudAccounts
			},
			'egdiscoverynetscalerform combo[id="ipModify"]':
			{
				'select':this.loadNetscalerAccounts
			},
			'egdiscoveryclouddirectoryform combo[id="ipModify"]':
			{
				'select':this.loadCloudDirectoryAccounts
			},
			'egdiscoverystorageplatformform combo[id="ipModify"]':
			{
				'select':this.loadStoragePlatformAccounts
			},
			'egdiscoveryrabbirmqform combo[id="ipModify"]':
			{
				'select':this.loadRabbitMQAccounts
			},
			'agentdiscovery':
			{
				'boxready':this.loadAgentGeneralSettings
			},
			'agentdiscovery #SendBox':
			{
				'select':this.setDepedencyList
			},
			'agentdiscovery button[id="Submit"]':
			{
				'click':this.submitAgentDetails
			},
			'configurecomponenttypes button[id="btnApply"]':
			{
				'click':this.applySeverChange
			},
			'automanagecomponenttypes button[id="btnApply"]':
			{
				'click':this.applyAutomanageSeverChange
			},
			'main button[id="btnBack"]':
			{
				'click': this.enableBackButton
			},
			'main button[id="btnConfigureApplicationSettings"]':
			{
				'click': this.configureCommonSettings
			},
			'commonsettingspanel button[id="btnUpdateAppSettings"]':
			{
				'click':this.updateAppSettings
			},
			'commonsettingspanel combo[id="discbase"]':
			{
				'select':this.discoveryIndexing
			},
			'egconfigenvformcontainer button[id="Update"]':
			{
				'click':this.updateComponentDetails
			},
			'egconfigenvformcontainer combo[id="servertypes"]':
			{
				'select':this.serverOnChange
			},
			'egconfigenvformcontainer button[id="deleteManaged"]':
			{
				'click':this.deleteManagedComponent
			},
			'egconfigenvformcontainer button[id="deleteUnManaged"]':
			{
				'click':this.deleteUnManagedComponent
			},
			'egconfigenvformcontainer itemselectorfield[id="componentDetails"]':
			{
				//'dirtychange':this.changeComponentState
			},
			'egconfigenvformcontainer checkboxfield[id="activeCompTypes"]':
			{
				'change':this.showActiveComponents
			},
			'egconfigenvformcontainer button[id="systems"]':
			{
				'click':this.loadManageBySystems
			},
			'egconfigenvformcontainer':
			{
				'afterrender': this.initServerDetails
			},
			'autodeletesettingspanel':
			{
				'afterrender': this.loadAutodeleteSettings
			},
			'autodeletesettingspanel radiogroup[id="autoDeleteRadio"]':
			{
				'change': this.autoDeleteComponent
			},
			'autodeletesettingspanel button[id="btnUpdateAutodeleteSettings"]':
			{
				'click': this.updateAutodeleteSettings
			},
			'discoveryreport':
			{
				'afterrender': this.initDiscoveredDetails
			},
			'discoveryreport combo[id="componentTypeCombo"]':
			{
				'select': this.showTypeBasedComponents
			},
			'discoveryreport combo[id="timelineCombo"]':
			{
				'select': this.showTimeline
			},
			'discoveryreport combo[id="searchByCombo"]':
			{
				'select': this.searchByComponents
			},
			'discoveryreport button[id="saveCSV"]':
			{
				'click': this.saveInCSVFormat
			},
			'discoveryreport button[id="save"]':
			{
				'click': this.savePdf
			},
			'discoveryreport button[id="print"]':
			{
				'click': this.printPage
			},
			'discoveryreport trigger[name="nickSearch"]': 
			{
				'change': this.mainGridSearch
			}
		});
	},
	buildMainData : function()
	{
		Ext.Ajax.request({
			url : appURL,
			method : 'POST',
			async : false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
//	isCredentialsConfigured : function(obj)
//	{
//		var selectedOption = obj.getValue().credential;
//		if (selectedOption == "yes")
//		{
//			Ext.getCmp('defaultCredentialsLoader').show();
//		}
//		else
//		{
//			Ext.getCmp('defaultCredentialsLoader').hide();
//		}
//	},
	setDepedencyList : function(obj)
	{
		var number = parseInt(obj.getValue());
		var numArray = new Array();
		for(var k=number ;k<=12;k++)
		{
			numArray.push({
				displayField : k+"",
				valueField : k+""
			})
		}
		Ext.getCmp('TotalBox').getStore().removeAll();
		Ext.getCmp('TotalBox').getStore().loadRawData(numArray);
		Ext.getCmp('TotalBox').setValue(Ext.getCmp('TotalBox').getStore().getAt(0).get("valueField"));
		delete number;
		delete numArray;
	},
	changeSNMPVersion : function(obj)
	{
		if (obj.getValue() == "v3")
		{
			Ext.getCmp('snmpv3Config').show();
			Ext.getCmp('snmpVersionConfig').hide();

		}
		else
		{
			Ext.getCmp('snmpv3Config').hide();
			Ext.getCmp('snmpVersionConfig').show();
		}
	},
	changeEncType : function(obj)
	{
		var selectedType = obj.getValue().encType;
		if (selectedType == "yes")
		{
			Ext.getCmp('snmpMgrEncryptTypeComboAdd').show();
			Ext.getCmp('snmpMgrEncryptPwdAdd').show();
			Ext.getCmp('snmpMgrEncryptConPwdAdd').show();
		}
		else
		{
			Ext.getCmp('snmpMgrEncryptTypeComboAdd').hide();
			Ext.getCmp('snmpMgrEncryptPwdAdd').hide();
			Ext.getCmp('snmpMgrEncryptConPwdAdd').hide();
		}
	},
	onSrvGroupChange : function(obj)
	{
		var selectedValue = obj.getValue();
		if (srvListArray.length == 0 && loadCount == 0)
		{
			var compObj = Ext.getCmp('c_types').getValue();
			srvListArray = compObj;
		}
		var tmpStore = Ext.getCmp('selectedCompDetails');
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}
		
		var url = 'EgServerDiscovery/data/EgChangePortsJson.jsp?from=commonSettings&selectedNode=node10&DiscOptions='+selectedValue+'&ServerDisplay='+srvListArray+'&LoadCount='+loadCount;
		this.updateCofigData(url);
		
		var managedServers = publicJSON['generalSettings']['discSrvrArray'];
		var unmanagedServers = publicJSON['generalSettings']['allSrvrArray'];

		tmpStore.fromField.store.add(managedServers);
		tmpStore.toField.store.add(unmanagedServers);
		loadCount++;
	},
	onAutomanageSrvGroupChange : function(obj)
	{
		var selectedValue = obj.getValue();
		if (srvListArray.length == 0 && loadCount == 0)
		{
			var compObj = Ext.getCmp('c_types2').getValue();
			srvListArray = compObj;
		}
		var tmpStore = Ext.getCmp('automanageCompDetails');
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}
		var url = 'EgServerDiscovery/data/EgChangePortsJson.jsp?from=commonSettings&selectedNode=node18&DiscOptions='+selectedValue+'&AutomanageSrvrDisplay='+srvListArray+'&LoadCount='+loadCount;
		this.updateCofigData(url);
		
		var managedServers = publicJSON['generalSettings']['automanageSrvrArray'];
		var unmanagedServers = publicJSON['generalSettings']['availSrvrArray'];

		tmpStore.fromField.store.add(managedServers);
		tmpStore.toField.store.add(unmanagedServers);
		loadCount++;
	},
	reDiscPeriodChange: function()
	{
		var discStatus = publicJSON.ManagerDiscovery;
		var comboObj = Ext.getCmp('period');
		var comboVal = comboObj.getValue();
		if (discStatus=='Disabled' && comboVal != '0')
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: "Please enable manager discovery before you attempt to change Re-discovery period",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok' || response == 'cancel') {
						comboObj.setValue('0');
					}
				}
			});			
		}
	},
	autoManageComponent : function(obj)
	{
		if (obj.getValue().autoManage == "Yes")
		{
			Ext.getCmp("discoveryPattenCt").show();
			Ext.getCmp("seletedAutomanageListGrid").show();
			this.selectAutoManageComps();
		}
		else
		{
			Ext.getCmp("discoveryPattenCt").hide();
			Ext.getCmp("seletedAutomanageListGrid").hide();
		}
	},
	applySeverChange : function()
	{
		var me = this;
		var selectedSrvList = srvListArray;
		
		if (selectedSrvList.length > 0)
		{
			Ext.getCmp('c_types').setValue(selectedSrvList);
			Ext.getCmp('c_types2').setValue(selectedSrvList);
			//me.selectAutoManageComps();
			var commonsettingspanel = this.getCommonsettingspanel().getForm();
			if (commonsettingspanel.isValid())
			{
				var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
				myMask.show();
				Ext.Ajax.request({
					url: 'EgServerDiscovery/data/EgchangeportspJson.jsp?from=configureComponentWindow&c_types='+selectedSrvList+'&date='+new Date().getTime(),
					method: 'POST',
					success: function(response){
						var resultObj =  Ext.decode(response.responseText);
						if (resultObj.requestStatus == "success")
						{
							Ext.Ajax.request({
								url : 'EgServerDiscovery/data/EgChangePortsJson.jsp?from=commonSettings&selectedNode=node10&LoadCount='+loadCount,
								success: function(response)
								{
									myMask.hide();
									publicJSON = Ext.decode(response.responseText);
									var selectedServerListGridObj = Ext.getCmp('selectedServerListGrid');
									selectedServerListGridObj.getStore().loadRawData(publicJSON['generalSettings']['configuredServersList']);
									var tmpCount = parseInt(publicJSON['generalSettings']['configuredServersCount']);
									selectedServerListGridObj.doLayout();
									selectedServerListGridObj.view.refresh();
									if (tmpCount > 24)
									{
										selectedServerListGridObj.setHeight(200);
									}
									Ext.getCmp('resultHeaderCt').show();
									isApplied = true;
									if(isSavedFromPrompt)
									{
										compSaveMask.hide();
										Ext.getCmp('configurationWindow').close();
									}
									//me.updateApplicationServerSettings("menu");
									//me.selectAutoManageComps();
								}
							});
						}
					},
					failure: function(form, action) {
						myMask.hide();
						switch (action.failureType) {
							case Ext.form.action.Action.CLIENT_INVALID:
								Ext.Msg.show({
									title: "Failure",
									msg: "Form fields may be submitted with invalid values.",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
								break;
							case Ext.form.action.Action.CONNECT_FAILURE:
								Ext.Msg.show({
									title: "Failure",
									msg: "Ajax communication failed.",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
								break;
							case Ext.form.action.Action.SERVER_INVALID:
								Ext.Msg.show({
									title: "Failure",
									msg: action.result.msg+".",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
						}
					}
				});
			}
		}
		else
		{
			Ext.MessageBox.show({
				title: pageTitle2,
				msg: intnlLabel13 + ".",
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			});
			return;
		}
	},
	applyAutomanageSeverChange : function()
	{
		var me = this;
		var selectedSrvList = srvListArray;
		if (selectedSrvList.length > 0)
		{
			Ext.getCmp('c_types2').setValue(selectedSrvList);
			var commonsettingspanel = this.getCommonsettingspanel().getForm();
			//changeSettings
			if (commonsettingspanel.isValid())
			{
				var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Saving...'});
				myMask.show();
				Ext.Ajax.request({
					url: 'EgServerDiscovery/data/EgchangeportspJson.jsp?from=configureComponentWindow2&c_types2='+selectedSrvList+'&date='+new Date().getTime(),
					method: 'POST',
					success: function(response){
						var resultObj = Ext.decode(response.responseText);
						if (resultObj.requestStatus == "success")
						{
							me.selectAutoManageComps();
							myMask.hide();
							Ext.getCmp('resultHeaderCt2').show();
							isAutomanageApplied = true;
							if(isAutomangeSavedFromPrompt)
							{
								automanageSaveMask.hide();
								Ext.getCmp('automanageWindow').close();
							}
						}
					},
					failure: function(form, action) {
						myMask.hide();
						switch (action.failureType) {
							case Ext.form.action.Action.CLIENT_INVALID:
								Ext.Msg.show({
									title: "Failure",
									msg: "Form fields may be submitted with invalid values.",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
								break;
							case Ext.form.action.Action.CONNECT_FAILURE:
								Ext.Msg.show({
									title: "Failure",
									msg: "Ajax communication failed.",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
								break;
							case Ext.form.action.Action.SERVER_INVALID:
								Ext.Msg.show({
									title: "Failure",
									msg: action.result.msg+".",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
						}
					}
				});
			}
		}
		else
		{
			Ext.MessageBox.show({
				title: pageTitle2,
				msg: intnlLabel13,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			});
			return;
		}
	},
	validateVCenterDetails : function()
	{
		var validationStatus = false;
		var validateNutanixStatus = false;
		var validateXenserverStatus = false;
		var validateOracleVMStatus = false;
		var selectedAction = this.getSeletedAction();
		if (selectedAction == "AddvCenters")
		{
			validationStatus = this.validateFormVC('add');
		}
		else if (selectedAction == "AddNutanix")
		{
			validateNutanixStatus = this.validateFormNutanix('add');
		}
		else if (selectedAction == "AddCtxXenPool")
		{
			validateXenserverStatus = this.validateCtxXenPoolForm('add');
		}
		else if (selectedAction == "ModifyCtxXenPool")
		{
			validateXenserverStatus = this.validateCtxXenPoolForm('modify');
		}
		else if(selectedAction == "ModifyNutanix")
		{
			validateNutanixStatus = this.validateFormNutanix('modify');
		}
		else if (selectedAction == "AddOracleVM")
		{
			validateOracleVMStatus = this.validateOracleVMForm('add');
		}
		else if (selectedAction == "ModifyOracleVM")
		{
			validateOracleVMStatus = this.validateOracleVMForm('modify');
		}
		else
		{
			validationStatus = this.validateFormVC('modify');
		}
		
		if (validationStatus == true)
		{
			var me = this;
			var validationLoadingMsg2 = "<table border='0' style='width:100%;height:170px;'><tr><td align='center' valign='bottom'><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center valign=top>Trying to get validation information from the agent...<br>This may take a few minutes...</td></tr></table>";
			var winObj = Ext.getCmp('validateAdServer');
			Ext.widget('window',{
				extend:'Ext.panel.Panel',
				title : validationTitle,
				listeners : {
					afterrender : function()
					{
						me.validateCredentials(validationURL);
					}
				},
				closeAction: 'destory',
				id : 'validateVcenterServer',
				align : 'center',
				width:650,
				modal: true,
				autoScroll : true,
				scroll : true,
				doClose: function() {
					this.destroy();
				},
				items : [
					{
						id : 'resultContainerStr',
						border : false,
						style:{'text-align':'center'},
						html:validationLoadingMsg2,
					},
					{
						xtype : 'container',
						id : 'agentDropList',
						padding : '40 0 130 0',
						hidden : true,
						layout : {
							type : 'hbox',
							align : 'center',
							pack : 'center',
						},
						items : [
							{
								xtype:'combo',
								id: 'agentList',
								cls: 'dropdown',
								editable :false,
								fieldLabel : validationMsg79,
								store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : []
								}),
								displayField : 'displayField',
								valueField : 'valueField',
								queryMode : 'local',
								width: 450,
								labelWidth: 280
							},
							{
								xtype :'tbspacer',
								width : 10,
							},
							{
								xtype : 'button',
								cls : 'button20',
								text : 'Go',
								handler : function()
								{
									var agentSelected = Ext.getCmp('agentList').getValue();
									if(agentSelected!=null && agentSelected == "-1")
									{
										Ext.Msg.show({
											title: pageTitle2,
											msg: _selectAgent + ".",
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
										return;
									}
									Ext.getCmp('resultContainerStr').show();
									Ext.getCmp('agentDropList').hide();
									Ext.getCmp('resultContainerStr').update(validationLoadingMsg2);
									var selectedAction = Ext.getCmp('action').getValue();
									var hostIP = "";
									if (selectedAction.toLowerCase() == "add")
									{
										hostIP = Ext.getCmp('ipAdd').getValue();
									}
									else
									{
										hostIP = Ext.getCmp('ipModify').getValue();
									}
									var paramWithValue = "-:";
									paramWithValue = paramWithValue + agentSelected;
									paramWithValue = paramWithValue + "|#|-host:"+hostIP;
									paramWithValue = paramWithValue + "|#|-virtual_center:"+hostIP;
									paramWithValue = paramWithValue + "|#|-ssl:"+Ext.getCmp('ssl').getValue();
									paramWithValue = paramWithValue + "|#|-webport:"+Ext.getCmp('webport').getValue();
									paramWithValue = paramWithValue + "|#|-esx_user:"+Ext.getCmp('uname').getValue();
									paramWithValue = paramWithValue + "|#|-esx_password:"+Ext.getCmp('pass').getValue();
									paramWithValue=filterEncode(paramWithValue);
									var uri = "EgServerDiscovery/data/validateApplicationServerCredentails.jsp?valForValidation="+encodeURIComponent(paramWithValue)+"&selectedAgent="+encodeURIComponent(agentSelected)+paramsForURLVC+"&multiUserMode=false&fromPage=descovery";
									me.validateCredentials(uri);
								}
							}
						]
					}
				]
			}).show();
		}
		if (validateNutanixStatus == true)
		{
			var me = this;
			var validationLoadingMsg2 = "<table border='0' style='width:100%;height:170px;'><tr><td align='center' valign='bottom'><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center valign=top>Trying to get validation information from the agent...<br>This may take a few minutes...</td></tr></table>";
			var winObj = Ext.getCmp('validateAdServer');
			Ext.widget('window',{
				extend:'Ext.panel.Panel',
				title : validationNutanixTitle,
				listeners : {
					afterrender : function()
					{
						me.validateCredentials(validationNutanixURL);
					}
				},
				closeAction: 'destory',
				id : 'validateVcenterServer',
				align : 'center',
				width:650,
				modal: true,
				autoScroll : true,
				scroll : true,
				doClose: function() {
					this.destroy();
				},
				items : [
					{
						id : 'resultContainerStr',
						border : false,
						style:{'text-align':'center'},
						html:validationLoadingMsg2,
					},
					{
						xtype : 'container',
						id : 'agentDropList',
						padding : '40 0 130 0',
						hidden : true,
						layout : {
							type : 'hbox',
							align : 'center',
							pack : 'center',
						},
						items : [
							{
								xtype:'combo',
								id: 'agentList',
								cls: 'dropdown',
								editable :false,
								fieldLabel : validationMsg79,
								store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : []
								}),
								displayField : 'displayField',
								valueField : 'valueField',
								queryMode : 'local',
								width: 450,
								labelWidth: 280
							},
							{
								xtype :'tbspacer',
								width : 10,
							},
							{
								xtype : 'button',
								cls : 'button20',
								text : 'Go',
								handler : function()
								{
									var agentSelected = Ext.getCmp('agentList').getValue();
									if(agentSelected!=null && agentSelected == "-1")
									{
										Ext.Msg.show({
											title: pageTitle2,
											msg: _selectAgent + ".",
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
										return;
									}
									Ext.getCmp('resultContainerStr').show();
									Ext.getCmp('agentDropList').hide();
									Ext.getCmp('resultContainerStr').update(validationLoadingMsg2);
									var selectedAction = Ext.getCmp('action').getValue();
									var hostIP = "";
									if (selectedAction.toLowerCase() == "add")
									{
										hostIP = Ext.getCmp('ipAdd').getValue();
									}
									else
									{
										hostIP = Ext.getCmp('ipModify').getValue();
									}
									var paramWithValue = "-:";
									paramWithValue = paramWithValue + agentSelected;
									paramWithValue = paramWithValue + "|#|-host:"+hostIP;
									paramWithValue = paramWithValue + "|#|-Prism_IP:"+hostIP;
									paramWithValue = paramWithValue + "|#|-ssl:"+Ext.getCmp('ssl').getValue();
									paramWithValue = paramWithValue + "|#|-webport:"+Ext.getCmp('webport').getValue();
									paramWithValue = paramWithValue + "|#|-Prism_user:"+Ext.getCmp('uname').getValue();
									paramWithValue = paramWithValue + "|#|-Prism_password:"+Ext.getCmp('pass').getValue();
									paramWithValue=filterEncode(paramWithValue);
									var uri = "EgServerDiscovery/data/validateApplicationServerCredentails.jsp?valForValidation="+encodeURIComponent(paramWithValue)+"&selectedAgent="+encodeURIComponent(agentSelected)+paramsForURLVC+"&multiUserMode=false&fromPage=descovery";
									me.validateCredentials(uri);
								}
							}
						]
					}
				]
			}).show();
		}
		if (validateXenserverStatus == true)
		{
			var me = this;
			var validationLoadingMsg2 = "<table border='0' style='width:100%;height:170px;'><tr><td align='center' valign='bottom'><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center valign=top>Trying to get validation information from the agent...<br>This may take a few minutes...</td></tr></table>";
			var winObj = Ext.getCmp('validateAdServer');
			Ext.widget('window',{
				extend:'Ext.panel.Panel',
				title : validationXenserverTitle,
				listeners : {
					afterrender : function()
					{
						me.validateCredentials(validationXenserverURL);
					}
				},
				closeAction: 'destory',
				id : 'validateVcenterServer',
				align : 'center',
				width:650,
				modal: true,
				autoScroll : true,
				scroll : true,
				doClose: function() {
					this.destroy();
				},
				items : [
					{
						id : 'resultContainerStr',
						border : false,
						style:{'text-align':'center'},
						html:validationLoadingMsg2,
					},
					{
						xtype : 'container',
						id : 'agentDropList',
						padding : '40 0 130 0',
						hidden : true,
						layout : {
							type : 'hbox',
							align : 'center',
							pack : 'center',
						},
						items : [
							{
								xtype:'combo',
								id: 'agentList',
								cls: 'dropdown',
								editable :false,
								fieldLabel : validationMsg79,
								store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : []
								}),
								displayField : 'displayField',
								valueField : 'valueField',
								queryMode : 'local',
								width: 450,
								labelWidth: 280
							},
							{
								xtype :'tbspacer',
								width : 10,
							},
							{
								xtype : 'button',
								cls : 'button20',
								text : 'Go',
								handler : function()
								{
									var agentSelected = Ext.getCmp('agentList').getValue();
									if(agentSelected!=null && agentSelected == "-1")
									{
										Ext.Msg.show({
											title: pageTitle2,
											msg: _selectAgent + ".",
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
										return;
									}
									Ext.getCmp('resultContainerStr').show();
									Ext.getCmp('agentDropList').hide();
									Ext.getCmp('resultContainerStr').update(validationLoadingMsg2);
									var selectedAction = Ext.getCmp('action').getValue();
									var hostIP = "";
									if (selectedAction.toLowerCase() == "add")
									{
										hostIP = Ext.getCmp('ipAdd').getValue();
									}
									else
									{
										hostIP = Ext.getCmp('ipModify').getValue();
									}
									var paramWithValue = "-:";
									paramWithValue = paramWithValue + agentSelected;
									paramWithValue = paramWithValue + "|#|-host:"+hostIP;
									paramWithValue = paramWithValue + "|#|-ssl:"+Ext.getCmp('ssl').getValue();
									paramWithValue = paramWithValue + "|#|-webport:"+Ext.getCmp('webport').getValue();
									paramWithValue = paramWithValue + "|#|-Xen_user:"+Ext.getCmp('uname').getValue();
									paramWithValue = paramWithValue + "|#|-Xen_password:"+Ext.getCmp('pass').getValue();
									paramWithValue=filterEncode(paramWithValue);
									var uri = "EgServerDiscovery/data/validateApplicationServerCredentails.jsp?valForValidation="+encodeURIComponent(paramWithValue)+"&selectedAgent="+encodeURIComponent(agentSelected)+paramsForURLVC+"&multiUserMode=false&fromPage=descovery";
									me.validateCredentials(uri);
								}
							}
						]
					}
				]
			}).show();
		}
		//Oracle VM Manager
		if (validateOracleVMStatus == true)
		{
			var me = this;
			var validationLoadingMsg2 = "<table border='0' style='width:100%;height:170px;'><tr><td align='center' valign='bottom'><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center valign=top>Trying to get validation information from the agent...<br>This may take a few minutes...</td></tr></table>";
			var winObj = Ext.getCmp('validateAdServer');
			Ext.widget('window',{
				extend:'Ext.panel.Panel',
				title : validationOracleVMTitle,
				listeners : {
					afterrender : function()
					{
						me.validateCredentials(validationOracleVMURL);
					}
				},
				closeAction: 'destory',
				id : 'validateVcenterServer',
				align : 'center',
				width:650,
				modal: true,
				autoScroll : true,
				scroll : true,
				doClose: function() {
					this.destroy();
				},
				items : [
					{
						id : 'resultContainerStr',
						border : false,
						style:{'text-align':'center'},
						html:validationLoadingMsg2,
					},
					{
						xtype : 'container',
						id : 'agentDropList',
						padding : '40 0 130 0',
						hidden : true,
						layout : {
							type : 'hbox',
							align : 'center',
							pack : 'center',
						},
						items : [
							{
								xtype:'combo',
								id: 'agentList',
								cls: 'dropdown',
								editable :false,
								fieldLabel : validationMsg79,
								store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : []
								}),
								displayField : 'displayField',
								valueField : 'valueField',
								queryMode : 'local',
								width: 450,
								labelWidth: 280
							},
							{
								xtype :'tbspacer',
								width : 10,
							},
							{
								xtype : 'button',
								cls : 'button20',
								text : 'Go',
								handler : function()
								{
									var agentSelected = Ext.getCmp('agentList').getValue();
									//console.log("agentSelected = "+agentSelected);
									if(agentSelected!=null && agentSelected == "-1")
									{
										Ext.Msg.show({
											title: pageTitle2,
											msg: _selectAgent + ".",
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
										return;
									}
									Ext.getCmp('resultContainerStr').show();
									Ext.getCmp('agentDropList').hide();
									Ext.getCmp('resultContainerStr').update(validationLoadingMsg2);
									var selectedAction = Ext.getCmp('action').getValue();
									var hostIP = "";
									if (selectedAction.toLowerCase() == "add")
									{
										hostIP = Ext.getCmp('ipAdd').getValue();
									}
									else
									{
										hostIP = Ext.getCmp('ipModify').getValue();
									}
									var paramWithValue = "-:";
									paramWithValue = paramWithValue + agentSelected;
									paramWithValue = paramWithValue + "|#|-host:"+hostIP;
									paramWithValue = paramWithValue + "|#|-Oracle_vm_mgr:"+hostIP;
									paramWithValue = paramWithValue + "|#|-ssl:"+Ext.getCmp('ssl').getValue();
									paramWithValue = paramWithValue + "|#|-webport:"+Ext.getCmp('webport').getValue();
									paramWithValue = paramWithValue + "|#|-Oracle_vm_mgr_user:"+Ext.getCmp('uname').getValue();
									paramWithValue = paramWithValue + "|#|-Oracle_vm_mgr_pass:"+Ext.getCmp('pass').getValue();
									paramWithValue=filterEncode(paramWithValue);
									/*paramWithValue = paramWithValue + "|#|-host:"+hostIP;
									paramWithValue = paramWithValue + "|#|-Prism_IP:"+hostIP;
									paramWithValue = paramWithValue + "|#|-ssl:"+Ext.getCmp('ssl').getValue();
									paramWithValue = paramWithValue + "|#|-webport:"+Ext.getCmp('webport').getValue();
									paramWithValue = paramWithValue + "|#|-Prism_user:"+Ext.getCmp('uname').getValue();
									paramWithValue = paramWithValue + "|#|-Prism_password:"+Ext.getCmp('pass').getValue();*/
									var uri = "EgServerDiscovery/data/validateApplicationServerCredentails.jsp?valForValidation="+encodeURIComponent(paramWithValue)+"&selectedAgent="+encodeURIComponent(agentSelected)+paramsForURLVC+"&multiUserMode=false&fromPage=descovery";
									me.validateCredentials(uri);
								}
							}
						]
					}
				]
			}).show();
		}
	},
	validateCredentials : function(url_string)
	{
		var tmpData = '';
		Ext.Ajax.request({
			url : url_string,
			method: 'POST',
			timeout : 7200000,
			success: function(response)
			{
				var tmpText = response.responseText;
				if (tmpText.indexOf("<div class=") == -1 && tmpText != "")
				{
					tmpData = Ext.decode(response.responseText);
					var agentListObj = Ext.getCmp('agentList');
					if (tmpData.isAgentsAvailable == true)
					{
						Ext.getCmp('resultContainerStr').hide();
						Ext.getCmp('resultContainerStr').update("");
						Ext.getCmp('agentDropList').show();
						agentListObj.getStore().loadRawData(tmpData.tmpListArr);
						agentListObj.setValue(agentListObj.getStore().getAt(0).get("valueField"));
						paramsForURLVC = tmpData.paramsForURL;
					}
					else
					{
						var tmpMessage = validationMsg80;
						if (tmpData.validationMessage != null && tmpData.validationMessage != 'undefined')
						{
							tmpMessage = tmpData.validationMessage;
						}
						Ext.getCmp('resultContainerStr').show();
						Ext.getCmp('agentDropList').hide();
						agentListObj.hide();
						//var html = "<table width='670' border='0' height='170px'><tr><td align=center valign=top><img src=/final/monitor/eg_images/indicator_medium.gif><div>"+tmpMessage+"</div></td></tr></table>";
						var html = "<table border='0' height='170px' align='center'><tr><td align='center' valign='top'><div class = 'iconInformation' style='margin:26% auto 0 auto;'></div><div>"+tmpMessage+"</div></td></tr></table>";
						Ext.getCmp('resultContainerStr').update(html);
					}
				}
				else
				{
					Ext.getCmp('resultContainerStr').show();
					Ext.getCmp('resultContainerStr').update(tmpText);
				}
			}
		});
	},
	clearCloudForm : function()
	{
		Ext.getCmp('accessKey').setValue("");
		Ext.getCmp('confAccessKey').setValue("");
		Ext.getCmp('secretKey').setValue("");
		Ext.getCmp('confSecretKey').setValue("");
	},
	loadCloudAccounts : function(obj)
	{
		var selectedOption = obj.getValue()
		if (selectedOption == "Choose account")
		{
			this.clearCloudForm();
			return;
		}

		var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=cloudModify&account="+encodeURIComponent(selectedOption)+"&selectedNode="+selectedNodeID;
		this.updateDiscoveryTree(url);
		var cloudAccount = publicJSON['cloudDetails']['seletedServerDetails'];
		var isDiscovery = cloudAccount.isDiscoverySelected;
		var accessKey = cloudAccount.accessKey;
		var confAccessKey = cloudAccount.confAccessKey;
		var secretKey = cloudAccount.secretKey;
		var confSecretKey = cloudAccount.confSecretKey;
		if (isDiscovery == "selected")
		{
			Ext.getCmp('isDiscovery').setValue(validationMsg15);
		}
		else
		{
			Ext.getCmp('isDiscovery').setValue("No");
		}
		Ext.getCmp("accessKey").setValue(accessKey);
		Ext.getCmp("confAccessKey").setValue(confAccessKey);
		Ext.getCmp("secretKey").setValue(secretKey);
		Ext.getCmp("confSecretKey").setValue(confSecretKey);
	},
	loadNetscalerAccounts : function()
	{
		var me = this;
		var ip = Ext.getCmp('ipModify').getValue();
		var url = 'EgServerDiscovery/data/EgNetScalerJson.jsp?from=getNetScalerDetails&netscalers='+ip;
		me.updateDiscoveryTree(url);

		if(ip != '-1')
		{
			Ext.getCmp('ssl').setValue(publicJSON['json']['ssl']);
			Ext.getCmp('isDiscovery').setValue(publicJSON['json']['discover']);
			Ext.getCmp('uname').setValue(publicJSON['json']['user']);
			Ext.getCmp('pass').setValue(publicJSON['json']['pwd']);
			Ext.getCmp('confpasswd').setValue(publicJSON['json']['pwd']);

			Ext.getCmp('$_ssl').setValue(publicJSON['json']['ssl']);
			Ext.getCmp('$_isDiscovery').setValue(publicJSON['json']['discover']);
			Ext.getCmp('$_uname').setValue(publicJSON['json']['user']);
			Ext.getCmp('$_pass').setValue(publicJSON['json']['pwd']);
		}
		else 
		{
			Ext.getCmp('ssl').setValue('Yes');
			Ext.getCmp('isDiscovery').setValue('Yes');
			Ext.getCmp('uname').setValue('');
			Ext.getCmp('pass').setValue('');
			Ext.getCmp('confpasswd').setValue('');
		}
	},
	loadCloudDirectoryAccounts : function()
	{
		var me = this;
		var ip = Ext.getCmp('ipModify').getValue();
		var url = 'EgServerDiscovery/data/EgCloudDirectoryJson.jsp?from=getvCloudDetails&vclouds='+ip;
		me.updateDiscoveryTree(url);

		if(ip != '-1')
		{
			Ext.getCmp('ssl').setValue(publicJSON['json']['ssl']);
			Ext.getCmp('isDiscovery').setValue(publicJSON['json']['discover']);
			Ext.getCmp('isVM').setValue(publicJSON['json']['vm']);
			Ext.getCmp('uname').setValue(publicJSON['json']['user']);
			Ext.getCmp('pass').setValue(publicJSON['json']['pwd']);
			Ext.getCmp('confpasswd').setValue(publicJSON['json']['pwd']);

			Ext.getCmp('$_ssl').setValue(publicJSON['json']['ssl']);
			Ext.getCmp('$_isDiscovery').setValue(publicJSON['json']['discover']);
			Ext.getCmp('$_isVM').setValue(publicJSON['json']['vm']);
			Ext.getCmp('$_uname').setValue(publicJSON['json']['user']);
			Ext.getCmp('$_pass').setValue(publicJSON['json']['pwd']);
		}
		else 
		{
			Ext.getCmp('ssl').setValue('Yes');
			Ext.getCmp('isDiscovery').setValue('Yes');
			Ext.getCmp('isVM').setValue('Yes');
			Ext.getCmp('uname').setValue('');
			Ext.getCmp('pass').setValue('');
			Ext.getCmp('confpasswd').setValue('');
		}
	},
	loadStoragePlatformAccounts : function()
	{
		var me = this;
		var ip = Ext.getCmp('ipModify').getValue();
		var url = 'EgServerDiscovery/data/EgStoragePlatformJson.jsp?from=getStoragePlatformDetails&xms='+ip;
		me.updateDiscoveryTree(url);

		if(ip != '-1')
		{
			Ext.getCmp('ssl').setValue(publicJSON['json']['ssl']);
			Ext.getCmp('isDiscovery').setValue(publicJSON['json']['discover']);
			Ext.getCmp('uname').setValue(publicJSON['json']['user']);
			Ext.getCmp('pass').setValue(publicJSON['json']['pwd']);
			Ext.getCmp('confpasswd').setValue(publicJSON['json']['pwd']);

			Ext.getCmp('$_ssl').setValue(publicJSON['json']['ssl']);
			Ext.getCmp('$_isDiscovery').setValue(publicJSON['json']['discover']);
			Ext.getCmp('$_uname').setValue(publicJSON['json']['user']);
			Ext.getCmp('$_pass').setValue(publicJSON['json']['pwd']);
		}
		else 
		{
			Ext.getCmp('ssl').setValue('Yes');
			Ext.getCmp('isDiscovery').setValue('Yes');
			Ext.getCmp('uname').setValue('');
			Ext.getCmp('pass').setValue('');
			Ext.getCmp('confpasswd').setValue('');
		}
	},
	loadRabbitMQAccounts : function()
	{
		var me = this;
		var ip = Ext.getCmp('ipModify').getValue();
		var url = 'EgServerDiscovery/data/EgRabbitMQNodeJson.jsp?from=getRabbitMQDetails&rabbitMQ='+ip;
		me.updateDiscoveryTree(url);

		if(ip != '-1')
		{
			Ext.getCmp('ssl').setValue(publicJSON['json']['ssl']);
			Ext.getCmp('webport').setValue(publicJSON['json']['webport']);
			Ext.getCmp('isDiscovery').setValue(publicJSON['json']['discover']);
			Ext.getCmp('uname').setValue(publicJSON['json']['user']);
			Ext.getCmp('pass').setValue(publicJSON['json']['pwd']);
			Ext.getCmp('confpasswd').setValue(publicJSON['json']['pwd']);

			Ext.getCmp('$_ssl').setValue(publicJSON['json']['ssl']);
			Ext.getCmp('$_isDiscovery').setValue(publicJSON['json']['discover']);
			Ext.getCmp('$_uname').setValue(publicJSON['json']['user']);
			Ext.getCmp('$_pass').setValue(publicJSON['json']['pwd']);
		}
		else 
		{
			Ext.getCmp('ssl').setValue('Yes');
			Ext.getCmp('webport').setValue('443');
			Ext.getCmp('isDiscovery').setValue('Yes');
			Ext.getCmp('uname').setValue('');
			Ext.getCmp('pass').setValue('');
			Ext.getCmp('confpasswd').setValue('');
		}
	},
	loadOnCloudAction : function(obj)
	{
		var selectedAction = obj.getValue();
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		if (selectedAction == "ADDCLOUD")
		{
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoverycloudform',
					id: 'cloud',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('accountAdd').show();
				Ext.getCmp('accountModify').hide();

				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				var cloudLabels = publicJSON['cloudLabels'];
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
				me.setIntnlLabels(cloudLabels);
			}
		}
		else if (selectedAction == "MODIFYCLOUD")
		{
			var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=cloudModify&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoverycloudform',
					id: 'cloud',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('accountAdd').hide();
				Ext.getCmp('accountModify').show();

				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);

				var clouds = publicJSON['cloudDetails']['cloudServers'];
				if (!Ext.isEmpty(clouds))
				{
					var cloudLabels = publicJSON['cloudLabels'];
					Ext.getCmp('accountModify').getStore().loadRawData(clouds);
					var seletedObj = Ext.getCmp('accountModify').getStore().getAt(0).get('valueField');
					Ext.getCmp('accountModify').setValue(seletedObj);
					me.setIntnlLabels(cloudLabels);
				}
				else
				{
					var emptyMessage = publicJSON['emptyMessage'];
					me.updateResultPaanel(emptyMessage);
				}
			}
		}
		else if (selectedAction == "VIEWCLOUD")
		{
			//Ext.getCmp('selectedServerCategory').setValue(selectedAction);
			var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=cloudView&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			var cloudServers = publicJSON['cloudDetails']['cloudServers'];
			resultPanelObj.show();
			resultPanelObj.removeAll();
			if (!Ext.isEmpty(cloudServers))
			{
				var cols = publicJSON['cloudDetails']['columns'];
				var gridTitle = publicJSON['cloudDetails']['gridTitle'];
				me.getGridPanel(cloudServers,cols,gridTitle);
			}
			else
			{
				var emptyMessage = publicJSON['emptyMessage'];
				me.updateResultPaanel(emptyMessage);
			}
		}
		else if (selectedAction == "DELETECLOUD")
		{
			me.deleteCloudDetails();
		}
	},
	loadOnNetscalerAction : function(obj)
	{
		var me = this;
		var selectedAction = obj.getValue();
		var resultPanelObj = Ext.getCmp('resultPanel');
		if(selectedAction == "VIEW")
		{
			var url = 'EgServerDiscovery/data/EgNetScalerJson.jsp?from=viewNetScalers';
			me.updateDiscoveryTree(url);
			//me.loadNetScalerSettings();
			resultPanelObj.show();
			resultPanelObj.removeAll();
			var array = publicJSON['gridArray'];
			if (!Ext.isEmpty(array))
			{
				var columns = publicJSON['columns'];
				var gridTitle = publicJSON['gridTitle'];
				me.getGridPanel(array,columns,gridTitle);
			}
			else
			{
				var emptyMessage = publicJSON['emptyMessage'];
				me.updateResultPaanel(emptyMessage);
			}
			Ext.getCmp('discoveryRightPane').setTitle(pageTitle9);
		}
		else if(selectedAction == "ADD")
		{
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var netScalerAddPanel = {
					xtype: 'egdiscoverynetscalerform',
					id: 'netscaler',
				}
				resultPanelObj.add(netScalerAddPanel);
				Ext.getCmp('ipAdd').show();
				Ext.getCmp('ipModify').hide();

				Ext.getCmp('ssl').setValue(Ext.getCmp('ssl').getStore().getAt(0).get('valueField'));
				Ext.getCmp('isDiscovery').setValue(Ext.getCmp('isDiscovery').getStore().getAt(0).get('valueField'));

			}
		}
		else if(selectedAction == "MODIFY")
		{
			var url = 'EgServerDiscovery/data/EgNetScalerJson.jsp?from=getAllNetScalers';
			me.updateDiscoveryTree(url);

			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				resultPanelObj.show();
				resultPanelObj.removeAll();

				var comboArray = publicJSON['comboArray'];
				if(comboArray != null && comboArray != 'undefined' && comboArray.length > 1)
				{
					var netScalerModifyPanel = {
						xtype: 'egdiscoverynetscalerform',
						id: 'netscaler',
					}
					resultPanelObj.add(netScalerModifyPanel);
					Ext.getCmp('ipAdd').hide();
					Ext.getCmp('ipModify').show();

					Ext.getCmp('ipModify').getStore().loadData(publicJSON['comboArray']);
					Ext.getCmp('ipModify').setValue(Ext.getCmp('ipModify').getStore().getAt(0).get('valueField'));

					Ext.getCmp('ssl').setValue(Ext.getCmp('ssl').getStore().getAt(0).get('valueField'));
					Ext.getCmp('isDiscovery').setValue(Ext.getCmp('isDiscovery').getStore().getAt(0).get('valueField'));
				}
				else
				{
					var emptyMessage = publicJSON['emptyMessage'];
					me.updateResultPaanel(emptyMessage);
				}
			}
		}
		else if(selectedAction == "DELETE")
		{
			me.deleteNetScalersDetails();
		}
	},
	loadOnCloudDirectoryAction : function(obj)
	{
		var me = this;
		var selectedAction = obj.getValue();
		var resultPanelObj = Ext.getCmp('resultPanel');
		if(selectedAction == "VIEW")
		{
			var url = 'EgServerDiscovery/data/EgCloudDirectoryJson.jsp?from=viewvCloud';
			me.updateDiscoveryTree(url);
			//me.loadCloudDirectorySettings();
			resultPanelObj.show();
			resultPanelObj.removeAll();

			var array = publicJSON['gridArray'];
			if (!Ext.isEmpty(array))
			{
				var columns = publicJSON['columns'];
				var gridTitle = publicJSON['gridTitle'];
				me.getGridPanel(array,columns,gridTitle);
			}
			else
			{
				var emptyMessage = publicJSON['emptyMessage'];
				me.updateResultPaanel(emptyMessage);
			}
			Ext.getCmp('discoveryRightPane').setTitle(pageTitle10);
		}
		else if(selectedAction == "ADD")
		{
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var cloudDirectoryAddPanel = {
					xtype: 'egdiscoveryclouddirectoryform',
					id: 'clouddirectory',
				}
				resultPanelObj.add(cloudDirectoryAddPanel);
				Ext.getCmp('ipAdd').show();
				Ext.getCmp('ipModify').hide();

				Ext.getCmp('ssl').setValue(Ext.getCmp('ssl').getStore().getAt(0).get('valueField'));
				Ext.getCmp('isDiscovery').setValue(Ext.getCmp('isDiscovery').getStore().getAt(0).get('valueField'));
				Ext.getCmp('isVM').setValue(Ext.getCmp('isVM').getStore().getAt(0).get('valueField'));

			}
		}
		else if(selectedAction == "MODIFY")
		{
			var url = 'EgServerDiscovery/data/EgCloudDirectoryJson.jsp?from=getAllvCloud';
			me.updateDiscoveryTree(url);

			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				resultPanelObj.show();
				resultPanelObj.removeAll();

				var comboArray = publicJSON['comboArray'];
				if(comboArray != null && comboArray != 'undefined' && comboArray.length > 1)
				{
					var cloudDirectoryModifyPanel = {
						xtype: 'egdiscoveryclouddirectoryform',
						id: 'clouddirectory',
					}
					resultPanelObj.add(cloudDirectoryModifyPanel);
					Ext.getCmp('ipAdd').hide();
					Ext.getCmp('ipModify').show();

					Ext.getCmp('ipModify').getStore().loadData(publicJSON['comboArray']);
					Ext.getCmp('ipModify').setValue(Ext.getCmp('ipModify').getStore().getAt(0).get('valueField'));

					Ext.getCmp('ssl').setValue(Ext.getCmp('ssl').getStore().getAt(0).get('valueField'));
					Ext.getCmp('isDiscovery').setValue(Ext.getCmp('isDiscovery').getStore().getAt(0).get('valueField'));
					Ext.getCmp('isVM').setValue(Ext.getCmp('isVM').getStore().getAt(0).get('valueField'));
				}
				else
				{
					var emptyMessage = publicJSON['emptyMessage'];
					me.updateResultPaanel(emptyMessage);
				}
			}
		}
		else if(selectedAction == "DELETE")
		{
			me.deleteCloudDirectoryDetails();
		}
	},
	loadOnStoragePlatformAction : function(obj)
	{
		var me = this;
		var selectedAction = obj.getValue();
		var resultPanelObj = Ext.getCmp('resultPanel');
		if(selectedAction == "VIEW")
		{
			var url = 'EgServerDiscovery/data/EgStoragePlatformJson.jsp?from=viewStoragePlatform';
			me.updateDiscoveryTree(url);
			resultPanelObj.show();
			resultPanelObj.removeAll();

			var array = publicJSON['gridArray'];
			if (!Ext.isEmpty(array))
			{
				var columns = publicJSON['columns'];
				var gridTitle = publicJSON['gridTitle'];
				me.getGridPanel(array,columns,gridTitle);
			}
			else
			{
				var emptyMessage = publicJSON['emptyMessage'];
				me.updateResultPaanel(emptyMessage);
			}
			Ext.getCmp('discoveryRightPane').setTitle(pageTitle11);
		}
		else if(selectedAction == "ADD")
		{
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var cloudDirectoryAddPanel = {
					xtype: 'egdiscoverystorageplatformform',
					id: 'storageplatform',
				}
				resultPanelObj.add(cloudDirectoryAddPanel);
				Ext.getCmp('ipAdd').show();
				Ext.getCmp('ipModify').hide();

				Ext.getCmp('ssl').setValue(Ext.getCmp('ssl').getStore().getAt(0).get('valueField'));
				Ext.getCmp('isDiscovery').setValue(Ext.getCmp('isDiscovery').getStore().getAt(0).get('valueField'));

			}
		}
		else if(selectedAction == "MODIFY")
		{
			var url = 'EgServerDiscovery/data/EgStoragePlatformJson.jsp?from=getAllStoragePlatforms';
			me.updateDiscoveryTree(url);

			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				resultPanelObj.show();
				resultPanelObj.removeAll();

				var comboArray = publicJSON['comboArray'];
				if(comboArray != null && comboArray != 'undefined' && comboArray.length > 1)
				{
					var storageDirectoryModifyPanel = {
						xtype: 'egdiscoverystorageplatformform',
						id: 'storageplatform',
					}
					resultPanelObj.add(storageDirectoryModifyPanel);
					Ext.getCmp('ipAdd').hide();
					Ext.getCmp('ipModify').show();

					Ext.getCmp('ipModify').getStore().loadData(publicJSON['comboArray']);
					Ext.getCmp('ipModify').setValue(Ext.getCmp('ipModify').getStore().getAt(0).get('valueField'));

					Ext.getCmp('ssl').setValue(Ext.getCmp('ssl').getStore().getAt(0).get('valueField'));
					Ext.getCmp('isDiscovery').setValue(Ext.getCmp('isDiscovery').getStore().getAt(0).get('valueField'));
				}
				else
				{
					var emptyMessage = publicJSON['emptyMessage'];
					me.updateResultPaanel(emptyMessage);
				}
			}
		}
		else if(selectedAction == "DELETE")
		{
			me.deleteStoragePlatformDetails();
		}
	},
	loadOnRabbitMQAction : function(obj)
	{
		var me = this;
		var selectedAction = obj.getValue();
		var resultPanelObj = Ext.getCmp('resultPanel');
		if(selectedAction == "VIEW")
		{
			var url = 'EgServerDiscovery/data/EgRabbitMQNodeJson.jsp?from=viewRabbitMQ';
			me.updateDiscoveryTree(url);
			resultPanelObj.show();
			resultPanelObj.removeAll();

			var array = publicJSON['gridArray'];
			if (!Ext.isEmpty(array))
			{
				var columns = publicJSON['columns'];
				var gridTitle = publicJSON['gridTitle'];
				me.getGridPanel(array,columns,gridTitle);
			}
			else
			{
				var emptyMessage = publicJSON['emptyMessage'];
				me.updateResultPaanel(emptyMessage);
			}
			Ext.getCmp('discoveryRightPane').setTitle(pageTitle12);
		}
		else if(selectedAction == "ADD")
		{
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var cloudDirectoryAddPanel = {
					xtype: 'egdiscoveryrabbirmqform',
					id: 'rabitMQForm',
				}
				resultPanelObj.add(cloudDirectoryAddPanel);
				Ext.getCmp('ipAdd').show();
				Ext.getCmp('ipModify').hide();

				Ext.getCmp('ssl').setValue(Ext.getCmp('ssl').getStore().getAt(1).get('valueField'));
				Ext.getCmp('webport').setValue("15672");
				Ext.getCmp('isDiscovery').setValue(Ext.getCmp('isDiscovery').getStore().getAt(0).get('valueField'));

			}
		}
		else if(selectedAction == "MODIFY")
		{
			var url = 'EgServerDiscovery/data/EgRabbitMQNodeJson.jsp?from=getAllRabbitMQ';
			me.updateDiscoveryTree(url);

			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				resultPanelObj.show();
				resultPanelObj.removeAll();

				var comboArray = publicJSON['comboArray'];
				if(comboArray != null && comboArray != 'undefined' && comboArray.length > 1)
				{
					var storageDirectoryModifyPanel = {
						xtype: 'egdiscoveryrabbirmqform',
						id: 'rabitMQForm',
					}
					resultPanelObj.add(storageDirectoryModifyPanel);
					Ext.getCmp('ipAdd').hide();
					Ext.getCmp('ipModify').show();

					Ext.getCmp('ipModify').getStore().loadData(publicJSON['comboArray']);
					Ext.getCmp('ipModify').setValue(Ext.getCmp('ipModify').getStore().getAt(0).get('valueField'));

					Ext.getCmp('ssl').setValue(Ext.getCmp('ssl').getStore().getAt(1).get('valueField'));
					Ext.getCmp('webport').setValue("15672");
					Ext.getCmp('isDiscovery').setValue(Ext.getCmp('isDiscovery').getStore().getAt(0).get('valueField'));
				}
				else
				{
					var emptyMessage = publicJSON['emptyMessage'];
					me.updateResultPaanel(emptyMessage);
				}
			}
		}
		else if(selectedAction == "DELETE")
		{
			me.deleteRabbitMQDetails();
		}
	},
	updateResultPaanel : function(emptyMessage)
	{
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var emptyResultPanel = {
			style : {'text-align':'center'},
			padding : 120,
			border :false,
			html: '<div class = "iconInformation" style="margin:0 auto" ></div><div class="commonErrorMsgText">'+emptyMessage+'.</div>'
		};
		resultPanelObj.add(emptyResultPanel);
		resultPanelObj.show();
	},
	discoverUsingActiveDirectory : function(obj)
	{
		var me = this;
		var selectedValue = obj.getValue().ADDiscovery;
		var ADdomainObj = Ext.getCmp('ADdomain');
		var activedomainObj = Ext.getCmp('activeDomain');
		var ADSubnetObj = Ext.getCmp('ADSubnet');
		var ADSiteObj = Ext.getCmp('ADSite');
		Ext.getCmp('iprange').setValue("");
		if (selectedValue == "Domain")
		{
			var ADdomain = publicJSON['generalSettings']['ADdomain'];
			var ADSite = publicJSON['generalSettings']['ADSite'];
			var ADSubnet = publicJSON['generalSettings']['ADSubnet'];
			ADdomainObj.getStore().loadRawData(ADdomain);
			ADSiteObj.getStore().loadRawData(ADSite);
			ADSubnetObj.getStore().loadRawData(ADSubnet);

			ADdomainObj.setValue("none");
			ADSiteObj.setValue("none");

			activedomainObj.show();
			ADSiteObj.show();
			Ext.getCmp('ADSubnet').show();
		}
		else
		{
			activedomainObj.hide();
			ADSiteObj.hide();
			Ext.getCmp('ADSubnet').hide();
		}
	},
	populateADSite : function(obj)
	{
		var me = this;
		var selectedDomainName = obj.getValue();
		if (selectedDomainName == "none")
		{
			return;
		}
		var url = '/final/servlet/com.eg.ADDiscoveryHelperServlet?selectedItem=domain&domainName='+selectedDomainName;
		me.populateADInfo(url,"site");
	},
	populateADSubnet : function(obj)
	{
		var me = this;
		var selectedSiteName = obj.getValue();
		if (selectedSiteName == "none")
		{
			return;
		}
		url = '/final/servlet/com.eg.ADDiscoveryHelperServlet?selectedItem=site&siteName='+selectedSiteName;
		me.populateADInfo(url,"subnet");
	},
	populateIPRange : function(obj)
	{
		var me = this;
		var selectedSubnets = obj.getValue();
		if (selectedSubnets == "none" || Ext.isEmpty(selectedSubnets))
		{
			return;
		}

		url = '/final/servlet/com.eg.ADDiscoveryHelperServlet?selectedItem=subnet&subnet='+selectedSubnets;
		me.populateADInfo(url,"iprange");
	},
	populateADInfo : function(domainURL,from)
	{
		Ext.Ajax.request({
			url : domainURL + "&date="+new Date().getTime(),
			method: 'POST',
			//async: false,
			success: function(response)
			{
				var tmpData = Ext.decode(response.responseText);
				if (from == "site")
				{
					var sitesArr = tmpData['sitesArr'];
					var ADSiteObj = Ext.getCmp('ADSite');
					ADSiteObj.getStore().loadRawData(sitesArr);
					ADSiteObj.setValue("none");
				}
				else if (from == "subnet")
				{
					var sitesArr = tmpData['subnetArr'];
					var ADSubnetObj = Ext.getCmp('ADSubnet');
					ADSubnetObj.getStore().loadRawData(sitesArr);
				}
				else if (from == "iprange")
				{
					var IPRange = tmpData['IPRange'];
					if (IPRange != null && IPRange.length > 0)
					{
						if (IPRange != null && IPRange.indexOf(",") != -1)
						{
							IPRange  = IPRange.replace(",","\n");
						}
						Ext.getCmp('iprange').setValue(IPRange);
					}
				}
			},
			failure : function(response)
			{
			}
		});
	},
	submitServerDetails : function()
	{
		var discStatus = publicJSON.ManagerDiscovery;
		var me = this;
		var selectedAction = this.getSeletedAction();
		if (selectedAction == "AddvCenters")
		{
			var validationStatus = this.validateFormVC('add');
			if (validationStatus == true)
			{
				var url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=add&selectedNode=node2";
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the Vmware vSphere servers?", function(btn){
						if (btn == "yes")
						{
							if(discStatus == "Disabled")
							{
								me.showConfigPopupWindow();
							}
							else
							{
								url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=addEsxDiscovery";
								me.updateVirtualServerDetails(url,selectedAction,true,true);
							}
						}
						else
						{
							me.updateVirtualServerDetails(url,selectedAction,false,true);
						}
					});
				}
				else
				{
					this.updateVirtualServerDetails(url,selectedAction,false,true);
				}
			}
		}
		else if (selectedAction == "ModifyvCenters")
		{
			var validationStatus = this.validateFormVC('modify');
			if (validationStatus == true)
			{
				var ip = Ext.getCmp("ipModify").getValue();
				var url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=modify&selectedNode=node2&ipAdd="+encodeURIComponent(ip);
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the Vmware vSphere servers?", function(btn){
						if (btn == "yes")
						{
							if(discStatus == "Disabled")
							{
								me.showConfigPopupWindow();
							}
							else
							{
								url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=modifyEsxDiscovery&ipAdd="+encodeURIComponent(ip);
								me.updateVirtualServerDetails(url,selectedAction,true);
							}
						}
						else
						{
							me.updateVirtualServerDetails(url,selectedAction,false);
						}
					});
				}
				else
				{
					this.updateVirtualServerDetails(url,selectedAction,false);
				}
			}
		}
		else if (selectedAction == "AddHMCs")
		{
			var validationStatus = this.validateFormHMC("add");
			if (validationStatus == true)
			{
				var url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=hmcAdd&selectedNode=node2";
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the pSeries Servers?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=hmcAddHmcDiscovery";
							me.updateVirtualServerDetails(url,selectedAction,true,true);
						}
						else
						{
							me.updateVirtualServerDetails(url,selectedAction,false,true);
						}
					});
				}
				else
				{
					this.updateVirtualServerDetails(url,selectedAction,false,true);
				}
			}
		}
		else if (selectedAction == "ModifyHMCs")
		{
			var validationStatus = this.validateFormHMC("modify");
			if (validationStatus == true)
			{
				var ip = Ext.getCmp("ipModify").getValue();
				var url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=hmcModify&selectedNode=node2&ipAdd="+encodeURIComponent(ip);
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the pSeries Servers?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=hmcModifyHmcDiscovery&ipAdd="+encodeURIComponent(ip);
							me.updateVirtualServerDetails(url,selectedAction,true);
						}
						else
						{
							me.updateVirtualServerDetails(url,selectedAction,false);
						}
					});
				}
				else
				{
					this.updateVirtualServerDetails(url,selectedAction,false);
				}
			}
		}
		else if (selectedAction == "AddRHEV")
		{
			var validationStatus = this.validateRHEVForm("add");
			if (validationStatus == true)
			{
				var url = "EgServerDiscovery/data/EgRHEVdiscoverypJson.jsp?from=rhevAdd&selectedNode=node2";
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{

					Ext.MessageBox.confirm('Confirm', "Do you want to discover the RHEV Hypervisor servers?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgRHEVdiscoverypJson.jsp?from=rhevAddRhevDiscovery";
							me.updateVirtualServerDetails(url,selectedAction,true,true);
						}
						else
						{
							me.updateVirtualServerDetails(url,selectedAction,false,true);
						}
					});
				}
				else
				{
					this.updateVirtualServerDetails(url,selectedAction,false,true);
				}
			}
		}
		else if (selectedAction == "ModifyRHEV")
		{
			var validationStatus = this.validateRHEVForm("modify");
			if (validationStatus == true)
			{
				var ip = Ext.getCmp("ipModify").getValue();
				var url = "EgServerDiscovery/data/EgRHEVdiscoverypJson.jsp?from=rhevModify&selectedNode=node2&ipAdd="+encodeURIComponent(ip);
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the RHEV Hypervisor servers?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgRHEVdiscoverypJson.jsp?from=rhevModifyRhevDiscovery&ipAdd="+encodeURIComponent(ip);
							me.updateVirtualServerDetails(url,selectedAction,true);
						}
						else
						{
							me.updateVirtualServerDetails(url,selectedAction,false);
						}
					});
				}
				else
				{
					this.updateVirtualServerDetails(url,selectedAction,false);
				}
			}
		}
		else if (selectedAction == "AddNutanix")
		{
			//new changes here....for nutanix server
			var validationStatus = this.validateFormNutanix("add");
			if (validationStatus == true)
			{
				var url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=nutanixAdd&selectedNode=node2";
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the Hypervisors?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=nutanixAddDiscovery";
							me.updateVirtualServerDetails(url,selectedAction,true,true);
						}
						else
						{
							me.updateVirtualServerDetails(url,selectedAction,false,true);
						}
					});
				}
				else
				{
					this.updateVirtualServerDetails(url,selectedAction,false,true);
				}
			}
		}
		else if (selectedAction == "ModifyNutanix")
		{
			var validationStatus = this.validateFormNutanix("modify");			
			if (validationStatus == true)
			{
				var ip = Ext.getCmp("ipModify").getValue();				
				var url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=nutanixModify&selectedNode=node2&ipAdd="+encodeURIComponent(ip);
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the Hypervisors?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=nutanixModifyDiscovery&ipAdd="+encodeURIComponent(ip);
							me.updateVirtualServerDetails(url,selectedAction,true);
						}
						else
						{
							me.updateVirtualServerDetails(url,selectedAction,false);
						}
					});
				}
				else
				{
					this.updateVirtualServerDetails(url,selectedAction,false);
				}
			}
		}
		else if (selectedAction == "AddCtxXenPool")
		{
			var validationStatus = this.validateCtxXenPoolForm("add");
			if (validationStatus == true)
			{
				var url = "EgServerDiscovery/data/EgCtxXenPoolDiscoverypJson.jsp?from=ctxXenPoolAdd&selectedNode=node2";
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the Citrix XenServers?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgCtxXenPoolDiscoverypJson.jsp?from=ctxXenPoolAddDiscovery";
							me.updateVirtualServerDetails(url,selectedAction,true,true);
						}
						else
						{
							me.updateVirtualServerDetails(url,selectedAction,false,true);
						}
					});
				}
				else
				{
					this.updateVirtualServerDetails(url,selectedAction,false,true);
				}
			}
		}
		else if (selectedAction == "ModifyCtxXenPool")
		{
			var validationStatus = this.validateCtxXenPoolForm("modify");
			if (validationStatus == true)
			{
				var ip = Ext.getCmp("ipModify").getValue();
				var url = "EgServerDiscovery/data/EgCtxXenPoolDiscoverypJson.jsp?from=ctxXenPoolModify&selectedNode=node2&ipAdd="+encodeURIComponent(ip);
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the Citrix XenServers?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgCtxXenPoolDiscoverypJson.jsp?from=ctxXenPoolModifyDisovery&ipAdd="+encodeURIComponent(ip);
							me.updateVirtualServerDetails(url,selectedAction,true);
						}
						else
						{
							me.updateVirtualServerDetails(url,selectedAction,false);
						}
					});
				}
				else
				{
					this.updateVirtualServerDetails(url,selectedAction,false);
				}
			}
		}
		else if (selectedAction == "AddOracleVM")//Oracle VM Manager
		{
			var validationStatus = this.validateOracleVMForm("add");
			if (validationStatus == true)
			{
				var url = "EgServerDiscovery/data/EgOracleVmManagerDiscoverypJson.jsp?from=oracleVMAdd&selectedNode=node2";
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the Oracle VM Servers?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgOracleVmManagerDiscoverypJson.jsp?from=oracleVMAddDiscovery";
							me.updateVirtualServerDetails(url,selectedAction,true,true);
						}
						else
						{
							me.updateVirtualServerDetails(url,selectedAction,false,true);
						}
					});
				}
				else
				{
					this.updateVirtualServerDetails(url,selectedAction,false,true);
				}
			}
		}
		else if (selectedAction == "ModifyOracleVM")
		{
			var validationStatus = this.validateOracleVMForm("modify");
			if (validationStatus == true)
			{
				var ip = Ext.getCmp("ipModify").getValue();
				var url = "EgServerDiscovery/data/EgOracleVmManagerDiscoverypJson.jsp?from=oracleVMModify&selectedNode=node2&ipAdd="+encodeURIComponent(ip);
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the Oracle VM Servers?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgOracleVmManagerDiscoverypJson.jsp?from=oracleVMModifyDisovery&ipAdd="+encodeURIComponent(ip);
							me.updateVirtualServerDetails(url,selectedAction,true);
						}
						else
						{
							me.updateVirtualServerDetails(url,selectedAction,false);
						}
					});
				}
				else
				{
					this.updateVirtualServerDetails(url,selectedAction,false);
				}
			}
		}
	},
	clearControls : function()
	{
		Ext.getCmp("uname").setValue("");
		Ext.getCmp("pass").setValue("");
		Ext.getCmp("confpasswd").setValue("");
	},
	loadComboDetails : function(obj)
	{
		var selectedOption = obj.getValue();
		var servObj = Ext.getCmp('virtualCategory').getValue();
		if (selectedOption == "Choose vCenter" || selectedOption == "Choose HMC IP address" || selectedOption == "Choose RHEV Manager" || selectedOption == "Choose Nutanix Prism" || selectedOption == "Choose Oracle VM Manager" || selectedOption == "-1")
		{
			this.clearControls();
			/*if(selectedOption == "Choose vCenter")
			{
				Ext.getCmp("servertype").setValue("ServerVMs");
			}*/
			return;
		}

		if (servObj == "vCenters")
		{
			var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=modify&ipAdd="+encodeURIComponent(selectedOption)+"&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			var vCenters = publicJSON['vCenterDetails']['seletedServerDetails'];
			var isSSL = vCenters.isSSLSelected;
			var isDiscovery = vCenters.isDiscoverySelected;
			var uname = vCenters.uname;
			var pass = vCenters.pass;
			var webport = vCenters.webport;
			var confpasswd = vCenters.confpasswd;
			//var serverType =publicJSON.hiddenFields.$_servertype;
			if (isSSL == "selected")
			{
				Ext.getCmp('ssl').setValue("True");
			}
			else
			{
				Ext.getCmp('ssl').setValue("False");
			}

			if (isDiscovery == "selected")
			{
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
			}
			else
			{
				Ext.getCmp('isDiscovery').setValue("No");
			}
			Ext.getCmp("uname").setValue(uname);
			Ext.getCmp("pass").setValue(pass);
			Ext.getCmp("confpasswd").setValue(confpasswd);
			Ext.getCmp("webport").setValue(webport);
			//Ext.getCmp("servertype").setValue(serverType);
		}
		else if (servObj == "HMCs")
		{
			var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=hmcModify&ipAdd="+encodeURIComponent(selectedOption)+"&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			var hmcDetails = publicJSON['hmcDetails']['seletedServerDetails'];
			var isSSL = hmcDetails.isSSLSelected;
			var isDiscovery = hmcDetails.isDiscoverySelected;
			var uname = hmcDetails.uname;
			var pass = hmcDetails.pass;
			var hName = hmcDetails.hName;
			var confpasswd = hmcDetails.confpasswd;
			if (isSSL == "selected")
			{
				Ext.getCmp('ssl').setValue("True");
			}
			else
			{
				Ext.getCmp('ssl').setValue("False");
			}

			if (isDiscovery == "selected")
			{
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
			}
			else
			{
				Ext.getCmp('isDiscovery').setValue("No");
			}
			Ext.getCmp("uname").setValue(uname);
			Ext.getCmp("hName").setValue(hName);
			Ext.getCmp("pass").setValue(pass);
			Ext.getCmp("confpasswd").setValue(confpasswd);
		}
		else if (servObj == "RHEV")
		{
			var url = "EgServerDiscovery/data/EgRHEVDiscoveryJson.jsp?from=rhevModify&ipAdd="+encodeURIComponent(selectedOption)+"&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			var rhevDetails = publicJSON['rhevDetails']['seletedServerDetails'];
			var isSSL = rhevDetails.isSSLSelected;
			var webport = rhevDetails.webport;
			var isDiscovery = rhevDetails.isDiscoverySelected;
			var uname = rhevDetails.uname;
			var pass = rhevDetails.pass;
			var confpasswd = rhevDetails.confpasswd;
			var domain = rhevDetails.domain;
			if (isSSL == "selected")
			{
				Ext.getCmp('ssl').setValue("True");
			}
			else
			{
				Ext.getCmp('ssl').setValue("False");
			}

			if (isDiscovery == "selected")
			{
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
			}
			else
			{
				Ext.getCmp('isDiscovery').setValue("No");
			}
			Ext.getCmp("webport").setValue(webport);
			Ext.getCmp("uname").setValue(uname);
			Ext.getCmp("pass").setValue(pass);
			Ext.getCmp("confpasswd").setValue(confpasswd);
			Ext.getCmp("domain").setValue(domain);
		}
		else if (servObj == "Nutanix")
		{
			//new changes for nutanix server...
			var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=nutanixModify&ipAdd="+encodeURIComponent(selectedOption)+"&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			var nutanixDetails = publicJSON['nutanixDetails']['seletedServerDetails'];
			var isSSL = nutanixDetails.isSSLSelected;
			var isDiscovery = nutanixDetails.isDiscoverySelected;
			var uname = nutanixDetails.uname;
			var pass = nutanixDetails.pass;
			//var hName = nutanixDetails.hName;
			var confpasswd = nutanixDetails.confpasswd;
			var webport = nutanixDetails.webport;
			if (isSSL == "selected")
			{
				Ext.getCmp('ssl').setValue("True");
			}
			else
			{
				Ext.getCmp('ssl').setValue("False");
			}

			if (isDiscovery == "selected")
			{
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
			}
			else
			{
				Ext.getCmp('isDiscovery').setValue("No");
			}
			Ext.getCmp("webport").setValue(webport);
			Ext.getCmp("uname").setValue(uname);
			//Ext.getCmp("hName").setValue(hName);
			Ext.getCmp("pass").setValue(pass);
			Ext.getCmp("confpasswd").setValue(confpasswd);
		}
		else if (servObj == "CtxXenPool")
		{
			var url = "EgServerDiscovery/data/EgCtxXenPoolDiscoveryJson.jsp?from=ctxXenPoolModify&ipAdd="+encodeURIComponent(selectedOption)+"&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			var ctxXenPoolDetails = publicJSON['ctxXenPoolDetails']['seletedServerDetails'];
			var isSSL = ctxXenPoolDetails.isSSLSelected;
			var webport = ctxXenPoolDetails.webport;
			var isDiscovery = ctxXenPoolDetails.isDiscoverySelected;
			var uname = ctxXenPoolDetails.uname;
			var pass = ctxXenPoolDetails.pass;
			var confpasswd = ctxXenPoolDetails.confpasswd;
			var domain = ctxXenPoolDetails.domain;
			if (isSSL == "selected")
			{
				Ext.getCmp('ssl').setValue("True");
			}
			else
			{
				Ext.getCmp('ssl').setValue("False");
			}

			if (isDiscovery == "selected")
			{
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
			}
			else
			{
				Ext.getCmp('isDiscovery').setValue("No");
			}
			Ext.getCmp("webport").setValue(webport);
			Ext.getCmp("uname").setValue(uname);
			Ext.getCmp("pass").setValue(pass);
			Ext.getCmp("confpasswd").setValue(confpasswd);
			Ext.getCmp("domain").setValue(domain);
		}
		else if (servObj == "OracleVM")//Oracle VM Manager
		{
			var url = "EgServerDiscovery/data/EgOracleVmManagerDiscoveryJson.jsp?from=oracleVMModify&ipAdd="+encodeURIComponent(selectedOption)+"&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			var oracleVMDetails = publicJSON['oracleVMDetails']['seletedServerDetails'];
			var isSSL = oracleVMDetails.isSSLSelected;
			var webport = oracleVMDetails.webport;
			var isDiscovery = oracleVMDetails.isDiscoverySelected;
			var uname = oracleVMDetails.uname;
			var pass = oracleVMDetails.pass;
			var confpasswd = oracleVMDetails.confpasswd;
			//var domain = oracleVMDetails.domain;
			if (isSSL == "selected")
			{
				Ext.getCmp('ssl').setValue("True");
			}
			else
			{
				Ext.getCmp('ssl').setValue("False");
			}

			if (isDiscovery == "selected")
			{
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
			}
			else
			{
				Ext.getCmp('isDiscovery').setValue("No");
			}
			Ext.getCmp("webport").setValue(webport);
			Ext.getCmp("uname").setValue(uname);
			Ext.getCmp("pass").setValue(pass);
			Ext.getCmp("confpasswd").setValue(confpasswd);
			//Ext.getCmp("domain").setValue(domain);
		}
	},
	categoryOnChange : function(obj)
	{
		var me = this;
		var selectedVirCategory = obj.getValue();
		var actionObj = Ext.getCmp('action');
		if (selectedVirCategory == "vCenters")
		{
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+vCloudPageDisc+'</center>');

			var vCenters = publicJSON['vCenters'];
			actionObj.getStore().loadRawData(vCenters);
			me.loadVirtualData();
			//Ext.getCmp('action').setValue(Ext.getCmp('action').getStore().getAt(0).get('valueField'));
			//me.viewVcenterDetails();
			//me.actionOnChange(Ext.getCmp('action'));
		}
		else if (selectedVirCategory == "HMCs")
		{
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+hmcPageDisc+'</center>');

			var HMCs = publicJSON['HMCs'];
			actionObj.getStore().loadRawData(HMCs);
			
			var resultPanelObj = Ext.getCmp('resultPanel');
			var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=hmcView&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			var hmcServers = publicJSON['hmcDetails']['hmcServers'];
			resultPanelObj.show();
			resultPanelObj.removeAll();

			if (!Ext.isEmpty(hmcServers))
			{
				var value = actionObj.getStore().getAt(0).get('valueField');
				actionObj.setValue(value);
				var cols = publicJSON['hmcDetails']['columns'];
				var gridTitle = publicJSON['hmcDetails']['gridTitle'];
				me.getGridPanel(hmcServers,cols,gridTitle);
			}
			else
			{
				var value = actionObj.getStore().getAt(1).get('valueField');
				actionObj.setValue(value);
				me.actionOnChange(actionObj);
			}
			
			//Ext.getCmp('action').setValue(Ext.getCmp('action').getStore().getAt(0).get('valueField'));
			//me.viewHMCDetails();
		}
		else if (selectedVirCategory == "RHEV")
		{
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+rhevPageDisc+'</center>');
			
			var RHEV = publicJSON['RHEV'];
			actionObj.getStore().loadRawData(RHEV);
			
			var resultPanelObj = Ext.getCmp('resultPanel');
			var url = "EgServerDiscovery/data/EgRHEVDiscoveryJson.jsp?from=rhevView&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			var rhevDetails = publicJSON['rhevDetails']['rhevManagers'];
			resultPanelObj.show();
			resultPanelObj.removeAll();

			if (!Ext.isEmpty(rhevDetails))
			{
				var value = actionObj.getStore().getAt(0).get('valueField');
				actionObj.setValue(value);
				var cols = publicJSON['rhevDetails']['columns'];
				var gridTitle = publicJSON['rhevDetails']['gridTitle'];
				me.getGridPanel(rhevDetails,cols,gridTitle);
			}
			else
			{
				var value = actionObj.getStore().getAt(1).get('valueField');
				actionObj.setValue(value);
				me.actionOnChange(actionObj);
			}
			//Ext.getCmp('action').setValue(Ext.getCmp('action').getStore().getAt(0).get('valueField'));
			//me.viewRHEVDetails();
		}
		else if (selectedVirCategory == "Nutanix")
		{
			//new changes for nutanix....
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+nutanixPageDisc+'</center>');
			var nutanix = publicJSON['NUTANIX'];
			actionObj.getStore().loadRawData(nutanix);

			var resultPanelObj = Ext.getCmp('resultPanel');
			var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=nutanixView&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			var nutanixServers = publicJSON['nutanixDetails']['nutanixServers'];
			resultPanelObj.show();
			resultPanelObj.removeAll();

			if (!Ext.isEmpty(nutanixServers))
			{
				var value = actionObj.getStore().getAt(0).get('valueField');
				actionObj.setValue(value);
				var cols = publicJSON['nutanixDetails']['columns'];
				var gridTitle = publicJSON['nutanixDetails']['gridTitle'];
				me.getGridPanel(nutanixServers,cols,gridTitle);
			}
			else
			{
				var value = actionObj.getStore().getAt(1).get('valueField');
				actionObj.setValue(value);
				me.actionOnChange(actionObj);
			}

			//Ext.getCmp('action').setValue(Ext.getCmp('action').getStore().getAt(0).get('valueField'));
			//me.viewNutanixDetails();
		}
		else if (selectedVirCategory == "CtxXenPool")
		{
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+ctxXenPoolPageDisc+'</center>');
			
			
			var CtxXenPool = publicJSON['CtxXenPool'];
			actionObj.getStore().loadRawData(CtxXenPool);
			var resultPanelObj = Ext.getCmp('resultPanel');
			var url = "EgServerDiscovery/data/EgCtxXenPoolDiscoveryJson.jsp?from=ctxXenPoolView&selectedNode="+selectedNodeID;
				this.updateDiscoveryTree(url);
			if (CtxXenPool == null || CtxXenPool == 'undefined')
			{
				CtxXenPool = publicJSON['CtxXenPool'];
				actionObj.getStore().loadRawData(CtxXenPool);
			}
			var ctxXenPoolDetails = publicJSON['ctxXenPoolDetails']['ctxXenPools'];
			resultPanelObj.show();
			resultPanelObj.removeAll();

			if (!Ext.isEmpty(ctxXenPoolDetails))
			{
				var value = actionObj.getStore().getAt(0).get('valueField');
				actionObj.setValue(value);
				var cols = publicJSON['ctxXenPoolDetails']['columns'];
				var gridTitle = publicJSON['ctxXenPoolDetails']['gridTitle'];
				me.getGridPanel(ctxXenPoolDetails,cols,gridTitle);
			}
			else
			{
				var value = actionObj.getStore().getAt(1).get('valueField');
				actionObj.setValue(value);
				me.actionOnChange(actionObj);
			}

			//Ext.getCmp('action').setValue(Ext.getCmp('action').getStore().getAt(0).get('valueField'));
			//me.viewCtxXenPoolDetails();
		}
		else if (selectedVirCategory == "OracleVM")
		{
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+oracleVMPageDisc+'</center>');
			
			
			var oracleVM = publicJSON['OracleVM'];
			actionObj.getStore().loadRawData(oracleVM);
			var resultPanelObj = Ext.getCmp('resultPanel');
			var url = "EgServerDiscovery/data/EgOracleVmManagerDiscoveryJson.jsp?from=oracleVMView&selectedNode="+selectedNodeID;
				this.updateDiscoveryTree(url);
			if (oracleVM == null || oracleVM == 'undefined')
			{
				oracleVM = publicJSON['OracleVM'];
				actionObj.getStore().loadRawData(oracleVM);
			}
			var oracleVMDetails = publicJSON['oracleVMDetails']['oracleVMs'];
			//console.log("oracleVMDetails = ",oracleVMDetails);
			resultPanelObj.show();
			resultPanelObj.removeAll();

			if (!Ext.isEmpty(oracleVMDetails))
			{
				var value = actionObj.getStore().getAt(0).get('valueField');
				actionObj.setValue(value);
				var cols = publicJSON['oracleVMDetails']['columns'];
				//console.log("cols = ",cols);
				var gridTitle = publicJSON['oracleVMDetails']['gridTitle'];
				//console.log("gridTitle = ",gridTitle);
				me.getGridPanel(oracleVMDetails,cols,gridTitle);
			}
			else
			{
				var value = actionObj.getStore().getAt(1).get('valueField');
				actionObj.setValue(value);
				me.actionOnChange(actionObj);
			}

			//Ext.getCmp('action').setValue(Ext.getCmp('action').getStore().getAt(0).get('valueField'));
			//me.viewCtxXenPoolDetails();
		}
	},
	actionOnChange: function(obj)
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		var selectedAction = obj.getValue();
		var tmpVirtualObj = Ext.getCmp('virtualCategory');
		selectedAction = selectedAction + tmpVirtualObj.getValue();
		if (selectedAction == "AddvCenters")
		{
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				Ext.suspendLayouts();
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoveryvirtualform',
					id: 'virtual',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('ipAdd').show();
				Ext.getCmp('ipModify').hide();
				Ext.getCmp('validateVC').show();
				//Ext.getCmp('servertype').show();

				var SSLTemplate = publicJSON['SSLTemplate'];
				var vCenterLabels = publicJSON['vCenterLabels'];
				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				//var ServerTypeTemplate = publicJSON['ServerTypeTemplate'];
				Ext.getCmp('ssl').getStore().loadRawData(SSLTemplate);
				Ext.getCmp('ssl').setValue("True");
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
				//Ext.getCmp('servertype').getStore().loadRawData(ServerTypeTemplate);
				//Ext.getCmp('servertype').setValue("ServerVMs");
				me.setIntnlLabels(vCenterLabels);
				Ext.getCmp('egdiscoveryvirtualformFields').titleCmp.update(validationMsg32);
				Ext.resumeLayouts(true);
			}
		}
		else if (selectedAction == "ModifyvCenters")
		{
			var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=modify&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				Ext.suspendLayouts();
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoveryvirtualform',
					id: 'virtual',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('ipAdd').hide();
				Ext.getCmp('ipModify').show();
				Ext.getCmp('validateVC').show();
				//Ext.getCmp('servertype').show();

				var SSLTemplate = publicJSON['SSLTemplate'];
				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				//var ServerTypeTemplate = publicJSON['ServerTypeTemplate'];
				Ext.getCmp('ssl').getStore().loadRawData(SSLTemplate);
				Ext.getCmp('ssl').setValue("True");
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
				//Ext.getCmp('servertype').getStore().loadRawData(ServerTypeTemplate);
				//Ext.getCmp('servertype').setValue("ServerVMs");

				var vCenters = publicJSON['vCenterDetails']['deletevCenterServers'];
				if (!Ext.isEmpty(vCenters))
				{
					var vCenterLabels = publicJSON['vCenterLabels'];
					Ext.getCmp('ipModify').getStore().loadRawData(vCenters);
					var seletedObj = Ext.getCmp('ipModify').getStore().getAt(0).get('valueField')
					Ext.getCmp('ipModify').setValue(seletedObj);
					me.setIntnlLabels(vCenterLabels);
					Ext.getCmp('egdiscoveryvirtualformFields').titleCmp.update(validationMsg32);

				}
				else
				{
					var emptyMessage = publicJSON['emptyMessage'];
					me.updateResultPaanel(emptyMessage);
				}
				Ext.resumeLayouts(true);
			}
		}
		else if (selectedAction == "ViewvCenters")
		{
			this.viewVcenterDetails();
		}
		else if (selectedAction == "DeletevCenters")
		{
			this.deleteVCenterDetails();
		}
		else if (selectedAction == "RemoteAgentvCenters")
		{
			this.viewVcenterRemoteAgentDetails();
		}
		else if (selectedAction == "ConfigurevCenters")
		{
			var tmpPanel = Ext.create("Ext.panel.Panel",{
				border : false,
				buttonAlign : 'center',
				layout : {
					type: 'vbox',
					align : 'center',
					pack: 'center',
					padding : 12
				},
				items:[
					{
						xtype:'fieldset',
						title : intnlLabel20,
						width : 700,
						items : [
							{
								xtype:'textfield',
								fieldLabel: 'Memory Range (MB)',
								id:'memory',
								name:'memory',
								value: memory,
								border:false,
								cls: 'textbox24',
								width: 620,
								labelSeparator: ' ',
								labelWidth: 320
							},
							{
								xtype:'hiddenfield',
								id:'$_memory',
								name:'$_memory',
								value: memory,
							}
						]
					}
				],
				buttons : [
					{
						text: intnlLabel7,
						cls: 'button20',
						handler: function()
						{
							var mem = Ext.getCmp('memory');
							var tmpMemory = mem.getValue();	
							memory = tmpMemory;
							if(!checkblank(tmpMemory))
							{
								Ext.Msg.alert(pageTitle2,validationMsg9,function(btn){
									if (btn == 'ok'){
										mem.focus(true);
									}
								});
								return false;
							}
							else if(checkSpecialExtjs(tmpMemory," +-=~!@#$%^&*()\"\';") != '0')
							{
								Ext.Msg.alert(pageTitle2,"Space/"+_checkspecial,function(btn){
									if (btn == 'ok'){
										mem.focus(true);
									}
								});
								return false;
							}
							else if(checkAlpha(tmpMemory))
							{
								Ext.Msg.alert(pageTitle2,_checkAlpha,function(btn){
									if (btn == 'ok'){
										mem.focus(true);
									}
								});
								return false;
							}
							var url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=memory&selectedNode=node2";
							me.updateVirtualServerDetails(url,selectedAction,false,false);
						}
					}
				]
			});
			var resultPanelObj = Ext.getCmp('resultPanel');
			resultPanelObj.removeAll();
			resultPanelObj.add(tmpPanel);
			resultPanelObj.show();
		}
		else if (selectedAction == "ViewHMCs")
		{
			me.viewHMCDetails();
		}
		else if (selectedAction == "AddHMCs")
		{
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				Ext.suspendLayouts();
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoveryvirtualform',
					id: 'virtual',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('ipAdd').show();
				Ext.getCmp('ipModify').hide();
				Ext.getCmp('hName').show();
				Ext.getCmp('webport').hide();

				var SSLTemplate = publicJSON['SSLTemplate'];
				var HMCLabels = publicJSON['HMCLabels'];
				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				Ext.getCmp('ssl').getStore().loadRawData(SSLTemplate);
				Ext.getCmp('ssl').setValue("True");
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
				me.setIntnlLabels(HMCLabels);
				Ext.getCmp('egdiscoveryvirtualformFields').titleCmp.update(validationMsg33);
				Ext.resumeLayouts(true);
			}
		}
		else if (selectedAction == "ModifyHMCs")
		{
			var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=hmcModify&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				Ext.suspendLayouts();
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoveryvirtualform',
					id: 'virtual',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('ipAdd').hide();
				Ext.getCmp('ipModify').show();
				Ext.getCmp('hName').show();
				Ext.getCmp('webport').hide();

				var SSLTemplate = publicJSON['SSLTemplate'];
				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				Ext.getCmp('ssl').getStore().loadRawData(SSLTemplate);
				Ext.getCmp('ssl').setValue("True");
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);

				var hmcServers = publicJSON['hmcDetails']['hmcServers'];
				if (!Ext.isEmpty(hmcServers))
				{
					var HMCLabels = publicJSON['HMCLabels'];
					Ext.getCmp('ipModify').getStore().loadRawData(hmcServers);
					var seletedObj = Ext.getCmp('ipModify').getStore().getAt(0).get('valueField')
					Ext.getCmp('ipModify').setValue(seletedObj);
					me.setIntnlLabels(HMCLabels);
					Ext.getCmp('egdiscoveryvirtualformFields').titleCmp.update(validationMsg33);
				}
				else
				{
					var emptyMessage = publicJSON['emptyMessage'];
					me.updateResultPaanel(emptyMessage);
				}
				Ext.resumeLayouts(true);
			}
		}
		else if (selectedAction == "DeleteHMCs")
		{
			this.deleteHMCsDetails();
		}
		else if (selectedAction == "ViewNutanix")
		{			
			me.viewNutanixDetails();
		}
		else if (selectedAction == "AddNutanix")
		{			
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				Ext.suspendLayouts();
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoveryvirtualform',
					id: 'virtual',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('ipAdd').show();
				Ext.getCmp('ipModify').hide();
				Ext.getCmp('hName').hide();
				Ext.getCmp('validateVC').show();
				Ext.getCmp('webport').show();

				var SSLTemplate = publicJSON['SSLTemplate'];
				var nutanixLabels = publicJSON['nutanixLabels'];
				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				Ext.getCmp('ssl').getStore().loadRawData(SSLTemplate);
				Ext.getCmp('ssl').setValue("True");
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
				Ext.getCmp('webport').setValue("9440");
				me.setIntnlLabels(nutanixLabels);
				Ext.getCmp('egdiscoveryvirtualformFields').titleCmp.update(validationMsg96);
				Ext.resumeLayouts(true);
			}
		}
		else if (selectedAction == "ModifyNutanix")
		{			
			var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=nutanixModify&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				Ext.suspendLayouts();
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoveryvirtualform',
					id: 'virtual',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('ipAdd').hide();
				Ext.getCmp('ipModify').show();
				Ext.getCmp('hName').hide();
				Ext.getCmp('validateVC').show();
				Ext.getCmp('webport').show();

				var SSLTemplate = publicJSON['SSLTemplate'];
				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				Ext.getCmp('ssl').getStore().loadRawData(SSLTemplate);
				Ext.getCmp('ssl').setValue("True");
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);				
				var nutanixServers = publicJSON['nutanixDetails']['nutanixServers'];
				if (!Ext.isEmpty(nutanixServers))
				{
					var nutanixLabels = publicJSON['nutanixLabels'];
					Ext.getCmp('ipModify').getStore().loadRawData(nutanixServers);
					var seletedObj = Ext.getCmp('ipModify').getStore().getAt(0).get('valueField')
					Ext.getCmp('ipModify').setValue(seletedObj);	
					Ext.getCmp('webport').setValue("9440");
					me.setIntnlLabels(nutanixLabels);
					Ext.getCmp('egdiscoveryvirtualformFields').titleCmp.update(validationMsg96);
				}
				else
				{
					var emptyMessage = publicJSON['emptyMessage'];
					me.updateResultPaanel(emptyMessage);
				}
				Ext.resumeLayouts(true);
			}
		}
		else if (selectedAction == "DeleteNutanix")
		{
			this.deleteNutanixDetails();
		}
		else if (selectedAction == "AddRHEV")
		{
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				Ext.suspendLayouts();
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoveryvirtualform',
					id: 'virtual',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('ipAdd').show();
				Ext.getCmp('ipModify').hide();
				Ext.getCmp('domain').show();

				var SSLTemplate = publicJSON['SSLTemplate'];
				var fieldLabels = publicJSON['fieldLabels'];
				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				Ext.getCmp('ssl').getStore().loadRawData(SSLTemplate);
				Ext.getCmp('ssl').setValue("True");
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
				Ext.getCmp('webport').setValue("443");
				me.setIntnlLabels(fieldLabels);
				//Ext.getCmp('egdiscoveryvirtualformFields').setTitle(validationMsg31);
				Ext.getCmp('egdiscoveryvirtualformFields').titleCmp.update(validationMsg31);
				Ext.resumeLayouts(true);
			}
		}
		else if (selectedAction == "ViewRHEV")
		{
			me.viewRHEVDetails();
		}
		else if (selectedAction == "ModifyRHEV")
		{
			var url = "EgServerDiscovery/data/EgRHEVDiscoveryJson.jsp?from=rhevModify&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				Ext.suspendLayouts();
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoveryvirtualform',
					id: 'virtual',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('ipAdd').hide();
				Ext.getCmp('ipModify').show();
				//Ext.getCmp('hName').show();
				Ext.getCmp('domain').show();
				Ext.getCmp('webport').show();

				var SSLTemplate = publicJSON['SSLTemplate'];
				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				Ext.getCmp('ssl').getStore().loadRawData(SSLTemplate);
				Ext.getCmp('ssl').setValue("True");
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
				Ext.getCmp('webport').setValue("443");

				var rhevDetails = publicJSON['rhevDetails']['rhevManagers'];
				if (!Ext.isEmpty(rhevDetails))
				{
					var fieldLabels = publicJSON['fieldLabels'];
					Ext.getCmp('ipModify').getStore().loadRawData(rhevDetails);
					var seletedObj = Ext.getCmp('ipModify').getStore().getAt(0).get('valueField')
					Ext.getCmp('ipModify').setValue(seletedObj);
					me.setIntnlLabels(fieldLabels);
					Ext.getCmp('egdiscoveryvirtualformFields').titleCmp.update(validationMsg31);
				}
				else
				{
					var emptyMessage = publicJSON['emptyMessage'];
					me.updateResultPaanel(emptyMessage);
				}
				Ext.resumeLayouts(true);
			}
		}
		else if (selectedAction == "DeleteRHEV")
		{
			this.deleteRHEVDetails();
		}
		else if (selectedAction == "AddCtxXenPool")
		{			
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				Ext.suspendLayouts();
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoveryvirtualform',
					id: 'virtual',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('ipAdd').show();
				Ext.getCmp('ipModify').hide();
				Ext.getCmp('hName').hide();
				Ext.getCmp('webport').show();
				Ext.getCmp('validateVC').show();

				var SSLTemplate = publicJSON['SSLTemplate'];
				var ctxXenPoolLabels = publicJSON['fieldLabels'];
				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				Ext.getCmp('ssl').getStore().loadRawData(SSLTemplate);
				Ext.getCmp('ssl').setValue("True");
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
				Ext.getCmp('webport').setValue("443");
				me.setIntnlLabels(ctxXenPoolLabels);
				Ext.getCmp('egdiscoveryvirtualformFields').titleCmp.update(validationMsg99);
				Ext.resumeLayouts(true);
			}
		}
		else if (selectedAction == "ModifyCtxXenPool")
		{
			var url = "EgServerDiscovery/data/EgCtxXenPoolDiscoveryJson.jsp?from=ctxXenPoolModify&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				Ext.suspendLayouts();
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoveryvirtualform',
					id: 'virtual',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('ipAdd').hide();
				Ext.getCmp('ipModify').show();
				Ext.getCmp('webport').show();
				Ext.getCmp('validateVC').show();

				var SSLTemplate = publicJSON['SSLTemplate'];
				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				Ext.getCmp('ssl').getStore().loadRawData(SSLTemplate);
				Ext.getCmp('ssl').setValue("True");
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
				Ext.getCmp('webport').setValue("443");

				var ctxXenPoolDetails = publicJSON['ctxXenPoolDetails']['ctxXenPools'];
				if (!Ext.isEmpty(ctxXenPoolDetails))
				{
					var fieldLabels = publicJSON['fieldLabels'];
					Ext.getCmp('ipModify').getStore().loadRawData(ctxXenPoolDetails);
					var seletedObj = Ext.getCmp('ipModify').getStore().getAt(0).get('valueField')
					Ext.getCmp('ipModify').setValue(seletedObj);
					me.setIntnlLabels(fieldLabels);
					Ext.getCmp('egdiscoveryvirtualformFields').titleCmp.update(validationMsg99);
				}
				else
				{
					var emptyMessage = publicJSON['emptyMessage'];
					me.updateResultPaanel(emptyMessage);
				}
				Ext.resumeLayouts(true);
			}
		}
		else if (selectedAction == "ViewCtxXenPool")
		{
			me.viewCtxXenPoolDetails();
		}
		else if (selectedAction == "DeleteCtxXenPool")
		{
			this.deleteCtxXenServerPoolDetails();
		}
		
		//Oracle VM Manager
		else if (selectedAction == "AddOracleVM")
		{
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				Ext.suspendLayouts();
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoveryvirtualform',
					id: 'virtual',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('ipAdd').show();
				Ext.getCmp('ipModify').hide();
				Ext.getCmp('hName').hide();
				Ext.getCmp('webport').show();
				Ext.getCmp('validateVC').show();

				var SSLTemplate = publicJSON['SSLTemplate'];
				var oracleVMLabels = publicJSON['fieldLabels'];
				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				Ext.getCmp('ssl').getStore().loadRawData(SSLTemplate);
				Ext.getCmp('ssl').setValue("True");
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
				Ext.getCmp('webport').setValue("7002");
				me.setIntnlLabels(oracleVMLabels);
				Ext.getCmp('egdiscoveryvirtualformFields').titleCmp.update(validationMsg115);
				Ext.resumeLayouts(true);
			}
		}
		else if (selectedAction == "ModifyOracleVM")
		{
			var url = "EgServerDiscovery/data/EgOracleVmManagerDiscoveryJson.jsp?from=oracleVMModify&selectedNode="+selectedNodeID;
			this.updateDiscoveryTree(url);
			if (resultPanelObj != null && resultPanelObj != 'undefined')
			{
				Ext.suspendLayouts();
				resultPanelObj.show();
				resultPanelObj.removeAll();
				var virtualAddPanel = {
					xtype: 'egdiscoveryvirtualform',
					id: 'virtual',
				}
				resultPanelObj.add(virtualAddPanel);
				Ext.getCmp('ipAdd').hide();
				Ext.getCmp('ipModify').show();
				Ext.getCmp('webport').show();
				Ext.getCmp('validateVC').show();

				var SSLTemplate = publicJSON['SSLTemplate'];
				var DiscoveryTemplate = publicJSON['DiscoveryTemplate'];
				Ext.getCmp('ssl').getStore().loadRawData(SSLTemplate);
				Ext.getCmp('ssl').setValue("True");
				Ext.getCmp('isDiscovery').getStore().loadRawData(DiscoveryTemplate);
				Ext.getCmp('isDiscovery').setValue(validationMsg15);
				Ext.getCmp('webport').setValue("7002");

				var oracleVMDetails = publicJSON['oracleVMDetails']['oracleVMs'];
				if (!Ext.isEmpty(oracleVMDetails))
				{
					var fieldLabels = publicJSON['fieldLabels'];
					Ext.getCmp('ipModify').getStore().loadRawData(oracleVMDetails);
					var seletedObj = Ext.getCmp('ipModify').getStore().getAt(0).get('valueField')
					Ext.getCmp('ipModify').setValue(seletedObj);
					me.setIntnlLabels(fieldLabels);
					Ext.getCmp('egdiscoveryvirtualformFields').titleCmp.update(validationMsg115);
				}
				else
				{
					var emptyMessage = publicJSON['emptyMessage'];
					me.updateResultPaanel(emptyMessage);
				}
				Ext.resumeLayouts(true);
			}
		}
		else if (selectedAction == "ViewOracleVM")
		{
			me.viewOracleVMDetails();
		}
		else if (selectedAction == "DeleteOracleVM")
		{
			this.deleteOracleVMDetails();
		}
		//this.getVirtualplatform().doLayout();
		//this.getMain().doLayout();
	},
	sslOnChange: function(obj)
	{
		var tmpVirtualVal = Ext.getCmp('virtualCategory').getValue();
		if(tmpVirtualVal != undefined && tmpVirtualVal != null && tmpVirtualVal != "Nutanix")
		{
			var sslVal = obj.getValue().toLowerCase();
			var port = (sslVal == "yes" || sslVal == "true") ? "443" : "80";
			Ext.getCmp("webport").setValue(port);
		}
	},
	deleteCloudDetails : function()
	{
		var selectedAction =Ext.getCmp('cloudaction').getValue();
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');

		var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=cloudDelete&selectedNode="+selectedNodeID;
		me.updateDiscoveryTree(url);
		var cloudServers = publicJSON['cloudDetails']['cloudServers'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(cloudServers))
		{
			var cols = publicJSON['cloudDetails']['columns'];
			var gridTitle = publicJSON['cloudDetails']['gridTitle'];
			me.getEditableGridPanel2(cloudServers,cols,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	deleteNetScalersDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.show();
		resultPanelObj.removeAll();

		var url = "EgServerDiscovery/data/EgNetScalerJson.jsp?from=delNetScalers";
		me.updateDiscoveryTree(url);

		var array = publicJSON['gridArray'];
		if (!Ext.isEmpty(array))
		{
			var columns = publicJSON['columns'];
			var gridTitle = publicJSON['gridTitle'];
			me.getEditableGridPanel2(array,columns,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	deleteCloudDirectoryDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.show();
		resultPanelObj.removeAll();
		var url = "EgServerDiscovery/data/EgCloudDirectoryJson.jsp?from=delvCloud";
		me.updateDiscoveryTree(url);

		var array = publicJSON['gridArray'];
		if (!Ext.isEmpty(array))
		{
			var columns = publicJSON['columns'];
			var gridTitle = publicJSON['gridTitle'];
			me.getEditableGridPanel2(array,columns,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	deleteStoragePlatformDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.show();
		resultPanelObj.removeAll();
		var url = "EgServerDiscovery/data/EgStoragePlatformJson.jsp?from=delStoragePlatform";
		me.updateDiscoveryTree(url);

		var array = publicJSON['gridArray'];
		if (!Ext.isEmpty(array))
		{
			var columns = publicJSON['columns'];
			var gridTitle = publicJSON['gridTitle'];
			me.getEditableGridPanel2(array,columns,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	deleteRabbitMQDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.show();
		resultPanelObj.removeAll();
		var url = "EgServerDiscovery/data/EgRabbitMQNodeJson.jsp?from=deleteRabbitMQ";
		me.updateDiscoveryTree(url);

		var array = publicJSON['gridArray'];
		if (!Ext.isEmpty(array))
		{
			var columns = publicJSON['columns'];
			var gridTitle = publicJSON['gridTitle'];
			me.getEditableGridPanel2(array,columns,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	deleteVCenterDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=delete&selectedNode="+selectedNodeID;
		me.updateDiscoveryTree(url);
		var vCenters = publicJSON['vCenterDetails']['deletevCenterServers'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(vCenters))
		{
			var cols = publicJSON['vCenterDetails']['columns'];
			var gridTitle = publicJSON['vCenterDetails']['gridTitle'];
			me.getEditableGridPanel2(vCenters,cols,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	deleteHMCsDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');

		var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=hmcDelete&selectedNode="+selectedNodeID;
		me.updateDiscoveryTree(url);
		var hmcServers = publicJSON['hmcDetails']['hmcServers'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(hmcServers))
		{
			var cols = publicJSON['hmcDetails']['columns'];
			var gridTitle = publicJSON['hmcDetails']['gridTitle'];
			me.getEditableGridPanel2(hmcServers,cols,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	deleteNutanixDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');		
		var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=nutanixDelete&selectedNode="+selectedNodeID;
		me.updateDiscoveryTree(url);
		var nutanixServers = publicJSON['nutanixDetails']['nutanixServers'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(nutanixServers))
		{
			var cols = publicJSON['nutanixDetails']['columns'];
			var gridTitle = publicJSON['nutanixDetails']['gridTitle'];
			me.getEditableGridPanel2(nutanixServers,cols,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	deleteRHEVDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');

		var url = "EgServerDiscovery/data/EgRHEVDiscoveryJson.jsp?from=rhevDelete&selectedNode="+selectedNodeID;
		me.updateDiscoveryTree(url);
		var rhevDetails = publicJSON['rhevDetails']['rhevManagers'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(rhevDetails))
		{
			var cols = publicJSON['rhevDetails']['columns'];
			var gridTitle = publicJSON['rhevDetails']['gridTitle'];
			me.getEditableGridPanel2(rhevDetails,cols,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	deleteCtxXenServerPoolDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');

		var url = "EgServerDiscovery/data/EgCtxXenPoolDiscoveryJson.jsp?from=ctxXenPoolDelete&selectedNode="+selectedNodeID;
		me.updateDiscoveryTree(url);
		var ctxXenPoolDetails = publicJSON['ctxXenPoolDetails']['ctxXenPools'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(ctxXenPoolDetails))
		{
			var cols = publicJSON['ctxXenPoolDetails']['columns'];
			var gridTitle = publicJSON['ctxXenPoolDetails']['gridTitle'];
			me.getEditableGridPanel2(ctxXenPoolDetails,cols,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	deleteOracleVMDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');

		var url = "EgServerDiscovery/data/EgOracleVmManagerDiscoveryJson.jsp?from=oracleVMDelete&selectedNode="+selectedNodeID;
		me.updateDiscoveryTree(url);
		var oracleVMDetails = publicJSON['oracleVMDetails']['oracleVMs'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(oracleVMDetails))
		{
			var cols = publicJSON['oracleVMDetails']['columns'];
			var gridTitle = publicJSON['oracleVMDetails']['gridTitle'];
			me.getEditableGridPanel2(oracleVMDetails,cols,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	afterMainRender : function()
	{
		if (reqfrom == 'seg_top' && reqfrom != null)
		{
			Ext.getCmp('btnBack').show();
		}
		var thisApp = this;
		var disObject = Ext.getCmp('discoveryRightPane');
		disObject.removeAll();
		if (selectedNodeID == "node1")
		{
			disObject.add({xtype:'discoverypane'});
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+settingPageDisc+'</center>');
		}
		else if (selectedNodeID == "node2")
		{
			disObject.add({xtype:'virtualplatform'});
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+vCloudPageDisc+'</center>');
			thisApp.loadVirtualData();
		}
		else if (selectedNodeID == "node3")
		{
			disObject.add({xtype:'egcloudplatforms'});
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+cloudPageDisc+'</center>');
			thisApp.loadCloudSettings();
		}
		else if (selectedNodeID == "node12")
		{
			disObject.add({xtype:'egnetscalerforms'});
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+netscalerPageDisc+'</center>');
			thisApp.loadNetScalerSettings();
		}
		else if (selectedNodeID == "node13")
		{
			disObject.add({xtype:'egclouddirectoryform'});
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+clouddirectoryPageDisc+'</center>');
			thisApp.loadCloudDirectorySettings();
		}
		else if (selectedNodeID == "node4")
		{
			disObject.add({xtype:'discoverysettings'});
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+cloudPageDisc+'</center>');
			thisApp.showManagerActions();
		}
		else if (selectedNodeID == "node14")
		{
			disObject.add({xtype:'egstorageplatform'});
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+storageplatformPageDisc+'</center>');
			thisApp.loadStoragePlatformSettings();
		}
		else if (selectedNodeID == "node8")
		{
			var isAgentDiscoveryEnabled = publicJSON['agentdiscval'];
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+agentPageDisc+'</center>');
			if (isAgentDiscoveryEnabled == "yes" || isAgentDiscoveryEnabled == "true")
			{
				disObject.add({xtype:'agentdiscovery'});
			}
			else
			{
				var discoveryRightPaneObj = Ext.getCmp('discoveryRightPane');
				discoveryRightPaneObj.removeAll();
				var tmpMsg = {
					xtype:'component',
					padding:160,
					style:{'text-align':'center'},
					html:'<div class = "iconInformation" style="margin:0 auto"></div><div>'+agentDiscoveryMessage+'</div>'
				}
				discoveryRightPaneObj.add(tmpMsg);
			}
			Ext.getCmp('discoveryRightPane').setTitle(pageTitle6);
		}
		else if (selectedNodeID == "node9")
		{
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;This page enables the administrator to enable/disable agent discovery</center>');
			disObject.add({xtype:'discoverysettings'});
			disObject.doLayout();
			thisApp.showAgentActions();
		}
		else if (selectedNodeID == "node10")
		{
			disObject.add({xtype:'commonsettingspanel'});
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+commonPageDisc+'</center>');
			Ext.getCmp('discoveryRightPane').setTitle(commonSettingGeneral);
			thisApp.updateApplicationServerSettings("menu");
		}
		else if (selectedNodeID == "node17")
		{
			disObject.add({xtype:'commonsettingspanel'});
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+commonPageDisc2+'</center>');
			Ext.getCmp('discoveryRightPane').setTitle(commonSettingTCP);
			thisApp.updateApplicationServerSettings2("menu");
		}
		else if (selectedNodeID == "node18")
		{
			disObject.add({xtype:'commonsettingspanel'});
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+commonPageDisc3+'</center>');
			Ext.getCmp('discoveryRightPane').setTitle(commonSettingAutomanage);
			thisApp.updateApplicationServerSettings3("menu");
		}
		else if (selectedNodeID == "node15")
		{
			disObject.add({xtype:'autodeletesettingspanel'});
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+autodeletePageDisc+'</center>');
			thisApp.loadAutodeleteSettings("menu");
		}
		else if (selectedNodeID == "node11")
		{
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+manageCompDisc+'</center>');
			disObject.add({xtype:'egconfigenvformcontainer'});
			Ext.getCmp('discoveryRightPane').setTitle(pageTitle8);
			if (activeCompTypes == "true")
			{
				Ext.getCmp('activeCompTypes').setValue(true);
			}
			disObject.doLayout();
		}
		else if (selectedNodeID == "node20")
		{
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;This page enables the administrator to view the discovered components.</center>');
			disObject.add({xtype:'discoveryreport'});
			Ext.getCmp('discoveryRightPane').setTitle(intnlLabel82);
		}
		else if (selectedNodeID == "node16")
		{
			disObject.add({xtype:'egrabbitmq'});
			Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+rabbitMQPageDisc+'</center>');
			Ext.getCmp('discoveryRightPane').setTitle(pageTitle12);
			thisApp.loadRabbitMQSettings("menu");
		}
	},
	showToolTip : function(obj, record, item, index, e, eOpts)
	{
		var customqtip = record.raw.customqtip;
		if (customqtip != null && customqtip != undefined)
		{
			var mytip  = Ext.create("Ext.tip.ToolTip",{
				target: e.getTarget(),
				anchor:"top",
				hideDelay : 0,
				autoHide : true,
				trackMouse : true,
				cls:"yellowTip",
				html : customqtip
			}).showAt(e.getXY());

			if (!Ext.isEmpty(mytip))
			{
				mytip.destroy();
				mytip = null;
			}
		}
	},
	loadServerDiscoveryPage :function(view, record, item, index, event)
	{
		var me = this;
		var selectNode = record.raw.nodeId;
		if (selectNode == 'Start' || selectNode == 'Stop')
		{
			var message = startDiscConfirm;
			if (selectNode == 'Stop')
			{
				message = stopDiscConfirm;
			}
			Ext.MessageBox.confirm({
				title : 'Confirm',
				msg: message+'?',
				icon : 'iconConfirmation',
				width : 400,
				buttons: Ext.Msg.YESNO,
				fn : function(btn){
					if (btn == "yes")
					{
						me.loadServerDiscoveryPage2(view, record, item, index, event);
					}				
				}
			});
		}
		else
		{
			me.loadServerDiscoveryPage2(view, record, item, index, event);
		}
	},
	loadServerDiscoveryPage2 : function(view, record, item, index, event)
	{
		var me = this;
		var seletedNode = record.raw.nodeId;
		var seletedTreeNode = record.raw.id;
		seletedNode = Ext.util.Format.trim(seletedNode);
		var disObject = Ext.getCmp('discoveryRightPane');
		var defaultUrl = "";
		defaultUrl = record.raw.link;
		if (record.raw.hasPageLink == false)
		{
			return false;
		}
		selectedNodeID = seletedTreeNode;
		//Ext.getCmp('settings').hide();
		disObject.removeAll();
		if (defaultUrl != "")
		{
			var myMask = new Ext.LoadMask(Ext.getCmp('discoveryRightPane'), {msg: 'Loading...'});
			myMask.show();
			Ext.Ajax.abort();
			Ext.Ajax.request({
				url : defaultUrl,
				method: 'POST',
				success: function(response)
				{
					myMask.hide();
					publicJSON = Ext.decode(response.responseText);
					Ext.getCmp('discoveryHeaderDocked').show();
					if (seletedNode != null && seletedNode == "virtual")
					{
						disObject.add({xtype:'virtualplatform'});
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+vCloudPageDisc+'</center>');
						me.loadVirtualData();
					}
					else if (seletedNode != null && seletedNode == "General")
					{
						//Ext.getCmp('settings').show();
						disObject.add({xtype:'discoverypane'});
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+settingPageDisc+'</center>');
					}
					else if (seletedNode != null && seletedNode == "clouds")
					{
						disObject.add({xtype:'egcloudplatforms'});
						me.loadCloudSettings();
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+cloudPageDisc+'</center>');
					}
					else if (seletedNode != null && seletedNode == "netscaler")
					{
						disObject.add({xtype:'egnetscalerforms'});
						me.loadNetScalerSettings();
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+netscalerPageDisc+'</center>');
					}
					else if (seletedNode != null && seletedNode == "clouddirector")
					{
						disObject.add({xtype:'egclouddirectoryform'});
						me.loadCloudDirectorySettings();
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+clouddirectoryPageDisc+'</center>');
					}
					else if (seletedNode != null && seletedNode == "storageplatform")
					{
						disObject.add({xtype:'egstorageplatform'});
						me.loadStoragePlatformSettings();
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+storageplatformPageDisc+'</center>');
					}
					else if (seletedNode != null && seletedNode == "rabbitmqnode")
					{
						disObject.add({xtype:'egrabbitmq'});
						me.loadRabbitMQSettings();
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+rabbitMQPageDisc+'</center>');
					}
					else if (seletedNode != null && seletedNode == "Stop")
					{
						Ext.getCmp('discoveryHeaderDocked').hide();
						disObject.add({xtype:'resultpanel',id : 'resultPanel',border:false});
						Ext.getCmp('discoveryRightPane').setTitle(pageTitle2);
						me.stopManagerDiscovery();
					}
					else if (seletedNode == "AgentGeneral")
					{
						var isAgentDiscoveryEnabled = publicJSON['agentdiscval'];
						if (isAgentDiscoveryEnabled == "yes" || isAgentDiscoveryEnabled == "true")
						{
							disObject.add({xtype:'agentdiscovery'});
							Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+agentPageDisc+'</center>');
						}
						else
						{
							var discoveryRightPaneObj = Ext.getCmp('discoveryRightPane');
							discoveryRightPaneObj.removeAll();
							var tmpMsg = {
								xtype:'component',
								style:{'text-align':'center'},
								html : "<div style='margin:20% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText'>"+agentDiscoveryMessage+"</div></td></tr></table></div>"
							}
							discoveryRightPaneObj.add(tmpMsg);
						}
						Ext.getCmp('discoveryRightPane').setTitle(pageTitle6);
					}
					else if (seletedNode != null && seletedNode == "Start")
					{
						disObject.add({xtype:'egconfigenvformcontainer',border : false});
						Ext.getCmp('discoveryRightPane').setTitle(pageTitle8);
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+manageCompDisc+'</center>');
						isDiscState = true;
						refreshOnDiscAlive();
						if (managerDiscoveryUI == "no")
						{
							me.showConfigPopupWindow();
						}
						if (automanageConfig.toLowerCase() == "yes" && managerDiscoveryUI == "yes")
						{
							me.showNotificationWindow();
						}
					}
					else if (seletedNode != null && seletedNode == "Manage")
					{
						disObject.add({xtype:'egconfigenvformcontainer'});
						var servertypes = Ext.getCmp('servertypes');
						var servers = publicJSON['servers'];
						servertypes.getStore().loadRawData(servers);
						servertypes.setValue('-1');
						Ext.getCmp('discoveryRightPane').setTitle(pageTitle8);
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+manageCompDisc+'</center>');
						//me.loadDefaultTabView();
					}
					else if (seletedNode != null && seletedNode == "mgrActions")
					{
						disObject.add({xtype:'discoverysettings'});
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+pageConfigDisc+'</center>');
						me.showManagerActions();
					}
					else if (seletedNode != null && seletedNode == "AgentActions")
					{
						disObject.add({xtype:'discoverysettings'});
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;This page enables the administrator to enable/disable agent discovery</center>');
						me.showAgentActions();
					}
					else if (seletedNode != null && seletedNode == "common")
					{
						disObject.add({xtype:'commonsettingspanel'});
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+commonPageDisc+'</center>');
						Ext.getCmp('discoveryRightPane').setTitle(commonSettingGeneral);
						me.updateApplicationServerSettings("menu");
					}
					else if (seletedNode != null && seletedNode == "commonTCP")
					{
						disObject.add({xtype:'commonsettingspanel'});
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+commonPageDisc2+'</center>');
						Ext.getCmp('discoveryRightPane').setTitle(commonSettingTCP);
						me.updateApplicationServerSettings2("menu");
					}
					else if (seletedNode != null && seletedNode == "commonAutomanage")
					{
						disObject.add({xtype:'commonsettingspanel'});
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+commonPageDisc3+'</center>');
						Ext.getCmp('discoveryRightPane').setTitle(commonSettingAutomanage);
						me.updateApplicationServerSettings3("menu");
					}
					else if (seletedNode != null && seletedNode == "AutoDelete")
					{
						disObject.add({xtype:'autodeletesettingspanel'});
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+autodeletePageDisc+'</center>');
						Ext.getCmp('discoveryRightPane').setTitle(commonSettingAutodelete);
						me.loadAutodeleteSettings("menu");
					}
					else if (seletedNode != null && seletedNode == "Report")
					{
						disObject.add({xtype:'discoveryreport'});
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;This page enables the administrator to view the discovered components.</center>');
						Ext.getCmp('discoveryRightPane').setTitle(intnlLabel82);
					}
				},
				failure : function(response)
				{
					myMask.hide();
				}
			});
		}
	},
	showConfigPopupWindow : function()
	{
		var VWidth = Ext.Element.getViewportWidth();
		if (Ext.getCmp('discoveryConfigWin') != undefined)
		{
			Ext.getCmp('discoveryConfigWin').destroy();
		}

		container = Ext.create('Ext.container.Container',{
			padding:5,
			id : 'discoveryConfigWin',
			floating:true,
			frame:true,
			width:500,
			hidden:true,
			floatable:true,
			cls:'configMode_popup',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'468px'}
				},
				{
					xtype:'container',
					html:'<div style="float:left;margin:2px 0px 4px 4px"><b class="commonErrorMsgText" style="color:#fff !important">'+pageTitle2+'</b></div><div style="text-align:right;float:right;"><div class="iconClose3"></div></div>',
					style:{'top':'0px','margin':'2px'}
				},
				{
					xtype:'container',
					cls : 'adminHeadInfoText',
					style : {height : '48px'},
					html: '<div><div style="float:left;width:16px;height:16px;"><img src="/final/images/spacer.gif" class="alarmCritical"></div><div  style="float:left;padding-left:10px;width:95%">'+intnlLabel30+' '+intnlLabel31+'</div><div style="clear:both"></div></div>'
				}
			]
		});

		Ext.create('Ext.fx.Anim', {
			target: container,
			duration: 500,
			from: {

				left: VWidth -515,
				top:-500
			},
			to: {
			   top:40,
				left: VWidth -515
			}
		});
		container.showAt(VWidth -515,5000);

		Ext.select('.iconClose3').on('click',function(){

				Ext.create('Ext.fx.Anim', {
					target: container,
					duration: 500,
					from: {

						left: VWidth -515,
						top:50
					},
					to: {
					   top:-500,
						left: VWidth -515
					},
					callback: function(){
						container.destroy();
					}
				});

		},this);
	},
	loadVirtualData : function()
	{
		var me = this;
		var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=view&selectedNode="+selectedNodeID;
		this.updateDiscoveryTree(url);
		var serverCategory = publicJSON['virtualCategory'];
		var vCenters = publicJSON['vCenters'];
		Ext.getCmp('virtualCategory').getStore().loadRawData(serverCategory);
		Ext.getCmp('virtualCategory').setValue(Ext.getCmp('virtualCategory').getStore().getAt(0).get('valueField'));
		Ext.getCmp('action').getStore().loadRawData(vCenters);

		var vCenters = publicJSON['vCenterDetails']['deletevCenterServers'];
		if (!Ext.isEmpty(vCenters))
		{
			var value = Ext.getCmp('action').getStore().getAt(0).get('valueField');
			Ext.getCmp('action').setValue(value);
			var cols = publicJSON['vCenterDetails']['columns'];
			var gridTitle = publicJSON['vCenterDetails']['gridTitle'];
			me.getGridPanel(vCenters,cols,gridTitle);
		}
		else
		{
			var value = Ext.getCmp('action').getStore().getAt(1).get('valueField');
			Ext.getCmp('action').setValue(value);
			//var emptyMessage = publicJSON['emptyMessage'];
			//me.updateResultPaanel(emptyMessage);
			me.actionOnChange(Ext.getCmp('action'));
		}
		Ext.getCmp('discoveryRightPane').setTitle(pageTitle3);
	},
	loadAgentGeneralSettings : function()
	{
		var me = this;
		me.loadAgentDiscoerySettings();
	},
	showManagerActions : function()
	{
		var me = this;
		var cols = publicJSON['columns'];
		var gridArray = publicJSON['managerActions'];
		var tooltipMsg = publicJSON['tooltip'];
		var fieldstoStore =  new Array();
		var mainColumnsObjArray	=  new Array();
		var itemsArray	=  new Array();
		for (var key in cols)
		{
			var gridColumn = cols[key];
			fieldstoStore.push(key);
			if (key == "col2")
			{
				mainColumnsObjArray.push({
					xtype: 'checkcolumn',
					text: gridColumn,
					dataIndex: key,
					width: 150,
					sortable:false,
					menuDisabled : true,
					cls:'gridCheckbt',
					align: 'center',
					listeners : {
						'checkchange' : function(obj, rowIndex, checked, eOpts ) {
							if (checked == true)
							{
								Ext.MessageBox.confirm({
									title : 'Confirm',
									msg: confirmMsgMgrEnable,
									icon : 'iconConfirmation',
									width : 400,
									buttons: Ext.Msg.YESNO,
									fn : function(btn){
										if (btn == "yes")
										{
											managerDiscoveryUI = "yes";
											Ext.Msg.show({
												title: pageTitle4,
												msg: intnlLabel32,
												width : 450,
												buttons: Ext.Msg.OK,
												icon: 'iconInformation',
												fn : function(btn){
													me.changeManagerDiscoverySettings(checked);
												}
											});
										}
										else
										{
											me.showManagerActions();
										}
									}
								});
							}
							else
							{
								Ext.MessageBox.confirm({
									title : 'Confirm',
									msg: confirmMsgMgrDisable,
									icon : 'iconConfirmation',
									width : 400,
									buttons: Ext.Msg.YESNO,
									fn : function(btn){
										if (btn == "yes")
										{
											managerDiscoveryUI = "no";
											Ext.Msg.show({
												title: pageTitle4,
												msg: intnlLabel33,
												width : 450,
												buttons: Ext.Msg.OK,
												icon: 'iconInformation',
												fn : function(btn){
													me.changeManagerDiscoverySettings(checked);
												}
											});
										}
										else
										{
											me.showManagerActions();
										}
									}
								});
							}
						}
					}
				});
			}
			else
			{
				mainColumnsObjArray.push({
					header: gridColumn,
					sortable:false,
					menuDisabled : true,
					dataIndex: key,
					align:'left',
					flex:1,
				});
			}
		}
		var gridpanel = Ext.widget('discoverydetailsgrid',{
			store:new Ext.data.Store({
				fields: fieldstoStore,
				data: gridArray
			}),
			sortableColumns:false,
			columns:mainColumnsObjArray,
			hideHeaders : false,
			viewConfig: {
				forceFit: true,
				stripeRows : false
			},
			//margin : '15 20 0 20'
		});
		var resultPanelObj = Ext.getCmp('actionContainer');
		resultPanelObj.removeAll();
		resultPanelObj.add(gridpanel);
		resultPanelObj.doLayout();
		Ext.getCmp('discoveryRightPane').setTitle(pageTitle4);
	},
	showAgentActions : function()
	{
		var me = this;
		var cols = publicJSON['columns'];
		var gridArray = publicJSON['agentActions'];
		var fieldstoStore =  new Array();
		var mainColumnsObjArray	=  new Array();
		var itemsArray	=  new Array();
		for (var key in cols)
		{
			var gridColumn = cols[key];
			fieldstoStore.push(key);
			if (key == "col3")
			{
				mainColumnsObjArray.push({
					header: '',
					sortable:false,
					menuDisabled : true,
					hidden :true,
					dataIndex: key,
				});
			}
			else if (key == "col2")
			{
				mainColumnsObjArray.push({
					xtype: 'checkcolumn',
					text: gridColumn,
					dataIndex: key,
					width: 150,
					sortable:false,
					menuDisabled : true,
					align: 'center',
					listeners : {
						'checkchange' : function(obj, rowIndex, checked, eOpts ) {
							var activityType = Ext.getCmp('discoverydetailsgrid').getStore().getAt(rowIndex).get('col3');
							var desc = '';
							if (activityType == 'agent')
							{
								desc = "Agent";
							}
							else
							{
								desc = "Topology";
							}

							if (checked == true)
							{
								Ext.MessageBox.confirm({
									title : 'Confirm',
									msg: confirmMsgAgtEnable + " "+ desc+ " discovery?",
									icon : 'iconConfirmation',
									width : 400,
									buttons: Ext.Msg.YESNO,
									fn : function(btn){
										if (btn == "yes")
										{
											Ext.Msg.show({
												title: pageTitle4,
												msg: desc+" discovery is currently enabled for your environment.",
												width : 450,
												buttons: Ext.Msg.OK,
												icon: 'iconInformation',
												fn : function(btn){
													me.changeAgentDiscoverySettings(activityType,checked);
												}
											});
										}
										else
										{
											me.showAgentActions();
										}
									}
								});
							}
							else
							{
								Ext.MessageBox.confirm({
									title : 'Confirm',
									msg: confirmMsgAgtDisable + " "+ desc+ " discovery?",
									icon : 'iconConfirmation',
									width : 400,
									buttons: Ext.Msg.YESNO,
									fn : function(btn){
										if (btn == "yes")
										{
											Ext.Msg.show({
												title: pageTitle4,
												msg: desc+" discovery is currently disabled for your environment.",
												width : 450,
												buttons: Ext.Msg.OK,
												icon: 'iconInformation',
												fn : function(btn){
													me.changeAgentDiscoverySettings(activityType,checked);
												}
											});
										}
										else
										{
											me.showAgentActions();
										}
									}
								});
							}
						}
					}
				});
			}
			else
			{
				mainColumnsObjArray.push({
					header: gridColumn,
					sortable:false,
					menuDisabled : true,
					dataIndex: key,
					align:'left',
					flex:1,
				});
			}
		}
		var gridpanel = Ext.widget('discoverydetailsgrid',{
			store:new Ext.data.Store({
				fields: fieldstoStore,
				data: gridArray
			}),
			sortableColumns:false,
			columns:mainColumnsObjArray,
			hideHeaders : false,
			viewConfig: {
				forceFit: true,
				stripeRows : false
			},
			//margin : '15 20 0 20'
		});
		var resultPanelObj = Ext.getCmp('actionContainer');
		resultPanelObj.removeAll();
		resultPanelObj.add(gridpanel);
		Ext.getCmp('discoveryRightPane').setTitle(pageTitle7);
	},
	refreshWindow:function()
	{
		var compsObj = Ext.getCmp('c_types');
		compsObj.getStore().loadRawData(publicJSON['generalSettings']['c_types']);
		compsObj.setValue(publicJSON['generalSettings']['seletedServerList']);

		var compsObj2 = Ext.getCmp('c_types2');
		compsObj2.getStore().loadRawData(publicJSON['generalSettings']['c_types2']);
		compsObj2.setValue(publicJSON.generalSettings.selectedAutomanageSrvrsList);

		var selectedServerListGridObj = Ext.getCmp('selectedServerListGrid');
		selectedServerListGridObj.getStore().loadRawData(publicJSON['generalSettings']['configuredServersList']);
		selectedServerListGridObj.doLayout();
		selectedServerListGridObj.view.refresh();
	},
	changeManagerDiscoverySettings : function(actionValue)
	{
		var optVal;
		if (actionValue == true)
		{
			optVal = "Enabled";
		}
		else
		{
			optVal = "Disabled";
		}

		var me = this;
		var defaultUrl = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=EnableDisableDiscovery&updateValue=yes&discovery_val="+optVal+"&selectedNode="+selectedNodeID;
		Ext.Ajax.request({
			url : defaultUrl,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				me.showManagerActions();
			}
		});
	},
	changeAgentDiscoverySettings : function(type,actionValue)
	{
		var optVal;
		if (actionValue == true)
		{
			optVal = "enable";
		}
		else
		{
			optVal = "disable";
		}
		var me = this;
		var defaultUrl = "EgServerDiscovery/data/EgAgentDiscoverJson.jsp?from=Actions&validate="+type+"&action="+optVal+"&selectedNode="+selectedNodeID;
		Ext.Ajax.request({
			url : defaultUrl,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				me.showAgentActions();
			}
		});
	},
	loadTreeData : function()
	{
		var discoveryTree = Ext.getCmp('discoverytree');
		Ext.Ajax.request({
			url : 'EgServerDiscovery/data/EgLeftDiscoveryPaneJson.jsp?linkFrom='+selectedNodeID,
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				if( !Ext.isEmpty(jsonText))
				{
					var jsonData = Ext.decode(jsonText);
					jsonData["expanded"] = true;
					discoveryTree.setRootNode(jsonData);

					var record = discoveryTree.getStore().getNodeById(selectedNodeID);
					discoveryTree.getSelectionModel().select(record);

					Ext.get('Expand').on('click', function(event, target, options)
					{
						var obj = Ext.getCmp('Expand');
						if (obj.currentStatus == "expanded")
						{
							obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px" id="exx">'+expandAll+'</div>');
							obj.currentStatus = "collapse";
							Ext.getCmp('discoverytree').collapseAll();
						}
						else
						{
							obj.currentStatus = "expanded";
							obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px" id="exx">'+collapseAll+'</div>');
							Ext.getCmp('discoverytree').expandAll();
						}
					});
				}
			},
			failure : function(response, opts){
			}
		});
	},
	onExpandAllClick: function(obj){
		if (obj.currentStatus == "expanded")
		{
			obj.setText('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px" id="exx">'+expandAll+'</div>');
			obj.currentStatus = "collapse";
			Ext.getCmp('discoverytree').collapseAll();
		}
		else
		{
			obj.currentStatus = "expanded";
			obj.setText('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px" id="exx">'+collapseAll+'</div>');
			Ext.getCmp('discoverytree').expandAll();
		}
	},
	getErrorMessageTemplate :function(tmpObj)
	{
		var me = this;
		var tmpTable = "";
		if (tmpObj.allow != null && tmpObj.allow !== undefined && tmpObj.allow == true)
		{
			tmpTable = "";
			for (var key in tmpObj)
			{
				if (key == "title" || key == "allow") continue ;
				var errorMessage = tmpObj[key];
				tmpTable = tmpTable + errorMessage;
			}
		}
		else
		{
			tmpTable = '<div class="x-table" style="width:100%"><table cellspacing="0" style="width:100%;border:1px solid #c3c3c3" cellpadding="5" border="0" align="center"><thead><tr class="x-grid-row"><th style="width:100%" class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">Error : '+errorReason+'</div></td></tr></thead>'
			for (var key in tmpObj)
			{
				if (key == "title") continue ;
				var errorMessage = tmpObj[key];
				tmpTable = tmpTable + '<tr class="x-grid-row"><td style="width:100%" class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner" >'+errorMessage+'</div></td></tr>';
			}
			tmpTable = tmpTable + '</table></div>';
		}
		return tmpTable;
	},
	updateServerDetails : function()
	{
		var me = this;
		var validationStatus = this.updateDiscSettings();
		if (validationStatus == true)
		{
			var ipr = Ext.getCmp('iprange').getValue();
			iprange = ipr;
			if (ipr.indexOf(":") != -1)
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: intnlLabel28,
					buttons: Ext.Msg.OK,
					icon : 'iconExclamation',
					fn : function(btn)
					{
						if (btn == "ok")
						{
							me.updateManagerDiscoverySettings();
						}
					}
				});
			}
			else
			{
				me.updateManagerDiscoverySettings();
			}
		}
	},
	updateManagerDiscoverySettings : function()
	{
		var me = this;

		var hiddenFields = this.getHiddenFields();
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var discoverypane = this.getDiscoverypane().getForm();
		if (discoverypane.isValid())
		{
			this.getDiscoverypane().submit({
				url: 'EgServerDiscovery/data/EgchangeportspJson.jsp?from=changeSettings&'+hiddenFields,
				method: 'POST',
				//standardSubmit: true,
				success: function(form, action){
					myMask.hide();
					var resultObj = Ext.decode(action.response.responseText);
					if (resultObj.requestStatus == "success")
					{
						//Ext.Msg.show(resultObj.result.title,resultObj.result.message1);
						Ext.Msg.show({
							title:resultObj.result.title,
							msg: resultObj.result.message1 + '. Would you like to start manager discovery?',
							buttons: Ext.Msg.YESNO,
							scope : me,
							icon : 'iconInformation',
							fn : me.showManagerAction
						});
					}
					else
					{
						var tmpObj = resultObj.errors;
						//var errorText = me.getErrorMessageTemplate(tmpObj);
						//Ext.Msg.show(tmpObj.title,errorText);
						Ext.Msg.show({
							title:tmpObj.title,
							msg: tmpObj.message1 + ".",
							buttons: Ext.Msg.OK,
							width : 400,
							icon : 'iconError'
						});
					}
				},
				failure: function(form, action) // if result page doest not return success:true, this method fires
				{
					myMask.hide();
					//console.log(action.response.responseText);
				}
			});
		}
	},
	showManagerAction : function(btn)
	{
		var me = this;
		if (btn == 'yes')
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();
			Ext.Ajax.request({
				url : 'EgServerDiscovery/data/EgConfigEnvJson.jsp?startDiscThread=yes&executeAction=New&selectedNode=node1',
				method : 'POST',
				success : function(response, opts)
				{
					myMask.hide();
					publicJSON = Ext.decode(response.responseText);
					var discoveryTree = Ext.getCmp('discoverytree');
					var record = discoveryTree.getStore().getNodeById("node5");
					discoveryTree.getSelectionModel().select(record);

					var disObject = Ext.getCmp('discoveryRightPane');
					disObject.removeAll();
					disObject.add({xtype:'egconfigenvformcontainer',border : false});
					Ext.getCmp('discoveryRightPane').setTitle(pageTitle8);
					Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+manageCompDisc+'</center>');
					isDiscState = true;
					refreshOnDiscAlive();
					if (managerDiscoveryUI == "no")
					{
						me.showConfigPopupWindow();
					}
					if (automanageConfig.toLowerCase() == "yes" && managerDiscoveryUI == "yes")
					{
						me.showNotificationWindow();
					}
				}
			});
		}
	},
	showComponentSelector : function()
	{
		var seletectedServers = publicJSON['generalSettings']['seletedServerList'];
		var cloneStore = Ext.getCmp('c_types').getStore();
		var expandWindow = Ext.create('Ext.window.Window',{
				title:'Components',
				width:600,
				height:300,
				doClose: function() {
					this.destroy();
				},
				buttonAlign:'center',
				items:[
					{
						//xtype:'panel',
						//cls:'multiselect',
						//height:230,
						//width: 580,
						//autoScroll:true,
						//scroll:true,
						//items:[
						//	{
								xtype: 'multiselectfield',
								autoScroll:true,
								scroll:true,
								name: 'multiselect',
								id: 'componentsClone',
								name: 'componentsClone',
								store:cloneStore,
								value: Ext.getCmp('c_types').getValue(),
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local',
								width: 580,
								height:230
						//	}
						//]
					}
				],
				buttons:[
					{
						text:'Select',
						id: 'expand',
						cls:'button20',
						name: 'expand',
						handler: function()
						{
							if ( Ext.getCmp('componentsClone').getValue() != '' )
							{
								var selectedList = Ext.getCmp('componentsClone').getValue();
								Ext.getCmp('c_types').setValue(selectedList);
								var tmpHTML = (selectedList.length > 1?selectedList[0] +", "+selectedList[1]:selectedList[0])+" <span id='moreComp'  title='Show more selected components' style='cursor:pointer;'><a href='javascript:void(0)' onclick='javascript:showMoreSelectedComps()'  class='more_link'>...</a></span>";
								Ext.getCmp('compViewPanel').update(tmpHTML);
								expandWindow.destroy();
							}
							else
							{
								Ext.MessageBox.show({
									title: 'Alert',
									msg: 'Please choose a component type',
									buttons: Ext.MessageBox.OK,
									icon: 'iconExclamation'
								});
								return;
							}
						}
					}
				]
		}).show();
	},
	showPortSelector : function(btn)
	{
		var tmpObject = Ext.getCmp("serverPorts");
		if (tmpObject.isHidden())
		{
			tmpObject.show();
			btn.setText("Hide Ports");
		}
		else
		{
			tmpObject.hide();
			btn.setText("Show Ports");
		}
	},
	/*getHiddenFields : function()
	{
		hiddenQstr = "";
		var hiddenFields = publicJSON['hiddenFields'];
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},*/
	getGridPanel : function(gridArray,cols,gridTitle)
	{
		var fieldstoStore =  new Array();
		var mainColumnsObjArray	=  new Array();
		var itemsArray	=  new Array();

		for (var key in cols)
		{
			var gridColumn = cols[key];
			fieldstoStore.push(key);
			if(key == 'User')
			{
				mainColumnsObjArray.push({
					header: gridColumn,
					sortable:true,
					tdCls:'wrap-text' ,
					dataIndex: key,
					flex:1
				});
			}
			else
			{
				mainColumnsObjArray.push({
					header: gridColumn,
					sortable:true,
					dataIndex: key,
					flex:1
				});
			}
		}
		var gridpanel = Ext.widget('discoverydetailsgrid',{
			store:new Ext.data.Store({
				fields: fieldstoStore,
				data: gridArray
			}),
			sortableColumns:true,
			columns:mainColumnsObjArray,
			title:gridTitle,
			viewConfig: {
				forceFit: true,
				stripeRows : false
			},
			width : '90%'
		});
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		resultPanelObj.add(gridpanel);
		resultPanelObj.show();
	},
	getEditableGridPanel : function(gridArray,cols,gridTitle)
	{
		var fieldstoStore =  new Array();
		var mainColumnsObjArray	=  new Array();
		var itemsArray	=  new Array();

		for (var key in cols)
		{
			var gridColumn = cols[key];
			if (key == "delOption")
			{
				fieldstoStore.push(gridColumn);
				mainColumnsObjArray.push({
					header: '<input type="checkbox" class="checkbt" name="severName" value="1"/>',
					sortable:false,
					hideable: false,
					menuDisabled : true,
					dataIndex: key,
					align:'center',
					flex:1,
					renderer: function(value, metaData, record, row, col, store, gridView)
					{
						return '<input type="checkbox" name="severName" value="1"/>';
					}
				});
			}
			else
			{
				fieldstoStore.push(gridColumn);
				mainColumnsObjArray.push({
					header: gridColumn,
					sortable:true,
					dataIndex: key,
					//align:'center',
					flex:1,
					renderer: function(value, metaData, record, row, col, store, gridView)
					{
						return value;
					}
				});
			}
		}
		var gridpanel = Ext.widget('discoverydetailsgrid',{
			store:new Ext.data.Store({
				fields: fieldstoStore,
				data: gridArray
			}),
			sortableColumns:true,
			columns:mainColumnsObjArray,
			bodyPadding:'0 0 20 0',
			title:gridTitle,
			viewConfig: {
				forceFit: true,
				stripeRows : false
			}
		});
		itemsArray.push(gridpanel);
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.show();
		resultPanelObj.removeAll();
		resultPanelObj.add(gridpanel);
		resultPanelObj.add(this.getButton());
	},
	getEditableGridPanel2 : function(gridArray,cols,gridTitle)
	{
		var fieldstoStore =  new Array();
		var mainColumnsObjArray	=  new Array();
		var itemsArray	=  new Array();
		var vCenterConfiguredObj = publicJSON['vCenterConfiguredObj'];

		for (var key in cols)
		{
			var gridColumn = cols[key];
			if (key == "delOption")
			{
				fieldstoStore.push(key);
				mainColumnsObjArray.push({
					dataIndex: key,
					hidden: true,
					sortable:false,
					flex:1,
					menuDisabled : true,
				});
			}
			else
			{
				fieldstoStore.push(key);
				mainColumnsObjArray.push({
					header: gridColumn,
					sortable:false,
					menuDisabled : true,
					dataIndex: key,
					flex:1
				});
			}
		}
		var gridpanel = Ext.widget('discoverydetailsgrid',{
			store:new Ext.data.Store({
				fields: fieldstoStore,
				data: gridArray
			}),
			selModel :new Ext.selection.CheckboxModel(
			{
				checkOnly: true,
				cls:'checkbt',
				style:{'padding':'3px 0px 3px 0px !important'},
				injectCheckbox: 'first',
				renderer : function(val, meta, record, rowIndex, colIndex, store,view)
				{
					var vCenterName = record.get('vCenter IP/Host');
					var isDisabled = false;
					if (!Ext.isEmpty(vCenterConfiguredObj) && !Ext.isEmpty(vCenterName) && vCenterConfiguredObj[vCenterName])
					{
						isDisabled = true;
					}

					if( isDisabled )
					{
						meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
						return '<img src="/final/images/spacer.gif" class="iconLock"  style="margin-left:-5px;width:16px;height:16px;"/>';
					}
					else
					{
						meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
						return '<img src="/final/images/spacer.gif" class="' + Ext.baseCSSPrefix + 'grid-row-checker"/>';
					}
				}

			}),
			listeners : {
				beforeselect: function(selModel, record, index) {

					var vCenterName = record.get('vCenter IP/Host');
					if (!Ext.isEmpty(vCenterConfiguredObj) && !Ext.isEmpty(vCenterName) && vCenterConfiguredObj[vCenterName])
					{
						return false;
					}
				},
				rowclick : function (in_this, rowIndex, e) 
				{
					var record = in_this.getStore().getAt(rowIndex);
					var vCenterName = record.get('vCenter IP/Host');
					if (!Ext.isEmpty(vCenterConfiguredObj) && !Ext.isEmpty(vCenterName) && vCenterConfiguredObj[vCenterName])
					{
						in_this.getSelectionModel().deselectRow(rowIndex);
					}
				}
			},
			sortableColumns:true,
			columns:mainColumnsObjArray,
			title:gridTitle,
			viewConfig: {
				forceFit: true,
				stripeRows : false
			},
			width : '90%'
		});
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.show();
		resultPanelObj.removeAll();
		resultPanelObj.add(gridpanel);
		resultPanelObj.add(this.getButton());
	},
	getButton : function()
	{
		var me = this;
		var selectVType;
		if (Ext.getCmp('virtualCategory') != null && Ext.getCmp('virtualCategory') != undefined)
		{
			selectVType = Ext.getCmp('virtualCategory').getValue();
		}
		else if(Ext.getCmp('cloudaction') != null && Ext.getCmp('cloudaction') != undefined)
		{
			selectVType = "cloudDelete";
		}
		else if(Ext.getCmp('netscaleraction') != null && Ext.getCmp('netscaleraction') != undefined)
		{
			selectVType = "NetScaler";
		}
		else if(Ext.getCmp('clouddirectoryaction') != null && Ext.getCmp('clouddirectoryaction') != undefined)
		{
			selectVType = "CloudDirector";
		}
		else if(Ext.getCmp('storagePlatformAction') != null && Ext.getCmp('storagePlatformAction') != undefined)
		{
			selectVType = "StoragePlatform";
		}
		else if(Ext.getCmp('rabbitMQAction') != null && Ext.getCmp('rabbitMQAction') != undefined)
		{
			selectVType = "RabbitMQ";
		}

		var tmpBtn = {
			xtype : 'container',
			layout : {
				type: 'vbox',
				align : 'center',
				pack : 'center',
				padding : '10 0 0 0'
			},
			items : [
				{
					xtype:'button',
					text: 'Delete',
					cls: 'button20',
					width : 80,
					handler : function(obj)
					{
						obj.setDisabled(true);
						me.deleteSelectedServers(selectVType);
						obj.setDisabled(false);
					}
				}
			]
		};
		return tmpBtn;
	},
	deleteSelectedServers : function(selectVType)
	{
		var me = this;
		var strServers = me.getSelectedServers();
		if (strServers == '' || strServers.length == 0)
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: validationMsg63 + ".",
				buttons: Ext.Msg.OK,
				icon : 'iconExclamation'
			});
			return false;
		}
		else
		{
			var urlStr = '';
			var confirmMsg = '';
			if (selectVType == "cloudDelete")
			{
				urlStr = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=cloudDelete&account="+encodeURIComponent(strServers);
				confirmMsg = validationMsg66;
			}
			else if (selectVType == "vCenters")
			{
				urlStr = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=delete&vc="+encodeURIComponent(strServers);
				confirmMsg = validationMsg64;
			}
			else if (selectVType == "HMCs")
			{
				urlStr = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=hmcDelete&hmc="+encodeURIComponent(strServers);
				confirmMsg = validationMsg65;
			}
			else if (selectVType == "RHEV")
			{
				urlStr = "EgServerDiscovery/data/EgRHEVdiscoverypJson.jsp?from=rhevDelete&rhev="+strServers;
				confirmMsg = validationMsg67;
			}
			else if (selectVType == "NetScaler")
			{
				urlStr = "EgServerDiscovery/data/EgNetScalerJsonp.jsp?from=delNetScaler&netScalers="+strServers;
				confirmMsg = validationMsg94;
			}
			else if (selectVType == "Nutanix")
			{
				urlStr = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=nutanixDelete&nutanix="+encodeURIComponent(strServers);
				confirmMsg = validationMsg98;
			}
			else if (selectVType == "CtxXenPool")
			{
				urlStr = "EgServerDiscovery/data/EgCtxXenPoolDiscoverypJson.jsp?from=ctxXenPoolDelete&ctxXenPool="+encodeURIComponent(strServers);
				confirmMsg = validationMsg102;
			}
			else if (selectVType == "OracleVM")
			{
				urlStr = "EgServerDiscovery/data/EgOracleVmManagerDiscoverypJson.jsp?from=oracleVMDelete&oracleVM="+encodeURIComponent(strServers);
				confirmMsg = validationMsg118;
			}
			else if (selectVType == "CloudDirector")
			{
				urlStr = "EgServerDiscovery/data/EgCloudDirectoryJsonp.jsp?from=delvClouds&vclouds="+strServers;
				confirmMsg = validationMsg105;
			}
			else if (selectVType == "StoragePlatform")
			{
				urlStr = "EgServerDiscovery/data/EgstorageplatformpJson.jsp?from=delStoragePlatform&xmsIps="+strServers;
				confirmMsg = validationMsg108;
			}
			else if (selectVType == "RabbitMQ")
			{
				urlStr = "EgServerDiscovery/data/EgrabbitmqnodepJson.jsp?from=deleteRabbitMQ&rabbitMQIPs="+strServers;
				confirmMsg = validationMsg112;
			}

			Ext.MessageBox.confirm({
				title : 'Confirm',
				msg: confirmMsg,
				icon : 'iconConfirmation',
				width : 400,
				buttons: Ext.Msg.YESNO,
				fn : function(btn){
					if (btn == "yes")
					{
						var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Deleting...'});
						myMask.show();
						Ext.Ajax.request({
							url : urlStr,
							method : 'POST',
							success: function(response){
								myMask.hide();
								var resultObj = Ext.decode(response.responseText);
								if (resultObj.requestStatus == "success")
								{
									var tmpObj = resultObj.result;
									Ext.Msg.show({
										title: tmpObj.title,
										msg: tmpObj.message1 + ".",
										buttons: Ext.Msg.OK,
										icon : 'iconInformation'
									});
								}
								else
								{
									var tmpObj = resultObj.errors;
									//var errorText = me.getErrorMessageTemplate(tmpObj);
									//Ext.Msg.show(tmpObj.title,errorText);
									Ext.Msg.show({
										title: tmpObj.title,
										msg: tmpObj.message1 + ".",
										buttons: Ext.Msg.OK,
										width : 400,
										icon : 'iconError'
									});
								}

								if (selectVType == "cloudDelete")
								{
									me.deleteCloudDetails();
								}
								else if (selectVType == "vCenters")
								{
									me.deleteVCenterDetails();
								}
								else if (selectVType == "HMCs")
								{
									me.deleteHMCsDetails();
								}
								else if (selectVType == "RHEV")
								{
									me.deleteRHEVDetails();
								}
								else if (selectVType == "NetScaler")
								{
									me.deleteNetScalersDetails();
								}
								else if (selectVType == "Nutanix")
								{
									me.deleteNutanixDetails();
								}
								else if (selectVType == "CtxXenPool")
								{
									me.deleteCtxXenServerPoolDetails();
								}
								else if (selectVType == "OracleVM")
								{
									me.deleteOracleVMDetails();
								}
								else if (selectVType == "CloudDirector")
								{
									me.deleteCloudDirectoryDetails();
								}
								else if (selectVType == "StoragePlatform")
								{
									me.deleteStoragePlatformDetails();
								}
								else if (selectVType == "RabbitMQ")
								{
									me.deleteRabbitMQDetails();
								}
							},
							failure: function(response)
							{
								myMask.hide();
							}
						});
					}
					else
					{
						return;
					}
				}
			});
		}
	},
	getSelectedServers : function()
	{
		var servers = '';
		var selectedObj = Ext.getCmp('discoverydetailsgrid').getSelectionModel();
		var gridStore = Ext.getCmp('discoverydetailsgrid').getStore();
		for ( var i = 0;i<gridStore.getCount();i++ )
		{
			if (selectedObj.isSelected(gridStore.getAt(i)) )
			{
				var localName = gridStore.getAt(i).get('delOption');
				servers = servers + localName + ",";
			}
		}
		return servers;
	},
	updateDiscoveryTree : function(defaultUrl)
	{
		Ext.Ajax.request({
			url : defaultUrl,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	updateViewRemoteAgentMapping : function(defaultUrl)
	{
		Ext.Ajax.request({
			url : defaultUrl,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicRmtAgt = Ext.decode(jsonText);
			}
		});
	},
	encodeFieldParams: function(thisForm)
	{
		var encodeParams = "";
		var fieldsArr = thisForm.getFields().items;
		for(var i in fieldsArr)
		{
			var fieldParamName = fieldsArr[i].name;
			var fieldParamValue = fieldsArr[i].value;
			if (fieldParamName=="uname" || fieldParamName=="pass" )
			{
				Ext.getCmp(fieldsArr[i].id).submitValue = false;
				encodeParams += "&"+fieldParamName+"="+encodeURIComponent(filterEncode(fieldParamValue));
			}
		}
		return encodeParams;
	},
	updateVirtualServerDetails : function(url,selectedServer,isDiscovery,fromAdd)
	{
		var me = this;
		var hiddenFields = this.getHiddenFields();
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var virtualplatform = this.getVirtualplatform().getForm();
		if (virtualplatform.isValid())
		{
			this.getVirtualplatform().submit({
				url: url+'&'+hiddenFields,
				method: 'POST',
				params: appCnt.encodeFieldParams(virtualplatform),
				timeout:300,
				//standardSubmit: true,
				success: function(form, action){
					myMask.hide();
					//alert(action.response.responseText);
					//me.showResultWindow(action.response.responseText);
					var resultObj = Ext.decode(action.response.responseText);
					if (resultObj.requestStatus == "success")
					{
						if (isDiscovery == true)
						{
							var myMask1 = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
							myMask1.show();
							Ext.Ajax.request({
								url : 'EgServerDiscovery/data/EgConfigEnvJson.jsp?startDiscThread=false&executeAction=New&selectedNode=node1',
								method : 'POST',
								success : function(response, opts)
								{
									myMask1.hide();
									publicJSON = Ext.decode(response.responseText);
									var discoveryTree = Ext.getCmp('discoverytree');
									var record = discoveryTree.getStore().getNodeById("node5");
									discoveryTree.getSelectionModel().select(record);

									var disObject = Ext.getCmp('discoveryRightPane');
									disObject.removeAll();
									disObject.add({xtype:'egconfigenvformcontainer',border : false});
									Ext.getCmp('discoveryRightPane').setTitle(pageTitle8);
									Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+manageCompDisc+'</center>');
									isDiscState = true;
									refreshOnDiscAlive();
									//if (automanageConfig.toLowerCase() == "yes")
									//{
									//	me.showNotificationWindow();
									//}
								}
							});
						}
						else
						{
							var tmpObj = resultObj.result;
							Ext.Msg.show({
								title: tmpObj.title,
								msg: tmpObj.message1 + ".",
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation'
							});
							if (fromAdd == true)
							{
								me.clearForm();
							}
						}
					}
					else
					{
						var tmpObj = resultObj.errors;
						//var errorText = me.getErrorMessageTemplate(tmpObj);
						Ext.Msg.show({
							title: tmpObj.title,
							msg: tmpObj.message1,
							buttons: Ext.Msg.OK,
							icon: 'iconError'
						});
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					//console.log(action.response.responseText);
				}
			});
		}
	},
	getSeletedAction : function()
	{
		var tmpVirtualObj = Ext.getCmp('virtualCategory');
		var selectedAction = Ext.getCmp('action');
		var act = selectedAction.getValue() + tmpVirtualObj.getValue();
		return act;
	},
	loadGeneralSettings : function()
	{
		var me = this;
		var ADDiscovery = publicJSON['generalSettings']['ADDiscovery'];
		var iprange = publicJSON['generalSettings']['iprange'];
		var disctimeout = publicJSON['generalSettings']['disctimeout'];
		var selectedDisctimeout = publicJSON['generalSettings']['selectedDisctimeout'];
		var icmp = publicJSON['generalSettings']['icmp'];
		var period = publicJSON['generalSettings']['period'];
		var selectedPeriodIndex = publicJSON['generalSettings']['selectedPeriodIndex'];
		var dhcp = publicJSON['generalSettings']['dhcp'];
		var Community = publicJSON['generalSettings']['Community'];
		var rediscoverDeletedComponents = publicJSON['generalSettings']['rediscoverDeletedComponents'];

		if (ADDiscovery != null && ADDiscovery != 'undefined' && ADDiscovery == "yes")
		{
			Ext.getCmp("disoverDomain").setValue(true);
		}
		if (!Ext.isEmpty( iprange ))
		{
			Ext.getCmp("iprange").setValue(iprange);
		}
		Ext.getCmp('disctimeout').getStore().loadRawData(disctimeout);
		if (selectedDisctimeout != null && selectedDisctimeout != 'undefined' && selectedDisctimeout == "LAN")
		{
			Ext.getCmp('disctimeout').setValue("250");
		}
		else
		{
			Ext.getCmp('disctimeout').setValue("2000");
		}

		if (icmp != null && icmp != 'undefined' && icmp.toLowerCase() == "yes")
		{
			Ext.getCmp("icmpEnbaled").setValue(true);
		}
		else
		{
			Ext.getCmp("icmpDisabled").setValue(true);
		}

		var periodObj = Ext.getCmp('period');
		periodObj.suspendEvents(true);
		periodObj.getStore().loadRawData(period);
		periodObj.setValue(selectedPeriodIndex);
		periodObj.resumeEvents();

		//if (dhcp.toLowerCase() == "yes")
		//{
		//	Ext.getCmp("dhcpEnbaled").setValue(true);
		//}
		//else
		//{
		//	Ext.getCmp("dhcpDisabled").setValue(true);
		//}

		if (rediscoverDeletedComponents.toLowerCase() == "yes" || rediscoverDeletedComponents.toLowerCase() == "true")
		{
			Ext.getCmp("rediscoverYes").setValue(true);
		}
		else
		{
			Ext.getCmp("rediscoverNo").setValue(true);
		}

		var DiscoverySNMPVersion = publicJSON.generalSettings.DiscoverySNMPVersion;
		var dataOverTcp = publicJSON.generalSettings.dataOverTcp;
		if (dataOverTcp != null && dataOverTcp != undefined && dataOverTcp.toLowerCase() == "yes")
		{
			Ext.getCmp('dataOverTcpYes').setValue(true);
		}
		else
		{
			Ext.getCmp('dataOverTcpNo').setValue(true);
		}

		Ext.suspendLayouts();
		Ext.getCmp('snmpversion').setValue(DiscoverySNMPVersion);
		if (DiscoverySNMPVersion != undefined && DiscoverySNMPVersion == "v3")
		{
			Ext.getCmp('snmpv3Config').show();
			Ext.getCmp('snmpVersionConfig').hide();
			Ext.getCmp('snmpMgrContext').setValue(publicJSON.generalSettings.snmpMgrContext);
			Ext.getCmp('snmpMgrUserNameAdd').setValue(publicJSON.generalSettings.snmpUserName);
			Ext.getCmp('snmpMgrAuthPwdAdd').setValue(publicJSON.generalSettings.SnmpUserPass);
			Ext.getCmp('snmpMgrAuthConPwdAdd').setValue(publicJSON.generalSettings.SnmpUserPass);
			Ext.getCmp('snmpauthtypecomboadd').setValue(publicJSON.generalSettings.snmpAuthType);
			var encType = publicJSON.generalSettings.encType;
			if (encType.toLowerCase() == "yes")
			{
				Ext.getCmp('encryptradioYesAdd').setValue(true);
				Ext.getCmp('snmpMgrEncryptTypeComboAdd').setValue(publicJSON.generalSettings.snmpEncAuth);
				Ext.getCmp('snmpMgrEncryptPwdAdd').setValue(publicJSON.generalSettings.SnmpUserPass);
				Ext.getCmp('snmpMgrEncryptConPwdAdd').setValue(publicJSON.generalSettings.snmpEncPass);
			}
			else
			{
				Ext.getCmp('encryptradioNoAdd').setValue(true);
				Ext.getCmp('snmpMgrEncryptTypeComboAdd').hide();
				Ext.getCmp('snmpMgrEncryptPwdAdd').hide();
				Ext.getCmp('snmpMgrEncryptConPwdAdd').hide();
				Ext.getCmp('snmpMgrEncryptPwdAdd').setValue("");
				Ext.getCmp('snmpMgrEncryptConPwdAdd').setValue("");
			}
		}
		else
		{
			Ext.getCmp('snmpv3Config').hide();
			Ext.getCmp('snmpVersionConfig').show();
		}


		Ext.getCmp("Community").setValue(Community);
//		Ext.getCmp('winuser').setValue(publicJSON['winuser']);
//		Ext.getCmp('winpass').setValue(publicJSON['winpassword']);
//		Ext.getCmp('windomain').setValue(publicJSON['windomain']);
//		Ext.getCmp('sshuser').setValue(publicJSON['sshuserName']);
//		Ext.getCmp('sshpass').setValue(publicJSON['sshpassword']);

//		if (publicJSON.isFlagEnabled.toLowerCase() == "yes")
//		{
//			Ext.getCmp('isCredentialsConfigured').getBoxes()[0].setValue(true);
//		}
//		else
//		{
//			Ext.getCmp('isCredentialsConfigured').getBoxes()[1].setValue(true);
//		}

		Ext.getCmp('discoveryRightPane').setTitle(pageTitle1);
		Ext.resumeLayouts(true);
	},
	autoDeleteComponent : function(obj)
	{
		if (obj.getValue().allowDelete == "true")
		{
			this.loadAutodeleteSettings("btnchange");
		}
		else
		{
			Ext.getCmp('mgdCompDel').hide();
			Ext.getCmp('checkTimeCt').hide();
		}
	},
	validateAutodeleteSettings : function()
	{
		var chkTimeObj = Ext.getCmp('autodeleteChkTime');
		var chkTimeVal = chkTimeObj.getValue();
		var chkTimeIntVal = parseInt(chkTimeVal);
		if(!checkblank(chkTimeVal))
		{
			Ext.Msg.alert(autoDelSetting,intnlLabel51,function(btn){
				if (btn == 'ok'){
					chkTimeObj.focus(true);
				 }
			});
			return false;
		}
		else if(checkspaceExtjs(chkTimeVal) != '0')
		{
			Ext.Msg.alert(autoDelSetting,validationMsg2,function(btn){
				if (btn == 'ok'){
					chkTimeObj.focus(true);
				 }
			});
			return false;
		}
		else if(checkSpecialExtjs(chkTimeVal,"@#$%^&*)_-+!~{}[];:.(=|\"\'<>,\/") != '0')
		{
			Ext.Msg.alert(autoDelSetting,validationMsg13,function(btn){
				if (btn == 'ok'){
					chkTimeObj.focus(true);
				 }
			});
			return false;
		}
		else if(checkAlpha(chkTimeVal))
		{
			Ext.Msg.alert(autoDelSetting,_checkAlpha,function(btn){
				if (btn == 'ok'){
					chkTimeObj.focus(true);
				}
			});
			return false;
		}
		else if(chkTimeIntVal < 8)
		{
			Ext.Msg.alert(autoDelSetting,intnlLabel52,function(btn){
				if (btn == 'ok'){
					chkTimeObj.focus(true);
				}
			});
			return false;
		}
		return true;
	},
	updateAutodeleteSettings : function()
	{
		var me = this;
		if(!me.validateAutodeleteSettings())
		{
			return false;
		}
		var autoDelOpt = Ext.getCmp('allowDelete_1').getValue();
		var mgdCmpDelOpt = Ext.getCmp('allowMgdCompDelete_1').getValue();
		var chkTimeOpt = Ext.getCmp('autodeleteChkTime').getValue();

		var $_autoDelOption = Ext.getCmp('$_autoDelOption').getValue();
		var $_mgdCompDelOpt = Ext.getCmp('$_mgdCompDelOpt').getValue();
		var $_cktTime = Ext.getCmp('$_cktTime').getValue();

		$_autoDelOption = ($_autoDelOption != null && $_autoDelOption != undefined) ? $_autoDelOption : autoDelOpt;
		$_mgdCompDelOpt = ($_mgdCompDelOpt != null && $_mgdCompDelOpt != undefined) ? $_mgdCompDelOpt : mgdCmpDelOpt;
		$_cktTime = ($_cktTime != null && $_cktTime != undefined && $_cktTime != "") ? $_cktTime : chkTimeOpt;

		var params = "autodeleteOption="+autoDelOpt+"&managedCompDel="+mgdCmpDelOpt+"&checkTime="+encodeURIComponent(chkTimeOpt)+"&$_autoDelOption="+$_autoDelOption+"&$_mgdCompDelOpt="+$_mgdCompDelOpt+"&$_cktTime="+encodeURIComponent($_cktTime);
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		Ext.Ajax.request({
			url : 'EgServerDiscovery/data/EgAutodeletepJson.jsp?from=autodeleteSettings&'+params,
			method : 'POST',
			success: function(response)
			{
				myMask.hide();
				var localJSON = Ext.decode(response.responseText);
				if(localJSON['success'] == 'true')
				{
					me.loadAutodeleteSettings("menu");
					Ext.Msg.show({
						title: 'Auto delete settings',
						msg: 'Details have been updated successfully' + ".",
						buttons: Ext.Msg.OK,
						width : 300,
						icon: 'iconInformation'
					});
				}
				else
				{
					Ext.Msg.show({
						title: 'Auto delete settings',
						msg: 'Error in details updation' + ".",
						buttons: Ext.Msg.OK,
						width : 300,
						icon: 'iconError'
					});
				}
			}
		});
	},
	loadAutodeleteSettings : function(val)
	{
		var from = val.toString().toLowerCase();
		Ext.Ajax.request({
			url : 'EgServerDiscovery/data/EgAutodeleteJson.jsp?from=autodeleteSettings&selectedNode=node15',
			success: function(response)
			{
				publicJSON = Ext.decode(response.responseText);
				var autoDeleteOptionYes = Ext.getCmp('allowDelete_1');
				var autoDeleteOptionNo = Ext.getCmp('allowDelete_2');
				var autoDeleteMgdCompYes = Ext.getCmp('allowMgdCompDelete_1');
				var autoDeleteMgdCompNo = Ext.getCmp('allowMgdCompDelete_2');
				var checkTimeContObj = Ext.getCmp('checkTimeCt');
				var checkTimeObj = Ext.getCmp('autodeleteChkTime');

				var autodelOption = (from == "menu") ? publicJSON['autodeleteOption'] : autoDeleteOptionYes.getValue();
				if(autodelOption != null && autodelOption != undefined && autodelOption == true)
				{
					autoDeleteOptionYes.setValue(true);
					autoDeleteOptionNo.setValue(false);
					Ext.getCmp('$_autoDelOption').setValue(true);
					Ext.getCmp('mgdCompDel').show();
					checkTimeContObj.show();
					if(publicJSON['managedCompDel'] == true)
					{
						autoDeleteMgdCompYes.setValue(true);
						autoDeleteMgdCompNo.setValue(false);
						Ext.getCmp('$_mgdCompDelOpt').setValue(true);
					}
					else
					{
						autoDeleteMgdCompYes.setValue(false);
						autoDeleteMgdCompNo.setValue(true);
						Ext.getCmp('$_mgdCompDelOpt').setValue(false);
					}
					checkTimeObj.setValue(publicJSON['checkTime']);
					Ext.getCmp('$_cktTime').setValue(publicJSON['checkTime']);
				}
				else
				{
					autoDeleteOptionYes.setValue(false);
					autoDeleteOptionNo.setValue(true);
					Ext.getCmp('$_autoDelOption').setValue(false);
					Ext.getCmp('mgdCompDel').hide();
					checkTimeContObj.hide();
				}
			}
		});
	},
	selectAutoManageComps : function()
	{
		Ext.Ajax.request({
			url : 'EgServerDiscovery/data/EgChangePortsJson.jsp?from=commonSettings&selectedNode=node18&LoadCount='+loadCount,
			success: function(response)
			{
				publicJSON = Ext.decode(response.responseText);
				var selectedCompListGridObj = Ext.getCmp('seletedAutomanageListGrid');
				if(selectedCompListGridObj != undefined)
				{
					selectedCompListGridObj.getStore().loadRawData(publicJSON['generalSettings']['configuredAutomanageSrvrList']);
				}
			}
		});
		var compsObj = Ext.getCmp('c_types2');
		compsObj.getStore().loadRawData(publicJSON['generalSettings']['c_types2']);
		compsObj.setValue(publicJSON.generalSettings.selectedAutomanageSrvrsList);
	},
	configureCommonSettings : function()
	{
		var me = this;
		var disObject = Ext.getCmp('discoveryRightPane');
		Ext.suspendLayouts();
		disObject.removeAll();
		disObject.add({xtype : 'commonsettingspanel'});
		Ext.resumeLayouts(true);
		Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+commonPageDisc+'</center>');
		me.updateApplicationServerSettings("menu");
	},
	updateApplicationServerSettings : function(from)
	{
		Ext.getCmp('generalCont').show();
		var discbase = publicJSON['generalSettings']['discbase'];
		var seletedDiscBase = publicJSON['generalSettings']['seletedDiscBase'];
		Ext.getCmp('discbase').getStore().loadRawData(discbase);
		Ext.getCmp('discbase').setValue(seletedDiscBase);

		var compsObj = Ext.getCmp('c_types');
		compsObj.getStore().loadRawData(publicJSON['generalSettings']['c_types']);
		compsObj.setValue(publicJSON['generalSettings']['seletedServerList']);

		var selectedServerListGridObj = Ext.getCmp('selectedServerListGrid');
		selectedServerListGridObj.show();
		selectedServerListGridObj.getStore().loadRawData(publicJSON['generalSettings']['configuredServersList']);
		
		var allowDuplicates = publicJSON['allowDuplicates'];
		if (allowDuplicates == "true")
		{
			Ext.getCmp('allowDuplicatesBox_1').setValue(true);
		}
		else
		{
			Ext.getCmp('allowDuplicatesBox_2').setValue(true);
		}
		Ext.getCmp('allowDuplicateCont').show();

		var dhcp = publicJSON['generalSettings']['dhcp'];
		if (dhcp.toLowerCase() == "yes")
		{
			Ext.getCmp("dhcpEnbaled").setValue(true);
		}
		else
		{
			Ext.getCmp("dhcpDisabled").setValue(true);
		}
		Ext.getCmp("isDHCPConfigured").show();
		var selectedDiscCompCase = publicJSON['generalSettings']['discCompUsingCase'];
		if (!Ext.isEmpty(selectedDiscCompCase))
		{
			Ext.getCmp('discCompUsingCase').setValue(selectedDiscCompCase);
		}
		else
		{
			Ext.getCmp('discCompUsingCase').setValue('Lower');
		}

		if (!Ext.isEmpty(seletedDiscBase) && seletedDiscBase == 'IP')
		{
			Ext.getCmp('discCompUsingCase').hide();
		}
		else
		{
			Ext.getCmp('discCompUsingCase').show();
		}
	},
	showActivePortsForComponents : function()
	{
		var portGridObj = Ext.getCmp('defaultServerPorts');
		var isActivePortChecked = Ext.getCmp("activePorts").getValue();
		var url = 'EgServerDiscovery/data/EgChangePortsJson.jsp?from=changePorts&selectedNode='+selectedNodeID+'&date='+new Date().getTime();
		if (isActivePortChecked)
		{
			url += '&activePorts='+isActivePortChecked;
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
		myMask.show();
		Ext.Ajax.request({
			url : url,
			method: 'POST',
			success: function(response)
			{
				myMask.hide();
				var jsonText = response.responseText;
				var publicDataJSON = Ext.decode(jsonText);
				var ports = publicDataJSON['generalSettings']['Port'];
				portGridObj.getStore().loadRawData(ports);
			}
		});
	},
	updateApplicationServerSettings2: function(from)
	{
		var isActivePortChecked = Ext.getCmp("activePorts").getValue();
		if(isActivePortChecked)
		{
			this.showActivePortsForComponents();
		}
		else
		{
			Ext.getCmp('defaultServerPorts').getStore().loadRawData(publicJSON['generalSettings']['Port']);
		}
		Ext.getCmp('defaultServerPorts').show();
	},
	updateApplicationServerSettings3: function(from)
	{
		Ext.getCmp("automanageCont").show();
		var autoManageStr = publicJSON['generalSettings']['autoManageStr'];
		var pattentype = publicJSON['generalSettings']['pattentype'];
		var wildcardpatten = publicJSON['generalSettings']['wildcardpatten'];
		var autoManageYes = Ext.getCmp("autoManageYes").getValue();
		if (autoManageYes != undefined && autoManageYes == true)
		{
			Ext.getCmp("discoveryPattenCt").show();
			this.selectAutoManageComps();
			Ext.getCmp("seletedAutomanageListGrid").show();
			Ext.getCmp("autoManageYes").setValue(autoManageYes);

			var pattenTypeVal = Ext.getCmp("pattentype").getValue();
			var wildcardpattenVal = Ext.getCmp("wildcardpatten").getValue();
			Ext.getCmp("pattentype").setValue(pattenTypeVal);
			Ext.getCmp("wildcardpatten").setValue(wildcardpattenVal);
		}
		else if (autoManageStr.toLowerCase() == "yes" || autoManageStr.toLowerCase() == "true")
		{
			Ext.getCmp("discoveryPattenCt").show();
			this.selectAutoManageComps();
			Ext.getCmp("seletedAutomanageListGrid").show();
			Ext.getCmp("autoManageYes").setValue(true);
			Ext.getCmp('pattentype').setValue(pattentype);
			Ext.getCmp('wildcardpatten').setValue(wildcardpatten);
		}
		else
		{
			Ext.getCmp("discoveryPattenCt").hide();
			Ext.getCmp("seletedAutomanageListGrid").hide();
			Ext.getCmp("autoManageNo").setValue(true);
			Ext.getCmp('pattentype').setValue(pattentype);
			Ext.getCmp('wildcardpatten').setValue(wildcardpatten);
		}
	},
	validateAutomanageSettings : function()
	{
		var autoManage = Ext.getCmp('autoManageYes').getValue();
		var wildcardpatten = Ext.getCmp('wildcardpatten');
		if (autoManage == true)
		{
			if (!checkspecialnomess(wildcardpatten.getValue(),"~!@+#$%^&()'<>[]\=_"))
			{
				Ext.Msg.show({
					title: pageTitle2,
					msg: intnlLabel25,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						wildcardpatten.focus(true);
					}
				});
				return false;
			}
			else if (wildcardpatten.getValue().indexOf("**") != -1)
			{
				Ext.Msg.show({
					title: pageTitle2,
					msg: intnlLabel26 +".",
					width : 400,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						wildcardpatten.focus(true);
					}
				});
				return false;
			}
			else if (wildcardpatten.getValue().charAt(0) == ',' || wildcardpatten.getValue().charAt(wildcardpatten.getValue().length-1) == ',')
			{
				Ext.Msg.show({
					title: pageTitle2,
					msg: intnlLabel27 +".",
					width : 400,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						wildcardpatten.focus(true);
					}
				});
				return false;
			}
		}
		return true;
	},
	validatePortSettings : function()
	{
		var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		var gridObj = Ext.getCmp("defaultServerPorts");
		var pluginObj = gridObj.getPlugin('applicationPorts');
		for(var i=0;i<gridObj.getStore().getCount();i++)
		{
			var serverportvalue = gridObj.getStore().getAt(i).get("port");
			for(var k=0;k<serverportvalue.length;k++)
			{
				if(serverportvalue.charAt(k) == ',' && serverportvalue.charAt(k + 1) == ',')
				{
					Ext.Msg.show({
						title: pageTitle2,
						msg: validationMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							if (btn == 'ok'){
								pluginObj.startEditByPosition({row : i,column : '2'});
							 }
						}
					});
					return false;
				}
				else
				{
					continue;
				}
			}

			if(!checkblank(serverportvalue))
			{
				Ext.Msg.show({
					title: pageTitle2,
					msg: validationMsg9 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						if (btn == 'ok'){
							pluginObj.startEditByPosition({row : i,column : '2'});
						}
					}
				});
				return false;
			}
			else if(!checkspace(serverportvalue))
			{
				//Ext.Msg.show(pageTitle2,validationMsg9);
				pluginObj.startEditByPosition({row : i,column : '2'});
				return false;
			}
			else if(!checkcomma(serverportvalue))
			{
				Ext.Msg.show({
					title: pageTitle2,
					msg: validationMsg10 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						if (btn == 'ok'){
							pluginObj.startEditByPosition({row : i,column : '2'});
						}
					}
				});
				return false;
			}
			else if(!checknumber("+",serverportvalue) && serverportvalue.indexOf(",") == -1)
			{
				Ext.Msg.show({
					title: pageTitle2,
					msg: validationMsg12 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						if (btn == 'ok'){
							pluginObj.startEditByPosition({row : i,column : '2'});
						}
					}
				});
				return false;
			}
			/*else if(serverportvalue.indexOf(",") == -1 && isNumber("+",serverportvalue))
			{
				if (serverportvalue > 65535)
				{
					Ext.Msg.show(pageTitle2,validationMsg11,function(btn){
						if (btn == 'ok'){
							pluginObj.startEditByPosition({row : i,column : '2'});
						 }
						});
					return false;
				}
			}*/
			else if(serverportvalue.indexOf(",") > -1)
			{
				var splittedVal = serverportvalue.split(",");
				for (n=0;n<splittedVal.length;n++)
				{
					try
					{
						var element = splittedVal[n];
						if(!checknumber("+",element))
						{
							Ext.Msg.show({
								title: pageTitle2,
								msg: validationMsg12 + ".",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn : function(btn){
									if (btn == 'ok'){
										pluginObj.startEditByPosition({row : i,column : '2'});
									}
								}
							});
							return false;
						}
						/*else
						{
							if (element > 65535)
							{
								Ext.Msg.show(pageTitle2,validationMsg11,function(btn){
									if (btn == 'ok'){
										pluginObj.startEditByPosition({row : i,column : '2'});
									 }
									});
								return false;
							}
						}*/
					}
					catch (e)
					{
						Ext.Msg.show({
							title: pageTitle2,
							msg: validationMsg11 + ".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn){
								if (btn == 'ok'){
									pluginObj.startEditByPosition({row : i,column : '2'});
								}
							}
						});
						return false;
					}
				}
			}
			else if(!checkspecialnomess(serverportvalue,splChar) && (serverportvalue != 'NULL'))
			{
				Ext.Msg.show({
					title: pageTitle2,
					msg: validationMsg13 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						if (btn == 'ok'){
							pluginObj.startEditByPosition({row : i,column : '2'});
						}
					}
				});
				return false;
			}
		}// Port validation ends

		var serverPorts = new Array();
		for(var l=0;l<gridObj.getStore().getCount();l++)
		{
			var port = gridObj.getStore().getAt(l).get("port");
			var textField = {
				xtype:'hiddenfield',
				name : 'Ports',
				value : port,
			}
			serverPorts.push(textField);
		}

		var seletectedServers = publicJSON['generalSettings']['AllPorts'];
		for (key in seletectedServers)
		{
			var valueField = seletectedServers[key]['valueField'];
			var port = seletectedServers[key]['port'];

			var txtHiddenField = {
				xtype:'hiddenfield',
				name : 'serverName',
				value : valueField
			}
			var tmpVal = valueField+"$"+port
			var hiddenField = {
				xtype:'hiddenfield',
				name : '$_Ports',
				value : tmpVal
			}
			serverPorts.push(txtHiddenField);
			serverPorts.push(hiddenField);
		}
		Ext.getCmp('serverPorts').removeAll();
		Ext.getCmp('serverPorts').add(serverPorts);
		serverPorts = new Array();
		return true;
	},
	discoveryIndexing : function(obj)
	{
		var discBase = obj.getValue();
		var dhcpEnbaled = Ext.getCmp('dhcpEnbaled').getValue();
		
		if (dhcpEnbaled)
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: intnlLabel34,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			obj.setValue("DNS");
			return;
		}

		if (iprange.indexOf(":") != -1)
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: intnlLabel29 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			obj.setValue("DNS");
		}
		if (!Ext.isEmpty(discBase) && discBase == 'IP')
		{
			Ext.getCmp('discCompUsingCase').hide();
		}
		else
		{
			Ext.getCmp('discCompUsingCase').show();
		}
	},
	isDHCPChange : function(obj)
	{
		var isDhcpYes = Ext.getCmp('dhcpEnbaled').getValue();
		if (isDhcpYes)
		{
			var discBase = Ext.getCmp('discbase').getValue(); 
			if (!Ext.isEmpty(discBase) && discBase != 'DNS')
			{
				Ext.Msg.confirm(pageTitle2, intnlLabel35, function(btn){
					if (btn == 'yes')
					{
						Ext.getCmp('discbase').setValue("DNS");
						if(Ext.getCmp('discCompUsingCase'))
						{
							Ext.getCmp('discCompUsingCase').show();
						}
					}
					else
					{
						Ext.getCmp('dhcpDisabled').setValue(true);
					}
				});
			}
			
		}
	},
	updateAppSettings : function()
	{
		var me = this;
		var autoManageValidationStatus = me.validateAutomanageSettings();
		var isActivePortChecked = Ext.getCmp("activePorts").getValue();

		if(selectedNodeID != null || selectedNodeID != undefined || selectedNodeID != "")
		{
			if(selectedNodeID == "commonTCP" || selectedNodeID == "node17")
			{
				var portValidationStatus = me.validatePortSettings();
				var gridObj = Ext.getCmp("defaultServerPorts");
				var pluginObj = gridObj.getPlugin('applicationPorts');
				var allservername = new Array();
				var allServerDetailsArr = new Array();
				var allOldServerDetailsArr = new Array();
				gridCount = gridObj.getStore().getCount();
				for(var i=0;i<gridCount;i++)
				{
					var serverportname = gridObj.getStore().getAt(i).get("valueField");
					var serverportvalue = gridObj.getStore().getAt(i).get("port");
					allservername.push(serverportname);
					var tmpVal = serverportname+"$"+serverportvalue;
					allServerDetailsArr.push(tmpVal+":");
				}
				var seletectedServers = publicJSON['generalSettings']['AllPorts'];
				if(seletectedServers != null && seletectedServers != undefined)
				{
					for (key in seletectedServers)
					{
						var valueField = seletectedServers[key]['valueField'];
						var port = seletectedServers[key]['port'];
						var tmpVal = valueField+"$"+port;
						allOldServerDetailsArr.push(tmpVal+":");
						if(isActivePortChecked && (allservername.indexOf(valueField) == -1))
						{
							allServerDetailsArr.push(tmpVal+":");
						}
					}
				}
				var commonsettingspanel = this.getCommonsettingspanel().getForm();
				var urlStr = 'EgServerDiscovery/data/EgchangeportspJson.jsp?from=commonsettings&'+'&Ports='+allServerDetailsArr+'&$_Ports='+allOldServerDetailsArr+"&selectedNodeID="+selectedNodeID+"&date="+new Date().getTime();
				if (portValidationStatus == true)
				{
					var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
					myMask.show();
					if (commonsettingspanel.isValid())
					{
						Ext.Ajax.request({
							url: urlStr, 
							method: 'POST',
							success: function(response){
								myMask.hide();
								var resultObj = Ext.decode(response.responseText);
								if (resultObj.requestStatus == "success")
								{
									//me.showActivePortsForComponents();
									Ext.Msg.show({
										title: resultObj.result.title,
										msg: resultObj.result.message1 + ".",
										buttons: Ext.Msg.OK,
										width : 300,
										icon: 'iconInformation',
										fn: function(btn){
											if(btn == "yes")
											{
												me.showActivePortsForComponents();
											}
										}
									});
									
								}
								else
								{
									var tmpObj = resultObj.errors;
									Ext.Msg.show({
										title: tmpObj.title,
										msg: tmpObj.message1 + ".",
										buttons: Ext.Msg.OK,
										width : 300,
										icon: 'iconError'
									});
								}
							},
							failure: function(form, action) {
								myMask.hide();
								switch (action.failureType) {
									case Ext.form.action.Action.CLIENT_INVALID:
										Ext.Msg.show({
											title: "Failure",
											msg: "Form fields may be submitted with invalid values.",
											buttons: Ext.Msg.OK,
											icon: 'iconError'
										});
										break;
									case Ext.form.action.Action.CONNECT_FAILURE:
										Ext.Msg.show({
											title: "Failure",
											msg: "Ajax communication failed.",
											buttons: Ext.Msg.OK,
											icon: 'iconError'
										});
										break;
									case Ext.form.action.Action.SERVER_INVALID:
										Ext.Msg.show({
											title: "Failure",
											msg: action.result.msg+".",
											buttons: Ext.Msg.OK,
											icon: 'iconError'
										});
								}
							}
						});
					}
				}
			}
			else if(selectedNodeID == "commonAutomanage" || selectedNodeID == "node18")
			{
				if (autoManageValidationStatus)
				{
					me.selectAutoManageComps();
					var autoManage = Ext.getCmp('autoManageYes').getValue();
					var pattentype = publicJSON['generalSettings']['pattentype'];
					var wildcardpatten = publicJSON['generalSettings']['wildcardpatten'];
					if(autoManage)
					{
						pattentype = Ext.getCmp('pattentype').getValue();
						wildcardpatten = Ext.getCmp('wildcardpatten').getValue();
					}
					var hiddenFields = this.getHiddenFields();
					var commonsettingspanel = this.getCommonsettingspanel().getForm();
					var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
					myMask.show();
					if (commonsettingspanel.isValid())
					{
						Ext.Ajax.request({
							url: 'EgServerDiscovery/data/EgchangeportspJson.jsp?from=commonsettings&'+hiddenFields+"&selectedNodeID="+selectedNodeID+"&autoManage="+autoManage+"&pattentype="+pattentype+"&wildcardpatten="+wildcardpatten+"&date="+new Date().getTime(),
							method: 'POST',
							success: function(response){
								myMask.hide();
								var resultObj = Ext.decode(response.responseText);
								if (resultObj.requestStatus == "success")
								{
									Ext.Msg.show({
										title: resultObj.result.title,
										msg: resultObj.result.message1 + ".",
										buttons: Ext.Msg.OK,
										width : 300,
										icon: 'iconInformation'
									});
									Ext.Ajax.request({
										url : 'EgServerDiscovery/data/EgChangePortsJson.jsp?from=commonSettings&selectedNode=node18&LoadCount='+loadCount,
										success: function(response)
										{
											publicJSON = Ext.decode(response.responseText);
											me.updateApplicationServerSettings3();
										},
										failure : function(response)
										{
										}
									});
								}
								else
								{
									var tmpObj = resultObj.errors;
									Ext.Msg.show({
										title: tmpObj.title,
										msg: tmpObj.message1 + ".",
										buttons: Ext.Msg.OK,
										width : 300,
										icon: 'iconError'
									});
								}
							},
							failure: function(form, action) {
								myMask.hide();
								switch (action.failureType) {
									case Ext.form.action.Action.CLIENT_INVALID:
										Ext.Msg.show({
											title: "Failure",
											msg: "Form fields may be submitted with invalid values.",
											buttons: Ext.Msg.OK,
											icon: 'iconError'
										});
										break;
									case Ext.form.action.Action.CONNECT_FAILURE:
										Ext.Msg.show({
											title: "Failure",
											msg: "Ajax communication failed.",
											buttons: Ext.Msg.OK,
											icon: 'iconError'
										});
										break;
									case Ext.form.action.Action.SERVER_INVALID:
										Ext.Msg.show({
											title: "Failure",
											msg: action.result.msg+".",
											buttons: Ext.Msg.OK,
											icon: 'iconError'
										});
								}
							}
						});
					}
				}
			}
			else if(selectedNodeID == "common" || selectedNodeID == "node10")
			{
				var discbase = Ext.getCmp('discbase').getValue();
				var discCompCaseObj = Ext.getCmp('discCompUsingCase');
				var discCompUsingCase = "";
				if(discCompCaseObj != undefined || discCompCaseObj != null)
				{
					discCompUsingCase = discCompCaseObj.getValue();
				}
				var dhcp = Ext.getCmp('dhcpEnbaled').getValue();
				var	allowDuplicates = Ext.getCmp('allowDuplicatesBox_1').getValue();
				var hiddenFields = this.getHiddenFields();
				var commonsettingspanel = this.getCommonsettingspanel().getForm();
				var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
				myMask.show();
				if (commonsettingspanel.isValid())
				{
					Ext.Ajax.request({
						url: 'EgServerDiscovery/data/EgchangeportspJson.jsp?from=commonsettings&'+hiddenFields+"&selectedNodeID="+selectedNodeID+"&discbase="+discbase+"&discCompUsingCase="+discCompUsingCase+"&dhcp="+dhcp+"&allowDuplicates="+allowDuplicates+"&date="+new Date().getTime(),
						method: 'POST',
						success: function(response){
							myMask.hide();
							var resultObj = Ext.decode(response.responseText);
							if (resultObj.requestStatus == "success")
							{
								Ext.Msg.show({
									title: resultObj.result.title,
									msg: resultObj.result.message1 + ".",
									buttons: Ext.Msg.OK,
									width : 300,
									icon: 'iconInformation'
								});
								Ext.Ajax.request({
									url : 'EgServerDiscovery/data/EgChangePortsJson.jsp?from=commonSettings&selectedNode=node10&LoadCount='+loadCount,
									success: function(response)
									{
										publicJSON = Ext.decode(response.responseText);
										me.updateApplicationServerSettings();
									},
									failure : function(response)
									{
									}
								});
							}
							else
							{
								var tmpObj = resultObj.errors;
								Ext.Msg.show({
									title: tmpObj.title,
									msg: tmpObj.message1 + ".",
									buttons: Ext.Msg.OK,
									width : 300,
									icon: 'iconError'
								});
							}
						},
						failure: function(form, action) {
							myMask.hide();
							switch (action.failureType) {
								case Ext.form.action.Action.CLIENT_INVALID:
									Ext.Msg.show({
										title: "Failure",
										msg: "Form fields may be submitted with invalid values.",
										buttons: Ext.Msg.OK,
										icon: 'iconError'
									});
									break;
								case Ext.form.action.Action.CONNECT_FAILURE:
									Ext.Msg.show({
										title: "Failure",
										msg: "Ajax communication failed.",
										buttons: Ext.Msg.OK,
										icon: 'iconError'
									});
									break;
								case Ext.form.action.Action.SERVER_INVALID:
									Ext.Msg.show({
										title: "Failure",
										msg: action.result.msg+".",
										buttons: Ext.Msg.OK,
										icon: 'iconError'
									});
							}
						}
					});
				}
			}
		}
		else
		{
			Ext.Msg.show("Ensure your form data is valid");
		}
	},
	loadCloudSettings : function()
	{
		var me = this;
		var cloudActionObj = Ext.getCmp('cloudaction');
		var publicClouds = publicJSON['publicClouds'];
		cloudActionObj.getStore().loadRawData(publicClouds);
		var clouds = publicJSON['cloudDetails']['cloudServers'];
		if (!Ext.isEmpty(clouds))
		{
			var value = cloudActionObj.getStore().getAt(0).get('valueField');
			cloudActionObj.setValue(value);
			var cols = publicJSON['cloudDetails']['columns'];
			var gridTitle = publicJSON['cloudDetails']['gridTitle'];
			me.getGridPanel(clouds,cols,gridTitle);
		}
		else
		{
			//var emptyMessage = publicJSON['emptyMessage'];
			//me.updateResultPaanel(emptyMessage);
			var value = cloudActionObj.getStore().getAt(1).get('valueField');
			cloudActionObj.setValue(value);
			me.loadOnCloudAction(cloudActionObj);
		}
		Ext.getCmp('discoveryRightPane').setTitle(pageTitle5);
	},
	loadNetScalerSettings : function()
	{
		var me = this;
		var netActionObj = Ext.getCmp('netscaleraction');
		var comboArray = publicJSON['mComboArray'];
		if(comboArray == null || comboArray == 'undefined')
		{
			var url = 'EgServerDiscovery/data/EgNetScalerJson.jsp?from=viewNetScalers';
			me.updateCofigData(url);
			comboArray = publicJSON['mComboArray'];
		}
		netActionObj.getStore().loadRawData(comboArray);
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.show();
		resultPanelObj.removeAll();
		var array = publicJSON['gridArray'];

		if (!Ext.isEmpty(array))
		{
			var value = netActionObj.getStore().getAt(0).get('valueField');
			netActionObj.setValue(value);
			var columns = publicJSON['columns'];
			var gridTitle = publicJSON['gridTitle'];
			me.getGridPanel(array,columns,gridTitle);
		}
		else
		{
			//var emptyMessage = publicJSON['emptyMessage'];
			//me.updateResultPaanel(emptyMessage);
			var value = netActionObj.getStore().getAt(1).get('valueField');
			netActionObj.setValue(value);
			me.loadOnNetscalerAction(Ext.getCmp('netscaleraction'));
		}
		Ext.getCmp('discoveryRightPane').setTitle(pageTitle9);
	},
	loadCloudDirectorySettings : function()
	{
		var me = this;
		var cloudDirActionObj = Ext.getCmp('clouddirectoryaction');
		var comboArray = publicJSON['mComboArray'];
		if(comboArray == null || comboArray == 'undefined')
		{
			var url = 'EgServerDiscovery/data/EgCloudDirectoryJson.jsp?from=viewvCloud';
			me.updateCofigData(url);
			comboArray = publicJSON['mComboArray'];
		}
		cloudDirActionObj.getStore().loadRawData(comboArray);
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.show();
		resultPanelObj.removeAll();

		var array = publicJSON['gridArray'];
		if (!Ext.isEmpty(array))
		{
			var value = cloudDirActionObj.getStore().getAt(0).get('valueField');
			cloudDirActionObj.setValue(value);
			var columns = publicJSON['columns'];
			var gridTitle = publicJSON['gridTitle'];
			me.getGridPanel(array,columns,gridTitle);
		}
		else
		{
			//var emptyMessage = publicJSON['emptyMessage'];
			//me.updateResultPaanel(emptyMessage);
			var value = cloudDirActionObj.getStore().getAt(1).get('valueField');
			cloudDirActionObj.setValue(value);
			me.loadOnCloudDirectoryAction(cloudDirActionObj);
		}
		Ext.getCmp('discoveryRightPane').setTitle(pageTitle10);
	},
	loadStoragePlatformSettings : function()
	{
		var me = this;
		var storageCategoryObj = Ext.getCmp('storagePlatformCategory');
		var storageActionObj = Ext.getCmp('storagePlatformAction');
		var storageCategoryArray = publicJSON['mComboCatArray'];
		var storagePlatformsArray = publicJSON['mComboArray'];
		if(storagePlatformsArray == null || storagePlatformsArray == 'undefined' || storageCategoryArray == null || storageCategoryArray == 'undefined')
		{
			var url = 'EgServerDiscovery/data/EgStoragePlatformJson.jsp?from=viewStoragePlatform';
			me.updateCofigData(url);
			storageCategoryArray = publicJSON['mComboCatArray'];
			storagePlatformsArray = publicJSON['mComboArray'];
		}
		storageCategoryObj.getStore().loadRawData(storageCategoryArray);		
		var val = storageCategoryObj.getStore().getAt(0).get('valueField');
		storageCategoryObj.setValue(val);
		storageActionObj.getStore().loadRawData(storagePlatformsArray);
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.show();
		resultPanelObj.removeAll();

		var array = publicJSON['gridArray'];
		if (!Ext.isEmpty(array))
		{
			var value = storageActionObj.getStore().getAt(0).get('valueField');
			storageActionObj.setValue(value);
			var columns = publicJSON['columns'];
			var gridTitle = publicJSON['gridTitle'];
			me.getGridPanel(array,columns,gridTitle);
		}
		else
		{
			//var emptyMessage = publicJSON['emptyMessage'];
			//me.updateResultPaanel(emptyMessage);
			var value = storageActionObj.getStore().getAt(1).get('valueField');
			storageActionObj.setValue(value);
			me.loadOnStoragePlatformAction(storageActionObj);
		}
		Ext.getCmp('discoveryRightPane').setTitle(pageTitle11);
	},
	loadRabbitMQSettings : function()
	{
		var me = this;
		var rabbitMQCategoryObj = Ext.getCmp('rabitMQCategory');
		var rabbitMQActionObj = Ext.getCmp('rabbitMQAction');
		var rabbitMQArray = publicJSON['mComboCatArray'];
		var rabbitMQNodeArray = publicJSON['mComboArray'];
		if(rabbitMQNodeArray == null || rabbitMQNodeArray == 'undefined' || rabbitMQArray == null || rabbitMQArray == 'undefined')
		{
			var url = 'EgServerDiscovery/data/EgRabbitMQNodeJson.jsp?from=viewRabbitMQ';
			me.updateCofigData(url);
			rabbitMQArray = publicJSON['mComboCatArray'];
			rabbitMQNodeArray = publicJSON['mComboArray'];
		}
		rabbitMQCategoryObj.getStore().loadRawData(rabbitMQArray);		
		var val = rabbitMQCategoryObj.getStore().getAt(0).get('valueField');
		rabbitMQCategoryObj.setValue(val);
		rabbitMQActionObj.getStore().loadRawData(rabbitMQNodeArray);
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.show();
		resultPanelObj.removeAll();

		var array = publicJSON['gridArray'];
		if (!Ext.isEmpty(array))
		{
			var value = rabbitMQActionObj.getStore().getAt(0).get('valueField');
			rabbitMQActionObj.setValue(value);
			var columns = publicJSON['columns'];
			var gridTitle = publicJSON['gridTitle'];
			me.getGridPanel(array,columns,gridTitle);
		}
		else
		{
			var value = rabbitMQActionObj.getStore().getAt(1).get('valueField');
			rabbitMQActionObj.setValue(value);
			me.loadOnRabbitMQAction(rabbitMQActionObj);
		}
		Ext.getCmp('discoveryRightPane').setTitle(pageTitle12);
	},
	submitCloudDetails : function(obj)
	{
		var me = this;
		var selectedAction = Ext.getCmp('cloudaction').getValue();
		if (selectedAction == "ADDCLOUD")
		{
			var validationStatus = this.validateFormCloud("add");
			if (validationStatus == true)
			{
				var url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=cloudAdd&selectedNode=node3";
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the AWS cloud regions?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=cloudAddCloudDiscovery";
							me.updateCloudAccounts(url,selectedAction,true);
						}
						else
						{
							me.updateCloudAccounts(url,selectedAction,false);
						}
					});
				}
				else
				{
					this.updateCloudAccounts(url,selectedAction,false);
				}
			}
		}
		else if (selectedAction == "MODIFYCLOUD")
		{
			var validationStatus = this.validateFormCloud("modify");
			if (validationStatus == true)
			{
				var account = Ext.getCmp("accountModify").getValue();
				var url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=cloudModify&selectedNode=node3&account="+encodeURIComponent(account);
				if (Ext.getCmp('isDiscovery').getValue().toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the AWS Cloud regions?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgchangeportspJson.jsp?from=cloudModifyCloudDiscovery&account="+encodeURIComponent(account);
							me.updateCloudAccounts(url,selectedAction,true);
						}
						else
						{
							me.updateCloudAccounts(url,selectedAction,false);
						}
					});
				}
				else
				{
					this.updateCloudAccounts(url,selectedAction,false);
				}
			}
		}
	},
	submitNetscaler : function()
	{
		var me = this;
		var selectedAction = Ext.getCmp('netscaleraction').getValue();
		var discover = Ext.getCmp('isDiscovery').getValue();


		if(selectedAction == 'ADD')
		{
			var validationStatus = this.validateFormNetScaler("add");
			if (validationStatus == true)
			{
				var url = '';
				if(discover.toLowerCase() == 'yes')
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the StoreFront servers?", function(btn){
						if (btn == "yes")
						{
							url = 'EgServerDiscovery/data/EgNetScalerJsonp.jsp?from=addNetScaler&discovery=true';
							me.updateNetScaler(url,'ADD','true');
						}
						else
						{
							url = 'EgServerDiscovery/data/EgNetScalerJsonp.jsp?from=addNetScaler&discovery=false';
							me.updateNetScaler(url,'ADD','false');
						}
					});
				}
				else
				{
					url = 'EgServerDiscovery/data/EgNetScalerJsonp.jsp?from=addNetScaler&discovery=false';
					me.updateNetScaler(url,'ADD','false');
				}
			}
		}
		else if(selectedAction == 'MODIFY')
		{
			var validationStatus = this.validateFormNetScaler("modify");
			if (validationStatus == true)
			{
				var url = '';
				if(discover.toLowerCase() == 'yes')
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the StoreFront servers?", function(btn){
						if (btn == "yes")
						{
							url = 'EgServerDiscovery/data/EgNetScalerJsonp.jsp?from=modifyNetScaler&discovery=true';
							me.updateNetScaler(url,'MODIFY','true');
						}
						else
						{
							url = 'EgServerDiscovery/data/EgNetScalerJsonp.jsp?from=modifyNetScaler&discovery=false';
							me.updateNetScaler(url,'MODIFY','false');
						}
					});
				}
				else
				{
					url = 'EgServerDiscovery/data/EgNetScalerJsonp.jsp?from=modifyNetScaler&discovery=false';
					me.updateNetScaler(url,'MODIFY','false');
				}
			}
		}
	},
	submitCloudDirectory : function()
	{
		var selectedAction = Ext.getCmp('clouddirectoryaction').getValue();
		var discover = Ext.getCmp('isDiscovery').getValue();
		var vm = Ext.getCmp('isVM').getValue();		
		
		if(selectedAction == 'ADD')
		{
			var validationStatus = this.validateFormCloudDirectory("add");			
			if (validationStatus == true)
			{
				var url = '';
				var discFlag='false';
				var vmFlag='false';				
				if(discover.toLowerCase() == 'yes')
				{					
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the ESX hosts/vCenters?", function(btn){
						if (btn == "yes")
						{							
							discFlag='true';
							appCnt.checkVirtualMachine('ADD',discFlag,vm);							
						}
						else
						{							
							discFlag='false';
							appCnt.checkVirtualMachine('ADD',discFlag,vm);
						}
					});
				}
				else
				{					
					discFlag='false';
					appCnt.checkVirtualMachine('ADD',discFlag,vm);					
				}								
			}
		}
		else if(selectedAction == 'MODIFY')
		{
			var validationStatus = this.validateFormCloudDirectory("modify");
			if (validationStatus == true)
			{
				var url = '';
				var discFlag='';
				var vmFlag='';				
				if(discover.toLowerCase() == 'yes')
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the ESX hosts/vCenters servers?", function(btn){
						if (btn == "yes")
						{							
							discFlag='true';
							appCnt.checkVirtualMachine('MODIFY',discFlag,vm);							
						}
						else
						{							
							discFlag='flase';
							appCnt.checkVirtualMachine('MODIFY',discFlag,vm);							
						}
					});
				}
				else
				{					
					discFlag='flase';
					appCnt.checkVirtualMachine('MODIFY',discFlag,vm);					
				}
			}
		}
	},
	submitStoragePlatform : function()
	{
		var me = this;
		var selectedAction = Ext.getCmp('storagePlatformAction').getValue();
		var discover = Ext.getCmp('isDiscovery').getValue();
		
		if (selectedAction == "ADD")
		{
			var validationStatus = me.validateFormStoragePlatform("add");
			if (validationStatus == true)
			{
				var url = "EgServerDiscovery/data/EgstorageplatformpJson.jsp?from=xmsAdd";
				if (discover.toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the XMS?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgstorageplatformpJson.jsp?from=xmsAdd&discovery=yes";
							me.updateStoragePlatform(url,selectedAction,true);
						}
						else
						{
							me.updateStoragePlatform(url,selectedAction,false);
						}
					});
				}
				else
				{
					me.updateStoragePlatform(url,selectedAction,false);
				}
			}
		}
		else if (selectedAction == "MODIFY")
		{
			var validationStatus = this.validateFormStoragePlatform("modify");
			if (validationStatus == true)
			{
				var account = Ext.getCmp("ipModify").getValue();
				var url = "EgServerDiscovery/data/EgstorageplatformpJson.jsp?from=xmsModify&account="+encodeURIComponent(account);
				if (discover.toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the XMS?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgstorageplatformpJson.jsp?from=xmsModify&discovery=yes";
							me.updateStoragePlatform(url,selectedAction,true);
						}
						else
						{
							me.updateStoragePlatform(url,selectedAction,false);
						}
					});
				}
				else
				{
					this.updateStoragePlatform(url,selectedAction,false);
				}
			}
		}
	},
	submitRabbitMQ : function()
	{
		var me = this;
		var selectedAction = Ext.getCmp('rabbitMQAction').getValue();
		var discover = Ext.getCmp('isDiscovery').getValue();
		
		if (selectedAction == "ADD")
		{
			var validationStatus = me.validateFormRabbitMQ("add");
			if (validationStatus == true)
			{
				var url = "EgServerDiscovery/data/EgrabbitmqnodepJson.jsp?from=Add";
				if (discover.toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the RabbitMQ host?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgrabbitmqnodepJson.jsp?from=Add&discovery=yes";
							me.updateRabbitMQ(url,selectedAction,true);
						}
						else
						{
							me.updateRabbitMQ(url,selectedAction,false);
						}
					});
				}
				else
				{
					me.updateRabbitMQ(url,selectedAction,false);
				}
			}
		}
		else if (selectedAction == "MODIFY")
		{
			var validationStatus = this.validateFormRabbitMQ("modify");
			if (validationStatus == true)
			{
				var account = Ext.getCmp("ipModify").getValue();
				var url = "EgServerDiscovery/data/EgrabbitmqnodepJson.jsp?from=Modify&account="+encodeURIComponent(account);
				if (discover.toLowerCase() == "yes")
				{
					Ext.MessageBox.confirm('Confirm', "Do you want to discover the RabbitMQ host?", function(btn){
						if (btn == "yes")
						{
							url = "EgServerDiscovery/data/EgrabbitmqnodepJson.jsp?from=Modify&discovery=yes";
							me.updateRabbitMQ(url,selectedAction,true);
						}
						else
						{
							me.updateRabbitMQ(url,selectedAction,false);
						}
					});
				}
				else
				{
					this.updateRabbitMQ(url,selectedAction,false);
				}
			}
		}
	},
	checkVirtualMachine : function(from,vcflag,vm)
	{
		var me=this;
		var vmFlag='false';
		var url = '';
		var frompage = '';
		if(from == 'ADD')
		{
			frompage = 'addvClouds';			
		}
		else
		{
			frompage = 'modifyvClouds';
		}		
		if(vm.toLowerCase() == 'yes')
		{			
			Ext.MessageBox.confirm('Confirm', "Do you want to discover the Vitual Machine servers?", function(btn){
				if (btn == "yes")
				{
					vmFlag='true';					
					url = 'EgServerDiscovery/data/EgCloudDirectoryJsonp.jsp?from='+frompage+'&discovery='+vcflag+'&vm='+vmFlag;						
					appCnt.updateCloudDirectory(url,from,vcflag,vmFlag);
				}
				else
				{
					vmFlag='false';
					url = 'EgServerDiscovery/data/EgCloudDirectoryJsonp.jsp?from='+frompage+'&discovery='+vcflag+'&vm='+vmFlag;					
					appCnt.updateCloudDirectory(url,from,vcflag,vmFlag);
				}
			});
		}
		else
		{
			vmFlag='false';
			url = 'EgServerDiscovery/data/EgCloudDirectoryJsonp.jsp?from='+frompage+'&discovery='+vcflag+'&vm='+vmFlag;			
			appCnt.updateCloudDirectory(url,from,vcflag,vmFlag);
		}
	},
	updateNetScaler : function(url,from,discovery)
	{
		var ip = '';
		var requestUrl = url;

		var ssl = Ext.getCmp('ssl').getValue();
		var discover = Ext.getCmp('isDiscovery').getValue();
		var uname = Ext.getCmp('uname').getValue();
		var pass = Ext.getCmp('pass').getValue();

		var $_ssl = '';
		var $_discover = '';
		var $_user = '';
		var $_pwd = '';

		if(from == 'ADD')
		{
			ip = Ext.getCmp('ipAdd').getValue();
		}
		else
		{
			ip = Ext.getCmp('ipModify').getValue();
			$_ssl = Ext.getCmp('$_ssl').getValue();
			$_discover = Ext.getCmp('$_isDiscovery').getValue();
			$_user = Ext.getCmp('$_uname').getValue();
			$_pwd = Ext.getCmp('$_pass').getValue();
		}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();

		Ext.Ajax.request({
			url : requestUrl,
			method : 'POST',
			params : {
				'ip' : ip,
				'ssl' : ssl,
				'discover' : discover,
				'user' : uname,
				'pwd' : pass,
				'$_ssl' : $_ssl,
				'$_discover' : $_discover,
				'$_user' : $_user,
				'$_pwd' : $_pwd
			},
			success : function(response)
			{
				myMask.hide();
				var localJSON = Ext.decode(response.responseText);
				if(localJSON['success'] == 'true')
				{
					if(discovery == 'true')
					{
						var discoveryTree = Ext.getCmp('discoverytree');
						var record = discoveryTree.getStore().getNodeById("node5");
						discoveryTree.getSelectionModel().select(record);

						var disObject = Ext.getCmp('discoveryRightPane');
						disObject.removeAll();
						disObject.add({xtype:'egconfigenvformcontainer',border : false});
						Ext.getCmp('discoveryRightPane').setTitle(pageTitle8);
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+manageCompDisc+'</center>');
						//isDiscState = true;
						refreshOnDiscAlive();
					}
					else
					{
						if(from == 'ADD')
						{
							Ext.Msg.show({
								title: 'NetScaler Settings',
								msg: 'Details have been added successfully' + ".",
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation'
							});
						}
						else
						{
							Ext.Msg.show({
								title: 'NetScaler Settings',
								msg: 'Details have been modified successfully' + ".",
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation'
							});
						}
					}
				}
				else
				{
					Ext.Msg.show({
						title: 'NetScaler Settings',
						msg: 'Error in details updation' + ".",
						buttons: Ext.Msg.OK,
						width : 300,
						icon: 'iconError'
					});
				}
			}
		});
	},
	updateCloudDirectory : function(url,from,discovery,vmfl)
	{		
		var ip = '';
		var requestUrl = url;

		var ssl = Ext.getCmp('ssl').getValue();
		var discover = Ext.getCmp('isDiscovery').getValue();
		var vm = Ext.getCmp('isVM').getValue();
		var uname = Ext.getCmp('uname').getValue();
		var pass = Ext.getCmp('pass').getValue();		

		var $_ssl = '';
		var $_discover = '';
		var $_vm = '';
		var $_user = '';
		var $_pwd = '';

		if(from == 'ADD')
		{
			ip = Ext.getCmp('ipAdd').getValue();
		}
		else
		{
			ip = Ext.getCmp('ipModify').getValue();
			$_ssl = Ext.getCmp('$_ssl').getValue();
			$_discover = Ext.getCmp('$_isDiscovery').getValue();
			$_vm = Ext.getCmp('$_isVM').getValue();
			$_user = Ext.getCmp('$_uname').getValue();
			$_pwd = Ext.getCmp('$_pass').getValue();
		}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();

		Ext.Ajax.request({
			url : requestUrl,
			method : 'POST',
			params : {
				'ip' : ip,
				'ssl' : ssl,
				'discover' : discover,
				'vm' : vm,
				'user' : uname,
				'pwd' : pass,
				'$_ssl' : $_ssl,
				'$_discover' : $_discover,
				'$_vm' : $_vm,
				'$_user' : $_user,
				'$_pwd' : $_pwd
			},
			success : function(response)
			{
				myMask.hide();
				var localJSON = Ext.decode(response.responseText);
				if(localJSON['success'] == 'true')
				{
					if(discovery == 'true' || vmfl == 'true')
					{
						var discoveryTree = Ext.getCmp('discoverytree');
						var record = discoveryTree.getStore().getNodeById("node5");
						discoveryTree.getSelectionModel().select(record);

						var disObject = Ext.getCmp('discoveryRightPane');
						disObject.removeAll();
						disObject.add({xtype:'egconfigenvformcontainer',border : false});
						Ext.getCmp('discoveryRightPane').setTitle(pageTitle8);
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+manageCompDisc+'</center>');
						//isDiscState = true;
						refreshOnDiscAlive();
					}
					else
					{
						if(from == 'ADD')
						{
							Ext.Msg.show({
								title: 'NetScaler Settings',
								msg: 'Details have been added successfully' + ".",
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation'
							});
						}
						else
						{
							Ext.Msg.show({
								title: 'NetScaler Settings',
								msg: 'Details have been modified successfully' + ".",
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation'
							});
						}
					}
				}
				else
				{
					Ext.Msg.show({
						title: 'NetScaler Settings',
						msg: 'Error in details updation' + ".",
						buttons: Ext.Msg.OK,
						width : 300,
						icon: 'iconError'
					});
				}
			}
		});
	},
	updateCloudAccounts : function(url,selectedAction,isDiscovery)
	{
		var me = this;
		var hiddenFields = this.getHiddenFields();
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var egcloudplatforms = this.getEgcloudplatforms().getForm();
		if (egcloudplatforms.isValid())
		{
			this.getEgcloudplatforms().submit({
				url: url+'&'+hiddenFields,
				method: 'POST',
				//standardSubmit: true,
				success: function(form, action){
					myMask.hide();
					//alert(action.response.responseText);
					//me.showResultWindow(action.response.responseText);
					var resultObj = Ext.decode(action.response.responseText);
					if (resultObj.requestStatus == "success")
					{
						if (isDiscovery == true)
						{
							var myMask1 = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
							myMask1.show();
							Ext.Ajax.request({
								url : 'EgServerDiscovery/data/EgConfigEnvJson.jsp?startDiscThread=false&executeAction=New&selectedNode=node1',
								method : 'POST',
								success : function(response, opts)
								{
									myMask1.hide();
									publicJSON = Ext.decode(response.responseText);
									var discoveryTree = Ext.getCmp('discoverytree');
									var record = discoveryTree.getStore().getNodeById("node5");
									discoveryTree.getSelectionModel().select(record);

									var disObject = Ext.getCmp('discoveryRightPane');
									disObject.removeAll();
									disObject.add({xtype:'egconfigenvformcontainer',border : false});
									Ext.getCmp('discoveryRightPane').setTitle(pageTitle8);
									Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+manageCompDisc+'</center>');
									isDiscState = true;
									refreshOnDiscAlive();
								}
							});
						}
						else
						{
							Ext.Msg.show({
								title: resultObj.result.title,
								msg: resultObj.result.message1 + ".",
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation'
							});
							if (selectedAction == "ADDCLOUD")
							{
								me.clearFormCloud();
							}
						}
					}
					else
					{
						var tmpObj = resultObj.errors;
						//var errorText = me.getErrorMessageTemplate(tmpObj);
						Ext.Msg.show({
							title: tmpObj.title,
							msg: tmpObj.message1 + ".",
							buttons: Ext.Msg.OK,
							width : 300,
							icon: 'iconError'
						});
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					//console.log(action.response.responseText);
				}
			});
		}
	},
	updateStoragePlatform : function(url,from,discovery)
	{
		var me = this;
		var ip = '';
		var requestUrl = url;

		var ssl = Ext.getCmp('ssl').getValue();
		var discover = Ext.getCmp('isDiscovery').getValue();
		var uname = Ext.getCmp('uname').getValue();
		var pass = Ext.getCmp('pass').getValue();		

		var $_ssl = '';
		var $_discover = '';
		var $_user = '';
		var $_pwd = '';

		if(from == 'ADD')
		{
			ip = Ext.getCmp('ipAdd').getValue();
		}
		else
		{
			ip = Ext.getCmp('ipModify').getValue();
			$_ssl = Ext.getCmp('$_ssl').getValue();
			$_discover = Ext.getCmp('$_isDiscovery').getValue();
			$_user = Ext.getCmp('$_uname').getValue();
			$_pwd = Ext.getCmp('$_pass').getValue();
		}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();

		Ext.Ajax.request({
			url : requestUrl,
			method : 'POST',
			params : {
				'ip' : ip,
				'ssl' : ssl,
				'discover' : discover,
				'user' : uname,
				'pwd' : pass,
				'$_ssl' : $_ssl,
				'$_discover' : $_discover,
				'$_user' : $_user,
				'$_pwd' : $_pwd
			},
			success : function(response)
			{
				myMask.hide();
				var localJSON = Ext.decode(response.responseText);
				if(localJSON['success'] == 'true')
				{
					if(discovery == true)
					{
						var discoveryTree = Ext.getCmp('discoverytree');
						var record = discoveryTree.getStore().getNodeById("node5");
						discoveryTree.getSelectionModel().select(record);

						var disObject = Ext.getCmp('discoveryRightPane');
						disObject.removeAll();
						disObject.add({xtype:'egconfigenvformcontainer',border : false});
						Ext.getCmp('discoveryRightPane').setTitle(pageTitle8);
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+manageCompDisc+'</center>');
						//isDiscState = true;
						refreshOnDiscAlive();
					}
					else
					{
						if(from == 'ADD')
						{
							Ext.Msg.show({
								title: 'Storage Platform Settings',
								msg: 'Details have been added successfully' + ".",
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation'
							});
						}
						else
						{
							Ext.Msg.show({
								title: 'Storage Platform Settings',
								msg: 'Details have been modified successfully' + ".",
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation'
							});
						}
						me.clearStoragePlatform();
					}
				}
				else
				{
					Ext.Msg.show({
						title: 'Storage Platform Settings',
						msg: 'Error in details updation' + ".",
						buttons: Ext.Msg.OK,
						width : 300,
						icon: 'iconError'
					});
				}
			}
		});
	},
	updateRabbitMQ : function(url,from,discovery)
	{
		var me = this;
		var ip = '';
		var requestUrl = url;

		var ssl = Ext.getCmp('ssl').getValue();
		var webport = Ext.getCmp('webport').getValue();
		var discover = Ext.getCmp('isDiscovery').getValue();
		var uname = Ext.getCmp('uname').getValue();
		var pass = Ext.getCmp('pass').getValue();		

		var $_ssl = '';
		var $_webport = '';
		var $_discover = '';
		var $_user = '';
		var $_pwd = '';

		if(from == 'ADD')
		{
			ip = Ext.getCmp('ipAdd').getValue();
		}
		else
		{
			ip = Ext.getCmp('ipModify').getValue();
			$_ssl = Ext.getCmp('$_ssl').getValue();
			$_webport = Ext.getCmp('$_webport').getValue();
			$_discover = Ext.getCmp('$_isDiscovery').getValue();
			$_user = Ext.getCmp('$_uname').getValue();
			$_pwd = Ext.getCmp('$_pass').getValue();
		}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();

		Ext.Ajax.request({
			url : requestUrl,
			method : 'POST',
			params : {
				'ip' : ip,
				'ssl' : ssl,
				'webport' : webport,
				'discover' : discover,
				'user' : uname,
				'pwd' : pass,
				'$_ssl' : $_ssl,
				'$_webport' : $_webport,
				'$_discover' : $_discover,
				'$_user' : $_user,
				'$_pwd' : $_pwd
			},
			success : function(response)
			{
				myMask.hide();
				var localJSON = Ext.decode(response.responseText);
				if(localJSON['success'] == 'true')
				{
					if(discovery == true)
					{
						var discoveryTree = Ext.getCmp('discoverytree');
						var record = discoveryTree.getStore().getNodeById("node5");
						discoveryTree.getSelectionModel().select(record);

						var disObject = Ext.getCmp('discoveryRightPane');
						disObject.removeAll();
						disObject.add({xtype:'egconfigenvformcontainer',border : false});
						Ext.getCmp('discoveryRightPane').setTitle(pageTitle8);
						Ext.getCmp('pageHeaderText').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+manageCompDisc+'</center>');
						//isDiscState = true;
						refreshOnDiscAlive();
					}
					else
					{
						if(from == 'ADD')
						{
							Ext.Msg.show({
								title: 'RabbitMQ Cluster Settings',
								msg: 'Details have been added successfully' + ".",
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation'
							});
						}
						else
						{
							Ext.Msg.show({
								title: 'RabbitMQ Cluster Settings',
								msg: 'Details have been modified successfully' + ".",
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation'
							});
						}
						me.clearRabbitMQ();
					}
				}
				else
				{
					Ext.Msg.show({
						title: 'RabbitMQ Cluster Settings',
						msg: 'Error in details updation' + ".",
						buttons: Ext.Msg.OK,
						width : 300,
						icon: 'iconError'
					});
				}
			}
		});
	},
	viewVcenterDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=view&selectedNode="+selectedNodeID;
		this.updateDiscoveryTree(url);
		var vCenters = publicJSON['vCenterDetails']['deletevCenterServers'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(vCenters))
		{
			var cols = publicJSON['vCenterDetails']['columns'];
			var gridTitle = publicJSON['vCenterDetails']['gridTitle'];
			me.getGridPanel(vCenters,cols,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	viewVcenterRemoteAgentDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		var url = "EgServerDiscovery/data/EgAssignRemoteAgentsList.jsp?vCenter=all";
		this.updateViewRemoteAgentMapping(url);

		var vCenters = publicRmtAgt['UserInfo'];
		var vCenterArr = publicRmtAgt['vCenterArr'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(vCenters))
		{
			var gridpanel = Ext.widget('remoteagentsgrid',{
				store:new Ext.data.Store({
					fields: ['vCenterName', 'Count', 'AssignedAgents','isAgentsAssociated','AssignedEsx','TotalEsxCount','TotalClubEsxHosts'],
					data: []
				}),
				sortableColumns:true,
				//columns:mainColumnsObjArray,
				//title:gridTitle,
				viewConfig: {
					forceFit: true,
					stripeRows : false
				},
				width : '90%'
			});
			resultPanelObj.add(gridpanel);

			var saveCSV = Ext.getCmp('saveCSV');
			if (!Ext.isEmpty(saveCSV))
			{
				saveCSV.show();
				saveCSV.setDisabled(false);
			}



			var agentsCombo = Ext.getCmp('agentsCombo');
			if (!Ext.isEmpty(agentsCombo))
			{
				agentsCombo.setDisabled(false);
			}
			

			var vCenterRmtAgentGrid = Ext.getCmp('usersgrid');

			agentsCombo.getStore().loadRawData(vCenterArr);
			agentsCombo.setValue('all');
			vCenterRmtAgentGrid.getStore().loadRawData(vCenters);

		}
		else
		{
			var gridpanel = Ext.widget('remoteagentsgrid',{
				store:new Ext.data.Store({
					fields: ['vCenterName', 'Count', 'AssignedAgents','isAgentsAssociated','AssignedEsx','TotalEsxCount','TotalClubEsxHosts'],
					data: []
				}),
				sortableColumns:true,
				//columns:mainColumnsObjArray,
				//title:gridTitle,
				viewConfig: {
					forceFit: true,
					stripeRows : false
				},
				width : '90%'
			});
			resultPanelObj.add(gridpanel);



			var agentsCombo = Ext.getCmp('agentsCombo');
			var saveCSV = Ext.getCmp('saveCSV');
			if (!Ext.isEmpty(agentsCombo))
			{
				agentsCombo.setDisabled(true);
			}
			
			if (!Ext.isEmpty(saveCSV))
			{
				saveCSV.hide();
				saveCSV.setDisabled(true);
			}
		}
	},
	loadUniqueVcenterRmtAgent : function()
	{
		var me = this;
		var agentsCombo = Ext.getCmp('agentsCombo');
		var selectedValue = agentsCombo.getValue();
		var url = "EgServerDiscovery/data/EgAssignRemoteAgentsList.jsp?vCenter="+selectedValue;
		this.updateViewRemoteAgentMapping(url);

		var vCenters = publicRmtAgt['UserInfo'];
		var vCenterRmtAgentGrid = Ext.getCmp('usersgrid');

		if (!Ext.isEmpty(vCenters))
		{
			//userInfoGrid.setTitle('');

			vCenterRmtAgentGrid.getStore().removeAll();
			vCenterRmtAgentGrid.getStore().loadRawData(vCenters);
		}
		else
		{
			vCenterRmtAgentGrid.getStore().removeAll();
		}
	},
	viewHMCDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=hmcView&selectedNode="+selectedNodeID;
		this.updateDiscoveryTree(url);
		var hmcServers = publicJSON['hmcDetails']['hmcServers'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(hmcServers))
		{
			var cols = publicJSON['hmcDetails']['columns'];
			var gridTitle = publicJSON['hmcDetails']['gridTitle'];
			me.getGridPanel(hmcServers,cols,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	viewNutanixDetails : function ()
	{
		//new changes for nutanix server...
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		var url = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=nutanixView&selectedNode="+selectedNodeID;
		this.updateDiscoveryTree(url);
		var nutanixServers = publicJSON['nutanixDetails']['nutanixServers'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(nutanixServers))
		{
			var cols = publicJSON['nutanixDetails']['columns'];
			var gridTitle = publicJSON['nutanixDetails']['gridTitle'];
			me.getGridPanel(nutanixServers,cols,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	viewCtxXenPoolDetails: function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		var url = "EgServerDiscovery/data/EgCtxXenPoolDiscoveryJson.jsp?from=ctxXenPoolView&selectedNode="+selectedNodeID;
		this.updateDiscoveryTree(url);
		var ctxXenPoolDetails = publicJSON['ctxXenPoolDetails']['ctxXenPools'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(ctxXenPoolDetails))
		{
			var cols = publicJSON['ctxXenPoolDetails']['columns'];
			var gridTitle = publicJSON['ctxXenPoolDetails']['gridTitle'];
			me.getGridPanel(ctxXenPoolDetails,cols,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	viewOracleVMDetails: function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		var url = "EgServerDiscovery/data/EgOracleVmManagerDiscoveryJson.jsp?from=oracleVMView&selectedNode="+selectedNodeID;
		this.updateDiscoveryTree(url);
		var oracleVMDetails = publicJSON['oracleVMDetails']['oracleVMs'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(oracleVMDetails))
		{
			var cols = publicJSON['oracleVMDetails']['columns'];
			var gridTitle = publicJSON['oracleVMDetails']['gridTitle'];
			me.getGridPanel(oracleVMDetails,cols,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	viewRHEVDetails : function()
	{
		var me = this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		var url = "EgServerDiscovery/data/EgRHEVDiscoveryJson.jsp?from=rhevView&selectedNode="+selectedNodeID;
		this.updateDiscoveryTree(url);
		var rhevDetails = publicJSON['rhevDetails']['rhevManagers'];
		resultPanelObj.show();
		resultPanelObj.removeAll();
		if (!Ext.isEmpty(rhevDetails))
		{
			var cols = publicJSON['rhevDetails']['columns'];
			var gridTitle = publicJSON['rhevDetails']['gridTitle'];
			me.getGridPanel(rhevDetails,cols,gridTitle);
		}
		else
		{
			var emptyMessage = publicJSON['emptyMessage'];
			me.updateResultPaanel(emptyMessage);
		}
	},
	stopManagerDiscovery : function()
	{
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var emptyResultPanel = {
			xtype:'container',
			style:{'text-align':'center'},
			html:"<div style='margin:20% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText'>"+discoveryStop+"</div></td></tr></table></div>"
		};
		resultPanelObj.add(emptyResultPanel);
	},
	loadAgentDiscoerySettings :  function()
	{
		var me = this;
		var agentDiscoverySettings = publicJSON['agentDiscoverySettings'];
		var AgentDiscDelay = agentDiscoverySettings.AgentDiscDelay;
		var AgentReDiscoverPeriod = agentDiscoverySettings.AgentReDiscoverPeriod;
		var DiscTimeout = agentDiscoverySettings.DiscTimeout;
		var portBasedDiscovery = agentDiscoverySettings.portBasedDiscovery;
		var nonPortBasedDiscovery = agentDiscoverySettings.nonPortBasedDiscovery;
		var aggregateCompAutoManage = agentDiscoverySettings.aggregateCompAutoManage;
		var discoverOsAlone = agentDiscoverySettings.discoverOsAlone;
		Ext.getCmp('AgentDiscDelay').setValue(AgentDiscDelay);
		Ext.getCmp('AgentReDiscoverPeriod').setValue(AgentReDiscoverPeriod);
		Ext.getCmp('DiscTimeout').setValue(DiscTimeout);
		if (portBasedDiscovery == 'yes')
		{
			Ext.getCmp('portBasedDiscovery_1').setValue(true);
		}
		else
		{
			Ext.getCmp('portBasedDiscovery_2').setValue(true);
		}
		if (nonPortBasedDiscovery == 'yes')
		{
			Ext.getCmp('nonPortBasedDiscovery_1').setValue(true);
		}
		else
		{
			Ext.getCmp('nonPortBasedDiscovery_2').setValue(true);
		}
		if (aggregateCompAutoManage == 'yes')
		{
			Ext.getCmp('aggregateCompAutoManage_1').setValue(true);
		}
		else
		{
			Ext.getCmp('aggregateCompAutoManage_2').setValue(true);
		}
		if (discoverOsAlone == 'yes')
		{
			Ext.getCmp('discoverOsAlone_1').setValue(true);
		}
		else
		{
			Ext.getCmp('discoverOsAlone_2').setValue(true);
		}
		var topodiscval = publicJSON['topodiscval'];
		if (topodiscval == "no" || topodiscval == "false")
		{
			Ext.getCmp('topologysettings').hide();
		}
		else
		{
			Ext.getCmp('topologysettings').show();
		}
		var topologyDiscoverySettings = publicJSON['topologyDiscoverySettings'];
		var TopologyReDiscoverPeriod = topologyDiscoverySettings.TopologyReDiscoverPeriod;
		var SendBox = topologyDiscoverySettings.SendBox;
		var TotalBox = topologyDiscoverySettings.TotalBox;
		var TopologySleepTime = topologyDiscoverySettings.TopologySleepTime;
		var selectedSendBox = topologyDiscoverySettings.selectedSendBox;
		var selectedTotalBox = topologyDiscoverySettings.selectedTotalBox;

		Ext.getCmp('TopologyReDiscoverPeriod').setValue(TopologyReDiscoverPeriod);
		Ext.getCmp('SendBox').getStore().loadRawData(SendBox);
		Ext.getCmp('SendBox').setValue(selectedSendBox);
		Ext.getCmp('TotalBox').getStore().loadRawData(TotalBox);
		Ext.getCmp('TotalBox').setValue(selectedTotalBox);
		Ext.getCmp('TopologySleepTime').setValue(TopologySleepTime);
	},
	submitAgentDetails : function()
	{
		var me = this;
		var status = me.validateAgentDiscoverySettingsForm();
		if (status == true)
		{
			var url = 'EgServerDiscovery/data/EgAgentDiscoverpJson.jsp?from=general&selectedNode=node8'
			var hiddenFields = this.getHiddenFields();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			var agentdiscovery = this.getAgentdiscovery().getForm();
			if (agentdiscovery.isValid())
			{
				this.getAgentdiscovery().submit({
					url: url+'&'+hiddenFields,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						//alert(action.response.responseText);
						//me.showResultWindow(action.response.responseText);
						var resultObj = Ext.decode(action.response.responseText);
						if (resultObj.requestStatus == "success")
						{
							Ext.Msg.show({
								title: resultObj.result.title,
								msg: resultObj.result.message1 + ".",
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation'
							});
						}
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
						//console.log(action.response.responseText);
					}
				});
			}
		}
	},
	updateDiscSettings : function()
	{
		var me = this;
		var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		var flag ="<%=discovery_state%>";
		var selectflag = "false";
		var ipr = Ext.getCmp('iprange').getValue();
		var iprangeObj = Ext.getCmp('iprange');
		var CommunityObj = Ext.getCmp('Community');

		while (ipr.charAt(0) == ' ')
		{
			ipr = ipr.substring(1,ipr.length);
		}
		while (ipr.charAt(ipr.length-1)==' ')
		{
			ipr = ipr.substring(0,ipr.length-1);
		}
		var allowToUpdate = true;
		Ext.getCmp('iprange').setValue(ipr);

		if (!checkspecialnomess(iprangeObj.getValue(),"GHIJKLMNOPQRSTUVWXYZghijklmnopqrstuvwxyz~!@#$%^&*()'<>,"))
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: validationMsg1 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					iprangeObj.focus(true);
				}
			});
			return false;
		}
		else if (ipr.indexOf(" ") > -1)
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: validationMsg2 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					iprangeObj.focus(true);
				}
			});
			return false;
		}
		else if (ipr.length > 0 && (ipr.indexOf("..") > -1 ||
				ipr.indexOf(".,") > -1 ||
				ipr.indexOf(",.") > -1 ||
				ipr.charAt(0) == "," ||
				ipr.charAt(0) == "-" ||
				ipr.charAt(ipr.length - 1) == "-" ||
				ipr.indexOf("--") > -1 ||
				ipr.indexOf('-') < 0))
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: validationMsg3 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					iprangeObj.focus(true);
				}
			});
			return false;
		}
		else if(!validateSingleByte(ipr))
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: validationMsg4 + ".",
				buttons: Ext.Msg.OK,
				width : 400,
				icon: 'iconExclamation',
				fn : function(btn){
					iprangeObj.focus(true);
				}
			});
			return false;
		}
		else if (ipr.length > 0)
		{
			var singleIp = false;
			var comma_array = ipr.replace("\r","").split("\n");
			if (comma_array.length == 1)
			{
				singleIp = true;
			}
			for(var i =0;i < comma_array.length;i++)
			{
				var hypen_array = comma_array[i].split('-');
				var caughtInvalidData = false;
				if(hypen_array.length != 2)
				{
					if (singleIp)
					{
						Ext.Msg.show({
							title: pageTitle2,
							msg: validationMsg1 + ".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn){
								iprangeObj.focus(true);
							}
						});

					}
					else
					{
						Ext.Msg.show({
							title: pageTitle2,
							msg: validationMsg1+" "+(i+1) + ".",
							buttons: Ext.Msg.OK,
							width : 300,
							icon: 'iconExclamation',
							fn : function(btn){
								iprangeObj.focus(true);
							}
						});
					}
					caughtInvalidData = true;
					return false;
				}
				else
				{
					var ipValid = true;
					var ipStr1 = hypen_array[0];
					var ipStr2 = hypen_array[1];
					var tmpStrIP = ipStr1 + "-" +ipStr2;
					var validationStr1 = ipStr1.indexOf(":");
					var validationStr2 = ipStr2.indexOf(":");
					if (validationStr1 != -1 || validationStr2 != -1)
					{
						if (validationStr1 != -1 && validationStr2 != -1)
						{
							ipValid = true;
							Ext.Ajax.request({
								url : 'EgServerDiscovery/data/IPV6ComparatorJson.jsp?iprange='+encodeURIComponent(tmpStrIP),
								method : 'POST',
								async : false,
								success : function(response)
								{
									var jsonObject = Ext.decode(response.responseText);
									if (jsonObject.isValidV6IPRange == false)
									{
										ipValid = false;
										return false;
									}
								},
								failure : function()
								{
								}
							});
							if (ipValid == false)
							{
								if (singleIp)
								{
									Ext.Msg.show({
										title: pageTitle2,
										msg: validationMsg5 +".",
										buttons: Ext.Msg.OK,
										width : 400,
										icon: 'iconExclamation',
										fn : function(btn){
											iprangeObj.focus(true);
										}
									});
								}
								else
								{
									Ext.Msg.show({
										title: pageTitle2,
										msg: validationMsg5+ " in IP range  '"+tmpStrIP+"'.",
										buttons: Ext.Msg.OK,
										width : 400,
										icon: 'iconExclamation',
										fn : function(btn){
											iprangeObj.focus(true);
										}
									});
								}
								return false;
							}
						}
						else
						{
							Ext.Msg.show({
								title: pageTitle2,
								msg: validationMsg1 +".",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn : function(btn){
									iprangeObj.focus(true);
								}
							});
							return false;
						}
					}
					else
					{
						var checkIpStatus = checkIp(hypen_array[0]);
						if (checkIpStatus != "success")
						{
							if (singleIp)
							{
								Ext.Msg.show({
									title: pageTitle2,
									msg: validationMsg1 +".",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn : function(btn){
										iprangeObj.focus(true);
									}
								});
							}
							else
							{
								Ext.Msg.show({
									title: pageTitle2,
									msg: validationMsg1+" "+(i+1) + ".",
									buttons: Ext.Msg.OK,
									width : 300,
									icon: 'iconExclamation',
									fn : function(btn){
										iprangeObj.focus(true);
									}
								});
							}
							caughtInvalidData = true;
							ipValid = false;
							return false;
						}

						checkIpStatus = checkIp(hypen_array[1]);
						if (checkIpStatus != "success")
						{
							if (singleIp)
							{
								Ext.Msg.show({
									title: pageTitle2,
									msg: validationMsg1+".",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn : function(btn){
										iprangeObj.focus(true);
									}
								});
							}
							else
							{
								Ext.Msg.show({
									title: pageTitle2,
									msg: validationMsg1+" "+(i+1)+".",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn : function(btn){
										iprangeObj.focus(true);
									}
								});
							}
							caughtInvalidData = true;
							ipValid = false;
							return false;
						}

						if (ipValid)
						{
							var colon_array1 = hypen_array[0].split('.');
							var colon_array2 = hypen_array[1].split('.');
							var colonArr1, colonArr2;

							for(var m=0;m < colon_array1.length;m++)
							{
								colonArr1 = parseInt(colon_array1[m],10);
								colonArr2 = parseInt(colon_array2[m],10);

								if ( colonArr2 > colonArr1 )
								{
									break;
								}
								else if( colonArr2 < colonArr1 )
								{
									if (singleIp)
									{
										Ext.Msg.show({
											title: pageTitle2,
											msg: validationMsg5+".",
											buttons: Ext.Msg.OK,
											width : 300,
											icon: 'iconExclamation',
											fn : function(btn){
												iprangeObj.focus(true);
											}
										});
									}
									else
									{
										Ext.Msg.show({
											title: pageTitle2,
											msg: validationMsg5+ " in IP range "+(i + 1)+".",
											buttons: Ext.Msg.OK,
											width : 400,
											icon: 'iconExclamation',
											fn : function(btn){
												iprangeObj.focus(true);
											}
										});
									}
									caughtInvalidData = true;
									return false;
								}
							}
							if (caughtInvalidData)
							{
								return false;
							}
						}
					}
				}
			}
		}

		//SNMP String validation starts
		var snmpVersion = Ext.getCmp('snmpversion').getValue();
		if(snmpVersion != null && snmpVersion != 'undefined' && snmpVersion == 'v3')
		{
			var snmpUserName = Ext.getCmp('snmpMgrUserNameAdd').getValue(); //strUserName=request.getParameter("username");
			var snmpAuthPwd = Ext.getCmp('snmpMgrAuthPwdAdd').getValue(); //strAuthPwd=request.getParameter("authendicationpassword");
			var snmpAuthType = Ext.getCmp('snmpauthtypecomboadd').getValue(); //strAuthType=request.getParameter("authendicationtype");
			var snmpEncryptFlag = Ext.getCmp('encryptradioYesAdd').getValue(); //request.getParameter("encryptflag");
			var snmpMgrContext = Ext.getCmp('snmpMgrContext').getValue(); //request.getParameter("encryptflag");

			//isValidData = this.validateSnmpMgrUserNameField(snmpUserName);
			if(!Ext.isEmpty(snmpMgrContext) && !checkblank(snmpMgrContext))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: 'Please enter a context value' +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('snmpMgrContext').focus(true);
					}
				});
				return false;
			}
			else if(snmpMgrContext !=null && !checkspecialnomess(snmpMgrContext,"@*+=|:;\"\'<>\/[]?,"))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: 'Special characters not allowed' +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('snmpMgrContext').focus(true);
					}
				});
				return false;
			}
			else if(snmpMgrContext !=null && trim(snmpMgrContext) == "")
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: alert10 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('snmpMgrContext').focus(true);
					}
				});
				return false;
			}
			else if(snmpMgrContext !=null && snmpMgrContext.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: alert20 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('snmpMgrContext').focus(true);
					}
				});
				return false;
			}
			else if(snmpMgrContext !=null && snmpMgrContext.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: alert21 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('snmpMgrContext').focus(true);
					}
				});
				return false;
			}


			//isValidData = this.validateSnmpMgrUserNameField(snmpUserName);
			if(snmpUserName !=null && !checkblank(snmpUserName))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: alert10 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('snmpMgrUserNameAdd').focus(true);
					}
				});
				return false;
			}
			else if(snmpUserName !=null && !checkspecialnomess(snmpUserName,"@*+=|:;\"\'<>\/[]?,"))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: alert17 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('snmpMgrUserNameAdd').focus(true);
					}
				});
				return false;
			}
			else if(snmpUserName !=null && trim(snmpUserName) == "")
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: alert10 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('snmpMgrUserNameAdd').focus(true);
					}
				});
				return false;
			}
			else if(snmpUserName !=null && snmpUserName.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: alert20 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('snmpMgrUserNameAdd').focus(true);
					}
				});
				return false;
			}
			else if(snmpUserName !=null && snmpUserName.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: alert21 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('snmpMgrUserNameAdd').focus(true);
					}
				});
				return false;
			}

			var val1 = snmpAuthPwd;
			var val2 = Ext.getCmp('snmpMgrAuthConPwdAdd').getValue();
			if(val1 !=null && !checkblank(val1))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: alert10 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('snmpMgrAuthPwdAdd').focus(true);
					}
				});
				return false;
			}
			else if(val2 !=null && !checkblank(val2))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: alert10 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('snmpMgrAuthConPwdAdd').focus(true);
					}
				});
				return false;
			}
			else if(val1 !=null && val2 !=null && val1 != val2 )
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: alert16 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('snmpMgrAuthConPwdAdd').reset();
						Ext.getCmp('snmpMgrAuthConPwdAdd').focus(true);
					}
				});
				return false;
			}

			if(snmpEncryptFlag == true)
			{
				snmpEncryptPwd = Ext.getCmp('snmpMgrEncryptPwdAdd').getValue(); //request.getParameter("encryptpassword");
				var val1 = snmpEncryptPwd;
				var val2 = Ext.getCmp('snmpMgrEncryptConPwdAdd').getValue();
				if(val1!=null && !checkblank(val1))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: alert10 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							Ext.getCmp('snmpMgrEncryptPwdAdd').focus(true);
						}
					});
					return false;
				}
				else if(val2 !=null && !checkblank(val2))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: alert10 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							Ext.getCmp('snmpMgrEncryptConPwdAdd').focus(true);
						}
					});
					return false;
				}
				else if(val1 !=null && val2 !=null && val1 != val2 )
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: alert16 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							Ext.getCmp('snmpMgrEncryptConPwdAdd').reset();
							Ext.getCmp('snmpMgrEncryptConPwdAdd').focus(true);
						}
					});
					return false;
				}
			}
		}

		if(!validateSingleByte(CommunityObj.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: validationMsg6 +".",
				buttons: Ext.Msg.OK,
				width : 400,
				icon: 'iconExclamation',
				fn : function(btn){
					Community.focus(true);
				}
			});
			return false;
		}
		else if (CommunityObj.getValue().indexOf(">") > -1 ||
			CommunityObj.getValue().indexOf("<") > -1 ||
			CommunityObj.getValue().indexOf("|") > -1 ||
			CommunityObj.getValue().indexOf("\"") > -1)
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: _snmpcomma +".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					Community.focus(true);
				}
			});
			return false;
		}
		else if (CommunityObj.getValue() != null && (CommunityObj.getValue().indexOf("-") == 0 ||
				CommunityObj.getValue().charAt(CommunityObj.getValue().length-1) == '-'))
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: validationMsg7 +".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					Community.focus(true);
				}
			});
			return false;
		}

		/*var autoManage = Ext.getCmp('autoManageYes').getValue();
		var wildcardpatten = Ext.getCmp('wildcardpatten');
		if (autoManage == true)
		{
			if (!checkspecialnomess(wildcardpatten.getValue(),"~!@-+#$%^&()'<>[]\=_"))
			{
				Ext.Msg.show({
					title: pageTitle2,
					msg: intnlLabel25 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						wildcardpatten.focus(true);
					}
				});
				return false;
			}
			else if (wildcardpatten.getValue().indexOf("**") != -1)
			{
				Ext.Msg.show({
					title: pageTitle2,
					msg: intnlLabel26 +".",
					width : 400,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						wildcardpatten.focus(true);
					}
				});
				return false;
			}
			else if (wildcardpatten.getValue().charAt(0) == ',' || wildcardpatten.getValue().charAt(wildcardpatten.getValue().length-1) == ',')
			{
				Ext.Msg.show({
					title: pageTitle2,
					msg: intnlLabel27 +".",
					width : 400,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						wildcardpatten.focus(true);
					}
				});
				return false;
			}
		}*/
		//SNMP String validation ends
		return true;
	},
	showPortSummary : function()
	{
		Ext.getCmp('serverPorts').show();
	},
	setIntnlLabels : function(setIntnlLabels)
	{
		for (var key in setIntnlLabels)
		{
			var tmpObj = Ext.getCmp(key);
			if (tmpObj == null || tmpObj == "undefined")
			{
				continue;
			}
			tmpObj.setFieldLabel(setIntnlLabels[key]);
		}
	},
	validateFormVC : function(urlFrom)
	{
		var me = this;
		var ipAdd;
		if (urlFrom == "add")
		{
			ipAdd = Ext.getCmp('ipAdd');
		}
		else
		{
			ipAdd = Ext.getCmp('ipModify');
		}
		var uname = Ext.getCmp('uname');
		var pass = Ext.getCmp('pass');
		var webport = Ext.getCmp('webport');
		var confpasswd = Ext.getCmp('confpasswd');
		var ipVal = ipAdd.getValue();
		var userVal = uname.getValue();

		var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		var webPortValue = webport.getValue();
		if(ipVal == 'Choose vCenter')
		{
			Ext.Msg.alert(pageTitle2,validationMsg35,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				}
			});
			ipAdd.focus(true);
			return false;
		}
		if(!checkblank(ipVal) || ipVal == 'none'||ipVal == 'None'||ipVal == 'other'||ipVal == 'Other')
		{
			if (urlFrom == "add")
			{
				Ext.Msg.alert(pageTitle2,intnlLabel21,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				ipAdd.focus(true);
			}
			else
			{
				Ext.Msg.alert(pageTitle2,validationMsg35,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				ipAdd.focus(true);
			}
			return false;
		}
		var ChkipOrhname = validateHostFieldExtjs(ipVal)//New IP Validation Starts here
		if(ChkipOrhname == "1")
		{ 
				Ext.Msg.alert(pageTitle2,_checkIp,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		else if(ChkipOrhname == "5")
		{
				Ext.Msg.alert(pageTitle2,_checkspaceIp,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		else if(ChkipOrhname == "7")
		{
				Ext.Msg.alert(pageTitle2,_checkspecial,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		else if(ChkipOrhname == "8")
		{
				Ext.Msg.alert(pageTitle2,_valIp,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		else if(ChkipOrhname == "9")
		{
				Ext.Msg.alert(pageTitle2,_validateHostDot,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		else if(ChkipOrhname == "10")
		{
				Ext.Msg.alert(pageTitle2,_checknum,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		else if(ChkipOrhname == "16")
		{
				Ext.Msg.alert(pageTitle2,_checkNumberLabel,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}//New IP Validation ends here
		var hostLen = ipVal;
		if (hostLen != null && hostLen.length > 40)
		{
			Ext.Msg.alert(pageTitle2,validationMsg36,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			ipAdd.focus(true);
			return false;
		}
		if(!checkblank(webport.getValue()))//flow changed here
		{
			Ext.Msg.alert(pageTitle2,validationMsg42,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(checkspaceExtjs(webport.getValue()) != '0')
		{
			Ext.Msg.alert(pageTitle2,validationMsg2,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if (webport.getValue() > 99999)
		{
			Ext.Msg.alert(pageTitle2,validationMsg43,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(!checkcomma(webport.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg10,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				}
			});
			return false;
		}
		else if (((!checknumber("+",webport.getValue()) && webPortValue.indexOf(',') == -1) || webPortValue == 0 || webPortValue.indexOf('.') > -1) && (webPortValue == 'NULL') || (webPortValue.indexOf(',') > -1))
		{
			Ext.Msg.alert(pageTitle2,validationMsg12,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecialnomess(webport.getValue(),splChar) && (webPortValue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,validationMsg13,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}//flow change ends here
		if(!checkblank(userVal))
		{
			Ext.Msg.alert(pageTitle2,validationMsg37,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			return false;
		}
		//else if(!checkspecial(userVal,"@#$%^&*+={}|:;\"\'<>,\/"))
		else if(checkSpecialExtjs(userVal,"#=|\"\'<>,\/") != '0')//replaced checkspecial by checkSpecialExtjs fn
		{
			Ext.Msg.alert(pageTitle2,validationMsg13,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			return false;
		}
		else if(!checkHyphenText(userVal,"uname"))
		{
			uname.focus(true);
			return false;
		}

		if(pass.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg38,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			pass.focus(true);
			return false;
		}
		else if(!checkspace(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(!checkspecialnomess(pass.getValue(),"|"))
		{
			Ext.Msg.alert(pageTitle2,validationMsg39,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			pass.focus(true);
			return false;
		}
		else if(!checkForPassValidity(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(confpasswd.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg40,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			confpasswd.focus(true);
			return false;
		}
		else if(!checkspace(confpasswd.getValue()))
		{
			confpasswd.focus(true);
			return false;
		}
		else if(pass.getValue() != confpasswd.getValue())
		{
			Ext.Msg.alert(pageTitle2,validationMsg41,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			confpasswd.focus(true);
			return false;
		}
		return true;
	},
	validateFormHMC : function(fromURL)
	{
		var ipAdd;
		if (fromURL == "add")
		{
			ipAdd = Ext.getCmp('ipAdd');
		}
		else
		{
			ipAdd = Ext.getCmp('ipModify');
		}
		var hName = Ext.getCmp('hName');
		var uname = Ext.getCmp('uname');
		var pass = Ext.getCmp('pass');
		var confpasswd = Ext.getCmp('confpasswd');
		var ipVal = ipAdd.getValue();
		var userVal = uname.getValue();

		var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		if(ipVal == 'Choose HMC IP address')
		{
			Ext.Msg.alert(pageTitle2,validationMsg44,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		if(!checkblank(ipVal))
		{
			Ext.Msg.alert(pageTitle2,validationMsg45,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		if (fromURL == "add")
		{			
			var validateIpAddRetVal = validateIpExtjs(ipVal)//New IP Validation Starts here
			if(validateIpAddRetVal == "1")
			{
				Ext.Msg.alert(pageTitle2,_checkIp,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(validateIpAddRetVal == "5")
			{
				Ext.Msg.alert(pageTitle2,_checkspaceIp,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(validateIpAddRetVal == "6")
			{
				Ext.Msg.alert(pageTitle2,_checkAlpha,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(validateIpAddRetVal == "7")
			{
				Ext.Msg.alert(pageTitle2,_checkspecial,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(validateIpAddRetVal == "8")
			{
				Ext.Msg.alert(pageTitle2,_valIp,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(validateIpAddRetVal == "10")
			{
				Ext.Msg.alert(pageTitle2,_checknum,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}//New IP Validation ends here
		}
		if(!checkblank(hName.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg46,function(btn){
				if (btn == 'ok'){
					hName.focus(true);
				 }
			});
			return false;
		}
		var hostLen = hName.getValue();
		if (hostLen != null && hostLen.length > 32)
		{
			Ext.Msg.alert(pageTitle2,validationMsg36,function(btn){
				if (btn == 'ok'){
					hName.focus(true);
				 }
			});
			return false;
		}
		else if(checkspaceExtjs(hName.getValue()) != '0')
		{
			Ext.Msg.alert(pageTitle2,validationMsg2,function(btn){
				if (btn == 'ok'){
					hName.focus(true);
				}
			});
			return false;
		}
		else if(checkspecialExtjs(hName.getValue(),"	`~!@#$%^&*()+={}[]|:\"\'<>,\/;") != '0')
		{
			Ext.Msg.alert(pageTitle2,tmpValidationMsg5+" Host Name",function(btn){
				if (btn == 'ok'){
					hName.focus(true);
				}
			});
			return false;
		}

		if(!checkblank(userVal))
		{
			Ext.Msg.alert(pageTitle2,validationMsg37,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			return false;
		}
		else if(checkSpecialExtjs(userVal,"	@#$%^&*+={}|:;\"\'<>,\/") != '0')//replaced checkspecial by checkSpecialExtjs fn
		{
			Ext.Msg.alert(pageTitle2,validationMsg13,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			return false;
		}
		else if(!checkHyphenText(userVal,"uname"))
		{
			uname.focus(true);
			return false;
		}

		if(pass.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg38,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(!checkspecialnomess(pass.getValue(),"|"))
		{
			Ext.Msg.alert(pageTitle2,validationMsg39,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			return false;
		}
		else if(!checkForPassValidity(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(confpasswd.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg40,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(confpasswd.getValue()))
		{
			confpasswd.focus(true);
			return false;
		}
		else if(pass.getValue() != confpasswd.getValue())
		{
			Ext.Msg.alert(pageTitle2,validationMsg41,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			return false;
		}
		return true;
	},
	validateFormNutanix : function(fromURL)
	{
		var ipAdd;
		if (fromURL == "add")
		{
			ipAdd = Ext.getCmp('ipAdd');
		}
		else
		{
			ipAdd = Ext.getCmp('ipModify');
		}
		var uname = Ext.getCmp('uname');
		var pass = Ext.getCmp('pass');
		var webport = Ext.getCmp('webport');
		var confpasswd = Ext.getCmp('confpasswd');
		var ipVal = ipAdd.getValue();
		var userVal = uname.getValue();

		var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		var webPortValue = webport.getValue();
		if(ipVal == 'Choose Nutanix Prism')
		{
			Ext.Msg.alert(pageTitle2,validationMsg97,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		if(!checkblank(ipVal))
		{
			Ext.Msg.alert(pageTitle2,intnlLabel39,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		if (fromURL == "add")
		{
			var ChkipOrhname = validateHostFieldExtjs(ipVal)//New IP Validation Starts here
			if(ChkipOrhname == "1")
			{ 
					Ext.Msg.alert(pageTitle2,_checkIp,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(ChkipOrhname == "5")
			{
					Ext.Msg.alert(pageTitle2,_checkspaceIp,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(ChkipOrhname == "7")
			{
					Ext.Msg.alert(pageTitle2,_checkspecial,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(ChkipOrhname == "8")
			{
					Ext.Msg.alert(pageTitle2,_valIp,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(ChkipOrhname == "9")
			{
					Ext.Msg.alert(pageTitle2,_validateHostDot,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(ChkipOrhname == "10")
			{
					Ext.Msg.alert(pageTitle2,_checknum,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(ChkipOrhname == "16")
			{
					Ext.Msg.alert(pageTitle2,_checkNumberLabel,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}//New IP Validation ends here
		}
		/*if(!checkblank(hName.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg46,function(btn){
				if (btn == 'ok'){
					hName.focus(true);
				 }
			});
			return false;
		}
		var hostLen = hName.getValue();
		if (hostLen != null && hostLen.length > 32)
		{
			Ext.Msg.alert(pageTitle2,validationMsg36,function(btn){
				if (btn == 'ok'){
					hName.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(hName.getValue()))
		{
			hName.focus(true);
			return false;
		}
		else if(!checkspecial(hName.getValue(),"	`~!@#$%^&*()+={}[]|:\"\'<>,\/;"))
		{
			hName.focus(true);
			return false;
		}*/
		var hostLen = ipVal;
		if (hostLen != null && hostLen.length > 40)
		{
			Ext.Msg.alert(pageTitle2,validationMsg49,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		if(!checkblank(webport.getValue()))//webport validation included
		{
			Ext.Msg.alert(pageTitle2,validationMsg42,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(checkspaceExtjs(webport.getValue()) != '0')
		{
			Ext.Msg.alert(pageTitle2,validationMsg2,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if (webport.getValue() > 99999)
		{
			Ext.Msg.alert(pageTitle2,validationMsg43,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(!checkcomma(webport.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg10,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				}
			});
			return false;
		}
		else if (((!checknumber("+",webport.getValue()) && webPortValue.indexOf(',') == -1) || webPortValue == 0 || webPortValue.indexOf('.') > -1) && (webPortValue == 'NULL') || (webPortValue.indexOf(',') > -1))
		{
			Ext.Msg.alert(pageTitle2,validationMsg12,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecialnomess(webport.getValue(),splChar) && (webPortValue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,validationMsg13,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}//webport validation ends here
		if(!checkblank(userVal))
		{
			Ext.Msg.alert(pageTitle2,validationMsg37,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			return false;
		}
		else if(checkSpecialExtjs(userVal,"	*+=|:;\"\'<>,\/[]?") != '0')//replaced checkspecial by checkSpecialExtjs fn
		{
			Ext.Msg.alert(pageTitle2,validationMsg13,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			return false;
		}
		else if(!checkHyphenText(userVal,"uname"))
		{
			uname.focus(true);
			return false;
		}

		if(pass.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg38,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(!checkspecialnomess(pass.getValue(),"|"))
		{
			Ext.Msg.alert(pageTitle2,validationMsg39,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			return false;
		}
		else if(!checkForPassValidity(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(confpasswd.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg40,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(confpasswd.getValue()))
		{
			confpasswd.focus(true);
			return false;
		}
		else if(pass.getValue() != confpasswd.getValue())
		{
			Ext.Msg.alert(pageTitle2,validationMsg41,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			return false;
		}
		return true;
	},
	validateRHEVForm : function(fromURL)
	{
		var ipAdd;
		if (fromURL == "add")
		{
			ipAdd = Ext.getCmp('ipAdd');
		}
		else
		{
			ipAdd = Ext.getCmp('ipModify');
		}
		var uname = Ext.getCmp('uname');
		var pass = Ext.getCmp('pass');
		var webport = Ext.getCmp('webport');
		var confpasswd = Ext.getCmp('confpasswd');
		var ipVal = ipAdd.getValue();
		var userVal = uname.getValue();

		var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		var webPortValue = webport.getValue();
		if(ipVal == 'Choose RHEV Manager')
		{
			Ext.Msg.alert(pageTitle2,validationMsg47,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		if(!checkblank(ipVal)||ipVal == 'none'||ipVal == 'None'||ipVal == 'other'||ipVal == 'Other')
		{
			Ext.Msg.alert(pageTitle2,validationMsg48,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		if (fromURL == "add")
		{			
			var ChkipOrhname = validateHostFieldExtjs(ipVal)//New IP Validation Starts here
			if(ChkipOrhname == "1")
			{ 
					Ext.Msg.alert(pageTitle2,_checkIp,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(ChkipOrhname == "5")
			{
					Ext.Msg.alert(pageTitle2,_checkspaceIp,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(ChkipOrhname == "7")
			{
					Ext.Msg.alert(pageTitle2,_checkspecial,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(ChkipOrhname == "8")
			{
					Ext.Msg.alert(pageTitle2,_valIp,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(ChkipOrhname == "9")
			{
					Ext.Msg.alert(pageTitle2,_validateHostDot,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(ChkipOrhname == "10")
			{
					Ext.Msg.alert(pageTitle2,_checknum,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
			else if(ChkipOrhname == "16")
			{
					Ext.Msg.alert(pageTitle2,_checkNumberLabel,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}//New IP Validation ends here
		}
		var hostLen = ipVal;
		if (hostLen != null && hostLen.length > 40)
		{
			Ext.Msg.alert(pageTitle2,validationMsg49,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		if(!checkblank(webport.getValue()))//WEBPORT FLOW CHANGED HERE
		{
			Ext.Msg.alert(pageTitle2,validationMsg42,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(checkspaceExtjs(webport.getValue()) != '0')//replaced checkspace by checkspaceExtjs fn
		{
			Ext.Msg.alert(pageTitle2,validationMsg13,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if (webport.getValue() > 99999)
		{
			Ext.Msg.alert(pageTitle2,validationMsg43,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(!checkcomma(webport.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg10,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if (((!checknumber("+",webport.getValue()) && webPortValue.indexOf(',') == -1) || webPortValue == 0 || webPortValue.indexOf('.') > -1) && (webPortValue == 'NULL') || (webPortValue.indexOf(',') > -1))
		{
			Ext.Msg.alert(pageTitle2,validationMsg12,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecialnomess(webport.getValue(),splChar) && (webPortValue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,validationMsg13,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}//WEBPORT FLOW CHANGE ENDS HERE
		if(!checkblank(userVal))
		{
			Ext.Msg.alert(pageTitle2,validationMsg37,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			return false;
		}
		else if(checkSpecialExtjs(userVal,"	@#$%^&*+={}|:;\"\'<>,\/") != '0')//replaced checkspecial by checkSpecialExtjs fn
		{
			Ext.Msg.alert(pageTitle2,validationMsg13,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			return false;
		}
		else if(!checkHyphenText(userVal,"uname"))
		{
			uname.focus(true);
			return false;
		}

		if(pass.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg38,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(!checkspecialnomess(pass.getValue(),"|"))
		{
			Ext.Msg.alert(pageTitle2,validationMsg39,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			return false;
		}
		else if(!checkForPassValidity(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(confpasswd.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg40,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(confpasswd.getValue()))
		{
			confpasswd.focus(true);
			return false;
		}
		else if(pass.getValue() != confpasswd.getValue())
		{
			Ext.Msg.alert(pageTitle2,validationMsg41,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			return false;
		}
		return true;
	},
	validateCtxXenPoolForm : function(fromURL)
	{
		var ipAdd;
		if (fromURL == "add")
		{
			ipAdd = Ext.getCmp('ipAdd');
		}
		else
		{
			ipAdd = Ext.getCmp('ipModify');
		}
		var uname = Ext.getCmp('uname');
		var pass = Ext.getCmp('pass');
		var webport = Ext.getCmp('webport');
		var confpasswd = Ext.getCmp('confpasswd');
		var ipVal = ipAdd.getValue();
		var userVal = uname.getValue();
		var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";

		var webPortValue = Ext.getCmp('webport').getValue();
		if(ipVal == '-1')
		{
			Ext.Msg.alert(pageTitle2,validationMsg100,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		if(!checkblank(ipVal)||ipVal == 'none'||ipVal == 'None'||ipVal == 'other'||ipVal == 'Other')
		{
			Ext.Msg.alert(pageTitle2,validationMsg101,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		if (fromURL == "add")
		{
			if(!validateIpOrHName(ipVal))
			{
				ipAdd.focus(true);
				return false;
			}
		}
	//	var hostLen = ipVal;
	//	if (hostLen != null && hostLen.length > 40)
	//	{
	//		Ext.Msg.alert(pageTitle2,validationMsg49,function(btn){
	//			if (btn == 'ok'){
	//				ipAdd.focus(true);
	//			 }
	//		});
	//		return false;
	//	}
		if(!checkblank(userVal))
		{
			Ext.Msg.alert(pageTitle2,validationMsg37,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecial(userVal,"	@#$%^&*+={}|:;\"\'<>,\/"))
		{
			uname.focus(true);
			return false;
		}
		else if(!checkHyphenText(userVal,"uname"))
		{
			uname.focus(true);
			return false;
		}

		if(pass.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg38,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(!checkspecialnomess(pass.getValue(),"|"))
		{
			Ext.Msg.alert(pageTitle2,validationMsg39,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			return false;
		}
		else if(!checkForPassValidity(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(confpasswd.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg40,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(confpasswd.getValue()))
		{
			confpasswd.focus(true);
			return false;
		}
		else if(pass.getValue() != confpasswd.getValue())
		{
			Ext.Msg.alert(pageTitle2,validationMsg41,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			return false;
		}
		else if(!checkblank(webport.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg42,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(webport.getValue()))
		{
			webport.focus(true);
			return false;
		}
		else if (webport.getValue() > 99999)
		{
			Ext.Msg.alert(pageTitle2,validationMsg43,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(!checkcomma(webport.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg10,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if (((!checknumber("+",webport.getValue()) && webPortValue.indexOf(',') == -1) || webPortValue == 0 || webPortValue.indexOf('.') > -1) && (webPortValue == 'NULL') || (webPortValue.indexOf(',') > -1))
		{
			Ext.Msg.alert(pageTitle2,validationMsg12,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecialnomess(webport.getValue(),splChar) && (webPortValue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,validationMsg13,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		return true;
	},
	validateOracleVMForm : function(fromURL)//Oracle VM Manager
	{
		var ipAdd;
		if (fromURL == "add")
		{
			ipAdd = Ext.getCmp('ipAdd');
		}
		else
		{
			ipAdd = Ext.getCmp('ipModify');
		}
		var uname = Ext.getCmp('uname');
		var pass = Ext.getCmp('pass');
		var webport = Ext.getCmp('webport');
		var confpasswd = Ext.getCmp('confpasswd');
		var ipVal = ipAdd.getValue();
		var userVal = uname.getValue();
		var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";

		var webPortValue = Ext.getCmp('webport').getValue();
		if(ipVal == '-1')
		{
			Ext.Msg.alert(pageTitle2,validationMsg116,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		if(!checkblank(ipVal)||ipVal == 'none'||ipVal == 'None'||ipVal == 'other'||ipVal == 'Other')
		{
			Ext.Msg.alert(pageTitle2,validationMsg117,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}
		if (fromURL == "add")
		{
			if(!validateIpOrHName(ipVal))
			{
				ipAdd.focus(true);
				return false;
			}
		}
	//	var hostLen = ipVal;
	//	if (hostLen != null && hostLen.length > 40)
	//	{
	//		Ext.Msg.alert(pageTitle2,validationMsg49,function(btn){
	//			if (btn == 'ok'){
	//				ipAdd.focus(true);
	//			 }
	//		});
	//		return false;
	//	}
		if(!checkblank(userVal))
		{
			Ext.Msg.alert(pageTitle2,validationMsg37,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecial(userVal,"	@#$%^&*+={}|:;\"\'<>,\/"))
		{
			uname.focus(true);
			return false;
		}
		else if(!checkHyphenText(userVal,"uname"))
		{
			uname.focus(true);
			return false;
		}

		if(pass.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg38,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(!checkspecialnomess(pass.getValue(),"|"))
		{
			Ext.Msg.alert(pageTitle2,validationMsg39,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			return false;
		}
		else if(!checkForPassValidity(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(confpasswd.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg40,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(confpasswd.getValue()))
		{
			confpasswd.focus(true);
			return false;
		}
		else if(pass.getValue() != confpasswd.getValue())
		{
			Ext.Msg.alert(pageTitle2,validationMsg41,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			return false;
		}
		else if(!checkblank(webport.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg42,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(webport.getValue()))
		{
			webport.focus(true);
			return false;
		}
		else if (webport.getValue() > 99999)
		{
			Ext.Msg.alert(pageTitle2,validationMsg43,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(!checkcomma(webport.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg10,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if (((!checknumber("+",webport.getValue()) && webPortValue.indexOf(',') == -1) || webPortValue == 0 || webPortValue.indexOf('.') > -1) && (webPortValue == 'NULL') || (webPortValue.indexOf(',') > -1))
		{
			Ext.Msg.alert(pageTitle2,validationMsg12,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecialnomess(webport.getValue(),splChar) && (webPortValue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,validationMsg13,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		return true;
	},
	validateFormCloud : function(urlFrom)
	{
		var accountObj;
		if (urlFrom == "add")
		{
			accountObj = Ext.getCmp('accountAdd');
		}
		else
		{
			accountObj = Ext.getCmp('accountModify');
		}
		var accessKeyObj = Ext.getCmp('accessKey');
		var confAccessKeyObj = Ext.getCmp('confAccessKey');
		var secretKeyObj = Ext.getCmp('secretKey');
		var confSecretKeyObj = Ext.getCmp('confSecretKey');
		var accountVal = accountObj.getValue();

		var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		if(accountVal == 'Choose account')
		{
			Ext.Msg.alert(pageTitle2,validationMsg50,function(btn){
				if (btn == 'ok'){
					accountObj.focus(true);
				 }
			});
			return false;
		}
		if(!checkblank(accountVal))
		{
			Ext.Msg.alert(pageTitle2,validationMsg51,function(btn){
				if (btn == 'ok'){
					accountObj.focus(true);
				 }
			});
			return false;
		}

		if(!checkblank(accessKeyObj.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg52,function(btn){
				if (btn == 'ok'){
					accessKeyObj.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecial(accessKeyObj.getValue(),"`~!@#$%^&*()={}[]|;\"\'<>,?"))
		{
			accessKeyObj.focus(true);
			return false;
		}
		else if(!checkHyphenText(accessKeyObj.getValue(), "accessKey"))
		{
			accessKeyObj.focus(true);
			return false;
		}

		if(accessKeyObj.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg52,function(btn){
				if (btn == 'ok'){
					accessKeyObj.focus(true);
				 }
			});
			return false;
		}
		else if(confAccessKeyObj.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg53,function(btn){
				if (btn == 'ok'){
					confAccessKeyObj.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(accessKeyObj.getValue()))
		{
			accessKeyObj.focus(true);
			return false;
		}
		else if(!checkForPassValidity(accessKeyObj.getValue()))
		{
			accessKeyObj.focus(true);
			return false;
		}
		else if(!checkblank(confAccessKeyObj.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg53,function(btn){
				if (btn == 'ok'){
					confAccessKeyObj.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(confAccessKeyObj.getValue()))
		{
			confAccessKeyObj.focus(true);
			return false;
		}
		else if(accessKeyObj.getValue() != confAccessKeyObj.getValue())
		{
			Ext.Msg.alert(pageTitle2,validationMsg54,function(btn){
				if (btn == 'ok'){
					confAccessKeyObj.focus(true);
				 }
			});
			return false;
		}
		if(!checkblank(secretKeyObj.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg55,function(btn){
				if (btn == 'ok'){
					secretKeyObj.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecial(secretKeyObj.getValue(),"	`~!@#$%^&*()={}[]|;\"\'<>,?"))
		{
			secretKeyObj.focus(true);
			return false;
		}
		else if(!checkHyphenText(secretKeyObj.getValue(), "secretKey"))
		{
			secretKeyObj.focus(true);
			return false;
		}

		if(secretKeyObj.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg55,function(btn){
				if (btn == 'ok'){
					secretKeyObj.focus(true);
				 }
			});
			return false;
		}
		else if(confSecretKeyObj.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg56,function(btn){
				if (btn == 'ok'){
					confSecretKeyObj.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(secretKeyObj.getValue()))
		{
			secretKeyObj.focus(true);
			return false;
		}

		else if(!checkForPassValidity(secretKeyObj.getValue()))
		{
			secretKeyObj.focus(true);
			return false;
		}
		else if(!checkblank(confSecretKeyObj.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg56,function(btn){
				if (btn == 'ok'){
					confSecretKeyObj.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(confSecretKeyObj.getValue()))
		{
			secretKeyObj.focus(true);
			return false;
		}
		else if(secretKeyObj.getValue() != confSecretKeyObj.getValue())
		{
			Ext.Msg.alert(pageTitle2,validationMsg57,function(btn){
				if (btn == 'ok'){
					confSecretKeyObj.focus(true);
				 }
			});
			return false;
		}
		return true;
	},
	validateNetScalerIP : function(ipAdd)
	{
		var me = this;
		var url = 'EgServerDiscovery/data/EgNetScalerJson.jsp?from=getAllNetScalers';
		me.updateDiscoveryTree(url);
		var array1 = publicJSON['comboArray'];
		for(var i = 0; i < array1.length; i++)
		{
			var ip = array1[i]['valueField'];
			if(ip.toLowerCase() == ipAdd.toLowerCase())
			{
				return false;
			}
		}
		return true;
	},
	validateCloudDirectoryIP : function(ipAdd)
	{
		var me = this;
		var url = 'EgServerDiscovery/data/EgCloudDirectoryJson.jsp?from=getAllvCloud';
		me.updateDiscoveryTree(url);
		var array1 = publicJSON['comboArray'];
		for(var i = 0; i < array1.length; i++)
		{
			var ip = array1[i]['valueField'];
			if(ip.toLowerCase() == ipAdd.toLowerCase())
			{
				return false;
			}
		}
		return true;
	},
	validateStoragePlatformIP : function(ipAdd)
	{
		var me = this;
		var url = 'EgServerDiscovery/data/EgStoragePlatformJson.jsp?from=getAllStoragePlatforms';
		me.updateDiscoveryTree(url);
		var array1 = publicJSON['comboArray'];
		for(var i = 0; i < array1.length; i++)
		{
			var ip = array1[i]['valueField'];
			if(ip.toLowerCase() == ipAdd.toLowerCase())
			{
				return false;
			}
		}
		return true;
	},
	validateRabbitMQIP : function(ipAdd)
	{
		var me = this;
		var url = 'EgServerDiscovery/data/EgRabbitMQNodeJson.jsp?from=getAllRabbitMQ';
		me.updateDiscoveryTree(url);
		var array1 = publicJSON['comboArray'];
		for(var i = 0; i < array1.length; i++)
		{
			var ip = array1[i]['valueField'];
			if(ip.toLowerCase() == ipAdd.toLowerCase())
			{
				return false;
			}
		}
		return true;
	},
	validateFormNetScaler : function(urlFrom)
	{
		var me = this;
		var ipAdd;
		if (urlFrom == "add")
		{
			ipAdd = Ext.getCmp('ipAdd');
		}
		else
		{
			ipAdd = Ext.getCmp('ipModify');
		}
		var ssl = Ext.getCmp('ssl');
		var discover = Ext.getCmp('isDiscovery');
		var uname = Ext.getCmp('uname');
		var pass = Ext.getCmp('pass');
		var confpasswd = Ext.getCmp('confpasswd');

		var ipVal = ipAdd.getValue();
		
		if(ipVal == '-1')
		{
			Ext.Msg.alert(pageTitle2,validationMsg91,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				}
			});
			ipAdd.focus(true);
			return false;
		}
		if(!checkblank(ipVal) || ipVal == 'none'||ipVal == 'None'||ipVal == 'other'||ipVal == 'Other')
		{
			if (urlFrom == "add")
			{
				Ext.Msg.alert(pageTitle2,intnlLabel38,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				ipAdd.focus(true);
			}
			else
			{
				Ext.Msg.alert(pageTitle2,validationMsg91,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				ipAdd.focus(true);
			}
			return false;
		}
		if(!validateIpOrHName(ipVal))
		{
			ipAdd.focus(true);
			return false;
		}
		if(urlFrom == "add")
		{
			if(!me.validateNetScalerIP(ipAdd.getValue()))
			{
				Ext.Msg.alert(pageTitle2,validationMsg95,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
		}
		var hostLen = ipVal;
		if (hostLen != null && hostLen.length > 40)
		{
			Ext.Msg.alert(pageTitle2,validationMsg36,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			ipAdd.focus(true);
			return false;
		}

		var userVal = uname.getValue();
		if(!checkblank(userVal))
		{
			Ext.Msg.alert(pageTitle2,validationMsg37,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			uname.focus(true);
			return false;
		}
		//else if(!checkspecial(userVal,"@#$%^&*+={}|:;\"\'<>,\/"))
		else if(!checkspecial(userVal,"#=|\"\'<>,\/"))
		{
			uname.focus(true);
			return false;
		}
		else if(!checkHyphenText(userVal,"uname"))
		{
			uname.focus(true);
			return false;
		}

		if(pass.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg38,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			pass.focus(true);
			return false;
		}
		else if(!checkspace(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(!checkspecialnomess(pass.getValue(),"|"))
		{
			Ext.Msg.alert(pageTitle2,validationMsg39,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			pass.focus(true);
			return false;
		}
		else if(!checkForPassValidity(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(confpasswd.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg40,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			confpasswd.focus(true);
			return false;
		}
		else if(!checkspace(confpasswd.getValue()))
		{
			confpasswd.focus(true);
			return false;
		}
		else if(pass.getValue() != confpasswd.getValue())
		{
			Ext.Msg.alert(pageTitle2,validationMsg41,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			confpasswd.focus(true);
			return false;
		}
		return true;
	},

	validateFormCloudDirectory : function(urlFrom)
	{
		var me = this;
		var ipAdd;
		if (urlFrom == "add")
		{
			ipAdd = Ext.getCmp('ipAdd');
		}
		else
		{
			ipAdd = Ext.getCmp('ipModify');
		}
		var ssl = Ext.getCmp('ssl');
		var discover = Ext.getCmp('isDiscovery');
		var uname = Ext.getCmp('uname');
		var pass = Ext.getCmp('pass');
		var confpasswd = Ext.getCmp('confpasswd');

		var ipVal = ipAdd.getValue();
		
		if(ipVal == '-1')
		{
			Ext.Msg.alert(pageTitle2,validationMsg104,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				}
			});
			ipAdd.focus(true);
			return false;
		}
		if(!checkblank(ipVal) || ipVal == 'none'||ipVal == 'None'||ipVal == 'other'||ipVal == 'Other')
		{
			if (urlFrom == "add")
			{
				Ext.Msg.alert(pageTitle2,intnlLabel48,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				ipAdd.focus(true);
			}
			else
			{
				Ext.Msg.alert(pageTitle2,validationMsg104,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				ipAdd.focus(true);
			}
			return false;
		}
		if(!validateIpOrHName(ipVal))
		{
			ipAdd.focus(true);
			return false;
		}
		if(urlFrom == "add")
		{
			if(!me.validateCloudDirectoryIP(ipAdd.getValue()))
			{
				Ext.Msg.alert(pageTitle2,validationMsg95,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
		}
		var hostLen = ipVal;
		if (hostLen != null && hostLen.length > 40)
		{
			Ext.Msg.alert(pageTitle2,validationMsg36,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			ipAdd.focus(true);
			return false;
		}

		var userVal = uname.getValue();
		if(!checkblank(userVal))
		{
			Ext.Msg.alert(pageTitle2,validationMsg37,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			uname.focus(true);
			return false;
		}
		//else if(!checkspecial(userVal,"@#$%^&*+={}|:;\"\'<>,\/"))
		else if(!checkspecial(userVal,"#=|\"\'<>,\/"))
		{
			uname.focus(true);
			return false;
		}
		else if(!checkHyphenText(userVal,"uname"))
		{
			uname.focus(true);
			return false;
		}

		if(pass.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg38,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			pass.focus(true);
			return false;
		}
		else if(!checkspace(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(!checkspecialnomess(pass.getValue(),"|"))
		{
			Ext.Msg.alert(pageTitle2,validationMsg39,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			pass.focus(true);
			return false;
		}
		else if(!checkForPassValidity(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(confpasswd.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg40,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			confpasswd.focus(true);
			return false;
		}
		else if(!checkspace(confpasswd.getValue()))
		{
			confpasswd.focus(true);
			return false;
		}
		else if(pass.getValue() != confpasswd.getValue())
		{
			Ext.Msg.alert(pageTitle2,validationMsg41,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			confpasswd.focus(true);
			return false;
		}
		return true;
	},
	validateFormStoragePlatform : function(urlFrom)
	{
		var me = this;
		var ipAdd;
		if (urlFrom == "add")
		{
			ipAdd = Ext.getCmp('ipAdd');
		}
		else
		{
			ipAdd = Ext.getCmp('ipModify');
		}
		var ssl = Ext.getCmp('ssl');
		var uname = Ext.getCmp('uname');
		var pass = Ext.getCmp('pass');
		var confpasswd = Ext.getCmp('confpasswd');

		var ipVal = ipAdd.getValue();
		
		if(ipVal == '-1')
		{
			Ext.Msg.alert(pageTitle2,validationMsg109,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				}
			});
			ipAdd.focus(true);
			return false;
		}
		if(!checkblank(ipVal) || ipVal == 'none'||ipVal == 'None'||ipVal == 'other'||ipVal == 'Other')
		{
			if (urlFrom == "add")
			{
				Ext.Msg.alert(pageTitle2,intnlLabel49,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				ipAdd.focus(true);
			}
			else
			{
				Ext.Msg.alert(pageTitle2,validationMsg109,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				ipAdd.focus(true);
			}
			return false;
		}
		if(!validateIpOrHName(ipVal))
		{
			ipAdd.focus(true);
			return false;
		}
		if(urlFrom == "add")
		{
			if(!me.validateStoragePlatformIP(ipAdd.getValue()))
			{
				Ext.Msg.alert(pageTitle2,validationMsg95,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
		}
		var hostLen = ipVal;
		if (hostLen != null && hostLen.length > 40)
		{
			Ext.Msg.alert(pageTitle2,validationMsg36,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			ipAdd.focus(true);
			return false;
		}

		var userVal = uname.getValue();
		if(!checkblank(userVal))
		{
			Ext.Msg.alert(pageTitle2,validationMsg37,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			uname.focus(true);
			return false;
		}
		//else if(!checkspecial(userVal,"@#$%^&*+={}|:;\"\'<>,\/"))
		else if(!checkspecial(userVal,"#=|\"\'<>,\/"))
		{
			uname.focus(true);
			return false;
		}
		else if(!checkHyphenText(userVal,"uname"))
		{
			uname.focus(true);
			return false;
		}

		if(pass.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg38,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			pass.focus(true);
			return false;
		}
		else if(!checkspace(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(!checkspecialnomess(pass.getValue(),"|"))
		{
			Ext.Msg.alert(pageTitle2,validationMsg39,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			pass.focus(true);
			return false;
		}
		else if(!checkForPassValidity(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(confpasswd.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg40,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			confpasswd.focus(true);
			return false;
		}
		else if(!checkspace(confpasswd.getValue()))
		{
			confpasswd.focus(true);
			return false;
		}
		else if(pass.getValue() != confpasswd.getValue())
		{
			Ext.Msg.alert(pageTitle2,validationMsg41,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			confpasswd.focus(true);
			return false;
		}
		return true;
	},
	validateFormRabbitMQ : function(urlFrom)
	{
		var me = this;
		var ipAdd;
		if (urlFrom == "add")
		{
			ipAdd = Ext.getCmp('ipAdd');
		}
		else
		{
			ipAdd = Ext.getCmp('ipModify');
		}
		var ssl = Ext.getCmp('ssl');
		var webport = Ext.getCmp('webport');
		var uname = Ext.getCmp('uname');
		var pass = Ext.getCmp('pass');
		var confpasswd = Ext.getCmp('confpasswd');

		var ipVal = ipAdd.getValue();
		
		if(ipVal == '-1')
		{
			Ext.Msg.alert(pageTitle2,validationMsg113,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				}
			});
			return false;
		}
		if(!checkblank(ipVal) || ipVal == 'none'||ipVal == 'None'||ipVal == 'other'||ipVal == 'Other')
		{
			if (urlFrom == "add")
			{
				Ext.Msg.alert(pageTitle2,intnlLabel50,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
			}
			else
			{
				Ext.Msg.alert(pageTitle2,validationMsg113,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
			}
			return false;
		}
		if(!validateIpOrHName(ipVal))
		{
			ipAdd.focus(true);
			return false;
		}
		if(urlFrom == "add")
		{
			if(!me.validateRabbitMQIP(ipAdd.getValue()))
			{
				Ext.Msg.alert(pageTitle2,validationMsg95,function(btn){
					if (btn == 'ok'){
						ipAdd.focus(true);
					 }
				});
				return false;
			}
		}
		var hostLen = ipVal;
		if (hostLen != null && hostLen.length > 40)
		{
			Ext.Msg.alert(pageTitle2,validationMsg36,function(btn){
				if (btn == 'ok'){
					ipAdd.focus(true);
				 }
			});
			return false;
		}

		var webportVal = webport.getValue();
		if(!checkblank(webportVal))
		{
			Ext.Msg.alert(pageTitle2,validationMsg37,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		if(parseInt(webportVal) > 99999)
		{
			Ext.Msg.alert(pageTitle2,validationMsg43,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(!checkSpecialExtjs(webportVal,"@#$%^&*+={}|:;\"\'<>,\/"))
		{
			Ext.Msg.alert(pageTitle2,validationMsg13,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(checkAlpha(webportVal))
		{
			Ext.Msg.alert(pageTitle2,_checkAlpha,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}
		else if(checkspaceExtjs(webportVal) != '0')
		{
			Ext.Msg.alert(autoDelSetting,validationMsg2,function(btn){
				if (btn == 'ok'){
					webport.focus(true);
				 }
			});
			return false;
		}

		var userVal = uname.getValue();
		if(!checkblank(userVal))
		{
			Ext.Msg.alert(pageTitle2,validationMsg37,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			return false;
		}
		else if(!checkSpecialExtjs(userVal,"#=|\"\'<>,\/"))
		{
			Ext.Msg.alert(pageTitle2,validationMsg13,function(btn){
				if (btn == 'ok'){
					uname.focus(true);
				 }
			});
			return false;
		}
		else if(!checkHyphenText(userVal,"uname"))
		{
			uname.focus(true);
			return false;
		}

		if(pass.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg38,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(!checkspecialnomess(pass.getValue(),"|"))
		{
			Ext.Msg.alert(pageTitle2,validationMsg39,function(btn){
				if (btn == 'ok'){
					pass.focus(true);
				 }
			});
			return false;
		}
		else if(!checkForPassValidity(pass.getValue()))
		{
			pass.focus(true);
			return false;
		}
		else if(confpasswd.getValue() == "")
		{
			Ext.Msg.alert(pageTitle2,validationMsg40,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(confpasswd.getValue()))
		{
			confpasswd.focus(true);
			return false;
		}
		else if(pass.getValue() != confpasswd.getValue())
		{
			Ext.Msg.alert(pageTitle2,validationMsg41,function(btn){
				if (btn == 'ok'){
					confpasswd.focus(true);
				 }
			});
			return false;
		}
		return true;
	},

	clearNSForm : function()
	{
		var action = Ext.getCmp('netscaleraction').getValue();
		if(action == 'ADD')
		{
			Ext.getCmp('ipAdd').setValue("");
		}
		else
		{
			Ext.getCmp('ipModify').setValue("-1");
		}

		Ext.getCmp('ssl').setValue(validationMsg15);
		Ext.getCmp('isDiscovery').setValue(validationMsg15);
		Ext.getCmp('uname').setValue("");
		Ext.getCmp('pass').setValue("");
		Ext.getCmp('confpasswd').setValue("");
	},
	clearCloudDirectory : function()
	{
		var action = Ext.getCmp('clouddirectoryaction').getValue();
		if(action == 'ADD')
		{
			Ext.getCmp('ipAdd').setValue("");
		}
		else
		{
			Ext.getCmp('ipModify').setValue("-1");
		}

		Ext.getCmp('ssl').setValue(validationMsg15);
		Ext.getCmp('isDiscovery').setValue(validationMsg15);
		Ext.getCmp('uname').setValue("");
		Ext.getCmp('pass').setValue("");
		Ext.getCmp('confpasswd').setValue("");
	},
	clearForm : function()
	{
		Ext.getCmp('ipAdd').setValue("");
		Ext.getCmp('uname').setValue("");
		Ext.getCmp('hName').setValue("");
		Ext.getCmp('pass').setValue("");
		Ext.getCmp('confpasswd').setValue("");
	},
	clearFormCloud : function()
	{
		Ext.getCmp('accountAdd').setValue("");
		Ext.getCmp('accessKey').setValue("");
		Ext.getCmp('confAccessKey').setValue("");
		Ext.getCmp('secretKey').setValue("");
		Ext.getCmp('confSecretKey').setValue("");
	},
	clearStoragePlatform : function()
	{
		var action = Ext.getCmp('storagePlatformAction').getValue();
		if(action == 'ADD')
		{
			Ext.getCmp('ipAdd').setValue("");
		}
		else
		{
			Ext.getCmp('ipModify').setValue("-1");
		}

		Ext.getCmp('ssl').setValue(validationMsg15);
		Ext.getCmp('isDiscovery').setValue(validationMsg15);
		Ext.getCmp('uname').setValue("");
		Ext.getCmp('pass').setValue("");
		Ext.getCmp('confpasswd').setValue("");
	},
	clearRabbitMQ : function()
	{
		var action = Ext.getCmp('rabbitMQAction').getValue();
		if(action == 'ADD')
		{
			Ext.getCmp('ipAdd').setValue("");
		}
		else
		{
			Ext.getCmp('ipModify').setValue("-1");
		}

		Ext.getCmp('ssl').setValue(validationMsg15);
		Ext.getCmp('webport').setValue("443");
		Ext.getCmp('isDiscovery').setValue(validationMsg15);
		Ext.getCmp('uname').setValue("");
		Ext.getCmp('pass').setValue("");
		Ext.getCmp('confpasswd').setValue("");
	},
	validateAgentDiscoverySettingsForm : function()
	{
		var me =this;
		var flag = true;
		var splChar = "abcdefghijklmnoprstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		var agentdisc = Ext.getCmp('AgentDiscDelay');
		var agentredisc = Ext.getCmp('AgentReDiscoverPeriod');
		var disctime  = Ext.getCmp('DiscTimeout');
		var agentdiscvalue = agentdisc.getValue();
		var agentrediscvalue=agentredisc.getValue();
		var disctimevalue = disctime.getValue();

		var toposleeptime = Ext.getCmp('TopologySleepTime');
		var toporediscover = Ext.getCmp('TopologyReDiscoverPeriod');
		var toposleeptimevalue = toposleeptime.getValue();
		var toporediscovervalue = toporediscover.getValue();

		for(var i=0;i <agentdiscvalue.length;i++)
		{
			if(agentdiscvalue.charAt(i) == ',' && agentdiscvalue.charAt(i + 1) == ',')
			{
				Ext.Msg.alert(pageTitle2,validationMsg58+" "+tmpValidationMsg,function(btn){
					if (btn == 'ok'){
						agentdisc.focus(true);
					 }
				});
				return false;
			}
			else
			{
				continue;
			}
		}
		for(var j=0;j <agentrediscvalue.length;j++)
		{
			if(agentrediscvalue.charAt(j) == ',' && agentrediscvalue.charAt(j + 1) == ',')
			{
				Ext.Msg.alert(pageTitle2,validationMsg59+" "+tmpValidationMsg,function(btn){
					if (btn == 'ok'){
						agentredisc.focus(true);
					 }
				});
				return false;
			}
			else
			{
				continue;
			}
		}
		for(var k=0;k < disctimevalue.length;k++)
		{
			if(disctimevalue.charAt(k) == ',' && disctimevalue.charAt(k + 1) == ',')
			{
				Ext.Msg.alert(pageTitle2,validationMsg60+" "+tmpValidationMsg,function(btn){
					if (btn == 'ok'){
						disctime.focus(true);
					 }
				});
				return false;
			}
			else
			{
				continue;
			}
		}

		for(var k=0;k<toposleeptimevalue.length;k++)
		{
			if(toposleeptimevalue.charAt(k) == ',' && toposleeptimevalue.charAt(k + 1) == ',')
			{
				Ext.Msg.alert(pageTitle2,validationMsg61+" "+tmpValidationMsg,function(btn){
					if (btn == 'ok'){
						toposleeptime.focus(true);
					 }
				});
				return false;

			}
			else
			{
				continue;
			}
		}

		for(var k=0;k <toporediscovervalue.length;k++)
		{
			if(toporediscovervalue.charAt(k) == ',' && toporediscovervalue.charAt(k + 1) == ',')
			{
				Ext.Msg.alert(pageTitle2,validationMsg61+" "+tmpValidationMsg,function(btn){
					if (btn == 'ok'){
						toporediscover.focus(true);
					 }
				});
				return false;

			}
			else
			{
				continue;
			}
		}

		if(!checkblank(agentdisc.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg58+" "+tmpValidationMsg2,function(btn){
				if (btn == 'ok'){
					agentdisc.focus(true);
				 }
			});
			return false;
		}
		else if(!checkblank(agentredisc.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg59+" "+tmpValidationMsg2,function(btn){
				if (btn == 'ok'){
					agentredisc.focus(true);
				 }
			});
			return false;
		}
		else if(!checkblank(disctime.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg60+" "+tmpValidationMsg2,function(btn){
				if (btn == 'ok'){
					disctime.focus(true);
				 }
			});
			return false;
		}
		else if(!checkblank(toposleeptime.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg61+" "+tmpValidationMsg2,function(btn){
				if (btn == 'ok'){
					toposleeptime.focus(true);
				 }
			});
			return false;
		}
		else if(!checkblank(toporediscover.getValue()))
		{
			Ext.Msg.alert(pageTitle2,validationMsg62+" "+tmpValidationMsg2,function(btn){
				if (btn == 'ok'){
					toporediscover.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspace(agentdisc.getValue()))
		{
			agentdisc.focus(true);
			return false;
		}
		else if(!checkspace(agentredisc.getValue()))
		{
			agentredisc.focus(true);
			return false;
		}
		else if(!checkspace(disctime.getValue()))
		{
			disctime.focus(true);
			return false;
		}
		else if(!checkspace(toposleeptime.getValue()))
		{
			toposleeptime.focus(true);
			return false;
		}
		else if(!checkspace(toporediscover.getValue()))
		{
			toporediscover.focus(true);
			return false;
		}
		else if(!checkcomma(agentdisc.getValue()))
		{
			Ext.Msg.alert(pageTitle2,tmpValidationMsg3+" "+validationMsg58,function(btn){
				if (btn == 'ok'){
					agentdisc.focus(true);
				 }
			});
			return false;
		}
		else if(!checkcomma(agentredisc.getValue()))
		{
			Ext.Msg.alert(pageTitle2,tmpValidationMsg3+" "+validationMsg59,function(btn){
				if (btn == 'ok'){
					agentredisc.focus(true);
				 }
			});
			return false;
		}
		else if(!checkcomma(disctime.getValue()))
		{
			Ext.Msg.alert(pageTitle2,tmpValidationMsg3+" "+validationMsg60,function(btn){
				if (btn == 'ok'){
					disctime.focus(true);
				 }
			});
			return false;
		}
		else if(!checkcomma(toposleeptime.getValue()))
		{
			Ext.Msg.alert(pageTitle2,tmpValidationMsg3+" "+validationMsg61,function(btn){
				if (btn == 'ok'){
					toposleeptime.focus(true);
				 }
			});
			return false;
		}
		else if(!checkcomma(toporediscover.getValue()))
		{
			Ext.Msg.alert(pageTitle2,tmpValidationMsg3+" "+validationMsg62,function(btn){
				if (btn == 'ok'){
					toporediscover.focus(true);
				 }
			});
			return false;
		}
		else if (((!checknumber("+",agentdisc.getValue()) && agentdiscvalue.indexOf(',') == -1) || agentdiscvalue == 0 || agentdiscvalue.indexOf('.') > -1) && (agentdiscvalue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,validationMsg58+" "+tmpValidationMsg4,function(btn){
				if (btn == 'ok'){
					agentdisc.focus(true);
				 }
			});
			return false;
		}
		else if (((!checknumber("+",agentredisc.getValue()) && agentrediscvalue.indexOf(',') == -1) || agentrediscvalue == 0 || agentrediscvalue.indexOf('.') > -1) && (agentrediscvalue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,validationMsg59+" "+tmpValidationMsg4,function(btn){
				if (btn == 'ok'){
					agentredisc.focus(true);
				 }
			});
			return false;
		}
		else if (((!checknumber("+",disctime.getValue()) && disctimevalue.indexOf(',') == -1) || disctimevalue == 0 || disctimevalue.indexOf('.') > -1) && (disctimevalue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,validationMsg60+" "+tmpValidationMsg4,function(btn){
				if (btn == 'ok'){
					disctime.focus(true);
				 }
			});
			return false;
		}
		else if (((!checknumber("+",toposleeptime.getValue()) && toposleeptimevalue.indexOf(',') == -1) || toposleeptimevalue == 0 || toposleeptimevalue.indexOf('.') > -1) && (toposleeptimevalue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,validationMsg61+" "+tmpValidationMsg4,function(btn){
				if (btn == 'ok'){
					toposleeptime.focus(true);
				 }
			});
			return false;
		}
		else if (((!checknumber("+",toporediscover.getValue()) && toporediscovervalue.indexOf(',') == -1) || toporediscovervalue == 0 || toporediscovervalue.indexOf('.') > -1) && (toporediscovervalue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,validationMsg62+" "+tmpValidationMsg4,function(btn){
				if (btn == 'ok'){
					toporediscover.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecialnomess(agentdisc.getValue(),splChar) && (agentdiscvalue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,tmpValidationMsg5+" "+validationMsg58,function(btn){
				if (btn == 'ok'){
					agentdisc.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecialnomess(agentredisc.getValue(),splChar) && (agentrediscvalue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,tmpValidationMsg5+" "+validationMsg59,function(btn){
				if (btn == 'ok'){
					agentredisc.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecialnomess(disctime.getValue(),splChar) && (disctimevalue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,tmpValidationMsg5+" "+validationMsg60,function(btn){
				if (btn == 'ok'){
					disctime.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecialnomess(toposleeptime.getValue(),splChar) && (toposleeptimevalue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,tmpValidationMsg5+" "+validationMsg61,function(btn){
				if (btn == 'ok'){
					toposleeptime.focus(true);
				 }
			});
			return false;
		}
		else if(!checkspecialnomess(toporediscover.getValue(),splChar) && (toporediscovervalue != 'NULL'))
		{
			Ext.Msg.alert(pageTitle2,tmpValidationMsg5+" "+validationMsg62,function(btn){
				if (btn == 'ok'){
					toporediscover.focus(true);
				 }
			});
			return false;
		}

		//var portsLen = Ext.getCmp('serverPorts').items.length;
		//var tmpObj2 = Ext.getCmp('serverPorts').items.items[1];
		// Port validation starts
		for(var i=0;;i++)
		{
			var tmpObj = Ext.getCmp("serverPortsCount_"+i);
			if (tmpObj == null || tmpObj == 'undefined')
			{
				break;
			}
			var serverportvalue = tmpObj.getValue();
			for(var k=0;k<serverportvalue.length;k++)
			{
				if(serverportvalue.charAt(k) == ',' && serverportvalue.charAt(k + 1) == ',')
				{
					Ext.Msg.alert(pageTitle2,validationMsg8,function(btn){
						if (btn == 'ok'){
							tmpObj.focus(true);
						 }
					});
					me.showPortSummary();
					return false;
				}
				else
				{
					continue;
				}
			}

			if(!checkblank(tmpObj.getValue()))
			{
				Ext.Msg.alert(pageTitle2,validationMsg9,function(btn){
					if (btn == 'ok'){
						tmpObj.focus(true);
					 }
				});
				me.showPortSummary();
				return false;
			}
			else if(!checkspace(tmpObj.getValue()))
			{
				//Ext.Msg.alert(pageTitle2,validationMsg9);
				me.showPortSummary();
				tmpObj.focus(true);
				return false;
			}
			else if(!checkcomma(tmpObj.getValue()))
			{
				Ext.Msg.alert(pageTitle2,validationMsg10,function(btn){
					if (btn == 'ok'){
						tmpObj.focus(true);
					 }
				});
				me.showPortSummary();
				return false;
			}
			else if (tmpObj.getValue().indexOf(",") > -1)
			{
				var splittedVal = tmpObj.getValue().split(",");
				for (n=0;n<splittedVal.length;n++)
				{
					try
					{
						var element = splittedVal[n];
						if (!checknumber("+",element))
						{
							Ext.Msg.alert(pageTitle2,validationMsg11,function(btn){
								if (btn == 'ok'){
									tmpObj.focus(true);
								 }
							});
							me.showPortSummary();
							return false;
						}
						else
						{
							if (element > 65535)
							{
								Ext.Msg.alert(pageTitle2,validationMsg11,function(btn){
									if (btn == 'ok'){
										tmpObj.focus(true);
									 }
									});
								me.showPortSummary();
								return false;
							}
						}
					}
					catch (e)
					{
						Ext.Msg.alert(pageTitle2,validationMsg11,function(btn){
							if (btn == 'ok'){
								tmpObj.focus(true);
							 }
						});
						me.showPortSummary();
						return false;
					}
				}
			}
			else if (((!checknumber("+",tmpObj.getValue()) && serverportvalue.indexOf(',') == -1) || serverportvalue == 0 || serverportvalue.indexOf('.') > -1) && (serverportvalue != 'NULL'))
			{
				Ext.Msg.alert(pageTitle2,validationMsg12,function(btn){
					if (btn == 'ok'){
						tmpObj.focus(true);
					 }
				});
				me.showPortSummary();
				return false;
			}
			else if(!checkspecialnomess(tmpObj.getValue(),splChar) && (serverportvalue != 'NULL'))
			{
				Ext.Msg.alert(pageTitle2,validationMsg13,function(btn){
					if (btn == 'ok'){
						tmpObj.focus(true);
					 }
				});
				me.showPortSummary();
				return false;
			}
		}// Port validation ends
		return true;
	},
	updateNewServerList : function()
	{
		var me = this;
		var componenetListObj = Ext.getCmp('newcomponenetList');
		componenetListObj.removeAll();
		var isServersFound = publicJSON['isServersFound'];
		var isSearchDone = publicJSON['isSearchDone'];
		if (isServersFound == true)
		{
			var tmpData = {
				xtype : 'panel',
				width : '93%',
				border : false,
				html : publicJSON['serversTable']
			}
			componenetListObj.add(tmpData);
		}
		else
		{
			if (isSearchDone == true)
			{
				var textMsg = me.getErrorMsg('Search',Ext.getCmp('newComponentSearch').getValue());
				componenetListObj.add(textMsg);
			}
			else
			{
				var textMsg = me.getErrorMsg("New","");
				componenetListObj.add(textMsg);
			}
		}
	},
	updateUnmanagedServerList : function(type)
	{
		var me = this;
		var componenetListObj = Ext.getCmp('unmanagedComponenetList');
		componenetListObj.removeAll();
		var isServersFound = publicJSON['isServersFound'];
		var isSearchDone = publicJSON['isSearchDone'];
		if (isServersFound == true)
		{
			var tmpData = {
				xtype : 'panel',
				width : '93%',
				border : false,
				html : publicJSON['serversTable']
			}
			componenetListObj.add(tmpData);
		}
		else
		{
			if (isSearchDone == true)
			{
				var textMsg = me.getErrorMsg('Search',Ext.getCmp('unmanagedComponentSearch').getValue());
				componenetListObj.add(textMsg);
			}
			else
			{
				var textMsg = me.getErrorMsg("Unmanage");
				componenetListObj.add(textMsg);
			}
		}
	},
	getErrorMsg :function(tmpQuery,SearchString)
	{
		var tmpMsg;
		if (tmpQuery == "New")
		{
			tmpMsg = {
				xtype:'component',
				id : 'newSrvResultContainer',
				padding:140,
				style:{'text-align':'center'},
				html:'<div class = "iconInformation" style="margin:0 auto"></div><div>'+validationMsg72+'.</div>'
			}
		}
		else if (tmpQuery == "Unmanage")
		{
			tmpMsg = {
				xtype:'component',
				padding:140,
				style:{'text-align':'center'},
				html:'<div class = "iconInformation" style="margin:0 auto"></div><div>'+validationMsg73+'.</div>'
			}
		}
		else
		{
			tmpMsg = {
				xtype:'component',
				id : 'searchResultCon',
				padding:130,
				style:{'text-align':'center'},
				html:'<div class = "iconInformation" style="margin:0 auto"></div><div>'+validationMsg74+', " '+SearchString+' "</div>'
			}
		}
		return tmpMsg;
	},
	loadDefaultTabView : function()
	{
		var me = this;
		me.updateNewServerList();
	},
	searchForNewServers : function(value)
	{
		if (value == " " || value == "Search" || value.length == 0)
		{
			value = "";
		}
		var me = this;
		me.updateDiscoveryTree("EgServerDiscovery/data/EgDiscServersJson.jsp?startDiscThread=false&executeAction=New&strSearch="+value+"&searchCategory=componentSearch&date="+new Date().getTime());

		var componenetListObj = Ext.getCmp('componenetList');
		componenetListObj.removeAll();
		var isServersFound = publicJSON['isServersFound'];
		var isSearchDone = publicJSON['isSearchDone'];
		if (isServersFound == true)
		{
			var tmpData = {
				xtype : 'panel',
				border : false,
				width : '93%',
				html : publicJSON['serversTable']
			}
			componenetListObj.add(tmpData);
		}
		else
		{
			if (isSearchDone == true)
			{
				var textMsg = me.getErrorMsg('Search',value);
				componenetListObj.add(textMsg);
			}
			else
			{
				var textMsg = me.getErrorMsg('New',value);
				componenetListObj.add(textMsg);
			}
		}
	},
	manageDiscoverdComponents : function()
	{
		var me = this;
		if (Ext.getCmp('hiddenFieldsContainer').items.length == 0)
		{
			Ext.Msg.alert(pageTitle2,validationMsg69);
			return;
		}
		var  urlStr = "EgServerDiscovery/data/EgconfigenvpJson.jsp?from=newServerDiscovery&date="+new Date().getTime();
		var myMask = new Ext.LoadMask(Ext.getCmp('discoveryRightPane'), {msg: 'Managing...'});
		myMask.show();
		var thisForm = Ext.getCmp('egdiscserverscontainer').getForm();
		if (thisForm.isValid())
		{
			thisForm.submit({
				url: urlStr,
				method: 'POST',
				success: function(form, action){
					myMask.hide();
					var resultObj = Ext.decode(action.response.responseText);
					if (resultObj.requestStatus == "success")
					{
						Ext.Msg.alert(resultObj.result.title,resultObj.result.message1);
					}
					else
					{
						var tmpObj = resultObj.errors;
						var errorText = me.getErrorMessageTemplate(tmpObj);
						Ext.Msg.alert(tmpObj.title,errorText);
					}
					me.updateDiscoveryTree("EgServerDiscovery/data/EgDiscServersJson.jsp?startDiscThread=false&executeAction=New&date="+new Date().getTime());
					me.updateResultPanel();
					Ext.getCmp('hiddenFieldsContainer').removeAll();
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					Ext.Msg.alert(pageTitle2,"Problem in deleting the componenets");
				}
			});
		}
	},
	manageComponents : function()
	{
		var me = this;
		var tabPanel = Ext.getCmp('managediscoveredcomponents').getActiveTab();
		var tmpQuery;
		if (tabPanel.itemId == "tab1")
		{
			if (Ext.getCmp('hiddenFieldsContainer1').items.length == 0)
			{
				Ext.Msg.alert(pageTitle2,validationMsg69);
				return;
			}
			tmpQuery = 'New';
		}
		else
		{
			if (Ext.getCmp('hiddenFieldsContainer2').items.length == 0)
			{
				Ext.Msg.alert(pageTitle2,validationMsg69);
				return;
			}
			tmpQuery = 'Unmanage';
		}
		var  urlStr = "EgServerDiscovery/data/EgconfigenvpJson.jsp?from=newServerDiscovery&date="+new Date().getTime();

		var myMask = new Ext.LoadMask(Ext.getCmp('discoveryRightPane'), {msg: 'Managing...'});
		myMask.show();
		var thisForm = Ext.getCmp('manageservers').getForm();
		if (thisForm.isValid())
		{
			thisForm.submit({
				url: urlStr,
				method: 'POST',
				success: function(form, action){
					myMask.hide();
					var resultObj = Ext.decode(action.response.responseText);
					if (resultObj.requestStatus == "success")
					{
						Ext.Msg.alert(resultObj.result.title,resultObj.result.message1);
					}
					else
					{
						var tmpObj = resultObj.errors;
						var errorText = me.getErrorMessageTemplate(tmpObj);
						Ext.Msg.alert(tmpObj.title,errorText);
					}
					me.updateDiscoveryTree("EgServerDiscovery/data/EgDiscServersJson.jsp?startDiscThread=false&executeAction="+tmpQuery+"&date="+new Date().getTime());

					if (tmpQuery == "New")
					{
						me.updateNewServerList();
					}
					else
					{
						me.updateUnmanagedServerList();
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					Ext.Msg.alert(pageTitle2,"Problem in deleting the componenets");
				}
			});
		}
	},
	deleteComponents : function()
	{
		var me = this;
		if (Ext.getCmp('hiddenFieldsContainer2').items.length == 0)
		{
			Ext.Msg.alert(pageTitle2,validationMsg70);
			return;
		}
		Ext.MessageBox.confirm('Confirm', validationMsg71, function(btn){
			if (btn == "yes")
			{
				var  urlStr = "EgServerDiscovery/data/EgdeleteserverpJson.jsp?refferalURL=newDiscovery&performaction=false&date="+new Date().getTime();

				var myMask = new Ext.LoadMask(Ext.getCmp('discoveryRightPane'), {msg: 'Deleting...'});
				myMask.show();
				var thisForm = Ext.getCmp('manageservers').getForm();
				if (thisForm.isValid())
				{
					thisForm.submit({
						url: urlStr,
						method: 'POST',
						success: function(form, action){
							myMask.hide();
							//me.showResultWindow(action.response.responseText);
							var resultObj = Ext.decode(action.response.responseText);
							if (resultObj.requestStatus == "success")
							{
								Ext.Msg.alert(resultObj.result.title,resultObj.result.message1);
							}
							else
							{
								var tmpObj = resultObj.errors;
								var errorText = me.getErrorMessageTemplate(tmpObj);
								Ext.Msg.alert(tmpObj.title,errorText);
							}
							me.updateDiscoveryTree("EgServerDiscovery/data/EgDiscServersJson.jsp?startDiscThread=false&executeAction=Unmanage&date="+new Date().getTime());
							me.updateUnmanagedServerList();
							Ext.getCmp('hiddenFieldsContainer2').removeAll();
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							myMask.hide();
							Ext.Msg.alert(pageTitle2,"Problem in deleting the componenets");
						}
					});
				}
			}
		});
	},
	refreshDiscServers : function()
	{
		var discoveryRightPaneObj = Ext.getCmp('discoveryRightPane');
		var me = this;
		var myMask = new Ext.LoadMask(discoveryRightPaneObj, {msg: 'Updating...'});
		myMask.show();
		var strString = "EgServerDiscovery/data/EgDiscServersJson.jsp?startDiscThread=false&executeAction=New&selectedNode="+selectedNodeID+"&date="+new Date().getTime();

		Ext.Ajax.request({
			url : strString,
			method: 'POST',
			success: function(response)
			{
				myMask.hide();
				publicJSON = Ext.decode(response.responseText);
				me.updateNewServerList();
			},
			failure : function(response)
			{
				myMask.hide();
			}
		});
	},
	refreshDiscServersPage : function(executeAction)
	{
		var discoveryRightPaneObj = Ext.getCmp('discoveryRightPane');
		var me = this;
		var myMask = new Ext.LoadMask(discoveryRightPaneObj, {msg: 'Updating...'});
		myMask.show();
		var strString = "EgServerDiscovery/data/EgDiscServersJson.jsp?startDiscThread=false&executeAction="+executeAction+"&date="+new Date().getTime();

		Ext.Ajax.request({
			url : strString,
			method: 'POST',
			success: function(response)
			{
				myMask.hide();
				publicJSON = Ext.decode(response.responseText);
				me.updateResultPanel();
			},
			failure : function(response)
			{
				myMask.hide();
			}
		});
	},
	updateResultPanel : function()
	{
		var discActionContainer = Ext.getCmp('discActionContainer');
		var isDiscAlive = publicJSON['isDiscAlive'];
		var isDiscFileReadable = publicJSON['isDiscFileCreated'];
		var isServersFound = publicJSON['isServersFound'];
		var isSearchDone = publicJSON['isSearchDone'];
		if (isServersFound == true)
		{
			discActionContainer.show();
			var componenetListObj = Ext.getCmp('componenetList');
			componenetListObj.removeAll();
			var tmpData = {
				xtype : 'panel',
				border : false,
				width : '93%',
				html : publicJSON['serversTable']
			}
			componenetListObj.add(tmpData);
		}
		else
		{
			discActionContainer.hide();
			var componenetListObj = Ext.getCmp('componenetList');
			componenetListObj.removeAll();
			var textMsg = appCnt.getErrorMsg('New',"");
			componenetListObj.add(textMsg);
		}
	},
	stopDiscovery : function()
	{
		var tmpStrURI = "EgServerDiscovery/data/EgStopDiscoveryJson.jsp?from=EgFrame";
		Ext.Ajax.request({
			url : tmpStrURI,
			method: 'POST',
			success: function(response)
			{
				Ext.Msg.alert(pageTitle2,"Discovery has been stopped successfully");
			},
			failure : function(response)
			{
			}
		});
	},
	enableBackButton : function()
	{
		window.location.href = backHref;
	},
	changeComponentState : function()
	{
		isComponentUpdated = false;
	},
	deleteManagedComponent : function(isProceed)
	{
		var me = this;
		var funmng = "";
		var fmng = "";
		var fmngwithcomptype = "";
		var srvtype = Ext.getCmp('servertypes').getValue();
		Ext.getCmp("server").setValue(srvtype);
		var tmpStore = Ext.getCmp('componentDetails');
		var fromList = tmpStore.fromField.boundList;
		var selectedList = tmpStore.getSelections(fromList);
		for (var key in selectedList)
		{
			var tmpData = selectedList[key].get("valueField");
			fmng = fmng + tmpData + ",";
			fmngwithcomptype = fmngwithcomptype + srvtype + ":" + tmpData + ",";
		}
		if(fmng == "" || fmng.length == 0)
		{
			Ext.Msg.alert(pageTitle8,intnlLabel8);
		}
		else if (isComponentUpdated != true)
		{
			Ext.Msg.alert(pageTitle8,intnlLabel9);
		}
		else
		{
			if (isProceed != null && isProceed !== undefined && isProceed == true)
			{
				Ext.getCmp("fmanage").setValue(fmng);
				Ext.getCmp("funmanage").setValue(funmng);
				Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
				var tmpURL = "EgServerDiscovery/data/EgdeleteserverpJson.jsp?performaction=true";
				tmpURL += "&isProceed="+isProceed;
				me.deleteSelectedComponent(tmpURL);
			}
			else
			{
				if(reDiscDelComp.toLowerCase() == 'no' || reDiscDelComp.toLowerCase() == 'false')
				{
					var alertMsg = intnlLabel36 + "&nbsp;" + intnlLabel37;
				
					Ext.MessageBox.confirm(pageTitle8, alertMsg,
						function (btn){
							if (btn == "yes")
							{
								Ext.getCmp("fmanage").setValue(fmng);
								Ext.getCmp("funmanage").setValue(funmng);
								Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
								var tmpURL = "EgServerDiscovery/data/EgdeleteserverpJson.jsp?performaction=true";
								me.deleteSelectedComponent(tmpURL);
							}
						}
					);
				}
				else
				{
					Ext.getCmp("fmanage").setValue(fmng);
					Ext.getCmp("funmanage").setValue(funmng);
					Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
					var tmpURL = "EgServerDiscovery/data/EgdeleteserverpJson.jsp?performaction=true";
					me.deleteSelectedComponent(tmpURL);
				}
			}
		}
	},
	deleteSelectedComponent : function(tmpURL)
	{
		var me = this;
		elemList = "";
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var hiddenFields = this.getHiddenFields();
		var frmMain = this.getEgconfigenvformcontainer().getForm();
		if (frmMain.isValid())
		{
			this.getEgconfigenvformcontainer().submit({
				url: tmpURL+'&'+hiddenFields,
				method: 'POST',
				//standardSubmit: true,
				success: function(form, action){
					//me.showResultWindow(action.response.responseText);
					myMask.hide();
					var resultObj = Ext.decode(action.response.responseText);
					if (resultObj.requestStatus == "success")
					{
						var tmpObj = resultObj.result;
						Ext.Msg.alert(tmpObj.title,tmpObj.message1);
						elemList = resultObj.elemList;
						me.afterComponentChanged();
					}
					else
					{
						var tmpObj = resultObj.errors;
						var errorText = me.getErrorMessageTemplate(tmpObj);
						//Ext.Msg.alert(tmpObj.title,errorText);
						me.showResultWindow(tmpObj.title,errorText,"delete");
					}
					Ext.getCmp("fmanage").setValue("");
					Ext.getCmp("funmanage").setValue("");
					Ext.getCmp("fmanagewithcomptype").setValue("");
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					Ext.getCmp("fmanage").setValue("");
					Ext.getCmp("funmanage").setValue("");
					Ext.getCmp("fmanagewithcomptype").setValue("");
					switch (action.failureType) {
						case Ext.form.action.Action.CLIENT_INVALID:
							Ext.Msg.show({
								title: "Failure",
								msg: "Form fields may be submitted with invalid values.",
								buttons: Ext.Msg.OK,
								icon: 'iconError'
							});
							break;
						case Ext.form.action.Action.CONNECT_FAILURE:
							Ext.Msg.show({
								title: "Failure",
								msg: "Ajax communication failed.",
								buttons: Ext.Msg.OK,
								icon: 'iconError'
							});
							break;
						case Ext.form.action.Action.SERVER_INVALID:
							Ext.Msg.show({
								title: "Failure",
								msg: action.result.msg+".",
								buttons: Ext.Msg.OK,
								icon: 'iconError'
							});
					}
				}
			});
		}
	},
	deleteUnManagedComponent : function()
	{
		var me = this;
		var funmng = "";
		var fmng = "";
		var fmngwithcomptype = "";
		var srvtype = Ext.getCmp('servertypes').getValue();
		Ext.getCmp("server").setValue(srvtype);
		var tmpStore = Ext.getCmp('componentDetails');
		var fromList = tmpStore.toField.boundList;
		var selectedList = tmpStore.getSelections(fromList);
		for (var key in selectedList)
		{
			var tmpData = selectedList[key].get("valueField");
			var tmpDis = selectedList[key].get("displayField");
			//if(tmpDis.charAt(0) == '*')
			//{
			//	Ext.Msg.alert(pageTitle8,intnlLabel11);
			//	return;
			//}
			funmng = funmng + tmpData + ",";
			fmngwithcomptype = fmngwithcomptype + srvtype + ":" + tmpData + ",";
		}
		if(funmng == "")
		{
			Ext.Msg.alert(pageTitle8,intnlLabel12);
		}
		else if (isComponentUpdated != true)
		{
			Ext.Msg.alert(pageTitle8,intnlLabel9);
		}
		else
		{
			if(reDiscDelComp.toLowerCase() == 'no' || reDiscDelComp.toLowerCase() == 'false')
			{
				var alertMsg = intnlLabel36 + "&nbsp;" + intnlLabel37;
				Ext.MessageBox.confirm(pageTitle8, alertMsg,
					function (btn){
						if (btn == "yes")
						{
							Ext.getCmp("fmanage").setValue(fmng);
							Ext.getCmp("funmanage").setValue(funmng);
							Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
							var tmpURL = "EgServerDiscovery/data/EgdeleteserverpJson.jsp?performaction=false";
							me.deleteSelectedComponent(tmpURL);
						}
					}
				);
			}
			else
			{
				Ext.getCmp("fmanage").setValue(fmng);
				Ext.getCmp("funmanage").setValue(funmng);
				Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
				var tmpURL = "EgServerDiscovery/data/EgdeleteserverpJson.jsp?performaction=false";
				me.deleteSelectedComponent(tmpURL);
			}
		}
	},
	serverOnChange : function(obj)
	{
		var tmpStore = Ext.getCmp('componentDetails');
		var selectedValue = obj.getValue();
		if (selectedValue == "-1")
		{
			if(tmpStore.fromField.store.getCount() > 0)
			{
				tmpStore.fromField.store.removeAll();
			}
			if(tmpStore.toField.store.getCount() > 0)
			{
				tmpStore.toField.store.removeAll();
			}
			return ;
		}

		isComponentUpdated = true;
		var url = 'EgServerDiscovery/data/EgConfigEnvJson.jsp?server='+encodeURIComponent(selectedValue)+'&selectedNode='+selectedNodeID;
		this.updateCofigData(url);


		var managedServers = publicJSON['managedServers'];
		var unmanagedServers = publicJSON['unmanagedServers'];
		tmpStore.clearValue();
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}

		//Ext.getCmp('componentDetails').getStore().loadRawData(managedServers);
		tmpStore.fromField.store.add(managedServers);
		tmpStore.toField.store.add(unmanagedServers);

		if (publicJSON.isSearchNeededForFromField == true || publicJSON.isSearchNeededForToField == true)
		{
			Ext.getCmp("searchFieldContainer").show();
			if (publicJSON.isSearchNeededForFromField == true)
			{
				Ext.getCmp('managedSeacrchBox').setDisabled(false);
			}
			else
			{
				Ext.getCmp('managedSeacrchBox').setDisabled(true);
			}

			if (publicJSON.isSearchNeededForToField == true)
			{
				Ext.getCmp('unmanagedSeacrchBox').setDisabled(false);
			}
			else
			{
				Ext.getCmp('unmanagedSeacrchBox').setDisabled(true);
			}
		}
		else
		{
			Ext.getCmp("searchFieldContainer").hide();
		}
	},
	initServerDetails: function()
	{
		var servertypes = Ext.getCmp('servertypes');
		var servers = publicJSON['servers'];
		servertypes.getStore().loadRawData(servers);
		servertypes.setValue(strServer);
		if (strServer != "-1")
		{
			var tmpStore = Ext.getCmp('componentDetails');
			var managedServers = publicJSON['managedServers'];
			var unmanagedServers = publicJSON['unmanagedServers'];
			if(tmpStore.fromField.store.getCount() > 0)
			{
				tmpStore.fromField.store.removeAll();
			}
			if(tmpStore.toField.store.getCount() > 0)
			{
				tmpStore.toField.store.removeAll();
			}
			//Ext.getCmp('componentDetails').getStore().loadRawData(managedServers);
			tmpStore.fromField.store.add(managedServers);
			tmpStore.toField.store.add(unmanagedServers);
		}
	},
	initDiscoveredDetails:function()
	{
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
		myMask.show();
		Ext.getCmp("nickSearch").setFieldLabel("Search by name");
		var choosenCompType1 = Ext.getCmp('componentTypeCombo').setValue("All");
		var choosenCompType = Ext.getCmp('componentTypeCombo').getValue();
		var comp ="";
		Ext.getCmp("timelineCombo").hide();
		Ext.getCmp("datepickfrom").hide();
		Ext.getCmp("datepickTo").hide();
		Ext.getCmp("nickSearch").show();
		Ext.getCmp("nickSearch").setValue(intnlLabel81);
		Ext.Ajax.request({
			url:'EgServerDiscovery/data/EgDiscoveryReport.jsp?selectedNode=node20&from=combo&choosenCompType='+choosenCompType,
			method:'POST',
			success: function(response)
			{
				myMask.hide();
				if(response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					comp = publicJSON['showcomponentNameWise'];
					var cols = publicJSON['columns'];
					if(comp != null && comp.length>0)
					{
						Ext.getCmp('componentTypeCombo').getStore().suspendEvents(true);
						Ext.getCmp('componentTypeCombo').getStore().loadRawData(publicJSON['viewas']);
						Ext.getCmp('componentTypeCombo').setValue("All");
						Ext.getCmp('componentTypeCombo').getStore().resumeEvents();

						Ext.getCmp('searchByCombo').getStore().suspendEvents(true);
						Ext.getCmp('searchByCombo').getStore().loadRawData(publicJSON['searchBy']);
						Ext.getCmp('searchByCombo').setValue("Nick name");
						Ext.getCmp("timelineCombo").hide();
						Ext.getCmp("datepickfrom").hide();
						Ext.getCmp("datepickTo").hide();
						Ext.getCmp('searchByCombo').getStore().resumeEvents();
						var totCount = publicJSON.totalCount;
						var gridTitle ="";
						if(choosenCompType != "All")
						{
							gridTitle = "Discovered Components: "+totCount;
						}
						else
						{
							gridTitle = "Total Discovered Components: "+totCount;
						}
						getGridPanelReport(comp,cols,gridTitle);
					}
					else
					{
						Ext.getCmp('combofilters').hide();
						var resultPanelObj = Ext.getCmp('reportpanel_in_formitem');
						resultPanelObj.removeAll();
						var emptyResultPanel = {
							style : {'text-align':'center'},
							padding : 190,
							border :false,
							html: '<div class = "iconInformation" style="margin:0 auto" ></div><div class="commonErrorMsgText">No discovered component(s) found.</div>'
						};
						resultPanelObj.add(emptyResultPanel);
						resultPanelObj.show();
					}
				}
			}
		});
	},
	showTypeBasedComponents:function()
	{
		var timelineVal = Ext.getCmp('timelineCombo').getValue();
		var searchType = Ext.getCmp('searchByCombo').getValue();
		var choosenCompType = Ext.getCmp('componentTypeCombo').getValue();
		Ext.Ajax.request({
			url:'EgServerDiscovery/data/EgDiscoveryReport.jsp?from=combo&choosenCompType='+choosenCompType,
			method:'POST',
			success: function(response)
			{
				if(response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					if(searchType == "Nick name" || searchType == "Component type")
					{
						Ext.getCmp('searchByCombo').getStore().loadRawData(publicJSON['searchBy']);
						var comp = publicJSON['showcomponentNameWise'];
						var cols = publicJSON['columns'];
						var totCount = publicJSON.totalCount;
						var gridTitle ="";
						if(choosenCompType != "All")
						{
							Ext.getCmp('searchByCombo').setValue("Nick name");
							Ext.getCmp("nickSearch").setValue("");
							gridTitle = "Discovered Components: "+totCount;
						}
						else
						{
							gridTitle = "Total Discovered Components: "+totCount;
						}
						getGridPanelReport(comp,cols,gridTitle);
					}
					else if(searchType == "Last discovered time")
					{
						Ext.getCmp("nickSearch").hide();
						Ext.getCmp("timelineCombo").show();
						Ext.getCmp("datepickfrom").show();
						Ext.getCmp("datepickTo").show();
						var fromdateSearch = Ext.getCmp("datepickfrom").getValue();
						var startDate = Ext.Date.add (fromdateSearch,Ext.Date.DAY,0);
						var currDate = Ext.Date.add (new Date(),Ext.Date.DAY,0);
						var initToDate = Ext.Date.format(currDate, mgrDateFormat);            
						Ext.getCmp('datepickTo').setValue(initToDate);
						Ext.Ajax.request({
							url:'EgServerDiscovery/data/EgDiscoveryReport.jsp?from=combo&value=searchbox&searchType='+searchType+'&fromdateSearch='+encodeURIComponent(startDate)+'&todateSearch='+encodeURIComponent(currDate)+'&choosenCompType='+choosenCompType+'&timelineVal='+timelineVal,
							method:'POST',
							success: function(response)
							{
								if(response.status == 200 && !Ext.isEmpty( response.responseText ))
								{
									var jsonText = response.responseText;
									publicJSON = Ext.decode(jsonText);
									var componentValue = publicJSON['showcomponentNameWise'];
									var timeLineValues = publicJSON['timeLineValues'];
									Ext.getCmp('timelineCombo').getStore().suspendEvents(true);
									Ext.getCmp('timelineCombo').getStore().loadRawData(timeLineValues);
									Ext.getCmp('timelineCombo').getStore().resumeEvents();
									Ext.getCmp('searchByCombo').getStore().loadRawData(publicJSON['searchBy']);
									if(componentValue!= null && componentValue.length > 0)
									{
										var cols = publicJSON['columns'];
										var totCount = publicJSON.totalCount;
										var gridTitle ="";
										if(choosenCompType != "All")
										{
											gridTitle = "Discovered Components: "+totCount;
										}
										else
										{
											gridTitle = "Total Discovered Components: "+totCount;
										}
										getGridPanelReport(componentValue,cols,gridTitle);
									}
									else
									{
										updateReportPanel();
									}
								}
							}
						});
					}
				}
			}
		});
	},
	searchByComponents:function()
	{
		var searchType = Ext.getCmp('searchByCombo').getValue();
		var choosenCompType = Ext.getCmp('componentTypeCombo').getValue();
		if(searchType == "Nick name" || searchType == "Component type" || searchType == "Host IP/Name")
		{
			Ext.getCmp("timelineCombo").hide();
			Ext.getCmp("datepickfrom").hide();
			Ext.getCmp("datepickTo").hide();
			Ext.getCmp("nickSearch").show();
			if(searchType == "Component type")
			{
				Ext.getCmp("nickSearch").setFieldLabel("Search by type");
			}
			else if(searchType == "Host IP/Name")
			{
				Ext.getCmp("nickSearch").setFieldLabel("Search by Host IP/Name");
			}
			else
			{
				Ext.getCmp("nickSearch").setFieldLabel("Search by name");
			}
			Ext.Ajax.request({
				url:'EgServerDiscovery/data/EgDiscoveryReport.jsp?from=combo&value=searchbox&searchType='+searchType+'&choosenCompType='+choosenCompType,
				method:'POST',
				success: function(response)
				{
					if(response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);
						var componentValue = publicJSON['showcomponentNameWise'];
						if(componentValue!= null && componentValue.length > 0)
						{
							Ext.getCmp('searchByCombo').getStore().loadRawData(publicJSON['searchBy']);
							var comp = publicJSON['showcomponentNameWise'];
							var cols = publicJSON['columns'];
							var totCount = publicJSON.totalCount;
							var gridTitle ="";
							if(choosenCompType != "All")
							{
								gridTitle = "Discovered Components: "+totCount;
							}
							else
							{
								gridTitle = "Total Discovered Components: "+totCount;
							}
							getGridPanelReport(componentValue,cols,gridTitle);
						}
						else
						{
							updateReportPanel();
						}
					}
				}
			});
		}
		else if(searchType == "Last discovered time")
		{
			var choosenCompType = Ext.getCmp('componentTypeCombo').getValue();
			Ext.getCmp("nickSearch").hide();
			Ext.getCmp("timelineCombo").show();
			Ext.getCmp("datepickfrom").disable();
			Ext.getCmp("datepickfrom").show();
			Ext.getCmp("datepickTo").disable();
			Ext.getCmp("datepickTo").show();
			var fromDate = changeTimeLineFromDate("24 hours");
			var initFromDate = Ext.Date.format(fromDate, mgrDateFormat); 
			Ext.getCmp('datepickfrom').setValue(initFromDate);
			var currDate = Ext.Date.add (new Date(),Ext.Date.DAY,0);
			var initToDate = Ext.Date.format(currDate, mgrDateFormat);            
			Ext.getCmp('datepickTo').setValue(initToDate);
			currDate = Ext.util.Format.date(currDate , 'm/d/Y');
			fromDate = Ext.util.Format.date(fromDate , 'm/d/Y');

			Ext.Ajax.request({
				url:'EgServerDiscovery/data/EgDiscoveryReport.jsp?from=combo&value=searchbox&searchType='+searchType+'&fromdateSearch='+encodeURIComponent(fromDate)+'&todateSearch='+encodeURIComponent(currDate)+'&choosenCompType='+choosenCompType+'&timelineVal=24 hours',
				method:'POST',
				success: function(response)
				{
					if(response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);
						var componentValue = publicJSON['showcomponentNameWise'];
						var timeLineValues = publicJSON['timeLineValues'];
						Ext.getCmp('timelineCombo').getStore().suspendEvents(true);
						Ext.getCmp('timelineCombo').getStore().loadRawData(publicJSON['timeLineValues']);
						Ext.getCmp('timelineCombo').setValue("24 hours");
						Ext.getCmp('timelineCombo').getStore().resumeEvents();
						if(componentValue!= null && componentValue.length > 0)
						{
							Ext.getCmp('searchByCombo').getStore().loadRawData(publicJSON['searchBy']);
							var cols = publicJSON['columns'];
							var totCount = publicJSON.totalCount;
							var gridTitle ="";
							if(choosenCompType != "All")
							{
								gridTitle = "Discovered Components: "+totCount;
							}
							else
							{
								gridTitle = "Total Discovered Components: "+totCount;
							}
							getGridPanelReport(componentValue,cols,gridTitle);
						}
						else
						{
							updateReportPanel();
						}
					}
				}
			});
		}
	},
	mainGridSearch:function()
	{
		var choosenCompType = Ext.getCmp('componentTypeCombo').getValue();
		var nicksearch = Ext.getCmp('nickSearch').getValue();
		var searchType = Ext.getCmp('searchByCombo').getValue();
		if (nicksearch == "" || nicksearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url:'EgServerDiscovery/data/EgDiscoveryReport.jsp?from=combo&value=searchbox&nickSearch='+encodeURIComponent(nicksearch)+'&searchType='+encodeURIComponent(searchType)+'&choosenCompType='+choosenCompType,
			method:'POST',
			success: function(response)
			{
				if(response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					var componentValue = publicJSON['showcomponentNameWise'];
					if(componentValue!= null && componentValue.length > 0)
					{
						Ext.getCmp('searchByCombo').getStore().loadRawData(publicJSON['searchBy']);
						var cols = publicJSON['columns'];
						var totCount = publicJSON.totalCount;
						var gridTitle ="";
						if(choosenCompType != "All")
						{
							gridTitle = "Discovered Components: "+totCount;
						}
						else
						{
							gridTitle = "Total Discovered Components: "+totCount;
						}
						getGridPanelReport(componentValue,cols,gridTitle);
					}
					else
					{
						updateReportPanel();
					}
				}
			}
		});
	},
	getDateValue:function()
	{
		var choosenCompType = Ext.getCmp('componentTypeCombo').getValue();
		var fromdateSearch = Ext.getCmp("datepickfrom").getValue();
		var todateSearch = Ext.getCmp("datepickTo").getValue();
		var searchType = Ext.getCmp('searchByCombo').getValue();
		var startDate = Ext.Date.add (fromdateSearch,Ext.Date.DAY,0);
		var startDateVal = Ext.Date.format(fromdateSearch, "m/d/y");    
		var endDate = Ext.Date.add (todateSearch,Ext.Date.DAY,0);
		var endDateVal = Ext.Date.format(todateSearch, "m/d/y"); 
		var timelineVal = Ext.getCmp('timelineCombo').getValue();
		startDate = Ext.util.Format.date(startDate , 'm/d/Y');
		endDate = Ext.util.Format.date(endDate , 'm/d/Y');
	

		if (dateValidation(startDateVal,endDateVal) == -1) 
		{
			Ext.MessageBox.show({
					title: "Alert",
					msg: validationMsg114,
					buttons: Ext.Msg.OK,
					icon: "iconExclamation",
			});
		} 
		else
		{
			Ext.Ajax.request({
				url:'EgServerDiscovery/data/EgDiscoveryReport.jsp?from=combo&value=searchbox&searchType='+searchType+'&fromdateSearch='+encodeURIComponent(startDate)+'&todateSearch='+encodeURIComponent(endDate)+'&choosenCompType='+choosenCompType+'&timelineVal='+timelineVal,
				method:'POST',
				success: function(response)
				{
					if(response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);
						var componentValue = publicJSON['showcomponentNameWise'];
						if(componentValue!= null && componentValue.length > 0)
						{
							Ext.getCmp('searchByCombo').getStore().loadRawData(publicJSON['searchBy']);
							var cols = publicJSON['columns'];
							var totCount = publicJSON.totalCount;
							getGridPanelReport(componentValue,cols,totCount);
							var gridTitle ="";
							if(choosenCompType != "All")
							{
								gridTitle = "Discovered Components: "+totCount;
							}
							else
							{
								gridTitle = "Total Discovered Components: "+totCount;
							}
							getGridPanelReport(componentValue,cols,gridTitle);
						}
						else
						{
							updateReportPanel();
						}
					}
				}
			});
		}
	},
	saveInCSVFormat:function()
	{
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+userLanguage+"&filePrefix=DiscoveredComponentsReport";
	},
	savePdf : function()
	{
		var getSaveObj = Ext.widget('savePdf');
		getSaveObj.savePDF(pdfURLString);
	},
	printPage : function()
	{
		var printPage = "/final/admin/EgDiscoveredComponentPdf.jsp?print=printpage";
		Ext.widget('print').show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set(
		{
			src :  printPage
		});
	},
	manageComponent: function(b, f, a , c) {
		var servertype = c.substring(0,c.indexOf(":"));
		var comptitle = c.substring(c.indexOf(":")+1,c.length);
		var choosenCompType = Ext.getCmp('componentTypeCombo').getValue();
		var compstatus = "NEW";
		var newServerUrl = "EgNewServer.jsp?server=new&from=inventory&compstatus="+ encodeURIComponent(compstatus)+"&serverType="+encodeURIComponent(servertype)+"&frmTopology=yes&allExternalTests=true&from=addnew&isAggregateLink=false&comptitle="+encodeURIComponent(comptitle);
		var w ;
		if(!w)
		{
			w = new Ext.Window({
				layout: 'fit',
				title: 'Manage components',
				id:'manageWindow',
				closeAction: 'destroy',
				width:850,
				padding:'5 10 10 10',
				height:550,
				border: false, 
				html: '<iframe id="newCompId" width="100%" src='+newServerUrl+' style="height:100%;border:0"></iframe>',
			});
		}
		w.show();
    },
	showTimeline: function()
	{
		var timelineVal = Ext.getCmp('timelineCombo').getValue();
		if(timelineVal != "Any")
		{
			Ext.getCmp("datepickfrom").hide();
			Ext.getCmp("datepickTo").hide();
			Ext.getCmp("datepickfrom").disable();
			Ext.getCmp("datepickTo").disable();
			var fromDate = changeTimeLineFromDate(timelineVal);
			var initFromDate = Ext.Date.format(fromDate, mgrDateFormat); 
			Ext.getCmp('datepickfrom').setValue(initFromDate);
		}
		else if(timelineVal == "Any")
		{
			Ext.getCmp("datepickfrom").show();
			Ext.getCmp("datepickTo").show();
			Ext.getCmp("datepickfrom").enable();
			Ext.getCmp("datepickTo").enable();
		}
		var choosenCompType = Ext.getCmp('componentTypeCombo').getValue();
		Ext.getCmp("nickSearch").hide();
		Ext.getCmp("timelineCombo").show();
		Ext.getCmp("datepickfrom").show();
		Ext.getCmp("datepickTo").show();
		var fromdateSearch = Ext.getCmp("datepickfrom").getValue();
		var todateSearch = Ext.getCmp("datepickTo").getValue();
		var startDate = Ext.Date.add (fromdateSearch,Ext.Date.DAY,0);
		var endDate = Ext.Date.add (todateSearch,Ext.Date.DAY,0);
		var searchType = Ext.getCmp('searchByCombo').getValue();
		startDate = Ext.util.Format.date(startDate , 'm/d/Y');
		endDate = Ext.util.Format.date(endDate , 'm/d/Y');

		Ext.Ajax.request({
			url:'EgServerDiscovery/data/EgDiscoveryReport.jsp?from=combo&value=searchbox&searchType='+searchType+'&fromdateSearch='+encodeURIComponent(startDate)+'&todateSearch='+encodeURIComponent(endDate)+'&choosenCompType='+choosenCompType+'&timelineVal='+timelineVal,
			method:'POST',
			success: function(response)
			{
				if(response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					var componentValue = publicJSON['showcomponentNameWise'];
					var timeLineValues = publicJSON['timeLineValues'];
					Ext.getCmp('timelineCombo').getStore().suspendEvents(true);
					Ext.getCmp('timelineCombo').getStore().loadRawData(publicJSON['timeLineValues']);
					Ext.getCmp('timelineCombo').getStore().resumeEvents();
					if(componentValue!= null && componentValue.length > 0)
					{
						Ext.getCmp('searchByCombo').getStore().loadRawData(publicJSON['searchBy']);
						var cols = publicJSON['columns'];
						var totCount = publicJSON.totalCount;
						var gridTitle ="";
						if(choosenCompType != "All")
						{
							gridTitle = "Discovered Components: "+totCount;
						}
						else
						{
							gridTitle = "Total Discovered Components: "+totCount;
						}
						getGridPanelReport(componentValue,cols,gridTitle);
					}
					else
					{
						updateReportPanel();
					}
				}
			}
		});
	},
	updateComponentDetails : function(isProceed)
	{
		var me = this;
		elemList = "";
		var srvtype = Ext.getCmp('servertypes').getValue();
		var obj = Ext.getCmp("activeCompTypes");
		var isActiveComponentChecked = obj.getValue();
		if (srvtype == "-1")
		{
			Ext.Msg.alert(pageTitle8,intnlLabel13);
			return;
		}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var hiddenFields = this.getHiddenFields();
		var componentDetails = Ext.getCmp('componentDetails');
		me.setAvailableConfigs();
		var urlStr = 'EgServerDiscovery/data/EgconfigenvpJson.jsp?activeCompTypes='+isActiveComponentChecked+'&'+hiddenFields+"&date="+new Date().getTime();
		if (isProceed != null && isProceed !== undefined && isProceed == true)
		{
			urlStr += "&isProceed="+isProceed;
		}
		var frmMain = this.getEgconfigenvformcontainer().getForm();
		if (frmMain.isValid())
		{
			this.getEgconfigenvformcontainer().submit({
				url: urlStr,
				method: 'POST',
				//standardSubmit: true,
				success: function(form, action){
					myMask.hide();
					//me.showResultWindow(action.response.responseText);
					var resultObj = Ext.decode(action.response.responseText);
					if (resultObj.requestStatus == "success")
					{
						isComponentUpdated = true;
						var tmpObj = resultObj.result;
						Ext.Msg.show({
							title:tmpObj.title,
							msg: tmpObj.message1,
							buttons: Ext.Msg.OK,
							width : 500,
							icon : 'iconInformation'
						});
						elemList = resultObj.elemList;
						if (isProceed != null && isProceed !== undefined && isProceed != false)
						{
							me.updateComponentInfo();
						}
					}
					else
					{
						var tmpObj = resultObj.errors;
						var errorText = me.getErrorMessageTemplate(tmpObj);
						//Ext.Msg.alert(tmpObj.title,errorText);
						me.showResultWindow(tmpObj.title,errorText,"unmanage");
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					switch (action.failureType) {
						case Ext.form.action.Action.CLIENT_INVALID:
							Ext.Msg.show({
								title: "Failure",
								msg: "Form fields may be submitted with invalid values.",
								buttons: Ext.Msg.OK,
								icon: 'iconError'
							});
							break;
						case Ext.form.action.Action.CONNECT_FAILURE:
							Ext.Msg.show({
								title: "Failure",
								msg: "Ajax communication failed.",
								buttons: Ext.Msg.OK,
								icon: 'iconError'
							});
							break;
						case Ext.form.action.Action.SERVER_INVALID:
							Ext.Msg.show({
								title: "Failure",
								msg: action.result.msg+".",
								buttons: Ext.Msg.OK,
								icon: 'iconError'
							});
					}
				}
			});
		}
	},
	updateCofigData : function(url)
	{
		Ext.Ajax.request({
			url : url,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	setAvailableConfigs : function()
	{
		Ext.getCmp("fmanage").setValue("");
		Ext.getCmp("funmanage").setValue("");
		Ext.getCmp("fmanagewithcomptype").setValue("");
		Ext.getCmp("funmanagewithcomptype").setValue("");
		Ext.getCmp("server").setValue("");

		var srvtype = Ext.getCmp('servertypes').getValue();
		var tmpStore = Ext.getCmp('componentDetails')//.getStore();
		var funmng = new Array();
		var fmng = new Array();
		var funmngwithcomptype = new Array();
		var fmngwithcomptype = new Array();
		var thisForm = document.list;
		var unmnglen = tmpStore.toField.store.getCount();
		var mnglen = tmpStore.fromField.store.getCount();
		var unmanagedList = tmpStore.toField.store;
		var managedList = tmpStore.fromField.store;
		for(var z = 0;z<unmnglen;z++)
		{
			var tmpVal = unmanagedList.getAt(z).get('valueField');
			funmng[z] = tmpVal;
			funmngwithcomptype[z] = srvtype + ":" + tmpVal;
		}
		for(var y = 0;y<mnglen;y++)
		{
			var tmpVal = managedList.getAt(y).get('valueField');
			fmng[y] = tmpVal;
			fmngwithcomptype[y] = srvtype + ":" + tmpVal;
		}


		Ext.getCmp("fmanage").setValue(fmng);
		Ext.getCmp("funmanage").setValue(funmng);
		Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
		Ext.getCmp("funmanagewithcomptype").setValue(funmngwithcomptype);
		Ext.getCmp("server").setValue(srvtype);
	},
	showResultWindow : function(title,resultText,action)
	{
		var me = this;
		var isProceed = false;
		Ext.Msg.show({
			title: title,
			msg: resultText,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'yes') 
				{
					isProceed = true;
					if (action != null && action !== undefined && action == "unmanage")
					{
						me.updateComponentDetails(isProceed);
					}
					else if (action != null && action !== undefined && action == "delete")
					{
						me.deleteManagedComponent(isProceed);
					}
				}
				else
				{
					var obj = Ext.getCmp("activeCompTypes");
					me.updateComponentInfo();
					me.showActiveComponents(obj);
				}
			}
		});
	},
	viewAssociatedEntities : function(action)
	{
		var me = this;
		Ext.widget("window",{
			extend: 'Ext.panel.Panel',
			title : associatedEntitiesTitle1,
			id:'assoEntitesWindow',
			width: '68%',
			bodyPadding:'10 10 10 10',
			height: 500,
			modal : true,
			border : false,
			
			autoScroll:true,
			scroll:true,
			ghost:false,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				afterrender : function()
				{
					me.updateEntityAssociationPage(action);
				}
			},
			items:[
				{
					xtype: 'container',
					flex:1,
					id: 'entityAssociationContainer',
					
					margin: 10
				}
			]
		}).show();
	},
	updateEntityAssociationPage : function(action)
	{
		var me = this;
		var servType = Ext.getCmp("server").getValue();
		var activeCompTypes = Ext.getCmp("activeCompTypes").getValue();
		var hiddenFields = me.getHiddenFields();
		var urlStr = "EgServerDiscovery/data/EgComponentGroupedSummary.jsp?"+hiddenFields+"&date="+new Date().getTime()+"&action="+action+"&srvtype="+servType+"&activeCompTypes="+activeCompTypes;
		if (action != null && action !== undefined && (action == "showMod" || action == "showDel"))
		{
			urlStr += "&elemList=true";
			Ext.getCmp('assoEntitesWindow').setTitle(associatedEntitiesTitle2);
			Ext.getCmp("hiddenElemList").setValue(elemList);
		}
		else
		{
			Ext.getCmp('assoEntitesWindow').setTitle(associatedEntitiesTitle1);
			if (action != null && action !== undefined && action == "unmanage")
			{
				me.setAvailableConfigs();
				//var funmanage = "192.168.10.234:80,192.168.10.94:80";
				//var funmanagewithCtype = "IIS_web_server:192.168.9.145:135,IIS_web_server:192.168.10.94:80";
				//servType = "IIS_web_server";
				//Ext.getCmp("funmanage").setValue(funmanage);
				//Ext.getCmp("funmanagewithcomptype").setValue(funmanagewithCtype);
			}
			else if (action != null && action !== undefined && action == "delete")
			{
				var funmng = "", fmng = "", fmngwithcomptype = "";
				var tmpStore = Ext.getCmp('componentDetails');
				var fromList = tmpStore.fromField.boundList;
				var selectedList = tmpStore.getSelections(fromList);
				for (var key in selectedList)
				{
					var tmpData = selectedList[key].get("valueField");
					fmng = fmng + tmpData + ",";
					fmngwithcomptype = fmngwithcomptype + servType + ":" + tmpData + ",";
				}
				Ext.getCmp("fmanage").setValue(fmng);
				Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
			}
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var frmMain = this.getEgconfigenvformcontainer().getForm();
		if (frmMain.isValid())
		{
			this.getEgconfigenvformcontainer().submit({
				url: urlStr,
				method: 'POST',
				timeout : 300,
				//standardSubmit: true,
				success: function(form, action){
					myMask.hide();
					var resultObj = Ext.decode(action.response.responseText);
					me.updateResultWinPanel(resultObj);
				},
				failure: function(form, action)
				{
					myMask.hide();
				}
			});
		}
	},
	updateResultWinPanel : function(resultObj)
	{
		var me = this;
		var entityAssociationCont = Ext.getCmp('entityAssociationContainer');
		entityAssociationCont.removeAll();

		var isElementsAssociated = resultObj['isElementsAssociated'];
		if (isElementsAssociated != undefined && isElementsAssociated == true)
		{
			var message = "<div>"+resultObj.usersGridArr+"</div>";
			Ext.getCmp('entityAssociationContainer').update(message);
		}
		else
		{
			var message = "<div class = \"iconInformation\" style=\"margin:12% auto auto auto\"></div><div>No components associated.</div>";
			var tmpPanel = {
				xtype : 'component',
				width : '100%',
				border : false,
				style:{'text-align':'center'},
				html : message
			}
			entityAssociationCont.add(tmpPanel);
		}
	},
	getHiddenFields : function()
	{
		hiddenQstr = "";
		var hiddenFields = publicJSON['hiddenFields'];
		for (key in hiddenFields)
		{	
			if(key=="$_confpasswd" || key == "$_uname")
			{
				hiddenQstr += key+'='+encodeURIComponent(filterEncode(hiddenFields[key]))+"&";
			}
			else
			{
				hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
			}
		}
		return hiddenQstr;
	},
	updateComponentInfo :  function()
	{
		var selectedValue = Ext.getCmp("servertypes").getValue();
		var activeCompTypes = "false";
		if (Ext.getCmp('activeCompTypes').getValue() == true)
		{
			activeCompTypes = "true";
		}
		var url = "EgServerDiscovery/data/EgConfigEnvJson.jsp?server="+encodeURIComponent(selectedValue)+"&selectedNode="+selectedNodeID+"&activeCompTypes="+activeCompTypes+"&date="+new Date().getTime();
		this.updateCofigData(url);

		var tmpStore = Ext.getCmp('componentDetails');
		var managedServers = publicJSON['managedServers'];
		var unmanagedServers = publicJSON['unmanagedServers'];
		tmpStore.clearValue();
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}
		//Ext.getCmp('componentDetails').getStore().loadRawData(managedServers);
		tmpStore.fromField.store.add(managedServers);
		tmpStore.toField.store.add(unmanagedServers);
	},
	afterComponentChanged :  function()
	{
		var selectedValue = Ext.getCmp("servertypes").getValue();
		var activeCompTypes = "false";
		if (Ext.getCmp('activeCompTypes').getValue() == true)
		{
			activeCompTypes = "true";
		}
		var url = "EgServerDiscovery/data/EgConfigEnvJson.jsp?server="+encodeURIComponent(selectedValue)+"&selectedNode="+selectedNodeID+"&activeCompTypes="+activeCompTypes;
		this.updateCofigData(url);
		var tmpStore = Ext.getCmp('componentDetails');
		var managedServers = publicJSON['managedServers'];
		var unmanagedServers = publicJSON['unmanagedServers'];
		tmpStore.clearValue();
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}
		var servertypesObj = Ext.getCmp('servertypes');
		var servers = publicJSON['servers'];
		servertypesObj.getStore().loadRawData(servers);
		var isServerAvailable = servertypesObj.getStore().findExact('valueField', selectedValue, 0);
		if ( isServerAvailable == -1 )
		{
			servertypesObj.setValue(servertypesObj.getStore().getAt(0).get("valueField"));
		}
		else
		{
			//Ext.getCmp('componentDetails').getStore().loadRawData(managedServers);
			tmpStore.fromField.store.add(managedServers);
			tmpStore.toField.store.add(unmanagedServers);
		}
	},
	showActiveComponents : function(obj)
	{
		var url = "";
		var isActiveComponentChecked = obj.getValue();
		var servertypesObj = Ext.getCmp('servertypes');
		var selectedValue = servertypesObj.getValue();

		if (isActiveComponentChecked)
		{
			url = "EgServerDiscovery/data/EgConfigEnvJson.jsp?server="+encodeURIComponent(selectedValue)+"&selectedNode="+selectedNodeID+"&activeCompTypes=true&date="+new Date().getTime();
		}
		else
		{
			url = "EgServerDiscovery/data/EgConfigEnvJson.jsp?server="+encodeURIComponent(selectedValue)+"&selectedNode="+selectedNodeID+"&activeCompTypes=false&date="+new Date().getTime();
		}
		this.updateCofigData(url);
		var tmpStore = Ext.getCmp('componentDetails');
		var managedServers = publicJSON['managedServers'];
		var unmanagedServers = publicJSON['unmanagedServers'];
		tmpStore.clearValue();
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}

		var servers = publicJSON['servers'];
		servertypesObj.getStore().loadRawData(servers);
		var isServerAvailable = servertypesObj.getStore().findExact('valueField', selectedValue, 0);
		if ( isServerAvailable == -1 || selectedValue == "-1")
		{
			servertypesObj.setValue(servertypesObj.getStore().getAt(0).get("valueField"));
		}
		else
		{
			//tmpStore.getStore().loadRawData(managedServers);
			tmpStore.fromField.store.add(managedServers);
			tmpStore.toField.store.add(unmanagedServers);
		}
	},
	searchComponent : function(strComponent,value,fieldObj)
	{
		var me = this;
		if (value == "" || value.length == 0)
		{
			Ext.get(fieldObj.getId()+'_0').setStyle('display','none');
			Ext.get(fieldObj.getId()+'_1').setStyle('display','block');
		}
		else
		{
			Ext.get(fieldObj.getId()+'_1').setStyle('display','none');
			Ext.get(fieldObj.getId()+'_0').setStyle('display','block');
		}

		var defaultCachedStore = me.getComponentDetailsSelector().fromField.getStore();
		if (strComponent == "unmanaged")
		{
			defaultCachedStore = me.getComponentDetailsSelector().toField.getStore();
		}

		if (value == "" || value.length == 0)
		{
			defaultCachedStore.clearFilter();
		}
		else
		{
			defaultCachedStore.clearFilter();
			var userFilter = new Ext.util.Filter({
				filterFn: function(item) {
					if (item.get('displayField').toLowerCase().indexOf(value.toLowerCase()) != -1)
					{
						return true
					}
					else
					{
						return false;
					}
				}
			});
			defaultCachedStore.filter(userFilter);
		}
		delete defaultCachedStore;
	},
	showNotificationWindow : function()
	{
		var topWindow = window;
		while(topWindow.parent!=topWindow ||  topWindow.opener!=null)
		{
			mainWindow = topWindow;
			topWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);
		}
		if(topWindow.location.pathname!="/")
		{
			mainWindow=topWindow;
		}
		mainWindow.showNotificationDialogBox(false);
		mainWindow.isWindowClosable = false;
	},
	doSorting: function(c) {
		var b = Ext.getCmp("end_date").up("tablepanel").store;
		var d = Ext.getCmp("end_date").getSortParam();
		customDateSorting(b, c, d, mgrDateFormat);
		Ext.getCmp("detailsgrid").getView().refresh();
		var a = "x-column-header-sort-" + c;
		Ext.getCmp("end_date").addCls(a);
    }
});

function enableDisableDiscovery()
{
	var disObject = Ext.getCmp('discoveryRightPane');
	var url = 'EgServerDiscovery/data/EgAgentDiscoverJson.jsp?from=General&validate=true&selectedNode='+selectedNodeID;
	appCnt.updateDiscoveryTree(url,"agent");
	disObject.removeAll();
	disObject.add({xtype:'agentdiscovery'});
	appCnt.loadAgentDiscoerySettings();
}

function changeSelectAll(obj,size,serverName,srvValue,serverID,checkboxID)
{
	var checkboxID = document.getElementById(checkboxID);
	var appliedClassName =	checkboxID.className;
	if (appliedClassName.indexOf("x-form-cb-checked") == -1)
	{
		checkboxID.className ="x-field x-form-item x-field-default x-checkboxgroup-form-item x-form-cb-checked x-form-dirty";
		addComponent(serverName,serverName+"#$#"+srvValue,srvValue);
		isAllItemsChecked(serverName,size);
	}
	else
	{
		checkboxID.className	= "x-field x-form-item x-field-default x-checkboxgroup-form-item";
		removeComponent(serverName+"#$#"+srvValue);
		var checkboxIDAll = document.getElementById(serverName);
		checkboxIDAll.className	= "x-field x-form-item x-field-default x-checkboxgroup-form-item";
	}
}

function isAllItemsChecked(serverName,size)
{
	var isAllChecked = true;
	for (var i=0;i<size;i++)
	{
		var tmpID = document.getElementById(serverName+i);
		if (tmpID == null || tmpID == 'undefined')
		{
			continue;
		}
		var cssStyle = tmpID.className;
		if (cssStyle.indexOf("x-form-cb-checked") == -1)
		{
			isAllChecked = false;
			break;
		}
	}
	if (isAllChecked == true || isAllChecked == "true")
	{
		var checkboxIDAll = document.getElementById(serverName);
		checkboxIDAll.className	= "x-field x-form-item x-field-default x-checkboxgroup-form-item x-form-cb-checked x-form-dirty";
	}
}

function addComponent(fieldName,fieldID,fieldValue)
{
	var hiddenFieldsContainerObj = '';
	var tabPanel = Ext.getCmp('managediscoveredcomponents');
	if (tabPanel != null && tabPanel != undefined && tabPanel != 'undefined')
	{
		var activeTab = tabPanel.getActiveTab();
		if (activeTab.itemId == "tab1")
		{
			hiddenFieldsContainerObj = Ext.getCmp('hiddenFieldsContainer1');
		}
		else
		{
			hiddenFieldsContainerObj = Ext.getCmp('hiddenFieldsContainer2');
		}
	}
	else
	{
		hiddenFieldsContainerObj = Ext.getCmp('hiddenFieldsContainer');
	}

	var tmp = {
		xtype : 'hiddenfield',
		name : fieldName,
		id : fieldID,
		value : fieldValue
	}
	hiddenFieldsContainerObj.add(tmp);
}

function removeComponent(fieldID)
{
	var hiddenFieldsContainerObj = '';
	var tabPanel = Ext.getCmp('managediscoveredcomponents');
	if (tabPanel != null && tabPanel != undefined && tabPanel != 'undefined')
	{
		var activeTab = tabPanel.getActiveTab();
		if (activeTab.itemId == "tab1")
		{
			hiddenFieldsContainerObj = Ext.getCmp('hiddenFieldsContainer1');
		}
		else
		{
			hiddenFieldsContainerObj = Ext.getCmp('hiddenFieldsContainer2');
		}
	}
	else
	{
		hiddenFieldsContainerObj = Ext.getCmp('hiddenFieldsContainer');
	}
	hiddenFieldsContainerObj.remove(fieldID);
}

function SelectAllServersByType(obj,size,serverName,serverID,allServers)
{
	var allServersStr = allServers.slice(1,allServers.length-1);
	var checkboxID = document.getElementById(serverName);
	var appliedClassName =	checkboxID.className;
	if (appliedClassName.indexOf("x-form-cb-checked") == -1)
	{
		checkboxID.className ="x-field x-form-item x-field-default x-checkboxgroup-form-item x-form-cb-checked x-form-dirty";
		for (var i=0;i<size;i++)
		{
			var tmpID = document.getElementById(serverName+i);
			if (tmpID == null || tmpID == 'undefined')
			{
				continue;
			}
			tmpID.className ="x-field x-form-item x-field-default x-checkboxgroup-form-item x-form-cb-checked x-form-dirty";
		}
		var tmpArr = allServersStr.split(",");
		for (var j = 0;j<tmpArr.length;j++)
		{
			var tmpVal = Ext.String.trim(tmpArr[j]);
			addComponent(serverName,serverName+"#$#"+tmpVal,tmpVal);
		}
	}
	else
	{
		checkboxID.className ="x-field x-form-item x-field-default x-checkboxgroup-form-item";
		for (var i=0;i<size;i++)
		{
			var tmpID = document.getElementById(serverName+i);
			if (tmpID == null || tmpID == 'undefined')
			{
				continue;
			}
			tmpID.className ="x-field x-form-item x-field-default x-checkboxgroup-form-item";
		}
		var tmpArr = allServersStr.split(",");
		for (var j = 0;j<tmpArr.length;j++)
		{
			var tmpVal = Ext.String.trim(tmpArr[j]);
			removeComponent(serverName+"#$#"+tmpVal);
		}
	}
}

function stopAutoRefresh()
{
	var disObject = Ext.getCmp('discoveryMsgLoader');
	disObject.hide();
	isDiscState = false;
}

function refreshOnDiscAlive()
{
	var me = this;
	var servertypesObj = Ext.getCmp('servertypes');
	if (isDiscState == false || servertypesObj == undefined)
	{
		return;
	}

	var urlString = "EgServerDiscovery/data/EgConfigEnvJson.jsp?startDiscThread=false&server="+servertypesObj.getValue()+"&selectedNode=node1&date="+new Date().getTime();
	Ext.getCmp('discoveryMsgLoader').show();
	var myMask = '';
	if (fromQuickMenu == false)
	{
		myMask = new Ext.LoadMask(Ext.getCmp('discoveryRightPane'), {msg: 'Updating...'});
		myMask.show();
	}
	Ext.Ajax.request({
		url : urlString,
		method : 'POST',
		success: function(response)
		{
			if (fromQuickMenu == false)
			{
				myMask.hide();
			}
			var rootJson = Ext.decode(response.responseText);
			var isDiscAlive = rootJson['isDiscAlive'];
			var isDiscFileReadable = rootJson['isDiscFileCreated'];

			var tmpStore = Ext.getCmp('componentDetails');
			var managedServers = rootJson['managedServers'];
			var unmanagedServers = rootJson['unmanagedServers'];
			tmpStore.clearValue();
			if(tmpStore.fromField.store.getCount() > 0)
			{
				tmpStore.fromField.store.removeAll();
			}
			if(tmpStore.toField.store.getCount() > 0)
			{
				tmpStore.toField.store.removeAll();
			}

			var servers = rootJson['servers'];
			servertypesObj.getStore().loadRawData(servers);
			var isServerAvailable = servertypesObj.getStore().findExact('valueField', servertypesObj.getValue(), 0);
			if (isServerAvailable == -1 || servertypesObj.getValue() == "-1")
			{
				servertypesObj.setValue("-1");
			}
			else
			{
				tmpStore.fromField.store.add(managedServers);
				tmpStore.toField.store.add(unmanagedServers);
			}

			if (isDiscAlive == false || isDiscFileReadable == false || isDiscState == false)
			{
				Ext.getCmp('discoveryMsgLoader').hide();
				return;
			}
			fromQuickMenu = false;
			setTimeout('refreshOnDiscAlive()',5000);
		},
		failure : function()
		{
			if (fromQuickMenu == false && myMask != '')
			{
				myMask.hide();
			}
			return;
		}
	});
}


function showMoreSelectedComps()
{
	appCnt.showComponentSelector();
}

function Clear(type)
{
	if (type == "iprange")
	{
		var iprangeObj = Ext.getCmp('iprange');
		iprangeObj.setValue("");
		iprangeObj.focus();
	}
	else
	{
		var commObj = Ext.getCmp('Community');
		commObj.setValue("");
		commObj.focus();
	}
}

function getLocalIPRange()
{
	var address = publicJSON['EgIPAddressStack'];
	if (Ext.isEmpty(address))
	{
		Ext.Msg.alert(pageTitle2,"Could not find IP range for this environment.");
	}
	else
	{
		Ext.getCmp('iprange').setValue(address);
	}
}
function getDomainAddPage()
{
	var domainServerUrl = "/final/admin/EgAuthenticationTree.jsp?ctype=Add&selectedNode=fromDiscovery";
	window.location.href = domainServerUrl;
}


function chkSelector(obj,size,serverName,serverID,allServers,radioID)
{
	var allServersStr = allServers.slice(1,allServers.length-1);
	var appliedClassName = obj.className;
	if (appliedClassName.indexOf("x-form-radio-checked") == -1)
	{
		obj.className ="x-form-field x-form-radio x-form-radio-checked";

		if (lastCheckedRadioButton != "" && lastCheckedRadioButton.length > 0)
		{
			var lastCheckedBox = document.getElementById(lastCheckedRadioButton+"_radio");
			lastCheckedBox.className = "x-form-field x-form-radio";

			for (var i=0;;i++)
			{
				var tmpID = document.getElementById(lastCheckedRadioButton+i);
				if (tmpID == null || tmpID == 'undefined')
				{
					break;
				}
				tmpID.className ="x-field x-form-item x-field-default x-checkboxgroup-form-item";
			}
			document.getElementById(lastCheckedRadioButton).className = "x-field x-form-item x-field-default x-checkboxgroup-form-item";
			var tmpArr = selectedComponentsCB.split(",");
			for (var j = 0;j<tmpArr.length;j++)
			{
				var tmpVal = Ext.String.trim(tmpArr[j]);
				removeComponent(lastCheckedRadioButton+"#$#"+tmpVal);
			}
		}

		lastCheckedRadioButton = serverName;
		selectedComponentsCB = allServersStr;
	}
	else
	{
		obj.className = "x-form-field x-form-radio";

		for (var i=0;;i++)
		{
			var tmpID = document.getElementById(serverName+i);
			if (tmpID == null || tmpID == 'undefined')
			{
				break;
			}
			tmpID.className ="x-field x-form-item x-field-default x-checkboxgroup-form-item";
		}
		document.getElementById(serverName).className = "x-field x-form-item x-field-default x-checkboxgroup-form-item";
		var tmpArr = allServersStr.split(",");
		for (var j = 0;j<tmpArr.length;j++)
		{
			var tmpVal = Ext.String.trim(tmpArr[j]);
			removeComponent(lastCheckedRadioButton+"#$#"+tmpVal);
		}

		lastCheckedRadioButton = '';
		selectedComponentsCB = '';
	}
}

function addAutomanageSrvs(tmpSrvList,obj)
{
	var selectedCategoryList = Ext.getCmp('serverCategoryList').getValue();
	var tempSrvList = tmpSrvList.toString();
	
	var temp;
	if (tempSrvList != null)
	{
		temp = tempSrvList.split(",");
	}

	if (temp != "" && temp.length > 0)
	{
		if (selectedCategoryArr.indexOf(selectedCategoryList) == -1)
		{
			selectedCategoryArr.push(selectedCategoryList);
			for (var i=0; i<temp.length; i++)
			{
				var tmpStr = temp[i];
				if (srvListArray.indexOf(tmpStr) == -1)
				{
					srvListArray.push(tmpStr);
				}				
			}
			if (obj.getValue() !== undefined)
			{
				toFieldData(obj);
			}
		}
		else
		{
			for (var i=0; i<temp.length; i++)
			{
				var tmpStr2 = temp[i];
				if (srvListArray.indexOf(tmpStr2) == -1)
				{
					srvListArray.push(tmpStr2);
				}
			}
			if (obj.getValue() !== undefined)
			{
				toFieldData(obj);
			}
		}
	}
	else
	{
		toFieldData(obj);
	}
}

function fromFieldData(obj)
{
	var itemSelObj = obj;
	var storeObj = itemSelObj.fromField.store;
	var associatedNow = '';
	var count = storeObj.getCount();
	for (var s=0; s < count; s++)
	{
		var newVal = storeObj.getAt(s).get('valueField');
		if (s == (count-1))
		{
			associatedNow += newVal;
		}
		else
		{
			associatedNow += newVal+',';
		}
	}
	addAutomanageSrvs(associatedNow,obj);
}

function toFieldData(obj)
{
	unmanageList = obj.getValue();
	var tmpList = unmanageList.toString();
	var tmpArr = tmpList.split(",");

	if (tmpArr != "" && tmpArr.length > 0)
	{
		for (var i=0; i<tmpArr.length; i++)
		{
			var tmpStr = tmpArr[i];
			for (var u=0; u<srvListArray.length; u++)
			{
				if (srvListArray[u].indexOf(tmpStr) != -1)
				{
					var pos = srvListArray.indexOf(srvListArray[u]);
					srvListArray.splice(pos, 1);
				}
			}
		}
	}
}

function dateValidation(k, e) {
	var fromyear = parseInt(k.substring((k.lastIndexOf("/") + 1)));
	var fromdate = parseInt(k.substring((k.indexOf("/") + 1), k.lastIndexOf("/")));
	var frommonth = parseInt(k.substring(0, k.indexOf("/")));
	var toyear = parseInt(e.substring((e.lastIndexOf("/") + 1)));
	var todate = parseInt(e.substring((e.indexOf("/") + 1), e.lastIndexOf("/")));
	var tomonth = parseInt(e.substring(0, e.indexOf("/")));
	var b = 0;
	if (fromyear > toyear) 
	{
		b = -1;
	} 
	else 
	{
		if (fromyear == toyear)
		{
			if (frommonth > tomonth)
			{
				b = -1;
			} 
			else 
			{
				if (frommonth == tomonth)
				{
					if (fromdate > todate)
					{
						b = -1;
					} 
				}
			}
		}
	}
	return b;
}
function closedManagedWindow()
{
	appCnt.initDiscoveredDetails();
	var windowObj = Ext.getCmp('manageWindow');
	if (windowObj != null && windowObj != undefined)
	{
		windowObj.destroy();
	}
}
function getGridPanelReport(gridArray,cols,gridTitle)
{
	var gridpanel ="";
	var fieldstoStore =  new Array();
	var mainColumnsObjArray =  new Array();
	for (var key in cols)
	{
		var gridColumn = cols[key];
		if (cols[key] == 'LAST DISCOVERED TIME' || cols[key] == 'FIRST DISCOVERED TIME' )
		{
			fieldstoStore.push({name: key, type: 'date'});
		}
		else
		{
			fieldstoStore.push(key);
		}
		if(key=="iconhide")
		{
			mainColumnsObjArray.push({
				xtype:"actioncolumn",
				width:36, 
				id:"iconmanage",
				dataIndex: 'iconmanage',
				sortable:false,
				renderer: function(value, metaData, record, row, col, store, gridView)
				{
					var isIconHide = record.data['iconhide'];
					var hiddenfield1 = record.data['hiddenfield'];
					metaData.tdAttr = "data-qtip='Manage' data-qclass='yellowTip'";
					if (!isIconHide)
					{
						return '<div class=""></div>';
					}
					else
					{
						return "<div style='cursor:pointer' onclick=\"javascript:appCnt.manageComponent('"+gridView+"','"+row+"','"+col+"','"+hiddenfield1+"')\"  class='iconManage'></div>";//
					}
				}
			});
		}
		else if(key=="hiddenfield")
		{
			mainColumnsObjArray.push({
				header: 'hiddenCol',
				dataIndex: key,
				hidden:true,
			});
		}
		else if(key=="end_time")
		{
			mainColumnsObjArray.push({
					dataIndex: key,
					header: gridColumn,
					id: "end_date",
					menuDisabled: true,
					sortable: true,
					flex: 1,
					renderer: renderLast
			});
		}
		else if(key=="start_time")
		{
			mainColumnsObjArray.push({
					dataIndex: key,
					header: gridColumn,
					id: "start_time",
					menuDisabled: true,
					sortable: true,
					flex: 1,
					renderer: renderLast
			});
		}
		else
		{
			mainColumnsObjArray.push({
				header: gridColumn,
				sortable:true,
				dataIndex: key,
				menuDisabled: true,
				flex:1,
			});
		}
	}
	gridpanel = Ext.widget('detailsgrid',{
	store:new Ext.data.Store({
		fields: fieldstoStore,
		data: gridArray,
		proxy: {
			type: "pagingmemory",
			reader: {
				type: "json"
			}
		},
		remoteSort : true,
		autoLoad: true,
		pageSize : 15
	}),
	sortableColumns:true,
	columns:mainColumnsObjArray,
	title:gridTitle,//"Total Discovered Components: "+totCount,
	viewConfig: {
		forceFit: true,
		stripeRows : true
	},
	width : '90%',
	tools : [
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'saveTool',
			items: [{
				xtype: 'button',
				iconCls: 'iconPdf',
				id: 'save',
				style: {
					background: 'none',
					border: '0px'
				},
				listeners:{
					afterrender:function(){
						Ext.create("Ext.tip.ToolTip",{
							target:this.id,
							anchor:"top",
							cls:"yellowTip",
							trackMouse:true,
							html:"PDF"
						});
					}
				}
			}]
		},
		{xtype:"tbseparator"},
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'printTool',
			items: [
				{
					xtype: 'button',
					iconCls: 'iconPrinter',
					id: 'print',
					style: {
						background: 'none',
						border: '0px'
					},
					listeners:{
						afterrender:function(){
							Ext.create("Ext.tip.ToolTip",{
								target:this.id,
								anchor:"top",
								cls:"yellowTip",
								trackMouse:true,
								html:"Print"
							});
						}
					}
				}
			]
		},
		{xtype:"tbseparator"},
		{
			xtype:'container',
			margin:'0 1px 0 1px',
			items:[
				{
					xtype:'button',
					id: 'saveCSV',
					//disabled : true,
					iconCls:'iconCsv',
					style:{
						background:'none',border:'0px'
					},
					listeners:{
						afterrender:function(){
							Ext.create("Ext.tip.ToolTip",{
								target:this.id,
								anchor:"top",
								cls:"yellowTip",
								trackMouse:true,
								html:"CSV"
							});
						}
					}
				}
			]
		}
		]
	});
	var resultPanelObj = Ext.getCmp('reportpanel_in_formitem');
	resultPanelObj.removeAll();
	resultPanelObj.add(gridpanel);
	resultPanelObj.show();
}

function updateReportPanel()
{
	var resultPanelObj = Ext.getCmp('reportpanel_in_formitem');
	resultPanelObj.removeAll();
	var emptyResultPanel = {
		style : {'text-align':'center'},
		padding : 150,
		border :false,
		html: '<div class = "iconInformation" style="margin:0 auto" ></div><div class="commonErrorMsgText">No discovered component(s) found for your current search.</div>'
	};
	resultPanelObj.add(emptyResultPanel);
	resultPanelObj.show();
}

function changeTimeLineFromDate(timelineVal)
{
	var fromDate = "";
	if(timelineVal == "24 hours" || timelineVal == "12 hours" || timelineVal == "6 hours" || timelineVal == "1 hour")
	{
		fromDate = Ext.Date.add (new Date(),Ext.Date.DAY,0);
	}
	else if (timelineVal == "2 days")
	{
		fromDate = Ext.Date.add (new Date(),Ext.Date.DAY,-2);
	}
	else if (timelineVal == "4 days")
	{
		fromDate = Ext.Date.add (new Date(),Ext.Date.DAY,-4);
	}
	else if (timelineVal == "1 week")
	{
		fromDate = Ext.Date.add (new Date(),Ext.Date.DAY,-7);
	}
	else if (timelineVal == "4 weeks")
	{
		fromDate = Ext.Date.add (new Date(),Ext.Date.DAY,-28);
	}
	else if (timelineVal == "1 month")
	{
		fromDate = Ext.Date.add (new Date(),Ext.Date.MONTH,-1);
	}
	return fromDate;
}


function renderLast(value, p, r) 
{
	var date = Ext.String.format('{0} {1}', Ext.Date.dateFormat(value, extjsDateFormat+'|'), r.get('LAST DISCOVERED TIME'));
	date = date.substring(0,date.indexOf('|'));
	return date;
}
