var selectedCategoryArr = [];
var srvListArray = [];
var unmanageList = [];
var loadCount = 0;
var isApplied = true;
var isSavedFromPrompt = false;
var compSaveMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Saving...'});
Ext.define('EgServerDiscovery.view.ConfigureComponentTypes', {
	extend: 'utilities.ScrollableWindow',
	id : 'configurationWindow',
	alias: 'widget.configurecomponenttypes',
	width: 700,
	title: intnlLabel45,
	resizable: false,
	draggable: false,
	autoScroll:false,
	scroll:false,
	modal: true,

	requires: [
		'Ext.ux.form.ItemSelectorSI'
	],

	listeners : {
		'afterrender' : function()
		{
			var appURL = "EgServerDiscovery/data/EgChangePortsJson.jsp?from=commonSettings&selectedNode=node10&LoadCount="+loadCount;
			Ext.Ajax.request({
				url : appURL,
				method : 'POST',
				async : false,
				success: function(response)
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
				}
			});
			Ext.getCmp('resultHeaderCt').hide();

			var serverCategoryList = Ext.getCmp('serverCategoryList');
			var componentDetails = Ext.getCmp('selectedCompDetails');
			serverCategoryList.getStore().loadRawData(publicJSON['generalSettings']['serverCategoryArr']);
			serverCategoryList.setValue(publicJSON['generalSettings']['isAllSelected']);
			if(componentDetails.fromField.store.getCount() > 0)
			{
				componentDetails.fromField.store.removeAll();
			}
			if(componentDetails.toField.store.getCount() > 0)
			{
				componentDetails.toField.store.removeAll();
			}
	
			var managedServers = publicJSON['generalSettings']['discSrvrArray'];
			var unmanagedServers = publicJSON['generalSettings']['allSrvrArray'];
			componentDetails.fromField.store.add(managedServers);
			componentDetails.toField.store.add(unmanagedServers);
			//fromFieldData(componentDetails);
		},
		'beforeClose' : function()
		{
			var me = this;
			if (srvListArray.length != 0 && (!isApplied))
			{
				if (!isSavedFromPrompt)
				{
					Ext.Msg.show({
						title:intnlLabel45,
						msg:'Your unsaved changes will be lost'+ '. Would you like to save your changes?',
						buttons: Ext.Msg.YESNO,
						icon : 'iconInformation',
						fn : function(btn)
						{
						 if (btn == 'yes')
							{
								isSavedFromPrompt = true;
								compSaveMask.show();
								appCnt.applySeverChange();
								me.close();
								return false;
							}else if (btn == 'no'){
								srvListArray = [];
								selectedCategoryArr = [];
								unmanageList = [];
								loadCount = 0;
								isApplied = true;
								me.close();
								appCnt.refreshWindow();
								return true;
							}
						}
					});
				}
				return false;
			}
		},
		'close' : function()
		{
			loadCount = 0;
			srvListArray = [];
			selectedCategoryArr = [];
			unmanageList = [];
			isApplied = true;
			isSavedFromPrompt = false;
			var appURL = 'EgServerDiscovery/data/EgChangePortsJson.jsp?from=commonSettings&selectedNode=node10&ServerDisplay='+srvListArray+'&LoadCount='+loadCount;
			Ext.Ajax.request({
				url : appURL,
				method : 'POST',
				async : false,
				success: function(response)
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
				}
			});
			appCnt.refreshWindow();
			//appCnt.updateApplicationServerSettings("menu");
		}
	},

	items: [
		{
			xtype: 'container',
			id : 'resultHeaderCt',
			margin : '10 10 0 10',
			padding: 5,
			hidden : true,
			cls: 'formOuter',
			layout: {
				type: 'hbox',
				pack: 'center',
			},
			items : [{
				xtype : 'component',
				html  : '<table border="0"><tr><td><div class="iconRight"></div></td><td><b>&nbsp;Changes have been updated successfully.</b><td></tr></table>',
			}]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: 10,
			items: [
				{
					xtype:'scrollcombo',
					cls: 'dropdown',
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 250,
					fieldLabel:intnlLabel44,
					name: 'serverCategoryList',
					id: 'serverCategoryList',
					editable : false,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					listeners : {
						change : function(obj)
						{
							Ext.getCmp('resultHeaderCt').hide();
							appCnt.onSrvGroupChange(obj);
						}
					}
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type : 'hbox',
				pack: 'center',
				align : 'stretch'
			},
			flex: 1,
			margin: '20 10 10 10',
			items: [
				{
					xtype: 'itemselectorfield',
					id: 'selectedCompDetails',
					name: 'selectedCompDetails',
					cls:'multiselect',
					buttons: ['add', 'remove'],
					onAddBtnClick : function() {
						var me = this,
							selected = me.getSelections(me.fromField.boundList);

						me.moveRec(true, selected);
						me.toField.boundList.getSelectionModel().select(selected);
						isApplied = false;
						var tempSrvList = Ext.getCmp('selectedCompDetails');
						fromFieldData(tempSrvList);
					},
					onRemoveBtnClick : function() {
						var me = this,
							selected = me.getSelections(me.toField.boundList);

						me.moveRec(false, selected);
						me.fromField.boundList.getSelectionModel().select(selected);
						isApplied = false;
						var tempSrvList = Ext.getCmp('selectedCompDetails');
						fromFieldData(tempSrvList);
					},
					onItemDblClick: function(view, rec) {
						this.moveRec(view === this.fromField.boundList, rec);
						isApplied = false;
						var tempSrvList = Ext.getCmp('selectedCompDetails');
						fromFieldData(tempSrvList);
					},
					syncValue: function() {
						var me = this;
						me.mixins.field.setValue.call(me, me.setupValue(me.toField.store.getRange()));
					},
					buttonsText: {
						add: intnlLabel46,
						remove: intnlLabel47
					},
					toTitle:intnlLabel43,
					fromTitle:intnlLabel42,
					multiSelect: true,
					height: 300,
					width: 650,
					displayField: 'displayField',
					valueField: 'valueField',
					store: Ext.create('Ext.data.Store', {
						fields: ['valueField', 'displayField'],
						data: []
					})
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '20 10 20 10',
			items: [
				{
					xtype: 'button',
					text: label14,
					id : 'btnApply',
					cls:'button20',
					width: 80
				}
			]
		}
	]

});



