Ext.define('EgServerDiscovery.view.EgConfigEnvFormContainer',{
	extend:'Ext.form.Panel',
	alias:'widget.egconfigenvformcontainer',
	id : 'egconfigenvformcontainer',
	border :false,
	autoScroll : false,
	scroll : false,
	flex: 1,

	requires: [
		'Ext.ux.form.ItemSelectorSI'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	dockedItems: [
		{
			dock: 'bottom',
			layout:{
				type: 'hbox',
				pack: 'center'
			},
			border: false,
			padding: '10 0 10 0',
			items: [
				{
					xtype: 'button',
					text: intnlLabel7,
					cls: 'button20',
					id: 'Update'
				}
			]
		}
	],

	items:[
		{
			xtype : 'container',
			id : 'discoveryMsgLoader',
			hidden : true,
			layout : {
				type : 'vbox',
				align : 'center'
			},
			margin : '10 10 0 10',
			items : [
				{
					xtype : 'component',
					border : false,
					id : 'eGDiscoveryLoader',
					//cls : 'discoveryLoader',
					html : '<div style="padding-left:5px"><img src="/final/admin/eg_images/discovery_preloader.gif"/></div><div style="margin-top:5px;margin-bottom:3px;margin-left: 10px;"><b>Discovery is in progress</b></div>'
				},
				{
					id : 'eGDiscoveryLoaderOption',
					border : false,
					html : 'This page will auto-refresh in 5 secs.&nbsp;To disable refresh and to proceed with manage activity,&nbsp;<a class="eg_monlink" href="javascript:void(0)" onclick="javascript:stopAutoRefresh()"><b>Click here</b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a>'
				}
			]
		},
		{
			xtype:'container',
			layout : {
				type : 'vbox',
				align : 'center',
				pack : 'center'
			},
			items:[
				{
					xtype: 'container',
					layout: {
						type : 'hbox',
						pack: 'center'
					},
					cls:'formOuter',
					width:750,
					padding: 10,
					margin: 10,
					items:[
						{
							xtype:'scrollcombo',
							cls: 'dropdown',
							labelAlign: 'top',
							labelSeparator: ' ',
							width: 250,
							labelSeparator:'',
							fieldLabel:intnlLabel2,
							name: 'servertypes',
							id: 'servertypes',
							editable : false,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'
						},
						{
							xtype: 'checkboxfield',
							id : 'activeCompTypes',
							name : 'activeCompTypes',
							inputValue: '1',
							boxLabel  : intnlLabel3,
							cls: 'checkbt',
							checked : false,
							margin: '20 0 0 20'
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			id : 'searchFieldContainer',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			hidden: true,
			items: [
				{
					xtype: 'container',
					width: 360,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [
						{
							xtype: 'trigger',
							id : 'managedSeacrchBox',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							cls: 'whitedropdown_search',
							emptyText: 'Search',
							margin: '0 0 5 0',
							getTriggerMarkup: function() {
								var me = this,
									i = 0,
									hideTrigger = (me.readOnly || me.hideTrigger),
									triggerCls,
									triggerBaseCls = me.triggerBaseCls,
									triggerConfigs = [],
									unselectableCls = Ext.dom.Element.unselectableCls,
									style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
									cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}

								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'managedSeacrchBox_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'managedSeacrchBox_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

								return Ext.DomHelper.markup(triggerConfigs);
							},
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								appCnt.searchComponent("managed",this.getValue(),this);
							},
							listeners :
							{
								change : function(obj)
								{
									appCnt.searchComponent("managed",obj.getValue(),obj);
								},
								specialkey: function(field, e){
									// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
									// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
									if (e.getKey() == e.ENTER) {
										appCnt.searchComponent("managed",field.getValue(),field);
									}
								}
							}
						}
					]
				},
				{
					xtype: 'tbspacer',
					width: 30
				},
				{
					xtype: 'container',
					width: 360,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [
						{
							xtype: 'trigger',
							id : 'unmanagedSeacrchBox',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							cls: 'whitedropdown_search',
							emptyText: 'Search',
							margin: '0 0 5 0',
							getTriggerMarkup: function() {
								var me = this,
									i = 0,
									hideTrigger = (me.readOnly || me.hideTrigger),
									triggerCls,
									triggerBaseCls = me.triggerBaseCls,
									triggerConfigs = [],
									unselectableCls = Ext.dom.Element.unselectableCls,
									style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
									cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}

								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'unmanagedSeacrchBox_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'unmanagedSeacrchBox_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

								return Ext.DomHelper.markup(triggerConfigs);
							},
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								appCnt.searchComponent("unmanaged",this.getValue(),this);
							},
							listeners :
							{
								change : function(obj)
								{
									appCnt.searchComponent("unmanaged",obj.getValue(),obj);
								},
								specialkey: function(field, e){
									// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
									// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
									if (e.getKey() == e.ENTER) {
										appCnt.searchComponent("unmanaged",field.getValue(),obj);
									}
								}
							}
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type : 'hbox',
				pack: 'center',
				align : 'stretch',
			},
			flex: 1,
			items: [
				{
					xtype: 'itemselectorfield',
					id: 'componentDetails',
					name: 'componentDetails',
					cls:'multiselect',
					buttons: ['add', 'remove'],
					onAddBtnClick : function() {
						isComponentUpdated = false;
						var me = this,
							selected = me.getSelections(me.fromField.boundList);

						me.moveRec(true, selected);
						me.toField.boundList.getSelectionModel().select(selected);
					},
					onRemoveBtnClick : function() {
						isComponentUpdated = false;
						var me = this,
							selected = me.getSelections(me.toField.boundList);

						me.moveRec(false, selected);
						me.fromField.boundList.getSelectionModel().select(selected);
					},
					onItemDblClick: function(view, rec) {
						isComponentUpdated = false;
						this.moveRec(view === this.fromField.boundList, rec);
					},
					syncValue: function() {
						//isComponentUpdated = false;
						var me = this;
						me.mixins.field.setValue.call(me, me.setupValue(me.toField.store.getRange()));
					},
					buttonsText: {
						add: "Add to Unmanaged",
						remove: "Remove from Unmanaged"
					},
					toTitle:intnlLabel4,
					fromTitle:intnlLabel5,
					multiSelect: true,
					height: 300,
					width: 750,
					displayField: 'displayField',
					valueField: 'valueField',
					store: Ext.create('Ext.data.Store', {
						fields: ['valueField', 'displayField'],
						data: []
					})
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'container',
					width: 360,
					layout: {
						type: 'hbox',
						pack: 'start'
					},
					items: [
					]
				},
				{
					xtype: 'tbspacer',
					width: 30
				},
				{
					xtype: 'container',
					width: 360,
					layout: {
						type: 'hbox',
						pack: 'start'
					},
					items: [
						{
							xtype:'label',
							text: '* Newly discovered components',
							margin: '5 0 0 0'
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'container',
					width: 360,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [
						{
							xtype:'button',
							name:'deleteManaged',
							cls: 'button20',
							id: 'deleteManaged',
							text: intnlLabel6,
							margin: '5 0 0 0'
						}
					]
				},
				{
					xtype: 'tbspacer',
					width: 30
				},
				{
					xtype: 'container',
					width: 360,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [
						{
							xtype:'button',
							cls: 'button20',
							name:'deleteUnManaged',
							id: 'deleteUnManaged',
							text: intnlLabel6,
							margin: '5 0 0 0'
						}
					]
				}
			]
		},
		{
			xtype: 'hiddenfield',
			name : 'fmanage',
			id : 'fmanage',
			value : ''
		},
		{
			xtype: 'hiddenfield',
			name : 'funmanage',
			id : 'funmanage',
			value : ''
		},
		{
			xtype: 'hiddenfield',
			name : 'fmanagewithcomptype',
			id : 'fmanagewithcomptype',
			value : ''
		},
		{
			xtype: 'hiddenfield',
			name : 'funmanagewithcomptype',
			id : 'funmanagewithcomptype'
		},
		{
			xtype: 'hiddenfield',
			name : 'srvtype',
			id : 'server',
			value : ''
		},
		{
			xtype: 'hiddenfield',
			name : 'hiddenElemList',
			id : 'hiddenElemList',
			value : ''
		}
	]

});



