Ext.define('EgServerDiscovery.view.EgDiscoveryReport', {
	extend:'Ext.form.Panel',
	alias:'widget.discoveryreport',
	id:'discoveryreport',
	scroll: false,
	autoScroll : false,

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	flex: 1,

	items: [
		{
			xtype: 'container',
			id:'combofilters',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			defaults: {
				labelAlign: 'top',
				labelSeparator: '',
			},
			border: true,
			style: 'border: 1px solid blue',
			cls: 'formOuter',
			margin: '10 10 0 10',
			padding: 10,
			items : [
				{
					xtype:'combo',
					id: 'componentTypeCombo',
					name: 'componentTypeCombo',
					cls: 'dropdown',
					editable : false,
					fieldLabel : intnlLabel1,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					width: 230
				},
				{
					xtype:'combo',
					id: 'searchByCombo',
					name: 'searchByCombo',
					cls: 'dropdown',
					editable : false,
					fieldLabel :intnlLabel77,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					width: 150,
					margin: '0 0 0 10'
				},
				{
					xtype: 'trigger',
					cls:'whitedropdown_search',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					fieldLabel : " ",
					id: 'nickSearch',
					name: 'nickSearch',
					emptyText: 'Search',
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) 
						{
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() {
						this.reset(); 
					},
					onTrigger2Click : function() {
						appCnt.mainGridSearch();
					},
					width: 200,
					margin: '0 0 0 10'
				},
				{
					xtype:'combo',
					id: 'timelineCombo',
					name: 'timelineCombo',
					cls: 'dropdown',
					editable : false,
					fieldLabel : intnlLabel78,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					width: 100,
					margin: '0 0 0 10'
				},
				{
					xtype: 'datepicker',
					id:'datepickfrom',
					fieldLabel: intnlLabel79,
					labelAlign: 'top',
					labelSeparator: ' ',
					editable : false,
					disabled: false,
					format: mgrDateFormat,
					allowBlank: false,
					listeners: {
						select: function(picker, value) {
							appCnt.getDateValue();
						}
					},
					width: 120,
					margin: '0 0 0 5'
				},
				{
					xtype: 'datepicker',
					id:'datepickTo',
					fieldLabel: intnlLabel80,
					labelAlign: 'top',
					labelSeparator: ' ',
					editable : false,
					disabled: false,
					format: mgrDateFormat,
					allowBlank: false,
					listeners: {
						select: function(picker, value) {
							appCnt.getDateValue();
						}
					},
					width: 120,
					margin: '0 0 0 5'
				}
			]
		},
		{
			xtype: 'label',
			id:'errorMsg',
			//margin: '20 50 20 20' ,
			flex:1,
			hidden:true,
			html: '<table><tr><td align="center" height="150"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">No component found for current search.</td></tr></table></td></tr></table>'
		},
		{
			xtype: 'reportpanel',
			id:"reportpanel_in_formitem",
			flex: 1,
			margin: 0,
			hidden:true
		}
	]
});



