
Ext.define('EgServerDiscovery.view.RemoteAgentsGrid',{
	extend:'Ext.form.Panel',
	alias:'widget.remoteagentsgrid',
	id: 'remoteagentsgrid',
	requires : [
		'utilities.ScrollCombo',
		'utilities.CustomGrid',
		'utilities.DatePicker',
		'Ext.ux.RowExpander'
	],

	//tools: [
		//{
			//xtype:'button',
			//id: 'saveCSV',
			//iconCls:'iconCsv',
			//style:{
				//background:'none',border:'0px'
			//},
			//listeners:{
				//afterrender:function()
				//{
					//Ext.create("Ext.tip.ToolTip",{
						//target:this.id,
						//anchor:"top",
						//cls:"yellowTip",
						//trackMouse:true,
						//html:"CSV"
					//});
				//},
				//click: function()
				//{
					//window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+userLanguage;
				//}
			//}
		//}
	//],
	items:[
		{
			xtype:'customgrid',
			id:'usersgrid',
			name:'usersgrid',
			//border:false,
			//autoScroll: true,
			//width : 950,
			cls:'gridSkin',
			store: new Ext.data.Store({
				fields: ['vCenterName', 'Count', 'AssignedAgents','isAgentsAssociated','AssignedEsx','TotalEsxCount','TotalClubEsxHosts'],
				data: []
			}),
			//title : 'All vCenters',
			rowBodyTrSelector: '.x-grid-rowbody-tr',
			rowBodyHiddenCls: 'x-grid-row-body-hidden',
			rowCollapsedCls: 'x-grid-row-collapsed',

			tbar: [
				{
					xtype:'scrollcombo',
					id: 'agentsCombo',
					name: 'agentsCombo',
					width: 310,
					labelWidth: 60,
					editable : false,
					fieldLabel:'vCenter',
					labelSeparator : '',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					listeners: {
						select: function()
						{
							appCnt.loadUniqueVcenterRmtAgent();
						}
					}
				},
				{
					xtype: 'tbfill'
				},
				{
					xtype: 'button',
					id : 'nodeExpand',
					iconCls: 'iconExpandAll',
					hidden:false,
					style: {
						background: 'none',
						border: '0px'
					},
					listeners: {
						'click':function(obj){
							this.hide();
							Ext.getCmp('nodeCollapse').show();
							for (var i = 0;i<this.up('grid').getStore().getCount();i++)
							{
								this.up('grid').expandAllRow(i);
							}
							this.up('grid').view.refreshSize();
						}
					}
				},
				{
					xtype:'button',
					id :'nodeCollapse',
					iconCls: 'iconCollapseAll',
					hidden:true,
					style: {
						background: 'none',
						border: '0px'
					},
					listeners:{
						'click':function(obj){
							this.hide();
							Ext.getCmp('nodeExpand').show();
							for (var i = 0;i<this.up('grid').getStore().getCount();i++)
							{
								this.up('grid').collapseAllRow(i);
							}
							this.up('grid').view.refreshSize();
						}
					}
				},
				{
					xtype:'button',
					id: 'saveCSV',
					name: 'saveCSV',
					iconCls:'iconCsv',
					style:{
						background:'none',border:'0px'
					},
					listeners:{
						afterrender:function()
						{
							Ext.create("Ext.tip.ToolTip",{
								target:this.id,
								anchor:"top",
								cls:"yellowTip",
								trackMouse:true,
								html:"CSV"
							});
						},
						click: function()
						{
							window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+userLanguage;
						}
					}
				}
			],

			plugins: [
				{
					ptype: 'rowexpander',
					rowBodyTpl : [
						'{[this.getRowBodyView(values)]}',
						{
							getRowBodyView : function(values)
							{
								if (values.isAgentsAssociated == true)
								{
										var tmpStr = "";
										var htmlStr = "<table border='0' cellpadding='5' cellspacing='0' style='width:100%'>";

										if (values.AssignedEsx != '-')
										{
											tmpStr = tmpStr + '<div><p><i>Managed ESX Host(s) ('+values.TotalEsxCount+') </i><br>'+values.TotalClubEsxHosts+'</p></div>';
										}

										htmlStr = htmlStr + "</table>";
										return '<div style="padding-top:0.5em;padding-bottom:0.5em;padding-left: 5em;">'+tmpStr+'</div>';
								}
								else
								{
									return '<div style="padding-top:1em;padding-bottom:1em;padding-left: 5em;font-style: italic;">No ESX host(s) found</div>';
								}
							}
						}
					]
				}
			],

			columns : [
				{
					dataIndex: 'vCenterName',
					text:'vCenter',
					menuDisabled:true,
					width:200,
					renderer: function(value, metaData, record, row, col, store, gridView)
					{
						return value;
					}
				},
				{
					dataIndex: 'Count',
					text:'Count',
					menuDisabled:true,
					width:60,
					tooltip: 'Remote agents count'

					//tooltip: {
						//target: 'Count',
						//anchor: 'right',
						//trackMouse: true,
						//html: 'Remote agents count'
					//}
				},
				{
					dataIndex: 'AssignedAgents',
					text:'Remote agents',
					menuDisabled:true,
					flex :1,
					renderer: function(value, metaData, record, row, col, store, gridView)
					{
						//var val0 = new Array();
						if (value != "-")
						{
							var val0 = value.toString().split(",");
							var result = '<table border="0" width="100%" cellspacing="0" cellpadding="0" class="font_normal11">';
							for (var v=0;v<val0.length;v=v+2 )
							{
								result += '<tr>';
								if (!Ext.isEmpty(val0[v]))
								{
									result += '<tr><td width="50%" height="20" valign="top">'+val0[v]+'</td>';
								}
								if (!Ext.isEmpty(val0[v+1]))
								{
									result += '<td width="50%" height="20" valign="top">'+val0[v+1]+'</td>'; 
								}
								//if (!Ext.isEmpty(val0[v+2]))
								//{
									//result += '<td width="33%" height="20" class="font_bold11" valign="top">'+val0[v+2]+'</td></tr>';
								//}
								result += '</tr>';

							}
							result += '</table>';
							return result;
						}
						else
						{
							return value;
						}

					}
				}
			],
			expandAllRow: function(rowIdx) 
			{
				var view = this.view,
				rowNode = view.getNode(rowIdx),
				row = Ext.get(rowNode),
				nextBd = Ext.get(row).down(this.rowBodyTrSelector),
				record = view.getRecord(rowNode);

				if(row.hasCls(this.rowCollapsedCls)) {
					row.removeCls(this.rowCollapsedCls);
					nextBd.removeCls(this.rowBodyHiddenCls);
				}
			},
			collapseAllRow: function(rowIdx) 
			{
				var view = this.view,
				rowNode = view.getNode(rowIdx),
				row = Ext.get(rowNode),
				nextBd = Ext.get(row).down(this.rowBodyTrSelector),
				record = view.getRecord(rowNode);

				row.addCls(this.rowCollapsedCls);
				nextBd.addCls(this.rowBodyHiddenCls);
			},
			margin: 10,
			emptyText: '<table border="0" width="100%" height="300px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noAgentAlrtDiv">No Data found.</div></td></tr></table>',
			viewConfig: {
				deferEmptyText: false
			}
		}
	]
});



