<%@ include file="../../EgTrackerAJSON.jsp"%>

<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
/*
*	This page helps to load the data for RabbitMQ node in Discovery tree.
*	ini File : eg_services.ini, subject : [RabbitMQ_Cluster]
*/
%>

<%

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();

	String rabbitMQ = "RabbitMQ_Cluster";
	IniFile services = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	String[] rabbitMQComps = services.getVariables(rabbitMQ);

	String from = request.getParameter("from");

	JSONArray mComboArray = new JSONArray();	
	JSONObject mJson = new JSONObject();
	mJson.put("displayField",_mapping.getTextDescription("admin.discovery.View configured RabbitMQ Cluster"));
	mJson.put("valueField","VIEW");
	mComboArray.add(mJson);

	mJson.put("displayField",_mapping.getTextDescription("admin.discovery.Add new RabbitMQ Cluster"));
	mJson.put("valueField","ADD");
	mComboArray.add(mJson);

	mJson.put("displayField",_mapping.getTextDescription("admin.discovery.Modify configured RabbitMQ Cluster"));
	mJson.put("valueField","MODIFY");
	mComboArray.add(mJson);

	mJson.put("displayField",_mapping.getTextDescription("admin.discovery.Delete configured RabbitMQ Cluster"));
	mJson.put("valueField","DELETE");
	mComboArray.add(mJson);
	rootJson.put("mComboArray",mComboArray);

	JSONArray mComboCatArray = new JSONArray();
	JSONObject mCatJson = new JSONObject();
	mCatJson.put("displayField","RabbitMQ Node");
	mCatJson.put("valueField","rabbit_mq_node");
	mComboCatArray.add(mCatJson);
	rootJson.put("mComboCatArray",mComboCatArray);

	rootJson.put("emptyMessage",_mapping.getTextDescription("admin.discovery.No RabbitMQ Clusters are available currently"));

	if(from != null && (from.equals("viewRabbitMQ") || from.equals("deleteRabbitMQ")))
	{		
		JSONObject columns = new JSONObject();		
		columns.put("IP/Host",_mapping.getTextDescription("admin.discovery.IP/Host"));
		columns.put("SSL",_mapping.getTextDescription("admin.discovery.SSL"));
		columns.put("Webport",_mapping.getTextDescription("admin.discovery.Web port"));
		columns.put("Discovery Enabled",_mapping.getTextDescription("admin.discovery.Discovery Enabled"));
		columns.put("User",_mapping.getTextDescription("admin.discovery.User"));		
		if (from.equalsIgnoreCase("deleteRabbitMQ"))
		{
			columns.put("delOption","");
		}		
		if(rabbitMQComps != null && rabbitMQComps.length > 0)
		{
			JSONArray gridArray = new JSONArray();
			for(int i = 0; i < rabbitMQComps.length; i++)
			{
				String ip = rabbitMQComps[i];
				String value = services.getValue(rabbitMQ,ip);

				StringTokenizer st = new StringTokenizer(value,"#");
				int counts = st.countTokens();
				if(counts == 5)
				{
					String ssl = st.nextToken();
					String user = st.nextToken();
					String pwd = st.nextToken();
					String discover = st.nextToken();
					String webport = st.nextToken();

					if(ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))
					{
						ssl = _mapping.getTextDescription("admin.common.Yes");
					}
					else
					{
						ssl = "No";
					}

					if (webport != null)//For Initial loading
					{
						if (ssl != null && ssl.equals(""))
						{
							webport = "443";
						}
					}

					if(discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))
					{
						discover = _mapping.getTextDescription("admin.common.Yes");
					}
					else
					{
						discover = "No";
					}

					JSONObject json = new JSONObject();

					json.put("IP/Host",ip);
					json.put("SSL",ssl);
					json.put("Webport",webport);
					json.put("Discovery Enabled",discover);
					json.put("User",user);
					if (from.equalsIgnoreCase("deleteRabbitMQ"))
					{
						json.put("delOption",ip);
					}
					gridArray.add(json);
				}
			}
			rootJson.put("gridArray",gridArray);
			rootJson.put("columns",columns);
			rootJson.put("gridTitle",_mapping.getTextDescription("admin.discovery.RabbitMQ Preferences"));
		}
	}
	else if(from != null && from.equals("getAllRabbitMQ"))
	{
		JSONArray comboArray = new JSONArray();

		JSONObject json = new JSONObject();
		json.put("displayField","Choose a RabbitMQ Cluster");
		json.put("valueField","-1");
		comboArray.add(json);

		if(rabbitMQComps != null && rabbitMQComps.length > 0)
		{
			for(int i = 0; i < rabbitMQComps.length; i++)
			{
				String ip = rabbitMQComps[i];
				json = new JSONObject();
				json.put("displayField",ip);
				json.put("valueField",ip);
				comboArray.add(json);
			}
		}
		rootJson.put("comboArray",comboArray);
	}
	else if(from != null && from.equals("getRabbitMQDetails"))
	{
		String ip = request.getParameter("rabbitMQ");
		String value = services.getValue(rabbitMQ,ip);
		if(ip != null && value != null)
		{
			StringTokenizer st = new StringTokenizer(value,"#");
			int counts = st.countTokens();
			if(counts == 5)
			{
				String ssl = st.nextToken();
				String user = st.nextToken();
				String pwd = st.nextToken();
				String discover = st.nextToken();
				String webport = st.nextToken();

				if(ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))
				{
					ssl = _mapping.getTextDescription("admin.common.Yes");
				}
				else
				{
					ssl = "No";
				}

				if(discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))
				{
					discover = _mapping.getTextDescription("admin.common.Yes");
				}
				else
				{
					discover = "No";
				}
				pwd = EgCrypt.decrypt(pwd);

				JSONObject json = new JSONObject();
				json.put("ssl",ssl);
				json.put("webport",webport);
				json.put("user",user);
				json.put("pwd",pwd);
				json.put("discover",discover);
				rootJson.put("json",json);
			}
		}
	}

	session.setAttribute("adminLastAccessedURL","/final/admin/EgDiscoveryPane.jsp?selectedNode=node16");

	out.println(rootJson.toString());


%>