<%@ include file="../../EgTrackerAJSON.jsp"%>

<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
/*
*	This page helps to load the data for Storage Platform node in Discovery tree.
*	ini File : eg_services.ini, subject : [EMC_XtremIO_4x]
*/
%>

<%

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();

	String storagePlatform = "EMC_XtremIO_4x";

	IniFile services = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	String[] xmsComps = services.getVariables(storagePlatform);

	String from = request.getParameter("from");


	JSONArray mComboArray = new JSONArray();
	
	JSONObject mJson = new JSONObject();
	mJson.put("displayField",_mapping.getTextDescription("admin.discovery.View configured XMS"));
	mJson.put("valueField","VIEW");
	mComboArray.add(mJson);

	mJson.put("displayField",_mapping.getTextDescription("admin.discovery.Add new XMS"));
	mJson.put("valueField","ADD");
	mComboArray.add(mJson);

	mJson.put("displayField",_mapping.getTextDescription("admin.discovery.Modify configured XMS"));
	mJson.put("valueField","MODIFY");
	mComboArray.add(mJson);

	mJson.put("displayField",_mapping.getTextDescription("admin.discovery.Delete configured XMS"));
	mJson.put("valueField","DELETE");
	mComboArray.add(mJson);

	rootJson.put("mComboArray",mComboArray);

	JSONArray mComboCatArray = new JSONArray();
	JSONObject mCatJson = new JSONObject();
	mCatJson.put("displayField","EMC XtremIO 4x");
	mCatJson.put("valueField","emc_xtremio");
	mComboCatArray.add(mCatJson);
	rootJson.put("mComboCatArray",mComboCatArray);

	rootJson.put("emptyMessage",_mapping.getTextDescription("admin.discovery.No EMC XtremIO Clusters are available currently"));

	if(from != null && (from.equals("viewStoragePlatform") || from.equals("delStoragePlatform")))
	{		
		JSONObject columns = new JSONObject();		
		columns.put("IP/Host",_mapping.getTextDescription("admin.discovery.IP/Host"));
		columns.put("SSL",_mapping.getTextDescription("admin.discovery.SSL"));
		columns.put("Discovery Enabled",_mapping.getTextDescription("admin.discovery.Discovery Enabled"));
		columns.put("User",_mapping.getTextDescription("admin.discovery.User"));		
		if (from.equalsIgnoreCase("delStoragePlatform"))
		{
			columns.put("delOption","");
		}		
		if(xmsComps != null && xmsComps.length > 0)
		{
			JSONArray gridArray = new JSONArray();
			for(int i = 0; i < xmsComps.length; i++)
			{
				String ip = xmsComps[i];
				String value = services.getValue(storagePlatform,ip);

				StringTokenizer st = new StringTokenizer(value,"#");
				int counts = st.countTokens();
				if(counts == 4)
				{
					String ssl = st.nextToken();
					String user = st.nextToken();
					String pwd = st.nextToken();
					String discover = st.nextToken();

					if(ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))
						ssl = "Yes";
					else
						ssl = "No";

					if(discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))
						discover = "Yes";
					else
						discover = "No";

					JSONObject json = new JSONObject();

					json.put("IP/Host",ip);
					json.put("SSL",ssl);
					json.put("Discovery Enabled",discover);
					json.put("User",user);
					if (from.equalsIgnoreCase("delStoragePlatform"))
					{
						json.put("delOption",ip);
					}
					gridArray.add(json);
				}
			}
			rootJson.put("gridArray",gridArray);
			rootJson.put("columns",columns);
			rootJson.put("gridTitle",_mapping.getTextDescription("admin.discovery.XMS Preferences"));
		}
	}
	else if(from != null && from.equals("getAllStoragePlatforms"))
	{
		JSONArray comboArray = new JSONArray();

		JSONObject json = new JSONObject();
		json.put("displayField","Choose a EMC XtremIO Cluster");
		json.put("valueField","-1");
		comboArray.add(json);

		if(xmsComps != null && xmsComps.length > 0)
		{
			for(int i = 0; i < xmsComps.length; i++)
			{
				String ip = xmsComps[i];
				json = new JSONObject();
				json.put("displayField",ip);
				json.put("valueField",ip);
				comboArray.add(json);
			}
		}
		rootJson.put("comboArray",comboArray);
	}
	else if(from != null && from.equals("getStoragePlatformDetails"))
	{
		String ip = request.getParameter("xms");
		String value = services.getValue(storagePlatform,ip);
		if(ip != null && value != null)
		{
			StringTokenizer st = new StringTokenizer(value,"#");
			int counts = st.countTokens();
			if(counts == 4)
			{
				String ssl = st.nextToken();
				String user = st.nextToken();
				String pwd = st.nextToken();
				String discover = st.nextToken();

				if(ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))
				{
					ssl = "Yes";
				}
				else
				{
					ssl = "No";
				}

				if(discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))
				{
					discover = "Yes";
				}
				else
				{
					discover = "No";
				}
				pwd = EgCrypt.decrypt(pwd);

				JSONObject json = new JSONObject();
				json.put("ssl",ssl);
				json.put("user",user);
				json.put("pwd",pwd);
				json.put("discover",discover);
				rootJson.put("json",json);
			}
		}
	}

	session.setAttribute("adminLastAccessedURL","/final/admin/EgDiscoveryPane.jsp?selectedNode=node11");

	out.println(rootJson.toString());


%>