<!DOCTYPE html>

<%@ include file = "EgTrackerA.jsp" %>

<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import ="com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "net.sf.json.JSONArray"%>
<%@ page import = "net.sf.json.JSONObject"%>

<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	boolean isWindowsOS=false;
	boolean isDouble = EgDbInfo.doubleByteEnabled;
	JSONArray resultAgentsArr = new JSONArray();
	JSONObject resultAgentObj = new JSONObject();


	EgSpecsInfo spec = new EgSpecsInfo("manager");
	String egServer = spec.getEGServer();
	if (!StringUtils.isNull(egServer))
	{
		resultAgentObj.put("displayField",egServer+" (Default)");
		resultAgentObj.put("valueField",egServer);
		resultAgentsArr.add(resultAgentObj);
	}

	String iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/"; 
	String extAgentConfig = "eg_external.ini"; 
	IniFile extAgentConfigIni = new IniFile(iniFile_dir + extAgentConfig);  
	Object [] extAgentKey = extAgentConfigIni.getVariables("Eg_External_Agents");

	if(extAgentKey != null)
	{
		List extAgtsList = new ArrayList(Arrays.asList(extAgentKey));
		extAgtsList.remove(egServer);

		if (extAgtsList != null)
		{
			for(int i=0; i<extAgtsList.size(); i++)
			{
				resultAgentObj = new JSONObject();

				String strKey = (String) extAgtsList.get(i);
				String extAgent=extAgentConfigIni.getValue("Eg_External_Agents",strKey); 
				StringTokenizer st=new StringTokenizer(extAgent,",");
				String ipAddr=st.nextToken();
				String nickVal=st.nextToken();

				resultAgentObj.put("displayField",nickVal);
				resultAgentObj.put("valueField",ipAddr);
				resultAgentsArr.add(resultAgentObj);
			}
		}
	}
	
%>

<html>
<head>
	<meta charset="utf-8">

	<egui:skin ui="admin"/>

	<title>SNMP UTILITY</title>

	<script language="JavaScript" src="eg_scripts/validate.js"></script>
	<script language="JavaScript" src="eg_scripts/eg_testparamsvalidate.js"></script>
	<script language="JavaScript" src="../scripts/utilities/EncodeDecodeParams.js"></script>
	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<script language="JavaScript1.2">

		var csrfToken = '<%=strCsrfToken%>';
		var PageTitle = '<egui:intnl text="admin.title.SNMP UTILITY"/>';
		var pageName = '<egui:intnl text="admin.title.SNMP UTILITY"/>';
		var PageDesc = '<egui:intnl text="This page enables the administrator to execute SNMP walk/Subtree command"/>';
		var showFromRawData = JSON.parse('<%=resultAgentsArr%>'); 

		var screenLabelMsg1 = '<egui:intnl text="admin.snmp.Host IP"/>';
		var screenLabelMsg2 = '<egui:intnl text="admin.snmp.SNMP port"/>';
		var screenLabelMsg3 = '<egui:intnl text="admin.snmp.SNMP version"/>';
		var screenLabelMsg4 = '<egui:intnl text="admin.snmp.SNMP community"/>';
		var screenLabelMsg5 = '<egui:intnl text="admin.snmp.Context"/>';
		var screenLabelMsg6 = '<egui:intnl text="admin.snmp.Username"/>';
		var screenLabelMsg7 = '<egui:intnl text="admin.snmp.Auth password"/>';
		var screenLabelMsg8 = '<egui:intnl text="admin.Confirm auth password"/>';
		var screenLabelMsg9 = '<egui:intnl text="admin.Auth type"/>';
		var screenLabelMsg10 = '<egui:intnl text="admin.Encryption enabled"/>';
		var screenLabelMsg11 = '<egui:intnl text="admin.Encryption type"/>';
		var screenLabelMsg12 = '<egui:intnl text="admin.Encryption password"/>';
		var screenLabelMsg13 = '<egui:intnl text="admin.Confirm encryption password"/>';
		var screenLabelMsg14= '<egui:intnl text="admin.snmp.Data over TCP"/>';
		var screenLabelMsg15= '<egui:intnl text="admin.snmp.OID"/>';
		var screenLabelMsg16= '<egui:intnl text="admin.snmp.External agent"/>';
		var screenLabelMsg18= '<egui:intnl text="admin.snmp.Timeout"/>';
		var screenLabelMsg19= '<egui:intnl text="admin.snmp.Get Subtree"/>';
		var screenLabelMsg20= '<egui:intnl text="admin.snmp.SNMP Walk"/>';
		var screenLabelMsg21= '<egui:intnl text="admin.snmp.SNMP Parameters"/>';
		var screenLabelMsg22= '<egui:intnl text="admin.snmp.Get Subtree Output"/>';
		var screenLabelMsg23= '<egui:intnl text="admin.snmp.SNMP walk output"/>';

		var alertMsg01 = '<egui:intnl text="admin.common.File name is not allowed in DBL(Chinese,Korean,Japanese)"/>';
		var alertMsg02 = '<egui:intnl text="admin.common.Please choose the file by clicking the browse button"/>';
		var alertMsg03 = '<egui:intnl text="admin.ic.The selected file already exist"/>'+'. '+'<egui:intnl text="admin.ic.Do you want to replace the file?"/>';
		var alertMsg04 = '<egui:intnl text="admin.common.Upload MIB file extensions should be either *txt or *mib"/>';
		var alertMsg05 = '<egui:intnl text="admin.common.Please enter valid Host IP"/>';
		var alertMsg06 = '<egui:intnl text="admin.common.Please enter SNMP port"/>';
		var alertMsg07 = '<egui:intnl text="admin.common.Please enter SNMP community string"/>';
		var alertMsg08 = '<egui:intnl text="admin.common.Please enter context value"/>';
		var alertMsg09 = '<egui:intnl text="admin.common.Please enter valid username"/>';
		var alertMsg10 = '<egui:intnl text="admin.common.Please enter the auth password"/>';
		var alertMsg11 = '<egui:intnl text="admin.common.Please enter the confirm auth password"/>';
		var alertMsg12 = '<egui:intnl text="admin.common.Passwords do not match"/>';
		var alertMsg13 = '<egui:intnl text="admin.common.Please enter valid OID"/>';
		var alertMsg14 = '<egui:intnl text="admin.common.Please enter the encryption password"/>';
		var alertMsg15 = '<egui:intnl text="admin.common.Please enter the confirm encryption password"/>';
		var alertMsg16 = '<egui:intnl text="admin.common.Request has been processed successfully"/>';
		var alertMsg17 = '<egui:intnl text="admin.common.Not able to upload the selected MIB file"/>'; 
		var alertMsg18 = '<egui:intnl text="admin.common.Please try again"/>';
		var titleMsg ='<egui:intnl text="admin.common.Files to be uploaded"/>';

		var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>.';
		var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>.';
		var errorTitle = '<egui:intnl text="admin.user.Error"/>';

		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut +'.',
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						console.log(response.responseText);
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage +'.',
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});

	</script>

	<!-- Application folder -->
	<script type="text/javascript" src="SnmpGetSubtree/app/app.js"></script>
</head>

<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</body>

</html>

<%
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgSnmpGetSubtree.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgSnmpGetSubtree.jsp");
	}
%>



