Ext.define('EgSpecificReports.controller.Main',{
	extend:'Ext.app.Controller',
	views:['SpecificReports','SpecificReportsConfiguration'],
	refs:[
		{selector:'specificreports', ref:'specificreports'},
		{selector:'specificreportsconfiguration', ref:'specificreportsconfiguration'}
	],

	init: function()
	{
		thisController = this;
		this.control({
			'specificreports':
			{
				'afterrender': this.afterMainRender
			},
			'specificreports combo[id="categoryType"]':
			{
				'select': this.categoryChange
			},
			'specificreports combo[id="reportTypeInView"]':
			{
				'select': this.reportChange
			},
			'specificreports combo[id="selectedCompType"]':
			{
				'select': this.compTypeChange
			},
			'specificreports combo[id="sitesInView"]':
			{
				'select': this.siteChange
			},
			'specificreports combo[id="selectedComp"]':
			{
				'select': this.compChange
			},
			'specificreports button[id="addToSummary"]':
			{
				'click': this.addToSummary
			},
			'specificreports button[id="addNew"]':
			{
				'click': this.addNew
			},
			'specificreports actioncolumn[id="deleteInView"]':
			{
				'click': this.deleteTest
			},
			'specificreports actioncolumn[id="updateInView"]':
			{
				'click': this.updateInView
			},
			'specificreports grid[id="mainGrid"]':
			{
				//'itemmouseenter': this.onGridEnter,
				//'itemmouseleave': this.onGridLeave
			},

		//Code added to get events for add page in specific reports
			'specificreportsconfiguration combo[id="category"]':
			{
				'select': this.categoryInAddChange
			},
			'specificreportsconfiguration combo[id="reportType"]':
			{
				'select': this.reportInAddChange
			},
			'specificreportsconfiguration combo[id="servers"]':
			{
				'select': this.compTypeInAddChange
			},
			'specificreportsconfiguration combo[id="component"]':
			{
				'select': this.compInAddChange
			},
			'specificreportsconfiguration combo[id="sites"]':
			{
				'select': this.siteInAddChange
			},
			'specificreportsconfiguration combo[id="tests"]':
			{
				'select': this.testsInAddChange
			},
			'specificreportsconfiguration button[id="addBtn"]':
			{
				'click': this.addMeasures
			},
			'specificreportsconfiguration button[id="backbutton"]':
			{
				'click': this.goToView
			},
		});
	},

	//Method to view the configured tests and measures in the specific report
	afterMainRender: function()
	{
		var viewStoreObj = Ext.getCmp('mainGrid');
		var compObj = Ext.getCmp('selectedComp');
		var serverTypeObj = Ext.getCmp('selectedCompType');
		var siteTypeObj = Ext.getCmp('sitesInView');

		if (Ext.isEmpty(catTypeFromSession) || catTypeFromSession == 'null' )
		{
			Ext.getCmp('categoryType').setValue('Choose category type');
		}
		else
		{
			Ext.getCmp('categoryType').setValue(catTypeFromSession);
		}

		if (catTypeFromSession == 'Application')
		{
			serverTypeObj.show();
			compObj.show();
		}
		else
		{
			serverTypeObj.hide();
		}

		if (catTypeFromSession == 'Site')
		{
			siteTypeObj.show();
			compObj.hide();
		}
		else
		{
			serverTypeObj.hide();
			compObj.show();
		}

		if (!Ext.isEmpty(graphTypeFromSession) && graphTypeFromSession != 'null')
		{
			Ext.getCmp('reportTypeInView').setValue(graphTypeFromSession);
		}
		else
		{
			Ext.getCmp('reportTypeInView').setValue('Choose report type');
		}

		if (!Ext.isEmpty(serverTypeFromSession) && serverTypeFromSession != 'null')
		{
			Ext.getCmp('selectedCompType').setValue(serverTypeFromSession);
		}
		else
		{
			Ext.getCmp('selectedCompType').setValue('Select the component type');
		}

		if (!Ext.isEmpty(comNameFromSession) && comNameFromSession != 'null')
		{
			Ext.getCmp('selectedComp').setValue(comNameFromSession);
		}
		else
		{
			Ext.getCmp('selectedComp').setValue('Select the component');
		}

		if (!Ext.isEmpty(siteTypeFromSession) && siteTypeFromSession != 'null')
		{
			Ext.getCmp('sitesInView').setValue(siteTypeFromSession);
		}
		else
		{
			Ext.getCmp('sitesInView').setValue('Select the Site');
		}

		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var serverTypeDisplay = Ext.getCmp('selectedCompType').getDisplayValue();
		var component = Ext.getCmp('selectedComp').getValue();
		var comName = Ext.getCmp('selectedComp').getDisplayValue();
		var sites = Ext.getCmp('sitesInView').getValue();
		var secType = 'Specific';

		if (graphType == 'Measure')
		{
			Ext.getCmp('addToSummary').setDisabled(false);
		}
		if (graphType == 'Summary')
		{
			Ext.getCmp('addToSummary').setDisabled(true);
		}

		viewStoreObj.setTitle(reportsForGridTitle);

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType)+"&siteType="+sites+"&servers="+encodeURIComponent(serverType)+"&component="+encodeURIComponent(component)+"&comName="+encodeURIComponent(comName)+"&comType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var viewArray = jsonData.summaryArrayJson;
					var viewArrayLength = jsonData.summaryArrayJson.length;

					viewStoreObj.getStore().loadRawData(viewArray);

					if (!Ext.isEmpty(serverTypeObj))
					{
						serverTypeObj.getStore().loadRawData(jsonData.serverCompTypeArrayJson);
						serverTypeObj.setValue(serverTypeDisplay);
					}
				}
			}
		);
	},

	categoryChange: function()
	{
		var catType = Ext.getCmp('categoryType').getValue();
		var compObj = Ext.getCmp('selectedComp');
		var serverTypeObj = Ext.getCmp('selectedCompType');
		var sitesObj = Ext.getCmp('sitesInView');

		compObj.show();
		if (catType == 'Application')
		{
			serverTypeObj.show();
			compObj.show();
		}
		else
		{
			serverTypeObj.hide();
		}

		if (catType == 'Site')
		{
			sitesObj.show();
			compObj.hide();
			serverTypeObj.hide();
		}
		else
		{
			sitesObj.hide();
		}

		Ext.getCmp('reportTypeInView').setValue('Choose report type');
		Ext.getCmp('selectedComp').setValue('Select the component');

		if (catType == 'Application')
		{
			Ext.getCmp('selectedCompType').setValue('Select the component type');
		}

		if (catType == 'Site')
		{
			Ext.getCmp('sitesInView').setValue('Select the site');
		}

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=main&catType="+catType;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					compObj.getStore().loadRawData(jsonData.CompTypeArrayJson);
					serverTypeObj.getStore().loadRawData(jsonData.serverCompTypeArrayJson);
					sitesObj.getStore().loadRawData(jsonData.siteCompTypeArrayJson);

					if (catType == 'Choose category type')
					{
						gridTitle = reportsForGridTitle;
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Network')
					{
						gridTitle = 'Network Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'System')
					{
						gridTitle = 'System Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Application')
					{
						gridTitle = 'Application Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Site')
					{
						gridTitle = 'Site Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					Ext.getCmp('mainGrid').getStore().removeAll();
				}
			}
		);
	},

	reportChange: function()
	{
		var gridTitle = '';
		var catType = Ext.getCmp('categoryType').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();

		Ext.getCmp('selectedComp').setValue('Select the component');

		if (Ext.isEmpty(catType) || catType == 'Choose category type')
		{
			Ext.Msg.show({
				title: reportsTitle,
				msg: alertforNoCategory,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			Ext.getCmp('reportTypeInView').setValue('Choose report type');
		}

		if (graphType == 'Measure')
		{
			Ext.getCmp('addToSummary').setDisabled(false);
		}
		else
		{
			Ext.getCmp('addToSummary').setDisabled(true);
		}

		if (catType == 'Choose category type')
		{
			gridTitle = reportsForGridTitle;
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'Network')
		{
			gridTitle = 'Network Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'System')
		{
			gridTitle = 'System Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'Application')
		{
			gridTitle = 'Application Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'Site')
		{
			gridTitle = 'Site Reports';
			Ext.getCmp('sitesInView').setValue('Select the site');
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		Ext.getCmp('mainGrid').getStore().removeAll();
	},

	compTypeChange: function()
	{
		var catType = Ext.getCmp('categoryType').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var secType = 'Specific';

		var componentObj = Ext.getCmp('selectedComp');
		componentObj.setValue('Select the component');

		if (Ext.isEmpty(graphType) || graphType == 'Choose report type')
		{
			Ext.Msg.show({
				title: reportsTitle,
				msg: alertforNoType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			Ext.getCmp('selectedCompType').setValue('Select the component type');
		}

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					componentObj.getStore().loadRawData(jsonData.CompTypeArrayJson);

					var gridTitle = jsonData.summaryJson.title;
					if (catType == 'Application')
					{
						gridTitle = 'Application Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}
					else
					{
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					Ext.getCmp('mainGrid').getStore().removeAll();
				}
			}
		);
	},

	compChange: function(Obj)
	{
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var comType = Ext.getCmp('selectedComp').getValue();
		var comName = Ext.getCmp('selectedComp').getDisplayValue();

		var secType = 'Specific';

		var viewStoreObj = Ext.getCmp('mainGrid');

		if (Ext.isEmpty(graphType) || graphType == 'Choose report type')
		{
			Ext.Msg.show({
				title: reportsTitle,
				msg: alertforNoType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			Ext.getCmp('selectedComp').setValue('Select the component');
		}

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var viewArray = jsonData.summaryArrayJson;
					var viewArrayLength = jsonData.summaryArrayJson.length;

					if (catType == 'Network' && comName == 'Select the component')
					{
						gridTitle = 'Network Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}
					else if (catType == 'System' && comName == 'Select the component')
					{
						gridTitle = 'System Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}
					else if (catType == 'Application' && comName == 'Select the component')
					{
						gridTitle = 'Application Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}
					else if (catType == 'Site' && comName == 'Select the component')
					{
						gridTitle = 'Site Reports';
						Ext.getCmp('sitesInView').setValue('Select the site');
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Network' && (Ext.isEmpty(viewArray) || viewArray.length == 0))
					{
						gridTitle = 'Network Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}
					else if (catType == 'System' && (Ext.isEmpty(viewArray) || viewArray.length == 0))
					{
						gridTitle = 'System Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}
					else if (catType == 'Application' && (Ext.isEmpty(viewArray) || viewArray.length == 0))
					{
						gridTitle = 'Application Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}
					else if (catType == 'Site' && (Ext.isEmpty(viewArray) || viewArray.length == 0))
					{
						gridTitle = 'Site Reports';
						//Ext.getCmp('sitesInView').setValue('Select the site');
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if ((!Ext.isEmpty(viewArray) || viewArray.length > 0))
					{
						var gridTitle = jsonData.summaryJson.title;
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					viewStoreObj.getStore().loadRawData(viewArray);

					if (comName == 'Select the component')
					{
						Ext.getCmp('mainGrid').getStore().removeAll();
					}
				}
			}
		);
	},

	siteChange: function()
	{
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var siteType = Ext.getCmp('sitesInView').getValue();
		var secType = 'Specific';

		var viewStoreObj = Ext.getCmp('mainGrid');

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&siteType="+siteType;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var viewArray = jsonData.summaryArrayJson;
					var viewArrayLength = jsonData.summaryArrayJson.length;

					viewStoreObj.getStore().loadRawData(viewArray);

					var gridTitle = jsonData.summaryJson.title;

					if (!Ext.isEmpty(gridTitle))
					{
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}
					else
					{
						gridTitle = 'Site Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}
				}
			}
		);
	},

	addToSummary: function()
	{
		var catType = Ext.getCmp('categoryType').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var graphTypeObj = Ext.getCmp('reportTypeInView');
		var serverType = Ext.getCmp('selectedCompType').getValue();

		var component = Ext.getCmp('selectedComp').getValue();
		var comName = Ext.getCmp('selectedComp').getDisplayValue();
		var sites = '';

		if (catType == 'Site')
		{
			sites = Ext.getCmp('sitesInView').getValue();
		}

		var secType = 'Specific';

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(component)+"&comName="+encodeURIComponent(comName)+"&siteType="+sites;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var lenForApplySummary = jsonData.applyToSummaryJson.length;

					for (var i=0; i<lenForApplySummary; i=i+2)
					{
						var variable = jsonData.applyToSummaryJson[i];

						var urlForSummary = 
						"/final/admin/EgSpecificReports/data/EgspecificreportsJSONp.jsp?mode=main&varMeas="+variable+"&applytosum=true"+"&catType="+catType+"&reportType="+graphType+"&secType=Specific&servers="+encodeURIComponent(serverType)+"&sites="+sites+"&comType="+encodeURIComponent(component)+"&comName="+encodeURIComponent(comName)+"&siteType="+sites;
						
						Ext.Ajax.request(
						{
							url : urlForSummary,
							scope:this,
							method : 'POST',
							success: function(response){
								Ext.getCmp('addToSummary').setDisabled(true);
								graphTypeObj.setValue('Summary');

								var catTypeForTitle = Ext.getCmp('categoryType').getValue();
								var graphTypeForTitle = 'Summary';
								var serverTypeForTitle = Ext.getCmp('selectedCompType').getValue();
								var secType = 'Specific';

								var urlForTitle = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=main&catType="+catTypeForTitle+"&graphType="+graphTypeForTitle+"&secType="+secType+"&serverType="+encodeURIComponent(serverTypeForTitle)+"&comType="+encodeURIComponent(component)+"&comName="+encodeURIComponent(comName)+"&siteType="+sites;

								Ext.Ajax.request(
								{
									url : urlForTitle,
									scope:this,
									method : 'POST',
									success: function(response){
										var jsonText = response.responseText;
										var jsonData = Ext.decode(jsonText);
										var gridTitle = jsonData.summaryJson.title;

										Ext.getCmp('mainGrid').setTitle(gridTitle);
									}
								});
							}
						});
					}
				}
			}
		);
	},

	addNew: function()
	{
		var mainViewId = Ext.getCmp('mainView');
		var categoryInView = Ext.getCmp('categoryType').getValue();
		var reportTypeInView = Ext.getCmp('reportTypeInView').getValue();
		var componentInView = Ext.getCmp('selectedComp').getValue();
		var compNameInView = Ext.getCmp('selectedComp').getDisplayValue();
		var compTypeInView = Ext.getCmp('selectedCompType').getDisplayValue();

		// pass value of combo field for component type in application category 
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var siteInView = Ext.getCmp('sitesInView').getValue();
		var secType = "Specific";
		isItemUpdated = false;

		mainViewId.removeAll();

		mainViewId.add({xtype: 'specificreportsconfiguration' });

		var testsObj = Ext.getCmp('tests');

		Ext.getCmp('category').setValue('Choose category type');
		Ext.getCmp('reportType').setValue('Choose report type');
		Ext.getCmp('component').setValue('Select the component')
		Ext.getCmp('tests').setValue('Select the test');
		if (catType == 'Site')
		{
			Ext.getCmp('sites').setValue('Select the site');
		}

		var catType = Ext.getCmp('category').getValue();
		var serverTypeObj = Ext.getCmp('servers');

		Ext.getCmp('category').setValue(categoryInView);
		Ext.getCmp('reportType').setValue(reportTypeInView);

		var categoryObj = Ext.getCmp('category');
		var reportTypeObj = Ext.getCmp('reportType');
		var componentObj = Ext.getCmp('component');

		var serverTypeObj = Ext.getCmp('servers');
		var siteObj = Ext.getCmp('sites');

		if (categoryInView == 'Application')
		{
			serverTypeObj.show();
		}
		else if (categoryInView == 'Site')
		{
			serverTypeObj.hide();
			componentObj.hide();
			siteObj.show();
		}
		else
		{
			serverTypeObj.hide();
			siteObj.hide();
		}

		categoryObj.setValue(categoryInView);
		reportTypeObj.setValue(reportTypeInView);
		componentObj.setValue(compNameInView);
		serverTypeObj.setValue(serverType);

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=addnew&catType="+categoryInView+"&graphType="+reportTypeInView+"&secType="+secType+"&comType="+encodeURIComponent(componentInView)+"&comName="+encodeURIComponent(compNameInView)+"&serverType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					componentObj.getStore().loadRawData(jsonData.CompTypeArrayJson);
					componentObj.setValue(compNameInView,true);

					serverTypeObj.getStore().loadRawData(jsonData.serverCompTypeArrayJson);
					serverTypeObj.setValue(serverType);

					if (categoryInView == 'Site')
					{
						siteObj.getStore().loadRawData(jsonData.siteCompTypeArrayJson);
						siteObj.setValue(siteInView);
					}

					if (categoryInView == 'Application')
					{
						testsArray = jsonData.serverTestsArrayJson;
						testsObj.getStore().loadRawData(testsArray);
					}
					else if (categoryInView == 'Site')
					{
						testsArray = jsonData.siteTestsArrayJson;
						testsObj.getStore().loadRawData(testsArray);
					}
					else
					{
						testsArray = jsonData.testsArrayJson;
						testsObj.getStore().loadRawData(testsArray);
					}

					Ext.getCmp('itemselectTests').getStore().removeAll();
					Ext.getCmp('itemselectTests').setValue(' ');
				}
			}
		);
	},

	onGridEnter: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
			Ext.each(icons, function(icon){
				Ext.get(icon).removeCls('x-hidden');
		});
	},

	onGridLeave: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		});
	},

	categoryInAddChange: function()
	{
		var catType = Ext.getCmp('category').getValue();

		var serverTypeObj = Ext.getCmp('servers');
		var siteObj = Ext.getCmp('sites');
		var componentObj = Ext.getCmp('component');

		if (catType == 'Application')
		{
			serverTypeObj.show();
			componentObj.show();
			siteObj.hide();
		}
		else if (catType == 'Site')
		{
			serverTypeObj.hide();
			componentObj.hide();
			siteObj.show();
		}
		else
		{
			serverTypeObj.hide();
			componentObj.show();
			siteObj.hide();
		}

		if (catType == 'Site')
		{
			Ext.getCmp('sites').setValue('Select the site');
		}

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=addnew&catType="+catType;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					if (catType == 'Application')
					{
						if (!Ext.isEmpty(serverTypeObj) && !Ext.isEmpty(jsonData.serverCompTypeArrayJson) && jsonData.serverCompTypeArrayJson.length > 0)
						{
							serverTypeObj.getStore().loadRawData(jsonData.serverCompTypeArrayJson);
							serverTypeObj.setValue(jsonData.serverCompTypeArrayJson[0].displayField);
						}

						Ext.getCmp('reportType').setValue('Choose report type');
						Ext.getCmp('servers').setValue('Select the component type');
						Ext.getCmp('component').setValue('Select the component');
						Ext.getCmp('tests').getStore().removeAll();
						Ext.getCmp('tests').setValue('Select the test');
					}
					else if (catType == 'Site')
					{
						if (!Ext.isEmpty(siteObj) && !Ext.isEmpty(jsonData.siteCompTypeArrayJson) && jsonData.siteCompTypeArrayJson.length > 0)
						{
							siteObj.getStore().loadRawData(jsonData.siteCompTypeArrayJson);
							siteObj.setValue(jsonData.siteCompTypeArrayJson[0].displayField);
						}

						Ext.getCmp('reportType').setValue('Choose report type');
						Ext.getCmp('sites').setValue('Select the site');
						Ext.getCmp('tests').getStore().removeAll();
						Ext.getCmp('tests').setValue('Select the test');
					}
					else
					{
						if (!Ext.isEmpty(componentObj) && !Ext.isEmpty(jsonData.CompTypeArrayJson) && jsonData.CompTypeArrayJson.length > 0)
						{
							componentObj.getStore().loadRawData(jsonData.CompTypeArrayJson);
							componentObj.setValue('Select the component');
						}
						else
						{
							componentObj.getStore().removeAll();
							componentObj.setValue('Select the component');
						}

						Ext.getCmp('reportType').setValue('Choose report type');
						Ext.getCmp('tests').getStore().removeAll();
						Ext.getCmp('tests').setValue('Select the test');
					}

					Ext.getCmp('itemselectTests').getStore().removeAll();
					Ext.getCmp('itemselectTests').setValue('');
				}
			}
		);
	},
	
	compTypeInAddChange: function()
	{
		var catType = Ext.getCmp('category').getValue();
		var reportType = Ext.getCmp('reportType').getValue();
		var serverType = Ext.getCmp('servers').getValue();
		var secType = "Specific";

		var componentObj = Ext.getCmp('component');
		var itemSelectObj = Ext.getCmp('itemselectTests');

		itemSelectObj.fromField.getStore().removeAll();
		itemSelectObj.toField.getStore().removeAll();

		Ext.getCmp('component').setValue('Select the component');
		Ext.getCmp('tests').setValue('Select the test');

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=addnew&catType="+catType+"&graphType="+reportType+"&serverType="+encodeURIComponent(serverType)+"&secType="+secType;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					componentObj.getStore().loadRawData(jsonData.CompTypeArrayJson);
				}
			}
		);
	},

	compInAddChange: function()
	{
		var catType = Ext.getCmp('category').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var comType = Ext.getCmp('component').getValue();
		var comName = Ext.getCmp('component').getDisplayValue();
		var serverType = Ext.getCmp('servers').getValue();
		var secType = 'Specific';

		var testsObj = Ext.getCmp('tests');
		var itemSelectObj = Ext.getCmp('itemselectTests');

		Ext.getCmp('tests').setValue('Select the test');

		if (Ext.isEmpty(catType) || catType == 'Choose category type')
		{
			Ext.Msg.show({
				title: configTitle,
				msg: alertforNoCategory,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		if (Ext.isEmpty(graphType) || graphType == 'Choose report type')
		{
			Ext.Msg.show({
				title: configTitle,
				msg: alertforNoType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		itemSelectObj.fromField.getStore().removeAll();
		itemSelectObj.toField.getStore().removeAll();

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=addnew&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName)+"&serverType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					if (catType == 'Application')
					{
						testsObj.getStore().loadRawData(jsonData.serverTestsArrayJson);
					}
					else if (catType == 'Site')
					{
						testsObj.getStore().loadRawData(jsonData.siteTestsArrayJson);
					}
					else
					{
						testsObj.getStore().loadRawData(jsonData.testsArrayJson);
					}
				}
			}
		);
	},

	reportInAddChange: function()
	{
		var catType = Ext.getCmp('category').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var compObj = Ext.getCmp('component');
		var secType = 'Specific';

		if (catType == 'Application')
		{
			Ext.getCmp('servers').setValue('Select the component type');
		}

		Ext.getCmp('component').setValue('Select the component');

		if (catType == 'Site')
		{
			Ext.getCmp('sites').setValue('Select the site');
		}

		var testsObj = Ext.getCmp('tests');

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=addnew&catType="+catType+"&graphType="+graphType+"&secType="+secType;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					compObj.getStore().loadRawData(jsonData.CompTypeArrayJson);
					testsObj.getStore().loadRawData(jsonData.testsArrayJson);
				}
			}
		);
	},

	siteInAddChange: function()
	{
		var catType = Ext.getCmp('category').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var siteType = Ext.getCmp('sites').getValue();
		var secType = 'Specific';

		var testsObj = Ext.getCmp('tests');

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=addnew&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&siteType="+encodeURIComponent(siteType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					testsObj.getStore().loadRawData(jsonData.siteTestsArrayJson);
				}
			}
		);
	},

	testsInAddChange: function()
	{
		var catType = Ext.getCmp('category').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var serverType = Ext.getCmp('servers').getValue();
		var siteType = Ext.getCmp('sites').getValue();
		var comType = Ext.getCmp('component').getValue();
		var comName = Ext.getCmp('component').getDisplayValue();
		var secType = 'Specific';

		var tests = Ext.getCmp('tests').getValue();
		var itemSelectObj = Ext.getCmp('itemselectTests');

		itemSelectObj.toField.store.removeAll();
		itemSelectObj.fromField.store.removeAll();

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=addnew&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName)+"&tname="+tests+"&serverType="+encodeURIComponent(serverType)+"&siteType="+encodeURIComponent(siteType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var allMeasures = jsonData.allRealMeasuresArrayJson;
					var assocMeasures = jsonData.assocRealMeasuresArrayJson;
					var disAssociatedMeasures = jsonData.disAssocRealMeasuresArrayJson;

					if (tests == 'Select the test')
					{
						var aStore = new Ext.data.Store({
							fields: ['displayField','valueField'],
						});
						aStore.add({'displayField': ' ', 'valueField': ' '});
						itemSelectObj.bindStore(aStore);
						itemSelectObj.setValue(' ');
					}
					else
					{
						var aStore = new Ext.data.Store({
							fields: ['displayField','valueField'],
						});
						for (var i=0; i<allMeasures.length; i++)
						{
							var aMeasureDisplayField = allMeasures[i].displayField;
							var aMeasureValueField = allMeasures[i].valueField;
							aStore.add({'displayField': aMeasureDisplayField, 'valueField': aMeasureValueField});
							itemSelectObj.bindStore(aStore);
						}
						itemSelectObj.setValue(disAssociatedMeasures);
					}
				}
			}
		);
	},

	addMeasures: function()
	{
		var secType = "Specific";
		var deleteTest = "";
		var hassociated = "";
		var hdisassociated = "";

		var valFlag = "true";

		var reportType = Ext.getCmp('reportType').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var catType = Ext.getCmp('category').getValue();
		var comType = Ext.getCmp('component').getValue();
		var comName = Ext.getCmp('component').getDisplayValue();
		var sites = Ext.getCmp('sites').getValue();

		if(Ext.isEmpty(catType) || catType == 'Choose category type')
		{
			valFlag = 'false';

			Ext.Msg.show({
				title: configTitle,
				msg: alertforNoCategory,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		var serverType = Ext.getCmp('servers').getValue();
		var testName = Ext.getCmp('tests').getValue();
		var tests = Ext.getCmp('tests').getValue();

		if (Ext.isEmpty(graphType) || graphType == 'Choose report type')
		{
			valFlag = 'false';

			Ext.Msg.show({
				title: configTitle,
				msg: alertforNoType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		if (Ext.isEmpty(testName) || testName == 'Select the test')
		{
			valFlag = 'false';

			Ext.Msg.show({
				title: configTitle,
				msg: alertforNoTest,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		if (catType == 'Application')
		{
			if (Ext.isEmpty(serverType) || serverType == 'Select the component')
			{
				valFlag = 'false';

				Ext.Msg.show({
					title: configTitle,
					msg: alertforNoComponent,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
		}

		if ( !isItemUpdated )
		{
			Ext.Msg.show({
				title: configTitle,
				msg: alertForMeasureSelection,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			valFlag = 'false';
		}

		var disassociatedMeasures = Ext.getCmp('itemselectTests').getValue();

		var lenDisAssoc;
		if (!Ext.isEmpty(disassociatedMeasures))
		{
			lenDisAssoc = disassociatedMeasures.length;
		}

		var disassociatedMeasuresArray = new Array();
		var associatedMeasuresArray = new Array();
		var allValueArray = new Array();
		var i;

		for (var i=0;i<Ext.getCmp('itemselectTests').getStore().getCount();i++)
		{
			var allValue = Ext.getCmp('itemselectTests').getStore().getAt(i).get('valueField');
			allValueArray[i] = allValue;
		}

		for (i=0;i<lenDisAssoc; i++)
		{
			var adisAssocMeasure = disassociatedMeasures[i];
			disassociatedMeasuresArray[i] = adisAssocMeasure;
		}

		var k = 0;
		for (var i=0;i<Ext.getCmp('itemselectTests').getStore().getCount();i++)
		{
			var allValue = Ext.getCmp('itemselectTests').getStore().getAt(i).get('valueField');
			for (var j=0;j<disassociatedMeasures.length;j++)
			{
				var isData = false;
				if (allValue == disassociatedMeasures[j])
				{
					isData = true;
					break;
				}
			}
			if (!isData)
			{
				associatedMeasuresArray[associatedMeasuresArray.length]=allValue;
			}
		}

		if (valFlag == 'true')
		{
			var url = "/final/admin/EgSpecificReports/data/EgspecificreportsJSONp.jsp?mode=main&catType="+catType+"&secType="+secType+"&reportType="+reportType+"&serverType="+encodeURIComponent(serverType)+"&testName="+testName+"&tests="+tests+"&hassociatem="+associatedMeasuresArray+"&hdisassociatem="+disassociatedMeasuresArray+"&deleteTest="+deleteTest+"&hassociated="+hassociated+"&hdisassociated="+hdisassociated+"&servers="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName)+"&sites="+encodeURIComponent(sites);

			Ext.Ajax.request(
				{
					url : url,
					scope: this,
					method : 'POST',
					success: function(response){
						var mainViewId = Ext.getCmp('mainView');

						mainViewId.removeAll();
						mainViewId.add({xtype: 'specificreports' });

						var categoryInViewObj = Ext.getCmp('categoryType');
						var componentObj = Ext.getCmp('selectedComp');
						var reportTypeInViewObj = Ext.getCmp('reportTypeInView');
						var compTypeInViewObj = Ext.getCmp('selectedCompType');
						var siteInViewObj = Ext.getCmp('sitesInView');
						var serverTypeObj = Ext.getCmp('selectedCompType');

						var viewStoreObj = Ext.getCmp('mainGrid');

						var urlForView = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+reportType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(serverType)+"&comName="+encodeURIComponent(comName)+"&siteType="+encodeURIComponent(sites);

						Ext.Ajax.request(
							{
								url : urlForView,
								scope:this,
								method : 'POST',
								success: function(response){
									var jsonText = response.responseText;
									var jsonData = Ext.decode(jsonText);

									var viewArray = jsonData.summaryArrayJson;
									var viewArrayLength = jsonData.summaryArrayJson.length;

									viewStoreObj.getStore().loadRawData(viewArray);
									componentObj.getStore().loadRawData(jsonData.CompTypeArrayJson);
									serverTypeObj.getStore().loadRawData(jsonData.serverCompTypeArrayJson);

									if (catType == 'Application')
									{
										compTypeInViewObj.show();
										componentObj.setValue(comName,true);
										compTypeInViewObj.setValue(serverType);
									}
									else if (catType == 'Site')
									{
										compTypeInViewObj.hide();
										componentObj.hide();
										siteInViewObj.show();
										siteInViewObj.setValue(sites);
									}
									else
									{
										compTypeInViewObj.hide();
										siteInViewObj.hide();
										componentObj.setValue(comName,true);
									}

									categoryInViewObj.setValue(catType);
									reportTypeInViewObj.setValue(graphType);

									if (graphType == 'Measure')
									{
										Ext.getCmp('addToSummary').setDisabled(false);
									}
									else
									{
										Ext.getCmp('addToSummary').setDisabled(true);
									}

									var gridTitle = jsonData.summaryJson.title;
									Ext.getCmp('mainGrid').setTitle(gridTitle);
								}
							}
						);

					}
				}
			);
		}
	},

	goToView: function()
	{
		var mainViewId = Ext.getCmp('mainView');

		var graphTypeInAdd = Ext.getCmp('reportType').getValue();
		var catTypeInAdd = Ext.getCmp('category').getValue();
		var serverTypeInAdd = Ext.getCmp('servers').getValue();
		var siteTypeInAdd = Ext.getCmp('sites').getValue();
		var comTypeInAdd = Ext.getCmp('component').getValue();
		var comNameInAdd = Ext.getCmp('component').getDisplayValue();

		mainViewId.removeAll();

		mainViewId.add({xtype: 'specificreports' });

		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var comType = Ext.getCmp('selectedComp').getValue();
		var comName = Ext.getCmp('selectedComp').getDisplayValue();
		var secType = 'Specific';

		var graphTypeObj = Ext.getCmp('reportTypeInView');
		var catTypeObj = Ext.getCmp('categoryType');
		var serverTypeObj = Ext.getCmp('selectedCompType');
		var comTypeObj = Ext.getCmp('selectedComp');
		var comNameObj = Ext.getCmp('selectedComp');
		var sitesObj = Ext.getCmp('sitesInView');

		var siteValue = sitesObj.getValue();

		//code added for the view after back button
		if (graphTypeInAdd == 'Measure')
		{
			Ext.getCmp('addToSummary').setDisabled(false);
		}
		else
		{
			Ext.getCmp('addToSummary').setDisabled(true);
		}

		var viewStoreObj = Ext.getCmp('mainGrid');

		var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=main&catType="+catTypeInAdd+"&graphType="+graphTypeInAdd+"&secType="+secType+"&serverType="+encodeURIComponent(serverTypeInAdd)+"&comType="+encodeURIComponent(comTypeInAdd)+"&comName="+encodeURIComponent(comNameInAdd)+"&siteType="+encodeURIComponent(siteTypeInAdd);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var viewArray = jsonData.summaryArrayJson;
					var viewArrayLength = jsonData.summaryArrayJson.length;

					viewStoreObj.getStore().loadRawData(viewArray);

					comTypeObj.getStore().loadRawData(jsonData.CompTypeArrayJson);
					serverTypeObj.getStore().loadRawData(jsonData.serverCompTypeArrayJson);
					sitesObj.getStore().loadRawData(jsonData.siteCompTypeArrayJson);

					if (catTypeInAdd == 'Application')
					{
						Ext.getCmp('selectedCompType').show();
						comTypeObj.show();
					}
					else if (catTypeInAdd == 'Site')
					{
						sitesObj.show();
						comTypeObj.hide();
					}
					else
					{
						sitesObj.hide();
						serverTypeObj.hide();
						comTypeObj.show();
					}

					graphTypeObj.setValue(graphTypeInAdd);
					catTypeObj.setValue(catTypeInAdd);
					serverTypeObj.setValue(serverTypeInAdd);
					comTypeObj.setValue(comTypeInAdd);
					comNameObj.setValue(comNameInAdd, true);
					sitesObj.setValue(siteTypeInAdd);

					var gridTitle = jsonData.summaryJson.title;
					if (!Ext.isEmpty(gridTitle))
					{
						viewStoreObj.setTitle(gridTitle);
					}
					else
					{
						viewStoreObj.setTitle(reportsForGridTitle);
					}
				}
			}
		);
	},

	deleteTest: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var secType = "Specific";
		var deleteTest = "";
		var hassociated = "";
		var hdisassociated = "";
		var testValueName = '';
		var testName = '';
		var tests = '';

		var associatedMeasuresArray = new Array();
		var disassociatedMeasuresArray = new Array();
		var allValueArray = new Array();
		var deleteTest = 'yes';

		/* code added to get the selected test name */
		var viewStoreObj = Ext.getCmp('mainGrid');

		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);

		var displaytestName = record.get('Test');
		var displaytests = record.get('Test');

		associatedMeasuresArray = record.get('Measures');
		// End of code added 

		var catType = Ext.getCmp('categoryType').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();

		var reportType = Ext.getCmp('reportTypeInView').getValue();
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var comType = Ext.getCmp('selectedComp').getValue();
		var comName = Ext.getCmp('selectedComp').getDisplayValue();
		var siteType = Ext.getCmp('sitesInView').getValue();

		Ext.MessageBox.confirm(reportsTitle,alertForDeleteConfirmation, function(id) {
			if (id == 'yes')
			{
				var urlTest = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName)+"&siteType="+encodeURIComponent(siteType);

				Ext.Ajax.request(
				{
					url : urlTest,
					scope:this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						var testArray = jsonData.testsArrayJson;
						if (catType == 'Application')
						{
							testArray = jsonData.serverTestsArrayJson;
						}
						else if (catType == 'Site')
						{
							testArray = jsonData.siteTestsArrayJson;;
						}

						for (var i=0;i<testArray.length;i++)
						{
							var allValue = testArray[i].displayField;

							if (displaytestName == allValue)
							{
								testValueName = testArray[i].valueField;
							}
						}
						testName = testValueName;
						tests = testValueName;

						var url = "/final/admin/EgSpecificReports/data/EgspecificreportsJSONp.jsp?mode=main&catType="+catType+"&secType="+secType+"&reportType="+reportType+"&serverType="+encodeURIComponent(serverType)+"&testName="+testName+"&tests="+tests+"&hassociatem="+associatedMeasuresArray+"&hdisassociatem="+disassociatedMeasuresArray+"&deleteTest="+deleteTest+"&hassociated="+hassociated+"&hdisassociated="+hdisassociated+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName)+"&servers="+encodeURIComponent(serverType)+"&sites="+encodeURIComponent(siteType);

						Ext.Ajax.request(
						{
							url : url,
							scope: this,
							method : 'POST',
							success: function(response){

								var urlForSummary = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName)+"&siteType="+encodeURIComponent(siteType);

								Ext.Ajax.request(
								{
									url : urlForSummary,
									scope:this,
									method : 'POST',
									success: function(response){
										var jsonText = response.responseText;
										var jsonData = Ext.decode(jsonText);

										var viewArray = jsonData.summaryArrayJson;
										var viewArrayLength = jsonData.summaryArrayJson.length;

										viewStoreObj.getStore().loadRawData(viewArray);
									}
								});
							}
						});
					}
				});
			}
		});
	},

	updateInView: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var mainViewId = Ext.getCmp('mainView');
		isItemUpdated = false;

		/* code added to get the selected test name */
		var viewStoreObj = Ext.getCmp('mainGrid');

		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);

		var testValueName = '';

		var displaytestName = record.get('Test');
		var displaytests = record.get('Test');

		associatedMeasuresArray = record.get('Measures');
		// End of code added 

		var catType = Ext.getCmp('categoryType').getValue();

		var categoryInView = Ext.getCmp('categoryType').getValue();
		var reportTypeInView = Ext.getCmp('reportTypeInView').getValue();
		var comType = Ext.getCmp('selectedComp').getValue();
		var comName = Ext.getCmp('selectedComp').getDisplayValue();
		var compTypeInView = Ext.getCmp('selectedCompType').getDisplayValue();
		// pass value of combo field for component type in application category 
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var sitesInView = Ext.getCmp('sitesInView').getValue();

		var secType = "Specific";

		mainViewId.removeAll();

		mainViewId.add({xtype: 'specificreportsconfiguration' });

		var serverTypeObj = Ext.getCmp('servers');
		var siteObj = Ext.getCmp('sites');
		var componentObj = Ext.getCmp('component');

		if (catType == 'Application')
		{
			if (!Ext.isEmpty(serverTypeObj))
			{
				serverTypeObj.show();
			}
			if (!Ext.isEmpty(componentObj))
			{
				componentObj.show();
			}
			if (!Ext.isEmpty(siteObj))
			{
				siteObj.hide();
			}
		}
		else if (catType == 'Site')
		{
			if (!Ext.isEmpty(serverTypeObj))
			{
				serverTypeObj.hide();
			}
			if (!Ext.isEmpty(serverTypeObj))
			{
				componentObj.hide();
			}
			siteObj.show();
			siteObj.setValue(sitesInView);
		}
		else
		{
			if (!Ext.isEmpty(serverTypeObj))
			{
				serverTypeObj.hide();
			}
			if (!Ext.isEmpty(componentObj))
			{
				componentObj.show();
			}
			if (!Ext.isEmpty(siteObj))
			{
				siteObj.hide();
			}
		}

		var categoryObj = Ext.getCmp('category');
		var reportTypeObj = Ext.getCmp('reportType');
		var compTypeObj = Ext.getCmp('servers');
		var compObj = Ext.getCmp('component');
		var testObj = Ext.getCmp('tests');
		var itemSelectObj = Ext.getCmp('itemselectTests');

		var serverTypeObj = Ext.getCmp('servers');

		if (categoryInView != 'Application')
		{
			serverTypeObj.hide();
		}
		else
		{
			serverTypeObj.show();
		}

		categoryObj.setValue(categoryInView);
		reportTypeObj.setValue(reportTypeInView);
		compTypeObj.setValue(serverType);

		compObj.setValue(comName, true);

		var catType = Ext.getCmp('category').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var serverType = '';
		if (catType == 'Application')
		{
			serverType = Ext.getCmp('servers').getValue();
		}
		var testName = Ext.getCmp('tests').getValue();
		var secType = 'Specific';

		var urlTest = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=addnew&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName)+"&siteType="+encodeURIComponent(sitesInView);

		Ext.Ajax.request(
		{
			url : urlTest,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var testArray = jsonData.testsArrayJson;

				if (catType == 'Application')
				{
					testArray = jsonData.serverTestsArrayJson;
				}
				else if (catType == 'Site')
				{
					testArray = jsonData.siteTestsArrayJson;
				}

				for (var i=0;i<testArray.length;i++)
				{
					var allValue = testArray[i].displayField;
					var allValueField = testArray[i].valueField;
					if (displaytestName == allValue)
					{
						testValueName = testArray[i].valueField;
					}
				}

				var url = "/final/admin/EgSpecificReports/data/EgSpecificReportsJSON.jsp?mode=addnew&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&tname="+testValueName+"&serverType="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName)+"&siteType="+encodeURIComponent(sitesInView);

				Ext.Ajax.request(
				{
					url : url,
					scope:this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						compObj.getStore().loadRawData(jsonData.CompTypeArrayJson);

						if (catType == 'Application')
						{
							compTypeObj.getStore().loadRawData(jsonData.serverCompTypeArrayJson);
							testArray = jsonData.serverTestsArrayJson;
							testObj.getStore().loadRawData(jsonData.serverTestsArrayJson);
							testObj.setValue(testValueName);
						}
						else if (catType == 'Site')
						{
							siteObj.getStore().loadRawData(jsonData.siteCompTypeArrayJson);
							siteObj.setValue(sitesInView);
							testObj.getStore().loadRawData(jsonData.siteTestsArrayJson);
							testObj.setValue(testValueName);
						}
						else
						{
							testObj.getStore().loadRawData(jsonData.testsArrayJson);
							testObj.setValue(testValueName);
						}

						var allMeasures = jsonData.allRealMeasuresArrayJson;
						var disAssociatedMeasures = jsonData.disAssocRealMeasuresArrayJson;

						var aStore = new Ext.data.Store({
							fields: ['displayField','valueField'],
						});
						for (var i=0; i<allMeasures.length; i++)
						{
							var aMeasureDisplayField = allMeasures[i].displayField;
							var aMeasureValueField = allMeasures[i].valueField;
							aStore.add({'displayField': aMeasureDisplayField, 'valueField': aMeasureValueField});
							itemSelectObj.bindStore(aStore);
						}
						itemSelectObj.setValue(disAssociatedMeasures);
					}
				}
				);
			}
		});
	},
});



