Ext.define('EgSpecificReports.view.SpecificReports', {
	extend: 'Ext.form.Panel',
	alias: 'widget.specificreports',
	frame:true,
	border:true,
	cls:'outerpanel',
	title: reportsTitle,
	margin: '8 8 0 8',
	//frame: true,
	header:{cls:'zonereporthead'},
	requires:['utilities.ScrollCombo','utilities.CustomGrid'],
	layout: {
		type: 'vbox',
		align:'stretch'
	},

	items: [
		{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;' + specificReportsDesc + '</center>',
			width:'100%',
			height: 25,
			padding: 3,
		},
		{
			xtype: 'container',
			cls:'formOuter',
			padding:'0 0 10 0',
			margin: '10 10 0 10',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: categoryTypeLabel,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 150,
					margin: '10 0 5 0',
					id: 'categoryType',
					editable: false,
					store: ['Choose category type','Network','System','Application','Site']
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: reportTypeLabel,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 150,
					margin: '10 0 5 20',
					editable: false,
					id: 'reportTypeInView',
					store: ['Choose report type','Measure','Summary']
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: componentTypeLabel,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 250,
					margin: '10 0 5 20',
					editable: false,
					forceSelection: false,
					id: 'selectedCompType',
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : []
					}),
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					hidden: true
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: componentLabel,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 250,
					margin: '10 0 5 20',
					editable: false,
					forceSelection: false,
					id: 'selectedComp',
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : []
					}),
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					onItemClick: function(picker, record){
						/*
						 * If we're doing single selection, the selection change events won't fire when
						 * clicking on the selected element. Detect it here.
						 */
						var me = this,
							selection = me.picker.getSelectionModel().getSelection(),
							valueField = me.displayField;

						if (!me.multiSelect && selection.length) {
							if (record.get(valueField) === selection[0].get(valueField)) {
								// Make sure we also update the display value if it's only partial
								me.displayTplData = [record.data];
								me.setValue(me.getDisplayValue());
								me.collapse();
							}
						}
						//thisController.compChange();
					},
					setValue: function(value, doSelect) {
						var me = this,
						valueNotFoundText = me.valueNotFoundText,
						inputEl = me.inputEl,
						i, len, record,
						dataObj,
						matchedRecords = [],
						displayTplData = [],
						processedValue = [];

						if (me.store.loading) {
							// Called while the Store is loading. Ensure it is processed by the onLoad method.
							me.value = value;
							me.setHiddenValue(me.value);
							return me;
						}

						// This method processes multi-values, so ensure value is an array.
						value = Ext.Array.from(value);

						// Loop through values, matching each from the Store, and collecting matched records
						for (i = 0, len = value.length; i < len; i++) {
							record = value[i];
							if (!record || !record.isModel) {
								record = me.findRecordByDisplay(record);
							}
							// record found, select it.
							if (record) {
								matchedRecords.push(record);
								displayTplData.push(record.data);
								processedValue.push(record.get(me.valueField));
							}
							// record was not found, this could happen because
							// store is not loaded or they set a value not in the store
							else {
								// If we are allowing insertion of values not represented in the Store, then push the value and
								// create a fake record data object to push as a display value for use by the displayTpl
								if (!me.forceSelection) {
									processedValue.push(value[i]);
									dataObj = {};
									dataObj[me.displayField] = value[i];
									displayTplData.push(dataObj);
									// TODO: Add config to create new records on selection of a value that has no match in the Store
								}
								// Else, if valueNotFoundText is defined, display it, otherwise display nothing for this value
								else if (Ext.isDefined(valueNotFoundText)) {
									displayTplData.push(valueNotFoundText);
								}
							}
						}

						// Set the value of this field. If we are multiselecting, then that is an array.
						me.setHiddenValue(processedValue);
						me.value = me.multiSelect ? processedValue : processedValue[0];
						if (!Ext.isDefined(me.value)) {
							me.value = null;
						}
						me.displayTplData = displayTplData; //store for getDisplayValue method
						me.lastSelection = me.valueModels = matchedRecords;

						if (inputEl && me.emptyText && !Ext.isEmpty(value)) {
							inputEl.removeCls(me.emptyCls);
						}

						// Calculate raw value from the collection of Model data
						me.setRawValue(me.getDisplayValue());
						me.checkChange();

						if (doSelect !== false) {
							me.syncSelection();
						}
						me.applyEmptyText();

						return me;
					},

				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: 'Sites',
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 250,
					margin: '10 0 5 20',
					editable: false,
					forceSelection: false,
					id: 'sitesInView',
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : []
					}),
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					hidden: true
				}
			]
		},
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id: 'mainGrid',
			store: new Ext.data.Store({
				fields : ['Test', 'Measures'],
				data : []
			}),
			flex: 1,
			queryMode: 'local',
			autoScroll: false,
			scroll:true,
			//viewConfig: {
			//	deferEmptyText: true
			//},
			//emptyText: "<table border='0' height='350px' width='100%'><tr><td align=center valign=middle><img src='/final/images/spacer.gif' class='iconInformation'><div class='commonErrorMsgText'>No Data Found</div></td></tr></table>",
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: testGridText,
						dataIndex: 'Test',
						width: 280
					},
					{
						text: measuresGridText,
						dataIndex: 'Measures',
						flex: 1,
						renderer : function(value) {
							return '<table width="100%" cellspacing="0" cellpadding="0"><tr><td valign="top" style="font-size:8pt;font-family:Tahoma,Calibri,Arial,Helvetica,sans-serif;">'+value+'</td></tr></table>';
						}
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-edit-column-header',
						width: 36,
						//icon: '../../../../resources/images/edit_task.png',
						iconCls: 'iconModify',
						//tooltip: 'Modify',
						sortable: false,
						id: 'updateInView',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
						}
						//handler: Ext.bind(this.handleEditClick, this),
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 36,
						//icon: '../../../../resources/images/delete.png',
						iconCls: 'iconDelete',
						//tooltip: 'Delete',
						sortable: false,
						id: 'deleteInView',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
						}
						//handler: Ext.bind(this.handleEditClick, this),
					}
				]
			},
			margin: 10,
			tbar:[
		{
			xtype:'tbfill',
		},{
			xtype:'toolbar',
			ui:'footer',
			items:[
				{
					xtype: 'button',
					cls:'button20',
					text: addNewBtnText,
					id: 'addNew'
				},
				{
					xtype: 'button',
					cls:'button20',
					text: addToSummaryBtnText,
					id: 'addToSummary',
					disabled: true
				}
			]
		}]
		}
	]

});



