Ext.define('EgSuperMgr.controller.Main',{
	extend:'Ext.app.Controller',
	views:['EgSuperMgr.view.SMConfiguration','EgSuperMgr.view.AddSuperManager'],
	refs:[
		{selector:'smconfiguration', ref:'smconfiguration'},
		{selector:'addSuperMgr', ref:'addSuperMgr'}
	],

	init: function()
	{
		thisController = this;
		if(!Ext.isEmpty(alertForNotAllowed))
		{
			Ext.Msg.show({
				title: 'SuperManager Configuration',
				msg: alertForNotAllowed,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}
		this.control({
			'smconfiguration':
			{
				'afterrender': this.afterMainRender
			},
			'smconfiguration button[id="addNew"]':
			{
				'click': this.managerComboChange
			},
			'smconfiguration actioncolumn[id="modify"]':
			{
				'click': this.modifyManager
			},
			'smconfiguration actioncolumn[id="delete"]':
			{
				'click': this.deleteManager
			},
			'addSuperMgr button[id="updateBtn"]':
			{
				'click': this.update
			},
		});
	},

	afterMainRender: function()
	{
		var mainGridObj = Ext.getCmp('mainGrid');
		Ext.Ajax.request({
				url: '/final/admin/EgSuperMgr/data/EgAddDeleteSuperMgrJSON.jsp?index=main',
				method: 'POST',
				success: function( response )
				{
					if( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonData = Ext.decode( response.responseText );
						mainGridObj.getStore().loadRawData(jsonData.managersForGrid);
					}
				}
			}
		);
	},

	managerComboChange: function()
	{
		Ext.widget('addSuperMgr').show();
		Ext.getCmp('addSuperMgr').show();
		Ext.getCmp('SMID').setVisible(true);
		Ext.getCmp('displaySmId').setVisible(false);

		Ext.getCmp('updateBtn').setText(superMgrAddText);

		var windowObj = Ext.getCmp('addSuperMgr');
		windowObj.setHeight('280');
		windowObj.doLayout();
	},

	update: function()
	{
		var updateText = Ext.getCmp('updateBtn').getText();
		if(updateText == superMgrUpdateBtnText)
		{
			var valFlag = 'true';
			var altMgrIps = Ext.getCmp('altMgrIps').getValue();
			var supermanager_url = Ext.getCmp('supermanagerURL').getValue();

			if(!checkblank(supermanager_url))
			{
				Ext.Msg.show({
					title: modifySuperMgrTitle,
					msg: url_blank,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('supermanagerURL').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			else if(!checkspace(supermanager_url))
			{
				Ext.Msg.show({
					title: modifySuperMgrTitle,
					msg: url_space,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('supermanagerURL').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			else if(!isValidURL(supermanager_url))
			{
				Ext.Msg.show({
					title: modifySuperMgrTitle,
					msg: url_invalid,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('supermanagerURL').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			else if(!checkblank(altMgrIps))
			{
				Ext.Msg.show({
					title: modifySuperMgrTitle,
					msg: alt_blank,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('altMgrIps').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			else if(!checkspace(altMgrIps))
			{
				Ext.Msg.show({
					title: modifySuperMgrTitle,
					msg: alt_space,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('altMgrIps').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			else if(!isValidAltIpAddress(altMgrIps))
			{
				Ext.Msg.show({
					title: modifySuperMgrTitle,
					msg: alt_invalid,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('altMgrIps').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			if(valFlag == 'true')
			{
				var mainGridObj = Ext.getCmp('mainGrid');
				var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Processing...'});
				myMask.show();
				var addURL = '/final/admin/EgSuperMgr/data/EgadddeletesupermgrJSONp.jsp?mode=modify&SMID='+Ext.getCmp('SMID').getValue()+'&altMgrIps='+Ext.getCmp('altMgrIps').getValue()+'&supermanagerURL='+Ext.getCmp('supermanagerURL').getValue();

				Ext.Ajax.request(
					{
						url : addURL,
						scope: this,
						method : 'POST',
						success: function(response){
							myMask.hide();

							Ext.Msg.show({
								title: modifySuperMgrTitle,
								msg: alertForModified,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});

							Ext.getCmp('addSuperMgr').destroy();

							Ext.Ajax.request({
								url: '/final/admin/EgSuperMgr/data/EgAddDeleteSuperMgrJSON.jsp?index=main',
								method: 'POST',
								success: function( response )
									{
										if( response.status == 200 && !Ext.isEmpty( response.responseText ) )
										{
											var jsonText = response.responseText;
											var jsonData = Ext.decode( jsonText );

											mainGridObj.getStore().loadRawData(jsonData.managersForGrid);
										}
									}
								}
							);
						},
						failure: function(response){
							myMask.hide();

							Ext.Msg.show({
								title: modifySuperMgrTitle,
								msg: alertForDeleted,
								width: 300,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
						},
					}
				);
			}
		}
		else
		{
			var valFlag = 'true';
			var smidObj = Ext.getCmp('SMID');
			var SM_ID = smidObj.getValue();
			var supermanager_url = Ext.getCmp('supermanagerURL').getValue();
			var altMgrIps = Ext.getCmp('altMgrIps').getValue();

			if(!checkblank(SM_ID))
			{
				Ext.Msg.show({
					title: addSuperMgrTitle,
					msg: smid_blank,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('SMID').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			else if(!checkspace(SM_ID))
			{
				Ext.Msg.show({
					title: addSuperMgrTitle,
					msg: id_space,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('SMID').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			else if(SM_ID.toLowerCase()=="supermanager")
			{
				Ext.Msg.show({
					title: addSuperMgrTitle,
					msg: id_reserved,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('SMID').focus(true,true);
					}
				});
				return false;
			}
			else if(!checkspecial(SM_ID))
			{
				Ext.Msg.show({
					title: addSuperMgrTitle,
					msg: id_splchar,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('SMID').focus(true,true);
					}
				});
				return false;
			}
			else if(!checkblank(supermanager_url))
			{
				Ext.Msg.show({
					title: addSuperMgrTitle,
					msg: url_blank,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('supermanagerURL').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			else if(!checkspace(supermanager_url))
			{
				Ext.Msg.show({
					title: addSuperMgrTitle,
					msg: url_space,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('supermanagerURL').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			else if(!isValidURL(supermanager_url))
			{
				Ext.Msg.show({
					title: addSuperMgrTitle,
					msg: url_invalid,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('supermanagerURL').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			else if(!checkblank(altMgrIps))
			{
				Ext.Msg.show({
					title: addSuperMgrTitle,
					msg: alt_blank,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('altMgrIps').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			else if(!checkspace(altMgrIps))
			{
				Ext.Msg.show({
					title: addSuperMgrTitle,
					msg: alt_space,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('altMgrIps').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			else if(!isValidAltIpAddress(altMgrIps))
			{
				Ext.Msg.show({
					title: addSuperMgrTitle,
					msg: alt_invalid,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('altMgrIps').focus(true,true);
					}
				});
				valFlag = 'false';
			}
			if(valFlag == 'true')
			{
				var mainGridObj = Ext.getCmp('mainGrid');
				var SMID = Ext.getCmp('SMID').getValue();
				var altMgrIps = Ext.getCmp('altMgrIps').getValue();
				var supermanagerUrl = Ext.getCmp('supermanagerURL').getValue();
				var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Processing...'});
				myMask.show();
				var addURL = '/final/admin/EgSuperMgr/data/EgadddeletesupermgrJSONp.jsp?mode=add&altMgrIps='+altMgrIps+'&supermanagerURL='+supermanagerUrl+'&SMID='+SM_ID;
				Ext.Ajax.request(
				{
					url : addURL,
					scope: this,
					method : 'POST',
					success: function(response){
						myMask.hide();

						Ext.Msg.show({
							title: addSuperMgrTitle,
							msg: alertForAdded,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});

						Ext.getCmp('addSuperMgr').destroy();

						Ext.Ajax.request({
								url: '/final/admin/EgSuperMgr/data/EgAddDeleteSuperMgrJSON.jsp?index=main',
								method: 'POST',
								success: function( response )
								{
									if( response.status == 200 && !Ext.isEmpty( response.responseText ) )
									{
										var jsonText = response.responseText;
										var jsonData = Ext.decode( jsonText );

										mainGridObj.getStore().loadRawData(jsonData.managersForGrid);
									}
								}
							}
						);
					},
					failure: function(response){
						myMask.hide();

						Ext.Msg.show({
							title: addSuperMgrTitle,
							msg: alertForDeleted,
							width: 300,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
					},
				});
			}
		}
	},

	modifyManager: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		Ext.widget('addSuperMgr').show();
		Ext.getCmp('addSuperMgr').show();
		Ext.getCmp('SMID').setVisible(false);
		Ext.getCmp('displaySmId').setVisible(true);

		var viewStoreObj = Ext.getCmp('mainGrid');
		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);

		Ext.getCmp('displaySmId').setValue(record.get('SMID'));
		Ext.getCmp('SMID').setValue(record.get('SMID'));
		Ext.getCmp('altMgrIps').setValue(record.get('ALTIPS'));
		Ext.getCmp('supermanagerURL').setValue(record.get('SUPERMANAGERURL'));

		var modifyBtn = Ext.getCmp('updateBtn');
		modifyBtn.setText(superMgrUpdateBtnText);
		modifyBtn.show();

		var windowObj = Ext.getCmp('addSuperMgr');
		windowObj.setTitle(modifySuperMgrTitle);
		windowObj.setHeight('280');
		windowObj.doLayout();
	},

	deleteManager: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var mainGridObj = Ext.getCmp('mainGrid');
		var me = this;

		var viewStoreObj = Ext.getCmp('mainGrid');
		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);
		var supermgrs = record.get('SMID');

		Ext.MessageBox.confirm(superMgrDelete,alertForSingleDeleteConfirmation + ' \'' + supermgrs + '\' ' + '?', function(id) {
			if(id == 'yes')
			{
				Ext.Ajax.request({
					url: '/final/admin/EgSuperMgr/data/EgAddDeleteSuperMgrJSON.jsp?mode=delete',
					method: 'POST',
					success: function( response )
					{
						if( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode( jsonText );
							Ext.Ajax.request(
								{
									url: '/final/admin/EgSuperMgr/data/EgadddeletesupermgrJSONp.jsp?supermgrs='+supermgrs+'&mode=delete',
									method: 'POST',
									success: function(form, action)
									{
										Ext.Msg.show({
											title: superMgrDelete,
											msg: alertForDeleted,
											width: 300,
											buttons: Ext.Msg.OK,
											icon: 'iconInformation'
										});

										Ext.Ajax.request({
											url: '/final/admin/EgSuperMgr/data/EgAddDeleteSuperMgrJSON.jsp?index=main',
											method: 'POST',
											success: function( response )
											{
												if( response.status == 200 && !Ext.isEmpty( response.responseText ) )
												{
													var jsonText = response.responseText;
													var jsonData = Ext.decode( jsonText );

													mainGridObj.getStore().loadRawData(jsonData.managersForGrid);
												}
											}
										});
									},
									failure: function(form, action) // if result page doest not contain success:true, this method fires
									{
										Ext.Msg.show({
											title: superMgrDelete,
											msg: alertForAddedOrDeleted,
											width: 300,
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
									}
								}
							);
						}
					}
				});
			}
		},me);
		
	},

	deleteCheckBox: function()
	{
		var mainGridObj = Ext.getCmp('mainGrid');
		var selectedRecords = mainGridObj.getSelectionModel().getSelection();
		var mgrIds = '';
		var len = selectedRecords.length;
		var j = 0;
		var mutipleDelete = 'multipleDelete';

		var allCAExistingManagers = '';
		var alleGExistingManagers = '';

		if(len == 0)
		{
			Ext.Msg.show({
				title: superMgrDelete,
				msg: alertForNoDeleteSelected,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}
		else
		{
			Ext.MessageBox.confirm(superMgrDelete,alertForDeleteConfirmation,
				function(id)
				{
					if(id == 'yes')
					{
						for(var i=0; i<len; i++)
						{
							var mgrId = selectedRecords[i].get('SMID');
							if(i == 0) {
								mgrIds = mgrId;
							}
							else {
								mgrIds = mgrIds + ',' + mgrId;
							}
						}
						var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Processing...'});
						myMask.show();

						Ext.Ajax.request(
						{
							url: '/final/admin/EgSuperMgr/data/EgadddeletesupermgrJSONp.jsp?supermgrs='+mgrIds+'&mode=delete&mutipleDelete='+mutipleDelete,
								method: 'POST',
								success: function(form, action)
								{
									myMask.hide();

									Ext.Msg.show({
										title: superMgrDelete,
										msg: alertForDeleted,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
									Ext.Ajax.request({
										url: '/final/admin/EgSuperMgr/data/EgAddDeleteSuperMgrJSON.jsp?index=main',
										method: 'POST',
										success: function( response )
										{
											if( response.status == 200 && !Ext.isEmpty( response.responseText ) )
											{
												var jsonText = response.responseText;
												var jsonData = Ext.decode( jsonText );

												mainGridObj.getStore().loadRawData(jsonData.managersForGrid);
											}
										}
									});
								},
								failure: function(form, action) // if result page doest not contain success:true, this method fires
								{
									myMask.hide();

									Ext.Msg.show({
										title: superMgrDelete,
										msg: alertForAddedOrDeleted,
										width: 300,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
								}
							});
						}
						else
						{
							for(var i=0; i<len; i++)
							{
								mainGridObj.getSelectionModel().deselect(selectedRecords[i]);
							}
						}
					},
				this
			);
		}
	}
});
function isValidAltIpAddress(ipaddress)
{
	if(ipaddress != null && ipaddress.trim().length==0)
	{
		return true;
	}
	var result = true;
	var ar = ipaddress.split(',');
	for(var i=0;i<ar.length;i++)
	{
		if(!isValidIPAddress(ar[i]))
		{
			result=false;
			break;
		}
	}
	return result;
}
function isValidIPAddress(ipAddress)
{
	var result = true;
	var ips = ipAddress.trim().split(',');
	var ipformat = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
	for(var i=0;i<ips.length;i++)
	{
		if(!ips[i].match(ipformat))
		{
			result=false;
		}
	}
	return result;
}
function isValidURL(url) {
	var regexp = new RegExp("^http(s?)\:\/\/[0-9a-zA-Z]([-.\w]*[0-9a-zA-Z])*(:(0-9)*)*(\/?)([a-zA-Z0-9\-\.\?\,\'\/\\\+&amp;%\$#_]*)?$");
	var regexp1 = new RegExp("^HTTP(S?)\:\/\/[0-9a-zA-Z]([-.\w]*[0-9a-zA-Z])*(:(0-9)*)*(\/?)([a-zA-Z0-9\-\.\?\,\'\/\\\+&amp;%\$#_]*)?$");
	if(!regexp.test(url) && !regexp1.test(url))
	{
		return false;
	}
	else
	{
		return true;
	}
}
function checkblank(str_Value)
{
	if(str_Value.length==0)
	{
		int_Flag=0;
	}
	for(i=1;i<=str_Value.length ;i++)
	{
		if(str_Value.charAt(i-1) == " ")
		{
			int_Flag=0;
		}
		else
		{
			int_Flag = 1;
			break;
		}
	}
	if(int_Flag != 1)
	{
		return false;
	}
	return true;
}
function checkspace(fieldValue)
{
	var s_val = fieldValue;
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			return false;
		}
	}
	return true;
}
function checkspecial(obj_val)
{
	var splChars = "`~!@#$%^&*()+=[]{}|\\:;\"\'<>,?\/";
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = splChars.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			return false;
		}
	}
	return true;
}

