Ext.define('EgSuperMgr.view.AddSuperManager', {
	extend: 'Ext.window.Window',
	alias: 'widget.addSuperMgr',
	id: 'addSuperMgr',
	width: 600,
	padding:'3 10 10 10',
	title: addSuperMgrTitle,
	resizable: false,
	draggable: true,
	modal: true,

	listeners : {
		close : function()
		{
			Ext.Ajax.request({
				url:'EgSuperMgr/data/EgAddDeleteSuperMgrJSON.jsp?index=main',
				method:'POST'
			});
		}
	},
	requires: ['utilities.ScrollCombo'],
	items: [
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			defaults: {
				labelSeparator: '',
				width: 450,
				labelWidth: 200,
				margin: 5
			},
			margin: 10,
			items: [
				{
					xtype: 'displayfield',
					fieldLabel: superMgrNameLabel,
					id: 'displaySmId',
					name: 'displaySmId',
					value: '',
					hidden:true
				},
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: superMgrNameLabel,
					id: 'SMID',
					name: 'SMID',
					maxLength: 32,
					enforceMaxLength: true,
					hidden: false
				},
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: supermanagerLabel,
					id: 'supermanagerURL',
					name: 'supermanagerURL',
					value: 'https://localhost:7077'
				},
				{
					xtype: 'textareafield',
					cls:'textbox',
					fieldLabel: superMgrAltIPLabel,
					id: 'altMgrIps',
					name: 'altMgrIps',
					//value: 'None',
					tooltip: superMgrAltIPTooltipLabel,
					listeners : {
						render: function(p) {
							//p.getEl().down('input').set({'data-qtip': p.tooltip});
						}
					}
				},
				{
					xtype: 'button',
					cls:'button20',
					text: superMgrUpdateBtnText,
					width: 80,
					id: 'updateBtn',
					margin: '10 0 0 0'
				}
			]
		}
	]
});



