Ext.define('EgSuperMgr.view.SMConfiguration', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.smconfiguration',
	border: true,
	frame: true,
	title: superMgrConfigTitle,
	margin:'8 8 0 8',

	requires : [
		'utilities.ScrollCombo',
		'utilities.CustomGrid',
		'utilities.adminMsg'
	],

	layout: {
		type: 'vbox',
		align:'stretch'
	},

	dockedItems: [
		{
			xtype: 'adminmsg',
			align:'center',
			addIcon:'iconAdminInfo',
			html: superMgrConfigDesc,
			spaceforImg:5,
			padding: 5
		}
	],

	items:[
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id: 'mainGrid',
			store: new Ext.data.Store({
				fields : ['SMID','SUPERMANAGERURL','ALTIPS'],
				data : []
			}),
			flex: 1,
			autoScroll: true,
			scroll: true,
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: "<table border='0' height='350px' width='100%'><tr><td align=center vlaign=top><img src='/final/images/spacer.gif' class='iconInformation'><div class='commonErrorMsgText'>" + noSuperMgr + ".</div></td></tr></table>",
			selModel: {
				selType: 'checkboxmodel',
				mode: 'MULTI',
				checkOnly: true,
			},
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: superMgrNameLabel,
						dataIndex: 'SMID',
						flex:1
					},
					{
						text: superMgrURLLabel,
						dataIndex: 'SUPERMANAGERURL',
						flex:1
					},
					{
						text: superMgrAltIPLabel,
						dataIndex: 'ALTIPS',
						flex:1.5
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls: 'iconModify',
						sortable: false,
						id: 'modify',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
						}
					},
					{
						header : '<div class="iconDeleteAll" data-qtip="Delete All" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						width: 36,
						iconCls: 'iconDelete',
						sortable: false,
						id: 'delete',
						listeners: {
							headerclick: function(g, index, ev) {
								thisController.deleteCheckBox();
							},
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
						}
					}
				]
			},
			margin: 10,
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					items:[
						{
							xtype: 'button',
							cls:'button20',
							text: addSuperMgr,
							id: 'addNew'
						}
					]
				}
			]
		}
	]

});



