<!DOCTYPE html>

<%@ include file="EgTrackerA.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import = "com.eg.EgCertUsage"%>
<%@ page import = "com.eg.EgUuidInfo"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	EgCertUsage user = new EgCertUsage();
	ArrayList usersList = user.getAllLimitedCompAccessUsers(true);
	boolean isLimitedAdmin = (usersList.contains(session.getId()));
	boolean isMspModel = EgUuidInfo.isMspModel();

	String orgUnitName = "Organizational Unit";
	if (isMspModel)
	{
		orgUnitName = "Organization/ Organizational Unit";
	}
%>

<html>
<head>
	<meta charset="utf-8">

	<!--Skin color--------->
	<egui:skin ui = "admin"/>

	<!---Components, icons, skin and Core ext script--->
	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>
	<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>

	<script language="JavaScript1.2">
		var csrfToken = '<%=strCsrfToken%>';
		var isMspModel = <%=isMspModel%>;
		var isLimitedAdmin = <%=isLimitedAdmin%>;
		var mainPageTitle = '<egui:intnl text="admin.title.LICENSE LIMIT"/>';
		var pageTitle = '<egui:intnl text="admin.title.LICENSE LIMIT"/>';
		var pageDesc = '<egui:intnl description="EgUserLicense.jsp"/>';
		var publicJSON = '';

		// Field Labels
		var popTitle = '<egui:intnl text="admin.title.SET LICENSE LIMIT FOR"/>';
		var popTitle2 = '<egui:intnl text="admin.title.LICENSE LIMIT"/>';
		var userName = '<egui:intnl text="admin.title.User"/>';
		var totalMonitors = '<egui:intnl text="admin.title.Total Monitors"/>';
		var premiumMonitors = '<egui:intnl text="admin.title.Premium Monitors"/>';
		var basicMonitors = '<egui:intnl text="admin.title.Basic Monitors"/>';
		var networkDevices = '<egui:intnl text="admin.title.Network Devices"/>';
		var concurrentUsers = '<egui:intnl text="admin.title.Concurrent Users"/>';
		var namedUsers = '<egui:intnl text="admin.title.Named Users"/>';
		var UserBased = '<egui:intnl text="admin.title.UserBased"/>';
		var UserCount = '<egui:intnl text="admin.title.Monitor Users"/>';
		var updateBtn = '<egui:intnl text="admin.title.Update"/>';
		var deleteAllBtn = '<egui:intnl text="admin.title.Delete All"/>';
		var unlimited = '<egui:intnl text="admin.title.Unlimited"/>';
		var orgUnitName = "<%=orgUnitName%>";
		var orgName = '<egui:intnl text="admin.title.Organization/ Organizational Unit"/>';
		var searchLbl = '<egui:intnl text="admin.title.Search Org/OU"/>';
		var licMsg1 = premiumMonitors + " = " + totalMonitors + " - " + basicMonitors + ".";
		var licMsg2 = '<egui:intnl text="admin.title.Note that you cannot set the premium monitor license limit"/>';
		var licenseMsg = licMsg1 + "<br/>" + licMsg2;

		// Validation & Alert Msgs
		var intnlLabel1 = '<egui:intnl text="admin.eguserlicense.Please enter the total monitors"/>';
		var intnlLabel2 = '<egui:intnl text="admin.eguserlicense.Please enter the basic monitors"/>';
		var intnlLabel3 = '<egui:intnl text="admin.eguserlicense.Please enter the network devices"/>';
		var intnlLabel4 = '<egui:intnl text="admin.eguserlicense.Please enter the concurrent users"/>';
		var intnlLabel5 = '<egui:intnl text="admin.eguserlicense.Please enter the named users"/>';
		var intnlLabel6 = '<egui:intnl text="admin.eguserlicense.Please select an Organization/OU/User"/>';
		var intnlLabel7 = '<egui:intnl text="admin.eguserlicense.Please enter the monitor users"/>';
		var intnlLabel8 = '<egui:intnl text="admin.eguserlicense.License limit has been configured successfully"/>';
		var intnlLabel9 = '<egui:intnl text="admin.eguserlicense.License limit for all the users have been deleted successfully"/>';
		var intnlLabel10 = '<egui:intnl text="admin.eguserlicense.License limit has been deleted successfully"/>';

		var validationMsg1 = '<egui:intnl text="admin.eguserlicense.Space is not allowed"/>';
		var validationMsg2 = '<egui:intnl text="admin.snmp.Special characters are not allowed"/>';
		var validationMsg3 = '<egui:intnl text="admin.eguserlicense.No default licensing policy users available"/>';

		var validationMsg4 = '<egui:intnl text="admin.eguserlicense.Total monitors count of the Org/OU should be greater than or equal to that of the child OUs"/>';
		var validationMsg5 = '<egui:intnl text="admin.eguserlicense.Basic monitors count of the Org/OU should be greater than or equal to that of the child OUs"/>';
		var validationMsg6 = '<egui:intnl text="admin.eguserlicense.Network devices count of the Org/OU should be greater than or equal to that of the child OUs"/>';
		var validationMsg7 = '<egui:intnl text="admin.eguserlicense.Concurrent users count of the Org/OU should be greater than or equal to that of the child OUs"/>';
		var validationMsg8 = '<egui:intnl text="admin.eguserlicense.Named users count of the Org/OU should be greater than or equal to that of the child OUs"/>';

		var validationMsg9 = '<egui:intnl text="admin.eguserlicense.Your are exceeding the total monitors count of the Organization/Organizational Unit"/>';
		var validationMsg10 = '<egui:intnl text="admin.eguserlicense.Your are exceeding the basic monitors count of the Organization/Organizational Unit"/>';
		var validationMsg11 = '<egui:intnl text="admin.eguserlicense.Your are exceeding the network devices count of the Organization/Organizational Unit"/>';
		var validationMsg12 = '<egui:intnl text="admin.eguserlicense.Your are exceeding the concurrent users count of the Organization/Organizational Unit"/>';
		var validationMsg13 = '<egui:intnl text="admin.eguserlicense.Your are exceeding the named users count of the Organization/Organizational Unit"/>';
		var validationMsg14 = '<egui:intnl text="admin.eguserlicense.Monitor users count of the Org/OU should be greater than or equal to that of the child OUs"/>';
		var validationMsg15 = '<egui:intnl text="admin.eguserlicense.Your are exceeding the monitor users count of the Organization/Organizational Unit"/>';
		var validationMsg16 = '<egui:intnl text="admin.eguserlicense.Your are exceeding the premium monitors count of the Organization/Organizational Unit"/>';
		var validationMsg17 = '<egui:intnl text="admin.eguserlicense.Basic Monitors count should be less than Total Monitors count"/>';
		var validationMsg18 = '<egui:intnl text="admin.eguserlicense.Licensing policy is not applicable for the egenterprise user"/>';

		var validationMsg19 = '<egui:intnl text="admin.eguserlicense.Total monitors count of the Org/OU should be greater than or equal to its consumed license limit"/>';
		var validationMsg20 = '<egui:intnl text="admin.eguserlicense.Basic monitors count of the Org/OU should be greater than or equal to its consumed license limit"/>';
		var validationMsg21 = '<egui:intnl text="admin.eguserlicense.Premium monitors count of the Org/OU should be greater than or equal to its consumed license limit"/>';
		var validationMsg22 = '<egui:intnl text="admin.eguserlicense.Network devices count of the Org/OU should be greater than or equal to its consumed license limit"/>';
		var validationMsg23 = '<egui:intnl text="admin.eguserlicense.Monitor users count of the Org/OU should be greater than or equal to its consumed license limit"/>';
		var validationMsg24 = '<egui:intnl text="admin.eguserlicense.You are trying to over-utilize the license"/>';
		var validationMsg25 = '<egui:intnl text="admin.eguserlicense.Set a Basic Monitor license limit lesser than"/>';

		var updateSingleRowActnMsg = '<egui:intnl text="admin.eguserlicense.Are you sure you want to delete the license limit for"/>';
		var updateMultipleActnMsg = '<egui:intnl text="admin.eguserlicense.Are you sure you want to delete the license limit for all the users"/>';
		var noUserAlert = '<egui:intnl text="admin.eguserlicense.No organizational unit found with license limit"/>';
		var noUserSearchAlert = '<egui:intnl text="admin.eguserlicense.No organizational unit found for your current search"/>';
		if (isMspModel)
		{
			noUserAlert = '<egui:intnl text="admin.eguserlicense.No organization/organizational unit found with license limit"/>';
			noUserSearchAlert = '<egui:intnl text="admin.eguserlicense.No organization/organizational unit found for your current search"/>';
		}
		var LoadAlert1 = '<table border="0" width="100%" height="400px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noCompAlrtDiv">'+noUserAlert+'</div></td></tr></table>';
		var LoadSearchAlert = '<table border="0" width="100%" height="400px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noCompAlrtDiv">'+noUserSearchAlert+'</div></td></tr></table>';

		var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>';
		var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>';
		var errorTitle = '<egui:intnl text="admin.user.Error"/>';
		
	</script>

	<!-- Application folder -->
	<script type="text/javascript" src="UserLicense/app/app.js"></script>

	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						console.log(response.responseText);
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>
	<style>
	.x-boundlist.admin_list_div{
	
	}
	.x-boundlist.admin_list_div .listdiv{
	
	}
	.x-boundlist.admin_list_div li{
		padding:0px !important;
	}
	.x-boundlist.admin_list_div li td{
		padding:5px !important;
	}
	.x-boundlist.admin_list_div li td:first-child{
		border-right:1px solid #abb2bd;
	}
	.gridSkin .x-column-header-inner .x-column-header-text  {
		//padding: 2px 10px 1px 10px !important;
		white-space: normal;
		word-break: break-word;
		text-align: center;
	}
	</style>
</head>

<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</body>
</html>
<%
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgUserLicense.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgUserLicense.jsp");
	}
%>



