Ext.define('EgUserRegReport.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main','Print'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'userregtools', ref:'userregtools'},
	],
	init:function(){
		appCnt = this;
		this.buildMainData();
		this.control({
			'main':
			{
				'afterrender': this.afterMainRender
			},
			'main button[id="submit"]':
			{
				'click': this.SubmitUserData
			},
			'main combo[id="timeLineCombo"]':
			{
				'select':this.loadTimeLineDetails
			},
			'main button[id="print"]':
			{
				'click':this.printPage
			}
		});

	},
	printPage : function()
	{
		var report = Ext.getCmp('timeLineCombo').getValue();
		if(report == "Any period")
		{
			var hiddenFields = publicJSON['hiddenFields'];
			var sdate = Ext.getCmp('startdate_h');
			var edate = Ext.getCmp('enddate_h');
			var shr = hiddenFields.starthour;
			var ehr = hiddenFields.endhour;
			var smin = hiddenFields.startmin;
			var emin = hiddenFields.endmin;
			if(!checkblank(sdate.getValue()))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: pageIntn11 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				sdate.focus(true);
				return false;
			}
			else if(!checkblank(edate.getValue()))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: pageIntn12 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				edate.focus(true);
				return false;
			}
			else if((sdate != null) && (edate != null))
			{
				var ssdate = sdate.getValue();
				var eedate = edate.getValue();
				if(checkCurrentDate(s_mon+"/"+s_day+"/"+s_yr,ssdate,eedate))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: pageIntn13 + ".",
						width : 350,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false
				}
				else if((sdate.getValue() > edate.getValue()) || (sdate.getValue() < edate.getValue()))
				{
					if(!checkExtTime(ssdate,eedate,shr,ehr,smin,emin))
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: pageIntn14 + ".",
							width : 350,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false
					}
				}

			}
		}
		var startdate = Ext.Date.dateFormat(Ext.getCmp('startdate').getValue(), mgrDateFormat);
		var enddate = Ext.Date.dateFormat(Ext.getCmp('enddate').getValue(), mgrDateFormat);
		var qrString = "getData=true&startdate="+encodeURIComponent(startdate)+"&enddate="+encodeURIComponent(enddate)+"&report="+report+"&action=go";

		var printPage = "/final/admin/EgCommonPrintPage.jsp?flag=2&from=UserRegReport&"+qrString;
		Ext.widget('print').show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set(
		{
			src :  printPage
		});
	},
	buildMainData : function()
	{
		Ext.Ajax.request({
			url : appURL,
			method : 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	afterGridRender: function()
	{
	},
	afterMainRender : function()
	{
		Ext.getCmp('print').setDisabled(true);
		var timeLineCombo = Ext.getCmp('timeLineCombo');
		var timeLineComboRawData = publicJSON['timeLineCombo'];
		timeLineCombo.getStore().loadRawData(timeLineComboRawData);
		if (selectedReportType == "" || selectedReportType.length == 0)
		{
			timeLineCombo.setValue(timeLineComboRawData[0].valueField);
		}
		else
		{
			timeLineCombo.setValue(selectedReportType);
		}

		var startDateVal = publicJSON['startdate'];
		Ext.getCmp('startdate').setValue(startDateVal);
		Ext.getCmp('startdate_h').setValue(startDateVal);

		var endDateVal = publicJSON['enddate'];
		Ext.getCmp('enddate').setValue(endDateVal);
		Ext.getCmp('enddate_h').setValue(endDateVal);

		var screenLabels = publicJSON['screenLabels'];
		Ext.getCmp('timeLineCombo').setFieldLabel(screenLabels['admin.common.Timeline']);
		Ext.getCmp('startdate').setFieldLabel(screenLabels['admin.common.Start date']);
		Ext.getCmp('enddate').setFieldLabel(screenLabels['admin.common.End date']);
		Ext.getCmp('submit').setText(screenLabels['admin.common.Go']);

		if (actionVal == "go")
		{
			if (selectedReportType == "Any period")
			{
				Ext.getCmp('startdate').setDisabled(false);
				Ext.getCmp('enddate').setDisabled(false);
			}
			else
			{
				Ext.getCmp('startdate').setDisabled(true);
				Ext.getCmp('enddate').setDisabled(true);
			}

			var usergrid = Ext.getCmp('usergrid');
			var timeLineRawData = publicJSON['userRegReports'];
			if (!Ext.isEmpty(timeLineRawData))
			{
				usergrid.getStore().loadRawData(timeLineRawData);
				Ext.getCmp('usergrid').show();
				Ext.getCmp('emptyPanel').hide()
				var screenLabels = publicJSON['gridColumns'];
				var gridTitle = publicJSON['gridTitle'];
				usergrid.setTitle(gridTitle);
				for ( var i = 0 ; i <usergrid.columns.length; i++ )
				{
					usergrid.columns[i].setText(screenLabels[i]);
				}
				Ext.getCmp('print').setDisabled(false);
			}
			else
			{
				Ext.getCmp('print').setDisabled(true);
				Ext.getCmp('usergrid').hide();
				Ext.getCmp('emptyPanel').show();
			}
		}
		this.doSorting("DESC");
	},
	SubmitUserData : function()
	{
		var me = this;
		var report = Ext.getCmp('timeLineCombo').getValue();
		if(report == "Any period")
		{
			var hiddenFields = publicJSON['hiddenFields'];
			var sdate = Ext.getCmp('startdate_h');
			var edate = Ext.getCmp('enddate_h');
			var shr = hiddenFields.starthour;
			var ehr = hiddenFields.endhour;
			var smin = hiddenFields.startmin;
			var emin = hiddenFields.endmin;
			if(!checkblank(sdate.getValue()))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: pageIntn11 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				sdate.focus(true);
				return false;
			}
			else if(!checkblank(edate.getValue()))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: pageIntn12 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				edate.focus(true);
				return false;
			}
			else if((sdate != null) && (edate != null))
			{
				//var ssdate = formatDate(new Date(getDateFromFormat(sdate.getValue(),currentDateFormat)),"MM/dd/yyyy");
				//var eedate = formatDate(new Date(getDateFromFormat(edate.getValue(),currentDateFormat)),"MM/dd/yyyy");
				
				var ssdate = sdate.getValue();
				var eedate = edate.getValue();
				if(checkCurrentDate(s_mon+"/"+s_day+"/"+s_yr,ssdate,eedate))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: pageIntn13 + ".",
						width : 350,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false
				}
				else if((sdate.getValue() > edate.getValue()) || (sdate.getValue() < edate.getValue()))
				{
					if(!checkExtTime(ssdate,eedate,shr,ehr,smin,emin))
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: pageIntn14 + ".",
							width : 350,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return false
					}
				}

			}
		}
		var startdate = Ext.Date.dateFormat(Ext.getCmp('startdate').getValue(), mgrDateFormat);
		var enddate = Ext.Date.dateFormat(Ext.getCmp('enddate').getValue(), mgrDateFormat);
		var qrString = "getData=true&startdate="+encodeURIComponent(startdate)+"&enddate="+encodeURIComponent(enddate)+"&report="+report+"&action=go";

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		Ext.Ajax.request({
			url: 'EgUserRegReport/data/EgUserRegReportJson.jsp?'+qrString,
			method: 'POST',
			success: function( response )
			{
				var jsonText = response.responseText;
				var jsonData = '';
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					jsonData = Ext.decode(jsonText);
					var usergrid = Ext.getCmp('usergrid');
					var timeLineRawData = jsonData['userRegReports'];
					usergrid.getStore().loadRawData(timeLineRawData);
					me.doSorting("DESC");
					if (!Ext.isEmpty(timeLineRawData))
					{
						usergrid.show();
						Ext.getCmp('emptyPanel').hide()
						myMask.hide();
						var screenLabels = jsonData['gridColumns'];
						var gridTitle = jsonData['gridTitle'];
						usergrid.setTitle(gridTitle);
						for ( var i = 0 ; i <usergrid.columns.length; i++ )
						{
							usergrid.columns[i].setText(screenLabels[i]);
						}
						Ext.getCmp('print').setDisabled(false);
					}
					else
					{
						Ext.getCmp('print').setDisabled(true);
						usergrid.hide();
						Ext.getCmp('emptyPanel').show();
						myMask.hide();
					}
				}
			}
		});
	},
	loadTimeLineDetails : function(obj)
	{
		var report = Ext.getCmp('timeLineCombo').getValue();
		var qrString = "report="+report;
		if (report != null && report == "Any period")
		{
			Ext.getCmp('startdate').setDisabled(false);
			Ext.getCmp('enddate').setDisabled(false);
		}
		else
		{
			Ext.getCmp('startdate').setDisabled(true);
			Ext.getCmp('enddate').setDisabled(true);
			Ext.Ajax.request({
				url: 'EgUserRegReport/data/EgUserRegReportJson.jsp?'+qrString,
				method: 'POST',
				success: function( response )
				{
					var jsonText = response.responseText;
					var jsonData = '';
					if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
					{
						jsonData = Ext.decode(jsonText);
						// for start date
						var startDateVal = jsonData['startdate'];
						Ext.getCmp('startdate').setValue(startDateVal);

						// for start date
						var endDateVal = jsonData['enddate'];
						Ext.getCmp('enddate').setValue(endDateVal);
					}
				},
				failure : function(response)
				{
				}
			});
		}
		var usergrid = Ext.getCmp('usergrid');
		usergrid.getStore().removeAll();
		usergrid.hide();
		Ext.getCmp('emptyPanel').hide();
		Ext.getCmp('print').setDisabled(true);
	},

	doSorting : function(state)
	{
		var ds = Ext.getCmp('Userregistrationdate').up('tablepanel').store;
		var field =  Ext.getCmp('Userregistrationdate').getSortParam();
		customDateSorting(ds,state,field,userDateFormat);
		Ext.getCmp('usergrid').getView().refresh();
		var cssClassName = "x-column-header-sort-"+state;
		Ext.getCmp('Userregistrationdate').addCls(cssClassName);
	}
});



