Ext.define('EgUserRegReport.view.Main',{
	extend:'utilities.OuterPanel',
	alias:'widget.main',
	id:'user_reg_report',
	cls:'outerpanel',
	frame:true,
	border:true,
	title : pageTitle,
	margin :'8 8 0 8',

	requires: [
		'EgUserRegReport.view.UserRegTools',
		'EgUserRegReport.view.EmptyPanel',
		'utilities.CustomGrid'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	tools : [
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			items: [{
				xtype: 'button',
				iconCls: 'iconPrinter',
				id: 'print',
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Print'
						});
					}
				},
				style: {
					background: 'none',
					border: '0px'
				}
			}]
		}
	],

	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDescription+'</center>',
			}
		]
	}],

	items: [
		{
			xtype: 'userregtools'
		},
		/*{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '10 0 0 0',
			items: [
				{
					xtype: 'button',
					text : 'Go',
					cls: 'button20',
					id: 'submit'
				}
			]
		},*/
		{
			xtype: 'customgrid',
			name: 'usergrid',
			id : 'usergrid',
			title : 'User(s) registered between Aug 01, 2013 and Aug 08, 2013',
			cls:'gridSkin',
			autoScroll: true,
			store: new Ext.data.Store({
				fields: ['User ID', 'User registration date','User validity date','Mail ID/Mobile No','To','Cc','Bcc'],
				data: []
			}),
			flex: 1,
			columns: [
				{
					dataIndex: 'User ID',
					header: 'User ID',
					flex:1,
					listeners:{
						headerclick: function() {
							Ext.getCmp('Userregistrationdate').removeCls("x-column-header-sort-DESC");
						}
					},
					tdCls:'wrap-text'
				},
				{
					dataIndex: 'User registration date',
					header: 'User registration date',
					id: 'Userregistrationdate',
					flex:1,
					doSort: function(state) {
						appCnt.doSorting(state);
					},
					tdCls:'wrap-text'
				},
				{
					dataIndex: 'User validity date',
					header: 'User validity date',
					flex: 1,
					sortable : true,
					doSort: function(state) {
						Ext.getCmp('Userregistrationdate').removeCls("x-column-header-sort-DESC");
						var ds = this.up('tablepanel').store;
						var field = this.getSortParam();
						customDateSorting(ds,state,field,userDateFormat);
						Ext.getCmp('usergrid').getView().refresh();
						var cssClassName = "x-column-header-sort-"+state;
						this.addCls(cssClassName);
					},
					tdCls:'wrap-text'
				},
				{
					dataIndex: 'Mail ID/Mobile No',
					header:'Mail ID/Mobile No',
					sortable : true,
					width: 300,
					columns: [
						{
							dataIndex: 'To',
							header:'To',
							sortable : true,
							width: 100,
							tdCls:'wrap-text'
						},
						{
							dataIndex: 'Cc',
							header:'Cc',
							sortable : true,
							width: 100,
							tdCls:'wrap-text'
						},
						{
							dataIndex: 'Bcc',
							header:'Bcc',
							sortable : true,
							width: 100,
							tdCls:'wrap-text'
						}
					]
				}
			],
			hideHeaders: false,
			hidden: true,
			margin: 10
			//height: 408,
		},
		{
			xtype : 'emptypanel',
			border :false,
			hidden : true,
			id : 'emptyPanel'
		}
	]

});



