Ext.define('EgUserRegReport.view.UserRegTools',{
	extend:'Ext.container.Container',
	alias:'widget.userregtools',
	border:false,
	cls:'formOuter',
	border:true,
	frame:true,
	padding:'10 0 10 0',
	margin: '10 10 0 10',
	defaults:{
		labelSeparator:'',
		labelAlign: 'top'
	},

	requires : [
		'utilities.ScrollCombo',
		'utilities.DatePicker'
	],

	layout:
	{
		type : 'hbox',
		pack: 'center'
	},

	//margin: '10 0 0 0',

	items: [
		{
			fieldLabel:'Timeline',
			xtype:'scrollcombo',
			id: 'timeLineCombo',
			name: 'timeLineCombo',
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			editable : false,
			width: 150,
			store: Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			//cls: 'dropdown',
			value: 'Last week'
		},
		{
			xtype: 'datepicker',
			id: 'startdate',
			name: 'startdate',
			format: mgrDateFormat,
			fieldLabel:'Start date',
			cls: 'datepicker',
			disabled: true,
			editable : false,
			width: 150,
			margin: '0 0 0 20',
			listeners : {
				blur : function(obj,The,eOpts)
				{
					var selected = obj.getValue();
					var startdate_h = Ext.Date.dateFormat(selected, mgrDateFormat);
					if (startdate_h != null && startdate_h.length > 0)
					{
						var tmpDate = formatDate(new Date(getDateFromFormat(startdate_h,userDateFormat)),"MM/dd/yyyy");
						Ext.getCmp('startdate_h').setValue(tmpDate);
					}
				}
			}
		},
		{
			xtype: 'hiddenfield',
			name : 'startdate_h',
			id : 'startdate_h'
		},
		{
			xtype: 'hiddenfield',
			name : 'enddate_h',
			id : 'enddate_h'
		},
		{
			xtype: 'datepicker',
			id: 'enddate',
			name: 'enddate',
			format: mgrDateFormat,
			fieldLabel:'End date',
			cls: 'datepicker',
			disabled: true,
			editable : false,
			width: 150,
			margin: '0 0 0 20',
			listeners : {
				blur : function(obj,The,eOpts)
				{
					var selected = obj.getValue();
					var enddate_h = Ext.Date.dateFormat(selected, mgrDateFormat);
					if (enddate_h != null && enddate_h.length > 0)
					{
						var tmpDate = formatDate(new Date(getDateFromFormat(enddate_h,userDateFormat)),"MM/dd/yyyy");
						Ext.getCmp('enddate_h').setValue(tmpDate);
					}
				}
			}
		},
		{
			xtype: 'button',
			text : 'Go',
			margin: '20 0 0 10',
			cls: 'button20',
			id: 'submit'
		}
	]

});



