Ext.define('EgUserReports.controller.Main',{
	extend:'Ext.app.Controller',
	views:['UserReports','UserReportsConfiguration'],
	refs:[
		{selector:'userreports', ref:'userreports'},
		{selector:'userreportsconfiguration', ref:'userreportsconfiguration'}
	],

	init: function()
	{
		this.control({
			'userreports':
			{
				'afterrender': this.afterMainRender
			},
			'userreports combo[id="userTypeInView"]':
			{
				'select': this.userChange
			},
			'userreports combo[id="categoryType"]':
			{
				'select': this.categoryChange
			},
			'userreports combo[id="reportTypeInView"]':
			{
				'select': this.reportChange
			},
			'userreports combo[id="selectedCompType"]':
			{
				'select': this.compTypeChange
			},
			'userreports combo[id="selectedComp"]':
			{
				'select': this.compChange
			},
			'userreports button[id="addToSummary"]':
			{
				'click': this.addToSummary
			},
			'userreports button[id="addNew"]':
			{
				'click': this.addNew
			},
			'userreports actioncolumn[id="deleteInView"]':
			{
				'click': this.deleteTest
			},
			'userreports actioncolumn[id="updateInView"]':
			{
				'click': this.updateInView
			},
			'userreports grid[id="mainGrid"]':
			{
				//'itemmouseenter': this.onGridEnter,
				//'itemmouseleave': this.onGridLeave
			},

			//Code added to get events for add page in user reports
			'userreportsconfiguration combo[id="users"]':
			{
				'select': this.usersInAddChange
			},
			'userreportsconfiguration combo[id="category"]':
			{
				'select': this.categoryInAddChange
			},
			'userreportsconfiguration combo[id="reportType"]':
			{
				'select': this.reportInAddChange
			},
			'userreportsconfiguration combo[id="servers"]':
			{
				'select': this.compTypeInAddChange
			},
			'userreportsconfiguration combo[id="component"]':
			{
				'select': this.compInAddChange
			},
			'userreportsconfiguration combo[id="tests"]':
			{
				'select': this.testsInAddChange
			},
			'userreportsconfiguration button[id="addBtn"]':
			{
				'click': this.addMeasures
			},
			'userreportsconfiguration button[id="backbutton"]':
			{
				'click': this.goToView
			},
		});
	},

	afterMainRender: function()
	{
		var userTypeInViewObj = Ext.getCmp('userTypeInView');
		var viewStoreObj = Ext.getCmp('mainGrid');

		if (!Ext.isEmpty(userTypeFromSession) && userTypeFromSession != 'null')
		{
			Ext.getCmp('userTypeInView').setValue(userTypeFromSession);
		}
		else
		{
			Ext.getCmp('userTypeInView').setValue('Select the user');
		}

		if (Ext.isEmpty(catTypeFromSession) || catTypeFromSession == 'null' )
		{
			Ext.getCmp('categoryType').setValue('Choose category type');
		}
		else
		{
			Ext.getCmp('categoryType').setValue(catTypeFromSession);
		}

		if (!Ext.isEmpty(graphTypeFromSession) && graphTypeFromSession != 'null')
		{
			Ext.getCmp('reportTypeInView').setValue(graphTypeFromSession);
		}
		else
		{
			Ext.getCmp('reportTypeInView').setValue('Choose report type');
		}

		if (!Ext.isEmpty(serverTypeFromSession) && serverTypeFromSession != 'null')
		{
			Ext.getCmp('selectedCompType').setValue(serverTypeFromSession);
		}
		else
		{
			Ext.getCmp('selectedCompType').setValue('Select the component type');
		}

		var catType = Ext.getCmp('categoryType').getValue();
		var secType = 'User';

		var serverTypeObj = Ext.getCmp('selectedCompType');

		var serverType = Ext.getCmp('selectedCompType').getValue();

		var userTypeInView = Ext.getCmp('userTypeInView').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();

		if (catType == 'Application')
		{
			Ext.getCmp('selectedCompType').show();
		}

		if (graphType == 'Measure')
		{
			Ext.getCmp('addToSummary').setDisabled(false);
		}
		else
		{
			Ext.getCmp('addToSummary').setDisabled(true);
		}

		viewStoreObj.setTitle('Reports');

		var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=main&userType="+encodeURIComponent(userTypeInView)+"&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);
		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					userTypeInViewObj.getStore().loadRawData(jsonData.usersArrayJson);
					serverTypeObj.getStore().loadRawData(jsonData.compTypeArrayJson);

					var view = jsonData.summaryArrayJson;
					viewStoreObj.getStore().loadRawData(view);
				}
			}
		);
	},

	userChange: function()
	{
		Ext.getCmp('categoryType').setValue('Choose category type');
		Ext.getCmp('reportTypeInView').setValue('Choose report type');
		Ext.getCmp('selectedCompType').setValue('Select any component type');

		var catType = Ext.getCmp('categoryType').getValue();

		Ext.getCmp('addToSummary').setDisabled(true);

		Ext.getCmp('mainGrid').getStore().removeAll();

		gridTitle = 'Reports';
		Ext.getCmp('mainGrid').setTitle(gridTitle);

		if (catType == 'Choose category type')
		{
			gridTitle = 'Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'Network')
		{
			gridTitle = 'Network Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'System')
		{
			gridTitle = 'System Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'Application')
		{
			gridTitle = 'Application Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'Site')
		{
			gridTitle = 'Site Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}
	},

	categoryChange: function()
	{
		var compTypeObj = Ext.getCmp('selectedCompType');
		Ext.getCmp('reportTypeInView').setValue('Choose report type');
		Ext.getCmp('selectedCompType').setValue('Select any component type');

		Ext.getCmp('addToSummary').setDisabled(true);

		var userTypeInView = Ext.getCmp('userTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var secType = 'User';
		var valFlag = 'true';

		var serverTypeObj = Ext.getCmp('selectedCompType');

		if (catType == 'Application')
		{
			Ext.getCmp('selectedCompType').show();
		}
		else
		{
			Ext.getCmp('selectedCompType').hide();
		}

		if (Ext.isEmpty(userTypeInView) || userTypeInView == 'Select the user')
		{
			Ext.Msg.show({
				title: userReportsTitle,
				msg: alertforNoUser,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			valFlag = 'false';
			Ext.getCmp('categoryType').setValue('Choose category type');
			compTypeObj.hide();
		}

		var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=main&userType="+encodeURIComponent(userTypeInView)+"&catType="+catType+"&graphType="+graphType+"&secType="+secType;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					serverTypeObj.getStore().loadRawData(jsonData.compTypeArrayJson);

					if (catType == 'Choose category type')
					{
						gridTitle = 'Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Network' && valFlag == 'true')
					{
						gridTitle = 'Network Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'System' && valFlag == 'true')
					{
						gridTitle = 'System Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Application' && valFlag == 'true')
					{
						gridTitle = 'Application Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Site' && valFlag == 'true')
					{
						gridTitle = 'Site Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}
					Ext.getCmp('mainGrid').getStore().removeAll();
				}
			}
		);
	},

	reportChange: function()
	{
		Ext.getCmp('selectedCompType').setValue('Select any component type')

		var userTypeInView = Ext.getCmp('userTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var secType = 'User';
		var valFlag = 'true';

		var viewStoreObj = Ext.getCmp('mainGrid');

		if (graphType == 'Measure')
		{
			Ext.getCmp('addToSummary').setDisabled(false);
		}
		else
		{
			Ext.getCmp('addToSummary').setDisabled(true);
		}

		if (Ext.isEmpty(catType) || catType == 'Choose category type')
		{
			Ext.Msg.show({
				title: userReportsTitle,
				msg: alertforNoCategory,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			Ext.getCmp('reportTypeInView').setValue('Choose report type');
			valFlag = 'false';
		}

		if (catType == 'Choose category type')
		{
			gridTitle = 'Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'Network')
		{
			gridTitle = 'Network Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'System')
		{
			gridTitle = 'System Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'Application')
		{
			gridTitle = 'Application Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'Site')
		{
			gridTitle = 'Site Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=main&userType="+encodeURIComponent(userTypeInView)+"&catType="+catType+"&graphType="+graphType+"&secType="+secType;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var view = jsonData.summaryArrayJson;
					viewStoreObj.getStore().loadRawData(view);

					var gridTitle = jsonData.rootSummaryJson.title;

					if (catType == 'Application')
					{
						gridTitle = 'Application Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}
					else
					{
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Network' && graphType == 'Choose report type')
					{
						gridTitle = 'Network Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'System' && graphType == 'Choose report type')
					{
						gridTitle = 'System Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Application' && graphType == 'Choose report type')
					{
						gridTitle = 'Application Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Site' && graphType == 'Choose report type')
					{
						gridTitle = 'Site Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Network' && (Ext.isEmpty(view) || view.length == 0))
					{
						gridTitle = 'Network Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'System' && (Ext.isEmpty(view) || view.length == 0))
					{
						gridTitle = 'System Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Application' && (Ext.isEmpty(view) || view.length == 0))
					{
						gridTitle = 'Application Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Site' && (Ext.isEmpty(view) || view.length == 0))
					{
						gridTitle = 'Site Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (valFlag == 'false')
					{
						Ext.getCmp('mainGrid').setTitle('Reports');
					}
				}
			}
		);
	},

	compTypeChange: function()
	{
		var userTypeInView = Ext.getCmp('userTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var secType = 'User';

		var viewStoreObj = Ext.getCmp('mainGrid');

		if (Ext.isEmpty(graphType) || graphType == 'Choose report type')
		{
			Ext.getCmp('selectedCompType').setValue('Select any component type');
		}

		if (catType == 'Network' && serverType == 'Select the component')
		{
			gridTitle = 'Network Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
			Ext.getCmp('mainGrid').getStore().removeAll();
			return;
		}

		if (catType == 'System' && serverType == 'Select the component')
		{
			gridTitle = 'System Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
			Ext.getCmp('mainGrid').getStore().removeAll();
			return;
		}

		if (catType == 'Application' && serverType == 'Select the component')
		{
			gridTitle = 'Application Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
			Ext.getCmp('mainGrid').getStore().removeAll();
			return;
		}

		if (catType == 'Site' && serverType == 'Select the component')
		{
			gridTitle = 'Site Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
			Ext.getCmp('mainGrid').getStore().removeAll();
			return;
		}

		var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=main&userType="+encodeURIComponent(userTypeInView)+"&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					viewStoreObj.getStore().loadRawData(jsonData.summaryArrayJson);
					var viewArray = jsonData.summaryArrayJson;

					var gridTitle = jsonData.rootSummaryJson.title;
					Ext.getCmp('mainGrid').setTitle(gridTitle);

					if (catType == 'Network' && Ext.isEmpty(viewArray) && viewArray.length == 0)
					{
						gridTitle = 'Network Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
						Ext.getCmp('mainGrid').getStore().removeAll();
						return;
					}

					if (catType == 'System' && Ext.isEmpty(viewArray) && viewArray.length == 0)
					{
						gridTitle = 'System Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
						Ext.getCmp('mainGrid').getStore().removeAll();
						return;
					}

					if (catType == 'Application' && Ext.isEmpty(viewArray) && viewArray.length == 0)
					{
						gridTitle = 'Application Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
						Ext.getCmp('mainGrid').getStore().removeAll();
						return;
					}

					if (catType == 'Site' && Ext.isEmpty(viewArray) && viewArray.length == 0)
					{
						gridTitle = 'Site Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
						Ext.getCmp('mainGrid').getStore().removeAll();
						return;
					}
				}
			}
		);
	},

	addToSummary: function()
	{
		var userType = Ext.getCmp('userTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var graphTypeObj = Ext.getCmp('reportTypeInView');
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var secType = 'User';

		var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=main&userType="+encodeURIComponent(userType)+"&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType)+"&userType="+encodeURIComponent(userType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var lenForApplySummary = jsonData.applyToSummaryJson.length;
					for (var i=0; i<lenForApplySummary; i=i+2)
					{
						var variable = jsonData.applyToSummaryJson[i];

						var urlForSummary = 
						"/final/admin/EgUserReports/data/EguserreportsJSONp.jsp?mode=main&varMeas="+variable+"&applytosum=true"+"&catType="+catType+"&reportType="+graphType+"&secType=Specific&servers="+encodeURIComponent(serverType)+"&users="+encodeURIComponent(userType)+"&component="+encodeURIComponent(serverType);

						Ext.Ajax.request(
						{
							url : urlForSummary,
							scope:this,
							method : 'POST',
							success: function(response){
								Ext.getCmp('addToSummary').setDisabled(true);
								graphTypeObj.setValue('Summary');

								graphTypeForTitle = 'Summary';
								var urlForTitle = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=main&userType="+encodeURIComponent(userType)+"&catType="+catType+"&graphType="+graphTypeForTitle+"&secType="+secType+"&serverType="+encodeURIComponent(serverType)+"&userType="+encodeURIComponent(userType);

								Ext.Ajax.request(
								{
									url : urlForTitle,
									scope:this,
									method : 'POST',
									success: function(response){
										var jsonText = response.responseText;
										var jsonData = Ext.decode(jsonText);

										var gridTitle = jsonData.rootSummaryJson.title;
										Ext.getCmp('mainGrid').setTitle(gridTitle);

									}
								});

								
							}
						});
					}
				}
			}
		);
	},

	addNew: function()
	{
		var mainViewId = Ext.getCmp('mainView');

		mainViewId.getLayout().setActiveItem(1);

		var testsObj = Ext.getCmp('tests');

		Ext.getCmp('users').setValue('Select the user');
		Ext.getCmp('category').setValue('Choose category type');
		Ext.getCmp('reportType').setValue('Choose report type');
		Ext.getCmp('component').setValue('Select the component');
		Ext.getCmp('tests').setValue('Select the test');

		var userType = Ext.getCmp('users').getValue();

		var componentObj = Ext.getCmp('component');
		var serverTypeObj = Ext.getCmp('servers');

		var serverType = '';
		isItemUpdated = false;

		// to get the selections from view into add new page
		var userInView = Ext.getCmp('userTypeInView').getValue();
		var categoryInView = Ext.getCmp('categoryType').getValue();
		var reportTypeInView = Ext.getCmp('reportTypeInView').getValue();
		var componentInView = Ext.getCmp('selectedComp').getValue();
		var compTypeInView = Ext.getCmp('selectedCompType').getDisplayValue();
		var secType = 'User';

		Ext.getCmp('category').setValue(categoryInView);
		Ext.getCmp('reportType').setValue(reportTypeInView);

		var usersObj = Ext.getCmp('users');
		var categoryObj = Ext.getCmp('category');
		var reportTypeObj = Ext.getCmp('reportType');
		var componentObj = Ext.getCmp('component');

		var serverTypeObj = Ext.getCmp('servers');

		if (categoryInView != 'Application')
		{
			serverTypeObj.hide();
		}
		else
		{
			serverTypeObj.show();
		}

		usersObj.setValue(userInView);
		categoryObj.setValue(categoryInView);
		reportTypeObj.setValue(reportTypeInView);
		serverTypeObj.setValue(compTypeInView);
		// End of to get the selections

		var componentInView = Ext.getCmp('component').getValue();
		var compNameInView = Ext.getCmp('component').getDisplayValue();
		var catType = Ext.getCmp('category').getValue();

		if (catType != 'Application' || catType == 'Choose category type')
		{
			serverTypeObj.hide();
			componentObj.hide();
		}
		else
		{
			serverTypeObj.show();
			componentObj.show();
			serverTypeObj.setValue('Select the component type');
			serverType = Ext.getCmp('selectedCompType').getValue();
		}

		var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=addnew&userType="+encodeURIComponent(userInView)+"&catType="+categoryInView+"&graphType="+reportTypeInView+"&secType="+secType+"&comType="+encodeURIComponent(componentInView)+"&comName="+encodeURIComponent(compNameInView)+"&serverType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					usersObj.getStore().loadRawData(jsonData.usersArrayJson);

					componentObj.getStore().loadRawData(jsonData.compArrayJson);
					componentObj.setValue(componentInView);

					serverTypeObj.getStore().loadRawData(jsonData.compTypeArrayJson);
					serverTypeObj.setValue(serverType);

					var testsArray = '';

					if (catType == 'Site' || categoryInView == 'Site')
					{
						testsArray = jsonData.siteTestsArrayJson;
						testsObj.getStore().loadRawData(testsArray);
					}
					else
					{
						testsArray = jsonData.testsArrayJson;
						testsObj.getStore().loadRawData(testsArray);
					}

					Ext.getCmp('itemselectTests').getStore().removeAll();
					Ext.getCmp('itemselectTests').setValue(' ');
				}
			}
		);
	},

	usersInAddChange: function()
	{
		Ext.getCmp('category').setValue('Choose category type');
		Ext.getCmp('reportType').setValue('Choose report type');
		Ext.getCmp('servers').setValue('Select the component type');
		Ext.getCmp('component').setValue('Select the component');
		Ext.getCmp('tests').setValue('Select the test');
	},

	categoryInAddChange: function()
	{
		var userType = Ext.getCmp('users').getValue();
		var catType = Ext.getCmp('category').getValue();
		var secType = 'User';

		var componentObj = Ext.getCmp('component');
		var serverTypeObj = Ext.getCmp('servers');

		Ext.getCmp('reportType').setValue('Choose report type');
		Ext.getCmp('servers').setValue('Select the component type');
		Ext.getCmp('component').setValue('Select the component');
		Ext.getCmp('tests').setValue('Select the test');

		if (catType != 'Application' || catType == 'Choose category type')
		{
			serverTypeObj.hide();
			componentObj.hide();
		}
		else
		{
			serverTypeObj.show();
			componentObj.show();
			serverTypeObj.setValue('Select the component type');
			serverType = Ext.getCmp('selectedCompType').getValue();
		}

		if (Ext.isEmpty(userType) || userType == 'Select the user')
		{
			Ext.Msg.show({
				title: userReportsTitle,
				msg: alertforNoUser,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=addnew&userType="+encodeURIComponent(userType)+"&catType="+catType+"&secType="+secType;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					serverTypeObj.getStore().loadRawData(jsonData.compTypeArrayJson);
				}
			}
		);
	},

	reportInAddChange: function()
	{
		var userType = Ext.getCmp('users').getValue();
		var catType = Ext.getCmp('category').getValue();
		var graphType = Ext.getCmp('reportType').getValue();

		var compObj = Ext.getCmp('component');
		var testsObj = Ext.getCmp('tests');
		var serverTypeObj = Ext.getCmp('servers');
		var secType = 'User';

		Ext.getCmp('servers').setValue('Select the component type');
		Ext.getCmp('component').setValue('Select the component');
		Ext.getCmp('tests').setValue('Select the test');

		if (Ext.isEmpty(catType) || catType == 'Choose category type')
		{
			Ext.Msg.show({
				title: userReportsTitle,
				msg: alertforNoCategory,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=addnew&userType="+encodeURIComponent(userType) +"&catType="+catType+"&graphType="+graphType+"&secType="+secType;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					serverTypeObj.getStore().loadRawData(jsonData.compTypeArrayJson);
					compObj.getStore().loadRawData(jsonData.compArrayJson);

					var testsArray = '';

					if (catType == 'Site')
					{
						testsArray = jsonData.siteTestsArrayJson;
						testsObj.getStore().loadRawData(testsArray);
					}
					else
					{
						testsArray = jsonData.testsArrayJson;
						testsObj.getStore().loadRawData(testsArray);
					}
				}
			}
		);
	},

	compTypeInAddChange: function()
	{
		var userType = Ext.getCmp('users').getValue();
		var catType = Ext.getCmp('category').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var secType = 'User';

		var serverType = Ext.getCmp('servers').getValue();
		var componentObj = Ext.getCmp('component');

		Ext.getCmp('component').setValue('Select the component');
		Ext.getCmp('tests').setValue('Select the test');

		if (Ext.isEmpty(catType) || catType == 'Choose category type')
		{
			Ext.Msg.show({
				title: reportsConfigTitle,
				msg: alertforNoCategory,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		if (Ext.isEmpty(graphType) || graphType == 'Choose report type')
		{
			Ext.Msg.show({
				title: reportsConfigTitle,
				msg: alertforNoType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=addnew&userType="+encodeURIComponent(userType) +"&catType="+catType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					componentObj.getStore().loadRawData(jsonData.compArrayJson);
				}
			}
		);
	
	},

	compInAddChange: function()
	{
		var userType = Ext.getCmp('users').getValue();
		var catType = Ext.getCmp('category').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var serverType = Ext.getCmp('servers').getValue();
		var comType = Ext.getCmp('component').getValue();
		var comName = Ext.getCmp('component').getDisplayValue();
		var secType = 'User';

		var testsObj = Ext.getCmp('tests');

		Ext.getCmp('tests').setValue('Select the test');

		var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=addnew&userType="+encodeURIComponent(userType) +"&catType="+catType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					testsObj.getStore().loadRawData(jsonData.serverTestsArrayJson);
				}
			}
		);
	},

	testsInAddChange: function()
	{
		var userType = Ext.getCmp('users').getValue();
		var catType = Ext.getCmp('category').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var serverType = Ext.getCmp('servers').getValue();
		var comType = Ext.getCmp('component').getValue();
		var comName = Ext.getCmp('component').getDisplayValue();

		var tests = Ext.getCmp('tests').getValue();
		var secType = 'User';

		var itemSelectObj = Ext.getCmp('itemselectTests');
		var testObj = Ext.getCmp('tests');
		var catTypeObj = Ext.getCmp('category');
		var graphTypeObj = Ext.getCmp('reportType');

		if (Ext.isEmpty(userType) || userType == 'Select the user')
		{
			Ext.Msg.show({
				title: reportsConfigTitle,
				msg: alertforNoUser,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			testObj.setValue('Select the test');
			catTypeObj.setValue('Choose category type');
			graphTypeObj.setValue('Choose report type');
			return;
		}

		if (Ext.isEmpty(catType) || catType == 'Choose category type')
		{
			Ext.Msg.show({
				title: reportsConfigTitle,
				msg: alertforNoType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			testObj.setValue('Select the test');
			catTypeObj.setValue('Choose category type');
			return;
		}

		if (Ext.isEmpty(graphType) || graphType == 'Choose report type')
		{
			Ext.Msg.show({
				title: reportsConfigTitle,
				msg: alertforNoType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			testObj.setValue('Select the test');
			catTypeObj.setValue('Choose category type');
			graphTypeObj.setValue('Choose report type');
			return;
		}

		if (catType == 'Application')
		{
			if (Ext.isEmpty(serverType) || serverType == 'Select the component type')
			{
				Ext.Msg.show({
					title: reportsConfigTitle,
					msg: alertforNoComponent,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});

				testObj.setValue('Select the test');
				return;
			}
		}

		if (catType == 'Application')
		{
			if (Ext.isEmpty(comType) || comType == 'Select the component')
			{
				Ext.Msg.show({
					title: reportsConfigTitle,
					msg: alertforNoComponent,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});

				testObj.setValue('Select the test');
				return;
			}
		}

		var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=addnew&userType="+encodeURIComponent(userType) +"&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&tname="+tests+"&serverType="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var tests = testObj.getValue();
					var allMeasures = jsonData.allRealMeasuresArrayJson;
					var disAssociatedMeasures = jsonData.disAssocRealMeasuresArrayJson;
					itemSelectObj.getStore().loadRawData(allMeasures);
					itemSelectObj.setValue(disAssociatedMeasures);

					if (tests == 'Select the test')
					{
						itemSelectObj.getStore().loadRawData(' ');
						itemSelectObj.setValue(' ');
					}

				}
			}
		);
	},

	goToView: function()
	{
		var userType = Ext.getCmp('userTypeInView').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var comType = Ext.getCmp('selectedComp').getValue();
		var comName = Ext.getCmp('selectedComp').getDisplayValue();
		var secType = 'User';

		var userTypeObj = Ext.getCmp('userTypeInView');
		var graphTypeObj = Ext.getCmp('reportTypeInView');
		var catTypeObj = Ext.getCmp('categoryType');
		var serverTypeObj = Ext.getCmp('selectedCompType');
		var comTypeObj = Ext.getCmp('selectedComp');
		var comNameObj = Ext.getCmp('selectedComp');

		var mainViewId = Ext.getCmp('mainView');

		mainViewId.getLayout().setActiveItem(0);

		//code added for the view after back button
		var viewStoreObj = Ext.getCmp('mainGrid');

		var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=main&userType="+ userType+"&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var viewArray = jsonData.summaryArrayJson;
					var viewArrayLength = jsonData.summaryArrayJson.length;

					viewStoreObj.getStore().loadRawData(viewArray);

					userTypeObj.setValue(userType);
					graphTypeObj.setValue(graphType);
					catTypeObj.setValue(catType);
					serverTypeObj.setValue(serverType);
					comTypeObj.setValue(comType);
				}
			}
		);
	},

	addMeasures: function()
	{
		var secType = 'User';
		var deleteTest = "";
		var hassociated = "";
		var hdisassociated = "";

		var valFlag = "true";

		var userType = Ext.getCmp('users').getValue();
		var reportType = Ext.getCmp('reportType').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var catType = Ext.getCmp('category').getValue();
		var comType = Ext.getCmp('component').getValue();
		var comName = Ext.getCmp('component').getDisplayValue();

		var userTypeObj = Ext.getCmp('userTypeInView');
		var categoryInViewObj = Ext.getCmp('categoryType');
		var componentObj = Ext.getCmp('selectedComp');
		var reportTypeInViewObj = Ext.getCmp('reportTypeInView');
		var compTypeInViewObj = Ext.getCmp('selectedCompType');

		if(Ext.isEmpty(catType) || catType == 'Choose category type')
		{
			valFlag = 'false';

			Ext.Msg.show({
				title: reportsConfigTitle,
				msg: alertforNoCategory,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		var serverType = Ext.getCmp('servers').getValue();
		var testName = Ext.getCmp('tests').getValue();
		var tests = Ext.getCmp('tests').getValue();

		if (Ext.isEmpty(graphType) || graphType == 'Choose report type')
		{
			valFlag = 'false';

			Ext.Msg.show({
				title: reportsConfigTitle,
				msg: alertforNoType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		if (Ext.isEmpty(testName) || testName == 'Select the test')
		{
			valFlag = 'false';

			Ext.Msg.show({
				title: reportsConfigTitle,
				msg: alertforNoTest,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		if (catType == 'Application')
		{
			if (Ext.isEmpty(serverType) || serverType == 'Select the component')
			{
				valFlag = 'false';

				Ext.Msg.show({
					title: reportsConfigTitle,
					msg: alertforNoComponent,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
		}

		if ( !isItemUpdated )
		{
			Ext.Msg.show({
				title: reportsConfigTitle,
				msg: alertForMeasureSelection,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			valFlag = 'false';
		}

		var disassociatedMeasures = Ext.getCmp('itemselectTests').getValue();

		var lenDisAssoc;
		if (!Ext.isEmpty(disassociatedMeasures))
		{
			lenDisAssoc = disassociatedMeasures.length;
		}
		var disassociatedMeasuresArray = new Array();
		var associatedMeasuresArray = new Array();
		var allValueArray = new Array();
		var i;

		for (var i=0;i<Ext.getCmp('itemselectTests').getStore().getCount();i++)
		{
			var allValue = Ext.getCmp('itemselectTests').getStore().getAt(i).get('valueField');
			allValueArray[i] = allValue;
		}

		for (i=0;i<lenDisAssoc; i++)
		{
			var adisAssocMeasure = disassociatedMeasures[i];
			disassociatedMeasuresArray[i] = adisAssocMeasure;
		}

		var k = 0;
		for (var i=0;i<Ext.getCmp('itemselectTests').getStore().getCount();i++)
		{
			var allValue = Ext.getCmp('itemselectTests').getStore().getAt(i).get('valueField');
			for (var j=0;j<disassociatedMeasures.length;j++)
			{
				var isData = false;
				if (allValue == disassociatedMeasures[j])
				{
					isData = true;
					break;
				}
			}
			if (!isData)
			{
				associatedMeasuresArray[associatedMeasuresArray.length]=allValue;
			}
		}

		if (valFlag == 'true')
		{
			var url = "/final/admin/EgUserReports/data/EguserreportsJSONp.jsp?mode=main&userType="+encodeURIComponent(userType)+"&users="+encodeURIComponent(userType)+"&catType="+catType+"&secType="+secType+"&reportType="+reportType+"&serverType="+encodeURIComponent(serverType)+"&testName="+testName+"&tests="+tests+"&hassociatem="+associatedMeasuresArray+"&hdisassociatem="+disassociatedMeasuresArray+"&deleteTest="+deleteTest+"&hassociated="+hassociated+"&hdisassociated="+hdisassociated+"&servers="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName)+"&component="+encodeURIComponent(comType);

			Ext.Ajax.request(
				{
					url : url,
					scope: this,
					method : 'POST',
					success: function(response){
						var mainViewId = Ext.getCmp('mainView');

						mainViewId.getLayout().setActiveItem(0);

						var viewStoreObj = Ext.getCmp('mainGrid');

						var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=main&userType="+encodeURIComponent(userType)+"&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName);

						Ext.Ajax.request(
							{
								url : url,
								scope:this,
								method : 'POST',
								success: function(response){
									var jsonText = response.responseText;
									var jsonData = Ext.decode(jsonText);

									var viewArray = jsonData.summaryArrayJson;
									var viewArrayLength = jsonData.summaryArrayJson.length;

									if (catType == 'Application')
									{
										compTypeInViewObj.show();
									}
									else
									{
										compTypeInViewObj.hide();
									}

									viewStoreObj.getStore().loadRawData(viewArray);
									compTypeInViewObj.getStore().loadRawData(jsonData.compTypeArrayJson);

									userTypeObj.setValue(userType);
									categoryInViewObj.setValue(catType);
									reportTypeInViewObj.setValue(graphType);
									compTypeInViewObj.setValue(serverType);

									if (graphType == 'Measure')
									{
										Ext.getCmp('addToSummary').setDisabled(false);
									}
									else
									{
										Ext.getCmp('addToSummary').setDisabled(true);
									}

									var gridTitle = jsonData.rootSummaryJson.title;
									Ext.getCmp('mainGrid').setTitle(gridTitle);
								}
							}
						);
					}
				}
			);
		}
	},

	deleteTest: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var secType = 'User';
		var hassociated = '';
		var hdisassociated = '';
		var testValueName = '';
		var testName = '';
		var tests = '';

		var associatedMeasuresArray = new Array();
		var disassociatedMeasuresArray = new Array();
		var allValueArray = new Array();
		var deleteTest = 'yes';

		/* code added to get the selected test name */
		var viewStoreObj = Ext.getCmp('mainGrid');

		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);

		var displaytestName = record.get('Test');
		var displaytests = record.get('Test');

		associatedMeasuresArray = record.get('Measures');
		// End of code added 

		var userType = Ext.getCmp('userTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();

		var reportType = Ext.getCmp('reportTypeInView').getValue();
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var comType = Ext.getCmp('selectedComp').getValue();
		var comName = Ext.getCmp('selectedComp').getDisplayValue();

		Ext.MessageBox.confirm(userReportsTitle,alertForDeleteConfirmation, function(id) {
			if (id == 'yes')
			{
				var urlTest = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=main&userType="+encodeURIComponent(userType)+"&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);

				Ext.Ajax.request(
				{
					url : urlTest,
					scope:this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						var testArray = '';

						if (catType == 'Site')
						{
							testArray = jsonData.siteTestsArrayJson;
						}
						else
						{
							testArray = jsonData.testsArrayJson;
						}

						for (var i=0;i<testArray.length;i++)
						{
							var allValue = testArray[i].displayField;

							if (displaytestName == allValue)
							{
								testValueName = testArray[i].valueField;
							}
						}
						testName = testValueName;
						tests = testValueName;

						var url = "/final/admin/EgUserReports/data/EguserreportsJSONp.jsp?mode=main&users="+ userType+"&catType="+catType+"&secType="+secType+"&reportType="+reportType+"&serverType="+encodeURIComponent(serverType)+"&testName="+testName+"&tests="+tests+"&hassociatem="+associatedMeasuresArray+"&hdisassociatem="+disassociatedMeasuresArray+"&deleteTest="+deleteTest+"&hassociated="+hassociated+"&hdisassociated="+hdisassociated+"&servers="+encodeURIComponent(serverType)+"&testNameForDelInView="+displaytestName+"&component="+encodeURIComponent(serverType);

						Ext.Ajax.request(
						{
							url : url,
							scope: this,
							method : 'POST',
							success: function(response){
								var urlForSummary = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=main&userType="+encodeURIComponent(userType)+"&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType)+"&comType="+encodeURIComponent(comType)+"&comName="+encodeURIComponent(comName);

								Ext.Ajax.request(
								{
									url : urlForSummary,
									scope:this,
									method : 'POST',
									success: function(response){

										var jsonText = response.responseText;
										var jsonData = Ext.decode(jsonText);

										var viewArray = jsonData.summaryArrayJson;
										var viewArrayLength = jsonData.summaryArrayJson.length;

										viewStoreObj.getStore().loadRawData(viewArray);
									}
								});
							}
						});
					}
				});
			}
		});
	},

	updateInView: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var testRealName = '';
		isItemUpdated = false;

		/* code added to get the selected test name */
		var viewStoreObj = Ext.getCmp('mainGrid');

		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);

		var displaytestName = record.get('Test');
		var displaytests = record.get('Test');

		associatedMeasuresArray = record.get('Measures');
		// End of code added 

		var userTypeInView = Ext.getCmp('userTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		//var siteType = Ext.getCmp('tests').getValue();
		var serverType = '';

		var serverTypeObj = Ext.getCmp('servers');
		var componentObj = Ext.getCmp('component');
		var itemSelectObj = Ext.getCmp('itemselectTests');
		if (catType == 'Application')
		{
			serverType = Ext.getCmp('selectedCompType').getValue();
			serverTypeObj.show();
			componentObj.show();
		}
		else
		{
			serverTypeObj.hide();
			componentObj.hide();
		}

		var secType = 'User';

		var mainViewId = Ext.getCmp('mainView');
		mainViewId.getLayout().setActiveItem(1);

		Ext.getCmp('users').setValue(userTypeInView);
		Ext.getCmp('category').setValue(catType);
		Ext.getCmp('reportType').setValue(graphType);
		Ext.getCmp('servers').setValue(serverType);

		var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=addnew&userType="+encodeURIComponent(userTypeInView)+"&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					if (catType == 'Application')
					{
						Ext.getCmp('servers').getStore().loadRawData(jsonData.compTypeArrayJson);
						Ext.getCmp('servers').setValue(serverType);
						Ext.getCmp('component').getStore().loadRawData(jsonData.compArrayJson);
						Ext.getCmp('component').setValue(jsonData.compArrayJson[0].displayField);
						var serverTests = jsonData.serverTestsArrayJson;
						//Ext.getCmp('tests').getStore().loadRawData(serverTests);

						for (var i=0; i<jsonData.serverTestsArrayJson.length; i++)
						{
							var aTest = jsonData.serverTestsArrayJson[i].displayField;

							if (displaytestName == aTest)
							{
								testRealName = jsonData.serverTestsArrayJson[i].valueField;
							}
						}
						Ext.getCmp('tests').setValue('Select the test');
					}
					else if (catType == 'Site')
					{
						var siteTests = jsonData.siteTestsArrayJson;
						Ext.getCmp('tests').getStore().loadRawData(siteTests);

						for (var i=0; i<jsonData.siteTestsArrayJson.length; i++)
						{
							var aTest = jsonData.siteTestsArrayJson[i].displayField;

							if (displaytestName == aTest)
							{
								testRealName = jsonData.siteTestsArrayJson[i].valueField;
								Ext.getCmp('tests').setValue(testRealName);
								break;
							}
							else
							{
								Ext.getCmp('tests').setValue('Select the test');
							}
						}
					}
					else
					{
						Ext.getCmp('tests').getStore().loadRawData(jsonData.testsArrayJson);
						Ext.getCmp('tests').setValue('Select the test');

						for (var i=0; i<jsonData.testsArrayJson.length; i++)
						{
							var aTest = jsonData.testsArrayJson[i].displayField;


							if (displaytestName == aTest)
							{
								testRealName = jsonData.testsArrayJson[i].valueField;
								Ext.getCmp('tests').setValue(testRealName);
								break;
							}
							else
							{
								Ext.getCmp('tests').setValue('Select the test');
							}
						}
						
						//Ext.getCmp('tests').setValue(displaytestName);
					}
					
					var url = "/final/admin/EgUserReports/data/EgUserReportsJSON.jsp?mode=addnew&userType="+encodeURIComponent(userTypeInView) +"&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&tname="+testRealName+"&serverType="+encodeURIComponent(serverType);

					Ext.Ajax.request(
						{
							url : url,
							scope:this,
							method : 'POST',
							success: function(response){
								var jsonText = response.responseText;
								var jsonData = Ext.decode(jsonText);

								var allMeasures = jsonData.allRealMeasuresArrayJson;
								var disAssociatedMeasures = jsonData.disAssocRealMeasuresArrayJson;
								itemSelectObj.getStore().loadRawData(allMeasures);
								itemSelectObj.setValue(disAssociatedMeasures);

							}
						}
					);
				}
			}
		);
	},

	onGridEnter: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
			Ext.each(icons, function(icon){
				Ext.get(icon).removeCls('x-hidden');
		});
	},

	onGridLeave: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		});
	},
});



