Ext.define('EgUserReports.view.UserReports', {
	extend: 'Ext.form.Panel',
	alias: 'widget.userreports',
	cls:'outerpanel',
	title: userReportsTitle,
	frame:true,
	border:true,
	margin: '8 8 0 8',
	//frame: true,
	header:{cls:'zonereporthead'},
	requires:['utilities.ScrollCombo','utilities.CustomGrid'],
	layout: {
		type: 'vbox',
		align:'stretch'
	},

	items: [
		{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;'+ userReportsDesc +'</center>',
			width:'100%',
			height: 25,
			padding: 3
		},
		{
			xtype: 'container',
			cls:'formOuter',
			padding:'5 0 5 0',
			margin: '10 10 0 10',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: userLabel,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 220,
					margin: '10 0 5 0',
					editable: false,
					forceSelection: false,
					id: 'userTypeInView',
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : []
					}),
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField'
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: categoryLabel,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 150,
					margin: '10 0 5 20',
					editable: false,
					id: 'categoryType',
					store: ['Choose category type','Network','System','Application','Site']
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: reportTypeLabel,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 150,
					margin: '10 0 5 20',
					editable: false,
					id: 'reportTypeInView',
					store: ['Choose report type','Measure','Summary']
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: componentTypeLabel,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 220,
					margin: '10 0 5 20',
					editable: false,
					forceSelection: false,
					id: 'selectedCompType',
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : []
					}),
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					hidden: true
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: componentLabel,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 220,
					margin: '10 0 5 20',
					editable: false,
					forceSelection: false,
					id: 'selectedComp',
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : []
					}),
					queryMode: 'local',
					displayField: 'displayField',
					valueField: 'valueField',
					hidden: true
				}
			]
		},
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id: 'mainGrid',
			store: new Ext.data.Store({
				fields : ['Test', 'Measures'],
				data : []
			}),
			flex: 1,
			autoScroll: false,
			scroll:true,
			//viewConfig: {
			//	deferEmptyText: true
			//},
			//emptyText: "<table border='0' height='350px' width='100%'><tr><td align=center valign=middle><img src='/final/images/spacer.gif' class='iconInformation'><div class='commonErrorMsgText'>No Data Found</div></td></tr></table>",
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: testText,
						dataIndex: 'Test',
						width: 280
					},
					{
						text: measuresText,
						dataIndex: 'Measures',
						flex: 1,
						renderer : function(value) {
							return '<table width="100%" cellspacing="0" cellpadding="0"><tr><td valign="top" style="font-size:8pt;font-family:Tahoma,Calibri,Arial,Helvetica,sans-serif;">'+value+'</td></tr></table>';
						}
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-edit-column-header',
						width: 36,
						//icon: '../../../../resources/images/edit_task.png',
						iconCls: 'iconModify',
						//tooltip: 'Modify',
						sortable: false,
						id: 'updateInView',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
						}
						//handler: Ext.bind(this.handleEditClick, this),
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 36,
						//icon: '../../../../resources/images/delete.png',
						iconCls: 'iconDelete',
						//tooltip: 'Delete',
						sortable: false,
						id: 'deleteInView',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
						}
						//handler: Ext.bind(this.handleEditClick, this),
					}
				]
			},
			margin: 10,
			tools:[
			{
				xtype: 'button',
				cls:'button20',
				text: addNewBtn,
				id: 'addNew',
				margin:'0 10 0 0'
			},
			{
				xtype: 'button',
				cls:'button20',
				text: measuresBtn,
				id: 'addToSummary',
				disabled: true
			}]
		}
	]

});



