Ext.define('EgViewRoles.controller.Main',{
	extend: 'Ext.app.Controller',
	views:[	
		'Main',
		'UserRoleContainer',
		'AddUserRole',
		'UserRolesGroupedSummaryGrid',
		'UserDefinedGroupedSummaryGrid',
		'EmptyPanel'
	],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'main #strSearch', ref:'searchBox'},
		{selector:'main #strSearch1', ref:'userSearchBox'},
		{selector:'userrolecontainer', ref:'userrolecontainer'},
		{selector:'userrolesgroupedsummarygrid', ref:'userrolesgroupedsummarygrid'},
		{selector:'userdefinedgroupedsummarygrid', ref:'userdefinedgroupedsummarygrid'},
		{selector:'adduserrole', ref:'adduserrole'}
	],
	init:function()
	{
		appCtn = this;
		this.rowBodyTrSelector = '.x-grid-rowbody-tr';
		this.rowBodyHiddenCls = 'x-grid-row-body-hidden';
		this.rowCollapsedCls = 'x-grid-row-collapsed';
		this.recordsExpanded = {};
		this.isViewExpaned = false;
		this.isViewExpaned2 = false;
		this.buildMainData();

		this.control({
			
			'main':
			{
				'afterrender': this.initDefaultConfigs
			},
			'main button[id="role"]':
			{
				'click':this.addNewUserRole
			},
			'adduserrole button[id="back"]':
			{
				'click':this.historyBack
			},
			'main trigger[id="strSearch"]':
			{
				'change':this.onTriggerChange
			},
			'main trigger[id="strSearch1"]':
			{
				'change':this.onTriggerChange1
			},
			'userrolesgroupedsummarygrid': 
			{
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			'userdefinedgroupedsummarygrid':
			{
				//'itemmouseenter': this.showActionsOnIME,
				//'itemmouseleave': this.hideActionsOnIML
			},
			'userdefinedgroupedsummarygrid button[id="showAll"]':
			{
				'click':this.showAllPreUsers
			},
			'userrolesgroupedsummarygrid button[id="showAllUsers"]':
			{
				'click':this.showAllUsers
			},
			'adduserrole radiogroup[id="accessGroup"]':
			{
				'change':this.componentAccessController
			},
			'adduserrole button[id="updateRole"]':
			{
				'click':this.submitUserDetails
			},
			'adduserrole checkboxfield[boxLabel="Component Management"]': {
				'change' : this.checkCompMgmt
			},
			'adduserrole checkboxfield[boxLabel="External/Remote Agent Configuration"]': {
				'change' : this.uncheckCompMgmt
			},
		})
	},
	resetSearchCtls : function(tabPanel)
	{
		this.getSearchBox().reset();
	},
	tabchange : function(tabPanel)
	{
		var tab = tabPanel.getActiveTab().itemId;
		Ext.Ajax.request({
			url: 'EgViewRoles/data/viewroleshelpJson.jsp?selectedTab='+tab,
			method: 'POST',
			async: false
		});
	},
	buildMainData : function()
	{
		if (defaultUrl.indexOf("&date=") == -1)
		{
			defaultUrl = defaultUrl + "&date="+new Date().getTime();
		}
		Ext.Ajax.request({
			url : defaultUrl+'&selectedTab=tab1',
			method : 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	isUserAvailable : function(rowNode, record, expandRow, eOpts,fromNode)
	{
		var thisGrid = Ext.getCmp('userrolesgroupedsummarygrid')
		var selectedRoleName = record.get("userRoleCategory");
		if (record.get('hasUsers') != true)
		{
			row = Ext.get(rowNode);
			nextBd = Ext.get(row).down(this.rowBodyTrSelector);
			record = thisGrid.view.getRecord(rowNode);
			if (!row.hasCls(this.rowCollapsedCls)) {
				row.addCls(this.rowCollapsedCls);
				nextBd.addCls(this.rowBodyHiddenCls);
				this.recordsExpanded[record.internalId] = false;
				thisGrid.view.fireEvent('collapsebody', rowNode, record, nextBd.dom);
			}
		}
		this.getMain().doLayout();
	},
	isPreUserAvailable : function(rowNode, record, expandRow, eOpts,fromNode)
	{
		var thisGrid = Ext.getCmp('userdefinedgroupedsummarygrid')
		var selectedRoleName = record.get("userRoleCategory");
		if (record.get('hasUsers') != true)
		{
			row = Ext.get(rowNode);
			nextBd = Ext.get(row).down(this.rowBodyTrSelector);
			record = thisGrid.view.getRecord(rowNode);
			if (!row.hasCls(this.rowCollapsedCls)) {
				row.addCls(this.rowCollapsedCls);
				nextBd.addCls(this.rowBodyHiddenCls);
				this.recordsExpanded[record.internalId] = false;
				thisGrid.view.fireEvent('collapsebody', rowNode, record, nextBd.dom);
			}
		}
		this.getMain().doLayout();
	},
	showAllPreUsers : function(obj)
	{
		if (obj.isModified == "false")
		{
			obj.setText(intnlLabel10);
			obj.isModified = "true";
		}
		else
		{
			obj.setText(intnlLabel11);
			obj.isModified = "false";
		}
		var thisGrid = Ext.getCmp('userdefinedgroupedsummarygrid').getStore();
		if (this.isViewExpaned2 == false)
		{
			this.isViewExpaned2 = true;
			for (var i = 0;i<thisGrid.getCount();i++)
			{
				var roleName = thisGrid.getAt(i).get("userRoleCategory");
				var hasUsers = thisGrid.getAt(i).get("hasUsers");
				if (hasUsers != null &&  hasUsers != 'undefined' && hasUsers)
				{
					this.expandRow(i,Ext.getCmp('userdefinedgroupedsummarygrid'));
				}
			}
		}
		else
		{
			this.isViewExpaned2 = false;
			for (var i = 0;i<thisGrid.getCount();i++)
			{
				this.collapseRow(i,Ext.getCmp('userdefinedgroupedsummarygrid'));
			}
		}
		this.getMain().doLayout();
	},
	showAllUsers : function(obj)
	{
		var thisGrid = Ext.getCmp('userrolesgroupedsummarygrid').getStore();
		if (obj.isChanged == "false")
		{
			obj.setText(intnlLabel10);
			obj.isChanged = "true";
		}
		else
		{
			obj.setText(intnlLabel11);
			obj.isChanged = "false";
		}
		if (this.isViewExpaned == false)
		{
			this.isViewExpaned = true;
			for (var i = 0;i<thisGrid.getCount();i++)
			{
				var roleName = thisGrid.getAt(i).get("userRoleCategory");
				var hasUsers = thisGrid.getAt(i).get("hasUsers");
				if (hasUsers != null &&  hasUsers != 'undefined' && hasUsers)
				{
					this.expandRow(i,Ext.getCmp('userrolesgroupedsummarygrid'));
				}
			}
		}
		else
		{
			this.isViewExpaned = false;
			for (var i = 0;i<thisGrid.getCount();i++)
			{
				this.collapseRow(i,Ext.getCmp('userrolesgroupedsummarygrid'));
			}
		}
		this.getMain().doLayout();
	},
	expandRow: function(rowIdx,thisGrid) {
		var rowNode = thisGrid.view.getNode(rowIdx);
		row = Ext.get(rowNode);
		nextBd = Ext.get(row).down(this.rowBodyTrSelector);
		record = thisGrid.view.getRecord(rowNode);
		if (row.hasCls(this.rowCollapsedCls)) {
			row.removeCls(this.rowCollapsedCls);
			nextBd.removeCls(this.rowBodyHiddenCls);
			this.recordsExpanded[record.internalId] = true;
			thisGrid.view.fireEvent('expandbody', rowNode, record, nextBd.dom);
		}
	},
	collapseRow: function(rowIdx,thisGrid) {
		var rowNode = thisGrid.view.getNode(rowIdx);
		row = Ext.get(rowNode);
		nextBd = Ext.get(row).down(this.rowBodyTrSelector);
		record = thisGrid.view.getRecord(rowNode);
		if (!row.hasCls(this.rowCollapsedCls)) {
			row.addCls(this.rowCollapsedCls);
			nextBd.addCls(this.rowBodyHiddenCls);
			this.recordsExpanded[record.internalId] = false;
			thisGrid.view.fireEvent('collapsebody', rowNode, record, nextBd.dom);
		}
	},
	showActions: function(view, task, node, rowIndex, e) {
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		/* Ext.each(icons, function(icon){
			Ext.get(icon).removeCls('x-hidden');
		}); */
	},
	hideActions: function(view, task, node, rowIndex, e) {
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		/* Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		}); */
	},
	showActionsOnIME: function(view, record, node, rowIndex, e) {
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		var countImage = 0;
		Ext.each(icons, function(icon){
			//Ext.get(icon).removeCls('x-hidden');
			if (parseInt(countImage) == 1)
			{
				var usertype = record.get('userRoleCategory');
				var users = publicJSON[usertype];
				if (users != null && users != 'undefined' && !Ext.isEmpty(users))
				{
					//Ext.get(icon).addCls('x-hidden');
				}
			}
			countImage = parseInt(countImage) + 1;
		});
	},
	hideActionsOnIML: function(view, record, node, rowIndex, e) {
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			//Ext.get(icon).addCls('x-hidden');
		});
	},
	isGroupsAvailable : function(view, node, group, e, eOpts)
	{
		var users = publicJSON[group];
		if (users == null ||  users == 'undefined' || Ext.isEmpty(users))
		{
			var thisGrid = Ext.getCmp('userdefinedgroupedsummarygrid');
			var groupingFeature = thisGrid.view.getFeature('userRoleGrouping');
			groupingFeature.collapse(group,true);
		}
	},
	isUserGroupsAvailable : function(view, node, group, e, eOpts)
	{
		var users = publicJSON[group];
		if (users == null ||  users == 'undefined' || Ext.isEmpty(users))
		{
			var thisGrid = Ext.getCmp('userrolesgroupedsummarygrid');
			var groupingFeature = thisGrid.view.getFeature('eGUserRoleGrouping');
			groupingFeature.collapse(group,true);
		}
	},
	historyBack : function()
	{
		window.location.href = "/final/admin/EgViewRoles.jsp?reqfrom=navlink";
	},
	goToUserAddPage : function()
	{
		window.location.href = "/final/admin/EgAddUser.jsp?qctr=0&fromPage=EgViewRoles.jsp";
	},
	componentAccessController : function(obj)
	{
		var me = this;
		var selectedOption = obj.getValue().notify;
		if (selectedOption == "Y")
		{
			me.limitedAccess("complete");
		}
		else
		{
			me.limitedAccess("limited");
		}
	},
	addNewUserRole : function(obj)
	{
		var me = this;
		var userRoleCreatorObj = Ext.getCmp('mainPort');

		userRoleCreatorObj.removeAll();
		userRoleCreatorObj.add({
			xtype : 'adduserrole'
		});

		var tmpURL = "EgViewRoles/data/EgUserRolesJson.jsp";
		me.updateRoleConfigs(tmpURL);
		me.initRoleConfigs();
		me.limitedAccess(publicJSON['compaccess']);
		var modulesObj = Ext.getCmp('modules');
		modulesObj.getStore().loadRawData(publicJSON['modulesArr']);
		modulesObj.setValue(publicJSON['selectedModuleName']);
		this.getAdduserrole().doLayout();
		
	},
	modifyUserRole : function(roleID)
	{
		var me = this;
		var activeTab = Ext.getCmp('userrolecontainer').getActiveTab().itemId;
		var userRoleCreatorObj = Ext.getCmp('mainPort');
		userRoleCreatorObj.removeAll();
		userRoleCreatorObj.add({xtype : 'adduserrole'});
		var tmpURL = "EgViewRoles/data/EgUserRolesJson.jsp?pageURI=adduserrole&modrole="+encodeURIComponent(roleID)+"&com.eg.CSRF_NONCE="+csrfToken;
		me.updateRoleConfigs(tmpURL);
		me.initRoleConfigs();
		me.limitedAccess(publicJSON['compaccess']);
		var modulesObj = Ext.getCmp('modules');
		var tmpRoleID = Ext.getCmp('roleName');
		tmpRoleID.setValue(roleID);
		tmpRoleID.setReadOnly(true);
		var hasallcompaccess = publicJSON['hasallcompaccess'];
		var accessGroupObj = Ext.getCmp('accessGroup');
		var accessCompleteObj = Ext.getCmp('accessComplete');
		var accessLimitedObj = Ext.getCmp('accessLimited');
		if (hasallcompaccess == true)
		{
			accessCompleteObj.setValue(true);
		}
		else
		{
			accessLimitedObj.setValue(true);
		}
		modulesObj.getStore().loadRawData(publicJSON['modulesArr']);
		modulesObj.setValue(publicJSON['selectedModuleName']);
		
		if(activeTab == 'tab1')
		{
			Ext.getCmp('roleName').disable();
			Ext.getCmp('accessGroup').disable();
			Ext.getCmp('modules').disable();
			Ext.getCmp('rolesContainer').disable();
			Ext.getCmp('updateRole').hide();
			Ext.getCmp('checkall_admin').hide();
			Ext.getCmp('checkall_monitor').hide();
			Ext.getCmp('checkall_reporter').hide();
			Ext.getCmp('checkall_config').hide();
		}
	},
	deleteUserRole : function(role)
	{
		var me = this;
		Ext.MessageBox.confirm({
			title : 'Confirm',
			msg: validationMsg9.substring(0,validationMsg9.length-1)+" '"+role+ "'?",
			icon : 'iconConfirmation',
			width : 400,
			buttons: Ext.Msg.YESNO,
			fn : function(btn){
				if (btn == "yes")
				{
					Ext.Ajax.request({
						url : 'EgViewRoles/data/EgViewRolesJson.jsp?appendQuery=no&delrole='+encodeURIComponent(role),
						method: 'POST',
						async: false,
						success: function(response)
						{
							var tmpJosnData = Ext.decode(response.responseText);
							var queryStatus = tmpJosnData.requestStatus;
							if (queryStatus == "success")
							{
								var resultObj = tmpJosnData.result;
								Ext.Msg.show({
									title: resultObj.title,
									msg: resultObj.message1,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}
							else
							{
								var resultObj = tmpJosnData.errors;
								var message = resultObj.message1;
								if (resultObj.message2 != undefined)
								{
									message = message + resultObj.message2;
								}
								Ext.Msg.show({
									title: resultObj.title,
									msg: message,
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
							}

							var tmp = "EgViewRoles/data/EgViewRolesJson.jsp";
							me.updateRoleConfigs(tmp);

							var userdefinedgroupedsummarygridObj = Ext.getCmp('userdefinedgroupedsummarygrid');
							if (publicJSON['isUserDefinedRolesAvailable'] == true)
							{
								me.getUserSearchBox().setDisabled(false);
								userdefinedgroupedsummarygridObj.getStore().loadRawData(publicJSON['groupedRolesArray2']);
								if (publicJSON.isUsersAssociatedWithCustomRoles == false)
								{
									userdefinedgroupedsummarygridObj.columns[0].hide();
									Ext.getCmp('showAll').setDisabled(true);
								}
								else
								{
									userdefinedgroupedsummarygridObj.columns[0].show();
									Ext.getCmp('showAll').setDisabled(false);
								}
							}
							else
							{
								userdefinedgroupedsummarygridObj.getStore().loadRawData(publicJSON['groupedRolesArray2']);
								me.getUserSearchBox().setDisabled(true);
								Ext.getCmp('showAll').setDisabled(true);
							}
							delete userdefinedgroupedsummarygridObj;
						}
					});
				}
			}
		});
	},
	deleteRole : function(role,checkboxObj,from)
	{
		var me = this;
		Ext.MessageBox.confirm({
			title : 'Confirm',
			msg: validationMsg9+" '"+role+ "'?",
			icon : 'iconConfirmation',
			buttons: Ext.Msg.YESNO,
			width : 300,
			fn : function(btn){
				if (btn == "yes")
				{
					Ext.Ajax.request({
						url : 'EgViewRoles/data/EgViewRolesJson.jsp?appendQuery=no&delrole='+encodeURIComponent(role),
						method: 'POST',
						async: false,
						success: function(response)
						{
							var tmpJosnData = Ext.decode(response.responseText);
							//me.showResultQWindow(jsonText);
							var queryStatus = tmpJosnData.requestStatus;
							if (queryStatus == "success")
							{
								var resultObj = tmpJosnData.result;
								Ext.Msg.show({
									title: resultObj.title,
									msg: resultObj.message1,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}
							else
							{
								var resultObj = tmpJosnData.errors;
								var message = resultObj.message1;
								if (resultObj.message2 != undefined)
								{
									message = message + resultObj.message2;
								}
								Ext.Msg.show({
									title: resultObj.title,
									msg: message,
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
							}

							var tmp = "EgViewRoles/data/EgViewRolesJson.jsp";
							me.updateRoleConfigs(tmp);
							var userdatagridObj = Ext.getCmp('userdefinedgroupedsummarygrid');
							var eGRoleContainerObj = Ext.getCmp('eGRoleContainer2');
							eGRoleContainerObj.add({xtype: 'userdefinedgroupedsummarygrid'});
						}
					});
				}
				else
				{
					checkboxObj.setChecked(false,false);
				}
			}
		});
	},
	updateRoleConfigs : function(urlStr)
	{
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	initRoleConfigs : function()
	{
		var me =this;
		var thinClientVal = '';
		var adduserroleObj = Ext.getCmp('adduserrole');
		var rolesContainerObj = Ext.getCmp('rolesContainer');
		var arr_modulesArr = publicJSON['arr_modules'];
		var displayNames = publicJSON['displayNames'];
		var isReporterSupported = publicJSON['isReporterSupported'];
		var isConfigSupported = publicJSON['isConfigSupported'];
		var itemsArray = new Array();
		for (var key in arr_modulesArr)
		{
			var moduleName = arr_modulesArr[key];
			var moduleDisplayName = displayNames[key];

			if (moduleDisplayName == "Reporter" && isReporterSupported == false)
				continue;
			if (moduleDisplayName == "Configuration" && isConfigSupported == false)
				continue;

			var isModuleChecked = publicJSON["checkall_"+moduleName.toLowerCase()];
			var attributesArr = publicJSON[moduleName];
			var checkboxChildItems = new Array();
			for (var key1 in attributesArr)
			{
				var tmpObj = attributesArr[key1];
				var name = tmpObj[0];
				var value = tmpObj[1];
				var isChecked = tmpObj[2];
				var dispName = tmpObj[3];
				if (!Ext.isEmpty(name) && name.toLowerCase() == 'config' && !Ext.isEmpty(dispName) && dispName.toLowerCase() == 'thin client')
				{
					var thinClientVal = {
						xtype : 'checkboxfield',
						boxLabel : dispName,
						labelAlign: 'top',
						name : name,
						inputValue : value,
						hidden: true,
						moduleName : 'checkall_'+moduleName.toLowerCase(),
						groupID : 'group_'+moduleName.toLowerCase(),
						checked : true, // unused bit so making it checked
						listeners : {
							click : {
								element : 'el',
								fn : function(id)
								{
									me.selectAny(Ext.getCmp(this.id),"handler");
								}
							}
						}
					};
				}
				else
				{
					var tmpBox = {
						xtype : 'checkboxfield',
						boxLabel : dispName,
						labelAlign: 'top',
						name : name,
						inputValue : value,
						moduleName : 'checkall_'+moduleName.toLowerCase(),
						groupID : 'group_'+moduleName.toLowerCase(),
						checked : ((isChecked.toLowerCase() == "checked")?true:false),
						listeners : {
							click : {
								element : 'el',
								fn : function(id)
								{
									me.selectAny(Ext.getCmp(this.id),"handler");
								}
							}
						}
						//handler : function(obj)
						//{
						//	me.selectAny(obj,"handler");
						//}
					}
					checkboxChildItems.push(tmpBox);
				}
			}
			if (!Ext.isEmpty(moduleName) && moduleName.toLowerCase() == 'config' && !Ext.isEmpty(thinClientVal))
			{
				checkboxChildItems.push(thinClientVal);
			}
			var tmpModule = moduleName;
			var tmpPanel = {
				xtype: 'fieldset',
					layout : {
					type : 'vbox',
					align : 'left'
				},
				//id:'my_fuieldset',
				width : '85%',
				title : moduleDisplayName.toUpperCase(),
				items : [
					{
						xtype: 'checkboxfield',
						boxLabel: 'Select All',
						margin: '0 0 10 5',
						cls: 'checkbt',
						name : 'checkall_'+moduleName.toLowerCase(),
						id : 'checkall_'+moduleName.toLowerCase(),
						inputValue : moduleName.toLowerCase(),
						checked : ((isModuleChecked.toLowerCase() == "checked")?true:false),
						listeners : {
							click : {
								element : 'el',
								fn : function(id)
								{
									me.selectAll(Ext.getCmp(this.id));
								}
							}
						}
						//handler : function(obj)
						//{
						//	me.selectAll(obj);
						//}
					},
					{
						xtype : 'checkboxgroup',
						width: '100%',
						id : "group_"+moduleName.toLowerCase(),
						columns : 3,
						cls: 'checkbt',
						margin: '0 0 0 20',
						items : checkboxChildItems
					}
				]
			}
			itemsArray.push(tmpPanel);
		}
		Ext.suspendLayouts();
		rolesContainerObj.add(itemsArray);
		Ext.resumeLayouts(true);
	},
	
	checkCompMgmt : function(obj)
	{
		if (obj.getValue())
		{
			var grpLen = Ext.getCmp("group_admin").items.length;
			var checkGroup = Ext.getCmp("group_admin");
			for(var j=0;j<grpLen;j++)
			{
				var tmpCheckboxObj = checkGroup.items.items[j];
				var boxLabel = tmpCheckboxObj.boxLabel;
				if(boxLabel == 'External/Remote Agent Configuration')
				{
					if(tmpCheckboxObj.isDisabled() == false)
						tmpCheckboxObj.setValue(true);
				}
				tmpCheckboxObj.resumeEvents();
			}
		}
	},

	uncheckCompMgmt : function(obj)
	{
		if (!obj.getValue())
		{
			var grpLen = Ext.getCmp("group_admin").items.length;
			var checkGroup = Ext.getCmp("group_admin");
			for(var j=0;j<grpLen;j++)
			{
				var tmpCheckboxObj = checkGroup.items.items[j];
				var boxLabel = tmpCheckboxObj.boxLabel;
				if(boxLabel == 'Component Management')
				{
					if(tmpCheckboxObj.isDisabled() == false)
						tmpCheckboxObj.setValue(false);
				}
				tmpCheckboxObj.resumeEvents();
			}
		}
	},

	selectAny : function(obj,fromSet)
	{
		if (obj.getValue())
		{
			var boxes = Ext.getCmp(obj.groupID).getBoxes(),b,bLen  = boxes.length,isAllChecked = true;
			for (b = 0; b < bLen; b++) {

				if (!boxes[b].isDisabled()) {
					if (!boxes[b].getValue())
					{
						isAllChecked = false;
					}
				}
			}
			if (isAllChecked)
			{
				Ext.getCmp(obj.moduleName).setValue(true);
			}
		}
		else
		{
			Ext.getCmp(obj.moduleName).setValue(false);
		}
	},
	isSelectedAll : function(name)
	{
		var me = this;
		var grpLen = Ext.getCmp("group_"+name).items.length;
		var checkGroup = Ext.getCmp("group_"+name);
		for(var j=0;j<grpLen;j++)
		{
			var tmpCheckboxObj = checkGroup.items.items[j];

			if(tmpCheckboxObj.isDisabled() == true)
					continue;

			if(tmpCheckboxObj.getValue() == false)
					return false;
		}
		return true;
	},
	selectAll : function(obj)
	{
		var name = obj.inputValue.toLowerCase();
		var moduleName = obj.inputValue;
		var me = this;
		var chk = obj.getValue();
		var grpLen = Ext.getCmp("group_"+moduleName).items.length;
		var checkGroup = Ext.getCmp("group_"+moduleName);
		for(var j=0;j<grpLen;j++)
		{
			var tmpCheckboxObj = checkGroup.items.items[j];
			var boxLabel = tmpCheckboxObj.boxLabel;
			if(name == 'admin')//For Limited Role
			{
				if(tmpCheckboxObj.isDisabled() == false)
					tmpCheckboxObj.setValue(chk);
			}
			else if(name == 'config')
			{
				if (!Ext.isEmpty(boxLabel) && boxLabel.toLowerCase() == 'thin client')
				{
					tmpCheckboxObj.setValue(true);
				}
				else
				{
					tmpCheckboxObj.setValue(chk);
				}
			}
			else
				tmpCheckboxObj.setValue(chk);

			tmpCheckboxObj.resumeEvents();
		}
		me.canHaveLimtedCompAcess(name,moduleName);
		me.moveModuleButtonToDefault(name,moduleName);
	},
	moveModuleButtonToDefault : function(name,moduleName)
	{
		var selectedModule = Ext.getCmp('modules').getValue();
		if(name == selectedModule)
		{
			var grpLen = Ext.getCmp("group_"+moduleName).items.length;
			var checkGroup = Ext.getCmp("group_"+moduleName);
			var flag = true;
			for(i=0;i<grpLen;i++)
			{
				var tmpCheckboxObj = checkGroup.items.items[i];
				if(tmpCheckboxObj.getValue() == true)
				{
					flag = false;
					break;
				}
			}
			if(flag)
			{
				Ext.getCmp('modules').setValue("default")
			}
		}
	},
	canHaveLimtedCompAcess : function(group,moduleName)
	{
		var me = this;
		if(group == 'admin')
		{
			if(me.isSelectedAny(group,moduleName))
			{
				//For Limited Role
				//thisForm.notify[0].checked = true;
				//thisForm.notify[1].disabled = true;
			}
			else
			{
				Ext.getCmp('accessLimited').setDisabled(false);
			}
		}
	},
	isSelectedAny : function(group,moduleName)
	{
		var grpLen = Ext.getCmp("group_"+moduleName).items.length;
		var checkGroup = Ext.getCmp("group_"+moduleName);
		for(var j=0;j<grpLen;j++)
		{
			var tmpCheckboxObj = checkGroup.items.items[j];
			if (tmpCheckboxObj.boxLabel.toLowerCase() == 'thin client')
			{
				return false;
			}
			if(tmpCheckboxObj.getValue() == true)
				return true;
		}
		return false;
	},
	limitedAccess : function(type)
	{
		var thisForm = this.getAdduserrole().getForm();
		var grpLen = Ext.getCmp("group_admin").items.length;
		var checkGroupAdmin = Ext.getCmp("group_admin");
		var checkallAdmin = Ext.getCmp("checkall_admin");
		for(var i=0;i<grpLen;i++)
		{
			var tmpCheckboxObj = checkGroupAdmin.items.items[i];
			var selectedChkValue = tmpCheckboxObj.inputValue;
			if(type == 'limited')
			{
				//if(thisForm.admin[i].value==51539607678 || thisForm.admin[i].value==3145728 ||thisForm.admin[i].value==12582912 )
				if(selectedChkValue== 1 || selectedChkValue== 4 || selectedChkValue==32 || selectedChkValue== 256 || selectedChkValue== 512 || selectedChkValue == 65536 || selectedChkValue==64 || selectedChkValue==128 || selectedChkValue==4096 || selectedChkValue==8192 || selectedChkValue == 16384 || selectedChkValue==524288)
					tmpCheckboxObj.setDisabled(false);
				else
				{
					if(tmpCheckboxObj.getValue() == true)
						tmpCheckboxObj.setValue(false);
					tmpCheckboxObj.setDisabled(true);
				}
			}
			else
			{
				if(checkallAdmin.getValue() == true)
					tmpCheckboxObj.setValue(true);
				tmpCheckboxObj.setDisabled(false);
			}
		}
	},
	initDefaultConfigs: function()
	{
		var me = this;
		if (defaultUrl.indexOf("EgViewRolesJson") != -1)
		{

			var userdatagridObj = Ext.getCmp('userrolesgroupedsummarygrid');
			userdatagridObj.getStore().loadRawData(publicJSON['groupedRolesArray1']);

			if (publicJSON.isUsersAssociatedWitheGRoles == false)
			{
				userdatagridObj.columns[0].hide();
				Ext.getCmp('showAllUsers').setDisabled(true);
			}
			else
			{
				userdatagridObj.columns[0].show();
				Ext.getCmp('showAllUsers').setDisabled(false);
			}

			var userdefinedgroupedsummarygridObj = Ext.getCmp('userdefinedgroupedsummarygrid');
			me.getUserSearchBox().setDisabled(true);
			Ext.getCmp('showAll').setDisabled(true);
			if (publicJSON['isUserDefinedRolesAvailable'] == true)
			{
				me.getUserSearchBox().setDisabled(false);
				userdefinedgroupedsummarygridObj.getStore().loadRawData(publicJSON['groupedRolesArray2']);
				userdefinedgroupedsummarygridObj.show();
				if (publicJSON.isUsersAssociatedWithCustomRoles == false)
				{
					userdefinedgroupedsummarygridObj.columns[0].hide();
					Ext.getCmp('showAll').setDisabled(true);
				}
				else
				{
					userdefinedgroupedsummarygridObj.columns[0].show();
					Ext.getCmp('showAll').setDisabled(false);
				}
			}
			else
			{
				userdefinedgroupedsummarygridObj.columns[0].hide();
			}

			if (sessionStorage.getItem('selectedTabItem') != undefined && sessionStorage.getItem('selectedTabItem') == 'tab2')
			{
				Ext.getCmp('userrolecontainer').setActiveTab(1);
				sessionStorage.setItem("selectedTabItem","tab2");
			}
			else
			{
				Ext.getCmp('userrolecontainer').setActiveTab(0);
				sessionStorage.setItem("selectedTabItem","tab1");
			}

			delete userdatagridObj;
			delete userdefinedgroupedsummarygridObj;
		}
		else
		{
			var userRoleCreatorObj = Ext.getCmp('mainPort');
			userRoleCreatorObj.removeAll();
			userRoleCreatorObj.add({xtype : 'adduserrole'})
			me.initRoleConfigs();
			me.limitedAccess(publicJSON['compaccess']);
			var modulesObj = Ext.getCmp('modules');
			var roleNameObj = Ext.getCmp('roleName');
			roleNameObj.setValue(tmpRoleID);
			if (publicJSON['commandExe'] != null && publicJSON['commandExe'] != undefined && publicJSON['commandExe'] == "update")
			{
				roleNameObj.setReadOnly(true);
			}
			modulesObj.getStore().loadRawData(publicJSON['modulesArr']);
			modulesObj.setValue(publicJSON['selectedModuleName']);
			var hasallcompaccess = publicJSON['hasallcompaccess'];
			if (hasallcompaccess == true)
			{
				Ext.getCmp('accessComplete').setValue(true);
			}
			else
			{
				Ext.getCmp('accessLimited').setValue(true);
			}
			if(sessionStorage.getItem('selectedTabItem') == 'tab1')
			{
				Ext.getCmp('roleName').disable();
				Ext.getCmp('accessGroup').disable();
				Ext.getCmp('modules').disable();
				Ext.getCmp('rolesContainer').disable();
				Ext.getCmp('updateRole').hide();
				Ext.getCmp('checkall_admin').hide();
				Ext.getCmp('checkall_monitor').hide();
				Ext.getCmp('checkall_reporter').hide();
				Ext.getCmp('checkall_config').hide();
			}
			delete userRoleCreatorObj;
			delete modulesObj;
			delete roleNameObj;
		}
	},
	loadAvailableRoles : function()
	{
		var userRoleCreatorObj = Ext.getCmp('mainPort');
		userRoleCreatorObj.removeAll();
		userRoleCreatorObj.add({xtype : 'main'})

		var userdatagridObj = Ext.getCmp('userrolesgroupedsummarygrid');
		userdatagridObj.getStore().loadRawData(publicJSON['groupedRolesArray1']);
		if (publicJSON.isUsersAssociatedWitheGRoles == false)
		{
			userdatagridObj.columns[0].hide();
			Ext.getCmp('showAllUsers').setDisabled(true);
		}
		else
		{
			userdatagridObj.columns[0].show();
			Ext.getCmp('showAllUsers').setDisabled(false);
		}

		var userdefinedgroupedsummarygridObj = Ext.getCmp('userdefinedgroupedsummarygrid');
		this.getUserSearchBox().setDisabled(true);
		if (publicJSON['isUserDefinedRolesAvailable'] == true)
		{
			this.getUserSearchBox().setDisabled(false);
			userdefinedgroupedsummarygridObj.getStore().loadRawData(publicJSON['groupedRolesArray2']);
			userdefinedgroupedsummarygridObj.show();
			if (publicJSON.isUsersAssociatedWithCustomRoles == false)
			{
				userdefinedgroupedsummarygridObj.columns[0].hide();
				Ext.getCmp('showAll').setDisabled(true);
			}
			else
			{
				userdefinedgroupedsummarygridObj.columns[0].show();
				Ext.getCmp('showAll').setDisabled(false);
			}
		}
		else
		{
			userdefinedgroupedsummarygridObj.columns[0].hide();
		}
		var userrolecontainerOnj = Ext.getCmp('userrolecontainer');
		userrolecontainerOnj.setActiveTab(1);
		sessionStorage.setItem("selectedTabItem","tab2");
		delete userRoleCreatorObj;
		delete userdatagridObj;
		delete userdefinedgroupedsummarygridObj;
		delete userrolecontainerOnj;
	},
	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			if (key == "vsTypes")
			{
				continue;
			}
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	getErrorMessageTemplate :function(tmpObj)
	{
		var tmpTable = '<div class="x-table" style="padding-left:10px;text-align:center;width:100%"><table cellspacing="0" width="90%" cellpadding="5" border="0" align="center" class="x-grid-table x-grid-table-resizer"><thead><tr class="x-grid-row"><th class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">Error</div></td></tr></thead>'
		for (var key in tmpObj)
		{
			if (key == "title") continue ;
			var errorMessage = tmpObj[key];
			tmpTable = tmpTable + '<tr class="x-grid-row"><td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner" >'+errorMessage+'</div></td></tr>';
		}
		tmpTable = tmpTable + '</table></div>';
		return tmpTable;
	},
	submitUserDetails : function(obj)
	{
		var me = this;
		var validationStatus = me.validateRoleForm();
		if (validationStatus == true)
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			var hiddenFields = this.getHiddenFields(publicJSON['hiddenFields']);
			var tmpURL = "EgViewRoles/data/EguserrolespJson.jsp?"+hiddenFields;
			var userForm = this.getAdduserrole().getForm();
			if (userForm.isValid())
			{
				this.getAdduserrole().submit({
					url: tmpURL,
					method: 'POST',
					success: function(form, action){
						myMask.hide();
						var tmpJosnData = Ext.decode(action.response.responseText);
						var queryStatus = tmpJosnData.requestStatus;
						if (queryStatus == "success")
						{
							var resultObj = tmpJosnData.result;
							Ext.Msg.show({
								title: resultObj.title,
								msg: resultObj.message1,
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconInformation',
								fn : function(btn){
									if (btn == "ok")
									{
										defaultUrl = "EgViewRoles/data/EgViewRolesJson.jsp";
										me.updateRoleConfigs('EgViewRoles/data/EgViewRolesJson.jsp?reqfrom=navlink');
										me.loadAvailableRoles();
									}
								}
							});
						}
						else
						{
							var resultObj = tmpJosnData.errors;
							var tmp = me.getErrorMessageTemplate(resultObj);
							var message = resultObj.message1;
							if (resultObj.message2 != undefined)
							{
								message = message + resultObj.message2;
							}
							Ext.Msg.show({
								title: resultObj.title,
								msg: message,
								buttons: Ext.Msg.OK,
								icon: 'iconError'
							});
						}
						//me.showResultQWindow(action.response.responseText);
						//me.viewUserRoles();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: "Could not update role details",
							buttons: Ext.Msg.OK,
							icon: 'iconError'
						});
						myMask.hide();
					}
				});
			}
		}
	},
	viewUserRoles : function()
	{
		var me = this;
		var historyBack = Ext.getCmp('back');
		var useraddObj= Ext.getCmp('useradd');
		var roleObj= Ext.getCmp('role');
		var userRoleCreatorObj = Ext.getCmp('main');
		defaultUrl = "EgViewRoles/data/EgViewRolesJson.jsp";

		var tmpURL = "EgViewRoles/data/EgViewRolesJson.jsp";
		me.updateRoleConfigs(tmpURL);

		userRoleCreatorObj.remove(Ext.getCmp('adduserrole'));
		userRoleCreatorObj.add({xtype : 'userrolecontainer'})
		historyBack.hide();
		roleObj.setDisabled(false);
		useraddObj.setDisabled(false);
	},
	showResultQWindow : function(resultText)
	{
		var resultJsonObj = Ext.decode(resultText);
		var requestStatus = resultJsonObj['requestStatus'];
		var title = '';
		if (requestStatus == "success")
		{
			var resultObj = resultJsonObj['result'];
			title = resultObj.title;
		}
		else
		{
			var resultObj = resultJsonObj['errors'];
			title = resultObj.title;
		}
		Ext.widget('window', {
			title: title,
			closeAction: 'destory',
			width: 600,
			height: 300,
			scroll: true,
			autoScroll: true,
			doClose: function() {
				resultJsonObj = '';
				this.destroy();
			},
			html: resultText
		}).show()
	},
	validateRoleForm : function()
	{
		var me = this;
		var rolName = true;
		var roleName = Ext.getCmp('roleName');
		if(isDoubleByteEnabled == "false")
		{
			rolName = validateSingleByte(roleName.getValue());
		}
		if(!checkblank(roleName.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: validationMsg1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					if (btn == 'ok'){
						roleName.focus(true);
					}
				}
			});
			return false;
		}
		else if(!checkspecial(roleName.getValue(),"`~!@#$%^&*()+={}[]|\\:;\"\'<>,.?\/"))
		{
			roleName.focus(true);
			return false;
		}
		else if(!checkspace(roleName.getValue()))
		{
			roleName.focus(true);
			return false;
		}
		else if(roleName.getValue().toUpperCase() == "ADMIN" || roleName.getValue().toUpperCase() == "SUPERMONITOR"
		|| roleName.getValue().toUpperCase() == "MONITOR" || roleName.getValue().toUpperCase() == "ALARMVIEWER" || roleName.getValue().toUpperCase() == "SERVERADMIN" || roleName.getValue().toUpperCase() == "SUPERALARMVIEWER")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: validationMsg2+" "+roleName.getValue() + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					if (btn == 'ok'){
						roleName.focus(true);
					}
				}
			});
			return false;
		}
		else if(!rolName)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: validationMsg3 + ".",
				buttons: Ext.Msg.OK,
				width : 500,
				icon: 'iconExclamation',
				fn : function(btn){
					if (btn == 'ok'){
						roleName.focus(true);
					}
				}
			});
			return false;
		}
		else if(!me.hasAnyPermission())
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: validationMsg4 + ".",
				width : 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if (!me.checkModuleRoles())
		{
			return false;
		}
		return true;
	},
	hasAnyPermission : function()
	{
		var me = this;
		var isReporterSupported = publicJSON['isReporterSupported'];
		var isConfigSupported = publicJSON['isConfigSupported'];

		var flag = me.isSelectedAny('admin','admin') || me.isSelectedAny('monitor','monitor');
		if(isReporterSupported == true)
		{
			flag =  flag || me.isSelectedAny('reporter','reporter');
		}

		/* uncomment the below code if the config mgmt enabled*/
		if(isConfigSupported == true)
		{
			flag = flag || me.isSelectedAny('config','config');
		}
		return flag;
	},
	checkModuleRoles : function()
	{
		var tmpName;
		var moduleName = Ext.getCmp('modules').getValue();
		if(moduleName != "default")
		{
			var flag = Ext.getCmp("checkall_"+moduleName).getValue();
			var grpLen = Ext.getCmp("group_"+moduleName).items.length;
			var checkGroup = Ext.getCmp("group_"+moduleName);
			if(flag != null && flag != true)
			{
				for(i=0;i<grpLen;i++)
				{
					var tmpCheckboxObj = checkGroup.items.items[i];
					if (tmpCheckboxObj.boxLabel.toLowerCase() == 'thin client')
					{
						continue;
					}
					if(tmpCheckboxObj.getValue() == true)
					{
						flag = true;
						break;
					}
				}
			}
			if(flag != null && flag == false)
			{
				if(moduleName == "admin")
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: validationMsg5 + ".",
						width : 400,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
				else if(moduleName == "monitor")
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: validationMsg6 + ".",
						width : 400,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
				else if(moduleName == "reporter")
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: validationMsg7 + ".",
						width : 400,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
				else if(moduleName == "config")
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: validationMsg8 + ".",
						width : 500,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}
		}
		return true;
	},
	onTriggerChange : function(obj)
	{
		 this.searchUserRole(obj.getValue(),"search1",obj);
	},
	onTriggerChange1 : function(obj)
	{
		 this.searchUserRole(obj.getValue(),"search2",obj);
	},
	searchUserRole : function(value,frm,obj)
	{
		var me = this;
		if (value == "" || value.length == 0)
		{
			Ext.get(obj.getId()+'_0').setStyle('display','none');
			Ext.get(obj.getId()+'_1').setStyle('display','block');
		}
		else
		{
			Ext.get(obj.getId()+'_1').setStyle('display','none');
			Ext.get(obj.getId()+'_0').setStyle('display','block');
		}

		var selectedTab = Ext.getCmp('userrolecontainer').getActiveTab().itemId;
		var storeKey;
		var userGridObj;
		if (selectedTab == "tab1")
		{
			storeKey = 'groupedRolesArray1';
			userGridObj = Ext.getCmp('userrolesgroupedsummarygrid');
		}
		else
		{
			storeKey = 'groupedRolesArray2';
			userGridObj = Ext.getCmp('userdefinedgroupedsummarygrid');
		}

		var strURI = "EgViewRoles/data/EgViewRolesJson.jsp?egTitleSearchStr="+encodeURI(value)+"&appendQuery=no&selectedTab="+selectedTab+"&date="+new Date().getTime();
		me.updateRoleConfigs(strURI);

		//if (publicJSON.searchFound == true)
		{
			if (selectedTab == "tab1")
			{
				userGridObj.getStore().loadRawData(publicJSON[storeKey]);
				if (publicJSON.isUsersAssociatedWitheGRoles == false)
				{
					userGridObj.columns[0].hide();
					Ext.getCmp('showAllUsers').setDisabled(true);
				}
				else
				{
					userGridObj.columns[0].show();
					Ext.getCmp('showAllUsers').setDisabled(false);
				}
			}
			else
			{
				userGridObj.getStore().loadRawData(publicJSON[storeKey]);
				if (Ext.isEmpty(publicJSON[storeKey]))
				{
					Ext.get('userDeferMessage2').update(validationMsg10);
				}

				if (publicJSON.isUsersAssociatedWithCustomRoles == false)
				{
					userGridObj.columns[0].hide();
					Ext.getCmp('showAll').setDisabled(true);
				}
				else
				{
					userGridObj.columns[0].show();
					Ext.getCmp('showAll').setDisabled(false);
				}
			}
		}
		delete storeKey;
		delete userGridObj;
	}
});




